# README: Source Data for  Ion Sensing based on Frequency-Dependent Physico-Chemical Processes at Electrode/Electrolyte Interfaces

## Overview
This repository contains the source data and analysis files for the manuscript "[Paper Title]". The dataset includes:  

1. **Electrochemical impedance spectroscopy (EIS) raw data** measured under different ion compositions and temperatures.  
2. **Machine learning cross-validation results**, including prediction outputs for different random seeds and folds.  
3. **MATLAB code** used for data processing and figure generation.  

The dataset is structured to support reproducibility of all figures and results presented in the manuscript.

---

## Repository Structure
```
Source Data/
│
│
├── EIS_dataset_clean/   # Raw experimental EIS data (.opt files)
│
├── NaF raw data/   # Raw experimental EIS data (.txt and .mat files)
│
├── Result for repeated CV/                           # Machine learning cross-validation results
│   ├── seed0/                                        # Random seed 0
│   │   ├── fold0/ ... fold4/                         # Individual folds
│   │   │   ├── train_true_pred.csv                   # Training set true vs. predicted
│   │   │   └── test_true_pred.csv                    # Test set true vs. predicted
│   │   └── r2_summary.json                           # Fold-wise R² summary
│   ├── seed1/ ... seedN/                             # Same structure for other seeds
│   └── dataprocessing.m                              # MATLAB script for analysis/visualization
│
│
├── Sensitivity and Temperature dependency dataset/   # Raw experimental EIS data (.mpt files)
│
└── README.md                                         # This file
```

---

## File Descriptions

### 1. EIS_dataset_clean
- **File type:** `.mpt` (BioLogic EC-Lab format)  
- **Content:** Raw EIS spectra recorded for different metal ion solutions (e.g., Zn²⁺, Cd²⁺) at varying concentrations and composition.  
- **File naming convention:**  
  ```
  [SampleID]_[Date]_[Electrolyte]_[Concentration]_[SetupInfo]_PEIS_C01.mpt
  ```
  Example:  
  ```
  0020_KWR_20250708_(20250708)_ZnSO4_5mmolL_CdSO4_5mmolL_MQ_m1a_ID5A_NoRef_02_PEIS_C01.mpt
  ```
  - `ZnSO4_5mmolL_CdSO4_5mmolL` → Electrolyte composition  
  - `MQ` → MilliQ water used as solvent  
  - `NoRef` → Two-electrode setup without reference electrode  
  - `PEIS` → Potentiostatic EIS measurement  

**Parameters in .mpt files include:**  
- Frequency (Hz)  
- Real part of impedance (Re(Z), Ohm)  
- Imaginary part of impedance (Im(Z), Ohm)  
- Phase angle (°)  
- Applied potential (V)  

---

### 1. NaF data raw
- **File type:** `.txt`  
- **Content:** Raw EIS spectra recorded for NaF solutions  at varying potential.

**Parameters in .mpt files include:**  
- Frequency (Hz)  
- Real part of impedance (Re(Z), Ohm)  
- Imaginary part of impedance (Im(Z), Ohm)  
- Phase angle (°)  
- Applied potential (V)  

---

### 3. Result for repeated CV
Contains results of repeated cross-validation runs for machine learning models trained to predict ion concentration/composition from EIS data.

- **train_true_pred.csv** – True vs. predicted values for training data in a given fold.  
- **test_true_pred.csv** – True vs. predicted values for test data in a given fold.  
- **r2_summary.json** – Fold-level performance metrics (R² values).  
- **dataprocessing.m** – MATLAB script to aggregate and visualize results across seeds and folds.  

---

## Codes and Symbols
- **Ion notation:**  
  - Zn²⁺ = Zinc ion  
  - Cd²⁺ = Cadmium ion  
  - Pb²⁺ = Lead ion  
  - Na⁺, Cl⁻ = Sodium, chloride ions  

- **Concentration units:** `mmolL` = millimoles per liter (mM)  
- **Temperature suffix in filenames:** e.g., `27p5C` = 27.5 °C  

---

### 4. Sensitivity and Temperature dependency dataset
- **File type:** `.mpt` (BioLogic EC-Lab format)  
- **Content:** Raw EIS spectra recorded for different metal ion solutions (e.g., Zn²⁺, Cd²⁺) at varying concentrations and temperatures.  
- **File naming convention:**  
  ```
  [SampleID]_[Date]_[Electrolyte]_[Concentration]_[SetupInfo]_PEIS_C01.mpt
  ```
  Example:  
  ```
  0020_KWR_20250708_(20250708)_ZnSO4_5mmolL_CdSO4_5mmolL_MQ_m1a_ID5A_NoRef_02_PEIS_C01.mpt
  ```
  - `ZnSO4_5mmolL_CdSO4_5mmolL` → Electrolyte composition  
  - `MQ` → MilliQ water used as solvent  
  - `NoRef` → Two-electrode setup without reference electrode  
  - `PEIS` → Potentiostatic EIS measurement  

**Parameters in .mpt files include:**  
- Frequency (Hz)  
- Real part of impedance (Re(Z), Ohm)  
- Imaginary part of impedance (Im(Z), Ohm)  
- Phase angle (°)  
- Applied potential (V)  

---

## Software Requirements
- **EIS data (.mpt)**: Open using **EC-Lab software** (BioLogic) or ASCII export.  
- **Cross-validation results (.csv, .json)**: Open with any text editor, Excel, or Python/MATLAB.  
- **MATLAB code**: Tested with MATLAB R2023a.  

---

