from numpy import genfromtxt
from scipy import stats
from scipy.stats import mstats

# This file calculates the Point-Biserial Correlation Coefficient with its corresponding P-Value
# Please note! This function assumes to have one binary data variable and one continuous data variable
if __name__ == '__main__':

    # Obtain the data stored in comma seperated file
    file = open('data1.csv', encoding="utf8")
    data1 = genfromtxt(file, delimiter=',')

    # Obtain the other data also stored in comma seperated file
    file = open('data2.csv', encoding="utf8")
    data2 = genfromtxt(file, delimiter=',')

    # Use Python Scipy function to calculate Point-Biserial Correlation Coefficient
    res = stats.pointbiserialr(data1, data2)
    # Use Python Scipy function to calculate P-Value
    p_res = mstats.pearsonr(data1, data2)
    # Display Point-Biserial Correlation Coefficient and P-Value
    print("Point-Biserial Correlation Coefficient and P-Value:")
    print(res)
