%% Pure Water
%PDADMAC/PSS
BL=[2;3;4;6;7;8;9;10]; %Bilayer number
P=[19.9756002	13.33900887	11.62454027	10.46461388	9.852042327	8.986779006	8.98179632	8.344471105]; %Pure water permeability [LMH/bar]
R=[1.79932E+13	2.69454E+13	3.09195E+13	3.43467E+13	3.64823E+13	3.99949E+13	4.0017E+13	4.30734E+13]; %Hydraulic Resistance [1/m]
P_Conf=[0.517964618	0.293177849	0.311788965	0.245858136	0.349379245	0.190766598	0.203474953	0.237874123]; %95% Confidence Permeability
R_Conf=[4.66561E+11	5.92232E+11	8.29311E+11	8.0695E+11	1.29376E+12	8.4899E+11	9.06552E+11	1.22789E+12]; %95% Confidence Hydraulic Resistance

figure;
hold on;
box on;
pbaspect([1 1 1])
yyaxis left
errorbar(BL,P,P_Conf,P_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255); %'b' 
axis([0,12,0,25]);
title('PDADMAC/PSS');
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Pure Water Permeability [LMH/bar]');
yticks([5 10 15 20 25]);
yyaxis right
errorbar(BL,R,R_Conf,R_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255); %'r'
axis([0,12,0,8E13]);
ylabel('Hydraulic Resistance [1/m]');
yticks([2E13 4E13 6E13 8E13]);
ax = gca;
ax.YAxis(1).Color = 'k';
ax.YAxis(2).Color = 'k';
xticks([2 4 6 8 10]);

%PAH/PAA
BL=[3;5;7;9;10;11;12;14]; %Bilayer number
P=[3.678067869	2.502551268	1.612751816	1.185023033	0.95373694	0.76276447	0.678019523	0.567924308]; %Pure water permeability [LMH/bar]
R=[9.77211E+13	1.43623E+14	2.22864E+14	3.03306E+14	3.7686E+14	4.71214E+14	5.3011E+14	6.32875E+14]; %Hydraulic Resistance [1/m]
P_Conf=[0.153384628	0.061989371	0.024645117	0.0312861	0.035912904	0.024641462	0.020254879	0.0300837]; %95% Confidence Permeability
R_Conf=[4.07521E+12	3.55762E+12	3.40568E+12	8.00767E+12	1.41906E+13	1.52228E+13	1.58363E+13	3.35242E+13]; %95% Confidence Hydraulic Resistance

figure;
hold on;
box on;
pbaspect([1 1 1])
yyaxis left
errorbar(BL,P,P_Conf,P_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255); %'b'
axis([0,16,0,25]);
title('PAH/PAA');
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Pure Water Permeability [LMH/bar]');
yticks([5 10 15 20 25]);
yyaxis right
errorbar(BL,R,R_Conf,R_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255); %'r'
axis([0,16,0,8E14]);
ylabel('Hydraulic Resistance [1/m]');
yticks([2E14 4E14 6E14 8E14]);
ax = gca;
ax.YAxis(1).Color = 'k';
ax.YAxis(2).Color = 'k';
xticks([2 4 6 8 10 12 14]);

%% MgSO4 Retention
%PDADMAC/PSS
BL=[2;3;4;6;7;8;9;10]; %Bilayer number
Ret=[0.249570201;0.63982808;0.858538682;0.933868195;0.942655211;0.94368071;0.946840355;0.94368071];
AoverB=[2.03519E-06;8.98928E-06;3.00481E-05;6.75403E-05;7.75317E-05;7.73235E-05;8.20923E-05;7.54447E-05];
Ret_Conf=[0.022650523;0.06115009;0.027664322;0.0034249;0.002089181;0.00353115;0.001101684;0.002604671];
AoverB_Conf=[1.94735E-07;1.59317E-06;4.4053E-06;4.11329E-06;4.36422E-06;3.2673E-06;2.96508E-06;4.86089E-06];

figure;
hold on;
box on;
pbaspect([1 1 1])
yyaxis left
errorbar(BL,Ret,Ret_Conf,Ret_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
axis([0,12,0,1]);
title('PDADMAC/PSS');
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Retention [-]');
yticks([0.2 0.4 0.6 0.8 1]);
yyaxis right
plot([5.999;6.001],[0;6.83E-5],'--','Color','k');
errorbar(BL,AoverB,AoverB_Conf,AoverB_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
axis([0,12,0,2E-4]);
ylabel('A/B [1/Pa]');
yticks([0.5 1 1.5 2]*1E-4);
ax = gca;
ax.YAxis(1).Color = 'k';
ax.YAxis(2).Color = 'k';
xticks([2 4 6 8 10]);

%PAH/PAA
BL=[3;5;7;9;10;11;12;14]; %Bilayer number
Ret=[0.419151376;0.569667431;0.74483945;0.829329128;0.816107001;0.806488332;0.830193512;0.805463859];
AoverB=[1.86027E-06;3.32048E-06;6.67478E-06;1.04037E-05;8.46369E-06;7.89646E-06;9.34357E-06;7.46797E-06];
Ret_Conf=[0.037263413;0.019731169;0.02395517;0.013200382;0.006207047;0.020403154;0.019745822;0.013716503];
AoverB_Conf=[2.82395E-07;2.93228E-07;6.55372E-07;5.75935E-07;7.37145E-07;1.23478E-06;1.3231E-06;5.26782E-07];

figure;
hold on;
box on;
pbaspect([1 1 1])
yyaxis left
errorbar(BL,Ret,Ret_Conf,Ret_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
axis([0,16,0,1]);
title('PAH/PAA');
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Retention [-]');
yticks([0.2 0.4 0.6 0.8 1]);
yyaxis right
plot([8.999;9.001],[0;10.5E-6],'--','Color','k');
errorbar(BL,AoverB,AoverB_Conf,AoverB_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
axis([0,16,0,2E-5]);
ylabel('A/B [1/Pa]');
yticks([0.5 1 1.5 2]*1E-5);
ax = gca;
ax.YAxis(1).Color = 'k';
ax.YAxis(2).Color = 'k';
xticks([2 4 6 8 10 12 14]);

%% PEG Retention
%PDADMAC/PSS 2-6BL
Flux1=[22.20407474;47.96138853;64.5148547;12.32384827;26.78746197;39.61627765;9.971415295;22.25812066;33.79708601;9.099284752;20.02444001;30.73278096]; %Flux of Mix 1 (EG,200,600,2000)
Flux2=[22.65362787;47.43768174;58.44531433;12.85755257;27.25612313;37.6839114;10.54731801;22.50551416;32.77082562;9.60644015;20.42366048;30.5993719]; %Flux of Mix 2 (DEG,400,1000,3000)
Flux1Conf=[1.514838107;3.49083326;4.046463792;0.724482918;1.599897004;2.066582565;0.625421896;1.223279099;1.967574812;0.404824356;1.390164144;1.216385427]; %95% Confidence Interval for Flux of Mix 1
Flux2Conf=[1.780987794;4.237441284;3.785692169;0.839700675;1.870653899;1.829962823;0.684300626;1.129801877;2.374762139;0.37974627;0.888250839;1.275160135]; %95% Confidence Interval for Flux of Mix 2

EG1=[0.00775;0.017;0.026;0.01;0.02175;0.04075;0.01025;0.02675;0.04525;0.01;0.022666667;0.0475]; %EG Retention first set
DEG1=[0.024;0.0425;0.07025;0.043;0.08175;0.127;0.052;0.09575;0.1515;0.056;0.10075;0.16025]; %DEG Retention first set
PEG2001=[0.12475;0.1655;0.216;0.32475;0.41975;0.50475;0.44525;0.54925;0.6255;0.4915;0.598333333;0.6605]; %200 Retention first set
PEG4001=[0.25675;0.27475;0.402;0.66;0.69775;0.82225;0.881;0.90525;0.9455;0.94475;0.95775;0.97225]; %400 Retention first set
PEG6001=[0.36175;0.393;0.46675;0.75575;0.8028;0.86175;0.9365;0.95475;0.971;0.9915;0.994;0.99625]; %600 Retention first set
PEG10001=[0.50725;0.46175;0.61675;0.84475;0.82825;0.923;0.96625;0.95925;0.9885;0.998;0.99725;0.99825]; %1000 Retention first set
PEG20001=[0.70775;0.65925;0.71125;0.93175;0.92825;0.9525;0.9865;0.9875;0.99175;0.99825;0.999;0.99875]; %2000 Retention first set
PEG30001=[0.83075;0.70375;0.84575;0.966;0.935;0.976;0.99425;0.98975;0.99525;0.997;0.99675;0.9975]; %3000 Retention first set

EG1Conf=[0.002002216;0.004500593;0.001299209;0.002250297;0.0007956;0.0007956;0.0007956;0.001523458;0.0007956;0.002250297;0.007589779;0.00205423];
DEG1Conf=[0.002250297;0.00205423;0.005718735;0.001299209;0.0023868;0.006996457;0.004108461;0.006281378;0.01340769;0.00290512;0.002002216;0.002002216];
PEG2001Conf=[0.009402453;0.012083346;0.013564144;0.02389892;0.030368585;0.032541888;0.014313431;0.013955166;0.014142895;0.00668809;0.001434333;0.008268118];
PEG4001Conf=[0.019504374;0.01082133;0.027713083;0.064647906;0.064456695;0.041358448;0.026403054;0.025735334;0.014496522;0.0007956;0.005415537;0.0007956];
PEG6001Conf=[0.018573469;0.017284856;0.018888869;0.058020645;0.056911302;0.04305806;0.026290939;0.021204394;0.01350178;0.00205423;0.002484338;0.003280343];
PEG10001Conf=[0.02310895;0.018933497;0.028057358;0.047954291;0.052875985;0.028015967;0.019974684;0.027449161;0.008666807;0;0.0055692;0.001523458];
PEG20001Conf=[0.018709291;0.018019945;0.018436646;0.025504741;0.031245242;0.021169539;0.011437471;0.013281199;0.0071604;0.0007956;0;0.0007956];
PEG30001Conf=[0.01806672;0.02560382;0.021520453;0.017861176;0.038606417;0.010634487;0.003528257;0.007835751;0.003528257;0;0.003978;0.0015912];

%PDADMAC/PSS 7-10BL
Flux3=[8.346081513;18.53051078;29.21626753;7.366477093;16.27303801;25.66591798;7.634988701;16.8298138;26.59508278;7.094261876;15.45812071;24.40051845]; %Flux of Mix 1 (EG,200,600,2000)
Flux4=[8.641934466;18.96506491;27.48447788;7.619193901;16.60770521;24.26719957;7.779974077;17.14660614;24.86510085;7.324430245;16.07411366;23.22324495]; %Flux of Mix 2 (DEG,400,1000,3000)
Flux3Conf=[0.70766455;1.744111149;2.606525312;0.349970982;0.537390531;0.790107057;0.291002264;0.845582076;0.981343253;0.284077439;0.72444361;0.706612057]; %95% Confidence Interval for Flux of Mix 1
Flux4Conf=[0.752571823;3.316821204;2.396999879;0.248354409;0.440391686;0.766256566;0.396946582;0.636467297;1.196976745;0.206292138;0.759702356;1.1109451]; %95% Confidence Interval for Flux of Mix 2

EG2=[0.0005;0.03475;0.0445;0.00125;0.0385;0.04575;0.00025;0.02975;0.043;0;0.03875;0.041]; %EG Retention second set
DEG2=[0.062;0.12125;0.17475;0.06325;0.1255;0.179;0.0605;0.1245;0.17775;0.05725;0.1255;0.17875]; %DEG Retention second set
PEG2002=[0.50025;0.63175;0.67125;0.5105;0.64275;0.682;0.50675;0.63925;0.68025;0.507;0.641;0.68625]; %200 Retention second set
PEG4002=[0.95425;0.9705;0.97825;0.95775;0.973;0.9805;0.95675;0.97275;0.98;0.9565;0.97325;0.9805]; %400 Retention second set
PEG6002=[0.99375;0.99625;0.995;0.99475;0.99525;0.995;0.995;0.994;0.995;0.9945;0.99525;0.995]; %600 Retention second set
PEG10002=[0.99825;0.999;0.999;0.999;0.999;0.999;0.999;0.999;0.999;0.999;0.999;0.999]; %1000 Retention second set
PEG20002=[0.99825;0.99775;0.995;0.999;0.99575;0.995;0.999;0.995;0.995;0.99875;0.99575;0.995]; %2000 Retention second set
PEG30002=[0.99725;0.998;0.998;0.998;0.998;0.998;0.998;0.998;0.998;0.998;0.998;0.998]; %3000 Retention second set

EG2Conf=[0.00091868;0.002717491;0.00205423;0.0007956;0.008061382;0.0007956;0.0023868;0.001523458;0.001299209;0.00290512;0.007392376;0.00430899];
DEG2Conf=[0.003897628;0.001523458;0.001523458;0.003528257;0.002756039;0.004684366;0.00205423;0.00091868;0.0007956;0.002717491;0.005882421;0.0023868];
PEG2002Conf=[0.003280343;0.003280343;0.003528257;0.004947242;0.001523458;0.002598419;0.0023868;0.001523458;0.003978;0.005031816;0.007233692;0.005094326];
PEG4002Conf=[0.0007956;0.00091868;0.001523458;0.0007956;0;0.00091868;0.0007956;0.0007956;0;0.002756039;0.002717491;0.00091868];
PEG6002Conf=[0.0007956;0.003280343;0;0.0007956;0.003978;0;0.001299209;0;0;0.00091868;0.003978;0];
PEG10002Conf=[0.0007956;0;0;0;0;0;0;0;0;0;0;0];
PEG20002Conf=[0.0007956;0.003012093;0;0;0.0023868;0;0;0;0;0.0007956;0.0023868;0];
PEG30002Conf=[0.0007956;0;0;0;0;0;0;0;0;0;0;0];

figure; %200 layer growth
hold on;
box on;
pbaspect([1 1 1])
plot(Flux3(10:12),PEG2002(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%[.5 0 .5]
plot(Flux3(7:9),PEG2002(7:9),'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
plot(Flux3(4:6),PEG2002(4:6),'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
plot(Flux3(1:3),PEG2002(1:3),'.','MarkerSize',16,'Color',[0,0,0]./255);%'k'
plot(Flux1(10:12),PEG2001(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%[.5 0 .5]
plot(Flux1(7:9),PEG2001(7:9),'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
plot(Flux1(4:6),PEG2001(4:6),'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
plot(Flux1(1:3),PEG2001(1:3),'.','MarkerSize',16,'Color',[0,0,0]./255);%'k'
errorbar(Flux3(10:12),PEG2002(10:12),PEG2002Conf(10:12),PEG2002Conf(10:12),Flux3Conf(10:12),Flux3Conf(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%[.5 0 .5]
errorbar(Flux3(7:9),PEG2002(7:9),PEG2002Conf(7:9),PEG2002Conf(7:9),Flux3Conf(7:9),Flux3Conf(7:9),'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
errorbar(Flux3(4:6),PEG2002(4:6),PEG2002Conf(4:6),PEG2002Conf(4:6),Flux3Conf(4:6),Flux3Conf(4:6),'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
errorbar(Flux3(1:3),PEG2002(1:3),PEG2002Conf(1:3),PEG2002Conf(1:3),Flux3Conf(1:3),Flux3Conf(1:3),'.','MarkerSize',16,'Color',[0,0,0]./255);%'k'
errorbar(Flux1(10:12),PEG2001(10:12),PEG2001Conf(10:12),PEG2001Conf(10:12),Flux1Conf(10:12),Flux1Conf(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%[.5 0 .5]
errorbar(Flux1(7:9),PEG2001(7:9),PEG2001Conf(7:9),PEG2001Conf(7:9),Flux1Conf(7:9),Flux1Conf(7:9),'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
errorbar(Flux1(4:6),PEG2001(4:6),PEG2001Conf(4:6),PEG2001Conf(4:6),Flux1Conf(4:6),Flux1Conf(4:6),'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
errorbar(Flux1(1:3),PEG2001(1:3),PEG2001Conf(1:3),PEG2001Conf(1:3),Flux1Conf(1:3),Flux1Conf(1:3),'.','MarkerSize',16,'Color',[0,0,0]./255);%'k'
axis([0,80,0,1]);
title('PDADMAC/PSS - PEG200');
xlabel('Flux [LMH]');
xticks([20 40 60 80]);
set(gca,'FontSize',15)
ylabel('Retention [-]');
yticks([0.2 0.4 0.6 0.8 1]);
legend('10','9','8','7','6','4','3','2');
[leg, icons, plots, txt]  = legend('show');
title(leg,{'Number of','Bilayers [-]'});
legend('boxoff');
leg.FontSize = 13;

figure; %6BL Retentions
hold on;
box on;
pbaspect([1 1 1])
plot(Flux2(10:12),PEG30001(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%'k'
plot(Flux1(10:12),PEG20001(10:12),'.','MarkerSize',16,'Color',[230,68,62]./255);%'b'
plot(Flux2(10:12),PEG10001(10:12),'.','MarkerSize',16,'Color',[96,58,232]./255);%'r'
plot(Flux1(10:12),PEG6001(10:12),'.','MarkerSize',16,'Color',[0,0,0]./255);%[.5 0 .5]
plot(Flux2(10:12),PEG4001(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%'k'
plot(Flux1(10:12),PEG2001(10:12),'.','MarkerSize',16,'Color',[230,68,62]./255);%'b'
plot(Flux2(10:12),DEG1(10:12),'.','MarkerSize',16,'Color',[96,58,232]./255);%'r'
plot(Flux1(10:12),EG1(10:12),'.','MarkerSize',16,'Color',[0,0,0]./255);%[.5 0 .5]
errorbar(Flux2(10:12),PEG30001(10:12),PEG30001Conf(10:12),PEG30001Conf(10:12),Flux2Conf(10:12),Flux2Conf(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%'k'
errorbar(Flux1(10:12),PEG20001(10:12),PEG20001Conf(10:12),PEG20001Conf(10:12),Flux1Conf(10:12),Flux1Conf(10:12),'.','MarkerSize',16,'Color',[230,68,62]./255);%'b'
errorbar(Flux2(10:12),PEG10001(10:12),PEG10001Conf(10:12),PEG10001Conf(10:12),Flux2Conf(10:12),Flux2Conf(10:12),'.','MarkerSize',16,'Color',[96,58,232]./255);%'r'
errorbar(Flux1(10:12),PEG6001(10:12),PEG6001Conf(10:12),PEG6001Conf(10:12),Flux1Conf(10:12),Flux1Conf(10:12),'.','MarkerSize',16,'Color',[0,0,0]./255);%[.5 0 .5]
errorbar(Flux2(10:12),PEG4001(10:12),PEG4001Conf(10:12),PEG4001Conf(10:12),Flux2Conf(10:12),Flux2Conf(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%'k'
errorbar(Flux1(10:12),PEG2001(10:12),PEG2001Conf(10:12),PEG2001Conf(10:12),Flux1Conf(10:12),Flux1Conf(10:12),'.','MarkerSize',16,'Color',[230,68,62]./255);%'b'
errorbar(Flux2(10:12),DEG1(10:12),DEG1Conf(10:12),DEG1Conf(10:12),Flux2Conf(10:12),Flux2Conf(10:12),'.','MarkerSize',16,'Color',[96,58,232]./255);%'r'
errorbar(Flux1(10:12),EG1(10:12),EG1Conf(10:12),EG1Conf(10:12),Flux1Conf(10:12),Flux1Conf(10:12),'.','MarkerSize',16,'Color',[0,0,0]./255);%[.5 0 .5]
axis([0,50,0,1]);
title('PDADMAC/PSS - 6 BL');
xlabel('Flux [LMH]');
xticks([10 20 30 40 50]);
set(gca,'FontSize',15)
ylabel('Retention [-]');
yticks([0.2 0.4 0.6 0.8 1]);
legend('3000','2000','1000','600','400','200','106','62');
[leg, icons, plots, txt]  = legend('show');
title(leg,{'PEG MW','[Da]'})
legend('boxoff');
leg.FontSize = 13;

%PAH/PAA 3-9BL
Flux1=[7.260245421	14.8305603	17.6997759839  4.493970352	8.860121057	11.5784057375  2.870175611	4.871566365	7.4278952655  2.081462198	3.36056486	5.371040066]; %Flux of Mix 1 (EG,200,600,2000)
Flux2=[7.318556445	13.14199723	18.57656001	4.458850345	8.092036773	11.70187737	2.764252932	5.220753732	7.487622708	2.049535231	3.844101418	5.620828842]; %Flux of Mix 2 (DEG,400,1000,3000)
Flux1Conf=[1.172250129	2.334145183	2.0787171  0.346519051	0.546592012	1.9561062  0.059353597	0.247013237	0.3570535 0.198092053	0.399817048	0.775361881]; %95% Confidence Interval for Flux of Mix 1
Flux2Conf=[1.149168472	1.955776898	2.644846329	0.393776701	0.563584432	0.835682951	0.027283049	0.164570058	0.399375354	0.075886016	0.289807019	0.041561036]; %95% Confidence Interval for Flux of Mix 2

EG1=[0.03025	0.054	0.102000  0.06025	0.0915	0.169500  0.1495	0.1805	0.313000  0.19425	0.24475	0.3365]; %EG Retention first set
DEG1=[0.08	0.1525	0.205	0.15125	0.26025	0.342	0.42925	0.56175	0.64825	0.72475	0.82075	0.86375]; %DEG Retention first set
PEG2001=[0.22375	0.2665	0.431650  0.33675	0.37825	0.572525	0.646	0.696	0.816767  0.8835  0.92475	0.92075]; %200 Retention first set
PEG4001=[0.456	0.563	0.63025	0.6065	0.70525	0.7665	0.84525	0.89225	0.91525	0.9435	0.9555	0.957]; %400 Retention first set
PEG6001=[0.55825	0.57125	0.755750	0.68875	0.6935	0.840275  0.8915	0.89925	0.948133	0.95575	0.9845	0.96075]; %600 Retention first set
PEG10001=[0.74425	0.8	0.82825	0.8485	0.886	0.9095	0.9475	0.96325	0.96575	0.96275	0.96525	0.964]; %1000 Retention first set
PEG20001=[0.784	0.673	0.896575	0.85775	0.77075	0.932950	0.97125	0.989	0.981167	0.975	0.99375	0.973]; %2000 Retention first set
PEG30001=[0.863	0.87975	0.8895	0.9315	0.95025	0.95375	0.984	0.9815	0.986	0.97025	0.97325	0.967]; %3000 Retention first set

EG1Conf=[0.005415537	0.00746339	0.007463	0.005257385	0.006162691	0.021170	0.019027984	0.009502897	0.029812	0.014015513	0.005257385	0.007631127];
DEG1Conf=[0.009094466	0.017162354	0.021109653	0.013649429	0.017593377	0.023277249	0.055477533	0.033763824	0.033030977	0.014662946	0.012419178	0.0103428];
PEG2001Conf=[0.021124641	0.02853828	0.028262	0.015610799	0.019974684	0.075473	0.047434488	0.025558457	0.043313	0.014142895	0.02310895	0.013209516];
PEG4001Conf=[0.033704406	0.038277098	0.03573121	0.030813456	0.02332705	0.025541941	0.021084651	0.012754438	0.010260876	0.008369571	0.009232617	0.007233692];
PEG6001Conf=[0.032928614	0.035825566	0.021752	0.019022439	0.021209369	0.092084	0.021049597	0.009221184	0.010331	0.012351033	0.025142303	0.013587457];
PEG10001Conf=[0.027785317	0.026909634	0.024868069	0.020231823	0.013185535	0.014727557	0.003312347	0.002002216	0.002717491	0.006672297	0.008942393	0.006230789];
PEG20001Conf=[0.019270389	0.041777208	0.010872	0.017400435	0.027876292	0.096846	0.01171992	0.009635194	0.002656	0.013056892	0.015664769	0.016122764];
PEG30001Conf=[0.018235272	0.021004443	0.018396548	0.02080764	0.012419178	0.018436646	0.003437385	0.002756039	0.00290512	0.007277312	0.007727293	0.006230789];

%PAH/PAA 10-14BL
Flux3=[1.530885729	3.098767032	4.695365839	1.229120967	2.469861951	3.702884223	1.178258351	2.301055382	3.227356027	1.020639834	2.098299868	3.058172142]; %Flux of Mix 1 (EG,200,600,2000)
Flux4=[1.512089144	3.109396743	5.067899336	1.288374665	2.5312341	4.171214815	1.221528352	2.246417565	3.645062855	0.948570092	2.06676209	3.319884971]; %Flux of Mix 2 (DEG,400,1000,3000)
Flux3Conf=[0.0007956	0.007942729	0.004570374	0.002002216	0.014727557	0.009047946	0.002002216	0.021446795	0.014926779	0.008369571	0.008457344	0.011656739]; %95% Confidence Interval for Flux of Mix 1
Flux4Conf=[0.005882421	0.007056513	0.004570374	0.021759333	0.019804954	0.019590724	0.029694111	0.021701075	0.0248001	0.021754484	0.012144307	0.003794889]; %95% Confidence Interval for Flux of Mix 2

EG2=[0.1675	0.26525	0.34925	0.1645	0.26625	0.34025	0.16625	0.28025	0.355	0.13825	0.27875	0.34575]; %EG Retention second set
DEG2=[0.778	0.861	0.88575	0.783	0.8555	0.87925	0.7945	0.86575	0.886	0.7825	0.84575	0.869666667]; %DEG Retention second set
PEG2002=[0.9355	0.93975	0.9575	0.94625	0.94275	0.95375	0.94975	0.945	0.9535	0.92525	0.93	0.93375]; %200 Retention second set
PEG4002=[0.97375	0.9665	0.97325	0.962	0.94925	0.95625	0.9635	0.953	0.95875	0.96	0.94	0.94]; %400 Retention second set
PEG6002=[0.9925	0.974	0.987	0.99125	0.96775	0.978	0.99	0.97	0.98	0.97375	0.95	0.96]; %600 Retention second set
PEG10002=[0.98525	0.971	0.97625	0.971	0.95125	0.9565	0.97075	0.95	0.96	0.97	0.93775	0.95]; %1000 Retention second set
PEG20002=[0.99775	0.98975	0.99625	0.99775	0.9835	0.9925	0.99675	0.99	0.99	0.99	0.97325	0.98]; %2000 Retention second set
PEG30002=[0.9945	0.9785	0.98425	0.9815	0.96125	0.97025	0.98575	0.97	0.97	0.98	0.95425	0.96]; %3000 Retention second set

EG2Conf=[0.006560686	0.010178292	0.014430877	0.003787814	0.008255348	0.008356957	0.012144307	0.01248695	0.01	0.01	0.01	0.012074612];
DEG2Conf=[0.028076152	0.015151255	0.006145549	0.012795728	0.014496522	0.013587457	0.015067468	0.014720392	0.015964952	0.02	0.01	0.01];
PEG2002Conf=[0.017931913	0.008356957	0.010908718	0.009926419	0.015556642	0.011791712	0.017784226	0.016070332	0.02	0.03	0.01	0.010976205];
PEG4002Conf=[0.009754891	0.009591298	0.0023868	0.02342183	0.020761959	0.018482366	0.024323337	0.019660605	0.020557705	0.02553781	0.015938498	0.001434333];
PEG6002Conf=[0.011363441	0.008906931	0.010312155	0.015282977	0.016142382	0.017284856	0.015617556	0.016914688	0.019155079	0.029920625	0.010424081	0.009667986];
PEG10002Conf=[0.01	0.01	0.00	0.02	0.02	0.02	0.02	0.019719542	0.020680499	0.030036754	0.020016891	0.002868667];
PEG20002Conf=[0.0007956	0.007942729	0.004570374	0.002002216	0.014727557	0.009047946	0.002002216	0.021446795	0.014926779	0.008369571	0.008457344	0.011656739];
PEG30002Conf=[0.005882421	0.007056513	0.004570374	0.021759333	0.019804954	0.019590724	0.029694111	0.021701075	0.0248001	0.021754484	0.012144307	0.003794889];

figure; %200 layer growth
hold on;
box on;
pbaspect([1 1 1])
plot(Flux3(10:12),PEG2002(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%[.5 0 .5]
plot(Flux3(7:9),PEG2002(7:9),'.','MarkerSize',16,'Color',[230,68,62]./255);
plot(Flux3(4:6),PEG2002(4:6),'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
plot(Flux3(1:3),PEG2002(1:3),'.','MarkerSize',16,'Color',[0,0,0]./255);%'k'
plot(Flux1(10:12),PEG2001(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%[.5 0 .5]
plot(Flux1(7:9),PEG2001(7:9),'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
plot(Flux1(4:6),PEG2001(4:6),'.','MarkerSize',16,'Color',[96,58,232]./255);
plot(Flux1(1:3),PEG2001(1:3),'.','MarkerSize',16,'Color',[0,0,0]./255);%'k'
errorbar(Flux3(10:12),PEG2002(10:12),PEG2002Conf(10:12),PEG2002Conf(10:12),Flux3Conf(10:12),Flux3Conf(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%[.5 0 .5]
errorbar(Flux3(7:9),PEG2002(7:9),PEG2002Conf(7:9),PEG2002Conf(7:9),Flux3Conf(7:9),Flux3Conf(7:9),'.','MarkerSize',16,'Color',[230,68,62]./255);
errorbar(Flux3(4:6),PEG2002(4:6),PEG2002Conf(4:6),PEG2002Conf(4:6),Flux3Conf(4:6),Flux3Conf(4:6),'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
errorbar(Flux3(1:3),PEG2002(1:3),PEG2002Conf(1:3),PEG2002Conf(1:3),Flux3Conf(1:3),Flux3Conf(1:3),'.','MarkerSize',16,'Color',[0,0,0]./255);%'k'
errorbar(Flux1(10:12),PEG2001(10:12),PEG2001Conf(10:12),PEG2001Conf(10:12),Flux1Conf(10:12),Flux1Conf(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%[.5 0 .5]
errorbar(Flux1(7:9),PEG2001(7:9),PEG2001Conf(7:9),PEG2001Conf(7:9),Flux1Conf(7:9),Flux1Conf(7:9),'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
errorbar(Flux1(4:6),PEG2001(4:6),PEG2001Conf(4:6),PEG2001Conf(4:6),Flux1Conf(4:6),Flux1Conf(4:6),'.','MarkerSize',16,'Color',[96,58,232]./255);
errorbar(Flux1(1:3),PEG2001(1:3),PEG2001Conf(1:3),PEG2001Conf(1:3),Flux1Conf(1:3),Flux1Conf(1:3),'.','MarkerSize',16,'Color',[0,0,0]./255);%'k'
axis([0,30,0,1]);
title('PAH/PAA - PEG200');
xlabel('Flux [LMH]');
xticks([5 10 15 20 25 30]);
set(gca,'FontSize',15)
ylabel('Retention [-]');
yticks([0.2 0.4 0.6 0.8 1]);
legend('14','12','11','10','9','7','5','3');
[leg, icons, plots, txt]  = legend('show');
title(leg,{'Number of','Bilayers [-]'})
legend('boxoff');
leg.FontSize = 13;

figure; %9BL Retentions
hold on;
box on;
pbaspect([1 1 1])
plot(Flux4(10:12),PEG30001(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%'k'
plot(Flux3(10:12),PEG20001(10:12),'.','MarkerSize',16,'Color',[230,68,62]./255);%'b'
plot(Flux4(10:12),PEG10001(10:12),'.','MarkerSize',16,'Color',[96,58,232]./255);%'r'
plot(Flux3(10:12),PEG6001(10:12),'.','MarkerSize',16,'Color',[0,0,0]./255);%[.5 0 .5]
plot(Flux4(10:12),PEG4001(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%'k'
plot(Flux3(10:12),PEG2001(10:12),'.','MarkerSize',16,'Color',[230,68,62]./255);%'b'
plot(Flux4(10:12),DEG1(10:12),'.','MarkerSize',16,'Color',[96,58,232]./255);%'r'
plot(Flux3(10:12),EG1(10:12),'.','MarkerSize',16,'Color',[0,0,0]./255);%[.5 0 .5]
errorbar(Flux4(10:12),PEG30001(10:12),PEG30001Conf(10:12),PEG30001Conf(10:12),Flux4Conf(10:12),Flux4Conf(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%'k'
errorbar(Flux3(10:12),PEG20001(10:12),PEG20001Conf(10:12),PEG20001Conf(10:12),Flux3Conf(10:12),Flux3Conf(10:12),'.','MarkerSize',16,'Color',[230,68,62]./255);%'b'
errorbar(Flux4(10:12),PEG10001(10:12),PEG10001Conf(10:12),PEG10001Conf(10:12),Flux4Conf(10:12),Flux4Conf(10:12),'.','MarkerSize',16,'Color',[96,58,232]./255);%'r'
errorbar(Flux3(10:12),PEG6001(10:12),PEG6001Conf(10:12),PEG6001Conf(10:12),Flux3Conf(10:12),Flux3Conf(10:12),'.','MarkerSize',16,'Color',[0,0,0]./255);%[.5 0 .5]
errorbar(Flux4(10:12),PEG4001(10:12),PEG4001Conf(10:12),PEG4001Conf(10:12),Flux4Conf(10:12),Flux4Conf(10:12),'.','MarkerSize',16,'Color',[118,230,67]./255);%'k'
errorbar(Flux3(10:12),PEG2001(10:12),PEG2001Conf(10:12),PEG2001Conf(10:12),Flux3Conf(10:12),Flux3Conf(10:12),'.','MarkerSize',16,'Color',[230,68,62]./255);%'b'
errorbar(Flux4(10:12),DEG1(10:12),DEG1Conf(10:12),DEG1Conf(10:12),Flux4Conf(10:12),Flux4Conf(10:12),'.','MarkerSize',16,'Color',[96,58,232]./255);%'r'
errorbar(Flux3(10:12),EG1(10:12),EG1Conf(10:12),EG1Conf(10:12),Flux3Conf(10:12),Flux3Conf(10:12),'.','MarkerSize',16,'Color',[0,0,0]./255);%[.5 0 .5]
axis([0,6,0,1]);
title('PAH/PAA - 9 BL');
xlabel('Flux [LMH]');
xticks([1 2 3 4 5 6]);
set(gca,'FontSize',15)
ylabel('Retention [-]');
yticks([0.2 0.4 0.6 0.8 1]);
legend('3000','2000','1000','600','400','200','106','62');
[leg, icons, plots, txt]  = legend('show');
title(leg,{'PEG MW','[Da]'})
legend('boxoff');
leg.FontSize = 13;

%% Single Pore Radius Fit Correlation 2 (Shimada)
%PDADMACPSS
BL_PDPSS=[2 3 4 6 7 8 9 10];
r_pore=[1.30646E-09	6.50255E-10	5.04658E-10	4.95199E-10	4.90905E-10	4.88188E-10	4.90202E-10	4.90165E-10]*10^9; %pore radius in [nm]
dxe=[3.91753E-06	1.43965E-06	9.84794E-07	1.05281E-06	1.09921E-06	1.19177E-06	1.2022E-06	1.29377E-06]*10^6; %effective membrane thickness in [um]

r_pore_Conf=[5.47992E-11	2.23543E-11	5.84305E-12	3.27108E-12	3.83392E-12	2.59564E-12	2.74711E-12	3.23737E-12]*10^9; %95% Confidence
dxe_Conf=[3.85811E-07	1.20511E-07	2.92088E-08	1.81005E-08	2.28412E-08	1.664E-08	1.76128E-08	2.23366E-08]*10^6; %95% Confidence

P=[19.9756002	13.33900887	11.62454027	10.46461388	9.852042327	8.986779006	8.98179632	8.344471105]; %Pure water permeability [LMH/bar]
P_Conf=[0.517964618	0.293177849	0.311788965	0.245858136	0.349379245	0.190766598	0.203474953	0.237874123]; %95% Confidence Permeability

figure;
hold on;
box on;
pbaspect([1 1 1])
yyaxis left
plot(BL_PDPSS,r_pore,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
errorbar(BL_PDPSS,r_pore,r_pore_Conf,r_pore_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);
axis([0,12,0,1.6]);
title('PDADMAC/PSS');
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Pore Radius [nm]');
yticks([0.4 0.8 1.2 1.6]);
yyaxis right
plot(BL_PDPSS,dxe,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
errorbar(BL_PDPSS,dxe,dxe_Conf,dxe_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255);
axis([0,12,0,5]);
ylabel('Effective Membrane Thickness [\mum]');
yticks([1 2 3 4 5]);
ax = gca;
ax.YAxis(1).Color = 'k';
ax.YAxis(2).Color = 'k';
xticks([2 4 6 8 10]);

%PAHPAA
BL_PAHPAA=[3 5 7 9 10 11 12 14];
r_pore=[9.3242E-10	7.48106E-10	3.81194E-10	3.38811E-10	3.33081E-10	3.34425E-10	3.33056E-10	3.35535E-10]*10^9; %pore radius in [nm]
dxe=[1.07657E-05	1.02164E-05	4.06237E-06	4.35921E-06	5.21514E-06	6.57294E-06	7.33473E-06	8.88433E-06]*10^6; %effective membrane thickness in [um]

r_pore_Conf=[4.732E-11	3.70551E-11	1.12476E-11	3.97451E-12	3.38734E-12	3.51812E-12	3.42576E-12	4.99111E-12]*10^9; %95% Confidence
dxe_Conf=[1.27028E-06	1.18508E-06	3.17586E-07	1.35192E-07	1.39175E-07	1.80272E-07	1.95137E-07	3.52542E-07]*10^6; %95% Confidence

P=[3.678067869	2.502551268	1.612751816	1.185023033	0.95373694	0.76276447	0.678019523	0.567924308]; %Pure water permeability [LMH/bar]
P_Conf=[0.153384628	0.061989371	0.024645117	0.0312861	0.035912904	0.024641462	0.020254879	0.0300837]; %95% Confidence Permeability

figure;
hold on;
box on;
pbaspect([1 1 1])
yyaxis left
plot(BL_PAHPAA,r_pore,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
errorbar(BL_PAHPAA,r_pore,r_pore_Conf,r_pore_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);
axis([0,12,0,1.6]);
title('PAH/PAA');
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Pore Radius [nm]');
yticks([0.4 0.8 1.2 1.6]);
yyaxis right
plot(BL_PAHPAA,dxe,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
errorbar(BL_PAHPAA,dxe,dxe_Conf,dxe_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255);
axis([0,16,0,15]);
ylabel('Effective Membrane Thickness [\mum]');
yticks([3 6 9 12 15]);
ax = gca;
ax.YAxis(1).Color = 'k';
ax.YAxis(2).Color = 'k';
xticks([2 4 6 8 10 12 14]);

%% Single Pore Radius Fit Correlation 1 (Murugaiah)
%PDADMACPSS
BL_PDPSS=[2 3 4 6 7 8 9 10];
r_pore=[1.69202E-09	7.40019E-10	5.15234E-10	5.06012E-10	5.02149E-10	4.99305E-10	5.01286E-10	5.01194E-10]*10^9; %pore radius in [nm]
dxe=[6.53858E-06	1.86574E-06	1.02669E-06	1.10015E-06	1.15105E-06	1.24769E-06	1.25823E-06	1.35382E-06]*10^6; %effective membrane thickness in [um]

r_pore_Conf=[8.58024E-11	3.2735E-11	6.44033E-12	3.83279E-12	4.5362E-12	3.49824E-12	3.5667E-12	3.98715E-12]*10^9; %95% Confidence
dxe_Conf=[7.54015E-07	1.92771E-07	3.25884E-08	2.14305E-08	2.73086E-08	2.26497E-08	2.30976E-08	2.77798E-08]*10^6; %95% Confidence

P=[19.9756002	13.33900887	11.62454027	10.46461388	9.852042327	8.986779006	8.98179632	8.344471105]; %Pure water permeability [LMH/bar]
P_Conf=[0.517964618	0.293177849	0.311788965	0.245858136	0.349379245	0.190766598	0.203474953	0.237874123]; %95% Confidence Permeability

figure;
hold on;
box on;
pbaspect([1 1 1])
yyaxis left
plot(BL_PDPSS,r_pore,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
errorbar(BL_PDPSS,r_pore,r_pore_Conf,r_pore_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);
axis([0,12,0,2]);
title('PDADMAC/PSS');
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Pore Radius [nm]');
yticks([0.5 1 1.5 2]);
yyaxis right
plot(BL_PDPSS,dxe,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
errorbar(BL_PDPSS,dxe,dxe_Conf,dxe_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255);
axis([0,12,0,8]);
ylabel('Effective Membrane Thickness [\mum]');
yticks([2 4 6 8]);
ax = gca;
ax.YAxis(1).Color = 'k';
ax.YAxis(2).Color = 'k';
xticks([2 4 6 8 10]);

%PAHPAA
BL_PAHPAA=[3 5 7 9 10 11 12 14];
r_pore=[1.13264E-09	8.55874E-10	3.52082E-10	3.1522E-10	3.07102E-10	3.08526E-10	3.05975E-10	3.08075E-10]*10^9; %pore radius in [nm]
dxe=[1.58981E-05	1.33741E-05	3.46103E-06	3.78171E-06	4.4476E-06	5.61151E-06	6.21083E-06	7.51833E-06]*10^6; %effective membrane thickness in [um]

r_pore_Conf=[7.14872E-11	5.56694E-11	1.02598E-11	5.11815E-12	4.891E-12	4.98653E-12	5.27961E-12	6.04568E-12]*10^9; %95% Confidence
dxe_Conf=[2.2445E-06	1.95561E-06	2.73242E-07	1.58371E-07	1.75604E-07	2.24137E-07	2.5919E-07	3.71073E-07]*10^6; %95% Confidence

P=[3.678067869	2.502551268	1.612751816	1.185023033	0.95373694	0.76276447	0.678019523	0.567924308]; %Pure water permeability [LMH/bar]
P_Conf=[0.153384628	0.061989371	0.024645117	0.0312861	0.035912904	0.024641462	0.020254879	0.0300837]; %95% Confidence Permeability

figure;
hold on;
box on;
pbaspect([1 1 1])
yyaxis left
plot(BL_PAHPAA,r_pore,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
errorbar(BL_PAHPAA,r_pore,r_pore_Conf,r_pore_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);
axis([0,12,0,2]);
title('PAH/PAA');
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Pore Radius [nm]');
yticks([0.5 1 1.5 2]);
yyaxis right
plot(BL_PAHPAA,dxe,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
errorbar(BL_PAHPAA,dxe,dxe_Conf,dxe_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255);
axis([0,16,0,20]);
ylabel('Effective Membrane Thickness [\mum]');
yticks([5 10 15 20]);
ax = gca;
ax.YAxis(1).Color = 'k';
ax.YAxis(2).Color = 'k';
xticks([2 4 6 8 10 12 14]);

%% Log-Normal Distribution Fit Correlation 2 (Shimada)
%PDADMACPSS Pore radius and Relative Flux
BL2_Radius=[1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09 2.09000000000000e-09 2.10000000000000e-09 2.11000000000000e-09 2.12000000000000e-09 2.13000000000000e-09 2.14000000000000e-09 2.15000000000000e-09 2.16000000000000e-09 2.17000000000000e-09 2.18000000000000e-09 2.19000000000000e-09 2.20000000000000e-09 2.21000000000000e-09 2.22000000000000e-09 2.23000000000000e-09 2.24000000000000e-09 2.25000000000000e-09 2.26000000000000e-09 2.27000000000000e-09 2.28000000000000e-09 2.29000000000000e-09 2.30000000000000e-09 2.31000000000000e-09 2.32000000000000e-09 2.33000000000000e-09 2.34000000000000e-09 2.35000000000000e-09 2.36000000000000e-09 2.37000000000000e-09 2.38000000000000e-09 2.39000000000000e-09 2.40000000000000e-09 2.41000000000000e-09 2.42000000000000e-09 2.43000000000000e-09 2.44000000000000e-09 2.45000000000000e-09 2.46000000000000e-09 2.47000000000000e-09 2.48000000000000e-09 2.49000000000000e-09 2.50000000000000e-09 2.51000000000000e-09 2.52000000000000e-09 2.53000000000000e-09 2.54000000000000e-09 2.55000000000000e-09 2.56000000000000e-09 2.57000000000000e-09 2.58000000000000e-09 2.59000000000000e-09 2.60000000000000e-09 2.61000000000000e-09 2.62000000000000e-09 2.63000000000000e-09 2.64000000000000e-09 2.65000000000000e-09 2.66000000000000e-09 2.67000000000000e-09 2.68000000000000e-09 2.69000000000000e-09 2.70000000000000e-09 2.71000000000000e-09 2.72000000000000e-09 2.73000000000000e-09 2.74000000000000e-09 2.75000000000000e-09 2.76000000000000e-09 2.77000000000000e-09 2.78000000000000e-09 2.79000000000000e-09 2.80000000000000e-09 2.81000000000000e-09 2.82000000000000e-09 2.83000000000000e-09 2.84000000000000e-09 2.85000000000000e-09 2.86000000000000e-09 2.87000000000000e-09 2.88000000000000e-09 2.89000000000000e-09 2.90000000000000e-09 2.91000000000000e-09 2.92000000000000e-09 2.93000000000000e-09 2.94000000000000e-09 2.95000000000000e-09 2.96000000000000e-09 2.97000000000000e-09 2.98000000000000e-09 2.99000000000000e-09 3.00000000000000e-09 3.01000000000000e-09 3.02000000000000e-09 3.03000000000000e-09 3.04000000000000e-09 3.05000000000000e-09 3.06000000000000e-09 3.07000000000000e-09 3.08000000000000e-09 3.09000000000000e-09 3.10000000000000e-09 3.11000000000000e-09 3.12000000000000e-09 3.13000000000000e-09 3.14000000000000e-09 3.15000000000000e-09 3.16000000000000e-09 3.17000000000000e-09 3.18000000000000e-09 3.19000000000000e-09 3.20000000000000e-09 3.21000000000000e-09 3.22000000000000e-09 3.23000000000000e-09 3.24000000000000e-09 3.25000000000000e-09 3.26000000000000e-09 3.27000000000000e-09 3.28000000000000e-09 3.29000000000000e-09 3.30000000000000e-09 3.31000000000000e-09 3.32000000000000e-09 3.33000000000000e-09 3.34000000000000e-09 3.35000000000000e-09 3.36000000000000e-09 3.37000000000000e-09 3.38000000000000e-09 3.39000000000000e-09 3.40000000000000e-09 3.41000000000000e-09 3.42000000000000e-09 3.43000000000000e-09 3.44000000000000e-09 3.45000000000000e-09 3.46000000000000e-09 3.47000000000000e-09 3.48000000000000e-09 3.49000000000000e-09 3.50000000000000e-09 3.51000000000000e-09 3.52000000000000e-09 3.53000000000000e-09 3.54000000000000e-09 3.55000000000000e-09 3.56000000000000e-09 3.57000000000000e-09 3.58000000000000e-09 3.59000000000000e-09 3.60000000000000e-09 3.61000000000000e-09 3.62000000000000e-09 3.63000000000000e-09 3.64000000000000e-09 3.65000000000000e-09 3.66000000000000e-09 3.67000000000000e-09 3.68000000000000e-09 3.69000000000000e-09 3.70000000000000e-09 3.71000000000000e-09 3.72000000000000e-09 3.73000000000000e-09 3.74000000000000e-09 3.75000000000000e-09 3.76000000000000e-09 3.77000000000000e-09 3.78000000000000e-09 3.79000000000000e-09 3.80000000000000e-09 3.81000000000000e-09 3.82000000000000e-09 3.83000000000000e-09 3.84000000000000e-09 3.85000000000000e-09 3.86000000000000e-09 3.87000000000000e-09 3.88000000000000e-09 3.89000000000000e-09 3.90000000000000e-09 3.91000000000000e-09 3.92000000000000e-09 3.93000000000000e-09 3.94000000000000e-09 3.95000000000000e-09 3.96000000000000e-09 3.97000000000000e-09 3.98000000000000e-09 3.99000000000000e-09 4.00000000000000e-09 4.01000000000000e-09 4.02000000000000e-09 4.03000000000000e-09 4.04000000000000e-09 4.05000000000000e-09 4.06000000000000e-09 4.07000000000000e-09 4.08000000000000e-09 4.09000000000000e-09 4.10000000000000e-09 4.11000000000000e-09 4.12000000000000e-09 4.13000000000000e-09 4.14000000000000e-09 4.15000000000000e-09 4.16000000000000e-09 4.17000000000000e-09 4.18000000000000e-09 4.19000000000000e-09 4.20000000000000e-09 4.21000000000000e-09 4.22000000000000e-09 4.23000000000000e-09 4.24000000000000e-09 4.25000000000000e-09 4.26000000000000e-09 4.27000000000000e-09 4.28000000000000e-09 4.29000000000000e-09 4.30000000000000e-09 4.31000000000000e-09 4.32000000000000e-09 4.33000000000000e-09 4.34000000000000e-09 4.35000000000000e-09 4.36000000000000e-09 4.37000000000000e-09 4.38000000000000e-09 4.39000000000000e-09 4.40000000000000e-09 4.41000000000000e-09 4.42000000000000e-09 4.43000000000000e-09 4.44000000000000e-09 4.45000000000000e-09 4.46000000000000e-09 4.47000000000000e-09 4.48000000000000e-09 4.49000000000000e-09 4.50000000000000e-09 4.51000000000000e-09 4.52000000000000e-09 4.53000000000000e-09 4.54000000000000e-09 4.55000000000000e-09 4.56000000000000e-09 4.57000000000000e-09 4.58000000000000e-09 4.59000000000000e-09 4.60000000000000e-09 4.61000000000000e-09 4.62000000000000e-09 4.63000000000000e-09 4.64000000000000e-09 4.65000000000000e-09 4.66000000000000e-09 4.67000000000000e-09 4.68000000000000e-09 4.69000000000000e-09 4.70000000000000e-09 4.71000000000000e-09 4.72000000000000e-09 4.73000000000000e-09 4.74000000000000e-09 4.75000000000000e-09 4.76000000000000e-09 4.77000000000000e-09 4.78000000000000e-09 4.79000000000000e-09 4.80000000000000e-09 4.81000000000000e-09 4.82000000000000e-09 4.83000000000000e-09 4.84000000000000e-09 4.85000000000000e-09 4.86000000000000e-09 4.87000000000000e-09 4.88000000000000e-09 4.89000000000000e-09 4.90000000000000e-09 4.91000000000000e-09 4.92000000000000e-09 4.93000000000000e-09 4.94000000000000e-09 4.95000000000000e-09 4.96000000000000e-09 4.97000000000000e-09 4.98000000000000e-09 4.99000000000000e-09 5.00000000000000e-09 5.01000000000000e-09 5.02000000000000e-09 5.03000000000000e-09 5.04000000000000e-09 5.05000000000000e-09 5.06000000000000e-09 5.07000000000000e-09 5.08000000000000e-09 5.09000000000000e-09 5.10000000000000e-09 5.11000000000000e-09 5.12000000000000e-09 5.13000000000000e-09 5.14000000000000e-09 5.15000000000000e-09 5.16000000000000e-09 5.17000000000000e-09 5.18000000000000e-09 5.19000000000000e-09 5.20000000000000e-09 5.21000000000000e-09 5.22000000000000e-09 5.23000000000000e-09 5.24000000000000e-09 5.25000000000000e-09 5.26000000000000e-09 5.27000000000000e-09 5.28000000000000e-09 5.29000000000000e-09 5.30000000000000e-09 5.31000000000000e-09 5.32000000000000e-09 5.33000000000000e-09 5.34000000000000e-09 5.35000000000000e-09 5.36000000000000e-09 5.37000000000000e-09 5.38000000000000e-09 5.39000000000000e-09 5.40000000000000e-09 5.41000000000000e-09 5.42000000000000e-09 5.43000000000000e-09 5.44000000000000e-09 5.45000000000000e-09 5.46000000000000e-09 5.47000000000000e-09 5.48000000000000e-09 5.49000000000000e-09 5.50000000000000e-09 5.51000000000000e-09 5.52000000000000e-09 5.53000000000000e-09 5.54000000000000e-09 5.55000000000000e-09 5.56000000000000e-09 5.57000000000000e-09 5.58000000000000e-09 5.59000000000000e-09 5.60000000000000e-09 5.61000000000000e-09 5.62000000000000e-09 5.63000000000000e-09 5.64000000000000e-09 5.65000000000000e-09 5.66000000000000e-09 5.67000000000000e-09 5.68000000000000e-09 5.69000000000000e-09 5.70000000000000e-09 5.71000000000000e-09 5.72000000000000e-09 5.73000000000000e-09 5.74000000000000e-09 5.75000000000000e-09 5.76000000000000e-09 5.77000000000000e-09 5.78000000000000e-09 5.79000000000000e-09 5.80000000000000e-09 5.81000000000000e-09 5.82000000000000e-09 5.83000000000000e-09 5.84000000000000e-09 5.85000000000000e-09 5.86000000000000e-09 5.87000000000000e-09 5.88000000000000e-09 5.89000000000000e-09 5.90000000000000e-09 5.91000000000000e-09 5.92000000000000e-09 5.93000000000000e-09 5.94000000000000e-09 5.95000000000000e-09 5.96000000000000e-09 5.97000000000000e-09 5.98000000000000e-09 5.99000000000000e-09 6.00000000000000e-09 6.01000000000000e-09 6.02000000000000e-09 6.03000000000000e-09 6.04000000000000e-09 6.05000000000000e-09 6.06000000000000e-09 6.07000000000000e-09 6.08000000000000e-09 6.09000000000000e-09 6.10000000000000e-09 6.11000000000000e-09 6.12000000000000e-09 6.13000000000000e-09 6.14000000000000e-09];
BL2_RelF=[0.000236267465432322 0.000291569314951934 0.000352438336759108 0.000418506553203910 0.000489366727566969 0.000564586938595727 0.000643722528448126 0.000726325720410145 0.000811953218478578 0.000900172090332398 0.000990564210951419 0.00108272951386665 0.00117628826528967 0.00127088254573370 0.00136617709553956 0.00146185965554053 0.00155764091207942 0.00165325413662158 0.00174845459404765 0.00184301878006334 0.00193674353671986 0.00202944508549667 0.00212095800948247 0.00221113420965124 0.00229984185485138 0.00238696434071884 0.00247239926912830 0.00255605745687320 0.00263786197990117 0.00271774725752732 0.00279565817952505 0.00287154927778286 0.00294538394326157 0.00301713368824089 0.00308677745327076 0.00315430095780728 0.00321969609319047 0.00328296035638944 0.00334409632278092 0.00340311115612651 0.00346001615385903 0.00351482632576935 0.00356756000419500 0.00361823848384246 0.00366688568942264 0.00371352786933818 0.00375819331372921 0.00380091209525748 0.00384171583108585 0.00388063746458928 0.00391771106541190 0.00395297164656396 0.00398645499732891 0.00401819753082593 0.00404823614514544 0.00407660809704467 0.00410335088725654 0.00412850215652821 0.00415209959156592 0.00417418084011883 0.00419478343448826 0.00421394472279922 0.00423170180741770 0.00424809148994212 0.00426315022223828 0.00427691406302614 0.00428941863956284 0.00430069911400001 0.00431079015402511 0.00431972590742544 0.00432753998024100 0.00433426541819755 0.00433993469113465 0.00434457968016549 0.00434823166732543 0.00435092132748498 0.00435267872232044 0.00435353329615159 0.00435351387347055 0.00435264865800019 0.00435096523313301 0.00434849056361286 0.00434525099833479 0.00434127227414505 0.00433657952053628 0.00433119726513921 0.00432514943992132 0.00431845938800989 0.00431114987106399 0.00430324307712608 0.00429476062889000 0.00428572359232719 0.00427615248561838 0.00426606728834221 0.00425548745087672 0.00424443190397351 0.00423291906846797 0.00422096686509229 0.00420859272436107 0.00419581359650217 0.00418264596140802 0.00416910583858499 0.00415520879708072 0.00414096996537125 0.00412640404119163 0.00411152530129550 0.00409634761113074 0.00408088443441942 0.00406514884263218 0.00404915352434772 0.00403291079448981 0.00401643260343471 0.00399973054598338 0.00398281587019310 0.00396569948606450 0.00394839197408029 0.00393090359359280 0.00391324429105802 0.00389542370811439 0.00387745118950501 0.00385933579084242 0.00384108628621552 0.00382271117563863 0.00380421869234275 0.00378561680990976 0.00376691324925030 0.00374811548542627 0.00372923075431949 0.00371026605914762 0.00369122817682922 0.00367212366419965 0.00365295886407967 0.00363373991119875 0.00361447273797522 0.00359516308015556 0.00357581648231483 0.00355643830322086 0.00353703372106443 0.00351760773855775 0.00349816518790403 0.00347871073564016 0.00345924888735540 0.00343978399228826 0.00342032024780430 0.00340086170375719 0.00338141226673560 0.00336197570419836 0.00334255564850042 0.00332315560081196 0.00330377893493311 0.00328442890100677 0.00326510862913169 0.00324582113287846 0.00322656931271034 0.00320735595931158 0.00318818375682524 0.00316905528600276 0.00314997302726754 0.00313093936369456 0.00311195658390820 0.00309302688490027 0.00307415237477039 0.00305533507539043 0.00303657692499536 0.00301787978070199 0.00299924542095776 0.00298067554792122 0.00296217178977619 0.00294373570298102 0.00292536877445502 0.00290707242370347 0.00288884800488292 0.00287069680880843 0.00285262006490404 0.00283461894309887 0.00281669455566841 0.00279884795902490 0.00278108015545643 0.00276339209481671 0.00274578467616700 0.00272825874937122 0.00271081511664572 0.00269345453406480 0.00267617771302335 0.00265898532165768 0.00264187798622563 0.00262485629244730 0.00260792078680724 0.00259107197781934 0.00257431033725539 0.00255763630133822 0.00254105027190064 0.00252455261751088 0.00250814367456561 0.00249182374835141 0.00247559311407553 0.00245945201786684 0.00244340067774779 0.00242743928457823 0.00241156800297173 0.00239578697218541 0.00238009630698378 0.00236449609847749 0.00234898641493761 0.00233356730258614 0.00231823878636344 0.00230300087067323 0.00228785354010571 0.00227279676013960 0.00225783047782340 0.00224295462243685 0.00222816910613271 0.00221347382455981 0.00219886865746760 0.00218435346929289 0.00216992810972927 0.00215559241427963 0.00214134620479225 0.00212718928998106 0.00211312146593039 0.00209914251658462 0.00208525221422333 0.00207145031992218 0.00205773658400000 0.00204411074645253 0.00203057253737307 0.00201712167736048 0.00200375787791499 0.00199048084182189 0.00197729026352377 0.00196418582948135 0.00195116721852350 0.00193823410218646 0.00192538614504281 0.00191262300502037 0.00189994433371131 0.00188734977667183 0.00187483897371253 0.00186241155917992 0.00185006716222919 0.00183780540708850 0.00182562591331510 0.00181352829604346 0.00180151216622566 0.00178957713086419 0.00177772279323755 0.00176594875311862 0.00175425460698624 0.00174263994822996 0.00173110436734842 0.00171964745214129 0.00170826878789509 0.00169696795756310 0.00168574454193936 0.00167459811982716 0.00166352826820196 0.00165253456236903 0.00164161657611594 0.00163077388186005 0.00162000605079107 0.00160931265300893 0.00159869325765708 0.00158814743305128 0.00157767474680408 0.00156727476594509 0.00155694705703720 0.00154669118628872 0.00153650671966183 0.00152639322297715 0.00151635026201473 0.00150637740261155 0.00149647421075548 0.00148664025267607 0.00147687509493199 0.00146717830449537 0.00145754944883310 0.00144798809598519 0.00143849381464024 0.00142906617420811 0.00141970474488995 0.00141040909774553 0.00140117880475806 0.00139201343889656 0.00138291257417576 0.00137387578571377 0.00136490264978739 0.00135599274388533 0.00134714564675917 0.00133836093847241 0.00132963820044740 0.00132097701551034 0.00131237696793449 0.00130383764348141 0.00129535862944053 0.00128693951466698 0.00127857988961769 0.00127027934638594 0.00126203747873434 0.00125385388212620 0.00124572815375556 0.00123765989257565 0.00122964869932607 0.00122169417655856 0.00121379592866148 0.00120595356188306 0.00119816668435335 0.00119043490610510 0.00118275783909333 0.00117513509721393 0.00116756629632113 0.00116005105424385 0.00115258899080118 0.00114517972781676 0.00113782288913223 0.00113051810061984 0.00112326499019403 0.00111606318782228 0.00110891232553505 0.00110181203743491 0.00109476195970493 0.00108776173061631 0.00108081099053518 0.00107390938192886 0.00106705654937127 0.00106025213954779 0.00105349580125944 0.00104678718542640 0.00104012594509103 0.00103351173542019 0.00102694421370712 0.00102042303937268 0.00101394787396613 0.00100751838116540 0.00100113422677682 0.000994795078734481 0.000988500607099036 0.000982250484056135 0.000976044383914414 0.000969881983103077 0.000963762960169095 0.000957686995774013 0.000951653772690414 0.000945662975798014 0.000939714292079430 0.000933807410615620 0.000927942022581012 0.000922117821238334 0.000916334501933150 0.000910591762088125 0.000904889301197021 0.000899226820818430 0.000893604024569280 0.000888020618118077 0.000882476309177954 0.000876970807499471 0.000871503824863230 0.000866075075072287 0.000860684273944362 0.000855331139303884 0.000850015390973849 0.000844736750767520 0.000839494942479967 0.000834289691879453 0.000829120726698678 0.000823987776625894 0.000818890573295872 0.000813828850280762 0.000808802343080838 0.000803810789115107 0.000798853927711846 0.000793931500099014 0.000789043249394591 0.000784188920596804 0.000779368260574295 0.000774581018056198 0.000769826943622141 0.000765105789692189 0.000760417310516713 0.000755761262166217 0.000751137402521082 0.000746545491261287 0.000741985289856076 0.000737456561553566 0.000732959071370341 0.000728492586080998 0.000724056874207657 0.000719651706009453 0.000715276853472002 0.000710932090296842 0.000706617191890852 0.000702331935355666 0.000698076099477069 0.000693849464714379 0.000689651813189834 0.000685482928677963 0.000681342596594966 0.000677230603988079 0.000673146739524962 0.000669090793483084 0.000665062557739105 0.000661061825758289 0.000657088392583908 0.000653142054826682 0.000649222610654209 0.000645329859780433 0.000641463603455132 0.000637623644453404 0.000633809787065205 0.000630021837084895 0.000626259601800810 0.000622522889984870 0.000618811511882204 0.000615125279200823 0.000611464005101300 0.000607827504186502 0.000604215592491358 0.000600628087472638 0.000597064807998797 0.000593525574339840 0.000590010208157229 0.000586518532493828 0.000583050371763889 0.000579605551743085 0.000576183899558572 0.000572785243679105 0.000569409413905191 0.000566056241359297 0.000562725558476081 0.000559417198992693 0.000556130997939112 0.000552866791628518 0.000549624417647737 0.000546403714847713 0.000543204523334031 0.000540026684457500 0.000536870040804776 0.000533734436189039 0.000530619715640712 0.000527525725398244 0.000524452312898935 0.000521399326769812 0.000518366616818560 0.000515354034024503 0.000512361430529642 0.000509388659629731 0.000506435575765427 0.000503502034513472 0.000500587892577943 0.000497693007781546 0.000494817239056967 0.000491960446438278 0.000489122491052392 0.000486303235110572 0.000483502541900003 0.000480720275775400 0.000477956302150687 0.000475210487490722 0.000472482699303075 0.000469772806129860 0.000467080677539627 0.000464406184119298 0.000461749197466164 0.000459109590179935 0.000456487235854841 0.000453882009071786 0.000451293785390560 0.000448722441342101 0.000446167854420813 0.000443629903076932 0.000441108466708953 0.000438603425656104 0.000436114661190873 0.000433642055511594 0.000431185491735076 0.000428744853889296 0.000426320026906134 0.000423910896614164 0.000421517349731503 0.000419139273858698 0.000416776557471681 0.000414429089914764 0.000412096761393690 0.000409779462968730 0.000407477086547843 0.000405189524879872 0.000402916671547799 0.000400658420962050 0.000398414668353850 0.000396185309768620 0.000393970242059436 0.000391769362880532 0.000389582570680848 0.000387409764697631 0.000385250844950088 0.000383105712233081 0.000380974268110871 0.000378856414910918 0.000376752055717716 0.000374661094366687 0.000372583435438114 0.000370518984251127 0.000368467646857732 0.000366429330036884 0.000364403941288616 0.000362391388828202 0.000360391581580374 0.000358404429173579 0.000356429841934285 0.000354467730881333 0.000352518007720324 0.000350580584838064 0.000348655375297043 0.000346742292829960 0.000344841251834296 0.000342952167366922 0.000341074955138758 0.000339209531509470 0.000337355813482211 0.000335513718698401 0.000333683165432556 0.000331864072587150 0.000330056359687523 0.000328259946876832 0.000326474754911036 0.000324700705153927 0.000322937719572200 0.000321185720730563 0.000319444631786883 0.000317714376487377 0.000315994879161840 0.000314286064718907 0.000312587858641365 0.000310900186981486 0.000309222976356418 0.000307556153943595 0.000305899647476200 0.000304253385238655 0.000302617296062148 0.000300991309320206 0.000299375354924294 0.000297769363319454 0.000296173265479981 0.000294586992905135 0.000293010477614882 0.000291443652145682 0.000289886449546295 0.000288338803373640 0.000286800647688676 0.000285271917052317 0.000283752546521389 0.000282242471644611 0.000280741628458620 0.000279249953484014 0.000277767383721442 0.000276293856647721 0.000274829310211983 0.000273373682831854 0.000271926913389671 0.000270488941228724 0.000269059706149530 0.000267639148406142 0.000266227208702481 0.000264823828188711 0.000263428948457629 0.000262042511541098 0.000260664459906501 0.000259294736453230 0.000257933284509201 0.000256580047827400 0.000255234970582456 0.000253897997367247 0.000252569073189525 0.000251248143468582 0.000249935154031931 0.000248630051112025 0.000247332781342997 0.000246043291757430 0.000244761529783155 0.000243487443240070 0.000242220980336996 0.000240962089668547 0.000239710720212036 0.000238466821324403 0.000237230342739167 0.000236001234563407 0.000234779447274768 0.000233564931718487 0.000232357639104451 0.000231157521004276 0.000229964529348409 0.000228778616423258 0.000227599734868343 0.000226427837673474 0.000225262878175947 0.000224104810057771 0.000222953587342913 0.000221809164394567 0.000220671495912447 0.000219540536930101 0.000218416242812251 0.000217298569252150];
BL3_Radius=[2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09];
BL3_RelF=[0.000991922725742116 0.00126950881859891 0.00158957969347513 0.00195174967867730 0.00235466333943661 0.00279607481300693 0.00327295416783945 0.00378161151979529 0.00431783053746123 0.00487700418930374 0.00545426694219860 0.00604461897867165 0.00664303926817046 0.00724458545127054 0.00784447944811217 0.00843817847687832 0.00902143177166316 0.00959032373696235 0.0101413045880561 0.0106712097242496 0.0111772691865477 0.0116571085826837 0.0121087428381945 0.0125305640676649 0.0129213247681394 0.0132801174273779 0.0136063515213639 0.0138997287545712 0.0141602172776757 0.0143880255040177 0.0145835760404395 0.0147474801515274 0.0148805130894943 0.0149835905451345 0.0150577464082960 0.0151041119686994 0.0151238966390612 0.0151183702416418 0.0150888468657334 0.0150366702764567 0.0149632008337595 0.0148698038639621 0.0147578394138894 0.0146286533089145 0.0144835694305542 0.0143238831260705 0.0141508556613972 0.0139657096292279 0.0137696252259140 0.0135637373136463 0.0133491331879697 0.0131268509747922 0.0128978785855296 0.0126631531637204 0.0124235609612336 0.0121799375869866 0.0119330685758072 0.0116836902296561 0.0114324906878382 0.0111801111870274 0.0109271474759016 0.0106741513529063 0.0104216322991452 0.0101700591816123 0.00991986200495950 0.00967143369271536 0.00942513188137301 0.00918128071302769 0.00894017261430499 0.00870207005117457 0.00846720725091217 0.00823579188396492 0.00800800669980592 0.00778401111204468 0.00756394272910268 0.00734791882768555 0.00713603776708024 0.00692838034301288 0.00672501108040456 0.00652597946488529 0.00633132111337193 0.00614105888439266 0.00595520392915731 0.00577375668463549 0.00559670781011824 0.00542403906891188 0.00525572415694693 0.00509172948018771 0.00493201488280167 0.00477653432809701 0.00462523653426453 0.00447806556696946 0.00433496139083276 0.00419586038182212 0.00406069580254252 0.00392939824237671 0.00380189602437900 0.00367811558077254 0.00355798179884273 0.00344141833895787 0.00332834792638403 0.00321869261849567 0.00311237404891616 0.00300931365005557 0.00290943285544541 0.00281265328320380 0.00271889690189840 0.00262808618001026 0.00254014422013857 0.00245499487902508 0.00237256287441730 0.00229277387973262 0.00221555460742937 0.00214083288193836 0.00206853770295670 0.00199859929985729 0.00193094917792044 0.00186552015704945 0.00180224640359003 0.00174106345583259 0.00168190824373877 0.00162471910339691 0.00156943578667731 0.00151599946652539 0.00146435273830060 0.00141443961753993 0.00136620553449780 0.00131959732578860 0.00127456322343408 0.00123105284159539 0.00118901716124837 0.00114840851304073 0.00110918055855161 0.00107128827015621 0.00103468790968225 0.000999337006029846 0.000965194331912115 0.000932219879860801 0.000900374837628855 0.000869621563110491 0.000839923558888618 0.000811245446509668 0.000783552940576680 0.000756812822742952 0.000730992915680743];
BL4_Radius=[3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10];
BL4_RelF=[0.00273941457490499 0.00382697423645256 0.00518159612906847 0.00681560037619598 0.00872774523288907 0.0109017490763591 0.0133060468390527 0.0158948155486388 0.0186101551557629 0.0213851894694733 0.0241477715034819 0.0268244431160546 0.0293443081065858 0.0316425228332316 0.0336631776190923 0.0353614235224695 0.0367047812854867 0.0376736435497509 0.0382610417196547 0.0384717920614309 0.0383211612022261 0.0378332005552773 0.0370388950552575 0.0359742573093919 0.0346784773483199 0.0331922138234013 0.0315560874578831 0.0298094138975114 0.0279891922482149 0.0261293483603685 0.0242602186421432 0.0224082507902056 0.0205958919731527 0.0188416321829343 0.0171601700947970 0.0155626702490874 0.0140570831284361 0.0126485032593397 0.0113395444096432 0.0101307149626149 0.00902078038821180 0.00800710324227819 0.00708595420821438 0.00625279030783566 0.00550249854259321 0.00482960490488409 0.00422844996213673 0.00369333311466112 0.00321862821741699 0.00279887359149294 0.00242883958581220 0.00210357683101536 0.00181844819720438];
BL6_Radius=[3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10];
BL6_RelF=[0.00325038235298815 0.00520016475228924 0.00789962624543203 0.0114356271809739 0.0158270539491842 0.0210053110016239 0.0268065829165233 0.0329787717928938 0.0392028974890525 0.0451256661502790 0.0503976843846769 0.0547109255728740 0.0578296180482493 0.0596104159159110 0.0600099941162333 0.0590804979461673 0.0569551049173448 0.0538270567973778 0.0499258406135716 0.0454938594649938 0.0407661562008559 0.0359547791482916 0.0312384207253708 0.0267571644939509 0.0226116193660845 0.0188654137554579 0.0155499355177837 0.0126702796821576 0.0102115430737460 0.00814482687759806 0.00643253173532615 0.00503272672275789 0.00390252884261882 0.00300053955404770 0.00228845269531252];
BL7_Radius=[3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10];
BL7_RelF=[0.00453463995551387 0.00703944951286786 0.0103889542716979 0.0146274411423913 0.0197116194295990 0.0254982024658050 0.0317468113371760 0.0381389497313945 0.0443102772404710 0.0498906285552395 0.0545448674076910 0.0580079324964267 0.0601090695835295 0.0607826807997247 0.0600657950845640 0.0580843074814463 0.0550315027076479 0.0511428716809524 0.0466709573413996 0.0418631634630139 0.0369444022229746 0.0321053887277778 0.0274964892169534 0.0232263878532163 0.0193644752293815 0.0159457477060265 0.0129770791171166 0.0104439154752212 0.00831668548262608 0.00655646558622732 0.00511965551557830 0.00396159181506343 0.00303914818895375 0.00231244617433113];
BL8_Radius=[3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10];
BL8_RelF=[0.00423424573374215 0.00680982956500496 0.0103561268339648 0.0149502912314256 0.0205606635675565 0.0270254539670644 0.0340528295799786 0.0412447124540109 0.0481408551949287 0.0542749734385188 0.0592322232343624 0.0626976176978805 0.0644876841844652 0.0645617519586157 0.0630135152175528 0.0600469180178143 0.0559423708226374 0.0510197303078663 0.0456036336509179 0.0399951612293747 0.0344519237177694 0.0291769502935106 0.0243154542625345 0.0199577684008422 0.0161464441422543 0.0128855882896088 0.0101508309625991 0.00789874907764721 0.00607500915363106 0.00462087568654564 0.00347802413788536 0.00259179398748928];
BL9_Radius=[3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10];
BL9_RelF=[0.00329238071250638 0.00548899873407664 0.00862594498778040 0.0128301818732842 0.0181300768131746 0.0244229188748789 0.0314625159113930 0.0388725579947451 0.0461851520030732 0.0528976877674046 0.0585369106726762 0.0627178783210452 0.0651874090935498 0.0658457871985357 0.0647454809771052 0.0620700970036070 0.0580997891457357 0.0531705090264374 0.0476339921854303 0.0418237346777631 0.0360300565516081 0.0304852312264863 0.0253579659479614 0.0207554259197269 0.0167305064389746 0.0132920614105469 0.0104161294359227 0.00805669594619811 0.00615505805150598 0.00464732820948392 0.00346997681577773 0.00256356007160452];
BL10_Radius=[3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10];
BL10_RelF=[0.00549224772533204 0.00869046196540124 0.0129993208941823 0.0184521984541876 0.0249430182086295 0.0322122328340125 0.0398609440878136 0.0473926470122541 0.0542750641698979 0.0600097089947164 0.0641954928530766 0.0665749164591850 0.0670561189911702 0.0657096903393319 0.0627441230554233 0.0584670310274146 0.0532404150703061 0.0474375454129561 0.0414070730124484 0.0354475063373244 0.0297928297573403 0.0246082093494001 0.0199936068231893 0.0159926799200905 0.0126044417673929 0.00979558675323224 0.00751197895861220 0.00568839484912776 0.00425612168068468 0.00314839323586633];
BL2_Radius=BL2_Radius*10^9; %to [nm]
BL3_Radius=BL3_Radius*10^9; %to [nm]
BL4_Radius=BL4_Radius*10^9; %to [nm]
BL6_Radius=BL6_Radius*10^9; %to [nm]
BL7_Radius=BL7_Radius*10^9; %to [nm]
BL8_Radius=BL8_Radius*10^9; %to [nm]
BL9_Radius=BL9_Radius*10^9; %to [nm]
BL10_Radius=BL10_Radius*10^9; %to [nm]

R=[1.79932E+13	2.69454E+13	3.09195E+13	3.43467E+13	3.64823E+13	3.99949E+13	4.0017E+13	4.30734E+13]; %Hydraulic Resistance [1/m]
R_Conf=[4.66561E+11	5.92232E+11	8.29311E+11	8.0695E+11	1.29376E+12	8.4899E+11	9.06552E+11	1.22789E+12]; %95% Confidence Hydraulic Resistance
DXE=[1.86277E-06	1.09604E-06	1.04448E-06	1.1158E-06	1.13942E-06	1.24919E-06	1.24982E-06	1.34527E-06]*10^6; %effective membrane thickness [um]
DXE_Conf=[9.84756E-08	1.18156E-07	6.91234E-08	5.33241E-08	6.75346E-08	4.34364E-08	4.61576E-08	5.51088E-08]*10^6;
MPR=[2.02088E-10	3.60848E-10	4.71899E-10	4.86499E-10	4.78436E-10	4.76412E-10	4.80431E-10	4.79785E-10]*10^9; %mean pore radius [nm]
MPR_Conf=[8.13999E-11	5.83323E-11	2.05757E-11	1.29338E-11	1.83569E-11	1.15529E-11	1.15615E-11	1.56003E-11]*10^9;
PRS=[1.84051E-10	1.62563E-10	9.4521E-11	6.40076E-11	6.33124E-11	5.96858E-11	5.86859E-11	5.79097E-11]*10^9; %pore radius spread [nm]
PRS_Conf=[4.86505E-11	5.36007E-12	1.25634E-11	1.45733E-11	1.94251E-11	1.32866E-11	1.4148E-11	1.87762E-11]*10^9;

%Data from Grooth 2015. Assume: density=1.1kg/L (Khler 2009), sweeling 40%.
Bilayer=[1 2 3 4 5 6];
Adsorption=[0.79 1.72 2.83 4.15 5.80 7.94]; %mg/m^2
Thickness=Adsorption/10^6/1100*10^9*1.35;

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(BL2_Radius,BL2_RelF,'.','MarkerSize',6,'Color',[0,0,0]./255);%'k'
plot(BL3_Radius,BL3_RelF,'.','MarkerSize',6,'Color',[96,58,232]./255);%'b'
plot(BL4_Radius,BL4_RelF,'.','MarkerSize',6,'Color',[230,68,62]./255);%'r'
plot(BL6_Radius,BL6_RelF,'.','MarkerSize',6,'Color',[0,0,0]./255);%'k'
plot(BL8_Radius,BL8_RelF,'.','MarkerSize',6,'Color',[96,58,232]./255);%'b'
plot(BL10_Radius,BL10_RelF,'.','MarkerSize',6,'Color',[230,68,62]./255);%'r'
axis([0.1,10,0,0.08]);
title('PDADMAC/PSS');
yticks([0.02 0.04 0.06 0.08]);
xlabel('Pore Radius [nm]');
set(gca,'FontSize',15)
ylabel('Relative Flux [-]');
ax = gca;
set(gca, 'XScale', 'log')
xticks([0.1 1 10]);

%Spline to guide Eye
s=spline(BL4_Radius,BL4_RelF,BL4_Radius(1):0.002:BL4_Radius(end));
plot(BL4_Radius(1):0.002:BL4_Radius(end),s,'-','Color',[230,68,62]./255);%'r'
s=spline(BL6_Radius,BL6_RelF,BL6_Radius(1):0.002:BL6_Radius(end));
plot(BL6_Radius(1):0.002:BL6_Radius(end),s,'-','Color',[0,0,0]./255);%'k'
s=spline(BL8_Radius,BL8_RelF,BL8_Radius(1):0.002:BL8_Radius(end));
plot(BL8_Radius(1):0.002:BL8_Radius(end),s,'-','Color',[96,58,232]./255);%'b'
s=spline(BL10_Radius,BL10_RelF,BL10_Radius(1):0.002:BL10_Radius(end));
plot(BL10_Radius(1):0.002:BL10_Radius(end),s,'-','Color',[230,68,62]./255);%'r'


BL=[2;3;4;6;7;8;9;10]; %Bilayer number

figure;
hold on;
box on;
pbaspect([1 1 1])
yyaxis left
errorbar(BL,DXE,DXE_Conf,DXE_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
axis([0,12,0,2]);
title('PDADMAC/PSS');
yticks([0.5 1 1.5 2]);
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Effective Membrane Thickness [\mum]');
yyaxis right
plot(Bilayer,Thickness,'.','MarkerSize',16,'Color',[230,68,62]./255);
axis([0,12,0,15]);
ylabel('Thickness from Reflectometry [nm]');
yticks([5 10 15]);
ax = gca;
ax.YAxis(1).Color = 'k';
ax.YAxis(2).Color = 'k';
xticks([2 4 6 8 10]);

%slope_R=(Thickness(end)-Thickness(end-3))/3;
%slope_M=(DXE(end)-DXE(end-4))/4;
%Conf_slope_R=((1/3)^2*(T_Conf(end))^2+(-1/3)^2*(T_Conf(end-3))^2)^(1/2);
%Conf_slope_M=((1/4)^2*(DXE_Conf(end))^2+(-1/4)^2*(DXE_Conf(end-4))^2)^(1/2);
%slope Reflectometer (last 4 points): 4.11nm/BL+-1.131nm/BL
%slope Model after closure: 45.6nm/BL+-17.8nm/BL

%PAHPAA Pore radius and Relative Flux
BL3_Radius=[1.00000000000000e-10 1.10000000000000e-10 1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09 2.09000000000000e-09 2.10000000000000e-09 2.11000000000000e-09 2.12000000000000e-09 2.13000000000000e-09 2.14000000000000e-09 2.15000000000000e-09 2.16000000000000e-09 2.17000000000000e-09 2.18000000000000e-09 2.19000000000000e-09 2.20000000000000e-09 2.21000000000000e-09 2.22000000000000e-09 2.23000000000000e-09 2.24000000000000e-09 2.25000000000000e-09 2.26000000000000e-09 2.27000000000000e-09 2.28000000000000e-09 2.29000000000000e-09 2.30000000000000e-09 2.31000000000000e-09 2.32000000000000e-09 2.33000000000000e-09 2.34000000000000e-09 2.35000000000000e-09 2.36000000000000e-09 2.37000000000000e-09 2.38000000000000e-09 2.39000000000000e-09 2.40000000000000e-09 2.41000000000000e-09 2.42000000000000e-09 2.43000000000000e-09 2.44000000000000e-09 2.45000000000000e-09 2.46000000000000e-09 2.47000000000000e-09 2.48000000000000e-09 2.49000000000000e-09 2.50000000000000e-09 2.51000000000000e-09 2.52000000000000e-09 2.53000000000000e-09 2.54000000000000e-09 2.55000000000000e-09 2.56000000000000e-09 2.57000000000000e-09 2.58000000000000e-09 2.59000000000000e-09 2.60000000000000e-09 2.61000000000000e-09 2.62000000000000e-09 2.63000000000000e-09 2.64000000000000e-09 2.65000000000000e-09 2.66000000000000e-09 2.67000000000000e-09 2.68000000000000e-09 2.69000000000000e-09 2.70000000000000e-09 2.71000000000000e-09 2.72000000000000e-09 2.73000000000000e-09 2.74000000000000e-09 2.75000000000000e-09 2.76000000000000e-09 2.77000000000000e-09 2.78000000000000e-09 2.79000000000000e-09 2.80000000000000e-09 2.81000000000000e-09 2.82000000000000e-09 2.83000000000000e-09 2.84000000000000e-09 2.85000000000000e-09 2.86000000000000e-09 2.87000000000000e-09 2.88000000000000e-09 2.89000000000000e-09 2.90000000000000e-09 2.91000000000000e-09 2.92000000000000e-09 2.93000000000000e-09 2.94000000000000e-09 2.95000000000000e-09 2.96000000000000e-09 2.97000000000000e-09 2.98000000000000e-09 2.99000000000000e-09 3.00000000000000e-09 3.01000000000000e-09 3.02000000000000e-09 3.03000000000000e-09 3.04000000000000e-09 3.05000000000000e-09 3.06000000000000e-09 3.07000000000000e-09 3.08000000000000e-09 3.09000000000000e-09 3.10000000000000e-09 3.11000000000000e-09 3.12000000000000e-09 3.13000000000000e-09 3.14000000000000e-09 3.15000000000000e-09 3.16000000000000e-09 3.17000000000000e-09 3.18000000000000e-09 3.19000000000000e-09 3.20000000000000e-09 3.21000000000000e-09 3.22000000000000e-09 3.23000000000000e-09 3.24000000000000e-09 3.25000000000000e-09 3.26000000000000e-09 3.27000000000000e-09 3.28000000000000e-09 3.29000000000000e-09 3.30000000000000e-09 3.31000000000000e-09 3.32000000000000e-09 3.33000000000000e-09 3.34000000000000e-09 3.35000000000000e-09 3.36000000000000e-09 3.37000000000000e-09 3.38000000000000e-09 3.39000000000000e-09 3.40000000000000e-09 3.41000000000000e-09 3.42000000000000e-09 3.43000000000000e-09 3.44000000000000e-09 3.45000000000000e-09 3.46000000000000e-09 3.47000000000000e-09 3.48000000000000e-09 3.49000000000000e-09 3.50000000000000e-09 3.51000000000000e-09 3.52000000000000e-09 3.53000000000000e-09 3.54000000000000e-09 3.55000000000000e-09 3.56000000000000e-09 3.57000000000000e-09 3.58000000000000e-09 3.59000000000000e-09 3.60000000000000e-09 3.61000000000000e-09 3.62000000000000e-09 3.63000000000000e-09 3.64000000000000e-09 3.65000000000000e-09 3.66000000000000e-09 3.67000000000000e-09 3.68000000000000e-09 3.69000000000000e-09 3.70000000000000e-09 3.71000000000000e-09 3.72000000000000e-09 3.73000000000000e-09 3.74000000000000e-09 3.75000000000000e-09 3.76000000000000e-09 3.77000000000000e-09 3.78000000000000e-09 3.79000000000000e-09 3.80000000000000e-09 3.81000000000000e-09 3.82000000000000e-09 3.83000000000000e-09 3.84000000000000e-09 3.85000000000000e-09 3.86000000000000e-09 3.87000000000000e-09 3.88000000000000e-09 3.89000000000000e-09 3.90000000000000e-09 3.91000000000000e-09 3.92000000000000e-09];
BL3_RelF=[0.000446199146444546 0.000591767477727643 0.000755485586256683 0.000935104181225779 0.00112824042602481 0.00133249562949774 0.00154553821597320 0.00176515939041138 0.00198930798084239 0.00221610979924858 0.00244387576486858 0.00267110207909971 0.00289646495353128 0.00311881176375781 0.00333715001032246 0.00355063509030321 0.00375855759599656 0.00396033064129821 0.00415547755559861 0.00434362016639351 0.00452446780520917 0.00469780710898989 0.00486349264474244 0.00502143835436014 0.00517160979565368 0.00531401714204716 0.00544870889516220 0.00557576626011571 0.00569529813168390 0.00580743663970548 0.00591233320360068 0.00601015504821874 0.00610108213606911 0.00618530447410425 0.00626301975643827 0.00633443130758902 0.00639974629394238 0.00645917417410568 0.00651292536161081 0.00656121007602912 0.00660423736096512 0.00664221424960219 0.00667534506048899 0.00670383080808700 0.00672786871425965 0.00674765180838210 0.00676336860510106 0.00677520284998866 0.00678333332442259 0.00678793370200162 0.00678917244967806 0.00678721276756911 0.00678221256210525 0.00677432444779527 0.00676369577344028 0.00675046866912229 0.00673478011073087 0.00671676199918149 0.00669654125182494 0.00667423990385534 0.00664997521779656 0.00662385979938926 0.00659600171841517 0.00656650463318536 0.00653546791758704 0.00650298678973308 0.00646915244138902 0.00643405216746914 0.00639776949499559 0.00636038431100473 0.00632197298896462 0.00628260851333783 0.00624236060198472 0.00620129582615697 0.00615947772787807 0.00611696693454887 0.00607382127065253 0.00603009586646468 0.00598584326370172 0.00594111351806403 0.00589595429865140 0.00585041098424527 0.00580452675646778 0.00575834268984028 0.00571189783877501 0.00566522932154196 0.00561837240126329 0.00557136056398933 0.00552422559392008 0.00547699764583748 0.00542970531481752 0.00538237570329419 0.00533503448554849 0.00528770596969715 0.00524041315725638 0.00519317780035610 0.00514602045668012 0.00509896054220694 0.00505201638182566 0.00500520525789977 0.00495854345685119 0.00491204631383504 0.00486572825557441 0.00481960284142275 0.00477368280272000 0.00472798008050667 0.00468250586165835 0.00463727061350163 0.00459228411697005 0.00454755549835747 0.00450309325972408 0.00445890530800837 0.00441499898289709 0.00437138108350284 0.00432805789389763 0.00428503520754878 0.00424231835070211 0.00419991220475534 0.00415782122766351 0.00411604947441620 0.00407460061662507 0.00403347796125883 0.00399268446856103 0.00395222276918493 0.00391209518057825 0.00387230372264935 0.00383285013274506 0.00379373587996926 0.00375496217887001 0.00371653000252212 0.00367844009503056 0.00364069298347966 0.00360328898935137 0.00356622823943539 0.00352951067625283 0.00349313606801409 0.00345710401813097 0.00342141397430209 0.00338606523718989 0.00335105696870662 0.00331638819992637 0.00328205783863894 0.00324806467656109 0.00321440739621989 0.00318108457752231 0.00314809470402454 0.00311543616891403 0.00308310728071659 0.00305110626874049 0.00301943128826894 0.00298808042551176 0.00295705170232664 0.00292634308072019 0.00289595246713799 0.00286587771655307 0.00283611663636145 0.00280666699009308 0.00277752650094631 0.00274869285515349 0.00272016370518507 0.00269193667279925 0.00266400935194386 0.00263637931151701 0.00260904409799261 0.00258200123791666 0.00255524824028001 0.00252878259877299 0.00250260179392704 0.00247670329514838 0.00245108456264839 0.00242574304927532 0.00240067620225159 0.00237588146482089 0.00235135627780911 0.00232709808110282 0.00230310431504901 0.00227937242177956 0.00225589984646377 0.00223268403849250 0.00220972245259588 0.00218701254989920 0.00216455179891832 0.00214233767649812 0.00212036766869618 0.00209863927161435 0.00207714999218044 0.00205589734888239 0.00203487887245697 0.00201409210653524 0.00199353460824651 0.00197320394878297 0.00195309771392653 0.00193321350453985 0.00191354893702305 0.00189410164373775 0.00187486927339999 0.00185584949144341 0.00183703998035421 0.00181843843997899 0.00180004258780710 0.00178185015922837 0.00176385890776756 0.00174606660529673 0.00172847104222632 0.00171107002767636 0.00169386138962833 0.00167684297505909 0.00166001265005733 0.00164336829992376 0.00162690782925560 0.00161062916201633 0.00159453024159134 0.00157860903083023 0.00156286351207654 0.00154729168718539 0.00153189157752980 0.00151666122399624 0.00150159868696998 0.00148670204631083 0.00147196940131973 0.00145739887069674 0.00144298859249090 0.00142873672404242 0.00141464144191763 0.00140070094183713 0.00138691343859746 0.00137327716598686 0.00135979037669525 0.00134645134221892 0.00133325835276030 0.00132020971712294 0.00130730376260227 0.00129453883487218 0.00128191329786785 0.00126942553366503 0.00125707394235609 0.00124485694192295 0.00123277296810726 0.00122082047427798 0.00120899793129657 0.00119730382738002 0.00118573666796182 0.00117429497555120 0.00116297728959067 0.00115178216631214 0.00114070817859164 0.00112975391580292 0.00111891798367002 0.00110819900411894 0.00109759561512847 0.00108710647058049 0.00107673024010965 0.00106646560895264 0.00105631127779715 0.00104626596263061 0.00103632839458881 0.00102649731980441 0.00101677149925561 0.00100714970861486 0.000997630738097763 0.000988213392312302 0.000978896490108354 0.000969678864427640 0.000960559362154095 0.000951536843964803 0.000942610184181447 0.000933778270622432 0.000925040004455630 0.000916394300051866 0.000907840084839145 0.000899376299157666 0.000891001896115677 0.000882715841446182 0.000874517113364546 0.000866404702427025 0.000858377611390246 0.000850434855071664 0.000842575460211023 0.000834798465332837 0.000827102920609916 0.000819487887727953 0.000811952439751196 0.000804495660989201 0.000797116646864713 0.000789814503782655 0.000782588349000250 0.000775437310498301 0.000768360526853606 0.000761357147112549 0.000754426330665847 0.000747567247124483 0.000740779076196808 0.000734061007566829 0.000727412240773690 0.000720831985092332 0.000714319459415355 0.000707873892136060 0.000701494521032688 0.000695180593153860 0.000688931364705184 0.000682746100937084 0.000676624076033779 0.000670564573003478 0.000664566883569736 0.000658630308063992 0.000652754155319289 0.000646937742565142 0.000641180395323597 0.000635481447306421 0.000629840240313459 0.000624256124132142 0.000618728456438119 0.000613256602697035 0.000607839936067434 0.000602477837304775 0.000597169694666568 0.000591914903818608 0.000586712867742311 0.000581562996643133 0.000576464707860077 0.000571417425776261 0.000566420581730565 0.000561473613930317 0.000556575967365036 0.000551727093721211 0.000546926451298103 0.000542173504924575 0.000537467725876927 0.000532808591797728 0.000528195586615652 0.000523628200466287 0.000519105929613921 0.000514628276374289 0.000510194749038279 0.000505804861796581 0.000501458134665268 0.000497154093412309 0.000492892269484998 0.000488672199938281 0.000484493427363996 0.000480355499820984 0.000476257970766098 0.000472200398986058 0.000468182348530191 0.000464203388643997 0.000460263093703577 0.000456361043150877 0.000452496821429765 0.000448670017922913 0.000444880226889489 0.000441127047403640 0.000437410083293765 0.000433728943082554 0.000430083239927811 0.000426472591564019 0.000422896620244666 0.000419354952685305 0.000415847220007351 0.000412373057682596 0.000408932105478445 0.000405524007403851 0.000402148411655953 0.000398804970567399 0.000395493340554353 0.000392213182065172 0.000388964159529748 0.000385745941309505 0.000382558199648045 0.000379400610622434 0.000376272854095116 0.000373174613666456 0.000370105576627897 0.000367065433915725 0.000364053880065433 0.000361070613166683 0.000358115334818848 0.000355187750087137 0.000352287567459286 0.000349414498802821 0.000346568259322862 0.000343748567520494 0.000340955145151670 0.000338187717186652];
BL5_Radius=[8.00000000000000e-11 9.00000000000000e-11 1.00000000000000e-10 1.10000000000000e-10 1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09 2.09000000000000e-09 2.10000000000000e-09 2.11000000000000e-09 2.12000000000000e-09 2.13000000000000e-09 2.14000000000000e-09 2.15000000000000e-09 2.16000000000000e-09 2.17000000000000e-09 2.18000000000000e-09 2.19000000000000e-09 2.20000000000000e-09 2.21000000000000e-09 2.22000000000000e-09 2.23000000000000e-09 2.24000000000000e-09 2.25000000000000e-09 2.26000000000000e-09 2.27000000000000e-09 2.28000000000000e-09 2.29000000000000e-09 2.30000000000000e-09 2.31000000000000e-09 2.32000000000000e-09 2.33000000000000e-09 2.34000000000000e-09 2.35000000000000e-09 2.36000000000000e-09 2.37000000000000e-09 2.38000000000000e-09 2.39000000000000e-09 2.40000000000000e-09 2.41000000000000e-09 2.42000000000000e-09 2.43000000000000e-09 2.44000000000000e-09 2.45000000000000e-09 2.46000000000000e-09 2.47000000000000e-09 2.48000000000000e-09 2.49000000000000e-09 2.50000000000000e-09 2.51000000000000e-09 2.52000000000000e-09 2.53000000000000e-09 2.54000000000000e-09 2.55000000000000e-09 2.56000000000000e-09 2.57000000000000e-09 2.58000000000000e-09 2.59000000000000e-09 2.60000000000000e-09 2.61000000000000e-09 2.62000000000000e-09 2.63000000000000e-09 2.64000000000000e-09 2.65000000000000e-09 2.66000000000000e-09 2.67000000000000e-09 2.68000000000000e-09 2.69000000000000e-09 2.70000000000000e-09 2.71000000000000e-09 2.72000000000000e-09 2.73000000000000e-09 2.74000000000000e-09 2.75000000000000e-09 2.76000000000000e-09];
BL5_RelF=[0.000555342653740018 0.000804600034249503 0.00109662021328409 0.00142538669367797 0.00178423009215145 0.00216636109430737 0.00256523022685681 0.00297475325963036 0.00338943770766246 0.00380443949126579 0.00421557217491335 0.00461928542553993 0.00501262468677710 0.00539318050252320 0.00575903327044197 0.00610869727368802 0.00644106645661540 0.00675536343718291 0.00705109257554937 0.00732799746171344 0.00758602288304651 0.00782528113973699 0.00804602245949637 0.00824860919860859 0.00843349348756570 0.00860119797409497 0.00875229932589836 0.00888741417401477 0.00900718720134072 0.00911228110677441 0.00920336820187630 0.00928112342270799 0.00934621856391620 0.00939931756477248 0.00944107269757937 0.00947212152756133 0.00949308453012062 0.00950456326625081 0.00950713903009521 0.00950137189425867 0.00948780008867800 0.00946693965777456 0.00943928434839303 0.00940530568780092 0.00936545321690397 0.00932015484893114 0.00926981732825589 0.00921482676783404 0.00915554924703006 0.00909233145444073 0.00902550136276596 0.00895536892487545 0.00888222678202114 0.00880635097668877 0.00872800166390302 0.00864742381592950 0.00856484791627869 0.00848049063973644 0.00839455551584079 0.00830723357381392 0.00821870396745529 0.00812913457892124 0.00803868260066673 0.00794749509511841 0.00785570953189172 0.00776345430256527 0.00767084921319046 0.00757800595484821 0.00748502855267131 0.00739201379383605 0.00729905163509263 0.00720622559045327 0.00711361309969330 0.00702128587834541 0.00692931024988245 0.00683774746079134 0.00674665397924215 0.00665608177805114 0.00656607860262825 0.00647668822458694 0.00638795068167891 0.00629990250469926 0.00621257693198818 0.00612600411213540 0.00604021129547211 0.00595522301491391 0.00587106125669600 0.00578774562151927 0.00570529347660678 0.00562372009914340 0.00554303881155557 0.00546326110906345 0.00538439677991929 0.00530645401872530 0.00522943953320570 0.00515335864478861 0.00507821538333642 0.00500401257634527 0.00493075193291878 0.00485843412280462 0.00478705885076818 0.00471662492656260 0.00464713033074128 0.00457857227654544 0.00451094726808710 0.00444425115503594 0.00437847918400731 0.00431362604683769 0.00424968592592404 0.00418665253679381 0.00412451916806281 0.00406327871893011 0.00400292373435043 0.00394344643801681 0.00388483876327917 0.00382709238211708 0.00377019873227876 0.00371414904269183 0.00365893435724560 0.00360454555703902 0.00355097338118315 0.00349820844624199 0.00344624126439093 0.00339506226036731 0.00334466178728383 0.00329503014137116 0.00324615757571249 0.00319803431302935 0.00315065055757453 0.00310399650618469 0.00305806235854252 0.00301283832669531 0.00296831464387408 0.00292448157265518 0.00288132941250348 0.00283884850673458 0.00279702924893066 0.00275586208884344 0.00271533753781495 0.00267544617374578 0.00263617864563842 0.00259752567774167 0.00255947807332093 0.00252202671807747 0.00248516258323850 0.00244887672833885 0.00241316030371350 0.00237800455271944 0.00234340081370401 0.00230934052173614 0.00227581521011566 0.00224281651167526 0.00221033615988868 0.00217836598979795 0.00214689793877178 0.00211592404710645 0.00208543645847998 0.00205542742026962 0.00202588928374219 0.00199681450412621 0.00196819564057425 0.00194002535602343 0.00191229641696147 0.00188500169310546 0.00185813415699971 0.00183168688353916 0.00180565304942393 0.00178002593255072 0.00175479891134599 0.00172996546404603 0.00170551916792817 0.00168145369849771 0.00165776282863425 0.00163444042770156 0.00161148046062414 0.00158887698693406 0.00156662415979108 0.00154471622497892 0.00152314751988052 0.00150191247243462 0.00148100560007657 0.00146042150866456 0.00144015489139474 0.00142020052770598 0.00140055328217684 0.00138120810341601 0.00136216002294806 0.00134340415409588 0.00132493569086117 0.00130674990680428 0.00128884215392458 0.00127120786154250 0.00125384253518414 0.00123674175546956 0.00121990117700552 0.00120331652728342 0.00118698360558340 0.00117089828188500 0.00115505649578528 0.00113945425542474 0.00112408763642175 0.00110895278081588 0.00109404589602056 0.00107936325378554 0.00106490118916939 0.00105065609952251 0.00103662444348081 0.00102280273997040 0.00100918756722344 0.000995775561805461 0.000982563417654233 0.000969547885130355 0.000956725770079715 0.000944093932907928 0.000931649287666804 0.000919388801152937 0.000907309492018484 0.000895408429894111 0.000883682734524203 0.000872129574914267 0.000860746168490572 0.000849529780272001 0.000838477722054048 0.000827587351604969 0.000816856071873997 0.000806281330211592 0.000795860617601629 0.000785591467905474 0.000775471457117862 0.000765498202634465 0.000755669362531104 0.000745982634854445 0.000736435756924133 0.000727026504646224 0.000717752691837798 0.000708612169562670 0.000699602825478037 0.000690722583191983 0.000681969401631683 0.000673341274422195 0.000664836229275726 0.000656452327391200 0.000648187662864056 0.000640040362106086 0.000632008583275220 0.000624090515715107 0.000616284379404361 0.000608588424415337 0.000601000930382298 0.000593520205978855 0.000586144588404514 0.000578872442880230 0.000571702162152808 0.000564632166008030 0.000557660900792374 0.000550786838943179 0.000544008478527154 0.000537324342787060 0.000530732979696472 0.000524232961522468 0.000517822884396124 0.000511501367890698 0.000505267054607358 0.000499118609768343 0.000493054720817437 0.000487074097027613 0.000481175469115758 0.000475357588864330 0.000469619228749846];
BL7_Radius=[1.00000000000000e-10 1.10000000000000e-10 1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09];
BL7_RelF=[0.00131846897637750 0.00198500048131254 0.00280149511687418 0.00375333103180449 0.00481892581974885 0.00597238246499763 0.00718587624540621 0.00843160513800347 0.00968325243160248 0.0109169865494739 0.0121120622171326 0.0132511015349645 0.0143201331232045 0.0153084592881439 0.0162084096486486 0.0170150275732472 0.0177257245770050 0.0183399281851003 0.0188587408813496 0.0192846215572410 0.0196210961652700 0.0198725008181272 0.0200437581202409 0.0201401858500791 0.0201673360418974 0.0201308618892325 0.0200364095857766 0.0198895321361886 0.0196956222367697 0.0194598614892514 0.0191871834304499 0.0188822481078888 0.0185494261870344 0.0181927908263702 0.0178161157938024 0.0174228785169254 0.0170162669580263 0.0165991893815937 0.0161742862378729 0.0157439435217344 0.0153103070832894 0.0148752974669880 0.0144406249411471 0.0140078044517209 0.0135781702943123 0.0131528903484706 0.0127329797596363 0.0123193139879436 0.0119126411705846 0.0115135937665722 0.0111226994703591 0.0107403913946174 0.0103670175332072 0.0100028495234849 0.00964809073311249 0.00930288370079375 0.00896731696323361 0.00864143130235281 0.00832522544763454 0.00801866126861820 0.00772166849214842 0.00743414897816669 0.00715598058670422 0.00688702066738518 0.00662710920124998 0.00637607162311537 0.00613372135104578 0.00589986204785426 0.00567428963790990 0.00545679410092048 0.00524716106280145 0.00504517320224633 0.00485061149018598 0.00466325627797051 0.00448288824883109 0.00430928924597939 0.00414224298958033 0.00398153569378762 0.00382695659405897 0.00367829839406585 0.00353535764067892 0.00339793503474018 0.00326583568462385 0.00313886930893650 0.00301685039410795 0.00289959831207631 0.00278693740276950 0.00267869702562477 0.00257471158397148 0.00247482052571896 0.00237886832344435 0.00228670443665877 0.00219818325874287 0.00211316405078167 0.00203151086429234 0.00195309245462342 0.00187778218661061 0.00180545793389797 0.00173600197317532 0.00166930087443891 0.00160524538825362 0.00154373033087839 0.00148465446801195 0.00142792039782169 0.00137343443383395 0.00132110648818808 0.00127084995568880 0.00122258159903022 0.00117622143551092 0.00113169262551050 0.00108892136295503 0.00104783676796034 0.00100837078180771 0.000970458064376435];
BL9_Radius=[2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10];
BL9_RelF=[0.00512440442517933 0.0109956533406411 0.0206329697033460 0.0343104063865856 0.0511536973194324 0.0690849727728966 0.0852909230427790 0.0970400884073869 0.102485732274128 0.101121202302328 0.0937563326017788 0.0821103206154100 0.0682448316875520 0.0540575246337627 0.0409659007770753 0.0298043886675275 0.0208835124922998 0.0141333300819076 0.00926287551064072 0.00589321622551534 0.00364771673182755];
BL10_Radius=[2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10];
BL10_RelF=[0.0273045585362050 0.0637941586265032 0.114293079397291 0.160731996851458 0.181179452359669 0.166797603521648 0.127549962131816 0.0822620377678855 0.0453663104782678 0.0216624682868916 0.00905837204236444];
BL11_Radius=[2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10];
BL11_RelF=[0.0267228163423874 0.0613666951373676 0.109235298781992 0.154140934697218 0.175919997321335 0.165339817281321 0.130060143042845 0.0868892796531668 0.0499557920900858 0.0250153665991656 0.0110294577394420 0.00432440131367354];
BL12_Radius=[2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10];
BL12_RelF=[0.00890621994969076 0.0274935265229225 0.0635956966940763 0.113123887503303 0.158363702891228 0.178122451000426 0.163986790402821 0.125656560477442 0.0813574079844138 0.0451198672397685 0.0217002821428234 0.00915302271486697 0.00342058447621816];
BL14_Radius=[3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10];
BL14_RelF=[0.0366463241008687 0.0903045713396875 0.159012460903811 0.205876061482906 0.201083972937058 0.151631137719980 0.0901398010335543 0.0430516219031849 0.0168066243929081 0.00544742418604227];
BL3_Radius=BL3_Radius*10^9; %to [nm]
BL5_Radius=BL5_Radius*10^9; %to [nm]
BL7_Radius=BL7_Radius*10^9; %to [nm]
BL9_Radius=BL9_Radius*10^9; %to [nm]
BL10_Radius=BL10_Radius*10^9; %to [nm]
BL11_Radius=BL11_Radius*10^9; %to [nm]
BL12_Radius=BL12_Radius*10^9; %to [nm]
BL14_Radius=BL14_Radius*10^9; %to [nm]

R=[9.77211E+13	1.43623E+14	2.22864E+14	3.03306E+14	3.7686E+14	4.71214E+14	5.3011E+14	6.32875E+14]; %Hydraulic Resistance [1/m]
R_Conf=[4.07521E+12	3.55762E+12	3.40568E+12	8.00767E+12	1.41906E+13	1.52228E+13	1.58363E+13	3.35242E+13]; %95% Confidence Hydraulic Resistance
DXE=[4.40082E-06	3.81164E-06	3.22219E-06	4.12605E-06	5.11417E-06	6.39398E-06	7.19315E-06	8.58757E-06]*10^6; %effective membrane thickness [um]
DXE_Conf=[1.87395E-07	1.59023E-07	1.25455E-07	1.17425E-07	1.14826E-07	1.30487E-07	1.32991E-07	2.37067E-07]*10^6;
MPR=[1.37545E-10	1.19885E-10	1.71121E-10	3.21684E-10	3.26953E-10	3.27676E-10	3.26869E-10	3.31277E-10]*10^9; %mean pore radius [nm]
MPR_Conf=[7.56253E-11	5.26709E-11	4.01967E-11	9.60985E-12	1.04886E-11	1.12445E-11	7.3294E-12	1.79929E-11]*10^9;
PRS=[1.23115E-10	1.00982E-10	9.5993E-11	3.76069E-11	2.19054E-11	2.24544E-11	2.20204E-11	1.88264E-11]*10^9; %pore radius spread [nm]
PRS_Conf=[4.43538E-11	2.80119E-11	8.54978E-12	9.97971E-12	1.53209E-11	1.49186E-11	1.11802E-11	2.80693E-11]*10^9;

%Data from Regenspurg 2021. Assume: density=1.1kg/L (Khler 2009), swelling 90%.
Bilayer=[1 2 3 4 5 6 7 8];
Adsorption=[0.8754 2.15411 4.9348 9.83619 18.38418 29.44906 39.35467 57.12342]; %mg/m^2
Thickness=Adsorption/10^6/1100*10^9*1.35;
T_Conf=[0.07237 0.09206 0.09391 0.1881 0.48168 0.35148 0.70959 0.37273]/10^6/1100*1.9*10^9;

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(BL3_Radius,BL3_RelF,'.','MarkerSize',6,'Color',[0,0,0]./255);%'k'
plot(BL5_Radius,BL5_RelF,'.','MarkerSize',6,'Color',[96,58,232]./255);%'b'
plot(BL7_Radius,BL7_RelF,'.','MarkerSize',6,'Color',[230,68,62]./255);%'r'
plot(BL9_Radius,BL9_RelF,'.','MarkerSize',6,'Color',[0,0,0]./255);%'k'
plot(BL10_Radius,BL10_RelF,'.','MarkerSize',6,'Color',[96,58,232]./255);%'b'
plot(BL14_Radius,BL14_RelF,'.','MarkerSize',6,'Color',[230,68,62]./255);%'r'
axis([0.1,10,0,0.25]);
title('PAH/PAA');
yticks([0.05 0.1 0.15 0.2 0.25]);
xlabel('Pore Radius [nm]');
set(gca,'FontSize',15)
ylabel('Relative Flux [-]');
ax = gca;
set(gca, 'XScale', 'log')
xticks([0.1 1 10]);

%Spline to guide Eye
s=spline(BL9_Radius,BL9_RelF,BL9_Radius(1):0.002:BL9_Radius(end));
plot(BL9_Radius(1):0.002:BL9_Radius(end),s,'-','Color',[0,0,0]./255);%'k'
s=spline(BL10_Radius,BL10_RelF,BL10_Radius(1):0.002:BL10_Radius(end));
plot(BL10_Radius(1):0.002:BL10_Radius(end),s,'-','Color',[96,58,232]./255);%'b'
s=spline(BL14_Radius,BL14_RelF,BL14_Radius(1):0.002:BL14_Radius(end));
plot(BL14_Radius(1):0.002:BL14_Radius(end),s,'-','Color',[230,68,62]./255);%'r'

BL=[3;5;7;9;10;11;12;14]; %Bilayer number

figure;
hold on;
box on;
pbaspect([1 1 1])
yyaxis left
errorbar(BL,DXE,DXE_Conf,DXE_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
axis([0,16,0,20]);
title('PAH/PAA');
yticks([5 10 15 20]);
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Effective Membrane Thickness [\mum]');
yyaxis right
errorbar(Bilayer,Thickness,T_Conf,T_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
axis([0,16,0,150]);
ylabel('Thickness from Reflectometry [nm]');
yticks([50 100 150]);
ax = gca;
ax.YAxis(1).Color = 'k';
ax.YAxis(2).Color = 'k';
xticks([2 4 6 8 10 12 14]);

%slope_R=(Thickness(end)-Thickness(end-3))/3;
%slope_M=(DXE(end)-DXE(end-4))/5;
%Conf_slope_R=((1/3)^2*(T_Conf(end))^2+(-1/3)^2*(T_Conf(end-3))^2)^(1/2);
%Conf_slope_M=((1/5)^2*(DXE_Conf(end))^2+(-1/5)^2*(DXE_Conf(end-4))^2)^(1/2);
%slope Reflectometer (last 4 points): 34.28nm/BL+-19.59nm/BL
%slope Model after closure: 805nm/BL+-157.6nm/BL

%% Log-Normal Distribution Fit Correlation 1 (Murugaiah)
%PDADMACPSS Pore radius and Relative Flux
BL2_Radius=[8.00000000000000e-11 9.00000000000000e-11 1.00000000000000e-10 1.10000000000000e-10 1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09 2.09000000000000e-09 2.10000000000000e-09 2.11000000000000e-09 2.12000000000000e-09 2.13000000000000e-09 2.14000000000000e-09 2.15000000000000e-09 2.16000000000000e-09 2.17000000000000e-09 2.18000000000000e-09 2.19000000000000e-09 2.20000000000000e-09 2.21000000000000e-09 2.22000000000000e-09 2.23000000000000e-09 2.24000000000000e-09 2.25000000000000e-09 2.26000000000000e-09 2.27000000000000e-09 2.28000000000000e-09 2.29000000000000e-09 2.30000000000000e-09 2.31000000000000e-09 2.32000000000000e-09 2.33000000000000e-09 2.34000000000000e-09 2.35000000000000e-09 2.36000000000000e-09 2.37000000000000e-09 2.38000000000000e-09 2.39000000000000e-09 2.40000000000000e-09 2.41000000000000e-09 2.42000000000000e-09 2.43000000000000e-09 2.44000000000000e-09 2.45000000000000e-09 2.46000000000000e-09 2.47000000000000e-09 2.48000000000000e-09 2.49000000000000e-09 2.50000000000000e-09 2.51000000000000e-09 2.52000000000000e-09 2.53000000000000e-09 2.54000000000000e-09 2.55000000000000e-09 2.56000000000000e-09 2.57000000000000e-09 2.58000000000000e-09 2.59000000000000e-09 2.60000000000000e-09 2.61000000000000e-09 2.62000000000000e-09 2.63000000000000e-09 2.64000000000000e-09 2.65000000000000e-09 2.66000000000000e-09 2.67000000000000e-09 2.68000000000000e-09 2.69000000000000e-09 2.70000000000000e-09 2.71000000000000e-09 2.72000000000000e-09 2.73000000000000e-09 2.74000000000000e-09 2.75000000000000e-09 2.76000000000000e-09 2.77000000000000e-09 2.78000000000000e-09 2.79000000000000e-09 2.80000000000000e-09 2.81000000000000e-09 2.82000000000000e-09 2.83000000000000e-09 2.84000000000000e-09 2.85000000000000e-09 2.86000000000000e-09 2.87000000000000e-09 2.88000000000000e-09 2.89000000000000e-09 2.90000000000000e-09 2.91000000000000e-09 2.92000000000000e-09 2.93000000000000e-09 2.94000000000000e-09 2.95000000000000e-09 2.96000000000000e-09 2.97000000000000e-09 2.98000000000000e-09 2.99000000000000e-09 3.00000000000000e-09 3.01000000000000e-09 3.02000000000000e-09 3.03000000000000e-09 3.04000000000000e-09 3.05000000000000e-09 3.06000000000000e-09 3.07000000000000e-09 3.08000000000000e-09 3.09000000000000e-09 3.10000000000000e-09 3.11000000000000e-09 3.12000000000000e-09 3.13000000000000e-09 3.14000000000000e-09 3.15000000000000e-09 3.16000000000000e-09 3.17000000000000e-09 3.18000000000000e-09 3.19000000000000e-09 3.20000000000000e-09 3.21000000000000e-09 3.22000000000000e-09 3.23000000000000e-09 3.24000000000000e-09 3.25000000000000e-09 3.26000000000000e-09 3.27000000000000e-09 3.28000000000000e-09 3.29000000000000e-09 3.30000000000000e-09 3.31000000000000e-09 3.32000000000000e-09 3.33000000000000e-09 3.34000000000000e-09 3.35000000000000e-09 3.36000000000000e-09 3.37000000000000e-09 3.38000000000000e-09 3.39000000000000e-09 3.40000000000000e-09 3.41000000000000e-09 3.42000000000000e-09 3.43000000000000e-09 3.44000000000000e-09 3.45000000000000e-09 3.46000000000000e-09 3.47000000000000e-09 3.48000000000000e-09 3.49000000000000e-09 3.50000000000000e-09 3.51000000000000e-09 3.52000000000000e-09 3.53000000000000e-09 3.54000000000000e-09 3.55000000000000e-09 3.56000000000000e-09 3.57000000000000e-09 3.58000000000000e-09 3.59000000000000e-09 3.60000000000000e-09 3.61000000000000e-09 3.62000000000000e-09 3.63000000000000e-09 3.64000000000000e-09 3.65000000000000e-09 3.66000000000000e-09 3.67000000000000e-09 3.68000000000000e-09 3.69000000000000e-09 3.70000000000000e-09 3.71000000000000e-09 3.72000000000000e-09 3.73000000000000e-09 3.74000000000000e-09 3.75000000000000e-09 3.76000000000000e-09 3.77000000000000e-09 3.78000000000000e-09 3.79000000000000e-09 3.80000000000000e-09 3.81000000000000e-09 3.82000000000000e-09 3.83000000000000e-09 3.84000000000000e-09 3.85000000000000e-09 3.86000000000000e-09 3.87000000000000e-09 3.88000000000000e-09 3.89000000000000e-09 3.90000000000000e-09 3.91000000000000e-09 3.92000000000000e-09 3.93000000000000e-09 3.94000000000000e-09 3.95000000000000e-09 3.96000000000000e-09 3.97000000000000e-09 3.98000000000000e-09 3.99000000000000e-09 4.00000000000000e-09 4.01000000000000e-09 4.02000000000000e-09 4.03000000000000e-09 4.04000000000000e-09 4.05000000000000e-09 4.06000000000000e-09 4.07000000000000e-09 4.08000000000000e-09 4.09000000000000e-09 4.10000000000000e-09 4.11000000000000e-09 4.12000000000000e-09 4.13000000000000e-09 4.14000000000000e-09 4.15000000000000e-09 4.16000000000000e-09 4.17000000000000e-09 4.18000000000000e-09 4.19000000000000e-09 4.20000000000000e-09 4.21000000000000e-09 4.22000000000000e-09 4.23000000000000e-09 4.24000000000000e-09 4.25000000000000e-09 4.26000000000000e-09 4.27000000000000e-09 4.28000000000000e-09 4.29000000000000e-09 4.30000000000000e-09 4.31000000000000e-09 4.32000000000000e-09 4.33000000000000e-09 4.34000000000000e-09 4.35000000000000e-09 4.36000000000000e-09 4.37000000000000e-09 4.38000000000000e-09 4.39000000000000e-09 4.40000000000000e-09 4.41000000000000e-09 4.42000000000000e-09 4.43000000000000e-09 4.44000000000000e-09 4.45000000000000e-09 4.46000000000000e-09 4.47000000000000e-09 4.48000000000000e-09 4.49000000000000e-09 4.50000000000000e-09 4.51000000000000e-09 4.52000000000000e-09 4.53000000000000e-09 4.54000000000000e-09 4.55000000000000e-09 4.56000000000000e-09 4.57000000000000e-09 4.58000000000000e-09 4.59000000000000e-09 4.60000000000000e-09 4.61000000000000e-09 4.62000000000000e-09 4.63000000000000e-09 4.64000000000000e-09 4.65000000000000e-09 4.66000000000000e-09 4.67000000000000e-09 4.68000000000000e-09 4.69000000000000e-09 4.70000000000000e-09 4.71000000000000e-09 4.72000000000000e-09 4.73000000000000e-09 4.74000000000000e-09 4.75000000000000e-09 4.76000000000000e-09 4.77000000000000e-09 4.78000000000000e-09 4.79000000000000e-09 4.80000000000000e-09 4.81000000000000e-09 4.82000000000000e-09 4.83000000000000e-09 4.84000000000000e-09 4.85000000000000e-09 4.86000000000000e-09 4.87000000000000e-09 4.88000000000000e-09 4.89000000000000e-09 4.90000000000000e-09 4.91000000000000e-09 4.92000000000000e-09 4.93000000000000e-09 4.94000000000000e-09 4.95000000000000e-09 4.96000000000000e-09 4.97000000000000e-09 4.98000000000000e-09 4.99000000000000e-09 5.00000000000000e-09 5.01000000000000e-09 5.02000000000000e-09 5.03000000000000e-09 5.04000000000000e-09 5.05000000000000e-09 5.06000000000000e-09 5.07000000000000e-09 5.08000000000000e-09 5.09000000000000e-09 5.10000000000000e-09 5.11000000000000e-09 5.12000000000000e-09 5.13000000000000e-09 5.14000000000000e-09 5.15000000000000e-09 5.16000000000000e-09 5.17000000000000e-09 5.18000000000000e-09 5.19000000000000e-09 5.20000000000000e-09 5.21000000000000e-09 5.22000000000000e-09 5.23000000000000e-09 5.24000000000000e-09 5.25000000000000e-09 5.26000000000000e-09 5.27000000000000e-09 5.28000000000000e-09 5.29000000000000e-09 5.30000000000000e-09 5.31000000000000e-09 5.32000000000000e-09 5.33000000000000e-09 5.34000000000000e-09 5.35000000000000e-09 5.36000000000000e-09 5.37000000000000e-09 5.38000000000000e-09 5.39000000000000e-09 5.40000000000000e-09 5.41000000000000e-09 5.42000000000000e-09 5.43000000000000e-09 5.44000000000000e-09 5.45000000000000e-09 5.46000000000000e-09 5.47000000000000e-09 5.48000000000000e-09 5.49000000000000e-09 5.50000000000000e-09 5.51000000000000e-09 5.52000000000000e-09 5.53000000000000e-09 5.54000000000000e-09 5.55000000000000e-09 5.56000000000000e-09 5.57000000000000e-09 5.58000000000000e-09 5.59000000000000e-09 5.60000000000000e-09 5.61000000000000e-09 5.62000000000000e-09 5.63000000000000e-09 5.64000000000000e-09 5.65000000000000e-09 5.66000000000000e-09 5.67000000000000e-09 5.68000000000000e-09 5.69000000000000e-09 5.70000000000000e-09 5.71000000000000e-09 5.72000000000000e-09 5.73000000000000e-09 5.74000000000000e-09 5.75000000000000e-09 5.76000000000000e-09 5.77000000000000e-09 5.78000000000000e-09 5.79000000000000e-09 5.80000000000000e-09 5.81000000000000e-09 5.82000000000000e-09 5.83000000000000e-09 5.84000000000000e-09 5.85000000000000e-09 5.86000000000000e-09 5.87000000000000e-09 5.88000000000000e-09 5.89000000000000e-09 5.90000000000000e-09 5.91000000000000e-09 5.92000000000000e-09 5.93000000000000e-09 5.94000000000000e-09 5.95000000000000e-09 5.96000000000000e-09 5.97000000000000e-09 5.98000000000000e-09 5.99000000000000e-09 6.00000000000000e-09 6.01000000000000e-09 6.02000000000000e-09 6.03000000000000e-09 6.04000000000000e-09 6.05000000000000e-09 6.06000000000000e-09 6.07000000000000e-09 6.08000000000000e-09 6.09000000000000e-09 6.10000000000000e-09 6.11000000000000e-09 6.12000000000000e-09 6.13000000000000e-09 6.14000000000000e-09 6.15000000000000e-09 6.16000000000000e-09 6.17000000000000e-09 6.18000000000000e-09 6.19000000000000e-09 6.20000000000000e-09 6.21000000000000e-09 6.22000000000000e-09 6.23000000000000e-09 6.24000000000000e-09 6.25000000000000e-09 6.26000000000000e-09 6.27000000000000e-09 6.28000000000000e-09 6.29000000000000e-09 6.30000000000000e-09 6.31000000000000e-09 6.32000000000000e-09 6.33000000000000e-09 6.34000000000000e-09 6.35000000000000e-09 6.36000000000000e-09 6.37000000000000e-09 6.38000000000000e-09 6.39000000000000e-09 6.40000000000000e-09 6.41000000000000e-09 6.42000000000000e-09 6.43000000000000e-09 6.44000000000000e-09 6.45000000000000e-09 6.46000000000000e-09 6.47000000000000e-09 6.48000000000000e-09 6.49000000000000e-09 6.50000000000000e-09 6.51000000000000e-09 6.52000000000000e-09 6.53000000000000e-09 6.54000000000000e-09 6.55000000000000e-09 6.56000000000000e-09 6.57000000000000e-09 6.58000000000000e-09 6.59000000000000e-09 6.60000000000000e-09 6.61000000000000e-09 6.62000000000000e-09 6.63000000000000e-09 6.64000000000000e-09 6.65000000000000e-09 6.66000000000000e-09 6.67000000000000e-09 6.68000000000000e-09 6.69000000000000e-09 6.70000000000000e-09 6.71000000000000e-09 6.72000000000000e-09 6.73000000000000e-09 6.74000000000000e-09 6.75000000000000e-09 6.76000000000000e-09 6.77000000000000e-09 6.78000000000000e-09 6.79000000000000e-09 6.80000000000000e-09 6.81000000000000e-09 6.82000000000000e-09 6.83000000000000e-09 6.84000000000000e-09 6.85000000000000e-09 6.86000000000000e-09 6.87000000000000e-09 6.88000000000000e-09 6.89000000000000e-09 6.90000000000000e-09 6.91000000000000e-09 6.92000000000000e-09 6.93000000000000e-09 6.94000000000000e-09 6.95000000000000e-09 6.96000000000000e-09 6.97000000000000e-09 6.98000000000000e-09 6.99000000000000e-09 7.00000000000000e-09 7.01000000000000e-09 7.02000000000000e-09 7.03000000000000e-09 7.04000000000000e-09 7.05000000000000e-09 7.06000000000000e-09 7.07000000000000e-09 7.08000000000000e-09 7.09000000000000e-09 7.10000000000000e-09 7.11000000000000e-09 7.12000000000000e-09 7.13000000000000e-09 7.14000000000000e-09 7.15000000000000e-09 7.16000000000000e-09 7.17000000000000e-09 7.18000000000000e-09 7.19000000000000e-09 7.20000000000000e-09 7.21000000000000e-09 7.22000000000000e-09 7.23000000000000e-09 7.24000000000000e-09 7.25000000000000e-09 7.26000000000000e-09 7.27000000000000e-09 7.28000000000000e-09 7.29000000000000e-09 7.30000000000000e-09 7.31000000000000e-09 7.32000000000000e-09 7.33000000000000e-09 7.34000000000000e-09 7.35000000000000e-09 7.36000000000000e-09 7.37000000000000e-09 7.38000000000000e-09 7.39000000000000e-09 7.40000000000000e-09 7.41000000000000e-09 7.42000000000000e-09 7.43000000000000e-09 7.44000000000000e-09 7.45000000000000e-09 7.46000000000000e-09 7.47000000000000e-09 7.48000000000000e-09 7.49000000000000e-09 7.50000000000000e-09 7.51000000000000e-09 7.52000000000000e-09 7.53000000000000e-09 7.54000000000000e-09 7.55000000000000e-09 7.56000000000000e-09 7.57000000000000e-09 7.58000000000000e-09 7.59000000000000e-09 7.60000000000000e-09 7.61000000000000e-09 7.62000000000000e-09 7.63000000000000e-09 7.64000000000000e-09 7.65000000000000e-09 7.66000000000000e-09 7.67000000000000e-09 7.68000000000000e-09 7.69000000000000e-09 7.70000000000000e-09 7.71000000000000e-09 7.72000000000000e-09 7.73000000000000e-09 7.74000000000000e-09 7.75000000000000e-09 7.76000000000000e-09 7.77000000000000e-09 7.78000000000000e-09 7.79000000000000e-09 7.80000000000000e-09 7.81000000000000e-09 7.82000000000000e-09 7.83000000000000e-09 7.84000000000000e-09 7.85000000000000e-09 7.86000000000000e-09 7.87000000000000e-09 7.88000000000000e-09 7.89000000000000e-09 7.90000000000000e-09 7.91000000000000e-09 7.92000000000000e-09 7.93000000000000e-09 7.94000000000000e-09 7.95000000000000e-09 7.96000000000000e-09 7.97000000000000e-09 7.98000000000000e-09 7.99000000000000e-09 8.00000000000000e-09 8.01000000000000e-09 8.02000000000000e-09 8.03000000000000e-09 8.04000000000000e-09 8.05000000000000e-09 8.06000000000000e-09 8.07000000000000e-09 8.08000000000000e-09 8.09000000000000e-09 8.10000000000000e-09 8.11000000000000e-09 8.12000000000000e-09 8.13000000000000e-09 8.14000000000000e-09 8.15000000000000e-09 8.16000000000000e-09 8.17000000000000e-09 8.18000000000000e-09 8.19000000000000e-09 8.20000000000000e-09 8.21000000000000e-09 8.22000000000000e-09 8.23000000000000e-09 8.24000000000000e-09 8.25000000000000e-09 8.26000000000000e-09 8.27000000000000e-09 8.28000000000000e-09 8.29000000000000e-09 8.30000000000000e-09 8.31000000000000e-09 8.32000000000000e-09 8.33000000000000e-09 8.34000000000000e-09 8.35000000000000e-09 8.36000000000000e-09 8.37000000000000e-09 8.38000000000000e-09 8.39000000000000e-09 8.40000000000000e-09 8.41000000000000e-09 8.42000000000000e-09 8.43000000000000e-09 8.44000000000000e-09 8.45000000000000e-09 8.46000000000000e-09 8.47000000000000e-09 8.48000000000000e-09 8.49000000000000e-09 8.50000000000000e-09 8.51000000000000e-09 8.52000000000000e-09 8.53000000000000e-09 8.54000000000000e-09 8.55000000000000e-09 8.56000000000000e-09 8.57000000000000e-09 8.58000000000000e-09 8.59000000000000e-09 8.60000000000000e-09 8.61000000000000e-09 8.62000000000000e-09 8.63000000000000e-09 8.64000000000000e-09 8.65000000000000e-09 8.66000000000000e-09 8.67000000000000e-09 8.68000000000000e-09 8.69000000000000e-09 8.70000000000000e-09 8.71000000000000e-09 8.72000000000000e-09 8.73000000000000e-09 8.74000000000000e-09 8.75000000000000e-09 8.76000000000000e-09 8.77000000000000e-09 8.78000000000000e-09 8.79000000000000e-09 8.80000000000000e-09 8.81000000000000e-09 8.82000000000000e-09 8.83000000000000e-09 8.84000000000000e-09 8.85000000000000e-09 8.86000000000000e-09 8.87000000000000e-09 8.88000000000000e-09 8.89000000000000e-09 8.90000000000000e-09 8.91000000000000e-09 8.92000000000000e-09 8.93000000000000e-09 8.94000000000000e-09 8.95000000000000e-09 8.96000000000000e-09 8.97000000000000e-09 8.98000000000000e-09 8.99000000000000e-09 9.00000000000000e-09 9.01000000000000e-09 9.02000000000000e-09 9.03000000000000e-09 9.04000000000000e-09 9.05000000000000e-09 9.06000000000000e-09 9.07000000000000e-09 9.08000000000000e-09 9.09000000000000e-09 9.10000000000000e-09 9.11000000000000e-09 9.12000000000000e-09 9.13000000000000e-09 9.14000000000000e-09 9.15000000000000e-09 9.16000000000000e-09 9.17000000000000e-09 9.18000000000000e-09 9.19000000000000e-09 9.20000000000000e-09 9.21000000000000e-09 9.22000000000000e-09 9.23000000000000e-09 9.24000000000000e-09 9.25000000000000e-09 9.26000000000000e-09 9.27000000000000e-09 9.28000000000000e-09 9.29000000000000e-09 9.30000000000000e-09 9.31000000000000e-09 9.32000000000000e-09 9.33000000000000e-09 9.34000000000000e-09 9.35000000000000e-09 9.36000000000000e-09 9.37000000000000e-09 9.38000000000000e-09 9.39000000000000e-09 9.40000000000000e-09 9.41000000000000e-09 9.42000000000000e-09 9.43000000000000e-09 9.44000000000000e-09 9.45000000000000e-09 9.46000000000000e-09 9.47000000000000e-09 9.48000000000000e-09 9.49000000000000e-09 9.50000000000000e-09 9.51000000000000e-09 9.52000000000000e-09 9.53000000000000e-09 9.54000000000000e-09 9.55000000000000e-09 9.56000000000000e-09 9.57000000000000e-09 9.58000000000000e-09 9.59000000000000e-09 9.60000000000000e-09 9.61000000000000e-09 9.62000000000000e-09 9.63000000000000e-09 9.64000000000000e-09 9.65000000000000e-09 9.66000000000000e-09 9.67000000000000e-09 9.68000000000000e-09 9.69000000000000e-09 9.70000000000000e-09 9.71000000000000e-09 9.72000000000000e-09 9.73000000000000e-09 9.74000000000000e-09];
BL2_RelF=[0.000166830873816694 0.000220930304151073 0.000280625806127972 0.000345008850050371 0.000413227535816009 0.000484501872281076 0.000558129322548312 0.000633484617131518 0.000710016324306239 0.000787241718127246 0.000864740888695346 0.000942150664401465 0.00101915867998844 0.00109549777616490 0.00117094082409335 0.00124529601111280 0.00131840258969149 0.00139012707162871 0.00146035983866765 0.00152901213555176 0.00159601340996565 0.00166130896433817 0.00172485788624217 0.00178663122652485 0.00184661039697931 0.00190478576209777 0.00196115540209432 0.00201572402687602 0.00206850202293605 0.00211950461722775 0.00216875114395464 0.00221626440188577 0.00226207009129383 0.00230619632092922 0.00234867317660413 0.00238953234398254 0.00242880677907024 0.00246653042068730 0.00250273793989747 0.00253746452197568 0.00257074567702714 0.00260261707583796 0.00263311440794688 0.00266227325928654 0.00269012900705823 0.00271671672978057 0.00274207113069599 0.00276622647293252 0.00278921652500644 0.00281107451541672 0.00283183309522793 0.00285152430766668 0.00287017956386974 0.00288782962402182 0.00290450458320925 0.00292023386139348 0.00293504619697703 0.00294896964349569 0.00296203156902409 0.00297425865792967 0.00298567691465235 0.00299631166922409 0.00300618758427622 0.00301532866331134 0.00302375826004290 0.00303149908862839 0.00303857323464299 0.00304500216665831 0.00305080674830725 0.00305600725073037 0.00306062336531183 0.00306467421662427 0.00306817837551212 0.00307115387225186 0.00307361820973543 0.00307558837663025 0.00307708086047555 0.00307811166068017 0.00307869630139192 0.00307884984421314 0.00307858690074077 0.00307792164491265 0.00307686782514507 0.00307543877624900 0.00307364743111487 0.00307150633215801 0.00306902764251853 0.00306622315701074 0.00306310431282011 0.00305968219994425 0.00305596757137852 0.00305197085304572 0.00304770215347111 0.00304317127320428 0.00303838771399045 0.00303336068769370 0.00302809912497578 0.00302261168373390 0.00301690675730163 0.00301099248241709 0.00300487674696306 0.00299856719748331 0.00299207124648040 0.00298539607949937 0.00297854866200260 0.00297153574604066 0.00296436387672423 0.00295703939850211 0.00294956846125033 0.00294195702617737 0.00293421087155032 0.00292633559824706 0.00291833663513908 0.00291021924430989 0.00290198852611356 0.00289364942407804 0.00288520672965777 0.00287666508684008 0.00286802899660951 0.00285930282127449 0.00285049078866044 0.00284159699617324 0.00283262541473717 0.00282357989261100 0.00281446415908608 0.00280528182807000 0.00279603640155939 0.00278673127300529 0.00277736973057447 0.00276795496030985 0.00275849004919331 0.00274897798811387 0.00273942167474424 0.00272982391632859 0.00272018743238441 0.00271051485732111 0.00270080874297803 0.00269107156108438 0.00268130570564362 0.00267151349524459 0.00266169717530190 0.00265185892022753 0.00264200083553614 0.00263212495988598 0.00262223326705746 0.00261232766787145 0.00260241001204922 0.00259248209001569 0.00258254563464805 0.00257260232297125 0.00256265377780220 0.00255270156934418 0.00254274721673317 0.00253279218953745 0.00252283790921208 0.00251288575050966 0.00250293704284867 0.00249299307164076 0.00248305507957841 0.00247312426788389 0.00246320179752116 0.00245328879037144 0.00244338633037389 0.00243349546463238 0.00242361720448933 0.00241375252656789 0.00240390237378305 0.00239406765632310 0.00238424925260198 0.00237444801018366 0.00236466474667925 0.00235490025061786 0.00234515528229182 0.00233543057457723 0.00232572683373043 0.00231604474016132 0.00230638494918401 0.00229674809174573 0.00228713477513447 0.00227754558366600 0.00226798107935149 0.00225844180254477 0.00224892827257192 0.00223944098834215 0.00222998042894117 0.00222054705420752 0.00221114130529225 0.00220176360520264 0.00219241435933023 0.00218309395596378 0.00217380276678754 0.00216454114736534 0.00215530943761077 0.00214610796224407 0.00213693703123597 0.00212779694023890 0.00211868797100601 0.00210961039179826 0.00210056445778002 0.00209155041140347 0.00208256848278211 0.00207361889005381 0.00206470183973352 0.00205581752705609 0.00204696613630954 0.00203814784115876 0.00202936280496038 0.00202061118106857 0.00201189311313240 0.00200320873538493 0.00199455817292403 0.00198594154198555 0.00197735895020878 0.00196881049689444 0.00196029627325565 0.00195181636266173 0.00194337084087537 0.00193495977628308 0.00192658323011936 0.00191824125668456 0.00190993390355669 0.00190166121179747 0.00189342321615252 0.00188521994524617 0.00187705142177070 0.00186891766267052 0.00186081867932116 0.00185275447770333 0.00184472505857218 0.00183673041762193 0.00182877054564589 0.00182084542869211 0.00181295504821473 0.00180509938122117 0.00179727840041523 0.00178949207433632 0.00178174036749478 0.00177402324050350 0.00176634065020598 0.00175869254980072 0.00175107888896237 0.00174349961395942 0.00173595466776867 0.00172844399018659 0.00172096751793759 0.00171352518477934 0.00170611692160512 0.00169874265654343 0.00169140231505484 0.00168409582002614 0.00167682309186191 0.00166958404857363 0.00166237860586622 0.00165520667722227 0.00164806817398396 0.00164096300543265 0.00163389107886634 0.00162685229967496 0.00161984657141357 0.00161287379587353 0.00160593387315177 0.00159902670171803 0.00159215217848031 0.00158531019884851 0.00157850065679624 0.00157172344492096 0.00156497845450248 0.00155826557555969 0.00155158469690590 0.00154493570620249 0.00153831849001110 0.00153173293384439 0.00152517892221534 0.00151865633868516 0.00151216506590993 0.00150570498568577 0.00149927597899294 0.00149287792603851 0.00148651070629792 0.00148017419855534 0.00147386828094292 0.00146759283097880 0.00146134772560421 0.00145513284121936 0.00144894805371840 0.00144279323852331 0.00143666827061685 0.00143057302457457 0.00142450737459585 0.00141847119453408 0.00141246435792593 0.00140648673801980 0.00140053820780342 0.00139461864003063 0.00138872790724740 0.00138286588181704 0.00137703243594470 0.00137122744170115 0.00136545077104579 0.00135970229584904 0.00135398188791402 0.00134828941899758 0.00134262476083070 0.00133698778513827 0.00133137836365827 0.00132579636816033 0.00132024167046374 0.00131471414245496 0.00130921365610446 0.00130374008348313 0.00129829329677817 0.00129287316830841 0.00128747957053922 0.00128211237609692 0.00127677145778268 0.00127145668858603 0.00126616794169793 0.00126090509052337 0.00125566800869357 0.00125045657007779 0.00124527064879474 0.00124011011922363 0.00123497485601474 0.00122986473409980 0.00122477962870185 0.00121971941534488 0.00121468396986302 0.00120967316840953 0.00120468688746534 0.00119972500384741 0.00119478739471667 0.00118987393758573 0.00118498451032632 0.00118011899117641 0.00117527725874706 0.00117045919202905 0.00116566467039920 0.00116089357362648 0.00115614578187786 0.00115142117572390 0.00114671963614418 0.00114204104453243 0.00113738528270149 0.00113275223288801 0.00112814177775704 0.00112355380040626 0.00111898818437019 0.00111444481362409 0.00110992357258775 0.00110542434612898 0.00110094701956712 0.00109649147867617 0.00109205760968794 0.00108764529929488 0.00108325443465285 0.00107888490338374 0.00107453659357787 0.00107020939379635 0.00106590319307315 0.00106161788091723 0.00105735334731437 0.00105310948272893 0.00104888617810553 0.00104468332487053 0.00104050081493347 0.00103633854068829 0.00103219639501458 0.00102807427127860 0.00102397206333424 0.00101988966552389 0.00101582697267921 0.00101178388012178 0.00100776028366364 0.00100375607960783 0.000999771164748734 0.000995805436372387 0.000991858792256718 0.000987931130671675 0.000984022350379288 0.000980132350633657 0.000976261031180870 0.000972408292258832 0.000968574034597049 0.000964758159416325 0.000960960568428408 0.000957181163835556 0.000953419848330062 0.000949676525093711 0.000945951097797168 0.000942243470599328 0.000938553548146606 0.000934881235572172 0.000931226438495137 0.000927589063019687 0.000923969015734186 0.000920366203710201 0.000916780534501518 0.000913211916143099 0.000909660257149985 0.000906125466516185 0.000902607453713511 0.000899106128690377 0.000895621401870561 0.000892153184151939 0.000888701386905184 0.000885265921972418 0.000881846701665859 0.000878443638766415 0.000875056646522265 0.000871685638647397 0.000868330529320131 0.000864991233181620 0.000861667665334306 0.000858359741340372 0.000855067377220168 0.000851790489450604 0.000848528994963534 0.000845282811144113 0.000842051855829140 0.000838836047305375 0.000835635304307844 0.000832449546018131 0.000829278692062639 0.000826122662510854 0.000822981377873580 0.000819854759101170 0.000816742727581733 0.000813645205139341 0.000810562114032217 0.000807493376950905 0.000804438917016444 0.000801398657778522 0.000798372523213626 0.000795360437723172 0.000792362326131639 0.000789378113684695 0.000786407726047302 0.000783451089301828 0.000780508129946149 0.000777578774891741 0.000774662951461769 0.000771760587389174 0.000768871610814753 0.000765995950285229 0.000763133534751327 0.000760284293565849 0.000757448156481724 0.000754625053650087 0.000751814915618329 0.000749017673328164 0.000746233258113678 0.000743461601699394 0.000740702636198325 0.000737956294110023 0.000735222508318645 0.000732501212090998 0.000729792339074606 0.000727095823295752 0.000724411599157546 0.000721739601437983 0.000719079765287997 0.000716432026229527 0.000713796320153583 0.000711172583318307 0.000708560752347046 0.000705960764226419 0.000703372556304398 0.000700796066288376 0.000698231232243254 0.000695677992589527 0.000693136286101366 0.000690606051904713 0.000688087229475375 0.000685579758637129 0.000683083579559820 0.000680598632757474 0.000678124859086410 0.000675662199743360 0.000673210596263593 0.000670769990519039 0.000668340324716433 0.000665921541395442 0.000663513583426821 0.000661116394010558 0.000658729916674029 0.000656354095270167 0.000653988873975623 0.000651634197288946 0.000649290010028759 0.000646956257331950 0.000644632884651864 0.000642319837756502 0.000640017062726726 0.000637724505954479 0.000635442114140991 0.000633169834295023 0.000630907613731086 0.000628655400067690 0.000626413141225584 0.000624180785426019 0.000621958281189002 0.000619745577331570 0.000617542622966061 0.000615349367498402 0.000613165760626396 0.000610991752338021 0.000608827292909736 0.000606672332904795 0.000604526823171562 0.000602390714841844 0.000600263959329226 0.000598146508327411 0.000596038313808572 0.000593939328021712 0.000591849503491028 0.000589768793014284 0.000587697149661196 0.000585634526771815 0.000583580877954931 0.000581536157086473 0.000579500318307923 0.000577473316024735 0.000575455104904765 0.000573445639876707 0.000571444876128535 0.000569452769105955 0.000567469274510867 0.000565494348299829 0.000563527946682535 0.000561570026120297 0.000559620543324534 0.000557679455255276 0.000555746719119664 0.000553822292370471 0.000551906132704620 0.000549998198061716 0.000548098446622585 0.000546206836807819 0.000544323327276328 0.000542447876923906 0.000540580444881794 0.000538720990515266 0.000536869473422207 0.000535025853431707 0.000533190090602663 0.000531362145222388 0.000529541977805226 0.000527729549091174 0.000525924820044518 0.000524127751852466 0.000522338305923800 0.000520556443887528 0.000518782127591549 0.000517015319101317 0.000515255980698524 0.000513504074879781 0.000511759564355313 0.000510022412047658 0.000508292581090373 0.000506570034826751 0.000504854736808543 0.000503146650794685 0.000501445740750039 0.000499751970844135 0.000498065305449924 0.000496385709142538 0.000494713146698054 0.000493047583092267 0.000491388983499479 0.000489737313291276 0.000488092538035331 0.000486454623494204 0.000484823535624151 0.000483199240573945 0.000481581704683693 0.000479970894483673 0.000478366776693170 0.000476769318219318 0.000475178486155956 0.000473594247782486 0.000472016570562738 0.000470445422143842 0.000468880770355107 0.000467322583206909 0.000465770828889585 0.000464225475772329 0.000462686492402101 0.000461153847502540 0.000459627509972882 0.000458107448886890 0.000456593633491784 0.000455086033207181 0.000453584617624041 0.000452089356503621 0.000450600219776432 0.000449117177541207 0.000447640200063871 0.000446169257776518 0.000444704321276399 0.000443245361324910 0.000441792348846590 0.000440345254928125 0.000438904050817356 0.000437468707922296 0.000436039197810153 0.000434615492206354 0.000433197562993583 0.000431785382210818 0.000430378922052381 0.000428978154866985 0.000427583053156797 0.000426193589576498 0.000424809736932355 0.000423431468181294 0.000422058756429985 0.000420691574933929 0.000419329897096546 0.000417973696468279 0.000416622946745696 0.000415277621770602 0.000413937695529151 0.000412603142150970 0.000411273935908285 0.000409950051215053 0.000408631462626103 0.000407318144836273 0.000406010072679561 0.000404707221128286 0.000403409565292235 0.000402117080417838 0.000400829741887334 0.000399547525217947 0.000398270406061065 0.000396998360201427 0.000395731363556317 0.000394469392174755 0.000393212422236700 0.000391960430052257 0.000390713392060892 0.000389471284830639 0.000388234085057331 0.000387001769563821 0.000385774315299214 0.000384551699338107 0.000383333898879823 0.000382120891247666 0.000380912653888161 0.000379709164370320 0.000378510400384895 0.000377316339743649 0.000376126960378618 0.000374942240341392 0.000373762157802394 0.000372586691050158 0.000371415818490623 0.000370249518646423 0.000369087770156185 0.000367930551773831 0.000366777842367885 0.000365629620920780 0.000364485866528179 0.000363346558398290 0.000362211675851193 0.000361081198318165 0.000359955105341015 0.000358833376571421 0.000357715991770268 0.000356602930806998 0.000355494173658954 0.000354389700410741 0.000353289491253576 0.000352193526484654 0.000351101786506515 0.000350014251826410 0.000348930903055680 0.000347851720909131 0.000346776686204417 0.000345705779861426 0.000344638982901669 0.000343576276447677 0.000342517641722396 0.000341463060048589 0.000340412512848242 0.000339365981641975 0.000338323448048452 0.000337284893783798 0.000336250300661026 0.000335219650589451 0.000334192925574125 0.000333170107715270 0.000332151179207706 0.000331136122340296 0.000330124919495389 0.000329117553148261 0.000328114005866571 0.000327114260309805 0.000326118299228747 0.000325126105464922 0.000324137661950075 0.000323152951705628 0.000322171957842155 0.000321194663558855 0.000320221052143028 0.000319251106969556 0.000318284811500390 0.000317322149284033 0.000316363103955030 0.000315407659233469 0.000314455798924467 0.000313507506917679 0.000312562767186799 0.000311621563789064 0.000310683880864765 0.000309749702636764 0.000308819013410001 0.000307891797571023 0.000306968039587499 0.000306047724007747 0.000305130835460265 0.000304217358653257 0.000303307278374172 0.000302400579489239 0.000301497246943006 0.000300597265757885 0.000299700621033697 0.000298807297947220 0.000297917281751744 0.000297030557776621 0.000296147111426824 0.000295266928182510 0.000294389993598579 0.000293516293304241 0.000292645813002586 0.000291778538470153 0.000290914455556507 0.000290053550183811 0.000289195808346409 0.000288341216110410 0.000287489759613312 0.000286641425063410 0.000285796198739661 0.000284954066991095 0.000284115016236450 0.000283279032963776 0.000282446103730030 0.000281616215160684 0.000280789353949327 0.000279965506857272 0.000279144660713167 0.000278326802412610 0.000277511918917760 0.000276699997256960 0.000275891024524351 0.000275084987879499 0.000274281874547017 0.000273481671816192 0.000272684367040619 0.000271889947637825 0.000271098401088911 0.000270309714938183 0.000269523876792792 0.000268740874322378 0.000267960695258709 0.000267183327395328 0.000266408758587203 0.000265636976750372 0.000264867969861599 0.000264101725958031 0.000263338233136845 0.000262577479554917 0.000261819453428474 0.000261064143032766 0.000260311536701721 0.000259561622827620 0.000258814389860765 0.000258069826309145 0.000257327920738113 0.000256588661770065 0.000255852038084110 0.000255118038415753 0.000254386651556579 0.000253657866353932 0.000252931671710602 0.000252208056584512 0.000251487009988410 0.000250768520989553 0.000250052578709410 0.000249339172323350 0.000248628291060340 0.000247919924202646 0.000247214061085531 0.000246510691096960 0.000245809803677302 0.000245111388319039 0.000244415434566472 0.000243721932015431 0.000243030870312987 0.000242342239157165 0.000241656028296659 0.000240972227530553 0.000240290826708031 0.000239611815728108 0.000238935184539344 0.000238260923139569 0.000237589021575615 0.000236919469943036 0.000236252258385838 0.000235587377096215 0.000234924816314276 0.000234264566327779 0.000233606617471871 0.000232950960128819 0.000232297584727756 0.000231646481744415 0.000230997641700874 0.000230351055165300 0.000229706712751693 0.000229064605119633 0.000228424722974030 0.000227787057064870 0.000227151598186970 0.000226518337179731 0.000225887264926888 0.000225258372356273 0.000224631650439564 0.000224007090192051 0.000223384682672394 0.000222764418982382 0.000222146290266702 0.000221530287712697 0.000220916402550139 0.000220304626050992 0.000219694949529180 0.000219087364340363 0.000218481861881703 0.000217878433591642 0.000217277070949671 0.000216677765476112 0.000216080508731890 0.000215485292318317 0.000214892107876866 0.000214300947088956 0.000213711801675736 0.000213124663397865 0.000212539524055300 0.000211956375487082 0.000211375209571122 0.000210796018223993 0.000210218793400720 0.000209643527094570 0.000209070211336846 0.000208498838196679 0.000207929399780830 0.000207361888233476 0.000206796295736020 0.000206232614506880 0.000205670836801295 0.000205110954911124 0.000204552961164650 0.000203996847926383 0.000203442607596866 0.000202890232612480 0.000202339715445253 0.000201791048602667 0.000201244224627468 0.000200699236097479 0.000200156075625406 0.000199614735858660 0.000199075209479163 0.000198537489203167 0.000198001567781072 0.000197467437997241 0.000196935092669816 0.000196404524650546 0.000195875726824598 0.000195348692110387 0.000194823413459392 0.000194299883855985 0.000193778096317255 0.000193258043892832 0.000192739719664714 0.000192223116747098 0.000191708228286208 0.000191195047460123 0.000190683567478610 0.000190173781582955 0.000189665683045799 0.000189159265170968 0.000188654521293309 0.000188151444778531 0.000187650029023033 0.000187150267453752 0.000186652153527992 0.000186155680733273 0.000185660842587164 0.000185167632637131 0.000184676044460377 0.000184186071663684 0.000183697707883260 0.000183210946784584 0.000182725782062253 0.000182242207439825 0.000181760216669674 0.000181279803532832 0.000180800961838847 0.000180323685425624 0.000179847968159286 0.000179373803934020 0.000178901186671934 0.000178430110322908 0.000177960568864455 0.000177492556301570 0.000177026066666590 0.000176561094019053 0.000176097632445555 0.000175635676059609 0.000175175219001503 0.000174716255438168 0.000174258779563031 0.000173802785595883 0.000173348267782743 0.000172895220395715 0.000172443637732864 0.000171993514118070 0.000171544843900904 0.000171097621456490 0.000170651841185375 0.000170207497513395 0.000169764584891549 0.000169323097795866 0.000168883030727277 0.000168444378211487 0.000168007134798846 0.000167571295064225 0.000167136853606889 0.000166703805050368 0.000166272144042340 0.000165841865254498 0.000165412963382437 0.000164985433145521 0.000164559269286770 0.000164134466572733 0.000163711019793372 0.000163288923761940 0.000162868173314860 0.000162448763311613 0.000162030688634614 0.000161613944189097 0.000161198524903003 0.000160784425726856 0.000160371641633655 0.000159960167618759 0.000159549998699769 0.000159141129916419 0.000158733556330463 0.000158327273025562 0.000157922275107174 0.000157518557702443 0.000157116115960090 0.000156714945050302 0.000156315040164627 0.000155916396515861 0.000155519009337944 0.000155122873885855 0.000154727985435500 0.000154334339283612 0.000153941930747643];
BL3_Radius=[1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09 2.09000000000000e-09 2.10000000000000e-09 2.11000000000000e-09 2.12000000000000e-09 2.13000000000000e-09 2.14000000000000e-09 2.15000000000000e-09 2.16000000000000e-09 2.17000000000000e-09 2.18000000000000e-09 2.19000000000000e-09 2.20000000000000e-09 2.21000000000000e-09 2.22000000000000e-09 2.23000000000000e-09 2.24000000000000e-09 2.25000000000000e-09 2.26000000000000e-09 2.27000000000000e-09 2.28000000000000e-09 2.29000000000000e-09 2.30000000000000e-09 2.31000000000000e-09 2.32000000000000e-09 2.33000000000000e-09 2.34000000000000e-09 2.35000000000000e-09 2.36000000000000e-09];
BL3_RelF=[0.000621767599069668 0.000828432978244458 0.00106736322897041 0.00133674357624139 0.00163405311556435 0.00195625081694112 0.00229994702754996 0.00266155418834343 0.00303741415652873 0.00342390197524323 0.00381750745004209 0.00421489673898893 0.00461295654793701 0.00500882360351459 0.00539990196881754 0.00578387055200695 0.00615868289102533 0.00652256101452035 0.00687398490225854 0.00721167881086814 0.00753459549936145 0.00784189918609686 0.00813294789458661 0.00840727569823574 0.00866457525128200 0.00890468089211110 0.00912755252289959 0.00933326040346015 0.00952197094471882 0.00969393354619069 0.00984946849016680 0.00998895588137836 0.0101128256032126 0.0102215482488943 0.0103156269773977 0.0103955902383627 0.0104619853072695 0.0105153725709934 0.0105563205041726 0.0105854012781853 0.0106031869466664 0.0106102461541535 0.0106071413174543 0.0105944262325265 0.0105726440629502 0.0105423256693593 0.0105039882424322 0.0104581342051622 0.0104052503531188 0.0103458072042396 0.0102802585323520 0.0102090410611072 0.0101325742973143 0.0100512604847906 0.00996548466180548 0.00987561480698838 0.00978200206021331 0.00968498100646396 0.00958487001204097 0.00948197160370054 0.00937657288242341 0.00926894596451429 0.00915934844363181 0.00904802386815769 0.00893520222903781 0.00882110045387605 0.00870592290363985 0.00858986186885141 0.00847309806259719 0.00835580110809416 0.00823813001891181 0.00812023367026698 0.00800225126008909 0.00788431275880013 0.00776653934697051 0.00764904384020110 0.00753193110074716 0.00741529843554378 0.00729923598041650 0.00718382707036852 0.00706914859592808 0.00695527134561807 0.00684226033467617 0.00673017512021297 0.00661907010303696 0.00650899481641994 0.00639999420210415 0.00629210887387901 0.00618537536907508 0.00607982638833752 0.00597549102405221 0.00587239497780496 0.00577056076725794 0.00567000792282910 0.00557075317455919 0.00547281062954827 0.00537619194033867 0.00528090646461600 0.00518696141659211 0.00509436201042647 0.00500311159603317 0.00491321178761181 0.00482466258523041 0.00473746248977871 0.00465160861159939 0.00456709677309462 0.00448392160559466 0.00440207664076462 0.00432155439681495 0.00424234645977114 0.00416444356004729 0.00408783564455885 0.00401251194459937 0.00393846103969688 0.00386567091765593 0.00379412903098232 0.00372382234987872 0.00365473741199073 0.00358686036907474 0.00352017703075110 0.00345467290549802 0.00339033323903476 0.00332714305023505 0.00326508716470520 0.00320415024615462 0.00314431682568021 0.00308557132908007 0.00302789810230624 0.00297128143516061 0.00291570558333290 0.00286115478887453 0.00280761329919751 0.00275506538468275 0.00270349535497787 0.00265288757406048 0.00260322647413880 0.00255449656845790 0.00250668246307598 0.00245976886767193 0.00241374060544206 0.00236858262214066 0.00232427999431633 0.00228081793679317 0.00223818180944300 0.00219635712329271 0.00215532954600798 0.00211508490679274 0.00207560920074126 0.00203688859267789 0.00199890942051750 0.00196165819817778 0.00192512161807291 0.00188928655321622 0.00185414005895834 0.00181966937438527 0.00178586192339996 0.00175270531550915 0.00172018734633647 0.00168829599788105 0.00165701943854029 0.00162634602291394 0.00159626429140595 0.00156676296963936 0.00153783096769864 0.00150945737921329 0.00148163148029517 0.00145434272834187 0.00142758076071722 0.00140133539331961 0.00137559661904809 0.00135035460617557 0.00132559969663789 0.00130132240424704 0.00127751341283609 0.00125416357434316 0.00123126390684140 0.00120880559252057 0.00118677997562714 0.00116517856036764 0.00114399300878087 0.00112321513858351 0.00110283692099382 0.00108285047853758 0.00106324808284002 0.00104402215240763 0.00102516525040298 0.00100667008241585 0.000988529494233420 0.000970736469612431 0.000953284128055566 0.000936165722594507 0.000919374637581752 0.000902904386493140 0.000886748609742876 0.000870901072512741 0.000855355662596943 0.000840106388264063 0.000825147376137280 0.000810472869094070 0.000796077224186412 0.000781954910582397 0.000768100507530131 0.000754508702344656 0.000741174288418550 0.000728092163256833 0.000715257326536652 0.000702664878192241 0.000690310016525502 0.000678188036342567 0.000666294327116595 0.000654624371177035 0.000643173741925529 0.000631938102078569 0.000620913201937024 0.000610094877682558 0.000599479049700964 0.000589061720932406 0.000578838975248493 0.000568806975856138 0.000558961963728059 0.000549300256059845 0.000539818244753381 0.000530512394926496 0.000521379243448650];
BL4_Radius=[2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09];
BL4_RelF=[0.00154158434875947 0.00208215905133944 0.00273760147909175 0.00351231542374947 0.00440674629792440 0.00541717353935677 0.00653575460778280 0.00775080082171988 0.00904724883155860 0.0104072810177694 0.0118110433887449 0.0132374098793466 0.0146647462212177 0.0160716335487650 0.0174375204442234 0.0187432811896797 0.0199716667743176 0.0211076431221805 0.0221386176978985 0.0230545609412982 0.0238480328520117 0.0245141275763182 0.0250503501960111 0.0254564402778733 0.0257341563210097 0.0258870342416255 0.0259201316471599 0.0258397680353382 0.0256532693417022 0.0253687235557780 0.0249947525084681 0.0245403034546381 0.0240144627678761 0.0234262929450676 0.0227846931898238 0.0220982830994456 0.0213753084068523 0.0206235673094423 0.0198503556316090 0.0190624288963585 0.0182659793042936 0.0174666256164701 0.0166694139943112 0.0158788279498422 0.0150988056900391 0.0143327632891590 0.0135836222835871 0.0128538404478469 0.0121454446724056 0.0114600650196217 0.0107989691806457 0.0101630966913238 0.00955309238800330 0.00896933869407539 0.00841198642509111 0.00788098388471385 0.00737610409624859 0.00689697007583080 0.00644307810449427 0.00601381899825149 0.00560849740901784 0.00522634921567266 0.00486655708472214 0.00452826429479472 0.00421058692937920 0.00391262454855073 0.00363346945359049 0.00337221465898349 0.00312796068479574 0.00289982127933800 0.00268692817771045 0.00248843499661143 0.00230352035997403 0.00213139034378278 0.00197128032201766 0.00182245628922022 0.00168421572879949 0.00155588808998627 0.00143683493037388 0.00132644977530256 0.00122415773998840];
BL6_Radius=[3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10];
BL6_RelF=[0.00259654367221340 0.00360268354642501 0.00484718586084160 0.00633935349012433 0.00807689027447190 0.0100449120641823 0.0122159581656777 0.0145509912604208 0.0170012664815519 0.0195108686092809 0.0220196674575022 0.0244664265812172 0.0267918156423090 0.0289411151062281 0.0308664549060669 0.0325284878460463 0.0338974565083470 0.0349536637414073 0.0356873979117991 0.0360983933619541 0.0361949238850491 0.0359926336297130 0.0355132075425242 0.0347829744552341 0.0338315224704469 0.0326903904482576 0.0313918828730698 0.0299680395183082 0.0284497770619361 0.0268662077065936 0.0252441301843321 0.0236076812944716 0.0219781311764102 0.0203738025867236 0.0188100932004886 0.0172995800399423 0.0158521862096808 0.0144753918778789 0.0131744736214419 0.0119527586312587 0.0108118826813633 0.00975204307704558 0.00877223992541019 0.00787050096440089 0.00704408681640666 0.00628967489430244 0.00560352129013601 0.00498160083879767 0.00441972619625985 0.00391364723282083 0.00345913234546653 0.00305203346829717 0.00268833663223265 0.00236419991847105 0.00207598058493477 0.00182025303857393 0.00159381919325232];
BL7_Radius=[3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10];
BL7_RelF=[0.00259528535755487 0.00360955345996523 0.00486462352308034 0.00636922035086260 0.00812013409364442 0.0101013163219260 0.0122840146022994 0.0146279143197401 0.0170831475837152 0.0195929495215302 0.0220966982652980 0.0245330662820612 0.0268430323080234 0.0289725469890442 0.0308747022655365 0.0325113158657892 0.0338539007518073 0.0348840397680419 0.0355932249675798 0.0359822479463307 0.0360602423570856 0.0358434840383191 0.0353540499474530 0.0346184266523270 0.0336661447745249 0.0325284995074692 0.0312374007961007 0.0298243811971870 0.0283197756718199 0.0267520760692188 0.0251474540246570 0.0235294393716681 0.0219187367614048 0.0203331606960961 0.0187876682785311 0.0172944693064027 0.0158631945684199 0.0145011050330546 0.0132133268100728 0.0120030991069853 0.0108720247414239 0.00982031499318286 0.00884702261043903 0.00795025857846730 0.00712738979551065 0.00637521607737384 0.00569012594110486 0.00506823141896047 0.00450548275208780 0.00399776423677118 0.00354097277277773 0.00313108082020902 0.00276418553311102 0.00243654582699457 0.00214460907249918 0.00188502900483317 0.00165467631162538];
BL8_Radius=[2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10];
BL8_RelF=[0.00200246272974665 0.00287359549269816 0.00398355375601943 0.00535003363447106 0.00697921007405419 0.00886393930330274 0.0109830578886460 0.0133018489480011 0.0157736046048437 0.0183420959756812 0.0209446812986479 0.0235157444018953 0.0259901574874949 0.0283064968335459 0.0304097972799017 0.0322537003606214 0.0338019217835896 0.0350290288111609 0.0359205716787183 0.0364726527326176 0.0366910418780342 0.0365899582520565 0.0361906379072926 0.0355197983857807 0.0346080961800560 0.0334886548203169 0.0321957219038496 0.0307634945173489 0.0292251354119248 0.0276119877251159 0.0259529843589652 0.0242742393625085 0.0225988026517341 0.0209465558069239 0.0193342251158624 0.0177754880566307 0.0162811506239852 0.0148593749256933 0.0135159389897152 0.0122545134687804 0.0110769427034339 0.00998352026016092 0.00897325149752330 0.00804409786989890 0.00719319952664381 0.00641707429957447 0.00571179240615534 0.00507312715373393 0.00449668264247700 0.00397799996539266 0.00351264372750593 0.00309627088598743 0.00272468397923272 0.00239387079257550 0.00210003242479878 0.00183960159245458 0.00160925285421781];
BL9_Radius=[3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10];
BL9_RelF=[0.00263627680442994 0.00367897565276834 0.00497223162728293 0.00652527114014937 0.00833461171990539 0.0103830774466997 0.0126399451652889 0.0150621892595506 0.0175966712062851 0.0201830312488521 0.0227569905343740 0.0252537628337255 0.0276112997842481 0.0297731433103555 0.0316907230766975 0.0333250056119758 0.0346474669196482 0.0356404161026708 0.0362967403564099 0.0366191704135278 0.0366191806929058 0.0363156417599301 0.0357333366865878 0.0349014401905859 0.0338520426232608 0.0326187822370752 0.0312356305226403 0.0297358581063399 0.0281511936222967 0.0265111755897467 0.0248426877834263 0.0231696617797509 0.0215129260288649 0.0198901785784263 0.0183160600540280 0.0168023042783535 0.0153579456102568 0.0139895643761480 0.0127015543746698 0.0114963991440401 0.0103749463262926 0.00933667192933845 0.00837992850305904 0.00750217316998974 0.00670017307117659 0.00597018710934208 0.00530812391376561 0.00470967674181954 0.00417043660291320 0.00368598527517284 0.00325197011634526 0.00286416267884606 0.00251850315224501 0.00221113259896769 0.00193841484114759 0.00169694971539907];
BL10_Radius=[3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10];
BL10_RelF=[0.00244826262150597 0.00345899842219840 0.00472720076037916 0.00626608335396309 0.00807573433632740 0.0101416949444201 0.0124347605114524 0.0149120161546691 0.0175189746237290 0.0201925709946139 0.0228646995781153 0.0254659551043822 0.0279292582435948 0.0301930952890263 0.0322041715751952 0.0339193561474491 0.0353068711956040 0.0363467462419767 0.0370306093380082 0.0373609235747771 0.0373497972641300 0.0370175019991278 0.0363908272070105 0.0355013859096020 0.0343839673062607 0.0330750102517202 0.0316112499602543 0.0300285699945941 0.0283610738940124 0.0266403762623984 0.0248951019686422 0.0231505741981528 0.0214286671189317 0.0197477964501703 0.0181230207558512 0.0165662273405057 0.0150863787453076 0.0136897986340101 0.0123804789920723 0.0111603937812531 0.0100298073051773 0.00898756841737500 0.00803138426063155 0.00715806942399786 0.00636376823126115 0.00564414934416268 0.00499457300236678 0.00441023206641648 0.00388626862035637 0.00341786826897633 0.00300033447079380 0.00262914531882794 0.00229999514969275 0.00200882325576618 0.00175183181880313];
BL2_Radius=BL2_Radius*10^9; %to [nm]
BL3_Radius=BL3_Radius*10^9; %to [nm]
BL4_Radius=BL4_Radius*10^9; %to [nm]
BL6_Radius=BL6_Radius*10^9; %to [nm]
BL7_Radius=BL7_Radius*10^9; %to [nm]
BL8_Radius=BL8_Radius*10^9; %to [nm]
BL9_Radius=BL9_Radius*10^9; %to [nm]
BL10_Radius=BL10_Radius*10^9; %to [nm]

R=[1.79932E+13	2.69454E+13	3.09195E+13	3.43467E+13	3.64823E+13	3.99949E+13	4.0017E+13	4.30734E+13]; %Hydraulic Resistance [1/m]
R_Conf=[4.66561E+11	5.92232E+11	8.29311E+11	8.0695E+11	1.29376E+12	8.4899E+11	9.06552E+11	1.22789E+12]; %95% Confidence Hydraulic Resistance
DXE=[1.70237E-06	9.812E-07	1.04509E-06	1.11799E-06	1.14058E-06	1.20043E-06	1.25067E-06	1.29283E-06]*10^6; %effective membrane thickness [um]
DXE_Conf=[9.93277E-08	1.18107E-07	6.54109E-08	4.43908E-08	6.3891E-08	3.9349E-08	4.11279E-08	5.15092E-08]*10^6;
MPR=[7.59112E-11	2.2072E-10	4.19627E-10	4.52529E-10	4.40579E-10	4.36183E-10	4.39393E-10	4.4104E-10]*10^9; %mean pore radius [nm]
MPR_Conf=[5.01073E-11	6.26321E-11	2.79868E-11	1.87069E-11	2.66004E-11	1.49341E-11	1.69432E-11	2.07999E-11]*10^9;
PRS=[9.75445E-11	1.45119E-10	1.2427E-10	9.85132E-11	9.83085E-11	9.66165E-11	9.69987E-11	9.54949E-11]*10^9; %pore radius spread [nm]
PRS_Conf=[4.83325E-11	2.05752E-11	8.27315E-12	9.99609E-12	1.32963E-11	7.62382E-12	8.60794E-12	1.09917E-11]*10^9;

%Data from Grooth 2015. Assume: density=1.1kg/L (Khler 2009), sweeling 35%.
Bilayer=[1 2 3 4 5 6];
Adsorption=[0.79 1.72 2.83 4.15 5.80 7.94]; %mg/m^2
Thickness=Adsorption/10^6/1100*10^9*1.35;

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(BL2_Radius,BL2_RelF,'.','MarkerSize',6,'Color',[0,0,0]./255);%'k'
plot(BL3_Radius,BL3_RelF,'.','MarkerSize',6,'Color',[96,58,232]./255);%'b'
plot(BL4_Radius,BL4_RelF,'.','MarkerSize',6,'Color',[230,68,62]./255);%'r'
plot(BL6_Radius,BL6_RelF,'.','MarkerSize',6,'Color',[0,0,0]./255);%'k'
plot(BL8_Radius,BL8_RelF,'.','MarkerSize',6,'Color',[96,58,232]./255);%'b'
plot(BL10_Radius,BL10_RelF,'.','MarkerSize',6,'Color',[230,68,62]./255);%'r'
axis([0.1,10,0,0.04]);
title('PDADMAC/PSS');
yticks([0.01 0.02 0.03 0.04]);
xlabel('Pore Radius [nm]');
set(gca,'FontSize',15)
ylabel('Relative Flux [-]');
ax = gca;
set(gca, 'XScale', 'log')
xticks([0.1 1 10]);

%Spline to guide Eye
s=spline(BL4_Radius,BL4_RelF,BL4_Radius(1):0.002:BL4_Radius(end));
plot(BL4_Radius(1):0.002:BL4_Radius(end),s,'-','Color',[230,68,62]./255);%'r'
s=spline(BL6_Radius,BL6_RelF,BL6_Radius(1):0.002:BL6_Radius(end));
plot(BL6_Radius(1):0.002:BL6_Radius(end),s,'-','Color',[0,0,0]./255);%'k'
s=spline(BL8_Radius,BL8_RelF,BL8_Radius(1):0.002:BL8_Radius(end));
plot(BL8_Radius(1):0.002:BL8_Radius(end),s,'-','Color',[96,58,232]./255);%'b'
s=spline(BL10_Radius,BL10_RelF,BL10_Radius(1):0.002:BL10_Radius(end));
plot(BL10_Radius(1):0.002:BL10_Radius(end),s,'-','Color',[230,68,62]./255);%'r'


BL=[2;3;4;6;7;8;9;10]; %Bilayer number

figure;
hold on;
box on;
pbaspect([1 1 1])
yyaxis left
errorbar(BL,DXE,DXE_Conf,DXE_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
axis([0,12,0,2.5]);
title('PDADMAC/PSS');
yticks([0.5 1 1.5 2 2.5]);
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Effective Membrane Thickness [\mum]');
yyaxis right
plot(Bilayer,Thickness,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
axis([0,12,0,15]);
ylabel('Thickness from Reflectometry [nm]');
yticks([5 10 15]);
ax = gca;
ax.YAxis(1).Color = 'k';
ax.YAxis(2).Color = 'k';
xticks([2 4 6 8 10]);

%slope_R=(Thickness(end)-Thickness(end-3))/3;
%slope_M=(DXE(end)-DXE(end-4))/4;
%Conf_slope_R=((1/3)^2*(T_Conf(end))^2+(-1/3)^2*(T_Conf(end-3))^2)^(1/2);
%Conf_slope_M=((1/4)^2*(DXE_Conf(end))^2+(-1/4)^2*(DXE_Conf(end-4))^2)^(1/2);
%slope Reflectometer (last 4 points): 4.11nm/BL+-1.131nm/BL
%slope Model after closure: 61.5nm/BL+-17.3nm/BL

%PAHPAA Pore radius and Relative Flux
BL3_Radius=[5.00000000000000e-11 6.00000000000000e-11 7.00000000000000e-11 8.00000000000000e-11 9.00000000000000e-11 1.00000000000000e-10 1.10000000000000e-10 1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09 2.09000000000000e-09 2.10000000000000e-09 2.11000000000000e-09 2.12000000000000e-09 2.13000000000000e-09 2.14000000000000e-09 2.15000000000000e-09 2.16000000000000e-09 2.17000000000000e-09 2.18000000000000e-09 2.19000000000000e-09 2.20000000000000e-09 2.21000000000000e-09 2.22000000000000e-09 2.23000000000000e-09 2.24000000000000e-09 2.25000000000000e-09 2.26000000000000e-09 2.27000000000000e-09 2.28000000000000e-09 2.29000000000000e-09 2.30000000000000e-09 2.31000000000000e-09 2.32000000000000e-09 2.33000000000000e-09 2.34000000000000e-09 2.35000000000000e-09 2.36000000000000e-09 2.37000000000000e-09 2.38000000000000e-09 2.39000000000000e-09 2.40000000000000e-09 2.41000000000000e-09 2.42000000000000e-09 2.43000000000000e-09 2.44000000000000e-09 2.45000000000000e-09 2.46000000000000e-09 2.47000000000000e-09 2.48000000000000e-09 2.49000000000000e-09 2.50000000000000e-09 2.51000000000000e-09 2.52000000000000e-09 2.53000000000000e-09 2.54000000000000e-09 2.55000000000000e-09 2.56000000000000e-09 2.57000000000000e-09 2.58000000000000e-09 2.59000000000000e-09 2.60000000000000e-09 2.61000000000000e-09 2.62000000000000e-09 2.63000000000000e-09 2.64000000000000e-09 2.65000000000000e-09 2.66000000000000e-09 2.67000000000000e-09 2.68000000000000e-09 2.69000000000000e-09 2.70000000000000e-09 2.71000000000000e-09 2.72000000000000e-09 2.73000000000000e-09 2.74000000000000e-09 2.75000000000000e-09 2.76000000000000e-09 2.77000000000000e-09 2.78000000000000e-09 2.79000000000000e-09 2.80000000000000e-09 2.81000000000000e-09 2.82000000000000e-09 2.83000000000000e-09 2.84000000000000e-09 2.85000000000000e-09 2.86000000000000e-09 2.87000000000000e-09 2.88000000000000e-09 2.89000000000000e-09 2.90000000000000e-09 2.91000000000000e-09 2.92000000000000e-09 2.93000000000000e-09 2.94000000000000e-09 2.95000000000000e-09 2.96000000000000e-09 2.97000000000000e-09 2.98000000000000e-09 2.99000000000000e-09 3.00000000000000e-09 3.01000000000000e-09 3.02000000000000e-09 3.03000000000000e-09 3.04000000000000e-09 3.05000000000000e-09 3.06000000000000e-09 3.07000000000000e-09 3.08000000000000e-09 3.09000000000000e-09 3.10000000000000e-09 3.11000000000000e-09 3.12000000000000e-09 3.13000000000000e-09 3.14000000000000e-09 3.15000000000000e-09 3.16000000000000e-09 3.17000000000000e-09 3.18000000000000e-09 3.19000000000000e-09 3.20000000000000e-09 3.21000000000000e-09 3.22000000000000e-09 3.23000000000000e-09 3.24000000000000e-09 3.25000000000000e-09 3.26000000000000e-09 3.27000000000000e-09 3.28000000000000e-09 3.29000000000000e-09 3.30000000000000e-09 3.31000000000000e-09 3.32000000000000e-09 3.33000000000000e-09 3.34000000000000e-09 3.35000000000000e-09 3.36000000000000e-09 3.37000000000000e-09 3.38000000000000e-09 3.39000000000000e-09 3.40000000000000e-09 3.41000000000000e-09 3.42000000000000e-09 3.43000000000000e-09 3.44000000000000e-09 3.45000000000000e-09 3.46000000000000e-09 3.47000000000000e-09 3.48000000000000e-09 3.49000000000000e-09 3.50000000000000e-09 3.51000000000000e-09 3.52000000000000e-09 3.53000000000000e-09 3.54000000000000e-09 3.55000000000000e-09 3.56000000000000e-09 3.57000000000000e-09 3.58000000000000e-09 3.59000000000000e-09 3.60000000000000e-09 3.61000000000000e-09 3.62000000000000e-09 3.63000000000000e-09 3.64000000000000e-09 3.65000000000000e-09 3.66000000000000e-09 3.67000000000000e-09 3.68000000000000e-09 3.69000000000000e-09 3.70000000000000e-09 3.71000000000000e-09 3.72000000000000e-09 3.73000000000000e-09 3.74000000000000e-09 3.75000000000000e-09 3.76000000000000e-09 3.77000000000000e-09 3.78000000000000e-09 3.79000000000000e-09 3.80000000000000e-09 3.81000000000000e-09 3.82000000000000e-09 3.83000000000000e-09 3.84000000000000e-09 3.85000000000000e-09 3.86000000000000e-09 3.87000000000000e-09 3.88000000000000e-09 3.89000000000000e-09 3.90000000000000e-09 3.91000000000000e-09 3.92000000000000e-09 3.93000000000000e-09 3.94000000000000e-09 3.95000000000000e-09 3.96000000000000e-09 3.97000000000000e-09 3.98000000000000e-09 3.99000000000000e-09 4.00000000000000e-09 4.01000000000000e-09 4.02000000000000e-09 4.03000000000000e-09 4.04000000000000e-09 4.05000000000000e-09 4.06000000000000e-09 4.07000000000000e-09 4.08000000000000e-09 4.09000000000000e-09 4.10000000000000e-09 4.11000000000000e-09 4.12000000000000e-09 4.13000000000000e-09 4.14000000000000e-09 4.15000000000000e-09 4.16000000000000e-09 4.17000000000000e-09 4.18000000000000e-09 4.19000000000000e-09 4.20000000000000e-09 4.21000000000000e-09 4.22000000000000e-09 4.23000000000000e-09 4.24000000000000e-09 4.25000000000000e-09 4.26000000000000e-09 4.27000000000000e-09 4.28000000000000e-09 4.29000000000000e-09 4.30000000000000e-09 4.31000000000000e-09 4.32000000000000e-09 4.33000000000000e-09 4.34000000000000e-09 4.35000000000000e-09 4.36000000000000e-09 4.37000000000000e-09 4.38000000000000e-09 4.39000000000000e-09 4.40000000000000e-09 4.41000000000000e-09 4.42000000000000e-09 4.43000000000000e-09 4.44000000000000e-09 4.45000000000000e-09 4.46000000000000e-09 4.47000000000000e-09 4.48000000000000e-09 4.49000000000000e-09 4.50000000000000e-09 4.51000000000000e-09 4.52000000000000e-09 4.53000000000000e-09 4.54000000000000e-09 4.55000000000000e-09 4.56000000000000e-09 4.57000000000000e-09 4.58000000000000e-09 4.59000000000000e-09 4.60000000000000e-09 4.61000000000000e-09 4.62000000000000e-09 4.63000000000000e-09 4.64000000000000e-09 4.65000000000000e-09 4.66000000000000e-09 4.67000000000000e-09 4.68000000000000e-09 4.69000000000000e-09 4.70000000000000e-09 4.71000000000000e-09 4.72000000000000e-09 4.73000000000000e-09 4.74000000000000e-09 4.75000000000000e-09 4.76000000000000e-09 4.77000000000000e-09 4.78000000000000e-09 4.79000000000000e-09 4.80000000000000e-09 4.81000000000000e-09 4.82000000000000e-09 4.83000000000000e-09 4.84000000000000e-09 4.85000000000000e-09 4.86000000000000e-09 4.87000000000000e-09 4.88000000000000e-09 4.89000000000000e-09 4.90000000000000e-09 4.91000000000000e-09 4.92000000000000e-09 4.93000000000000e-09 4.94000000000000e-09 4.95000000000000e-09 4.96000000000000e-09 4.97000000000000e-09 4.98000000000000e-09 4.99000000000000e-09 5.00000000000000e-09 5.01000000000000e-09 5.02000000000000e-09 5.03000000000000e-09 5.04000000000000e-09 5.05000000000000e-09 5.06000000000000e-09 5.07000000000000e-09 5.08000000000000e-09 5.09000000000000e-09 5.10000000000000e-09 5.11000000000000e-09 5.12000000000000e-09 5.13000000000000e-09 5.14000000000000e-09 5.15000000000000e-09 5.16000000000000e-09 5.17000000000000e-09 5.18000000000000e-09 5.19000000000000e-09 5.20000000000000e-09 5.21000000000000e-09 5.22000000000000e-09 5.23000000000000e-09 5.24000000000000e-09 5.25000000000000e-09 5.26000000000000e-09 5.27000000000000e-09 5.28000000000000e-09 5.29000000000000e-09 5.30000000000000e-09 5.31000000000000e-09 5.32000000000000e-09 5.33000000000000e-09 5.34000000000000e-09 5.35000000000000e-09 5.36000000000000e-09 5.37000000000000e-09 5.38000000000000e-09 5.39000000000000e-09 5.40000000000000e-09 5.41000000000000e-09 5.42000000000000e-09 5.43000000000000e-09 5.44000000000000e-09 5.45000000000000e-09 5.46000000000000e-09 5.47000000000000e-09 5.48000000000000e-09 5.49000000000000e-09 5.50000000000000e-09 5.51000000000000e-09 5.52000000000000e-09 5.53000000000000e-09 5.54000000000000e-09 5.55000000000000e-09 5.56000000000000e-09 5.57000000000000e-09 5.58000000000000e-09 5.59000000000000e-09 5.60000000000000e-09 5.61000000000000e-09 5.62000000000000e-09 5.63000000000000e-09 5.64000000000000e-09 5.65000000000000e-09 5.66000000000000e-09 5.67000000000000e-09 5.68000000000000e-09 5.69000000000000e-09 5.70000000000000e-09 5.71000000000000e-09 5.72000000000000e-09 5.73000000000000e-09 5.74000000000000e-09 5.75000000000000e-09 5.76000000000000e-09 5.77000000000000e-09];
BL3_RelF=[0.000441811097441697 0.000648403631297258 0.000874581772133129 0.00111250047282152 0.00135599389075249 0.00160033592056011 0.00184197338911036 0.00207828452859169 0.00230737677293252 0.00252792352557640 0.00273903480464899 0.00294015572671291 0.00313098724227135 0.00331142440510493 0.00348150835776727 0.00364138901087389 0.00379129605064182 0.00393151643370277 0.00406237693979144 0.00418423067283380 0.00429744664851115 0.00440240179761040 0.00449947486222128 0.00458904177613760 0.00467147220941239 0.00474712702584681 0.00481635645581003 0.00487949882866729 0.00493687974189398 0.00498881156971266 0.00503559323437121 0.00507751017918696 0.00511483449514430 0.00514782516287046 0.00517672837978613 0.00520177794856821 0.00522319570811437 0.00524119199222656 0.00525596610444635 0.00526770680004213 0.00527659276819848 0.00528279310909487 0.00528646780186655 0.00528776816048103 0.00528683727539058 0.00528381043947708 0.00527881555732450 0.00527197353726102 0.00526339866593242 0.00525319896541465 0.00524147653306368 0.00522832786444362 0.00521384415978110 0.00519811161447049 0.00518121169420802 0.00516322139536770 0.00514421349125186 0.00512425676485748 0.00510341622879901 0.00508175333302078 0.00505932616091929 0.00503618961447911 0.00501239558900656 0.00498799313802354 0.00496302862886183 0.00493754588947376 0.00491158634695201 0.00488518915822732 0.00485839133338911 0.00483122785205136 0.00480373177316356 0.00477593433864461 0.00474786507119716 0.00471955186663941 0.00469102108107260 0.00466229761318391 0.00463340498196741 0.00460436540012899 0.00457519984342583 0.00454592811617604 0.00451656891316028 0.00448713987812395 0.00445765765907612 0.00442813796056988 0.00439859559313736 0.00436904452004281 0.00433949790150710 0.00430996813654782 0.00428046690257074 0.00425100519284034 0.00422159335194860 0.00419224110939677 0.00416295761139375 0.00413375145097309 0.00410463069652141 0.00407560291880715 0.00404667521659270 0.00401785424090833 0.00398914621806162 0.00396055697145197 0.00393209194225547 0.00390375620904181 0.00387555450638138 0.00384749124249707 0.00381957051601259 0.00379179613184567 0.00376417161629221 0.00373670023134448 0.00370938498828414 0.00368222866058865 0.00365523379618730 0.00362840272910117 0.00360173759049936 0.00357524031920205 0.00354891267165923 0.00352275623143242 0.00349677241820497 0.00347096249634558 0.00344532758304770 0.00341986865606680 0.00339458656107607 0.00336948201865983 0.00334455563096325 0.00331980788801572 0.00329523917374436 0.00327084977169325 0.00324663987046315 0.00322260956888580 0.00319875888094592 0.00317508774046350 0.00315159600554834 0.00312828346283806 0.00310514983153022 0.00308219476721876 0.00305941786554435 0.00303681866566774 0.00301439665357471 0.00299215126522091 0.00297008188952434 0.00294818787121276 0.00292646851353324 0.00290492308083024 0.00288355080099882 0.00286235086781872 0.00284132244317526 0.00282046465917222 0.00279977662014210 0.00277925740455843 0.00275890606685495 0.00273872163915595 0.00271870313292209 0.00269884954051557 0.00267915983668859 0.00265963297999856 0.00264026791415364 0.00262106356929182 0.00260201886319663 0.00258313270245249 0.00256440398354250 0.00254583159389138 0.00252741441285605 0.00250915131266640 0.00249104115931845 0.00247308281342218 0.00245527513100613 0.00243761696428077 0.00242010716236248 0.00240274457196015 0.00238552803802586 0.00236845640437160 0.00235152851425333 0.00233474321092408 0.00231809933815743 0.00230159574074273 0.00228523126495348 0.00226900475898991 0.00225291507339715 0.00223696106146000 0.00222114157957544 0.00220545548760385 0.00218990164919997 0.00217447893212458 0.00215918620853755 0.00214402235527386 0.00212898625410187 0.00211407679196659 0.00209929286121717 0.00208463335982000 0.00207009719155796 0.00205568326621637 0.00204139049975652 0.00202721781447703 0.00201316413916387 0.00199922840922946 0.00198540956684138 0.00197170656104120 0.00195811834785388 0.00194464389038821 0.00193128215892868 0.00191803213101924 0.00190489279153929 0.00189186313277236 0.00187894215446766 0.00186612886389509 0.00185342227589382 0.00184082141291484 0.00182832530505784 0.00181593299010251 0.00180364351353482 0.00179145592856823 0.00177936929616034 0.00176738268502500 0.00175549517164034 0.00174370584025267 0.00173201378287669 0.00172041809929208 0.00170891789703668 0.00169751229139650 0.00168620040539260 0.00167498136976516 0.00166385432295484 0.00165281841108146 0.00164187278792042 0.00163101661487663 0.00162024906095649 0.00160956930273763 0.00159897652433692 0.00158846991737654 0.00157804868094844 0.00156771202157716 0.00155745915318123 0.00154728929703311 0.00153720168171786 0.00152719554309058 0.00151727012423278 0.00150742467540756 0.00149765845401400 0.00148797072454045 0.00147836075851716 0.00146882783446799 0.00145937123786149 0.00144999026106135 0.00144068420327617 0.00143145237050880 0.00142229407550508 0.00141320863770221 0.00140419538317676 0.00139525364459222 0.00138638276114636 0.00137758207851824 0.00136885094881507 0.00136018873051881 0.00135159478843266 0.00134306849362741 0.00133460922338768 0.00132621636115817 0.00131788929648979 0.00130962742498583 0.00130143014824814 0.00129329687382337 0.00128522701514923 0.00127721999150092 0.00126927522793756 0.00126139215524885 0.00125357020990184 0.00124580883398779 0.00123810747516936 0.00123046558662787 0.00122288262701082 0.00121535806037961 0.00120789135615757 0.00120048198907811 0.00119312943913326 0.00118583319152241 0.00117859273660133 0.00117140756983152 0.00116427719172982 0.00115720110781838 0.00115017882857484 0.00114320986938299 0.00113629375048359 0.00112942999692569 0.00112261813851813 0.00111585770978150 0.00110914824990043 0.00110248930267617 0.00109588041647965 0.00108932114420476 0.00108281104322210 0.00107634967533307 0.00106993660672432 0.00106357140792257 0.00105725365374982 0.00105098292327895 0.00104475879978966 0.00103858087072483 0.00103244872764720 0.00102636196619654 0.00102032018604708 0.00101432299086539 0.00100836998826865 0.00100246078978326 0.000996595010803862 0.000990772270552740 0.000984992192039581 0.000979254402021651 0.000973558530964314 0.000967904213001957 0.000962291085899279 0.000956718791012951 0.000951186973253670 0.000945695281048561 0.000940243366303973 0.000934830884368631 0.000929457493997155 0.000924122857313959 0.000918826639777499 0.000913568510144890 0.000908348140436884 0.000903165205903203 0.000898019384988231 0.000892910359297051 0.000887837813561849 0.000882801435608650 0.000877800916324413 0.000872835949624459 0.000867906232420254 0.000863011464587514 0.000858151348934660 0.000853325591171607 0.000848533899878869 0.000843775986477010 0.000839051565196414 0.000834360353047372 0.000829702069790505 0.000825076437907480 0.000820483182572077 0.000815922031621525 0.000811392715528188 0.000806894967371529 0.000802428522810394 0.000797993120055590 0.000793588499842763 0.000789214405405574 0.000784870582449169 0.000780556779123923 0.000776272745999507 0.000772018236039195 0.000767793004574497 0.000763596809280026 0.000759429410148687 0.000755290569467106 0.000751180051791342 0.000747097623922873 0.000743043054884834 0.000739016115898532 0.000735016580360213 0.000731044223818083 0.000727098823949598 0.000723180160538987 0.000719288015455046 0.000715422172629157 0.000711582418033572 0.000707768539659920 0.000703980327497968 0.000700217573514614 0.000696480071633106 0.000692767617712509 0.000689080009527384 0.000685417046747708 0.000681778530919007 0.000678164265442720 0.000674574055556772 0.000671007708316379 0.000667465032575049 0.000663945838965814 0.000660449939882657 0.000656977149462153 0.000653527283565316 0.000650100159759648 0.000646695597301389 0.000643313417117962 0.000639953441790619 0.000636615495537283 0.000633299404195571 0.000630004995206020 0.000626732097595489 0.000623480541960760 0.000620250160452307 0.000617040786758257 0.000613852256088526 0.000610684405159135 0.000607537072176696 0.000604410096823081 0.000601303320240246 0.000598216585015244 0.000595149735165386 0.000592102616123589 0.000589075074723861 0.000586066959186972 0.000583078119106273 0.000580108405433672 0.000577157670465769 0.000574225767830147 0.000571312552471814 0.000568417880639793 0.000565541609873864 0.000562683598991456 0.000559843708074675 0.000557021798457490 0.000554217732713043 0.000551431374641126 0.000548662589255765 0.000545911242772963 0.000543177202598581 0.000540460337316331 0.000537760516675930 0.000535077611581362 0.000532411494079282 0.000529762037347543 0.000527129115683855 0.000524512604494562 0.000521912380283547 0.000519328320641257 0.000516760304233853 0.000514208210792475 0.000511671921102623 0.000509151316993665 0.000506646281328445 0.000504156697993021 0.000501682451886501 0.000499223428911001 0.000496779515961707 0.000494350600917049 0.000491936572628979 0.000489537320913361 0.000487152736540455 0.000484782711225521 0.000482427137619508 0.000480085909299858 0.000477758920761400 0.000475446067407355 0.000473147245540424 0.000470862352353981 0.000468591285923367 0.000466333945197265 0.000464090229989180 0.000461860040969002 0.000459643279654670 0.000457439848403920 0.000455249650406119 0.000453072589674194 0.000450908571036649 0.000448757500129653 0.000446619283389237 0.000444493828043555 0.000442381042105235 0.000440280834363814 0.000438193114378252 0.000436117792469528 0.000434054779713311 0.000432003987932711 0.000429965329691118 0.000427938718285095 0.000425924067737369 0.000423921292789882 0.000421930308896928 0.000419951032218351 0.000417983379612822 0.000416027268631188 0.000414082617509888 0.000412149345164441 0.000410227371183004 0.000408316615819995 0.000406416999989784 0.000404528445260454 0.000402650873847627 0.000400784208608347 0.000398928373035042 0.000397083291249537 0.000395248887997134 0.000393425088640756 0.000391611819155152 0.000389809006121161 0.000388016576720036 0.000386234458727826 0.000384462580509827 0.000382700871015074 0.000380949259770903 0.000379207676877567 0.000377476053002906 0.000375754319377072 0.000374042407787312 0.000372340250572805 0.000370647780619546 0.000368964931355292 0.000367291636744559 0.000365627831283658 0.000363973449995802 0.000362328428426252 0.000360692702637509 0.000359066209204570 0.000357448885210217 0.000355840668240366 0.000354241496379455 0.000352651308205889 0.000351070042787524 0.000349497639677196 0.000347934038908306 0.000346379180990439 0.000344833006905032 0.000343295458101089 0.000341766476490935 0.000340246004446014 0.000338733984792736 0.000337230360808354 0.000335735076216896 0.000334248075185128 0.000332769302318566 0.000331298702657519 0.000329836221673182 0.000328381805263764 0.000326935399750649 0.000325496951874611 0.000324066408792046 0.000322643718071265 0.000321228827688805 0.000319821686025789 0.000318422241864313 0.000317030444383882 0.000315646243157867 0.000314269588150010 0.000312900429710954 0.000311538718574813 0.000310184405855780 0.000308837443044756 0.000307497782006026 0.000306165374973960 0.000304840174549751 0.000303522133698181 0.000302211205744424 0.000300907344370877 0.000299610503614023 0.000298320637861328 0.000297037701848161 0.000295761650654754 0.000294492439703186 0.000293230024754397 0.000291974361905234 0.000290725407585521 0.000289483118555164 0.000288247451901282 0.000287018365035362 0.000285795815690446 0.000284579761918347 0.000283370162086889 0.000282166974877172 0.000280970159280869 0.000279779674597544 0.000278595480432004 0.000277417536691663 0.000276245803583948 0.000275080241613714 0.000273920811580701 0.000272767474576996 0.000271620191984541 0.000270478925472642 0.000269343636995527 0.000268214288789902 0.000267090843372553 0.000265973263537955 0.000264861512355910 0.000263755553169212];
BL5_Radius=[4.00000000000000e-11 5.00000000000000e-11 6.00000000000000e-11 7.00000000000000e-11 8.00000000000000e-11 9.00000000000000e-11 1.00000000000000e-10 1.10000000000000e-10 1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09 2.09000000000000e-09 2.10000000000000e-09 2.11000000000000e-09 2.12000000000000e-09 2.13000000000000e-09 2.14000000000000e-09 2.15000000000000e-09 2.16000000000000e-09 2.17000000000000e-09 2.18000000000000e-09 2.19000000000000e-09 2.20000000000000e-09 2.21000000000000e-09 2.22000000000000e-09 2.23000000000000e-09 2.24000000000000e-09 2.25000000000000e-09 2.26000000000000e-09 2.27000000000000e-09 2.28000000000000e-09 2.29000000000000e-09 2.30000000000000e-09 2.31000000000000e-09 2.32000000000000e-09 2.33000000000000e-09 2.34000000000000e-09 2.35000000000000e-09 2.36000000000000e-09 2.37000000000000e-09 2.38000000000000e-09 2.39000000000000e-09 2.40000000000000e-09 2.41000000000000e-09 2.42000000000000e-09 2.43000000000000e-09 2.44000000000000e-09 2.45000000000000e-09 2.46000000000000e-09 2.47000000000000e-09 2.48000000000000e-09 2.49000000000000e-09 2.50000000000000e-09 2.51000000000000e-09 2.52000000000000e-09 2.53000000000000e-09 2.54000000000000e-09 2.55000000000000e-09 2.56000000000000e-09 2.57000000000000e-09 2.58000000000000e-09 2.59000000000000e-09 2.60000000000000e-09 2.61000000000000e-09 2.62000000000000e-09 2.63000000000000e-09 2.64000000000000e-09 2.65000000000000e-09 2.66000000000000e-09 2.67000000000000e-09 2.68000000000000e-09 2.69000000000000e-09 2.70000000000000e-09 2.71000000000000e-09 2.72000000000000e-09 2.73000000000000e-09 2.74000000000000e-09 2.75000000000000e-09 2.76000000000000e-09 2.77000000000000e-09 2.78000000000000e-09 2.79000000000000e-09 2.80000000000000e-09 2.81000000000000e-09 2.82000000000000e-09 2.83000000000000e-09 2.84000000000000e-09 2.85000000000000e-09 2.86000000000000e-09 2.87000000000000e-09 2.88000000000000e-09 2.89000000000000e-09 2.90000000000000e-09 2.91000000000000e-09 2.92000000000000e-09 2.93000000000000e-09 2.94000000000000e-09 2.95000000000000e-09 2.96000000000000e-09 2.97000000000000e-09 2.98000000000000e-09 2.99000000000000e-09 3.00000000000000e-09 3.01000000000000e-09 3.02000000000000e-09 3.03000000000000e-09 3.04000000000000e-09 3.05000000000000e-09 3.06000000000000e-09 3.07000000000000e-09 3.08000000000000e-09 3.09000000000000e-09 3.10000000000000e-09 3.11000000000000e-09 3.12000000000000e-09 3.13000000000000e-09 3.14000000000000e-09 3.15000000000000e-09 3.16000000000000e-09 3.17000000000000e-09 3.18000000000000e-09 3.19000000000000e-09 3.20000000000000e-09 3.21000000000000e-09 3.22000000000000e-09 3.23000000000000e-09 3.24000000000000e-09 3.25000000000000e-09 3.26000000000000e-09 3.27000000000000e-09 3.28000000000000e-09 3.29000000000000e-09 3.30000000000000e-09 3.31000000000000e-09 3.32000000000000e-09 3.33000000000000e-09 3.34000000000000e-09 3.35000000000000e-09 3.36000000000000e-09 3.37000000000000e-09 3.38000000000000e-09 3.39000000000000e-09 3.40000000000000e-09 3.41000000000000e-09 3.42000000000000e-09 3.43000000000000e-09 3.44000000000000e-09 3.45000000000000e-09 3.46000000000000e-09 3.47000000000000e-09 3.48000000000000e-09 3.49000000000000e-09 3.50000000000000e-09 3.51000000000000e-09 3.52000000000000e-09 3.53000000000000e-09 3.54000000000000e-09 3.55000000000000e-09 3.56000000000000e-09 3.57000000000000e-09 3.58000000000000e-09 3.59000000000000e-09 3.60000000000000e-09 3.61000000000000e-09 3.62000000000000e-09 3.63000000000000e-09 3.64000000000000e-09 3.65000000000000e-09 3.66000000000000e-09 3.67000000000000e-09 3.68000000000000e-09 3.69000000000000e-09 3.70000000000000e-09 3.71000000000000e-09 3.72000000000000e-09 3.73000000000000e-09 3.74000000000000e-09 3.75000000000000e-09 3.76000000000000e-09 3.77000000000000e-09 3.78000000000000e-09 3.79000000000000e-09 3.80000000000000e-09 3.81000000000000e-09 3.82000000000000e-09 3.83000000000000e-09 3.84000000000000e-09];
BL5_RelF=[0.000737595894149123 0.00117408946512749 0.00165273947383990 0.00214905397037972 0.00264553697679605 0.00313017626630213 0.00359503514715198 0.00403512890724672 0.00444757868250328 0.00483099022701456 0.00518500322769125 0.00550996628255016 0.00580670330226290 0.00607634608205872 0.00632021469775557 0.00653973247751318 0.00673636599545765 0.00691158319036017 0.00706682461929968 0.00720348422574317 0.00732289698758889 0.00742633152317172 0.00751498624991165 0.00758998806643503 0.00765239280385642 0.00770318689345000 0.00774328984617467 0.00777355724883058 0.00779478406240549 0.00780770806794778 0.00781301334957248 0.00781133373698538 0.00780325615415251 0.00778932383862798 0.00777003940919898 0.00774586776911090 0.00771723883909500 0.00768455011940380 0.00764816908356732 0.00760843540899243 0.00756566305112144 0.00752014216885745 0.00747214090951280 0.00742190706176533 0.00736966958510422 0.00731564002408238 0.00726001381541636 0.00720297149562548 0.00714467981650801 0.00708529277533362 0.00702495256620508 0.00696379045861627 0.00690192760881850 0.00683947580920636 0.00677653818055171 0.00671320981155229 0.00664957834982056 0.00658572454811926 0.00652172276935234 0.00645764145354348 0.00639354354977771 0.00632948691584432 0.00626552468810038 0.00620170562387181 0.00613807441852293 0.00607467199915438 0.00601153579673158 0.00594869999830122 0.00588619578082074 0.00582405152800326 0.00576229303146864 0.00570094367738876 0.00564002461972024 0.00557955494103177 0.00551955180185344 0.00546003057940259 0.00540100499647383 0.00534248724121922 0.00528448807848840 0.00522701695334637 0.00517008208733916 0.00511369056803370 0.00505784843231804 0.00500256074391111 0.00494783166549703 0.00489366452586771 0.00484006188242881 0.00478702557939723 0.00473455680199424 0.00468265612691554 0.00463132356933905 0.00458055862671119 0.00453036031953717 0.00448072722938051 0.00443165753426611 0.00438314904166452 0.00433519921922339 0.00428780522340008 0.00424096392613808 0.00419467193972023 0.00414892563992200 0.00410372118757964 0.00405905454867970 0.00401492151306928 0.00397131771187931 0.00392823863374664 0.00388567963991518 0.00384363597829035 0.00380210279651645 0.00376107515414139 0.00372054803392932 0.00368051635237709 0.00364097496948716 0.00360191869784570 0.00356334231105147 0.00352524055153823 0.00348760813783017 0.00345043977126755 0.00341373014223724 0.00337747393594044 0.00334166583772782 0.00330630053803034 0.00327137273691217 0.00323687714827031 0.00320280850370410 0.00316916155607608 0.00313593108278447 0.00310311188876611 0.00307069880924756 0.00303868671226082 0.00300707050093921 0.00297584511560784 0.00294500553568235 0.00291454678138837 0.00288446391531386 0.00285475204380525 0.00282540631821796 0.00279642193603093 0.00276779414183442 0.00273951822819958 0.00271158953643785 0.00268400345725771 0.00265675543132579 0.00262984094973904 0.00260325555441405 0.00257699483839935 0.00255105444611619 0.00252543007353280 0.00250011746827693 0.00247511242969122 0.00245041080883550 0.00242600850843997 0.00240190148281300 0.00237808573770689 0.00235455733014495 0.00233131236821284 0.00230834701081700 0.00228565746741295 0.00226323999770573 0.00224109091132505 0.00221920656747714 0.00219758337457549 0.00217621778985223 0.00215510631895214 0.00213424551551077 0.00211363198071831 0.00209326236287076 0.00207313335690962 0.00205324170395146 0.00203358419080854 0.00201415764950164 0.00199495895676605 0.00197598503355177 0.00195723284451881 0.00193869939752838 0.00192038174313084 0.00190227697405106 0.00188438222467193 0.00186669467051662 0.00184921152773018 0.00183193005256103 0.00181484754084289 0.00179796132747748 0.00178126878591857 0.00176476732765796 0.00174845440171289 0.00173232749411660 0.00171638412741115 0.00170062186014341 0.00168503828636431 0.00166963103513157 0.00165439777001625 0.00163933618861312 0.00162444402205526 0.00160971903453291 0.00159515902281673 0.00158076181578573 0.00156652527395972 0.00155244728903677 0.00153852578343544 0.00152475870984196 0.00151114405076260 0.00149767981808099 0.00148436405262076 0.00147119482371327 0.00145817022877066 0.00144528839286414 0.00143254746830759 0.00141994563424646 0.00140748109625201 0.00139515208592083 0.00138295686047973 0.00137089370239589 0.00135896091899236 0.00134715684206876 0.00133547982752734 0.00132392825500421 0.00131250052750576 0.00130119507105036 0.00129001033431505 0.00127894478828751 0.00126799692592294 0.00125716526180607 0.00124644833181816 0.00123584469280882 0.00122535292227291 0.00121497161803214 0.00120469939792153 0.00119453489948061 0.00118447677964934 0.00117452371446864 0.00116467439878552 0.00115492754596282 0.00114528188759330 0.00113573617321831 0.00112628917005075 0.00111693966270237 0.00110768645291535 0.00109852835929807 0.00108946421706511 0.00108049287778121 0.00107161320910942 0.00106282409456317 0.00105412443326226 0.00104551313969278 0.00103698914347082 0.00102855138910997 0.00102019883579250 0.00101193045714423 0.00100374524101302 0.000995642189250780 0.000987620317498996 0.000979678654977703 0.000971816244277864 0.000964032141157068 0.000956325414338542 0.000948695145313406 0.000941140428146097 0.000933660369282963 0.000926254087363928 0.000918920713037215 0.000911659388777059 0.000904469268704364 0.000897349518410274 0.000890299314782587 0.000883317845834986 0.000876404310539029 0.000869557918658861 0.000862777890588608 0.000856063457192382 0.000849413859646905 0.000842828349286654 0.000836306187451531 0.000829846645336975 0.000823449003846523 0.000817112553446735 0.000810836594024472 0.000804620434746481 0.000798463393921241 0.000792364798863042 0.000786323985758263 0.000780340299533793 0.000774413093727586 0.000768541730361290 0.000762725579814938 0.000756964020703640 0.000751256439756272 0.000745602231696106 0.000740000799123353 0.000734451552399605 0.000728953909534110 0.000723507296071883 0.000718111144983607 0.000712764896557281 0.000707467998291621 0.000702219904791142 0.000697020077662930 0.000691867985415046 0.000686763103356558 0.000681704913499159 0.000676692904460345 0.000671726571368139 0.000666805415767316 0.000661928945527123 0.000657096674750454 0.000652308123684461 0.000647562818632587 0.000642860291867968 0.000638200081548220 0.000633581731631557 0.000629004791794227 0.000624468817349257 0.000619973369166452 0.000615518013593676 0.000611102322379340 0.000606725872596116 0.000602388246565843 0.000598089031785594 0.000593827820854914 0.000589604211404165 0.000585417806024013 0.000581268212195991 0.000577155042224138 0.000573077913167715 0.000569036446774942 0.000565030269417772 0.000561059012027662 0.000557122310032345 0.000553219803293561 0.000549351136045763 0.000545515956835747 0.000541713918463218 0.000537944677922265 0.000534207896343729 0.000530503238938447 0.000526830374941375 0.000523188977556549 0.000519578723902888 0.000515999294960822 0.000512450375519731 0.000508931654126172 0.000505442823032901 0.000501983578148657 0.000498553618988709 0.000495152648626144 0.000491780373643889 0.000488436504087459 0.000485120753418407 0.000481832838468478 0.000478572479394444 0.000475339399633617 0.000472133325860024 0.000468953987941243 0.000465801118895864 0.000462674454851606 0.000459573735004030 0.000456498701575891 0.000453449099777065 0.000450424677765088 0.000447425186606268 0.000444450380237373 0.000441500015427885 0.000438573851742798 0.000435671651505979 0.000432793179764053 0.000429938204250819 0.000427106495352190 0.000424297826071640 0.000421511971996158 0.000418748711262697 0.000416007824525103 0.000413289094921538 0.000410592308042362 0.000407917251898487 0.000405263716890185 0.000402631495776345 0.000400020383644178 0.000397430177879353 0.000394860678136560 0.000392311686310504 0.000389783006507303];
BL7_Radius=[5.00000000000000e-11 6.00000000000000e-11 7.00000000000000e-11 8.00000000000000e-11 9.00000000000000e-11 1.00000000000000e-10 1.10000000000000e-10 1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09];
BL7_RelF=[0.00113728160642434 0.00200983743125938 0.00308747435731394 0.00430899768562884 0.00561313221960159 0.00694568066111522 0.00826234672786150 0.00952909211681527 0.0107212584886484 0.0118221840045241 0.0128217135162585 0.0137148016254646 0.0145002936796813 0.0151799080538568 0.0157574119942949 0.0162379694893237 0.0166276351434818 0.0169329682991490 0.0171607441079269 0.0173177415127988 0.0174105914421267 0.0174456715958482 0.0174290368866731 0.0173663768564000 0.0172629932442074 0.0171237923868508 0.0169532883333944 0.0167556135109319 0.0165345345288733 0.0162934712973743 0.0160355180933995 0.0157634655627704 0.0154798229202230 0.0151868398194876 0.0148865275256205 0.0145806791432766 0.0142708887459786 0.0139585693195264 0.0136449694828246 0.0133311889857523 0.0130181930095006 0.0127068253125833 0.0123978202774448 0.0120918139197543 0.0117893539262720 0.0114909087884809 0.0111968760987127 0.0109075900737609 0.0106233283683892 0.0103443182379988 0.0100707421062477 0.00980274258977780 0.00954042702853882 0.00928387156656905 0.00903312482458365 0.00878821120235827 0.00854913384571306 0.00831587730991148 0.00808840994849811 0.00786668605400881 0.00765064777459221 0.00744022682837761 0.00723534603539978 0.00703592068503878 0.00684185975523983 0.00665306699823445 0.00646944190607898 0.00629088056804850 0.00611727643076407 0.00594852097087819 0.00578450428918964 0.00562511563419424 0.00547024386229574 0.00531977784119396 0.00517360680232644 0.00503162064766211 0.00489371021562267 0.00475976751043507 0.00462968589879227 0.00450336027731466 0.00438068721395671 0.00426156506619003 0.00414589407851107 0.00403357646156591 0.00392451645495476 0.00381862037557033 0.00371579665313737 0.00361595585445084 0.00351901069765842 0.00342487605779495 0.00333346896465221 0.00324470859395713 0.00315851625272792 0.00307481535958958 0.00299353142074657 0.00291459200223726 0.00283792669902804 0.00276346710144520 0.00269114675938855 0.00262090114472229 0.00255266761219479 0.00248638535919940 0.00242199538465344 0.00235944044723995 0.00229866502322870 0.00223961526406696 0.00218223895390722 0.00212648546721865 0.00207230572661001 0.00201965216097540 0.00196847866405879 0.00191874055352036 0.00187039453057528 0.00182339864026480 0.00177771223241039 0.00173329592329252 0.00169011155808838 0.00164812217409612 0.00160729196476693 0.00156758624456111 0.00152897141463943 0.00149141492939719 0.00145488526384420 0.00141935188183129 0.00138478520512060 0.00135115658329482 0.00131843826449812 0.00128660336699995 0.00125562585157100 0.00122548049465947 0.00119614286235457 0.00116758928512331 0.00113979683330553 0.00111274329335199 0.00108640714478928 0.00106076753789537 0.00103580427206892 0.00101149777487573 0.000987829081755069 0.000964779816368971 0.000942332171577486 0.000920468891022815 0.000899173251305567 0.000878429044736395 0.000858220562646524];
BL9_Radius=[1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10];
BL9_RelF=[0.00643275650703979 0.0109936886650265 0.0171841012961535 0.0248398914676343 0.0335180661088404 0.0425580157441801 0.0511952952243066 0.0586933614552289 0.0644585829140727 0.0681147607522374 0.0695286933271391 0.0687918674245139 0.0661717225834637 0.0620485157201826 0.0568519380147001 0.0510073580020137 0.0448967592273711 0.0388353603471999 0.0330621197246402 0.0277408787246732 0.0229685281642647 0.0187869223756017 0.0151959671995235 0.0121661074636164 0.00964916958904200 0.00758709419521889 0.00591850096494593 0.00458327902836318 0.00352552309641729 0.00269517469238914];
BL10_Radius=[2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10];
BL10_RelF=[0.00558666760168877 0.0109261000799806 0.0189843587313627 0.0297210982763746 0.0424323057898335 0.0558184656883547 0.0682625137051578 0.0782115525885055 0.0845227794806311 0.0866674583174558 0.0847564318238966 0.0794169454825079 0.0715878499698709 0.0623040372943250 0.0525216732751618 0.0430083725754844 0.0342986322240087 0.0267001589888653 0.0203314544184756 0.0151724969267886 0.0111152298378119 0.00800612698091576 0.00567776893861931 0.00396952100392354];
BL11_Radius=[2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10];
BL11_RelF=[0.00564689399819201 0.0109316598388838 0.0188454254258097 0.0293336567220111 0.0417144515615469 0.0547473578940913 0.0668946723110195 0.0766769502821919 0.0829953535881220 0.0853240873831949 0.0837389839297341 0.0788081629722419 0.0714049413478037 0.0625075276200083 0.0530334569635581 0.0437323217927183 0.0351386293229693 0.0275727742890614 0.0211726675590624 0.0159393350426654 0.0117838787635885 0.00856813321835028 0.00613564794349356 0.00433265193512523 0.00302037829455658];
BL12_Radius=[2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10];
BL12_RelF=[0.00578960991162130 0.0112879374056116 0.0195493612648478 0.0305024079677977 0.0433963576212985 0.0568832661490233 0.0693119547910829 0.0791208457134457 0.0851858847161489 0.0870177007692090 0.0847752787749709 0.0791307216296951 0.0710558147393310 0.0616027457618701 0.0517300823492245 0.0421965749041050 0.0335213007502762 0.0259943722264989 0.0197177795631346 0.0146579855439427 0.0106971421897810 0.00767554138400859 0.00542259575077485 0.00377673812229993];
BL14_Radius=[2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10];
BL14_RelF=[0.00824044726233499 0.0151812409641498 0.0250137613318336 0.0373371355645299 0.0510484912407437 0.0645419027951324 0.0760866842747716 0.0842393921783516 0.0881463175731758 0.0876571305193410 0.0832517046587737 0.0758415647824465 0.0665281175745372 0.0563872081314014 0.0463200131847821 0.0369799714430945 0.0287640634848230 0.0218468649906707 0.0162352410287080 0.0118263708936722 0.00845835824220021 0.00594861126632952 0.00411940661419680];
BL3_Radius=BL3_Radius*10^9; %to [nm]
BL5_Radius=BL5_Radius*10^9; %to [nm]
BL7_Radius=BL7_Radius*10^9; %to [nm]
BL9_Radius=BL9_Radius*10^9; %to [nm]
BL10_Radius=BL10_Radius*10^9; %to [nm]
BL11_Radius=BL11_Radius*10^9; %to [nm]
BL12_Radius=BL12_Radius*10^9; %to [nm]
BL14_Radius=BL14_Radius*10^9; %to [nm]

R=[9.77211E+13	1.43623E+14	2.22864E+14	3.03306E+14	3.7686E+14	4.71214E+14	5.3011E+14	6.32875E+14]; %Hydraulic Resistance [1/m]
R_Conf=[4.07521E+12	3.55762E+12	3.40568E+12	8.00767E+12	1.41906E+13	1.52228E+13	1.58363E+13	3.35242E+13]; %95% Confidence Hydraulic Resistance
DXE=[2.82014E-06	2.07672E-06	1.8843E-06	3.18835E-06	3.9502E-06	4.93856E-06	5.55594E-06	6.63525E-06]*10^6; %effective membrane thickness [um]
DXE_Conf=[1.68663E-07	1.45993E-07	1.24295E-07	1.09635E-07	1.03963E-07	1.14967E-07	1.16784E-07	1.9973E-07]*10^6;
MPR=[3.66E-11	3.005E-11	7.45743E-11	2.64687E-10	2.72343E-10	2.72592E-10	2.71648E-10	2.76823E-10]*10^9; %mean pore radius [nm]
MPR_Conf=[3.55389E-11	2.53195E-11	3.52674E-11	1.20481E-11	8.266E-12	8.60412E-12	8.04499E-12	1.33673E-11]*10^9;
PRS=[4.92E-11	3.85744E-11	6.02358E-11	5.23065E-11	4.34153E-11	4.39462E-11	4.32311E-11	4.28076E-11]*10^9; %pore radius spread [nm]
PRS_Conf=[3.63E-11	2.44434E-11	1.75256E-11	6.66696E-12	6.1326E-12	6.13284E-12	6.00898E-12	1.00302E-11]*10^9;

%Data from Regenspurg 2021. Assume: density=1.1kg/L (Khler 2009), swelling 90%.
Bilayer=[1 2 3 4 5 6 7 8];
Adsorption=[0.8754 2.15411 4.9348 9.83619 18.38418 29.44906 39.35467 57.12342]; %mg/m^2
Thickness=Adsorption/10^6/1100*10^9*1.35;
T_Conf=[0.07237 0.09206 0.09391 0.1881 0.48168 0.35148 0.70959 0.37273]/10^6/1100*1.35*10^9;


figure;
hold on;
box on;
pbaspect([1 1 1])
plot(BL3_Radius,BL3_RelF,'.','MarkerSize',6,'Color',[0,0,0]./255);%'k'
plot(BL5_Radius,BL5_RelF,'.','MarkerSize',6,'Color',[96,58,232]./255);%'b'
plot(BL7_Radius,BL7_RelF,'.','MarkerSize',6,'Color',[230,68,62]./255);%'r'
plot(BL9_Radius,BL9_RelF,'.','MarkerSize',6,'Color',[0,0,0]./255);%'k'
plot(BL10_Radius,BL10_RelF,'.','MarkerSize',6,'Color',[96,58,232]./255);%'b'
plot(BL14_Radius,BL14_RelF,'.','MarkerSize',6,'Color',[230,68,62]./255);%'r'
axis([0.1,10,0,0.1]);
title('PAH/PAA');
yticks([0.02 0.04 0.06 0.08 0.1]);
xlabel('Pore Radius [nm]');
set(gca,'FontSize',15)
ylabel('Relative Flux [-]');
ax = gca;
set(gca, 'XScale', 'log')
xticks([0.1 1 10]);

%Spline to guide Eye
s=spline(BL9_Radius,BL9_RelF,BL9_Radius(1):0.002:BL9_Radius(end));
plot(BL9_Radius(1):0.002:BL9_Radius(end),s,'-','Color',[0,0,0]./255);%'k'
s=spline(BL10_Radius,BL10_RelF,BL10_Radius(1):0.002:BL10_Radius(end));
plot(BL10_Radius(1):0.002:BL10_Radius(end),s,'-','Color',[96,58,232]./255);%'b'
s=spline(BL14_Radius,BL14_RelF,BL14_Radius(1):0.002:BL14_Radius(end));
plot(BL14_Radius(1):0.002:BL14_Radius(end),s,'-','Color',[230,68,62]./255);%'r'

BL=[3;5;7;9;10;11;12;14]; %Bilayer number

figure;
hold on;
box on;
pbaspect([1 1 1])
yyaxis left
errorbar(BL,DXE,DXE_Conf,DXE_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
axis([0,16,0,25]);
title('PAH/PAA');
yticks([5 10 15 20 25]);
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Effective Membrane Thickness [\mum]');
yyaxis right
errorbar(Bilayer,Thickness,T_Conf,T_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
axis([0,16,0,150]);
ylabel('Thickness from Reflectometry [nm]');
yticks([50 100 150]);
ax = gca;
ax.YAxis(1).Color = 'k';
ax.YAxis(2).Color = 'k';
xticks([2 4 6 8 10 12 14]);

%slope_R=(Thickness(end)-Thickness(end-3))/3;
%slope_M=(DXE(end)-DXE(end-4))/4;
%Conf_slope_R=((1/3)^2*(T_Conf(end))^2+(-1/3)^2*(T_Conf(end-3))^2)^(1/2);
%Conf_slope_M=((1/5)^2*(DXE_Conf(end))^2+(-1/5)^2*(DXE_Conf(end-4))^2)^(1/2);
%% Log-Normal Distribution + Imperfections Fit Correlation 2 (Shimada)
%PDADMAC/PSS
BL=[2;3;4;6;7;8;9;10]; %Bilayer number
MPR=[2.02088E-10	4.03619E-10	4.77333E-10	4.86002E-10	4.80812E-10	4.77755E-10	4.8029E-10	4.81964E-10]*10^9; %mean pore radius [nm]
MPR_Conf=[1.13008E-10	4.96688E-11	1.84321E-11	1.43485E-11	1.9131E-11	1.09301E-11	1.28279E-11	1.40588E-11]*10^9; %mean pore radius 95% Confidence [nm]
PRS=[1.84051E-10	1.52663E-10	8.58338E-11	6.24627E-11	5.89441E-11	5.68525E-11	5.69771E-11	5.36259E-11]*10^9; %pore radius spread [nm]
PRS_Conf=[6.39379E-11	7.21043E-12	1.39233E-11	1.66474E-11	2.28946E-11	1.41468E-11	1.61833E-11	1.97996E-11]*10^9; %pore radius spread 95% Confidence [nm]
IMP=[3.05843E-12	3.259621535	1.213986078	0.326546121	0.309842935	0.331999507	0.333652504	0.361790997]; %non selective flux percentage [%]
IMP_Conf=[1.930938546	0.979666703	0.553666227	0.445112551	0.585046845	0.396318159	0.416809179	0.509725112]; %non selective flux percentage 95% Confidence [%]
DXE=[1.86277E-06	1.05648E-06	1.04449E-06	1.11574E-06	1.13944E-06	1.20013E-06	1.24982E-06	1.34531E-06]*10^6; %effective membrane thickness [um]
DXE_Conf=[9.89602E-08	1.03212E-07	6.41278E-08	5.28471E-08	6.74719E-08	4.30554E-08	4.57169E-08	5.49188E-08]*10^6; %effective membrane thickness 95% Confidence [um]
IMPA=[6.57714E-13	0.430446906	0.136763973	0.033452235	0.030174847	0.028403574	0.029578387	0.029426293]; %non selective flux in absolute permeability [LMHbar]
IMPA_Conf=[0.415247399	0.131303364	0.06288047	0.045617707	0.057039846	0.033917504	0.036966364	0.04146728]; %non selective flux in absolute permeability 95% Confidence [LMHbar]

figure;
hold on;
box on;
pbaspect([1 1 1])
errorbar(BL,IMPA,IMPA_Conf,IMPA_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
axis([0,16,0,0.6]);
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Permeability of Imperfections [LMH/bar]');
xticks([2 4 6 8 10 12 14 16]);
yticks([0.2 0.4 0.6]);

%PAH/PAA
BL=[3;5;7;9;10;11;12;14]; %Bilayer number
MPR=[2.49541E-10	1.95046E-10	2.00683E-10	3.20467E-10	3.25569E-10	3.25584E-10	3.24174E-10	3.28334E-10]*10^9; %mean pore radius [nm]
MPR_Conf=[1.20709E-10	7.17776E-11	3.95106E-11	7.35971E-12	7.25515E-12	6.27753E-12	6.1829E-12	2.97477E-11]*10^9; %mean pore radius 95% Confidence [nm]
PRS=[1.64485E-10	1.2817E-10	9.78827E-11	2.9995E-11	1.81023E-11	1.75129E-11	1.76541E-11	7.31115E-12]*10^9; %pore radius spread [nm]
PRS_Conf=[3.58509E-11	2.18776E-11	4.48498E-12	8.11869E-12	1.26422E-11	1.108E-11	1.03894E-11	5.50948E-11]*10^9; %pore radius spread 95% Confidence [nm]
IMP=[7.782815914	5.560733223	3.230314009	3.873992529	2.229338125	3.110345586	2.947452096	4.30694806]; %non selective flux percentage [%]
IMP_Conf=[3.403850264	2.389398809	1.288800092	0.689009932	0.808122227	0.725100645	0.698164238	1.120541926]; %non selective flux percentage 95% Confidence [%]
DXE=[4.54549E-06	4.13778E-06	3.2185E-06	4.1282E-06	5.11442E-06	6.39433E-06	7.19363E-06	8.59009E-06]*10^6; %effective membrane thickness [um]
DXE_Conf=[1.83191E-07	1.55926E-07	1.16388E-07	7.98571E-08	1.01719E-07	1.00736E-07	1.03312E-07	1.89953E-07]*10^6; %effective membrane thickness 95% Confidence [um]
IMPA=[0.275508196	0.128768851	0.047988868	0.041614738	0.020935116	0.023034499	0.019024955	0.026342777]; %non selective flux in absolute permeability [LMHbar]
IMPA_Conf=[0.124763645	0.05945408	0.019284608	0.009532612	0.007757044	0.005887269	0.005264845	0.007132607]; %non selective flux in absolute permeability 95% Confidence [LMHbar]

errorbar(BL,IMPA,IMPA_Conf,IMPA_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
hold off;

%PDADMAC/PSS
BL=[2;3;4;6;7;8;9;10]; %Bilayer number
MPR=[2.02088E-10	4.03619E-10	4.77333E-10	4.86002E-10	4.80812E-10	4.77755E-10	4.8029E-10	4.81964E-10]*10^9; %mean pore radius [nm]
MPR_Conf=[1.13008E-10	4.96688E-11	1.84321E-11	1.43485E-11	1.9131E-11	1.09301E-11	1.28279E-11	1.40588E-11]*10^9; %mean pore radius 95% Confidence [nm]
PRS=[1.84051E-10	1.52663E-10	8.58338E-11	6.24627E-11	5.89441E-11	5.68525E-11	5.69771E-11	5.36259E-11]*10^9; %pore radius spread [nm]
PRS_Conf=[6.39379E-11	7.21043E-12	1.39233E-11	1.66474E-11	2.28946E-11	1.41468E-11	1.61833E-11	1.97996E-11]*10^9; %pore radius spread 95% Confidence [nm]
IMP=[3.05843E-12	3.259621535	1.213986078	0.326546121	0.309842935	0.331999507	0.333652504	0.361790997]; %non selective flux percentage [%]
IMP_Conf=[1.930938546	0.979666703	0.553666227	0.445112551	0.585046845	0.396318159	0.416809179	0.509725112]; %non selective flux percentage 95% Confidence [%]
DXE=[1.86277E-06	1.05648E-06	1.04449E-06	1.11574E-06	1.13944E-06	1.20013E-06	1.24982E-06	1.34531E-06]*10^6; %effective membrane thickness [um]
DXE_Conf=[9.89602E-08	1.03212E-07	6.41278E-08	5.28471E-08	6.74719E-08	4.30554E-08	4.57169E-08	5.49188E-08]*10^6; %effective membrane thickness 95% Confidence [um]
IMPA=[6.57714E-13	0.430446906	0.136763973	0.033452235	0.030174847	0.028403574	0.029578387	0.029426293]; %non selective flux in absolute permeability [LMHbar]
IMPA_Conf=[0.415247399	0.131303364	0.06288047	0.045617707	0.057039846	0.033917504	0.036966364	0.04146728]; %non selective flux in absolute permeability 95% Confidence [LMHbar]

figure;
hold on;
box on;
pbaspect([1 1 1])
errorbar(BL,IMP,IMP_Conf,IMP_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
axis([0,16,0,12]);
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Non-selective Flux [%]');
xticks([2 4 6 8 10 12 14 16]);
yticks([3 6 9 12]);

%PAH/PAA
BL=[3;5;7;9;10;11;12;14]; %Bilayer number
MPR=[2.49541E-10	1.95046E-10	2.00683E-10	3.20467E-10	3.25569E-10	3.25584E-10	3.24174E-10	3.28334E-10]*10^9; %mean pore radius [nm]
MPR_Conf=[1.20709E-10	7.17776E-11	3.95106E-11	7.35971E-12	7.25515E-12	6.27753E-12	6.1829E-12	2.97477E-11]*10^9; %mean pore radius 95% Confidence [nm]
PRS=[1.64485E-10	1.2817E-10	9.78827E-11	2.9995E-11	1.81023E-11	1.75129E-11	1.76541E-11	7.31115E-12]*10^9; %pore radius spread [nm]
PRS_Conf=[3.58509E-11	2.18776E-11	4.48498E-12	8.11869E-12	1.26422E-11	1.108E-11	1.03894E-11	5.50948E-11]*10^9; %pore radius spread 95% Confidence [nm]
IMP=[7.782815914	5.560733223	3.230314009	3.873992529	2.229338125	3.110345586	2.947452096	4.30694806]; %non selective flux percentage [%]
IMP_Conf=[3.403850264	2.389398809	1.288800092	0.689009932	0.808122227	0.725100645	0.698164238	1.120541926]; %non selective flux percentage 95% Confidence [%]
DXE=[4.54549E-06	4.13778E-06	3.2185E-06	4.1282E-06	5.11442E-06	6.39433E-06	7.19363E-06	8.59009E-06]*10^6; %effective membrane thickness [um]
DXE_Conf=[1.83191E-07	1.55926E-07	1.16388E-07	7.98571E-08	1.01719E-07	1.00736E-07	1.03312E-07	1.89953E-07]*10^6; %effective membrane thickness 95% Confidence [um]
IMPA=[0.275508196	0.128768851	0.047988868	0.041614738	0.020935116	0.023034499	0.019024955	0.026342777]; %non selective flux in absolute permeability [LMHbar]
IMPA_Conf=[0.124763645	0.05945408	0.019284608	0.009532612	0.007757044	0.005887269	0.005264845	0.007132607]; %non selective flux in absolute permeability 95% Confidence [LMHbar]

errorbar(BL,IMP,IMP_Conf,IMP_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
hold off;

%PDADMAC/PSS
BL2_Radius=[1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09 2.09000000000000e-09 2.10000000000000e-09 2.11000000000000e-09 2.12000000000000e-09 2.13000000000000e-09 2.14000000000000e-09 2.15000000000000e-09 2.16000000000000e-09 2.17000000000000e-09 2.18000000000000e-09 2.19000000000000e-09 2.20000000000000e-09 2.21000000000000e-09 2.22000000000000e-09 2.23000000000000e-09 2.24000000000000e-09 2.25000000000000e-09 2.26000000000000e-09 2.27000000000000e-09 2.28000000000000e-09 2.29000000000000e-09 2.30000000000000e-09 2.31000000000000e-09 2.32000000000000e-09 2.33000000000000e-09 2.34000000000000e-09 2.35000000000000e-09 2.36000000000000e-09 2.37000000000000e-09 2.38000000000000e-09 2.39000000000000e-09 2.40000000000000e-09 2.41000000000000e-09 2.42000000000000e-09 2.43000000000000e-09 2.44000000000000e-09 2.45000000000000e-09 2.46000000000000e-09 2.47000000000000e-09 2.48000000000000e-09 2.49000000000000e-09 2.50000000000000e-09 2.51000000000000e-09 2.52000000000000e-09 2.53000000000000e-09 2.54000000000000e-09 2.55000000000000e-09 2.56000000000000e-09 2.57000000000000e-09 2.58000000000000e-09 2.59000000000000e-09 2.60000000000000e-09 2.61000000000000e-09 2.62000000000000e-09 2.63000000000000e-09 2.64000000000000e-09 2.65000000000000e-09 2.66000000000000e-09 2.67000000000000e-09 2.68000000000000e-09 2.69000000000000e-09 2.70000000000000e-09 2.71000000000000e-09 2.72000000000000e-09 2.73000000000000e-09 2.74000000000000e-09 2.75000000000000e-09 2.76000000000000e-09 2.77000000000000e-09 2.78000000000000e-09 2.79000000000000e-09 2.80000000000000e-09 2.81000000000000e-09 2.82000000000000e-09 2.83000000000000e-09 2.84000000000000e-09 2.85000000000000e-09 2.86000000000000e-09 2.87000000000000e-09 2.88000000000000e-09 2.89000000000000e-09 2.90000000000000e-09 2.91000000000000e-09 2.92000000000000e-09 2.93000000000000e-09 2.94000000000000e-09 2.95000000000000e-09 2.96000000000000e-09 2.97000000000000e-09 2.98000000000000e-09 2.99000000000000e-09 3.00000000000000e-09 3.01000000000000e-09 3.02000000000000e-09 3.03000000000000e-09 3.04000000000000e-09 3.05000000000000e-09 3.06000000000000e-09 3.07000000000000e-09 3.08000000000000e-09 3.09000000000000e-09 3.10000000000000e-09 3.11000000000000e-09 3.12000000000000e-09 3.13000000000000e-09 3.14000000000000e-09 3.15000000000000e-09 3.16000000000000e-09 3.17000000000000e-09 3.18000000000000e-09 3.19000000000000e-09 3.20000000000000e-09 3.21000000000000e-09 3.22000000000000e-09 3.23000000000000e-09 3.24000000000000e-09 3.25000000000000e-09 3.26000000000000e-09 3.27000000000000e-09 3.28000000000000e-09 3.29000000000000e-09 3.30000000000000e-09 3.31000000000000e-09 3.32000000000000e-09 3.33000000000000e-09 3.34000000000000e-09 3.35000000000000e-09 3.36000000000000e-09 3.37000000000000e-09 3.38000000000000e-09 3.39000000000000e-09 3.40000000000000e-09 3.41000000000000e-09 3.42000000000000e-09 3.43000000000000e-09 3.44000000000000e-09 3.45000000000000e-09 3.46000000000000e-09 3.47000000000000e-09 3.48000000000000e-09 3.49000000000000e-09 3.50000000000000e-09 3.51000000000000e-09 3.52000000000000e-09 3.53000000000000e-09 3.54000000000000e-09 3.55000000000000e-09 3.56000000000000e-09 3.57000000000000e-09 3.58000000000000e-09 3.59000000000000e-09 3.60000000000000e-09 3.61000000000000e-09 3.62000000000000e-09 3.63000000000000e-09 3.64000000000000e-09 3.65000000000000e-09 3.66000000000000e-09 3.67000000000000e-09 3.68000000000000e-09 3.69000000000000e-09 3.70000000000000e-09 3.71000000000000e-09 3.72000000000000e-09 3.73000000000000e-09 3.74000000000000e-09 3.75000000000000e-09 3.76000000000000e-09 3.77000000000000e-09 3.78000000000000e-09 3.79000000000000e-09 3.80000000000000e-09 3.81000000000000e-09 3.82000000000000e-09 3.83000000000000e-09 3.84000000000000e-09 3.85000000000000e-09 3.86000000000000e-09 3.87000000000000e-09 3.88000000000000e-09 3.89000000000000e-09 3.90000000000000e-09 3.91000000000000e-09 3.92000000000000e-09 3.93000000000000e-09 3.94000000000000e-09 3.95000000000000e-09 3.96000000000000e-09 3.97000000000000e-09 3.98000000000000e-09 3.99000000000000e-09 4.00000000000000e-09 4.01000000000000e-09 4.02000000000000e-09 4.03000000000000e-09 4.04000000000000e-09 4.05000000000000e-09 4.06000000000000e-09 4.07000000000000e-09 4.08000000000000e-09 4.09000000000000e-09 4.10000000000000e-09 4.11000000000000e-09 4.12000000000000e-09 4.13000000000000e-09 4.14000000000000e-09 4.15000000000000e-09 4.16000000000000e-09 4.17000000000000e-09 4.18000000000000e-09 4.19000000000000e-09 4.20000000000000e-09 4.21000000000000e-09 4.22000000000000e-09 4.23000000000000e-09 4.24000000000000e-09 4.25000000000000e-09 4.26000000000000e-09 4.27000000000000e-09 4.28000000000000e-09 4.29000000000000e-09 4.30000000000000e-09 4.31000000000000e-09 4.32000000000000e-09 4.33000000000000e-09 4.34000000000000e-09 4.35000000000000e-09 4.36000000000000e-09 4.37000000000000e-09 4.38000000000000e-09 4.39000000000000e-09 4.40000000000000e-09 4.41000000000000e-09 4.42000000000000e-09 4.43000000000000e-09 4.44000000000000e-09 4.45000000000000e-09 4.46000000000000e-09 4.47000000000000e-09 4.48000000000000e-09 4.49000000000000e-09 4.50000000000000e-09 4.51000000000000e-09 4.52000000000000e-09 4.53000000000000e-09 4.54000000000000e-09 4.55000000000000e-09 4.56000000000000e-09 4.57000000000000e-09 4.58000000000000e-09 4.59000000000000e-09 4.60000000000000e-09 4.61000000000000e-09 4.62000000000000e-09 4.63000000000000e-09 4.64000000000000e-09 4.65000000000000e-09 4.66000000000000e-09 4.67000000000000e-09 4.68000000000000e-09 4.69000000000000e-09 4.70000000000000e-09 4.71000000000000e-09 4.72000000000000e-09 4.73000000000000e-09 4.74000000000000e-09 4.75000000000000e-09 4.76000000000000e-09 4.77000000000000e-09 4.78000000000000e-09 4.79000000000000e-09 4.80000000000000e-09 4.81000000000000e-09 4.82000000000000e-09 4.83000000000000e-09 4.84000000000000e-09 4.85000000000000e-09 4.86000000000000e-09 4.87000000000000e-09 4.88000000000000e-09 4.89000000000000e-09 4.90000000000000e-09 4.91000000000000e-09 4.92000000000000e-09 4.93000000000000e-09 4.94000000000000e-09 4.95000000000000e-09 4.96000000000000e-09 4.97000000000000e-09 4.98000000000000e-09 4.99000000000000e-09 5.00000000000000e-09 5.01000000000000e-09 5.02000000000000e-09 5.03000000000000e-09 5.04000000000000e-09 5.05000000000000e-09 5.06000000000000e-09 5.07000000000000e-09 5.08000000000000e-09 5.09000000000000e-09 5.10000000000000e-09 5.11000000000000e-09 5.12000000000000e-09 5.13000000000000e-09 5.14000000000000e-09 5.15000000000000e-09 5.16000000000000e-09 5.17000000000000e-09 5.18000000000000e-09 5.19000000000000e-09 5.20000000000000e-09 5.21000000000000e-09 5.22000000000000e-09 5.23000000000000e-09 5.24000000000000e-09 5.25000000000000e-09 5.26000000000000e-09 5.27000000000000e-09 5.28000000000000e-09 5.29000000000000e-09 5.30000000000000e-09 5.31000000000000e-09 5.32000000000000e-09 5.33000000000000e-09 5.34000000000000e-09 5.35000000000000e-09 5.36000000000000e-09 5.37000000000000e-09 5.38000000000000e-09 5.39000000000000e-09 5.40000000000000e-09 5.41000000000000e-09 5.42000000000000e-09 5.43000000000000e-09 5.44000000000000e-09 5.45000000000000e-09 5.46000000000000e-09 5.47000000000000e-09 5.48000000000000e-09 5.49000000000000e-09 5.50000000000000e-09 5.51000000000000e-09 5.52000000000000e-09 5.53000000000000e-09 5.54000000000000e-09 5.55000000000000e-09 5.56000000000000e-09 5.57000000000000e-09 5.58000000000000e-09 5.59000000000000e-09 5.60000000000000e-09 5.61000000000000e-09 5.62000000000000e-09 5.63000000000000e-09 5.64000000000000e-09 5.65000000000000e-09 5.66000000000000e-09 5.67000000000000e-09 5.68000000000000e-09 5.69000000000000e-09 5.70000000000000e-09 5.71000000000000e-09 5.72000000000000e-09 5.73000000000000e-09 5.74000000000000e-09 5.75000000000000e-09 5.76000000000000e-09 5.77000000000000e-09 5.78000000000000e-09 5.79000000000000e-09 5.80000000000000e-09 5.81000000000000e-09 5.82000000000000e-09 5.83000000000000e-09 5.84000000000000e-09 5.85000000000000e-09 5.86000000000000e-09 5.87000000000000e-09 5.88000000000000e-09 5.89000000000000e-09 5.90000000000000e-09 5.91000000000000e-09 5.92000000000000e-09 5.93000000000000e-09 5.94000000000000e-09 5.95000000000000e-09 5.96000000000000e-09 5.97000000000000e-09 5.98000000000000e-09 5.99000000000000e-09 6.00000000000000e-09 6.01000000000000e-09 6.02000000000000e-09 6.03000000000000e-09 6.04000000000000e-09 6.05000000000000e-09 6.06000000000000e-09 6.07000000000000e-09 6.08000000000000e-09 6.09000000000000e-09 6.10000000000000e-09 6.11000000000000e-09 6.12000000000000e-09 6.13000000000000e-09 6.14000000000000e-09];
BL2_RelF=[0.000235695035628154 0.000290925702548703 0.000351728856286805 0.000417737840591722 0.000488546449184317 0.000563723521842670 0.000642824919202590 0.000725403169591954 0.000811015097939349 0.000899227736958744 0.000989622797069651 0.00108179994160402 0.00117537908236498 0.00127000188013453 0.00136533260663527 0.00146105849933550 0.00155688971850252 0.00165255899695306 0.00174782105679242 0.00184245185377988 0.00193624769850236 0.00202902429398162 0.00212061572140820 0.00221087339913992 0.00229966503470833 0.00238687358515427 0.00247239623740296 0.00255614341745371 0.00263803783478321 0.00271801356644746 0.00279601518383584 0.00287199692381150 0.00294592190501129 0.00301776138932749 0.00308749408801416 0.00315510551142136 0.00322058736103393 0.00328393696225631 0.00334515673622271 0.00340425370880872 0.00346123905496338 0.00351612767646018 0.00356893781117352 0.00361969067201695 0.00366841011372569 0.00371512232572433 0.00375985554938796 0.00380263981807734 0.00384350671840581 0.00388248917127372 0.00391962123128499 0.00395493790323862 0.00398847497446493 0.00402026886185063 0.00405035647246933 0.00407877507680323 0.00410556219360811 0.00413075548553666 0.00415439266469543 0.00417651140736681 0.00419714927718126 0.00421634365607514 0.00423413168241665 0.00425055019572682 0.00426563568746385 0.00427942425737790 0.00429195157497968 0.00430325284569984 0.00431336278134784 0.00432231557450802 0.00433014487653814 0.00433688377886082 0.00434256479726184 0.00434721985893140 0.00435088029200438 0.00435357681737483 0.00435533954257699 0.00435619795754184 0.00435618093205262 0.00435531671473707 0.00435363293344703 0.00435115659688689 0.00434791409736625 0.00434393121455782 0.00433923312015566 0.00433384438333448 0.00432778897692001 0.00432109028418790 0.00431377110621498 0.00430585366971349 0.00429735963528481 0.00428831010603422 0.00427872563649361 0.00426862624180352 0.00425803140711036 0.00424696009713796 0.00423543076589728 0.00422346136650036 0.00421106936104845 0.00419827173056661 0.00418508498496011 0.00417152517296990 0.00415760789210709 0.00414334829854801 0.00412876111697362 0.00411386065033862 0.00409866078955706 0.00408317502309306 0.00406741644644618 0.00405139777152247 0.00403513133588328 0.00401862911186490 0.00400190271556306 0.00398496341567722 0.00396782214221029 0.00395048949502023 0.00393297575222049 0.00391529087842713 0.00389744453285050 0.00387944607723052 0.00386130458361441 0.00384302884197654 0.00382462736768030 0.00380610840878212 0.00378747995317835 0.00376874973559561 0.00374992524442573 0.00373101372840660 0.00371202220315021 0.00369295745751964 0.00367382605985667 0.00365463436406198 0.00363538851552982 0.00361609445693941 0.00359675793390513 0.00357738450048783 0.00355797952456962 0.00353854819309436 0.00351909551717645 0.00349962633708030 0.00348014532707283 0.00346065700015172 0.00344116571265167 0.00342167566873135 0.00340219092474343 0.00338271539349021 0.00336325284836739 0.00334380692739830 0.00332438113716123 0.00330497885661212 0.00328560334080507 0.00326625772451314 0.00324694502575156 0.00322766814920591 0.00320842988956741 0.00318923293477755 0.00317007986918440 0.00315097317661262 0.00313191524334945 0.00311290836104867 0.00309395472955463 0.00307505645964842 0.00305621557571809 0.00303743401835492 0.00301871364687755 0.00300005624178605 0.00298146350714743 0.00296293707291471 0.00294447849718107 0.00292608926837084 0.00290777080736911 0.00288952446959140 0.00287135154699520 0.00285325327003456 0.00283523080956026 0.00281728527866497 0.00279941773447750 0.00278162917990551 0.00276392056532892 0.00274629279024530 0.00272874670486833 0.00271128311168085 0.00269390276694361 0.00267660638216090 0.00265939462550441 0.00264226812319623 0.00262522746085242 0.00260827318478783 0.00259140580328375 0.00257462578781889 0.00255793357426512 0.00254132956404873 0.00252481412527824 0.00250838759383965 0.00249205027446008 0.00247580244174066 0.00245964434115955 0.00244357619004584 0.00242759817852529 0.00241171047043853 0.00239591320423268 0.00238020649382692 0.00236459042945292 0.00234906507847077 0.00233363048616101 0.00231828667649367 0.00230303365287465 0.00228787139887035 0.00227279987891098 0.00225781903897328 0.00224292880724315 0.00222812909475875 0.00221341979603470 0.00219880078966782 0.00218427193892500 0.00216983309231368 0.00215548408413536 0.00214122473502285 0.00212705485246135 0.00211297423129420 0.00209898265421347 0.00208507989223591 0.00207126570516474 0.00205753984203751 0.00204390204156066 0.00203035203253088 0.00201688953424389 0.00200351425689091 0.00199022590194303 0.00197702416252413 0.00196390872377232 0.00195087926319055 0.00193793545098643 0.00192507695040173 0.00191230341803186 0.00189961450413545 0.00188700985293457 0.00187448910290554 0.00186205188706092 0.00184969783322269 0.00183742656428701 0.00182523769848070 0.00181313084960979 0.00180110562730024 0.00178916163723117 0.00177729848136071 0.00176551575814476 0.00175381306274887 0.00174218998725328 0.00173064612085158 0.00171918105004295 0.00170779435881823 0.00169648562884003 0.00168525443961707 0.00167410036867279 0.00166302299170855 0.00165202188276145 0.00164109661435705 0.00163024675765697 0.00161947188260170 0.00160877155804862 0.00159814535190541 0.00158759283125907 0.00157711356250045 0.00156670711144474 0.00155637304344775 0.00154611092351820 0.00153592031642627 0.00152580078680828 0.00151575189926777 0.00150577321847310 0.00149586430925150 0.00148602473667990 0.00147625406617248 0.00146655186356507 0.00145691769519652 0.00144735112798709 0.00143785172951399 0.00142841906808409 0.00141905271280400 0.00140975223364744 0.00140051720152006 0.00139134718832189 0.00138224176700724 0.00137320051164237 0.00136422299746086 0.00135530880091680 0.00134645749973581 0.00133766867296406 0.00132894190101519 0.00132027676571538 0.00131167285034647 0.00130312973968728 0.00129464702005310 0.00128622427933355 0.00127786110702866 0.00126955709428341 0.00126131183392067 0.00125312492047260 0.00124499595021058 0.00123692452117374 0.00122891023319604 0.00122095268793204 0.00121305148888137 0.00120520624141192 0.00119741655278178 0.00118968203216004 0.00118200229064641 0.00117437694128971 0.00116680559910531 0.00115928788109150 0.00115182340624485 0.00114441179557460 0.00113705267211607 0.00112974566094318 0.00112249038918003 0.00111528648601169 0.00110813358269410 0.00110103131256316 0.00109397931104304 0.00108697721565377 0.00108002466601804 0.00107312130386734 0.00106626677304739 0.00105946071952288 0.00105270279138164 0.00104599263883812 0.00103932991423630 0.00103271427205203 0.00102614536889480 0.00101962286350896 0.00101314641677445 0.00100671569170696 0.00100033035345769 0.000993990069312588 0.000987694508691140 0.000981443343144723 0.000975236246354554 0.000969072894129210 0.000962952964401776 0.000956876137226598 0.000950842094775687 0.000944850521334765 0.000938901103298967 0.000932993529168244 0.000927127489542417 0.000921302677115967 0.000915518786672508 0.000909775515078999 0.000904072561279685 0.000898409626289779 0.000892786413188906 0.000887202627114298 0.000881657975253782 0.000876152166838532 0.000870684913135627 0.000865255927440408 0.000859864925068635 0.000854511623348482 0.000849195741612338 0.000843917001188453 0.000838675125392429 0.000833469839518552 0.000828300870830983 0.000823167948554821 0.000818070803867017 0.000813009169887190 0.000807982781668306 0.000802991376187252 0.000798034692335313 0.000793112470908534 0.000788224454598013 0.000783370387980073 0.000778550017506382 0.000773763091493985 0.000769009360115249 0.000764288575387763 0.000759600491164160 0.000754944863121888 0.000750321448752918 0.000745730007353408 0.000741170300013328 0.000736642089606020 0.000732145140777745 0.000727679219937187 0.000723244095244911 0.000718839536602816 0.000714465315643550 0.000710121205719914 0.000705806981894229 0.000701522420927710 0.000697267301269822 0.000693041403047611 0.000688844508055054 0.000684676399742384 0.000680536863205430 0.000676425685174944 0.000672342654005938 0.000668287559667037 0.000664260193729815 0.000660260349358168 0.000656287821297683 0.000652342405865032 0.000648423900937365 0.000644532105941742 0.000640666821844576 0.000636827851141086 0.000633014997844796 0.000629228067477044 0.000625466867056513 0.000621731205088804 0.000618020891556030 0.000614335737906442 0.000610675557044080 0.000607040163318474 0.000603429372514363 0.000599843001841452 0.000596280869924217 0.000592742796791732 0.000589228603867548 0.000585738113959601 0.000582271151250165 0.000578827541285855 0.000575407110967650 0.000572009688540983 0.000568635103585862 0.000565283187007038 0.000561953771024217 0.000558646689162319 0.000555361776241789 0.000552098868368943 0.000548857802926372 0.000545638418563393 0.000542440555186542 0.000539264053950124 0.000536108757246806 0.000532974508698271 0.000529861153145906 0.000526768536641553 0.000523696506438315 0.000520644910981394 0.000517613599899003 0.000514602423993319 0.000511611235231488 0.000508639886736682 0.000505688232779219 0.000502756128767722 0.000499843431240337 0.000496949997856013 0.000494075687385815 0.000491220359704317 0.000488383875781023 0.000485566097671858 0.000482766888510712 0.000479986112501028 0.000477223634907456 0.000474479322047551 0.000471753041283537 0.000469044661014105 0.000466354050666290 0.000463681080687386 0.000461025622536916 0.000458387548678659 0.000455766732572738 0.000453163048667744 0.000450576372392931 0.000448006580150457 0.000445453549307680 0.000442917158189507 0.000440397286070794 0.000437893813168806 0.000435406620635726 0.000432935590551212 0.000430480605915019 0.000428041550639662 0.000425618309543139 0.000423210768341701 0.000420818813642682 0.000418442332937369 0.000416081214593939 0.000413735347850433 0.000411404622807795 0.000409088930422947 0.000406788162501932 0.000404502211693095 0.000402230971480322 0.000399974336176325 0.000397732200915979 0.000395504461649709 0.000393291015136932 0.000391091758939534 0.000388906591415415 0.000386735411712070 0.000384578119760222 0.000382434616267506 0.000380304802712202 0.000378188581337008 0.000376085855142874 0.000373996527882871 0.000371920504056117 0.000369857688901742 0.000367807988392907 0.000365771309230865 0.000363747558839071 0.000361736645357334 0.000359738477636021 0.000357752965230302 0.000355780018394440 0.000353819548076126 0.000351871465910867 0.000349935684216402 0.000348012115987179 0.000346100674888866 0.000344201275252905 0.000342313832071119 0.000340438260990349 0.000338574478307144 0.000336722400962490 0.000334881946536577 0.000333053033243618 0.000331235579926697 0.000329429506052671 0.000327634731707104 0.000325851177589244 0.000324078765007045 0.000322317415872222 0.000320567052695354 0.000318827598581016 0.000317098977222965 0.000315381112899351 0.000313673930467976 0.000311977355361590 0.000310291313583218 0.000308615731701539 0.000306950536846290 0.000305295656703712 0.000303651019512038 0.000302016554057010 0.000300392189667437 0.000298777856210791 0.000297173484088835 0.000295579004233288 0.000293994348101532 0.000292419447672342 0.000290854235441663 0.000289298644418417 0.000287752608120340 0.000286216060569865 0.000284688936290025 0.000283171170300403 0.000281662698113105 0.000280163455728773 0.000278673379632628 0.000277192406790547 0.000275720474645172 0.000274257521112049 0.000272803484575808 0.000271358303886359 0.000269921918355139 0.000268494267751369 0.000267075292298364 0.000265664932669854 0.000264263129986351 0.000262869825811534 0.000261484962148675 0.000260108481437087 0.000258740326548606 0.000257380440784096 0.000256028767869995 0.000254685251954876 0.000253349837606049 0.000252022469806182 0.000250703093949954 0.000249391655840738 0.000248088101687309 0.000246792378100580 0.000245504432090365 0.000244224211062170 0.000242951662814012 0.000241686735533260 0.000240429377793510 0.000239179538551476 0.000237937167143918 0.000236702213284588 0.000235474627061205 0.000234254358932452 0.000233041359725005 0.000231835580630579 0.000230636973203004 0.000229445489355323 0.000228261081356915 0.000227083701830643 0.000225913303750025 0.000224749840436428 0.000223593265556288 0.000222443533118351 0.000221300597470937 0.000220164413299229 0.000219034935622585 0.000217912119791866 0.000216795921486798];
BL3_Radius=[2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09];
BL3_RelF=[0.00120672119246705 0.00155642224833875 0.00196436777316637 0.00243103802191654 0.00295543727779784 0.00353513465182525 0.00416636366942360 0.00484416879765736 0.00556258618331422 0.00631484604390735 0.00709358510567243 0.00789105895152384 0.00869934589721503 0.00951053586819952 0.0103168995609834 0.0111110348419910 0.0118859888022581 0.0126353551160968 0.0133533473380457 0.0140348495234876 0.0146754460940319 0.0152714332153995 0.0158198141424110 0.0163182810424513 0.0167651857637323 0.0171595018935113 0.0175007802766841 0.0177890999559356 0.0180250162665904 0.0182095075849265 0.0183439219975777 0.0184299249387960 0.0184694486366747 0.0184646440220778 0.0184178355866824 0.0183314795298065 0.0182081254073335 0.0180503813891718 0.0178608831430593 0.0176422662905634 0.0173971423241804 0.0171280778307444 0.0168375768342244 0.0165280660487513 0.0162018828188564 0.0158612655169907 0.0155083461671659 0.0151451450668695 0.0147735671862710 0.0143954001332877 0.0140123134845841 0.0136258592954163 0.0132374736148859 0.0128484788472139 0.0124600868137464 0.0120734023842811 0.0116894275597628 0.0113090659012659 0.0109331272123681 0.0105623323934292 0.0101973183968927 0.00983864322249824 0.00948679090022857 0.00914217641693558 0.00880515054991673 0.00847600457728458 0.00815497484082737 0.00784224714224320 0.00753796095819074 0.00724221346358548 0.00695506335602790 0.00667653447722650 0.00640661922982419 0.00614528179018093 0.00589246111947106 0.00564807377693686 0.00541201654035093 0.00518416883970587 0.00496439501090193 0.00475254637676856 0.00454846316316128 0.00435197625814037 0.00416290882238592 0.00398107775905109 0.00380629505121856 0.00363836897501868 0.00347710519630453 0.00332230775856901 0.00317377996954335 0.00303132519364244 0.00289474755712767 0.00276385257254863 0.00263844768870728 0.00251834277206485 0.00240335052518826 0.00229328684751159 0.00218797114337155 0.00208722658196667 0.00199088031358920 0.00189876364618819 0.00181071218604255 0.00172656594605505 0.00164616942492270 0.00156937166019570 0.00149602625800688 0.00142599140203550 0.00135912984406399 0.00129530887829326 0.00123440030140075 0.00117628036015614 0.00112082968825104 0.00106793323385151 0.00101748017924480 0.000969363853824360 0.000923481641538611 0.000879734883819963];
BL4_Radius=[3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10];
BL4_RelF=[0.00274610905869405 0.00396653168255910 0.00552924374244865 0.00745793507947146 0.00975664039404225 0.0124064643228542 0.0153644076895035 0.0185645134454212 0.0219212305959674 0.0253346085778025 0.0286967268455932 0.0318986584579502 0.0348372648151405 0.0374212064868518 0.0395757060089370 0.0412457818214372 0.0423978588190626 0.0430198266393127 0.0431197460726389 0.0427234893490637 0.0418716412782565 0.0406159904522126 0.0390159114404558 0.0371348899574544 0.0350373829855111 0.0327861431178106 0.0304400773724786 0.0280526597670263 0.0256708764249582 0.0233346526619163 0.0210766928780169 0.0189226548521737 0.0168915784281424 0.0149964926870510 0.0132451336765389 0.0116407149881188 0.0101827046109590 0.00886757252816327 0.00768948375133322 0.00664092046935521 0.00571322449660762 0.00489705719152758 0.00418277854605982 0.00356075036464923 0.00302157054532800 0.00255624664802440 0.00215631738602300 0.00181393058909558];
BL6_Radius=[3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10];
BL6_RelF=[0.00502613871884773 0.00775142019633790 0.0113672250035249 0.0159052615826727 0.0213010701093381 0.0273832236240465 0.0338795170949518 0.0404403555333888 0.0466757191672120 0.0521992139895974 0.0566715083152818 0.0598360603091321 0.0615420953407876 0.0617526129743834 0.0605380392613290 0.0580583833397226 0.0545380672878714 0.0502379188245910 0.0454283161632475 0.0403664462448200 0.0352793996312136 0.0303536454721555 0.0257304865396331 0.0215064691808450 0.0177374172342624 0.0144447196050863 0.0116226495014237 0.00924574742599505 0.00727558998574290 0.00566654167563611 0.00437031651892645 0.00333934775249044 0.00252907639550538];
BL7_Radius=[3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10];
BL7_RelF=[0.00547430843365387 0.00859110423608677 0.0127652757661962 0.0180256353101823 0.0242723011066424 0.0312643506161648 0.0386325827635736 0.0459168758021842 0.0526215719680294 0.0582781355818710 0.0625031144601883 0.0650412397707969 0.0657874764136121 0.0647866553533359 0.0622136684659126 0.0583401652817957 0.0534948939978372 0.0480244213876553 0.0422594278659373 0.0364897056954545 0.0309489323237400 0.0258086242826933 0.0211795817450151 0.0171186222762771 0.0136383734798906 0.0107181938427486 0.00831476101756905 0.00637137637153310 0.00482549436912835 0.00361434705505808 0.00267878295923649];
BL8_Radius=[3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10];
BL8_RelF=[0.00339337005472718 0.00573160060722689 0.00910017314891361 0.0136401825507405 0.0193773274188354 0.0261838045896863 0.0337652012886452 0.0416792413265910 0.0493850416501879 0.0563135364896103 0.0619445160798343 0.0658747327028553 0.0678646331914946 0.0678570975733047 0.0659681268772844 0.0624549182646762 0.0576700582553667 0.0520113641600027 0.0458756233058155 0.0396219287090477 0.0335473668763187 0.0278751843294046 0.0227536625713050 0.0182628956952542 0.0144264013409136 0.0112247935757235 0.00860936237646623 0.00651412499959716 0.00486558657036418 0.00358998408022856 0.00261815933957843];
BL9_Radius=[3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10];
BL9_RelF=[0.00513142678684060 0.00824748668282607 0.0125068273347663 0.0179653766519697 0.0245338197586506 0.0319579682089653 0.0398296422540501 0.0476287587501384 0.0547891546855525 0.0607747071254640 0.0651502680197880 0.0676340745577892 0.0681235237755555 0.0666926566974389 0.0635655094496528 0.0590733461878911 0.0536051957031774 0.0475603204528657 0.0413089774167923 0.0351649556062475 0.0293706490188870 0.0240933367785426 0.0194300929595424 0.0154182988120054 0.0120488961135077 0.00928006478648214 0.00704970842194851 0.00528581935764789 0.00391436748809713 0.00286477015691754];
BL10_Radius=[3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10];
BL10_RelF=[0.00390754970112840 0.00668628769411775 0.0107107927639062 0.0161348319003072 0.0229508723478548 0.0309431025428453 0.0396792651193015 0.0485494166198965 0.0568463371866924 0.0638702560565338 0.0690340646923368 0.0719460864741709 0.0724547423781237 0.0706500465962357 0.0668271714467980 0.0614245254518930 0.0549516270508622 0.0479208206221910 0.0407929053573406 0.0339417129963799 0.0276380261083352 0.0220498722658260 0.0172544595804939 0.0132566701705611 0.0100096800954543 0.00743444709493838 0.00543609402715228 0.00391634337449481 0.00278199228382896];
BL2_Radius=BL2_Radius*10^9; %to [nm]
BL3_Radius=BL3_Radius*10^9; %to [nm]
BL4_Radius=BL4_Radius*10^9; %to [nm]
BL6_Radius=BL6_Radius*10^9; %to [nm]
BL7_Radius=BL7_Radius*10^9; %to [nm]
BL8_Radius=BL8_Radius*10^9; %to [nm]
BL9_Radius=BL9_Radius*10^9; %to [nm]
BL10_Radius=BL10_Radius*10^9; %to [nm]

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(BL2_Radius,BL2_RelF,'.','MarkerSize',6,'Color','k');
plot(BL3_Radius,BL3_RelF,'.','MarkerSize',6,'Color','b');
plot(BL4_Radius,BL4_RelF,'.','MarkerSize',6,'Color','r');
plot(BL6_Radius,BL6_RelF,'.','MarkerSize',6,'Color','k');
plot(BL8_Radius,BL8_RelF,'.','MarkerSize',6,'Color','b');
plot(BL10_Radius,BL10_RelF,'.','MarkerSize',6,'Color','r');
axis([0.1,10,0,0.08]);
title('PDADMAC/PSS');
xlabel('Pore Radius [nm]');
set(gca,'FontSize',12)
ylabel('Relative Flux [-]');
ax = gca;
set(gca, 'XScale', 'log')
xticks([0.1 1 10]);
legend('2','3','4','6','8','10');
[leg, icons, plots, txt]  = legend('show');
title(leg,{'Number of','Bilayers [-]'})

%Spline to guide Eye
s=spline(BL4_Radius,BL4_RelF,BL4_Radius(1):0.002:BL4_Radius(end));
plot(BL4_Radius(1):0.002:BL4_Radius(end),s,'-','Color','r');
s=spline(BL6_Radius,BL6_RelF,BL6_Radius(1):0.002:BL6_Radius(end));
plot(BL6_Radius(1):0.002:BL6_Radius(end),s,'-','Color','k');
s=spline(BL8_Radius,BL8_RelF,BL8_Radius(1):0.002:BL8_Radius(end));
plot(BL8_Radius(1):0.002:BL8_Radius(end),s,'-','Color','b');
s=spline(BL10_Radius,BL10_RelF,BL10_Radius(1):0.002:BL10_Radius(end));
plot(BL10_Radius(1):0.002:BL10_Radius(end),s,'-','Color','r');

%PAH/PAA
BL3_Radius=[1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09 2.09000000000000e-09 2.10000000000000e-09 2.11000000000000e-09 2.12000000000000e-09 2.13000000000000e-09 2.14000000000000e-09 2.15000000000000e-09 2.16000000000000e-09 2.17000000000000e-09 2.18000000000000e-09 2.19000000000000e-09 2.20000000000000e-09 2.21000000000000e-09 2.22000000000000e-09 2.23000000000000e-09 2.24000000000000e-09 2.25000000000000e-09 2.26000000000000e-09 2.27000000000000e-09 2.28000000000000e-09 2.29000000000000e-09 2.30000000000000e-09 2.31000000000000e-09 2.32000000000000e-09 2.33000000000000e-09 2.34000000000000e-09 2.35000000000000e-09 2.36000000000000e-09 2.37000000000000e-09 2.38000000000000e-09 2.39000000000000e-09 2.40000000000000e-09 2.41000000000000e-09 2.42000000000000e-09 2.43000000000000e-09 2.44000000000000e-09 2.45000000000000e-09 2.46000000000000e-09 2.47000000000000e-09 2.48000000000000e-09 2.49000000000000e-09 2.50000000000000e-09 2.51000000000000e-09 2.52000000000000e-09 2.53000000000000e-09 2.54000000000000e-09 2.55000000000000e-09 2.56000000000000e-09 2.57000000000000e-09 2.58000000000000e-09 2.59000000000000e-09 2.60000000000000e-09 2.61000000000000e-09 2.62000000000000e-09 2.63000000000000e-09 2.64000000000000e-09 2.65000000000000e-09 2.66000000000000e-09 2.67000000000000e-09 2.68000000000000e-09];
BL3_RelF=[0.000590546752547717 0.000755792952448892 0.000942939040694842 0.00115084345934844 0.00137799326942264 0.00162259186614702 0.00188264078854947 0.00215601315366742 0.00244051751371369 0.00273395182888489 0.00303414784708362 0.00333900655587803 0.00364652558165022 0.00395481950423514 0.00426213406957871 0.00456685524586540 0.00486751400045972 0.00516278759026453 0.00545149806664480 0.00573260860450030 0.00600521817758190 0.00626855502119887 0.00652196925032622 0.00676492493624479 0.00699699188815396 0.00721783733727568 0.00742721767921922 0.00762497039510104 0.00781100624239088 0.00798530178197223 0.00814789228779087 0.00829886506910132 0.00843835322215080 0.00856652981766704 0.00868360252230631 0.00878980864589273 0.00888541060151399 0.00897069176205266 0.00904595269429043 0.00911150775012479 0.00916768199351454 0.00921480844138337 0.00925322559674255 0.00928327525264622 0.00930530054618998 0.00931964424253714 0.00932664722985753 0.00932664720704605 0.00931997754712155 0.00930696632026065 0.00928793546147835 0.00926320006900930 0.00923306782045894 0.00919783849477391 0.00915780358901896 0.00911324601983939 0.00906443990033092 0.00901165038383195 0.00895513356689545 0.00889513644439050 0.00883189691032776 0.00876564379860016 0.00869659695838184 0.00862496735943793 0.00855095722306555 0.00847476017481676 0.00839656141554811 0.00831653790770189 0.00823485857405300 0.00815168450645581 0.00806716918239781 0.00798145868741530 0.00789469194165129 0.00780700092903970 0.00771851092778438 0.00762934074096817 0.00753960292627742 0.00744940402396274 0.00735884478227854 0.00726802037975321 0.00717702064373852 0.00708593026477821 0.00699482900640747 0.00690379191007154 0.00681288949490912 0.00672218795220322 0.00663174933435010 0.00654163173824047 0.00645188948298410 0.00636257328194327 0.00627373040906833 0.00618540485955469 0.00609763750486211 0.00601046624215568 0.00592392613824456 0.00583804956810765 0.00575286634810707 0.00566840386399992 0.00558468719386648 0.00550173922607944 0.00541958077244340 0.00533823067663806 0.00525770591810076 0.00517802171148601 0.00509919160184058 0.00502122755563278 0.00494414004777430 0.00486793814477208 0.00479262958414610 0.00471822085024730 0.00464471724660779 0.00457212296495292 0.00450044115100220 0.00442967396718347 0.00435982265238115 0.00429088757883696 0.00422286830631780 0.00415576363366247 0.00408957164781540 0.00402428977045248 0.00395991480230037 0.00389644296524779 0.00383386994234340 0.00377219091577227 0.00371140060289894 0.00365149329046265 0.00359246286700649 0.00353430285361971 0.00347700643306895 0.00342056647739162 0.00336497557402152 0.00331022605051412 0.00325630999793627 0.00320321929298228 0.00315094561887603 0.00309948048511615 0.00304881524611887 0.00299894111881104 0.00294984919922342 0.00290153047813215 0.00285397585579458 0.00280717615582308 0.00276112213823919 0.00271580451174793 0.00267121394527100 0.00262734107877528 0.00258417653343188 0.00254171092113900 0.00249993485344079 0.00245883894987247 0.00241841384576099 0.00237865019950888 0.00233953869938792 0.00230107006986775 0.00226323507750357 0.00222602453640589 0.00218942931331430 0.00215344033229596 0.00211804857908885 0.00208324510510852 0.00204902103113666 0.00201536755070832 0.00198227593321445 0.00194973752673503 0.00191774376061791 0.00188628614781710 0.00185535628700432 0.00182494586446614 0.00179504665579928 0.00176565052741517 0.00173674943786514 0.00170833543899632 0.00168040067694839 0.00165293739300071 0.00162593792427803 0.00159939470432444 0.00157330026355270 0.00154764722957694 0.00152242832743608 0.00149763637971467 0.00147326430656786 0.00144930512565664 0.00142575195199924 0.00140259799774432 0.00137983657187116 0.00135746107982193 0.00133546502307087 0.00131384199863467 0.00129258569852852 0.00127168990917179 0.00125114851074715 0.00123095547651674 0.00121110487209888 0.00119159085470846 0.00117240767236415 0.00115354966306524 0.00113501125394089 0.00111678696037439 0.00109887138510481 0.00108125921730829 0.00106394523166132 0.00104692428738776 0.00103019132729188 0.00101374137677883 0.000997569542864602 0.000981671013176835 0.000966041054948110 0.000950675014003072 0.000935568313740740 0.000920716454113265 0.000906115010602239 0.000891759633193741 0.000877646045353052 0.000863770043000060 0.000850127493486220 0.000836714334573907 0.000823526573418941 0.000810560285557005 0.000797811613894640 0.000785276767705419 0.000772952021631899 0.000760833714693886 0.000748918249303486 0.000737202090287437 0.000725681763917100 0.000714353856946518 0.000703215015658908 0.000692261944921863 0.000681491407251619 0.000670900221886585 0.000660485263870443 0.000650243463144972 0.000640171803652830 0.000630267322450455 0.000620527108831208 0.000610948303458939 0.000601528097512037 0.000592263731838090 0.000583152496119238 0.000574191728048244 0.000565378812515394 0.000556711180806203 0.000548186309810000 0.000539801721239363 0.000531554980860440 0.000523443697734136 0.000515465523468134 0.000507618151479745 0.000499899316269545 0.000492306792705749 0.000484838395319278 0.000477491977609469 0.000470265431360358 0.000463156685967460];
BL5_Radius=[1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09];
BL5_RelF=[0.000836536606188775 0.00112886286532109 0.00146631828717192 0.00184499546331876 0.00225996268888930 0.00270562864655386 0.00317605834101663 0.00366523326286490 0.00416725600883725 0.00467650375611649 0.00518773705093232 0.00569617107263164 0.00619751641057563 0.00668799581069962 0.00716434255244535 0.00762378525579910 0.00806402308118291 0.00848319451980877 0.00887984230049473 0.00925287636650484 0.00960153639908863 0.00992535497455323 0.0102241221282691 0.0104978518508940 0.0107467508486884 0.0109711897514581 0.0111716768399399 0.0113488342821171 0.0115033768089180 0.0116360927189968 0.0117478270756862 0.0118394669434246 0.0119119285033216 0.0119661458859153 0.0120030615619138 0.0120236181375144 0.0120287514087354 0.0120193845383138 0.0119964232285379 0.0119607517734684 0.0119132298840272 0.0118546901891979 0.0117859363259138 0.0117077415390187 0.0116208477209146 0.0115259648281255 0.0114237706190089 0.0113149106632386 0.0111999985794941 0.0110796164630458 0.0109543154696581 0.0108246165264787 0.0106910111443821 0.0105539623096210 0.0104139054356508 0.0102712493586631 0.0101263773627233 0.00997964822249282 0.00983139725334789 0.00968193736031610 0.00953156007866165 0.00938053660018002 0.00922911878033512 0.00907754012230347 0.00892601673479623 0.00877474826122648 0.00862391877838846 0.00847369766332909 0.00832424042753023 0.00817568951789291 0.00802817508432923 0.00788181571403128 0.00773671913270734 0.00759298287325631 0.00745069491250045 0.00730993427671583 0.00717077161679462 0.00703326975394645 0.00689748419690133 0.00676346363161532 0.00663125038450607 0.00650088086025984 0.00637238595525621 0.00624579144765292 0.00612111836516596 0.00599838333155987 0.00587759889284854 0.00575877382417988 0.00564191341835287 0.00552701975688674 0.00541409196453192 0.00530312644808109 0.00519411712030692 0.00508705560982048 0.00498193145761181 0.00487873230100194 0.00477744404570361 0.00467805102665601 0.00458053615826873 0.00448488107467911 0.00439106626059845 0.00429907117329373 0.00420887435622433 0.00412045354482609 0.00403378576491036 0.00394884742412022 0.00386561439686321 0.00378406210311700 0.00370416558148286 0.00362589955684141 0.00354923850294530 0.00347415670026484 0.00340062828938468 0.00332862732023291 0.00325812779740773 0.00318910372185140 0.00312152912910721 0.00305537812438076 0.00299062491461452 0.00292724383777184 0.00286520938951518 0.00280449624745221 0.00274507929311308 0.00268693363181224 0.00263003461053894 0.00257435783401190 0.00251987917902496 0.00246657480720337 0.00241442117628222 0.00236339505001238 0.00231347350679217 0.00226463394711701 0.00221685409993381 0.00217011202798078 0.00212438613218883 0.00207965515521549 0.00203589818417783 0.00199309465264676 0.00195122434196075 0.00191026738191350 0.00187020425086641 0.00183101577533343 0.00179268312908255 0.00175518783179565 0.00171851174732508 0.00168263708158339 0.00164754638009951 0.00161322252527318 0.00157964873335640 0.00154680855118949 0.00151468585271687 0.00148326483530614 0.00145253001589245 0.00142246622696845 0.00139305861243857 0.00136429262335547 0.00133615401355452 0.00130862883520167 0.00128170343426846 0.00125536444594705 0.00122959879001731 0.00120439366617675 0.00117973654934357 0.00115561518494205 0.00113201758417889 0.00110893201931841 0.00108634701896372 0.00106425136335057 0.00104263407965983 0.00102148443735424 0.00100079194354418 0.000980546338387365 0.000960737590526267 0.000941355892567123 0.000922391656603886 0.000903835509790018 0.000885678289961063 0.000867911041309783 0.000850525010116743 0.000833511640537575 0.000816862570448759 0.000800569627353290 0.000784624824347335 0.000769020356148934 0.000753748595189474 0.000738802087768650 0.000724173550273339 0.000709855865460778 0.000695842078806268 0.000682125394915487 0.000668699174001455 0.000655556928426004 0.000642692319305609 0.000630099153181296 0.000617771378752255 0.000605703083672804 0.000593888491412159];
BL7_Radius=[1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09];
BL7_RelF=[0.00177249048818010 0.00258703127990536 0.00357467248470848 0.00471996044563101 0.00599901438761631 0.00738215747731250 0.00883653091706021 0.0103284233358674 0.0118251734588068 0.0132965990066473 0.0147159683508629 0.0160605685575559 0.0173119407404995 0.0184558574476452 0.0194821123207978 0.0203841833547406 0.0211588203910153 0.0218055966956917 0.0223264545578944 0.0227252662807110 0.0230074248721761 0.0231794731422024 0.0232487756280290 0.0232232346161562 0.0231110493028806 0.0229205156492064 0.0226598635711068 0.0223371276202416 0.0219600471362767 0.0215359918965308 0.0210719094791146 0.0205742908368429 0.0200491509100536 0.0195020214575590 0.0189379536356847 0.0183615281919638 0.0177768714539192 0.0171876755796267 0.0165972217932514 0.0160084055552315 0.0154237628142228 0.0148454966581258 0.0142755038267251 0.0137154006711563 0.0131665482480885 0.0126300763216137 0.0121069061156904 0.0115977717167107 0.0111032400712953 0.0106237295604826 0.0101595271595824 0.00971080421445543 0.00927763088098507 0.00885998928603098 0.00845778547602937 0.00807086022434314 0.00769899877106974 0.00734193956978500 0.00699938211505141 0.00667099392279578 0.00635641673314298 0.00605527200220882 0.00576716574589099 0.00549169279499915 0.00522844051725091 0.00497699205781943 0.00473692914632225 0.00450783451444015 0.00428929396478944 0.00408089812826759 0.00388224394386776 0.00369293589192476 0.00351258700891664 0.00334081970930413 0.00317726643744126 0.00302157017032935 0.00287338478990607 0.00273237534165316 0.00259821819456097 0.00247060111589595 0.00234922327276856 0.00223379517118338 0.00212403854206176 0.00201968618264907 0.00192048176074727 0.00182617958833553 0.00173654437035557 0.00165135093373019 0.00157038394104971 0.00149343759279424 0.00142031532145317 0.00135082948045141 0.00128480103039035 0.00122205922475394 0.00116244129691384 0.00110579214998677];
BL9_Radius=[2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10];
BL9_RelF=[0.0156534011775453 0.0322228223631770 0.0561559345140615 0.0841568009973634 0.109966535016168 0.126841827679093 0.130578693578723 0.121161833088070 0.102230481243056 0.0790621656561153 0.0564475111728237 0.0374475808549700 0.0232196658829966 0.0135287194885386 0.00744272530142191 0.00388330198587668];
BL10_Radius=[2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10];
BL10_RelF=[0.0195189919077837 0.0608352060497068 0.129893435131358 0.196358146692658 0.216432893962849 0.178604614463826 0.113008063043124 0.0560189894559856 0.0221849035437120 0.00714475574899759];
BL11_Radius=[2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10];
BL11_RelF=[0.0174899910056851 0.0584646029231549 0.130615064724196 0.201969317872720 0.223023248240050 0.180877809388916 0.110507249335674 0.0520377533578998 0.0192839591411020 0.00573100401060113];
BL12_Radius=[2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10];
BL12_RelF=[0.0217599411699979 0.0675255576989169 0.141571377428128 0.207486564580488 0.219156495460703 0.171460879073542 0.101847509349658 0.0469694525848292 0.0171617683403730 0.00506045431336396];
BL14_Radius=[3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10];
BL14_RelF=[0.272486076611348 0.513803737677099 0.197211950221841 0.0164982354897120];
BL3_Radius=BL3_Radius*10^9; %to [nm]
BL5_Radius=BL5_Radius*10^9; %to [nm]
BL7_Radius=BL7_Radius*10^9; %to [nm]
BL9_Radius=BL9_Radius*10^9; %to [nm]
BL10_Radius=BL10_Radius*10^9; %to [nm]
BL11_Radius=BL11_Radius*10^9; %to [nm]
BL12_Radius=BL12_Radius*10^9; %to [nm]
BL14_Radius=BL14_Radius*10^9; %to [nm]

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(BL3_Radius,BL3_RelF,'.','MarkerSize',4,'Color','k');
plot(BL5_Radius,BL5_RelF,'.','MarkerSize',4,'Color','b');
plot(BL7_Radius,BL7_RelF,'.','MarkerSize',4,'Color','r');
plot(BL9_Radius,BL9_RelF,'.','MarkerSize',4,'Color','k');
plot(BL12_Radius,BL12_RelF,'.','MarkerSize',4,'Color','b');
plot(BL14_Radius,BL14_RelF,'.','MarkerSize',4,'Color','r');
axis([0.1,10,0,0.6]);
title('PAH/PAA');
xlabel('Pore Radius [nm]');
set(gca,'FontSize',12)
ylabel('Relative Flux [-]');
ax = gca;
set(gca, 'XScale', 'log')
xticks([0.1 1 10]);
legend('3','5','7','9','12','14');
[leg, icons, plots, txt]  = legend('show');
title(leg,{'Number of','Bilayers [-]'})

%Spline to guide Eye
s=spline(BL9_Radius,BL9_RelF,BL9_Radius(1):0.002:BL9_Radius(end));
plot(BL9_Radius(1):0.002:BL9_Radius(end),s,'-','Color','k');
s=spline(BL12_Radius,BL12_RelF,BL12_Radius(1):0.002:BL12_Radius(end));
plot(BL12_Radius(1):0.002:BL12_Radius(end),s,'-','Color','b');
s=spline(BL14_Radius,BL14_RelF,BL14_Radius(1):0.002:BL14_Radius(end));
plot(BL14_Radius(1):0.002:BL14_Radius(end),s,'-','Color','r');

%% Log-Normal Distribution + Imperfections Fit Correlation 1 (Murugaiah)
%PDADMAC/PSS
BL=[2;3;4;6;7;8;9;10]; %Bilayer number
MPR=[7.55585E-11	2.78812E-10	4.29069E-10	4.51864E-10	4.4072E-10	4.37534E-10	4.40046E-10	4.4232E-10]*10^9; %mean pore radius [nm]
MPR_Conf=[6.68171E-11	6.17014E-11	2.62657E-11	1.90335E-11	2.69991E-11	1.61354E-11	1.70413E-11	2.08146E-11]*10^9; %mean pore radius 95% Confidence [nm]
PRS=[9.72098E-11	1.55104E-10	1.18335E-10	9.78588E-11	9.77782E-11	9.53158E-11	9.62544E-11	9.44215E-11]*10^9; %pore radius spread [nm]
PRS_Conf=[6.32785E-11	1.23638E-11	9.55479E-12	1.05629E-11	1.40625E-11	8.48089E-12	9.07961E-12	1.16136E-11]*10^9; %pore radius spread 95% Confidence [nm]
IMP=[1.2638E-05	2.673189236	1.030727548	0.229325186	0.175408278	0.193032686	0.191731578	0.206538373]; %non selective flux percentage [%]
IMP_Conf=[1.273636286	0.862619428	0.465869202	0.333547681	0.503694506	0.333469734	0.343249848	0.44273789]; %non selective flux percentage 95% Confidence [%]
DXE=[1.70241E-06	1.01925E-06	1.04507E-06	1.11661E-06	1.14015E-06	1.20058E-06	1.20107E-06	1.29284E-06]*10^6; %effective membrane thickness [um]
DXE_Conf=[9.98163E-08	1.05788E-07	6.0844E-08	4.42548E-08	6.40842E-08	3.93168E-08	4.10442E-08	5.15794E-08]*10^6; %effective membrane thickness 95% Confidence [um]
IMPA=[2.71779E-06	0.353006023	0.116118625	0.023492669	0.017082584	0.016514537	0.016997057	0.016798811]; %non selective flux in absolute permeability [LMHbar]
IMPA_Conf=[0.273894866	0.115391374	0.052916981	0.034182142	0.049077247	0.028533886	0.030435657	0.036013399]; %non selective flux in absolute permeability 95% Confidence [LMHbar]

figure;
hold on;
box on;
pbaspect([1 1 1])
errorbar(BL,IMPA,IMPA_Conf,IMPA_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
axis([0,16,0,0.6]);
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Permeability of Imperfections [LMH/bar]');
xticks([2 4 6 8 10 12 14 16]);
yticks([0.2 0.4 0.6]);

%PAH/PAA
BL=[3;5;7;9;10;11;12;14]; %Bilayer number
MPR=[8.78121E-11	6.57786E-11	1.00602E-10	2.65737E-10	2.71797E-10	2.71569E-10	2.70715E-10	2.75655E-10]*10^9; %mean pore radius [nm]
MPR_Conf=[8.11555E-11	4.84088E-11	3.90836E-11	6.9899E-12	6.7548E-12	6.66086E-12	6.29167E-12	8.95382E-12]*10^9; %mean pore radius 95% Confidence [nm]
PRS=[9.00E-11	6.63771E-11	7.02557E-11	4.6889E-11	4.06265E-11	4.00092E-11	3.93474E-11	3.72454E-11]*10^9; %pore radius spread [nm]
PRS_Conf=[5.64475E-11	3.3220E-11	1.44697E-11	4.70268E-12	5.49131E-12	5.13563E-12	5.15086E-12	7.90253E-12]*10^9; %pore radius spread 95% Confidence [nm]
IMP=[6.447701517	5.24888364	3.361418153	3.8097E+00	2.164505039	3.053325629	2.906925438	4.202545568]; %non selective flux percentage [%]
IMP_Conf=[3.288375034	2.3459E+00	1.327578334	0.697749197	0.806966337	0.727830765	0.711972457	1.117597044]; %non selective flux percentage 95% Confidence [%]
DXE=[3.43082E-06	2.5929E-06	2.02864E-06	3.18834E-06	3.95022E-06	4.93939E-06	5.55663E-06	6.6355E-06]*10^6; %effective membrane thickness [um]
DXE_Conf=[1.71836E-07	1.4450E-07	1.16017E-07	7.58707E-08	9.26736E-08	8.95713E-08	9.19301E-08	1.61082E-07]*10^6; %effective membrane thickness 95% Confidence [um]
IMPA=[0.380409575	0.202579015	0.08322754	0.068207278	0.033877143	3.7687E-02	0.031272278	0.042840359]; %non selective flux in absolute permeability [LMHbar]
IMPA_Conf=[0.199089366	0.096793156	0.033112945	0.015906118	0.012894784	0.009812962	0.00887059	0.011836929]; %non selective flux in absolute permeability 95% Confidence [LMHbar]

errorbar(BL,IMPA,IMPA_Conf,IMPA_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
hold off;

%PDADMAC/PSS
BL=[2;3;4;6;7;8;9;10]; %Bilayer number
MPR=[7.55585E-11	2.78812E-10	4.29069E-10	4.51864E-10	4.4072E-10	4.37534E-10	4.40046E-10	4.4232E-10]*10^9; %mean pore radius [nm]
MPR_Conf=[6.68171E-11	6.17014E-11	2.62657E-11	1.90335E-11	2.69991E-11	1.61354E-11	1.70413E-11	2.08146E-11]*10^9; %mean pore radius 95% Confidence [nm]
PRS=[9.72098E-11	1.55104E-10	1.18335E-10	9.78588E-11	9.77782E-11	9.53158E-11	9.62544E-11	9.44215E-11]*10^9; %pore radius spread [nm]
PRS_Conf=[6.32785E-11	1.23638E-11	9.55479E-12	1.05629E-11	1.40625E-11	8.48089E-12	9.07961E-12	1.16136E-11]*10^9; %pore radius spread 95% Confidence [nm]
IMP=[1.2638E-05	2.673189236	1.030727548	0.229325186	0.175408278	0.193032686	0.191731578	0.206538373]; %non selective flux percentage [%]
IMP_Conf=[1.273636286	0.862619428	0.465869202	0.333547681	0.503694506	0.333469734	0.343249848	0.44273789]; %non selective flux percentage 95% Confidence [%]
DXE=[1.70241E-06	1.01925E-06	1.04507E-06	1.11661E-06	1.14015E-06	1.20058E-06	1.20107E-06	1.29284E-06]*10^6; %effective membrane thickness [um]
DXE_Conf=[9.98163E-08	1.05788E-07	6.0844E-08	4.42548E-08	6.40842E-08	3.93168E-08	4.10442E-08	5.15794E-08]*10^6; %effective membrane thickness 95% Confidence [um]
IMPA=[2.71779E-06	0.353006023	0.116118625	0.023492669	0.017082584	0.016514537	0.016997057	0.016798811]; %non selective flux in absolute permeability [LMHbar]
IMPA_Conf=[0.273894866	0.115391374	0.052916981	0.034182142	0.049077247	0.028533886	0.030435657	0.036013399]; %non selective flux in absolute permeability 95% Confidence [LMHbar]

figure;
hold on;
box on;
pbaspect([1 1 1])
errorbar(BL,IMP,IMP_Conf,IMP_Conf,'.','MarkerSize',16,'Color',[230,68,62]./255);%'r'
axis([0,16,0,10]);
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Non-selective Flux [%]');
xticks([2 4 6 8 10 12 14 16]);
yticks([2 4 6 8 10]);

%PAH/PAA
BL=[3;5;7;9;10;11;12;14]; %Bilayer number
MPR=[8.78121E-11	6.57786E-11	1.00602E-10	2.65737E-10	2.71797E-10	2.71569E-10	2.70715E-10	2.75655E-10]*10^9; %mean pore radius [nm]
MPR_Conf=[8.11555E-11	4.84088E-11	3.90836E-11	6.9899E-12	6.7548E-12	6.66086E-12	6.29167E-12	8.95382E-12]*10^9; %mean pore radius 95% Confidence [nm]
PRS=[9.00E-11	6.63771E-11	7.02557E-11	4.6889E-11	4.06265E-11	4.00092E-11	3.93474E-11	3.72454E-11]*10^9; %pore radius spread [nm]
PRS_Conf=[5.64475E-11	3.3220E-11	1.44697E-11	4.70268E-12	5.49131E-12	5.13563E-12	5.15086E-12	7.90253E-12]*10^9; %pore radius spread 95% Confidence [nm]
IMP=[6.447701517	5.24888364	3.361418153	3.8097E+00	2.164505039	3.053325629	2.906925438	4.202545568]; %non selective flux percentage [%]
IMP_Conf=[3.288375034	2.3459E+00	1.327578334	0.697749197	0.806966337	0.727830765	0.711972457	1.117597044]; %non selective flux percentage 95% Confidence [%]
DXE=[3.43082E-06	2.5929E-06	2.02864E-06	3.18834E-06	3.95022E-06	4.93939E-06	5.55663E-06	6.6355E-06]*10^6; %effective membrane thickness [um]
DXE_Conf=[1.71836E-07	1.4450E-07	1.16017E-07	7.58707E-08	9.26736E-08	8.95713E-08	9.19301E-08	1.61082E-07]*10^6; %effective membrane thickness 95% Confidence [um]
IMPA=[0.380409575	0.202579015	0.08322754	0.068207278	0.033877143	3.7687E-02	0.031272278	0.042840359]; %non selective flux in absolute permeability [LMHbar]
IMPA_Conf=[0.199089366	0.096793156	0.033112945	0.015906118	0.012894784	0.009812962	0.00887059	0.011836929]; %non selective flux in absolute permeability 95% Confidence [LMHbar]

errorbar(BL,IMP,IMP_Conf,IMP_Conf,'.','MarkerSize',16,'Color',[96,58,232]./255);%'b'
hold off;

%PDADMAC/PSS
BL2_Radius=[8.00000000000000e-11 9.00000000000000e-11 1.00000000000000e-10 1.10000000000000e-10 1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09 2.09000000000000e-09 2.10000000000000e-09 2.11000000000000e-09 2.12000000000000e-09 2.13000000000000e-09 2.14000000000000e-09 2.15000000000000e-09 2.16000000000000e-09 2.17000000000000e-09 2.18000000000000e-09 2.19000000000000e-09 2.20000000000000e-09 2.21000000000000e-09 2.22000000000000e-09 2.23000000000000e-09 2.24000000000000e-09 2.25000000000000e-09 2.26000000000000e-09 2.27000000000000e-09 2.28000000000000e-09 2.29000000000000e-09 2.30000000000000e-09 2.31000000000000e-09 2.32000000000000e-09 2.33000000000000e-09 2.34000000000000e-09 2.35000000000000e-09 2.36000000000000e-09 2.37000000000000e-09 2.38000000000000e-09 2.39000000000000e-09 2.40000000000000e-09 2.41000000000000e-09 2.42000000000000e-09 2.43000000000000e-09 2.44000000000000e-09 2.45000000000000e-09 2.46000000000000e-09 2.47000000000000e-09 2.48000000000000e-09 2.49000000000000e-09 2.50000000000000e-09 2.51000000000000e-09 2.52000000000000e-09 2.53000000000000e-09 2.54000000000000e-09 2.55000000000000e-09 2.56000000000000e-09 2.57000000000000e-09 2.58000000000000e-09 2.59000000000000e-09 2.60000000000000e-09 2.61000000000000e-09 2.62000000000000e-09 2.63000000000000e-09 2.64000000000000e-09 2.65000000000000e-09 2.66000000000000e-09 2.67000000000000e-09 2.68000000000000e-09 2.69000000000000e-09 2.70000000000000e-09 2.71000000000000e-09 2.72000000000000e-09 2.73000000000000e-09 2.74000000000000e-09 2.75000000000000e-09 2.76000000000000e-09 2.77000000000000e-09 2.78000000000000e-09 2.79000000000000e-09 2.80000000000000e-09 2.81000000000000e-09 2.82000000000000e-09 2.83000000000000e-09 2.84000000000000e-09 2.85000000000000e-09 2.86000000000000e-09 2.87000000000000e-09 2.88000000000000e-09 2.89000000000000e-09 2.90000000000000e-09 2.91000000000000e-09 2.92000000000000e-09 2.93000000000000e-09 2.94000000000000e-09 2.95000000000000e-09 2.96000000000000e-09 2.97000000000000e-09 2.98000000000000e-09 2.99000000000000e-09 3.00000000000000e-09 3.01000000000000e-09 3.02000000000000e-09 3.03000000000000e-09 3.04000000000000e-09 3.05000000000000e-09 3.06000000000000e-09 3.07000000000000e-09 3.08000000000000e-09 3.09000000000000e-09 3.10000000000000e-09 3.11000000000000e-09 3.12000000000000e-09 3.13000000000000e-09 3.14000000000000e-09 3.15000000000000e-09 3.16000000000000e-09 3.17000000000000e-09 3.18000000000000e-09 3.19000000000000e-09 3.20000000000000e-09 3.21000000000000e-09 3.22000000000000e-09 3.23000000000000e-09 3.24000000000000e-09 3.25000000000000e-09 3.26000000000000e-09 3.27000000000000e-09 3.28000000000000e-09 3.29000000000000e-09 3.30000000000000e-09 3.31000000000000e-09 3.32000000000000e-09 3.33000000000000e-09 3.34000000000000e-09 3.35000000000000e-09 3.36000000000000e-09 3.37000000000000e-09 3.38000000000000e-09 3.39000000000000e-09 3.40000000000000e-09 3.41000000000000e-09 3.42000000000000e-09 3.43000000000000e-09 3.44000000000000e-09 3.45000000000000e-09 3.46000000000000e-09 3.47000000000000e-09 3.48000000000000e-09 3.49000000000000e-09 3.50000000000000e-09 3.51000000000000e-09 3.52000000000000e-09 3.53000000000000e-09 3.54000000000000e-09 3.55000000000000e-09 3.56000000000000e-09 3.57000000000000e-09 3.58000000000000e-09 3.59000000000000e-09 3.60000000000000e-09 3.61000000000000e-09 3.62000000000000e-09 3.63000000000000e-09 3.64000000000000e-09 3.65000000000000e-09 3.66000000000000e-09 3.67000000000000e-09 3.68000000000000e-09 3.69000000000000e-09 3.70000000000000e-09 3.71000000000000e-09 3.72000000000000e-09 3.73000000000000e-09 3.74000000000000e-09 3.75000000000000e-09 3.76000000000000e-09 3.77000000000000e-09 3.78000000000000e-09 3.79000000000000e-09 3.80000000000000e-09 3.81000000000000e-09 3.82000000000000e-09 3.83000000000000e-09 3.84000000000000e-09 3.85000000000000e-09 3.86000000000000e-09 3.87000000000000e-09 3.88000000000000e-09 3.89000000000000e-09 3.90000000000000e-09 3.91000000000000e-09 3.92000000000000e-09 3.93000000000000e-09 3.94000000000000e-09 3.95000000000000e-09 3.96000000000000e-09 3.97000000000000e-09 3.98000000000000e-09 3.99000000000000e-09 4.00000000000000e-09 4.01000000000000e-09 4.02000000000000e-09 4.03000000000000e-09 4.04000000000000e-09 4.05000000000000e-09 4.06000000000000e-09 4.07000000000000e-09 4.08000000000000e-09 4.09000000000000e-09 4.10000000000000e-09 4.11000000000000e-09 4.12000000000000e-09 4.13000000000000e-09 4.14000000000000e-09 4.15000000000000e-09 4.16000000000000e-09 4.17000000000000e-09 4.18000000000000e-09 4.19000000000000e-09 4.20000000000000e-09 4.21000000000000e-09 4.22000000000000e-09 4.23000000000000e-09 4.24000000000000e-09 4.25000000000000e-09 4.26000000000000e-09 4.27000000000000e-09 4.28000000000000e-09 4.29000000000000e-09 4.30000000000000e-09 4.31000000000000e-09 4.32000000000000e-09 4.33000000000000e-09 4.34000000000000e-09 4.35000000000000e-09 4.36000000000000e-09 4.37000000000000e-09 4.38000000000000e-09 4.39000000000000e-09 4.40000000000000e-09 4.41000000000000e-09 4.42000000000000e-09 4.43000000000000e-09 4.44000000000000e-09 4.45000000000000e-09 4.46000000000000e-09 4.47000000000000e-09 4.48000000000000e-09 4.49000000000000e-09 4.50000000000000e-09 4.51000000000000e-09 4.52000000000000e-09 4.53000000000000e-09 4.54000000000000e-09 4.55000000000000e-09 4.56000000000000e-09 4.57000000000000e-09 4.58000000000000e-09 4.59000000000000e-09 4.60000000000000e-09 4.61000000000000e-09 4.62000000000000e-09 4.63000000000000e-09 4.64000000000000e-09 4.65000000000000e-09 4.66000000000000e-09 4.67000000000000e-09 4.68000000000000e-09 4.69000000000000e-09 4.70000000000000e-09 4.71000000000000e-09 4.72000000000000e-09 4.73000000000000e-09 4.74000000000000e-09 4.75000000000000e-09 4.76000000000000e-09 4.77000000000000e-09 4.78000000000000e-09 4.79000000000000e-09 4.80000000000000e-09 4.81000000000000e-09 4.82000000000000e-09 4.83000000000000e-09 4.84000000000000e-09 4.85000000000000e-09 4.86000000000000e-09 4.87000000000000e-09 4.88000000000000e-09 4.89000000000000e-09 4.90000000000000e-09 4.91000000000000e-09 4.92000000000000e-09 4.93000000000000e-09 4.94000000000000e-09 4.95000000000000e-09 4.96000000000000e-09 4.97000000000000e-09 4.98000000000000e-09 4.99000000000000e-09 5.00000000000000e-09 5.01000000000000e-09 5.02000000000000e-09 5.03000000000000e-09 5.04000000000000e-09 5.05000000000000e-09 5.06000000000000e-09 5.07000000000000e-09 5.08000000000000e-09 5.09000000000000e-09 5.10000000000000e-09 5.11000000000000e-09 5.12000000000000e-09 5.13000000000000e-09 5.14000000000000e-09 5.15000000000000e-09 5.16000000000000e-09 5.17000000000000e-09 5.18000000000000e-09 5.19000000000000e-09 5.20000000000000e-09 5.21000000000000e-09 5.22000000000000e-09 5.23000000000000e-09 5.24000000000000e-09 5.25000000000000e-09 5.26000000000000e-09 5.27000000000000e-09 5.28000000000000e-09 5.29000000000000e-09 5.30000000000000e-09 5.31000000000000e-09 5.32000000000000e-09 5.33000000000000e-09 5.34000000000000e-09 5.35000000000000e-09 5.36000000000000e-09 5.37000000000000e-09 5.38000000000000e-09 5.39000000000000e-09 5.40000000000000e-09 5.41000000000000e-09 5.42000000000000e-09 5.43000000000000e-09 5.44000000000000e-09 5.45000000000000e-09 5.46000000000000e-09 5.47000000000000e-09 5.48000000000000e-09 5.49000000000000e-09 5.50000000000000e-09 5.51000000000000e-09 5.52000000000000e-09 5.53000000000000e-09 5.54000000000000e-09 5.55000000000000e-09 5.56000000000000e-09 5.57000000000000e-09 5.58000000000000e-09 5.59000000000000e-09 5.60000000000000e-09 5.61000000000000e-09 5.62000000000000e-09 5.63000000000000e-09 5.64000000000000e-09 5.65000000000000e-09 5.66000000000000e-09 5.67000000000000e-09 5.68000000000000e-09 5.69000000000000e-09 5.70000000000000e-09 5.71000000000000e-09 5.72000000000000e-09 5.73000000000000e-09 5.74000000000000e-09 5.75000000000000e-09 5.76000000000000e-09 5.77000000000000e-09 5.78000000000000e-09 5.79000000000000e-09 5.80000000000000e-09 5.81000000000000e-09 5.82000000000000e-09 5.83000000000000e-09 5.84000000000000e-09 5.85000000000000e-09 5.86000000000000e-09 5.87000000000000e-09 5.88000000000000e-09 5.89000000000000e-09 5.90000000000000e-09 5.91000000000000e-09 5.92000000000000e-09 5.93000000000000e-09 5.94000000000000e-09 5.95000000000000e-09 5.96000000000000e-09 5.97000000000000e-09 5.98000000000000e-09 5.99000000000000e-09 6.00000000000000e-09 6.01000000000000e-09 6.02000000000000e-09 6.03000000000000e-09 6.04000000000000e-09 6.05000000000000e-09 6.06000000000000e-09 6.07000000000000e-09 6.08000000000000e-09 6.09000000000000e-09 6.10000000000000e-09 6.11000000000000e-09 6.12000000000000e-09 6.13000000000000e-09 6.14000000000000e-09 6.15000000000000e-09 6.16000000000000e-09 6.17000000000000e-09 6.18000000000000e-09 6.19000000000000e-09 6.20000000000000e-09 6.21000000000000e-09 6.22000000000000e-09 6.23000000000000e-09 6.24000000000000e-09 6.25000000000000e-09 6.26000000000000e-09 6.27000000000000e-09 6.28000000000000e-09 6.29000000000000e-09 6.30000000000000e-09 6.31000000000000e-09 6.32000000000000e-09 6.33000000000000e-09 6.34000000000000e-09 6.35000000000000e-09 6.36000000000000e-09 6.37000000000000e-09 6.38000000000000e-09 6.39000000000000e-09 6.40000000000000e-09 6.41000000000000e-09 6.42000000000000e-09 6.43000000000000e-09 6.44000000000000e-09 6.45000000000000e-09 6.46000000000000e-09 6.47000000000000e-09 6.48000000000000e-09 6.49000000000000e-09 6.50000000000000e-09 6.51000000000000e-09 6.52000000000000e-09 6.53000000000000e-09 6.54000000000000e-09 6.55000000000000e-09 6.56000000000000e-09 6.57000000000000e-09 6.58000000000000e-09 6.59000000000000e-09 6.60000000000000e-09 6.61000000000000e-09 6.62000000000000e-09 6.63000000000000e-09 6.64000000000000e-09 6.65000000000000e-09 6.66000000000000e-09 6.67000000000000e-09 6.68000000000000e-09 6.69000000000000e-09 6.70000000000000e-09 6.71000000000000e-09 6.72000000000000e-09 6.73000000000000e-09 6.74000000000000e-09 6.75000000000000e-09 6.76000000000000e-09 6.77000000000000e-09 6.78000000000000e-09 6.79000000000000e-09 6.80000000000000e-09 6.81000000000000e-09 6.82000000000000e-09 6.83000000000000e-09 6.84000000000000e-09 6.85000000000000e-09 6.86000000000000e-09 6.87000000000000e-09 6.88000000000000e-09 6.89000000000000e-09 6.90000000000000e-09 6.91000000000000e-09 6.92000000000000e-09 6.93000000000000e-09 6.94000000000000e-09 6.95000000000000e-09 6.96000000000000e-09 6.97000000000000e-09 6.98000000000000e-09 6.99000000000000e-09 7.00000000000000e-09 7.01000000000000e-09 7.02000000000000e-09 7.03000000000000e-09 7.04000000000000e-09 7.05000000000000e-09 7.06000000000000e-09 7.07000000000000e-09 7.08000000000000e-09 7.09000000000000e-09 7.10000000000000e-09 7.11000000000000e-09 7.12000000000000e-09 7.13000000000000e-09 7.14000000000000e-09 7.15000000000000e-09 7.16000000000000e-09 7.17000000000000e-09 7.18000000000000e-09 7.19000000000000e-09 7.20000000000000e-09 7.21000000000000e-09 7.22000000000000e-09 7.23000000000000e-09 7.24000000000000e-09 7.25000000000000e-09 7.26000000000000e-09 7.27000000000000e-09 7.28000000000000e-09 7.29000000000000e-09 7.30000000000000e-09 7.31000000000000e-09 7.32000000000000e-09 7.33000000000000e-09 7.34000000000000e-09 7.35000000000000e-09 7.36000000000000e-09 7.37000000000000e-09 7.38000000000000e-09 7.39000000000000e-09 7.40000000000000e-09 7.41000000000000e-09 7.42000000000000e-09 7.43000000000000e-09 7.44000000000000e-09 7.45000000000000e-09 7.46000000000000e-09 7.47000000000000e-09 7.48000000000000e-09 7.49000000000000e-09 7.50000000000000e-09 7.51000000000000e-09 7.52000000000000e-09 7.53000000000000e-09 7.54000000000000e-09 7.55000000000000e-09 7.56000000000000e-09 7.57000000000000e-09 7.58000000000000e-09 7.59000000000000e-09 7.60000000000000e-09 7.61000000000000e-09 7.62000000000000e-09 7.63000000000000e-09 7.64000000000000e-09 7.65000000000000e-09 7.66000000000000e-09 7.67000000000000e-09 7.68000000000000e-09 7.69000000000000e-09 7.70000000000000e-09 7.71000000000000e-09 7.72000000000000e-09 7.73000000000000e-09 7.74000000000000e-09 7.75000000000000e-09 7.76000000000000e-09 7.77000000000000e-09 7.78000000000000e-09 7.79000000000000e-09 7.80000000000000e-09 7.81000000000000e-09 7.82000000000000e-09 7.83000000000000e-09 7.84000000000000e-09 7.85000000000000e-09 7.86000000000000e-09 7.87000000000000e-09 7.88000000000000e-09 7.89000000000000e-09 7.90000000000000e-09 7.91000000000000e-09 7.92000000000000e-09 7.93000000000000e-09 7.94000000000000e-09 7.95000000000000e-09 7.96000000000000e-09 7.97000000000000e-09 7.98000000000000e-09 7.99000000000000e-09 8.00000000000000e-09 8.01000000000000e-09 8.02000000000000e-09 8.03000000000000e-09 8.04000000000000e-09 8.05000000000000e-09 8.06000000000000e-09 8.07000000000000e-09 8.08000000000000e-09 8.09000000000000e-09 8.10000000000000e-09 8.11000000000000e-09 8.12000000000000e-09 8.13000000000000e-09 8.14000000000000e-09 8.15000000000000e-09 8.16000000000000e-09 8.17000000000000e-09 8.18000000000000e-09 8.19000000000000e-09 8.20000000000000e-09 8.21000000000000e-09 8.22000000000000e-09 8.23000000000000e-09 8.24000000000000e-09 8.25000000000000e-09 8.26000000000000e-09 8.27000000000000e-09 8.28000000000000e-09 8.29000000000000e-09 8.30000000000000e-09 8.31000000000000e-09 8.32000000000000e-09 8.33000000000000e-09 8.34000000000000e-09 8.35000000000000e-09 8.36000000000000e-09 8.37000000000000e-09 8.38000000000000e-09 8.39000000000000e-09 8.40000000000000e-09 8.41000000000000e-09 8.42000000000000e-09 8.43000000000000e-09 8.44000000000000e-09 8.45000000000000e-09 8.46000000000000e-09 8.47000000000000e-09 8.48000000000000e-09 8.49000000000000e-09 8.50000000000000e-09 8.51000000000000e-09 8.52000000000000e-09 8.53000000000000e-09 8.54000000000000e-09 8.55000000000000e-09 8.56000000000000e-09 8.57000000000000e-09 8.58000000000000e-09 8.59000000000000e-09 8.60000000000000e-09 8.61000000000000e-09 8.62000000000000e-09 8.63000000000000e-09 8.64000000000000e-09 8.65000000000000e-09 8.66000000000000e-09 8.67000000000000e-09 8.68000000000000e-09 8.69000000000000e-09 8.70000000000000e-09 8.71000000000000e-09 8.72000000000000e-09 8.73000000000000e-09 8.74000000000000e-09 8.75000000000000e-09 8.76000000000000e-09 8.77000000000000e-09 8.78000000000000e-09 8.79000000000000e-09 8.80000000000000e-09 8.81000000000000e-09 8.82000000000000e-09 8.83000000000000e-09 8.84000000000000e-09 8.85000000000000e-09 8.86000000000000e-09 8.87000000000000e-09 8.88000000000000e-09 8.89000000000000e-09 8.90000000000000e-09 8.91000000000000e-09 8.92000000000000e-09 8.93000000000000e-09 8.94000000000000e-09 8.95000000000000e-09 8.96000000000000e-09 8.97000000000000e-09 8.98000000000000e-09 8.99000000000000e-09 9.00000000000000e-09 9.01000000000000e-09 9.02000000000000e-09 9.03000000000000e-09 9.04000000000000e-09 9.05000000000000e-09 9.06000000000000e-09 9.07000000000000e-09 9.08000000000000e-09 9.09000000000000e-09 9.10000000000000e-09 9.11000000000000e-09 9.12000000000000e-09 9.13000000000000e-09 9.14000000000000e-09 9.15000000000000e-09 9.16000000000000e-09 9.17000000000000e-09 9.18000000000000e-09 9.19000000000000e-09 9.20000000000000e-09 9.21000000000000e-09 9.22000000000000e-09 9.23000000000000e-09 9.24000000000000e-09 9.25000000000000e-09 9.26000000000000e-09 9.27000000000000e-09 9.28000000000000e-09 9.29000000000000e-09 9.30000000000000e-09 9.31000000000000e-09 9.32000000000000e-09 9.33000000000000e-09 9.34000000000000e-09 9.35000000000000e-09 9.36000000000000e-09 9.37000000000000e-09 9.38000000000000e-09 9.39000000000000e-09 9.40000000000000e-09 9.41000000000000e-09 9.42000000000000e-09 9.43000000000000e-09 9.44000000000000e-09 9.45000000000000e-09 9.46000000000000e-09 9.47000000000000e-09 9.48000000000000e-09 9.49000000000000e-09 9.50000000000000e-09 9.51000000000000e-09 9.52000000000000e-09 9.53000000000000e-09 9.54000000000000e-09 9.55000000000000e-09 9.56000000000000e-09 9.57000000000000e-09 9.58000000000000e-09 9.59000000000000e-09 9.60000000000000e-09 9.61000000000000e-09 9.62000000000000e-09 9.63000000000000e-09 9.64000000000000e-09 9.65000000000000e-09 9.66000000000000e-09 9.67000000000000e-09 9.68000000000000e-09 9.69000000000000e-09 9.70000000000000e-09 9.71000000000000e-09 9.72000000000000e-09 9.73000000000000e-09 9.74000000000000e-09 9.75000000000000e-09];
BL2_RelF=[0.000167848640506176 0.000222157351065753 0.000282052674227455 0.000346622035744644 0.000415010874292321 0.000486437607603544 0.000560198918224372 0.000635669358586864 0.000712297757823286 0.000789601962983964 0.000867162851980752 0.000944618181776774 0.00102165660057471 0.00109801200566473 0.00117345833703892 0.00124780484061617 0.00132089180111447 0.00139258672506995 0.00146278094398865 0.00153138660275427 0.00159833399703175 0.00166356922410319 0.00172705211345478 0.00178875440592850 0.00184865815300462 0.00190675431056779 0.00196304150420287 0.00201752494559122 0.00207021548190066 0.00212112876216815 0.00217028450656618 0.00221770586613097 0.00226341886202786 0.00230745189475232 0.00234983531483174 0.00239060104761887 0.00242978226566912 0.00246741310298486 0.00250352840610345 0.00253816351761348 0.00257135408821717 0.00260313591392356 0.00263354479536728 0.00266261641660673 0.00269038624107063 0.00271688942259907 0.00274216072976777 0.00276623448189814 0.00278914449534340 0.00281092403880622 0.00283160579658892 0.00285122183880521 0.00286980359769542 0.00288738184928694 0.00290398669972913 0.00291964757570999 0.00293439321843000 0.00294825168066948 0.00296125032653935 0.00297341583355243 0.00298477419669470 0.00299535073421291 0.00300517009486795 0.00301425626643273 0.00302263258523907 0.00303032174660114 0.00303734581596345 0.00304372624063937 0.00304948386202244 0.00305463892816662 0.00305921110664482 0.00306321949760579 0.00306668264695979 0.00306961855963221 0.00307204471283214 0.00307397806928999 0.00307543509042438 0.00307643174940411 0.00307698354407576 0.00307710550973203 0.00307681223169952 0.00307611785772824 0.00307503611016801 0.00307358029791965 0.00307176332815118 0.00306959771777132 0.00306709560465437 0.00306426875861195 0.00306112859210957 0.00305768617072497 0.00305395222334892 0.00304993715212809 0.00304565104215139 0.00304110367088166 0.00303630451733507 0.00303126277101120 0.00302598734057738 0.00302048686231084 0.00301476970830293 0.00300884399442966 0.00300271758809327 0.00299639811573924 0.00298989297015406 0.00298320931754817 0.00297635410442958 0.00296933406427281 0.00296215572398860 0.00295482541019906 0.00294734925532374 0.00293973320348128 0.00293198301621187 0.00292410427802529 0.00291610240177950 0.00290798263389448 0.00289975005940609 0.00289140960686456 0.00288296605308211 0.00287442402773418 0.00286578801781866 0.00285706237197722 0.00284825130468309 0.00283935890029917 0.00283038911701052 0.00282134579063504 0.00281223263831613 0.00280305326210087 0.00279381115240741 0.00278450969138491 0.00277515215616948 0.00276574172203924 0.00275628146547183 0.00274677436710728 0.00273722331461936 0.00272763110549816 0.00271800044974688 0.00270833397249531 0.00269863421653290 0.00268890364476375 0.00267914464258614 0.00266935952019891 0.00265955051483705 0.00264971979293878 0.00263986945224619 0.00263000152384171 0.00262011797412227 0.00261022070671325 0.00260031156432415 0.00259039233054770 0.00258046473160431 0.00257053043803360 0.00256059106633459 0.00255064818055630 0.00254070329384019 0.00253075786991613 0.00252081332455318 0.00251087102696679 0.00250093230118361 0.00249099842736541 0.00248107064309331 0.00247115014461354 0.00246123808804605 0.00245133559055696 0.00244144373149617 0.00243156355350109 0.00242169606356760 0.00241184223408924 0.00240200300386561 0.00239217927908100 0.00238237193425412 0.00237258181315973 0.00236280972972334 0.00235305646888939 0.00234332278746413 0.00233360941493371 0.00232391705425835 0.00231424638264329 0.00230459805228729 0.00229497269110929 0.00228537090345395 0.00227579327077656 0.00226624035230863 0.00225671268570316 0.00224721078766230 0.00223773515454630 0.00222828626296505 0.00221886457035261 0.00220947051552509 0.00220010451922268 0.00219076698463597 0.00218145829791728 0.00217217882867735 0.00216292893046778 0.00215370894124979 0.00214451918384955 0.00213535996640056 0.00212623158277349 0.00211713431299374 0.00210806842364727 0.00209903416827477 0.00209003178775486 0.00208106151067629 0.00207212355369978 0.00206321812190953 0.00205434540915487 0.00204550559838238 0.00203669886195851 0.00202792536198330 0.00201918525059517 0.00201047867026725 0.00200180575409540 0.00199316662607814 0.00198456140138876 0.00197599018663989 0.00196745308014061 0.00195895017214644 0.00195048154510234 0.00194204727387900 0.00193364742600247 0.00192528206187753 0.00191695123500470 0.00190865499219138 0.00190039337375707 0.00189216641373287 0.00188397414005552 0.00187581657475601 0.00186769373414305 0.00185960562898135 0.00185155226466511 0.00184353364138662 0.00183554975430022 0.00182760059368181 0.00181968614508384 0.00181180638948610 0.00180396130344238 0.00179615085922302 0.00178837502495357 0.00178063376474962 0.00177292703884792 0.00176525480373391 0.00175761701226569 0.00175001361379463 0.00174244455428265 0.00173490977641623 0.00172740921971731 0.00171994282065119 0.00171251051273135 0.00170511222662146 0.00169774789023462 0.00169041742882971 0.00168312076510529 0.00167585781929073 0.00166862850923497 0.00166143275049272 0.00165427045640837 0.00164714153819755 0.00164004590502638 0.00163298346408868 0.00162595412068087 0.00161895777827490 0.00161199433858918 0.00160506370165746 0.00159816576589590 0.00159130042816816 0.00158446758384882 0.00157766712688491 0.00157089894985583 0.00156416294403154 0.00155745899942914 0.00155078700486788 0.00154414684802264 0.00153753841547590 0.00153096159276824 0.00152441626444746 0.00151790231411628 0.00151141962447876 0.00150496807738532 0.00149854755387656 0.00149215793422583 0.00148579909798057 0.00147947092400251 0.00147317329050669 0.00146690607509938 0.00146066915481495 0.00145446240615166 0.00144828570510639 0.00144213892720843 0.00143602194755229 0.00142993464082950 0.00142387688135957 0.00141784854312000 0.00141184949977544 0.00140587962470599 0.00139993879103465 0.00139402687165403 0.00138814373925221 0.00138228926633781 0.00137646332526447 0.00137066578825436 0.00136489652742126 0.00135915541479268 0.00135344232233155 0.00134775712195710 0.00134209968556516 0.00133646988504785 0.00133086759231267 0.00132529267930095 0.00131974501800582 0.00131422448048955 0.00130873093890039 0.00130326426548885 0.00129782433262349 0.00129241101280624 0.00128702417868716 0.00128166370307877 0.00127632945896995 0.00127102131953933 0.00126573915816828 0.00126048284845345 0.00125525226421894 0.00125004727952802 0.00124486776869447 0.00123971360629356 0.00123458466717262 0.00122948082646129 0.00122440195958139 0.00121934794225642 0.00121431865052082 0.00120931396072877 0.00120433374956281 0.00119937789404204 0.00119444627153009 0.00118953875974278 0.00118465523675545 0.00117979558101009 0.00117495967132217 0.00117014738688715 0.00116535860728685 0.00116059321249545 0.00115585108288532 0.00115113209923262 0.00114643614272265 0.00114176309495492 0.00113711283794815 0.00113248525414487 0.00112788022641601 0.00112329763806511 0.00111873737283247 0.00111419931489905 0.00110968334889018 0.00110518935987912 0.00110071723339043 0.00109626685540316 0.00109183811235391 0.00108743089113970 0.00108304507912068 0.00107868056412273 0.00107433723443983 0.00107001497883639 0.00106571368654939 0.00106143324729035 0.00105717355124721 0.00105293448908611 0.00104871595195299 0.00104451783147506 0.00104034001976226 0.00103618240940843 0.00103204489349255 0.00102792736557974 0.00102382971972225 0.00101975185046025 0.00101569365282262 0.00101165502232756 0.00100763585498320 0.00100363604728801 0.000999655496231196 0.000995694099293018 0.000991751754444964 0.000987828360149904 0.000983923815362123 0.000980038019527312 0.000976170872582471 0.000972322274955728 0.000968492127566112 0.000964680331823248 0.000960886789626990 0.000957111403366981 0.000953354075922170 0.000949614710660261 0.000945893211437093 0.000942189482595991 0.000938503428967043 0.000934834955866325 0.000931183969095090 0.000927550374938896 0.000923934080166697 0.000920334992029871 0.000916753018261224 0.000913188067073949 0.000909640047160521 0.000906108867691584 0.000902594438314781 0.000899096669153552 0.000895615470805891 0.000892150754343073 0.000888702431308359 0.000885270413715640 0.000881854614048081 0.000878454945256716 0.000875071320759024 0.000871703654437465 0.000868351860638006 0.000865015854168613 0.000861695550297714 0.000858390864752644 0.000855101713718072 0.000851828013834393 0.000848569682196109 0.000845326636350192 0.000842098794294419 0.000838886074475691 0.000835688395788344 0.000832505677572429 0.000829337839611985 0.000826184802133296 0.000823046485803129 0.000819922811726965 0.000816813701447207 0.000813719076941386 0.000810638860620350 0.000807572975326439 0.000804521344331656 0.000801483891335821 0.000798460540464727 0.000795451216268265 0.000792455843718566 0.000789474348208123 0.000786506655547900 0.000783552691965447 0.000780612384103002 0.000777685659015580 0.000774772444169075 0.000771872667438340 0.000768986257105269 0.000766113141856874 0.000763253250783364 0.000760406513376209 0.000757572859526213 0.000754752219521576 0.000751944524045959 0.000749149704176546 0.000746367691382102 0.000743598417521033 0.000740841814839447 0.000738097815969207 0.000735366353925989 0.000732647362107347 0.000729940774290762 0.000727246524631707 0.000724564547661704 0.000721894778286390 0.000719237151783573 0.000716591603801302 0.000713958070355933 0.000711336487830197 0.000708726792971272 0.000706128922888856 0.000703542815053249 0.000700968407293426 0.000698405637795127 0.000695854445098943 0.000693314768098402 0.000690786546038072 0.000688269718511654 0.000685764225460090 0.000683270007169663 0.000680787004270118 0.000678315157732776 0.000675854408868651 0.000673404699326584 0.000670965971091371 0.000668538166481904 0.000666121228149309 0.000663715099075095 0.000661319722569314 0.000658935042268714 0.000656561002134908 0.000654197546452542 0.000651844619827482 0.000649502167184985 0.000647170133767901 0.000644848465134862 0.000642537107158491 0.000640236006023604 0.000637945108225437 0.000635664360567859 0.000633393710161607 0.000631133104422525 0.000628882491069800 0.000626641818124222 0.000624411033906435 0.000622190087035204 0.000619978926425688 0.000617777501287719 0.000615585761124087 0.000613403655728836 0.000611231135185564 0.000609068149865731 0.000606914650426980 0.000604770587811451 0.000602635913244124 0.000600510578231147 0.000598394534558191 0.000596287734288797 0.000594190129762743 0.000592101673594410 0.000590022318671160 0.000587952018151721 0.000585890725464579 0.000583838394306379 0.000581794978640332 0.000579760432694632 0.000577734710960877 0.000575717768192505 0.000573709559403228 0.000571710039865484 0.000569719165108888 0.000567736890918697 0.000565763173334279 0.000563797968647594 0.000561841233401677 0.000559892924389137 0.000557952998650653 0.000556021413473490 0.000554098126390009 0.000552183095176203 0.000550276277850221 0.000548377632670915 0.000546487118136387 0.000544604692982545 0.000542730316181672 0.000540863946940991 0.000539005544701253 0.000537155069135321 0.000535312480146768 0.000533477737868478 0.000531650802661259 0.000529831635112463 0.000528020196034609 0.000526216446464025 0.000524420347659481 0.000522631861100843 0.000520850948487734 0.000519077571738193 0.000517311692987349 0.000515553274586106 0.000513802279099825 0.000512058669307021 0.000510322408198066 0.000508593458973900 0.000506871785044750 0.000505157350028850 0.000503450117751179 0.000501750052242198 0.000500057117736598 0.000498371278672056 0.000496692499687995 0.000495020745624354 0.000493355981520364 0.000491698172613333 0.000490047284337437 0.000488403282322515 0.000486766132392880 0.000485135800566124 0.000483512253051944 0.000481895456250966 0.000480285376753578 0.000478681981338771 0.000477085236972986 0.000475495110808970 0.000473911570184638 0.000472334582621937 0.000470764115825726 0.000469200137682654 0.000467642616260053 0.000466091519804830 0.000464546816742371 0.000463008475675447 0.000461476465383136 0.000459950754819737 0.000458431313113708 0.000456918109566591 0.000455411113651963 0.000453910295014381 0.000452415623468335 0.000450927068997213 0.000449444601752265 0.000447968192051582 0.000446497810379072 0.000445033427383448 0.000443575013877225 0.000442122540835712 0.000440675979396026 0.000439235300856095 0.000437800476673686 0.000436371478465418 0.000434948278005803 0.000433530847226273 0.000432119158214229 0.000430713183212084 0.000429312894616323 0.000427918264976557 0.000426529266994593 0.000425145873523506 0.000423768057566712 0.000422395792277061 0.000421029050955913 0.000419667807052247 0.000418312034161751 0.000416961706025935 0.000415616796531237 0.000414277279708150 0.000412943129730333 0.000411614320913752 0.000410290827715803 0.000408972624734463 0.000407659686707425 0.000406351988511254 0.000405049505160544 0.000403752211807075 0.000402460083738985 0.000401173096379935 0.000399891225288296 0.000398614446156320 0.000397342734809337 0.000396076067204944 0.000394814419432203 0.000393557767710844 0.000392306088390473 0.000391059357949788 0.000389817552995793 0.000388580650263023 0.000387348626612773 0.000386121459032332 0.000384899124634217 0.000383681600655418 0.000382468864456648 0.000381260893521593 0.000380057665456168 0.000378859157987781 0.000377665348964601 0.000376476216354827 0.000375291738245963 0.000374111892844104 0.000372936658473216 0.000371766013574426 0.000370599936705321 0.000369438406539243 0.000368281401864594 0.000367128901584142 0.000365980884714337 0.000364837330384624 0.000363698217836765 0.000362563526424167 0.000361433235611208 0.000360307324972574 0.000359185774192596 0.000358068563064593 0.000356955671490218 0.000355847079478811 0.000354742767146751 0.000353642714716818 0.000352546902517556 0.000351455310982639 0.000350367920650244 0.000349284712162426 0.000348205666264497 0.000347130763804411 0.000346059985732150 0.000344993313099115 0.000343930727057526 0.000342872208859813 0.000341817739858027 0.000340767301503241 0.000339720875344966 0.000338678443030559 0.000337639986304648 0.000336605487008549 0.000335574927079695 0.000334548288551062 0.000333525553550605 0.000332506704300691 0.000331491723117546 0.000330480592410690 0.000329473294682391 0.000328469812527114 0.000327470128630972 0.000326474225771192 0.000325482086815566 0.000324493694721926 0.000323509032537605 0.000322528083398910 0.000321550830530602 0.000320577257245366 0.000319607346943302 0.000318641083111402 0.000317678449323044 0.000316719429237478 0.000315764006599329 0.000314812165238086 0.000313863889067611 0.000312919162085637 0.000311977968373283 0.000311040292094555 0.000310106117495870 0.000309175428905567 0.000308248210733429 0.000307324447470203 0.000306404123687134 0.000305487224035485 0.000304573733246074 0.000303663636128812 0.000302756917572233 0.000301853562543042 0.000300953556085659 0.000300056883321759 0.000299163529449832 0.000298273479744726 0.000297386719557210 0.000296503234313527 0.000295623009514958 0.000294746030737385 0.000293872283630860 0.000293001753919169 0.000292134427399411 0.000291270289941568 0.000290409327488084 0.000289551526053445 0.000288696871723765 0.000287845350656414 0.000286996949079420 0.000286151653291342 0.000285309449660678 0.000284470324625504 0.000283634264693072 0.000282801256439417 0.000281971286508953 0.000281144341614086 0.000280320408534818 0.000279499474118361 0.000278681525278747 0.000277866548996447 0.000277054532317990 0.000276245462355580 0.000275439326286723 0.000274636111353851 0.000273835804863951 0.000273038394188192 0.000272243866761562 0.000271452210082501 0.000270663411712535 0.000269877459275923 0.000269094340459293 0.000268314043011285 0.000267536554742203 0.000266761863523658 0.000265989957288222 0.000265220824029078 0.000264454451799680 0.000263690828713405 0.000262929942943212 0.000262171782721312 0.000261416336338819 0.000260663592145426 0.000259913538549069 0.000259166164015595 0.000258421457068437 0.000257679406288288 0.000256940000312773 0.000256203227836134 0.000255469077608902 0.000254737538437587 0.000254008599184356 0.000253282248766721 0.000252558476157228 0.000251837270383147 0.000251118620526161 0.000250402515722063 0.000249688945160452 0.000248977898084426 0.000248269363790287 0.000247563331627238 0.000246859790997090 0.000246158731353964 0.000245460142203996 0.000244764013105055 0.000244070333666441 0.000243379093548606 0.000242690282462865 0.000242003890171111 0.000241319906485536 0.000240638321268345 0.000239959124431483 0.000239282305936353 0.000238607855793542 0.000237935764062549 0.000237266020851510 0.000236598616316929 0.000235933540663409 0.000235270784143388 0.000234610337056866 0.000233952189751148 0.000233296332620580 0.000232642756106285 0.000231991450695911 0.000231342406923366 0.000230695615368568 0.000230051066657185 0.000229408751460389 0.000228768660494600 0.000228130784521238 0.000227495114346473 0.000226861640820984 0.000226230354839706 0.000225601247341593 0.000224974309309372 0.000224349531769305 0.000223726905790948 0.000223106422486915 0.000222488073012637 0.000221871848566138 0.000221257740387787 0.000220645739760079 0.000220035838007397 0.000219428026495786 0.000218822296632723 0.000218218639866893 0.000217617047687964 0.000217017511626360 0.000216420023253044 0.000215824574179291 0.000215231156056475 0.000214639760575845 0.000214050379468313 0.000213463004504234 0.000212877627493195 0.000212294240283800 0.000211712834763459 0.000211133402858179 0.000210555936532351 0.000209980427788547 0.000209406868667309 0.000208835251246948 0.000208265567643335 0.000207697810009700 0.000207131970536434 0.000206568041450882 0.000206006015017150 0.000205445883535900 0.000204887639344160 0.000204331274815125 0.000203776782357961 0.000203224154417615 0.000202673383474620 0.000202124462044906 0.000201577382679609 0.000201032137964882 0.000200488720521707 0.000199947123005710 0.000199407338106974 0.000198869358549857 0.000198333177092806 0.000197798786528175 0.000197266179682047 0.000196735349414051 0.000196206288617184 0.000195678990217633 0.000195153447174600 0.000194629652480125 0.000194107599158908 0.000193587280268142 0.000193068688897335 0.000192551818168141 0.000192036661234189 0.000191523211280912 0.000191011461525382 0.000190501405216138 0.000189993035633022 0.000189486346087013 0.000188981329920063 0.000188477980504932 0.000187976291245026 0.000187476255574237 0.000186977866956778 0.000186481118887027 0.000185986004889368 0.000185492518518031 0.000185000653356936 0.000184510403019537 0.000184021761148666 0.000183534721416382 0.000183049277523813 0.000182565423201006 0.000182083152206775 0.000181602458328553 0.000181123335382236 0.000180645777212042 0.000180169777690354 0.000179695330717582 0.000179222430222010 0.000178751070159653 0.000178281244514114 0.000177812947296436 0.000177346172544965 0.000176880914325200 0.000176417166729661 0.000175954923877740 0.000175494179915567 0.000175034929015870 0.000174577165377835 0.000174120883226972 0.000173666076814973 0.000173212740419585 0.000172760868344467 0.000172310454919060 0.000171861494498454 0.000171413981463254 0.000170967910219447 0.000170523275198276 0.000170080070856104 0.000169638291674289 0.000169197932159051 0.000168758986841348 0.000168321450276748 0.000167885317045301 0.000167450581751411 0.000167017239023719 0.000166585283514969 0.000166154709901892 0.000165725512885078 0.000165297687188856 0.000164871227561173 0.000164446128773473 0.000164022385620575 0.000163599992920554 0.000163178945514626 0.000162759238267026 0.000162340866064889 0.000161923823818141 0.000161508106459374 0.000161093708943735 0.000160680626248812 0.000160268853374519 0.000159858385342982 0.000159449217198424 0.000159041344007060 0.000158634760856978 0.000158229462858030 0.000157825445141725 0.000157422702861116 0.000157021231190694 0.000156621025326275 0.000156222080484897 0.000155824391904711 0.000155427954844872 0.000155032764585439 0.000154638816427263 0.000154246105691888 0.000153854627721441];
BL3_Radius=[1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09];
BL3_RelF=[0.000764571801092814 0.00100125570724830 0.00127513042080605 0.00158504724677060 0.00192898643093359 0.00230420170551897 0.00270737360676257 0.00313476132300283 0.00358234578428836 0.00404595923759304 0.00452139860120411 0.00500452146830711 0.00549132478343130 0.00597800701317419 0.00646101514430197 0.00693707813294846 0.00740322855479342 0.00785681421475294 0.00829550140341990 0.00871727136535037 0.00912041139318935 0.00950350179752494 0.00986539983649673 0.0102052215291393 0.0105223221270194 0.0108162758826795 0.0110868556320005 0.0113340126010927 0.0115578567562599 0.0117586379370711 0.0119367279464774 0.0120926037169632 0.0122268316266303 0.0123400530026249 0.0124329708202380 0.0125063375832583 0.0125609443537349 0.0125976108863525 0.0126171768133524 0.0126204938196879 0.0126084187443055 0.0125818075416039 0.0125415100368272 0.0124883654100436 0.0124231983451737 0.0123468157829977 0.0122600042200227 0.0121635274983478 0.0120581250351104 0.0119445104436303 0.0118233705019065 0.0116953644276056 0.0115611234220654 0.0114212504490918 0.0112763202174194 0.0111268793386328 0.0109734466350885 0.0108165135749359 0.0106565448137098 0.0104939788241645 0.0103292285980304 0.0101626824052305 0.00999470459777676 0.00982563644710637 0.00965579700500957 0.00948548397956383 0.00931497461862475 0.00914452659444814 0.00897437888393512 0.00880475263981254 0.00863585204879367 0.00846786517341528 0.00830096477482493 0.00813530911430307 0.00797104273175525 0.00780829719980512 0.00764719185246532 0.00748783448766572 0.00733032204318049 0.00717474124572126 0.00702116923316197 0.00686967415002119 0.00672031571647542 0.00657314577129133 0.00642820878916580 0.00628554237304295 0.00614517772204444 0.00600714007570044 0.00587144913521054 0.00573811946249288 0.00560716085780186 0.00547857871670763 0.00535237436723749 0.00522854538798010 0.00510708590794971 0.00498798688899896 0.00487123639155765 0.00475681982446007 0.00464472017960679 0.00453491825218761 0.00442739284717253 0.00432212097275559 0.00421907802141442 0.00411823793922496 0.00401957338404785 0.00392305587317895 0.00382865592103332 0.00373634316740825 0.00364608649684768 0.00355785414960775 0.00347161382470056 0.00338733277547125 0.00330497789814241 0.00322451581373873 0.00314591294378479 0.00306913558014938 0.00299414994939099 0.00292092227194078 0.00284941881644212 0.00277960594954872 0.00271145018146779 0.00264491820751867 0.00257997694596300 0.00251659357234855 0.00245473555059485 0.00239437066103660 0.00233546702562809 0.00227799313050055 0.00222191784605326 0.00216721044474856 0.00211384061677114 0.00206177848370239 0.00201099461035172 0.00196146001487809 0.00191314617732706 0.00186602504670109 0.00182006904667329 0.00177525108004851 0.00173154453206861 0.00168892327265320 0.00164736165766096 0.00160683452925153 0.00156731721542256 0.00152878552879197 0.00149121576469061 0.00145458469862650 0.00141886958317753 0.00138404814436592 0.00135009857756396 0.00131699954297742 0.00128473016074953 0.00125327000572573 0.00122259910191653 0.00119269791669299 0.00116354735474724 0.00113512875184775 0.00110742386841707 0.00108041488295790 0.00105408438535098 0.00102841537004695 0.00100339122917246 0.000978995745569163 0.000955213085782873 0.000932027793018837 0.000909424780077593 0.000887389322284854 0.000865907050427669 0.000844963943708062 0.000824546322724374 0.000804640842489619 0.000785234485495316 0.000766314554828428 0.000747868667348510 0.000729884746930832 0.000712351017781714 0.000695255997830561 0.000678588492203244 0.000662337586780743 0.000646492641846441 0.000631043285825148 0.000615979409116371];
BL4_Radius=[2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09];
BL4_RelF=[0.00161957769785057 0.00221137953296107 0.00293611475164636 0.00380013318608136 0.00480494146770078 0.00594681738023573 0.00721676024731726 0.00860076438156568 0.0100803759041500 0.0116334742547738 0.0132352090446275 0.0148590200428764 0.0164776717616335 0.0180642426461859 0.0195930205179044 0.0210402690110974 0.0223848429105687 0.0236086424847840 0.0246969074150801 0.0256383593542206 0.0264252083811317 0.0270530427275122 0.0275206233500358 0.0278296055059980 0.0279842087940945 0.0279908554803400 0.0278577946529566 0.0275947271111413 0.0272124431156375 0.0267224823896088 0.0261368231852389 0.0254676049115017 0.0247268868027250 0.0239264434179847 0.0230775963978583 0.0221910808512847 0.0212769439740283 0.0203444729778550 0.0194021490993864 0.0184576243227607 0.0175177174553678 0.0165884263085629 0.0156749529265476 0.0147817390516646 0.0139125092923344 0.0130703197538046 0.0122576101883756 0.0114762580106248 0.0107276327969308 0.0100126501422238 0.00933182397720935 0.00868531665472497 0.00807298629402395 0.00749443102715000 0.00694902992337818 0.00643598047758348 0.00595433263828438 0.00550301942305985 0.00508088422515756 0.00468670495746480 0.00431921521057090 0.00397712262224747 0.00365912466799006 0.00336392208781365 0.00309023016461330 0.00283678806526110 0.00260236644822168 0.00238577353168894 0.00218585980479870 0.00200152155195606 0.00183170334721372 0.00167539966234955 0.00153165571911553 0.00139956770331034 0.00127828244603474];
BL6_Radius=[3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10];
BL6_RelF=[0.00262332212631044 0.00364533936844707 0.00491072673406038 0.00642899328285219 0.00819766346022050 0.0102012509782635 0.0124112774258497 0.0147873233266652 0.0172789859998907 0.0198285323577622 0.0223739833824718 0.0248523516565428 0.0272027699144924 0.0293692896215072 0.0313031849807601 0.0329646604999393 0.0343239215276117 0.0353616211439770 0.0360687397550758 0.0364459840263309 0.0365028094236436 0.0362561768708488 0.0357291509156448 0.0349494367092243 0.0339479384526347 0.0327574049306822 0.0314112101639282 0.0299423004555978 0.0283823241574185 0.0267609478995780 0.0251053530701992 0.0234398989796145 0.0217859342138919 0.0201617348655959 0.0185825472638068 0.0170607131306218 0.0156058564042004 0.0142251129617590 0.0129233868705427 0.0117036193638806 0.0105670593079771 0.00951352636587981 0.00854166029261280 0.00764915175908118 0.00683295177899880 0.00608945820073361 0.00541467883758912 0.00480437166861363 0.00425416317637644 0.00375964632975710 0.00331646000041332 0.00292035175157004 0.00256722598494813 0.00225317940073418 0.00197452563778053 0.00172781083459000];
BL7_Radius=[3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10];
BL7_RelF=[0.00256711531982955 0.00358109606650847 0.00483916603699053 0.00635089216445290 0.00811367897508339 0.0101117716116628 0.0123163313509146 0.0146865596484415 0.0171717314766123 0.0197139134127505 0.0222510936032230 0.0247204396094353 0.0270614211953993 0.0292185800293004 0.0311437874469456 0.0327978956324108 0.0341517490823156 0.0351865764117431 0.0358938240559099 0.0362745218980030 0.0363382866378589 0.0361020733031848 0.0355887808771265 0.0348258070278462 0.0338436317836873 0.0326744928407796 0.0313511977662543 0.0299061019784753 0.0283702669260274 0.0267728008488188 0.0251403750738891 0.0234969019240594 0.0218633557832104 0.0202577163508606 0.0186950122660625 0.0171874437140119 0.0157445639965787 0.0143735020374663 0.0130792101396352 0.0118647238043309 0.0107314228949662 0.00967928576829315 0.00870713012224232 0.00781283617954497 0.00699354941949948 0.00624586138703498 0.00556596816228019 0.00494980688787302 0.00439317135311926 0.00389180805392091 0.00344149441529374 0.00303810100795042 0.00267763963806629 0.00235629916319417 0.00207047080734566 0.00181676463127864];
BL8_Radius=[3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10];
BL8_RelF=[0.00271518447664983 0.00380271378469013 0.00515446132129600 0.00677996935758326 0.00867493765694655 0.0108201612865884 0.0131817335352244 0.0157124756162432 0.0183544154548264 0.0210420365485000 0.0237059631194485 0.0262767393113836 0.0286883911079776 0.0308815190150385 0.0328057449856099 0.0344214169119018 0.0357005487270354 0.0366270370593727 0.0371962427123954 0.0374140558691695 0.0372955787486684 0.0368635607556718 0.0361467119950906 0.0351780046078081 0.0339930507907408 0.0326286242170392 0.0311213699378448 0.0295067281948310 0.0278180808168359 0.0260861154530155 0.0243383928737779 0.0225990957438017 0.0208889332590128 0.0192251743686068 0.0176217824716992 0.0160896260002642 0.0146367417369839 0.0132686306939652 0.0119885695924803 0.0107979242018900 0.00969645384950964 0.00868259919064094 0.00775374776428611 0.00690647392703945 0.00613675145479267 0.00544013844817761 0.00481193520471788 0.00424731646723190 0.00374143996579048 0.00328953348096294 0.00288696280836419 0.00252928303416326 0.00221227546939211 0.00193197246412884 0.00168467215289291];
BL9_Radius=[3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10];
BL9_RelF=[0.00255781793693398 0.00358944858974030 0.00487561840902253 0.00642731732808113 0.00824256866927752 0.0103052522141942 0.0125851065060609 0.0150388964351599 0.0176125995183179 0.0202443645345410 0.0228679383000708 0.0254162413227099 0.0278247954675439 0.0300347571495837 0.0319953768249042 0.0336657788809137 0.0350160263409373 0.0360274954750277 0.0366926324804520 0.0370141963276111 0.0370041090847667 0.0366820393398616 0.0360738383336752 0.0352099350136170 0.0341237782419401 0.0328503943407959 0.0314251080450142 0.0298824562480506 0.0282553076422515 0.0265741879974362 0.0248668005540502 0.0231577237195453 0.0214682636563026 0.0198164370362019 0.0182170587653034 0.0166819104072968 0.0152199669442591 0.0138376620477031 0.0125391748931174 0.0113267245016923 0.0102008604582006 0.00916074151210878 0.00820439594332610 0.00732895962463378 0.00653088942812210 0.00580615101186896 0.00515038110867469 0.00455902525263453 0.00402745245779715 0.00355104874342967 0.00312529161869312 0.00274580772940301 0.00240841586104289 0.00210915741136609 0.00184431631473386];
BL10_Radius=[3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10];
BL10_RelF=[0.00230788131499894 0.00329188332181623 0.00453768757930306 0.00606168972701463 0.00786694939057898 0.00994140668796688 0.0122573798008537 0.0147723973861515 0.0174312566597839 0.0201690654484344 0.0229149394076239 0.0255959891049972 0.0281412423303290 0.0304851952879375 0.0325707595267842 0.0343514563016491 0.0357927947469626 0.0368728457090697 0.0375820834548633 0.0379226099934761 0.0379069012667416 0.0375562227625059 0.0368988571582433 0.0359682719254301 0.0348013339477738 0.0334366543070061 0.0319131220787137 0.0302686632102028 0.0285392406240292 0.0267580953248204 0.0249552157276835 0.0231570135601057 0.0213861791583127 0.0196616862828069 0.0179989161539594 0.0164098716945496 0.0149034554414814 0.0134857878004504 0.0121605458917238 0.0109293068809841 0.00979188319226371 0.00874664021476069 0.00779078995370590 0.00692065649534689 0.00613191115035109 0.00541977672628146 0.00477920159254328 0.00420500508424400 0.00369199639294333 0.00323506946084804 0.00282927657680167 0.00246988340948967 0.00215240814259525 0.00187264722970561];
BL2_Radius=BL2_Radius*10^9; %to [nm]
BL3_Radius=BL3_Radius*10^9; %to [nm]
BL4_Radius=BL4_Radius*10^9; %to [nm]
BL6_Radius=BL6_Radius*10^9; %to [nm]
BL7_Radius=BL7_Radius*10^9; %to [nm]
BL8_Radius=BL8_Radius*10^9; %to [nm]
BL9_Radius=BL9_Radius*10^9; %to [nm]
BL10_Radius=BL10_Radius*10^9; %to [nm]

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(BL2_Radius,BL2_RelF,'.','MarkerSize',6,'Color',[0,0,0]./255);
plot(BL3_Radius,BL3_RelF,'.','MarkerSize',6,'Color',[96,58,232]./255);
plot(BL4_Radius,BL4_RelF,'.','MarkerSize',6,'Color',[230,68,62]./255);
plot(BL6_Radius,BL6_RelF,'.','MarkerSize',6,'Color',[0,0,0]./255);
plot(BL8_Radius,BL8_RelF,'.','MarkerSize',6,'Color',[96,58,232]./255);
plot(BL10_Radius,BL10_RelF,'.','MarkerSize',6,'Color',[230,68,62]./255);
axis([0.1,10,0,0.04]);
title('PDADMAC/PSS');
xlabel('Pore Radius [nm]');
set(gca,'FontSize',12)
ylabel('Relative Flux [-]');
ax = gca;
set(gca, 'XScale', 'log')
xticks([0.1 1 10]);
legend('2','3','4','6','8','10');
[leg, icons, plots, txt]  = legend('show');
title(leg,{'Number of','Bilayers [-]'})

%Spline to guide Eye
s=spline(BL4_Radius,BL4_RelF,BL4_Radius(1):0.002:BL4_Radius(end));
plot(BL4_Radius(1):0.002:BL4_Radius(end),s,'-','Color',[230,68,62]./255);
s=spline(BL6_Radius,BL6_RelF,BL6_Radius(1):0.002:BL6_Radius(end));
plot(BL6_Radius(1):0.002:BL6_Radius(end),s,'-','Color',[0,0,0]./255);
s=spline(BL8_Radius,BL8_RelF,BL8_Radius(1):0.002:BL8_Radius(end));
plot(BL8_Radius(1):0.002:BL8_Radius(end),s,'-','Color',[96,58,232]./255);
s=spline(BL10_Radius,BL10_RelF,BL10_Radius(1):0.002:BL10_Radius(end));
plot(BL10_Radius(1):0.002:BL10_Radius(end),s,'-','Color',[230,68,62]./255);

%PAH/PAA
BL3_Radius=[7.00000000000000e-11 8.00000000000000e-11 9.00000000000000e-11 1.00000000000000e-10 1.10000000000000e-10 1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09 2.09000000000000e-09 2.10000000000000e-09 2.11000000000000e-09 2.12000000000000e-09 2.13000000000000e-09 2.14000000000000e-09 2.15000000000000e-09 2.16000000000000e-09 2.17000000000000e-09 2.18000000000000e-09 2.19000000000000e-09 2.20000000000000e-09 2.21000000000000e-09 2.22000000000000e-09 2.23000000000000e-09 2.24000000000000e-09 2.25000000000000e-09 2.26000000000000e-09 2.27000000000000e-09 2.28000000000000e-09 2.29000000000000e-09 2.30000000000000e-09 2.31000000000000e-09 2.32000000000000e-09 2.33000000000000e-09 2.34000000000000e-09 2.35000000000000e-09 2.36000000000000e-09 2.37000000000000e-09 2.38000000000000e-09 2.39000000000000e-09 2.40000000000000e-09 2.41000000000000e-09 2.42000000000000e-09 2.43000000000000e-09 2.44000000000000e-09 2.45000000000000e-09 2.46000000000000e-09 2.47000000000000e-09 2.48000000000000e-09 2.49000000000000e-09 2.50000000000000e-09 2.51000000000000e-09 2.52000000000000e-09 2.53000000000000e-09 2.54000000000000e-09 2.55000000000000e-09 2.56000000000000e-09 2.57000000000000e-09 2.58000000000000e-09 2.59000000000000e-09 2.60000000000000e-09 2.61000000000000e-09 2.62000000000000e-09 2.63000000000000e-09 2.64000000000000e-09 2.65000000000000e-09 2.66000000000000e-09 2.67000000000000e-09 2.68000000000000e-09 2.69000000000000e-09 2.70000000000000e-09 2.71000000000000e-09 2.72000000000000e-09 2.73000000000000e-09 2.74000000000000e-09 2.75000000000000e-09 2.76000000000000e-09 2.77000000000000e-09 2.78000000000000e-09 2.79000000000000e-09 2.80000000000000e-09 2.81000000000000e-09 2.82000000000000e-09 2.83000000000000e-09 2.84000000000000e-09 2.85000000000000e-09 2.86000000000000e-09 2.87000000000000e-09 2.88000000000000e-09 2.89000000000000e-09 2.90000000000000e-09 2.91000000000000e-09 2.92000000000000e-09 2.93000000000000e-09 2.94000000000000e-09 2.95000000000000e-09 2.96000000000000e-09 2.97000000000000e-09 2.98000000000000e-09 2.99000000000000e-09 3.00000000000000e-09 3.01000000000000e-09 3.02000000000000e-09 3.03000000000000e-09 3.04000000000000e-09 3.05000000000000e-09 3.06000000000000e-09 3.07000000000000e-09 3.08000000000000e-09 3.09000000000000e-09 3.10000000000000e-09 3.11000000000000e-09 3.12000000000000e-09 3.13000000000000e-09 3.14000000000000e-09 3.15000000000000e-09 3.16000000000000e-09 3.17000000000000e-09 3.18000000000000e-09 3.19000000000000e-09 3.20000000000000e-09 3.21000000000000e-09 3.22000000000000e-09 3.23000000000000e-09 3.24000000000000e-09 3.25000000000000e-09 3.26000000000000e-09 3.27000000000000e-09 3.28000000000000e-09 3.29000000000000e-09 3.30000000000000e-09 3.31000000000000e-09 3.32000000000000e-09 3.33000000000000e-09 3.34000000000000e-09 3.35000000000000e-09 3.36000000000000e-09 3.37000000000000e-09 3.38000000000000e-09 3.39000000000000e-09 3.40000000000000e-09 3.41000000000000e-09 3.42000000000000e-09 3.43000000000000e-09 3.44000000000000e-09 3.45000000000000e-09 3.46000000000000e-09 3.47000000000000e-09 3.48000000000000e-09 3.49000000000000e-09 3.50000000000000e-09 3.51000000000000e-09 3.52000000000000e-09 3.53000000000000e-09 3.54000000000000e-09 3.55000000000000e-09 3.56000000000000e-09 3.57000000000000e-09 3.58000000000000e-09 3.59000000000000e-09 3.60000000000000e-09 3.61000000000000e-09 3.62000000000000e-09 3.63000000000000e-09 3.64000000000000e-09 3.65000000000000e-09 3.66000000000000e-09 3.67000000000000e-09 3.68000000000000e-09 3.69000000000000e-09 3.70000000000000e-09 3.71000000000000e-09 3.72000000000000e-09 3.73000000000000e-09 3.74000000000000e-09 3.75000000000000e-09 3.76000000000000e-09 3.77000000000000e-09 3.78000000000000e-09 3.79000000000000e-09 3.80000000000000e-09 3.81000000000000e-09 3.82000000000000e-09 3.83000000000000e-09 3.84000000000000e-09 3.85000000000000e-09 3.86000000000000e-09 3.87000000000000e-09 3.88000000000000e-09 3.89000000000000e-09 3.90000000000000e-09 3.91000000000000e-09 3.92000000000000e-09 3.93000000000000e-09 3.94000000000000e-09 3.95000000000000e-09 3.96000000000000e-09 3.97000000000000e-09 3.98000000000000e-09 3.99000000000000e-09 4.00000000000000e-09 4.01000000000000e-09 4.02000000000000e-09 4.03000000000000e-09 4.04000000000000e-09 4.05000000000000e-09 4.06000000000000e-09 4.07000000000000e-09 4.08000000000000e-09 4.09000000000000e-09 4.10000000000000e-09 4.11000000000000e-09 4.12000000000000e-09 4.13000000000000e-09 4.14000000000000e-09 4.15000000000000e-09 4.16000000000000e-09 4.17000000000000e-09 4.18000000000000e-09 4.19000000000000e-09 4.20000000000000e-09 4.21000000000000e-09];
BL3_RelF=[0.000383271616636711 0.000551436275318673 0.000744481075171292 0.000957912113566081 0.00118728209351299 0.00142842011574460 0.00167755013129056 0.00193133898653170 0.00218690161432962 0.00244178140834035 0.00269391734016171 0.00294160507411863 0.00318345651643673 0.00341836041235550 0.00364544543886401 0.00386404650572653 0.00407367452310549 0.00427398962140879 0.00446477765301144 0.00464592972368924 0.00481742446618578 0.00497931276125482 0.00513170462110280 0.00527475796891387 0.00540866907133546 0.00553366440549705 0.00564999376655774 0.00575792444491876 0.00585773632356685 0.00594971776530967 0.00603416217688973 0.00611136515219290 0.00618162211013532 0.00624522635448376 0.00630246749301242 0.00635363016219379 0.00639899301122638 0.00643882790576482 0.00647339931737383 0.00650296386959641 0.00652777001571468 0.00654805782688142 0.00656405887239347 0.00657599617653444 0.00658408423869503 0.00658852910543718 0.00658952848484840 0.00658727189497501 0.00658194083935947 0.00657370900376855 0.00656274246910880 0.00654919993630579 0.00653323295959222 0.00651498618522257 0.00649459759312222 0.00647219873939837 0.00644791499799878 0.00642186580011068 0.00639416487015329 0.00636492045744045 0.00633423556277897 0.00630220815942938 0.00626893140799214 0.00623449386489769 0.00619897968427555 0.00616246881306003 0.00612503717925767 0.00608675687335877 0.00604769632292264 0.00600792046040441 0.00596749088432318 0.00592646601389662 0.00588490123728718 0.00584284905362101 0.00580035920895269 0.00575747882635747 0.00571425253033925 0.00567072256574584 0.00562692891138561 0.00558290938853947 0.00553869976456152 0.00549433385175970 0.00544984360174454 0.00540525919543102 0.00536060912887402 0.00531592029511320 0.00527121806219863 0.00522652634756289 0.00518186768889957 0.00513726331170493 0.00509273319362985 0.00504829612578801 0.00500396977115778 0.00495977072021143 0.00491571454389894 0.00487181584410924 0.00482808830172597 0.00478454472239029 0.00474119708007808 0.00469805655859439 0.00465513359108335 0.00461243789764740 0.00456997852116529 0.00452776386139459 0.00448580170744005 0.00444409926866579 0.00440266320412541 0.00436149965058079 0.00432061424917702 0.00428001217083755 0.00423969814044093 0.00419967645983728 0.00415995102976005 0.00412052537068595 0.00408140264269327 0.00404258566436671 0.00400407693079412 0.00396587863069864 0.00392799266274771 0.00389042065107806 0.00385316396007428 0.00381622370843659 0.00377960078257169 0.00374329584933898 0.00370730936818288 0.00367164160268051 0.00363629263153257 0.00360126235902374 0.00356655052497812 0.00353215671423344 0.00349808036565694 0.00346432078072474 0.00343087713168530 0.00339774846932670 0.00336493373036650 0.00333243174448199 0.00330024124099790 0.00326836085524766 0.00323678913462364 0.00320552454433108 0.00317456547285966 0.00314391023718596 0.00311355708771954 0.00308350421300466 0.00305374974418915 0.00302429175927140 0.00299512828713582 0.00296625731138677 0.00293767677399042 0.00290938457873346 0.00288137859450738 0.00285365665842643 0.00282621657878705 0.00279905613787621 0.00277217309463579 0.00274556518718966 0.00271923013523998 0.00269316564233877 0.00266736939804071 0.00264183907994259 0.00261657235561484 0.00259156688443016 0.00256682031929411 0.00254233030828219 0.00251809449618790 0.00249411052598589 0.00247037604021421 0.00244688868227952 0.00242364609768881 0.00240064593521113 0.00237788584797270 0.00235536349448840 0.00233307653963284 0.00231102265555367 0.00228919952253003 0.00226760482977872 0.00224623627621047 0.00222509157113888 0.00220416843494405 0.00218346459969333 0.00216297780972098 0.00214270582216927 0.00212264640749166 0.00210279734992155 0.00208315644790692 0.00206372151451325 0.00204449037779591 0.00202546088114371 0.00200663088359494 0.00198799826012731 0.00196956090192298 0.00195131671661009 0.00193326362848172 0.00191539957869373 0.00189772252544220 0.00188023044412174 0.00186292132746562 0.00184579318566848 0.00182884404649277 0.00181207195535952 0.00179547497542446 0.00177905118764009 0.00176279869080454 0.00174671560159795 0.00173080005460692 0.00171505020233778 0.00169946421521926 0.00168404028159509 0.00166877660770724 0.00165367141767010 0.00163872295343630 0.00162392947475460 0.00160928925912029 0.00159480060171846 0.00158046181536079 0.00156627123041602 0.00155222719473455 0.00153832807356768 0.00152457224948157 0.00151095812226651 0.00149748410884163 0.00148414864315544 0.00147095017608248 0.00145788717531628 0.00144495812525902 0.00143216152690802 0.00141949589773931 0.00140695977158858 0.00139455169852963 0.00138227024475060 0.00137011399242809 0.00135808153959946 0.00134617150003334 0.00133438250309868 0.00132271319363238 0.00131116223180566 0.00129972829298937 0.00128841006761836 0.00127720626105496 0.00126611559345180 0.00125513679961400 0.00124426862886093 0.00123350984488752 0.00122285922562531 0.00121231556310337 0.00120187766330901 0.00119154434604857 0.00118131444480819 0.00117118680661476 0.00116116029189708 0.00115123377434726 0.00114140614078247 0.00113167629100704 0.00112204313767513 0.00111250560615370 0.00110306263438623 0.00109371317275692 0.00108445618395553 0.00107529064284293 0.00106621553631737 0.00105722986318150 0.00104833263401011 0.00103952287101881 0.00103079960793342 0.00102216188986033 0.00101360877315772 0.00100513932530768 0.000996752624789318 0.000988447760952779 0.000980223833894272 0.000972079954332083 0.000964015243483589 0.000956028832943315 0.000948119864561999 0.000940287490326730 0.000932530872242122 0.000924849182212564 0.000917241601925534 0.000909707322735998 0.000902245545551899 0.000894855480720714 0.000887536347917132 0.000880287376031808 0.000873107803061221 0.000865996875998642 0.000858953850726183 0.000851977991907968 0.000845068572884392 0.000838224875567479 0.000831446190337351 0.000824731815939774 0.000818081059384816 0.000811493235846578 0.000804967668564025 0.000798503688742896 0.000792100635458682 0.000785757855560699 0.000779474703577201 0.000773250541621586 0.000767084739299635 0.000760976673617816 0.000754925728892628 0.000748931296660983 0.000742992775591624 0.000737109571397561 0.000731281096749531 0.000725506771190464 0.000719786021050953 0.000714118279365721 0.000708502985791067 0.000702939586523307 0.000697427534218169 0.000691966287911160 0.000686555312938886 0.000681194080861319 0.000675882069385001 0.000670618762287173 0.000665403649340835 0.000660236226240708 0.000655115994530101 0.000650042461528678 0.000645015140261108 0.000640033549386584 0.000635097213129226 0.000630205661209331 0.000625358428775473 0.000620555056337456 0.000615795089700089 0.000611078079897786 0.000606403583129992 0.000601771160697397 0.000597180378938963 0.000592630809169737 0.000588122027619437 0.000583653615371819 0.000579225158304798 0.000574836247031331 0.000570486476841039 0.000566175447642572 0.000561902763906700 0.000557668034610119 0.000553470873179982 0.000549310897439120 0.000545187729551964 0.000541100995971156 0.000537050327384832 0.000533035358664591 0.000529055728814098 0.000525111080918381 0.000521201062093734 0.000517325323438292 0.000513483519983219 0.000509675310644522 0.000505900358175486 0.000502158329119715 0.000498448893764768 0.000494771726096401 0.000491126503753377 0.000487512907982876 0.000483930623596455 0.000480379338926591 0.000476858745783765 0.000473368539414105 0.000469908418457578 0.000466478084906701 0.000463077244065795 0.000459705604510760 0.000456362878049364 0.000453048779682038 0.000449763027563182 0.000446505342962957 0.000443275450229582 0.000440073076752099 0.000436897952923624 0.000433749812105071 0.000430628390589334 0.000427533427565936 0.000424464665086126 0.000421421848028430 0.000418404724064630 0.000415413043626199 0.000412446559871148 0.000409505028651305 0.000406588208480019 0.000403695860500263 0.000400827748453164 0.000397983638646915 0.000395163299926102 0.000392366503641416 0.000389593023619750 0.000386842636134682 0.000384115119877337 0.000381410255927610 0.000378727827725773 0.000376067621044432 0.000373429423960846 0.000370813026829593 0.000368218222255598 0.000365644805067491 0.000363092572291307 0.000360561323124528 0.000358050858910446 0.000355560983112857 0.000353091501291075 0.000350642221075262 0.000348212952142077 0.000345803506190623 0.000343413696918711 0.000341043339999413 0.000338692253057925 0.000336360255648710 0.000334047169232937 0.000331752817156205 0.000329477024626546 0.000327219618692707];
BL5_Radius=[5.00000000000000e-11 6.00000000000000e-11 7.00000000000000e-11 8.00000000000000e-11 9.00000000000000e-11 1.00000000000000e-10 1.10000000000000e-10 1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09 1.29000000000000e-09 1.30000000000000e-09 1.31000000000000e-09 1.32000000000000e-09 1.33000000000000e-09 1.34000000000000e-09 1.35000000000000e-09 1.36000000000000e-09 1.37000000000000e-09 1.38000000000000e-09 1.39000000000000e-09 1.40000000000000e-09 1.41000000000000e-09 1.42000000000000e-09 1.43000000000000e-09 1.44000000000000e-09 1.45000000000000e-09 1.46000000000000e-09 1.47000000000000e-09 1.48000000000000e-09 1.49000000000000e-09 1.50000000000000e-09 1.51000000000000e-09 1.52000000000000e-09 1.53000000000000e-09 1.54000000000000e-09 1.55000000000000e-09 1.56000000000000e-09 1.57000000000000e-09 1.58000000000000e-09 1.59000000000000e-09 1.60000000000000e-09 1.61000000000000e-09 1.62000000000000e-09 1.63000000000000e-09 1.64000000000000e-09 1.65000000000000e-09 1.66000000000000e-09 1.67000000000000e-09 1.68000000000000e-09 1.69000000000000e-09 1.70000000000000e-09 1.71000000000000e-09 1.72000000000000e-09 1.73000000000000e-09 1.74000000000000e-09 1.75000000000000e-09 1.76000000000000e-09 1.77000000000000e-09 1.78000000000000e-09 1.79000000000000e-09 1.80000000000000e-09 1.81000000000000e-09 1.82000000000000e-09 1.83000000000000e-09 1.84000000000000e-09 1.85000000000000e-09 1.86000000000000e-09 1.87000000000000e-09 1.88000000000000e-09 1.89000000000000e-09 1.90000000000000e-09 1.91000000000000e-09 1.92000000000000e-09 1.93000000000000e-09 1.94000000000000e-09 1.95000000000000e-09 1.96000000000000e-09 1.97000000000000e-09 1.98000000000000e-09 1.99000000000000e-09 2.00000000000000e-09 2.01000000000000e-09 2.02000000000000e-09 2.03000000000000e-09 2.04000000000000e-09 2.05000000000000e-09 2.06000000000000e-09 2.07000000000000e-09 2.08000000000000e-09 2.09000000000000e-09 2.10000000000000e-09 2.11000000000000e-09 2.12000000000000e-09 2.13000000000000e-09 2.14000000000000e-09 2.15000000000000e-09 2.16000000000000e-09 2.17000000000000e-09 2.18000000000000e-09 2.19000000000000e-09 2.20000000000000e-09 2.21000000000000e-09 2.22000000000000e-09 2.23000000000000e-09 2.24000000000000e-09 2.25000000000000e-09 2.26000000000000e-09 2.27000000000000e-09 2.28000000000000e-09 2.29000000000000e-09 2.30000000000000e-09 2.31000000000000e-09 2.32000000000000e-09 2.33000000000000e-09 2.34000000000000e-09 2.35000000000000e-09 2.36000000000000e-09 2.37000000000000e-09 2.38000000000000e-09 2.39000000000000e-09 2.40000000000000e-09 2.41000000000000e-09 2.42000000000000e-09 2.43000000000000e-09 2.44000000000000e-09 2.45000000000000e-09 2.46000000000000e-09 2.47000000000000e-09 2.48000000000000e-09 2.49000000000000e-09 2.50000000000000e-09 2.51000000000000e-09 2.52000000000000e-09 2.53000000000000e-09 2.54000000000000e-09 2.55000000000000e-09 2.56000000000000e-09 2.57000000000000e-09 2.58000000000000e-09 2.59000000000000e-09 2.60000000000000e-09 2.61000000000000e-09 2.62000000000000e-09 2.63000000000000e-09 2.64000000000000e-09 2.65000000000000e-09 2.66000000000000e-09 2.67000000000000e-09 2.68000000000000e-09 2.69000000000000e-09 2.70000000000000e-09 2.71000000000000e-09 2.72000000000000e-09 2.73000000000000e-09 2.74000000000000e-09 2.75000000000000e-09 2.76000000000000e-09 2.77000000000000e-09 2.78000000000000e-09 2.79000000000000e-09 2.80000000000000e-09 2.81000000000000e-09 2.82000000000000e-09 2.83000000000000e-09 2.84000000000000e-09 2.85000000000000e-09 2.86000000000000e-09 2.87000000000000e-09 2.88000000000000e-09 2.89000000000000e-09 2.90000000000000e-09 2.91000000000000e-09 2.92000000000000e-09 2.93000000000000e-09 2.94000000000000e-09 2.95000000000000e-09 2.96000000000000e-09 2.97000000000000e-09];
BL5_RelF=[0.000495301658070569 0.000819831824462020 0.00120945492498967 0.00164786769276254 0.00211945971720582 0.00261043072357045 0.00310916768519531 0.00360623777923946 0.00409420025777313 0.00456734816333439 0.00502143782700579 0.00545343442907835 0.00586128569605926 0.00624372722100059 0.00660011856646571 0.00693030732667243 0.00723451760468142 0.00751325929378501 0.00776725480144050 0.00799738023446917 0.00820461847781196 0.00839002199658929 0.00855468355021794 0.00869971332015399 0.00882622121930850 0.00893530337481962 0.00902803196165211 0.00910544771775136 0.00916855459727388 0.00921831612130948 0.00925565306946117 0.00928144222402429 0.00929651593412537 0.00930166231238223 0.00929762591335679 0.00928510877286756 0.00926477171140189 0.00923723582446777 0.00920308409860820 0.00916286310466236 0.00911708473026404 0.00906622792197551 0.00901074041424173 0.00895104042781469 0.00888751832469069 0.00882053821012365 0.00875043947508961 0.00867753827481262 0.00860212894073108 0.00852448532467290 0.00844486207508947 0.00836349584603257 0.00828060644019126 0.00819639788777760 0.00811105946339160 0.00802476664323444 0.00793768200519424 0.00784995607441883 0.00776172811702878 0.00767312688462261 0.00758427131219360 0.00749527117202250 0.00740622768603698 0.00731723409904333 0.00722837621514170 0.00713973289953628 0.00705137654784893 0.00696337352494059 0.00687578457514095 0.00678866520568441 0.00670206604505038 0.00661603317780868 0.00653060845747715 0.00644582979880884 0.00636173145083995 0.00627834425194776 0.00619569586809029 0.00611381101532538 0.00603271166763735 0.00595241725103365 0.00587294482481193 0.00579430925083954 0.00571652335163300 0.00563959805797324 0.00556354254674431 0.00548836436963824 0.00541406957332621 0.00534066281165657 0.00526814745040355 0.00519652566505562 0.00512579853209937 0.00505596611422738 0.00498702753986547 0.00491898107739339 0.00485182420440518 0.00478555367233354 0.00472016556674128 0.00465565536356238 0.00459201798155695 0.00452924783122682 0.00446733886042216 0.00440628459685451 0.00434607818771731 0.00428671243660201 0.00422817983788522 0.00417047260875124 0.00411358271900324 0.00405750191880660 0.00400222176449841 0.00394773364258848 0.00389402879206911 0.00384109832514316 0.00378893324647293 0.00373752447104573 0.00368686284074587 0.00363693913971683 0.00358774410859225 0.00353926845766917 0.00349150287909213 0.00344443805811264 0.00339806468348405 0.00335237345704841 0.00330735510256773 0.00326300037384944 0.00321930006221204 0.00317624500333423 0.00313382608352828 0.00309203424547540 0.00305086049345877 0.00301029589812759 0.00297033160082319 0.00293095881749666 0.00289216884224514 0.00285395305049252 0.00281630290183869 0.00277920994259953 0.00274266580805913 0.00270666222445359 0.00267119101070525 0.00263624407992438 0.00260181344069485 0.00256789119815875 0.00253446955491438 0.00250154081174085 0.00246909736816188 0.00243713172286042 0.00240563647395515 0.00237460431914906 0.00234402805575972 0.00231390058064036 0.00228421489000001 0.00225496407913079 0.00222614134204953 0.00219773997106081 0.00216975335624779 0.00214217498489690 0.00211499844086207 0.00208821740387372 0.00206182564879759 0.00203581704484787 0.00201018555475909 0.00198492523392072 0.00196003022947828 0.00193549477940446 0.00191131321154357 0.00188747994263231 0.00186398947729984 0.00184083640704961 0.00181801540922565 0.00179552124596548 0.00177334876314184 0.00175149288929520 0.00172994863455896 0.00170871108957904 0.00168777542442939 0.00166713688752502 0.00164679080453385 0.00162673257728864 0.00160695768270023 0.00158746167167310 0.00156824016802430 0.00154928886740671 0.00153060353623727 0.00151218001063150 0.00149401419534399 0.00147610206271673 0.00145843965163508 0.00144102306649210 0.00142384847616186 0.00140691211298198 0.00139021027174606 0.00137373930870599 0.00135749564058491 0.00134147574360067 0.00132567615250037 0.00131009345960605 0.00129472431387170 0.00127956541995189 0.00126461353728199 0.00124986547917023 0.00123531811190170 0.00122096835385418 0.00120681317462615 0.00119284959417674 0.00117907468197785 0.00116548555617832 0.00115207938278016 0.00113885337482696 0.00112580479160423 0.00111293093785178 0.00110022916298805 0.00108769686034633 0.00107533146642282 0.00106313046013633 0.00105109136209983 0.00103921173390333 0.00102748917740844 0.00101592133405419 0.00100450588417412 0.000993240546324547 0.000982123076623874 0.000971151268102793 0.000960322950065302 0.000949635987460384 0.000939088280264257 0.000928677762873004 0.000918402403505529 0.000908260203616639 0.000898249197320170 0.000888367450821987 0.000878613061862738 0.000868984159170235 0.000859478901921303 0.000850095479212988 0.000840832109542959 0.000831687040298989 0.000822658547257380 0.000813744934090171 0.000804944531881032 0.000796255698649667 0.000787676818884639 0.000779206303084438 0.000770842587306690 0.000762584132725376 0.000754429425195903 0.000746376974827936 0.000738425315565834 0.000730573004776577 0.000722818622845057 0.000715160772776607 0.000707598079806649 0.000700129191017330 0.000692752774961044 0.000685467521290705 0.000678272140396660 0.000671165363050134 0.000664145940053077 0.000657212641894317 0.000650364258411900 0.000643599598461512 0.000636917489590863 0.000630316777719947 0.000623796326827065 0.000617355018640489 0.000610991752335704 0.000604705444238093 0.000598495027530985 0.000592359451968964 0.000586297683596346 0.000580308704470726 0.000574391512391505 0.000568545120633314 0.000562768557684230 0.000557060866988701 0.000551421106695118 0.000545848349407903 0.000540341681944074 0.000534900205094175 0.000529523033387509 0.000524209294861583 0.000518958130835694 0.000513768695688577 0.000508640156640036 0.000503571693536500 0.000498562498640405 0.000493611776423354 0.000488718743362980 0.000483882627743431 0.000479102669459427 0.000474378119823813 0.000469708241378538 0.000465092307709012 0.000460529603261765];
BL7_Radius=[6.00000000000000e-11 7.00000000000000e-11 8.00000000000000e-11 9.00000000000000e-11 1.00000000000000e-10 1.10000000000000e-10 1.20000000000000e-10 1.30000000000000e-10 1.40000000000000e-10 1.50000000000000e-10 1.60000000000000e-10 1.70000000000000e-10 1.80000000000000e-10 1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10 4.60000000000000e-10 4.70000000000000e-10 4.80000000000000e-10 4.90000000000000e-10 5.00000000000000e-10 5.10000000000000e-10 5.20000000000000e-10 5.30000000000000e-10 5.40000000000000e-10 5.50000000000000e-10 5.60000000000000e-10 5.70000000000000e-10 5.80000000000000e-10 5.90000000000000e-10 6.00000000000000e-10 6.10000000000000e-10 6.20000000000000e-10 6.30000000000000e-10 6.40000000000000e-10 6.50000000000000e-10 6.60000000000000e-10 6.70000000000000e-10 6.80000000000000e-10 6.90000000000000e-10 7.00000000000000e-10 7.10000000000000e-10 7.20000000000000e-10 7.30000000000000e-10 7.40000000000000e-10 7.50000000000000e-10 7.60000000000000e-10 7.70000000000000e-10 7.80000000000000e-10 7.90000000000000e-10 8.00000000000000e-10 8.10000000000000e-10 8.20000000000000e-10 8.30000000000000e-10 8.40000000000000e-10 8.50000000000000e-10 8.60000000000000e-10 8.70000000000000e-10 8.80000000000000e-10 8.90000000000000e-10 9.00000000000000e-10 9.10000000000000e-10 9.20000000000000e-10 9.30000000000000e-10 9.40000000000000e-10 9.50000000000000e-10 9.60000000000000e-10 9.70000000000000e-10 9.80000000000000e-10 9.90000000000000e-10 1.00000000000000e-09 1.01000000000000e-09 1.02000000000000e-09 1.03000000000000e-09 1.04000000000000e-09 1.05000000000000e-09 1.06000000000000e-09 1.07000000000000e-09 1.08000000000000e-09 1.09000000000000e-09 1.10000000000000e-09 1.11000000000000e-09 1.12000000000000e-09 1.13000000000000e-09 1.14000000000000e-09 1.15000000000000e-09 1.16000000000000e-09 1.17000000000000e-09 1.18000000000000e-09 1.19000000000000e-09 1.20000000000000e-09 1.21000000000000e-09 1.22000000000000e-09 1.23000000000000e-09 1.24000000000000e-09 1.25000000000000e-09 1.26000000000000e-09 1.27000000000000e-09 1.28000000000000e-09];
BL7_RelF=[0.00111820973493028 0.00195237497831321 0.00301383429872885 0.00425771944989799 0.00562989290517394 0.00707547434900395 0.00854414435543642 0.00999290204054816 0.0113870627445799 0.0127001565266964 0.0139132116715340 0.0150137491816339 0.0159946930937756 0.0168533162202602 0.0175902843061251 0.0182088257963904 0.0187140329135035 0.0191122876826120 0.0194108004780271 0.0196172462730891 0.0197394835302005 0.0197853415917134 0.0197624639190262 0.0196781962125053 0.0195395101201629 0.0193529547976361 0.0191246299650366 0.0188601753022082 0.0185647720373335 0.0182431534294794 0.0178996215428989 0.0175380682801158 0.0171619991016442 0.0167745582304988 0.0163785544351742 0.0159764867190478 0.0155705694286356 0.0151627564373490 0.0147547641732926 0.0143480933456594 0.0139440492897345 0.0135437608996803 0.0131481981546147 0.0127581882697793 0.0123744305230655 0.0119975098195842 0.0116279090647527 0.0112660204206377 0.0109121555219228 0.0105665547275545 0.0102293954823915 0.00990079986048049 0.00958084135820205 0.00926955100174735 0.00896692282937133 0.00867291880476779 0.00838747321382958 0.00811049659306843 0.00784187923412376 0.00758149430512667 0.00732920062622447 0.00708484513332420 0.00684826506108684 0.00661928987339507 0.00639774296692147 0.00618344317103440 0.00597620606508425 0.00577584513210408 0.00558217276612249 0.00539500114861384 0.00521414300808682 0.00503941227542856 0.00487062464636468 0.00470759806125676 0.00455015311142725 0.00439811338026896 0.00425130572655258 0.00410956051658416 0.00397271181117717 0.00384059751278325 0.00371305947756746 0.00358994359670987 0.00347109985076251 0.00335638234048210 0.00324564929719285 0.00313876307540293 0.00303559013010223 0.00293600098090255 0.00283987016494240 0.00274707618026318 0.00265750142117305 0.00257103210693913 0.00248755820499693 0.00240697334972553 0.00232917475771352 0.00225406314032990 0.00218154261431439 0.00211152061101331 0.00204390778480766 0.00197861792120952 0.00191556784503949 0.00185467732904209 0.00179586900324576 0.00173906826532945 0.00168420319221868 0.00163120445309846 0.00158000522399952 0.00153054110408682 0.00148275003375488 0.00143657221461311 0.00139195003142544 0.00134882797605178 0.00130715257342466 0.00126687230958124 0.00122793756176026 0.00119030053056354 0.00115391517417355 0.00111873714461124 0.00108472372601245 0.00105183377489574 0.00102002766239030 0.000989267218388760 0.000959515677586937];
BL9_Radius=[1.90000000000000e-10 2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10 4.30000000000000e-10 4.40000000000000e-10 4.50000000000000e-10];
BL9_RelF=[0.00497680968919734 0.00946930141514860 0.0161405173996782 0.0249841858530186 0.0355282714498295 0.0468726465691434 0.0578588112150908 0.0673113896272921 0.0742711842987104 0.0781546984586882 0.0788105150017585 0.0764794871351157 0.0716898905301238 0.0651264173066716 0.0575064229999036 0.0494845850824704 0.0415940820648421 0.0342223093183404 0.0276133421534948 0.0218874460417160 0.0170687083044345 0.0131140070945241 0.00993900710924833 0.00743904495777833 0.00550436557066922 0.00403016515197347 0.00292238820113781];
BL10_Radius=[2.00000000000000e-10 2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10];
BL10_RelF=[0.00485478054941074 0.0101756771583891 0.0186694628415609 0.0304621032508058 0.0448051383146789 0.0601017427952017 0.0742677343594601 0.0852812231727819 0.0916954983729033 0.0929339899527789 0.0893047059174524 0.0817880215004675 0.0717143902674098 0.0604488786509559 0.0491595152852582 0.0386962942706245 0.0295687382303159 0.0219902027925801 0.0159543000872562 0.0113161408334644 0.00786182473179715 0.00535929224412825 0.00359034442031838];
BL11_Radius=[2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10 4.20000000000000e-10];
BL11_RelF=[0.0100885739221979 0.0187389139091573 0.0308572955289307 0.0456780690696629 0.0615150019372883 0.0761478618892394 0.0874230806876280 0.0938159299895972 0.0947497220383937 0.0906024979441633 0.0824643793951490 0.0717787772510054 0.0599985871817669 0.0483410360830138 0.0376672512764828 0.0284693935833091 0.0209276668485350 0.0149981714636577 0.0105020854370082 0.00719925118339203 0.00484003641496137 0.00319641696546014];
BL12_Radius=[2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10];
BL12_RelF=[0.0103604891659349 0.0193709193448341 0.0320191372217927 0.0474612565357986 0.0638629899442980 0.0788362810811806 0.0901053824214628 0.0961156459495851 0.0963597318276478 0.0913539297252350 0.0823468213446909 0.0709156658635236 0.0585960064060101 0.0466312579546391 0.0358630004475872 0.0267362299571832 0.0193743447668423 0.0136803833849679 0.00943367194506781 0.00636574480109857 0.00421110991061956];
BL14_Radius=[2.10000000000000e-10 2.20000000000000e-10 2.30000000000000e-10 2.40000000000000e-10 2.50000000000000e-10 2.60000000000000e-10 2.70000000000000e-10 2.80000000000000e-10 2.90000000000000e-10 3.00000000000000e-10 3.10000000000000e-10 3.20000000000000e-10 3.30000000000000e-10 3.40000000000000e-10 3.50000000000000e-10 3.60000000000000e-10 3.70000000000000e-10 3.80000000000000e-10 3.90000000000000e-10 4.00000000000000e-10 4.10000000000000e-10];
BL14_RelF=[0.00643054740705406 0.0136123166671726 0.0249699466369182 0.0403505618486661 0.0582601693541552 0.0760842421608571 0.0908304119749962 0.100047474022908 0.102505131857487 0.0983901431619547 0.0890353749169460 0.0763843993875170 0.0624358525884448 0.0488396981130808 0.0367062497234747 0.0265996440460618 0.0186451153035778 0.0126781316973370 0.00838441693795090 0.00540551793780236 0.00340465425563839];
BL3_Radius=BL3_Radius*10^9; %to [nm]
BL5_Radius=BL5_Radius*10^9; %to [nm]
BL7_Radius=BL7_Radius*10^9; %to [nm]
BL9_Radius=BL9_Radius*10^9; %to [nm]
BL10_Radius=BL10_Radius*10^9; %to [nm]
BL11_Radius=BL11_Radius*10^9; %to [nm]
BL12_Radius=BL12_Radius*10^9; %to [nm]
BL14_Radius=BL14_Radius*10^9; %to [nm]

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(BL3_Radius,BL3_RelF,'.','MarkerSize',4,'Color',[0,0,0]./255);
plot(BL5_Radius,BL5_RelF,'.','MarkerSize',4,'Color',[96,58,232]./255);
plot(BL7_Radius,BL7_RelF,'.','MarkerSize',4,'Color',[230,68,62]./255);
plot(BL9_Radius,BL9_RelF,'.','MarkerSize',4,'Color',[0,0,0]./255);
plot(BL10_Radius,BL10_RelF,'.','MarkerSize',6,'Color',[96,58,232]./255);%'b'
plot(BL14_Radius,BL14_RelF,'.','MarkerSize',4,'Color',[230,68,62]./255);
axis([0.1,10,0,0.12]);
title('PAH/PAA');
xlabel('Pore Radius [nm]');
set(gca,'FontSize',12)
ylabel('Relative Flux [-]');
ax = gca;
set(gca, 'XScale', 'log')
xticks([0.1 1 10]);
legend('3','5','7','9','12','14');
[leg, icons, plots, txt]  = legend('show');
title(leg,{'Number of','Bilayers [-]'})

%Spline to guide Eye
s=spline(BL9_Radius,BL9_RelF,BL9_Radius(1):0.002:BL9_Radius(end));
plot(BL9_Radius(1):0.002:BL9_Radius(end),s,'-','Color',[0,0,0]./255);
s=spline(BL12_Radius,BL12_RelF,BL12_Radius(1):0.002:BL12_Radius(end));
plot(BL12_Radius(1):0.002:BL12_Radius(end),s,'-','Color',[96,58,232]./255);
s=spline(BL14_Radius,BL14_RelF,BL14_Radius(1):0.002:BL14_Radius(end));
plot(BL14_Radius(1):0.002:BL14_Radius(end),s,'-','Color',[230,68,62]./255);

%% Model Comparison Correlation 2 (Shimada)
%PDADMAC/PSS
BL=[2;3;4;6;7;8;9;10]; %Bilayer number
SPR=[0.017353663	0.014114529	0.001596883	0.000312222	0.000210297	0.000190068	0.000187233	0.000185196]; %MSE for Single Pore Radius Model
PDR=[0.001840476	0.003239306	0.000693103	0.000275141	0.000170639	0.000140812	0.000155716	0.000155539]; %MSE for Pore Radius Distribution Model
PDRI=[0.001860701	0.002390833	0.000515885	0.00025928	0.00015948	0.00013084	0.000141703	0.00014435]; %MSE for Pore Radius Distribution + Imperfaction Model
SPRI=[0.01071442	0.008539495	0.000990534	0.000254556	0.000171939	0.00015108	0.000147168	0.000146416]; %MSE for Imperfaction Model

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(BL,SPR,'.','MarkerSize',18,'Color',[0,0,0]./255);%'k'
plot(BL,PDR,'.','MarkerSize',18,'Color',[96,58,232]./255);%'b'
plot(BL,PDRI,'.','MarkerSize',18,'Color',[230,68,62]./255);%'r'
plot(BL,SPRI,'.','MarkerSize',18,'Color',[118,230,67]./255);%[.5 0 .5]
axis([0,12,0.00001,0.1]);
title('PDADMAC/PSS');
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Mean Squared Error [-]');
ax = gca;
set(gca, 'YScale', 'log');
xticks([2 4 6 8 10 12]);

%PAH/PAA
BL=[3;5;7;9;10;11;12;14]; %Bilayer number
SPR=[0.0191505	0.020525917	0.014827904	0.002298469	0.000830217	0.001205572	0.001146206	0.002073476]; %MSE for Single Pore Radius Model
PDR=[0.004607499	0.004236913	2.81E-03	0.00195055	0.000763323	0.001144293	0.001071627	0.002084018]; %MSE for Pore Radius Distribution Model
PDRI=[0.004202172	0.003824592	2.4031E-03	0.000633609	0.000326783	0.000310202	0.000329947	0.000519549]; %MSE for Pore Radius Distribution + Imperfaction Model
SPRI=[0.009813105	0.012320516	0.008826691	0.000894608	0.000372428	0.00034939	0.000377376	0.000504298]; %MSE for Imperfaction Model

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(BL,SPR,'.','MarkerSize',18,'Color',[0,0,0]./255);%'k'
plot(BL,PDR,'.','MarkerSize',18,'Color',[96,58,232]./255);%'b'
plot(BL,PDRI,'.','MarkerSize',18,'Color',[230,68,62]./255);%'r'
plot(BL,SPRI,'.','MarkerSize',18,'Color',[118,230,67]./255);%[.5 0 .5]
axis([0,16,0.00001,0.1]);
title('PAH/PAA');
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Mean Squared Error [-]');
ax = gca;
set(gca, 'YScale', 'log');
xticks([2 4 6 8 10 12 14 16]);

%% Model Comparison Correlation 1 (Murugaiah)
%PDADMAC/PSS
BL=[2;3;4;6;7;8;9;10]; %Bilayer number
SPR=[0.021556908	0.017822783	0.001850189	0.000484902	0.00050059	0.000522171	0.000480959	0.000472488]; %MSE for Single Pore Radius Model
PDR=[0.001919116	0.003260126	0.000563735	6.75339E-05	5.68198E-05	5.57477E-05	4.35604E-05	6.08549E-05]; %MSE for Pore Radius Distribution Model
PDRI=[0.001940246	0.002536701	0.000409483	6.06516E-05	5.34374E-05	5.17868E-05	3.95304E-05	5.67067E-05]; %MSE for Pore Radius Distribution + Imperfaction Model
SPRI=[0.013295118	0.010105273	0.001277399	0.000433873	0.000469703	0.00048764	0.000445032	0.000437703]; %MSE for Imperfaction Model

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(BL,SPR,'.','MarkerSize',18,'Color',[0,0,0]./255);%'k'
plot(BL,PDR,'.','MarkerSize',18,'Color',[96,58,232]./255);%'b'
plot(BL,PDRI,'.','MarkerSize',18,'Color',[230,68,62]./255);%'r'
plot(BL,SPRI,'.','MarkerSize',18,'Color',[118,230,67]./255);%[.5 0 .5]
axis([0,12,0.00001,0.1]);
title('PDADMAC/PSS');
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Mean Squared Error [-]');
ax = gca;
set(gca, 'YScale', 'log');
xticks([2 4 6 8 10 12]);

%PAH/PAA
BL=[3;5;7;9;10;11;12;14]; %Bilayer number
SPR=[0.022161967	0.025458733	0.016540573	0.004418597	0.002630011	0.002974487	0.00306616	0.003547771]; %MSE for Single Pore Radius Model
PDR=[4.85E-03	0.004577973	0.003297463	0.001972641	0.00075693	0.001140822	0.001112277	0.002008785]; %MSE for Pore Radius Distribution Model
PDRI=[0.004501065	4.1778E-03	0.002809799	0.000684969	0.000341329	0.000330304	0.000384974	0.000508982]; %MSE for Pore Radius Distribution + Imperfaction Model
SPRI=[0.012512385	0.01493372	0.010408737	0.003010605	0.002104572	0.00201533	0.001962945	0.001812539]; %MSE for Imperfection Model

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(BL,SPR,'.','MarkerSize',18,'Color',[0,0,0]./255);%'k'
plot(BL,PDR,'.','MarkerSize',18,'Color',[96,58,232]./255);%'b'
plot(BL,PDRI,'.','MarkerSize',18,'Color',[230,68,62]./255);%'r'
plot(BL,SPRI,'.','MarkerSize',18,'Color',[118,230,67]./255);%[.5 0 .5]
axis([0,16,0.00001,0.1]);
title('PAH/PAA');
xlabel('Number of Bilayers [-]');
set(gca,'FontSize',15)
ylabel('Mean Squared Error [-]');
ax = gca;
set(gca, 'YScale', 'log');
xticks([2 4 6 8 10 12 14 16]);
