function OUTPUT = TransmittingBoundaryFEM(...
                    EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Kdlat,Nlat,N,M,W,DampType,fTol)
VISCOUS = 1;
HYSTERETIC = 0;
if nargin < 18, DampType = HYSTERETIC; end
if nargin < 19, fTol = 10*eps; end

if Knlat(1) == inf
    Nlat = 0; Knlat = inf; Kslat = inf; Mlat = inf;
end
if length(Mlat)~=length(Knlat) || length(Mlat)~=length(Kslat) || length(Mlat)~=length(Nlat)
    fprintf(1, 'ERROR: lattice inputs must have all the same dimensions (except for Dlat)');
    return;
end

%% Create lattice - mesh and matrices - 1 slice
% fprintf(1, '\n');
% fprintf(1, 'Creating lattice grid ... ');
XZlat = zeros((N+M)*(sum(Nlat)+1),2);
x = 0;
kMass = 0;
for iN = 1:1:N+M
    XZlat(kMass+(1:sum(Nlat)+1),1) = x;
    XZlat(kMass+(1:sum(Nlat)+1),2) = -(0:1:sum(Nlat))'*D;
    kMass = kMass + sum(Nlat)+1;
    x = x + D;
end
% fprintf(1, 'done.\n');
% fprintf(1, 'Assembeling lattice matrices ... ');
nNodeLat = size(XZlat,1);
ad2Klat = zeros(100*nNodeLat,4); kNZT_K = 0;
ad2Mlat = zeros(100*nNodeLat,3); kNZT_M = 0;
Kdiag1 = 0.5*[1 1 0 0; -1 1 0 0; 0 0 1 1; 0 0 -1 1] * ...
             [1 0 -1 0; 0 0 0 0; -1 0 1 0; 0 0 0 0] * ...
             [1 -1 0 0; 1 1 0 0; 0 0 1 -1; 0 0 1 1];
Kdiag2 = 0.5*[1 -1 0 0; 1 1 0 0; 0 0 1 -1; 0 0 1 1] * ...
             [1 0 -1 0; 0 0 0 0; -1 0 1 0; 0 0 0 0] * ...
             [1 1 0 0; -1 1 0 0; 0 0 1 1; 0 0 -1 1];
Kdiag1 = Kdiag1(:);
Kdiag2 = Kdiag2(:);
for iX = 0: 1: N+M-2
    iZ = 0;
    for iLayer = 1: 1: length(Nlat)
        if iLayer == length(Nlat) && Nlat(iLayer) == 0
            Node1 = (iX+1)*(sum(Nlat)+1);
            Node2 = (iX+2)*(sum(Nlat)+1);
            
            % Left
            ad2Klat(kNZT_K+(1:2),1) = [2*Node1-1;2*Node1];
            ad2Klat(kNZT_K+(1:2),2) = [2*Node1-1;2*Node1];
            if iX == 0
                ad2Klat(kNZT_K+(1:2),3) = real([Kslat(iLayer);Knlat(iLayer)]);
                ad2Klat(kNZT_K+(1:2),4) = imag([Kslat(iLayer);Knlat(iLayer)]);
            else
                ad2Klat(kNZT_K+(1:2),3) = real(0.5*[Kslat(iLayer);Knlat(iLayer)]);
                ad2Klat(kNZT_K+(1:2),4) = imag(0.5*[Kslat(iLayer);Knlat(iLayer)]);
            end
            kNZT_K = kNZT_K + 2;

            % Right
            ad2Klat(kNZT_K+(1:2),1) = [2*Node2-1;2*Node2];
            ad2Klat(kNZT_K+(1:2),2) = [2*Node2-1;2*Node2];
            if iX == N+M-2
                ad2Klat(kNZT_K+(1:2),3) = real([Kslat(iLayer);Knlat(iLayer)]);
                ad2Klat(kNZT_K+(1:2),4) = imag([Kslat(iLayer);Knlat(iLayer)]);
            else
                ad2Klat(kNZT_K+(1:2),3) = real(0.5*[Kslat(iLayer);Knlat(iLayer)]);
                ad2Klat(kNZT_K+(1:2),4) = imag(0.5*[Kslat(iLayer);Knlat(iLayer)]);
            end
            kNZT_K = kNZT_K + 2;
        end
        Kndiag = Kdlat(iLayer);
        for kZ = 1:1:Nlat(iLayer)
            iZ = iZ+1;
            % Masses
            Node1 = iX*(sum(Nlat)+1)+iZ;
            Node2 = Node1 + 1;
            Node3 = Node2 + (sum(Nlat)+1);
            Node4 = Node3 - 1;
            ad2Mlat(kNZT_M+(1:8),1) = [2*[Node1;Node2;Node3;Node4]-1;
                                       2*[Node1;Node2;Node3;Node4]-0];
            ad2Mlat(kNZT_M+(1:8),2) = [2*[Node1;Node2;Node3;Node4]-1;
                                       2*[Node1;Node2;Node3;Node4]-0];
            if iX == 0
                ad2Mlat(kNZT_M+(1:8),3) = 0.25*Mlat(iLayer)*[2;2;1;1;2;2;1;1];
            elseif iX == N+M-2
                ad2Mlat(kNZT_M+(1:8),3) = 0.25*Mlat(iLayer)*[1;1;2;2;1;1;2;2];
            else
                ad2Mlat(kNZT_M+(1:8),3) = 0.25*Mlat(iLayer);
            end
            kNZT_M = kNZT_M + 8;

            % Spring left
            Node1 = iX*(sum(Nlat)+1)+iZ;
            Node2 = Node1 + 1;
            ad2Klat(kNZT_K+(1:4),1) = 2*[Node1;Node1;Node2;Node2];
            ad2Klat(kNZT_K+(1:4),2) = 2*[Node1;Node2;Node1;Node2];
            if iX == 0
                ad2Klat(kNZT_K+(1:4),3) = real(Knlat(iLayer)*[1;-1;-1;1]);
                ad2Klat(kNZT_K+(1:4),4) = imag(Knlat(iLayer)*[1;-1;-1;1]);
            else
                ad2Klat(kNZT_K+(1:4),3) = real(0.5*Knlat(iLayer)*[1;-1;-1;1]);
                ad2Klat(kNZT_K+(1:4),4) = imag(0.5*Knlat(iLayer)*[1;-1;-1;1]);
            end
            kNZT_K = kNZT_K + 4;
            ad2Klat(kNZT_K+(1:4),1) = 2*[Node1;Node1;Node2;Node2]-1;
            ad2Klat(kNZT_K+(1:4),2) = 2*[Node1;Node2;Node1;Node2]-1;
            if iX == 0
                ad2Klat(kNZT_K+(1:4),3) = real(Kslat(iLayer)*[1;-1;-1;1]);
                ad2Klat(kNZT_K+(1:4),4) = imag(Kslat(iLayer)*[1;-1;-1;1]);
            else
                ad2Klat(kNZT_K+(1:4),3) = real(0.5*Kslat(iLayer)*[1;-1;-1;1]);
                ad2Klat(kNZT_K+(1:4),4) = imag(0.5*Kslat(iLayer)*[1;-1;-1;1]);
            end
            kNZT_K = kNZT_K + 4;

            % Spring bottom
            Node1 = Node2;
            Node2 = Node1 + (sum(Nlat)+1);
            ad2Klat(kNZT_K+(1:4),1) = 2*[Node1;Node1;Node2;Node2];
            ad2Klat(kNZT_K+(1:4),2) = 2*[Node1;Node2;Node1;Node2];
            ad2Klat(kNZT_K+(1:4),3) = real(0.5*Kslat(iLayer)*[1;-1;-1;1]);
            ad2Klat(kNZT_K+(1:4),4) = imag(0.5*Kslat(iLayer)*[1;-1;-1;1]);
            kNZT_K = kNZT_K + 4;
            ad2Klat(kNZT_K+(1:4),1) = 2*[Node1;Node1;Node2;Node2]-1;
            ad2Klat(kNZT_K+(1:4),2) = 2*[Node1;Node2;Node1;Node2]-1;
            ad2Klat(kNZT_K+(1:4),3) = real(0.5*Knlat(iLayer)*[1;-1;-1;1]);
            ad2Klat(kNZT_K+(1:4),4) = imag(0.5*Knlat(iLayer)*[1;-1;-1;1]);
            kNZT_K = kNZT_K + 4;

            % Spring right
            Node1 = Node2;
            Node2 = Node1 - 1;
            ad2Klat(kNZT_K+(1:4),1) = 2*[Node1;Node1;Node2;Node2];
            ad2Klat(kNZT_K+(1:4),2) = 2*[Node1;Node2;Node1;Node2];
            if iX == N+M-2
                ad2Klat(kNZT_K+(1:4),3) = real(Knlat(iLayer)*[1;-1;-1;1]);
                ad2Klat(kNZT_K+(1:4),4) = imag(Knlat(iLayer)*[1;-1;-1;1]);
            else
                ad2Klat(kNZT_K+(1:4),3) = real(0.5*Knlat(iLayer)*[1;-1;-1;1]);
                ad2Klat(kNZT_K+(1:4),4) = imag(0.5*Knlat(iLayer)*[1;-1;-1;1]);
            end
            kNZT_K = kNZT_K + 4;
            ad2Klat(kNZT_K+(1:4),1) = 2*[Node1;Node1;Node2;Node2]-1;
            ad2Klat(kNZT_K+(1:4),2) = 2*[Node1;Node2;Node1;Node2]-1;
            if iX == N+M-2
                ad2Klat(kNZT_K+(1:4),3) = real(Kslat(iLayer)*[1;-1;-1;1]);
                ad2Klat(kNZT_K+(1:4),4) = imag(Kslat(iLayer)*[1;-1;-1;1]);
            else
                ad2Klat(kNZT_K+(1:4),3) = real(0.5*Kslat(iLayer)*[1;-1;-1;1]);
                ad2Klat(kNZT_K+(1:4),4) = imag(0.5*Kslat(iLayer)*[1;-1;-1;1]);
            end
            kNZT_K = kNZT_K + 4;

            % Spring up
            Node1 = Node2;
            Node2 = Node1 - (sum(Nlat)+1);
            ad2Klat(kNZT_K+(1:4),1) = 2*[Node1;Node1;Node2;Node2];
            ad2Klat(kNZT_K+(1:4),2) = 2*[Node1;Node2;Node1;Node2];
            ad2Klat(kNZT_K+(1:4),3) = real(0.5*Kslat(iLayer)*[1;-1;-1;1]);
            ad2Klat(kNZT_K+(1:4),4) = imag(0.5*Kslat(iLayer)*[1;-1;-1;1]);
            kNZT_K = kNZT_K + 4;
            ad2Klat(kNZT_K+(1:4),1) = 2*[Node1;Node1;Node2;Node2]-1;
            ad2Klat(kNZT_K+(1:4),2) = 2*[Node1;Node2;Node1;Node2]-1;
            ad2Klat(kNZT_K+(1:4),3) = real(0.5*Knlat(iLayer)*[1;-1;-1;1]);
            ad2Klat(kNZT_K+(1:4),4) = imag(0.5*Knlat(iLayer)*[1;-1;-1;1]);
            kNZT_K = kNZT_K + 4;

            % Spring diag1
            Node1 = Node2;
            Node2 = Node1 + (sum(Nlat)+1) + 1;
            ad2Klat(kNZT_K+(1:16),1) = [2*Node1-1;2*Node1-1;2*Node1-1;2*Node1-1;
                                        2*Node1-0;2*Node1-0;2*Node1-0;2*Node1-0;
                                        2*Node2-1;2*Node2-1;2*Node2-1;2*Node2-1;
                                        2*Node2-0;2*Node2-0;2*Node2-0;2*Node2-0];
            ad2Klat(kNZT_K+(1:16),2) = [2*Node1-1;2*Node1-0;2*Node2-1;2*Node2-0;
                                        2*Node1-1;2*Node1-0;2*Node2-1;2*Node2-0;
                                        2*Node1-1;2*Node1-0;2*Node2-1;2*Node2-0;
                                        2*Node1-1;2*Node1-0;2*Node2-1;2*Node2-0];
            ad2Klat(kNZT_K+(1:16),3) = real(Kndiag)*Kdiag1;
            ad2Klat(kNZT_K+(1:16),4) = imag(Kndiag)*Kdiag1;
            kNZT_K = kNZT_K + 16;

            % Spring diag2
            Node1 = Node1 + 1;
            Node2 = Node1 + (sum(Nlat)+1) - 1;
            ad2Klat(kNZT_K+(1:16),1) = [2*Node1-1;2*Node1-1;2*Node1-1;2*Node1-1;
                                        2*Node1-0;2*Node1-0;2*Node1-0;2*Node1-0;
                                        2*Node2-1;2*Node2-1;2*Node2-1;2*Node2-1;
                                        2*Node2-0;2*Node2-0;2*Node2-0;2*Node2-0];
            ad2Klat(kNZT_K+(1:16),2) = [2*Node1-1;2*Node1-0;2*Node2-1;2*Node2-0;
                                        2*Node1-1;2*Node1-0;2*Node2-1;2*Node2-0;
                                        2*Node1-1;2*Node1-0;2*Node2-1;2*Node2-0;
                                        2*Node1-1;2*Node1-0;2*Node2-1;2*Node2-0];
            ad2Klat(kNZT_K+(1:16),3) = real(Kndiag)*Kdiag2;
            ad2Klat(kNZT_K+(1:16),4) = imag(Kndiag)*Kdiag2;
            kNZT_K = kNZT_K + 16;
        end
    end
end
ad2Klat = ad2Klat(1:kNZT_K,:);
ad2Mlat = ad2Mlat(1:kNZT_M,:);
ai1FreeDofLat = 1:1:2*nNodeLat;
ai1FixedDofLat = [];
if Nlat(end) ~= 0
    ai1FixedDofLat = sort([((2*sum(Nlat)+1):(2*sum(Nlat)+2):(2*nNodeLat))';
                           ((2*sum(Nlat)+2):(2*sum(Nlat)+2):(2*nNodeLat))']);
end
ai1FreeDofLat(ai1FixedDofLat) = [];
% fprintf(1, 'done.\n');
%% Discretize lattice, beams and sleepers
% fprintf(1, 'Assembeling rail and sleepers matrices ... ');
RAIL = 1;
SLEEPER = 0;
RailSleeperDiscrete = 0;
RailSleeper = RAIL;
Rail_dX = D/2;
EPS = 1e-5*D;
while RailSleeperDiscrete(end) < (N-1)*D/2 - EPS
    RailSleeperDiscrete = [RailSleeperDiscrete; RailSleeperDiscrete(end)+Rail_dX];
    RailSleeper = [RailSleeper; RAIL];
end
RailSleeperDiscrete = [RailSleeperDiscrete; RailSleeperDiscrete(end)];
RailSleeper = [RailSleeper; SLEEPER];
while RailSleeperDiscrete(end) < (N+M-1)*D - EPS
    RailSleeperDiscrete = [RailSleeperDiscrete; RailSleeperDiscrete(end)+Rail_dX];
    RailSleeper = [RailSleeper; RAIL];
end
%% Assemble rails and sleepers
nNode = length(RailSleeper);
ad2K = zeros(16*nNode,3); kLastNZT_K = 0;
ad2M = zeros(16*nNode,3); kLastNZT_M = 0;
for iNode = 2: 1: nNode
    if RailSleeper(iNode) == RAIL
        if RailSleeper(iNode-1) == RAIL
            kNode1 = iNode-1;
        else
            kNode1 = iNode-2;
        end
        kNode2 = iNode;
        L = RailSleeperDiscrete(kNode2)-RailSleeperDiscrete(kNode1);
        if abs(L-Rail_dX)<EPS, L = Rail_dX;
        elseif abs(L-D)<EPS, L = D;
        end
        L2 = L*L;
        L3 = L2*L;
        
        ad2Ke =  EI*[ 12/L3  6/L2 -12/L3  6/L2;
                       6/L2   4/L  -6/L2   2/L;
                     -12/L3 -6/L2  12/L3 -6/L2;
                       6/L2   2/L  -6/L2   4/L];
                   
        ad2Me = m*L/420*[  156  22*L    54 -13*L;
                          22*L  4*L2  13*L -3*L2;
                            54  13*L   156 -22*L;
                         -13*L -3*L2 -22*L  4*L2];
    else
        kNode1 = iNode-1;
        kNode2 = iNode;
        ad2Ke = [ Kv   0 -Kv   0;
                   0  Kt   0 -Kt;
                 -Kv   0  Kv   0;
                   0 -Kt   0  Kt];
        ad2Me = [ 0  0  0  0;
                  0  0  0  0;
                  0  0 Ms  0;
                  0  0  0 Js];
    end
    Dofs = [2*kNode1-1; 2*kNode1; 2*kNode2-1; 2*kNode2];
    
    [ROW,COL,VAL] = find(ad2Ke);
    ROW = Dofs(ROW);
    COL = Dofs(COL);
    ad2K(kLastNZT_K+(1:length(ROW)),:) = [ROW COL VAL];
    kLastNZT_K = kLastNZT_K + length(ROW);

    [ROW,COL,VAL] = find(ad2Me);
    ROW = Dofs(ROW);
    COL = Dofs(COL);
    ad2M(kLastNZT_M+(1:length(ROW)),:) = [ROW COL VAL];
    kLastNZT_M = kLastNZT_M + length(ROW);
end
ad2K = ad2K(1:kLastNZT_K,:);
ad2M = ad2M(1:kLastNZT_M,:);
% fprintf(1, 'done.\n');

%% Assemble Rail/sleepers and lattice
ad2Klat(:,1) = ad2Klat(:,1)+2*nNode;
ad2Klat(:,2) = ad2Klat(:,2)+2*nNode;
ad2Klat(:,3) = ad2Klat(:,3)+1i*ad2Klat(:,4);
ad2K = [ad2K; ad2Klat(:,1:3)];
ad2Mlat(:,1) = ad2Mlat(:,1)+2*nNode;
ad2Mlat(:,2) = ad2Mlat(:,2)+2*nNode;
ad2M = [ad2M; ad2Mlat];
ai1FreeDof = [1:1:2*nNode ai1FreeDofLat+2*nNode];
nDofTotal = max(ad2K(:,1));
ai1FixedDof = ones(2*nNode+2*nNodeLat,1);
ai1FixedDof(ai1FreeDof) = 0;
%% Add coupling terms between sleepers and lattice
% fprintf(1, 'Coupling lattice and sleepers ... ');
ad2KPad = zeros(10*N,3); kNZT_K = 0;
xSleep = (N-1)/2*D;
kNodeSleeper = find((abs(RailSleeperDiscrete-xSleep)<EPS).*(RailSleeper==SLEEPER));
% Find lattice nodes
ai1LatticeNodes = find((XZlat(:,1)>=xSleep-2*EPS-(N-1)*D/2) .* (XZlat(:,1)<=xSleep+2*EPS+(N-1)*D/2) .* (XZlat(:,2)==0));
Dx = XZlat(ai1LatticeNodes,1)-xSleep;
for iContact = 1: 1: length(ai1LatticeNodes)
    kNodeLattice = ai1LatticeNodes(iContact)+nNode;
    dx = Dx(iContact);
    kDofL = 2*kNodeLattice;
    kDofLx = 2*kNodeLattice-1;
    kDofU = 2*kNodeSleeper-1;
    kDofR = 2*kNodeSleeper;
    ad2KPad(kNZT_K+(1:10),:) = [[kDofLx;kDofL;kDofL;kDofL;kDofU;kDofU;kDofU;kDofR;kDofR;kDofR],...
                                [kDofLx;kDofL;kDofU;kDofR;kDofL;kDofU;kDofR;kDofL;kDofU;kDofR],...
                                [Kuh;Ku;-Ku;-dx*Ku;-Ku;Ku;dx*Ku;-dx*Ku;dx*Ku;dx^2*Ku]];
    kNZT_K = kNZT_K + 10;
    if real(Kuh) == inf
        ai1FixedDof(kDofLx) = 1;
    end
end
ad2KPad(kNZT_K+1:end,:) = [];
ad2K = [ad2K; ad2KPad];
ad2K = sparse(ad2K(:,1),ad2K(:,2),ad2K(:,3),nDofTotal,nDofTotal);
ad2M = sparse(ad2M(:,1),ad2M(:,2),ad2M(:,3),nDofTotal,nDofTotal);
% fprintf(1, 'done.\n');

%% Loop on Frequencies
ai1L = [1 (1:1:sum(Nlat)+1)+nNode]; ai1L = sort([2*ai1L-1 2*ai1L],'ascend');
ai1R = [nNode nNodeLat-(0:1:sum(Nlat))+nNode]; ai1R = sort([2*ai1R-1 2*ai1R],'ascend');
ai1C = 1:1:2*(nNode+nNodeLat); ai1C([ai1L ai1R]) = [];

ai1FDL = ai1FixedDof(ai1L); ai1FDL = find(ai1FDL==1); ai1L(ai1FDL) = [];
ai1FDR = ai1FixedDof(ai1R); ai1FDR = find(ai1FDR==1); ai1R(ai1FDR) = [];
ai1FDC = ai1FixedDof(ai1C); ai1FDC = find(ai1FDC==1); ai1C(ai1FDC) = [];
Kdiag1 = Kdiag1([1 2 3 4; 5 6 7 8; 9 10 11 12; 13 14 15 16]);
Kdiag2 = Kdiag2([1 2 3 4; 5 6 7 8; 9 10 11 12; 13 14 15 16]);

% fprintf(1, '\n');
% fprintf(1, 'Calculating transmitting boundaries for %d frequencies ...\n', length(W));
% fprintf(1, '[0%%                     50%%                    100%%]\n');
% fprintf(1, '[');
for iFreq = 1: 1: length(W)
%     if mod(iFreq,round(length(W)/50)) == 0
%         fprintf(1, '*');
%     end
    FIRST = 1;
    w = W(iFreq);
    ad2Keq = ad2K-w^2*ad2M;
    if DampType == VISCOUS
        ad2Keq = real(ad2Keq) + 1i*w*imag(ad2Keq);
    else
        ad2Keq = real(ad2Keq) + 1i*sign(w)*imag(ad2Keq);
    end
    % Condense out middle nodes
    K11 = full(ad2Keq([ai1L ai1R],[ai1L ai1R]));
    K12 = ad2Keq([ai1L ai1R],ai1C);
    K22 = ad2Keq(ai1C,ai1C);
    K21 = full(ad2Keq(ai1C, [ai1L ai1R]));
    INV = K22 \ K21;
    ad2Keq = K11 - full(K12 * INV);
    ai1DofLeft = 1:1:length(ai1L);
    ai1DofsMid = ai1DofLeft(end)+(1:1:length([ai1L ai1R]));
    ai1DofsRight = ai1DofsMid(end)+(1:1:length(ai1R));
    ai1DofsSide = [ai1DofLeft ai1DofsRight];
    nTotal = 1;
%     while max(max(abs(ad2Keq(ai1DofLeft,ai1DofLeft(end)+1:end)))) > fTol*max(max(abs(ad2Keq)))
    while (max(max(abs(ad2Keq(ai1DofLeft,ai1DofLeft(end)+1:end)))) > 0) || ...
                (max(max(abs(ad2Keq(ai1DofLeft(end)+1:end,ai1DofLeft)))) > 0)
        ad2Keq = [ad2Keq, zeros(size(ad2Keq));
                  zeros(size(ad2Keq)), ad2Keq];
        % Add coupling terms
        if FIRST
            FIRST = 0;
            if real(Kuh) == inf
                ad2KCouple = zeros(size(ad2Keq)+2);
            else
                ad2KCouple = zeros(size(ad2Keq));
            end
            % Rail piece
            L =  D;
            L2 = L*L;
            L3 = L2*L;

            ad2Kb =  EI*[ 12/L3  6/L2 -12/L3  6/L2;
                           6/L2   4/L  -6/L2   2/L;
                         -12/L3 -6/L2  12/L3 -6/L2;
                           6/L2   2/L  -6/L2   4/L];

            ad2Mb = m*L/420*[  156  22*L    54 -13*L;
                              22*L  4*L2  13*L -3*L2;
                                54  13*L   156 -22*L;
                             -13*L -3*L2 -22*L  4*L2];
            ad2Kb = ad2Kb-w^2*ad2Mb;
            ad2KCouple([end/4+(1:2) end/2+(1:2)],[end/4+(1:2) end/2+(1:2)]) = ad2Kb;
            iZ = 0;
            for iLayer = 1: 1: length(Nlat)
                Kndiag = Kdlat(iLayer);
                for kZ = 1:1:Nlat(iLayer)
                    iZ = iZ + 1;
                    if iZ ~= sum(Nlat) || Nlat(end) == 0
                        % Spring bottom
                        Node1 = size(ad2KCouple,1)/2/4+1+iZ+1;
                        Node2 = size(ad2KCouple,1)/2/2+1+iZ+1;
                        ad2KCouple(2*[Node1;Node2],2*[Node1;Node2]) = ...
                            ad2KCouple(2*[Node1;Node2],2*[Node1;Node2]) + ...
                                                        0.5*Kslat(iLayer)*[1 -1;-1 1];
                        ad2KCouple(2*[Node1;Node2]-1,2*[Node1;Node2]-1) = ...
                            ad2KCouple(2*[Node1;Node2]-1,2*[Node1;Node2]-1) + ...
                                                        0.5*Knlat(iLayer)*[1 -1;-1 1];
                    end
                    % Spring up
                    Node1 = size(ad2KCouple,1)/2/4+1+iZ;
                    Node2 = size(ad2KCouple,1)/2/2+1+iZ;
                    ad2KCouple(2*[Node1;Node2],2*[Node1;Node2]) = ...
                        ad2KCouple(2*[Node1;Node2],2*[Node1;Node2]) + ...
                                                        0.5*Kslat(iLayer)*[1 -1;-1 1];
                    ad2KCouple(2*[Node1;Node2]-1,2*[Node1;Node2]-1) = ...
                        ad2KCouple(2*[Node1;Node2]-1,2*[Node1;Node2]-1) + ...
                                                        0.5*Knlat(iLayer)*[1 -1;-1 1];

                    % Spring diag1
                    Node1 = size(ad2KCouple,1)/2/4+1+iZ;
                    if iZ ~= sum(Nlat) || Nlat(end) == 0
                        Node2 = size(ad2KCouple,1)/2/2+1+iZ+1;
                        Dofs = [2*Node1+(-1:0) 2*Node2+(-1:0)];
                        ad2KCouple(Dofs,Dofs) = ad2KCouple(Dofs,Dofs) + Kndiag*Kdiag1;
                    else
                        Dofs = 2*Node1+(-1:0);
                        ad2KCouple(Dofs,Dofs) = ad2KCouple(Dofs,Dofs) + Kndiag*Kdiag1(1:2,1:2);
                    end

                    % Spring diag2
                    Node1 = size(ad2KCouple,1)/2/4+1+iZ+1;
                    Node2 = size(ad2KCouple,1)/2/2+1+iZ;
                    if iZ ~= sum(Nlat) || Nlat(end) == 0
                        Dofs = [2*Node1+(-1:0) 2*Node2+(-1:0)];
                        ad2KCouple(Dofs,Dofs) = ad2KCouple(Dofs,Dofs) + Kndiag*Kdiag2;
                    else
                        Dofs = 2*Node2+(-1:0);
                        ad2KCouple(Dofs,Dofs) = ad2KCouple(Dofs,Dofs) + Kndiag*Kdiag2(3:4,3:4);
                    end
                end
            end
            if DampType == VISCOUS
                ad2KCouple = real(ad2KCouple) + 1i*w*imag(ad2KCouple);
            else
                ad2KCouple = real(ad2KCouple) + 1i*sign(w)*imag(ad2KCouple);
            end
            if real(Kuh) == inf
                Dofs = 1:1:size(ad2KCouple,1);
                Dofs([3 end/2+3]) = [];
                ad2KCouple = ad2KCouple(Dofs,Dofs);
            end
        end
        ad2Keq = ad2Keq+ad2KCouple;
        ad2Keq = ad2Keq(ai1DofsSide,ai1DofsSide) - ...
            ad2Keq(ai1DofsSide,ai1DofsMid) * ...
                (ad2Keq(ai1DofsMid,ai1DofsMid) \ ...
                    ad2Keq(ai1DofsMid,ai1DofsSide));
        nTotal = nTotal * 2;
    end
    if real(Kuh) == inf
        ad2Keq = [ad2Keq(1:2,1:2), zeros(2,1), ad2Keq(1:2,3:end);
                  zeros(1, size(ad2Keq,2)+1);
                  ad2Keq(3:end,1:2), zeros(size(ad2Keq,1)-2,1), ad2Keq(3:end,3:end)];
        ad2Keq(3,3) = inf;
    end
    OUTPUT(iFreq).nTotal = nTotal;
    OUTPUT(iFreq).KRight = ad2Keq(end/2+1:end,end/2+1:end);
    OUTPUT(iFreq).KLeft = ad2Keq(1:end/2,1:end/2);
    OUTPUT(iFreq).ad2KCouple = sparse(ad2KCouple(end/4+1:3*end/4,end/4+1:3*end/4));
end
% fprintf(1, ']\n');

end