clc; clear; close all
LEFT = 1; RIGHT = 2; LEFT_RIGHT = 3;
%% Material properties
Damp = 0.001;
VISCOUS = 1;
HYSTERETIC = 0;
DampType = VISCOUS;
% Rail
EI = 2*6.044e6;
m = 2*60;
DampEI = 0.0001;
% Sleepers
Width = 0.3;
Spacing = 0.6;
Ms = 315;
Js = Ms/6*Width^2;
% Sleeper pads
Kv = 100e6;
Kt = Kv*Width^2/4;
% Under sleeper pads
Ku = 45e9;
Kuh = inf; Kuh = Ku*1e2*0;
% Ballast - stiffness properties for half track (1m cross section)
Hlat = 0.3;
Dlat = 0.03;
Rho = 1800;
Knlat = 1.4222e+07;
Kslat = 1.7778e+06;
Kdlat = 6.2222e+06;
Mlat = Rho*Dlat^2;

%% Calculate geometrical quantities
Nlat = round(Hlat/Dlat);
Hlat = Dlat*Nlat;
N = round(Width/Dlat)+1;
M = round(Spacing/Dlat); M = M - N;
Width = (N-1)*Dlat;
Spacing = (M+N)*Dlat;
% Under-sleeper pads divided by each grain of ballast
Ku  = Ku/N;
Kuh = Kuh/N;
%% Frequency of interest, loading locations and output locations
% Damped constants
if (DampType == VISCOUS)
    EI = EI*(1+1i*DampEI);
    Kv = Kv*(1+1i*Damp);
    Kt = Kt*(1+1i*Damp);
    Ku = Ku*(1+1i*Damp);
    Kuh = Kuh*(1+1i*Damp);
    Knlat = Knlat*(1+1i*Damp);
    Kslat = Kslat*(1+1i*Damp);
else
    EI = EI*(1+2i*DampEI);
    Kv = Kv*(1+2i*Damp);
    Kt = Kt*(1+2i*Damp);
    Ku = Ku*(1+2i*Damp);
    Kuh = Kuh*(1+2i*Damp);
    Knlat = Knlat*(1+2i*Damp);
    Kslat = Kslat*(1+2i*Damp);
end
%% Calculate transmitting boundary
start = clock;
if DampType == VISCOUS
    DF = 1;
else
    DF = 2;
end
dt = 1e-3;
Tmax = 1;
V = 60;
[T, Uleft,  Uright] = IncidentDisplacements(EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,DampType,dt,Tmax,V);
for iComp = 1:1:size(Uleft,1)
    subplot(1,2,1);
    plot(T,Uleft(iComp,:),'.-b');
    hold on; plot((-(N-1)/2-1)*Dlat/V*[1 1], [min(Uleft(iComp,:)) max(Uleft(iComp,:))], 'r'); hold off
    xlim([-0.1 0.1]);
    title(['a_' num2str(iComp)]);
    subplot(1,2,2);
    plot(T,Uright(iComp,:),'.-b');
    hold on; plot(-(N-1)/2*Dlat/V*[1 1], [min(Uright(iComp,:)) max(Uright(iComp,:))], 'r'); hold off
    xlim([-0.1 0.1]);
    title(['a_' num2str(iComp)]);
    pause
end