function OUTPUT = ML_TD(EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Nlat,N,M,dt,Tmax,V,nCell,Xout)
PLOT = 0;
OUTPUT = [];
if size(Mlat,2) == 1
    Mlat = [Mlat Mlat];
    Knlat = [Knlat Knlat];
    Kslat = [Kslat Kslat];
    Nlat = [Nlat Nlat];
end
nCell = nCell + 1 - mod(nCell,2);
%% Assemble stiffness matrices
nNodePerColLat = sum(Nlat(:,1)) + 1;
nNodePerCell = nNodePerColLat*(N+M) + 2*(N+M);
nNodeTotal = nNodePerCell * nCell * size(Mlat,2);
NODE_TYPE = zeros(nNodeTotal,5); % [TYPE X Y Mass J]
RAIL = 1; SLEEPER = 2; BALLAST = 3;
BLOCK_SIZE = 100000;
ad2Connection = zeros(BLOCK_SIZE, 8); % [RAIL Node1 Node2 EI m] or [SPRING Node1 Node2 Dofs1 Dofs2 K]
kCon = 0;
BEAM = 1;
SPRING = 2;
kCell = 0;
nTotalCell = nCell;
fprintf(1, '\n');
fprintf(1, 'Assembling element matrices for %d cells...\n', nTotalCell);
fprintf(1, '[0%%                                            100%%]\n');
fprintf(1, '[');
STARS = zeros(50,1); star = 0;
mlat =  Mlat;
knlat = Knlat;
kslat = Kslat;
kdlat = (knlat-kslat)/2;
for jCell = 1: 1: nCell
    if mod(kCell+1,round(nTotalCell/50))==0
        star = star + 1;
        if star <= 50 && STARS(star) == 0
            fprintf(1, '*');
            STARS(star) = 1;
        end
    end
    kNode_RR = kCell*nNodePerCell + 1;
    % Column by column assemble the elements
    SurfaceNodes = zeros(1,N+M);
    for iN = 0: 1: N+M-2
        if kCon + 25*sum(Nlat(:,1)) > size(ad2Connection,1)
            ad2Connection = [ad2Connection; zeros(BLOCK_SIZE,size(ad2Connection,2))];
        end
        %% Define rail nodes, ballast nodes and sleeper node
        kNode_RS = [];
        kNode_RL = kNode_RR;
        kNode_RM = kNode_RL + nNodePerColLat + 1;
        kNode_RR = kNode_RM + 1;
        kNode_BL = kNode_RL + 1;
        kNode_BR = kNode_RR + 1;
        if mod(N,2)==1 && iN == (N-1)/2
            kNode_RS = kNode_RL;
            kNode_S = kNode_RL + 1;
            kNode_RM = kNode_RM + 1;
            kNode_RR = kNode_RR + 1;
            kNode_BL = kNode_BL + 1;
            kNode_BR = kNode_BR + 1;
        elseif mod(N,2)==1 && iN == (N-1)/2-1
            kNode_BR = kNode_BR + 1;
        elseif mod(N,2)==0 && iN == N/2-1
            kNode_RS = kNode_RM;
            kNode_S = kNode_RM + 1;
            kNode_RR = kNode_RR + 1;
            kNode_BR = kNode_BR + 1;
        end
        if iN == 0
            kNode_RLS = kNode_RL;
            kNode_BLS = kNode_BL;
        end
        SurfaceNodes(iN+1) = kNode_BL;
        if iN == N+M-2, SurfaceNodes(iN+2) = kNode_BR; end
        NODE_TYPE([kNode_RL kNode_RM kNode_RR],1) = RAIL;
        NODE_TYPE([kNode_RL kNode_RM kNode_RR],2) = (kCell*(N+M)+iN-1+(1:0.5:2))*D;
        NODE_TYPE([kNode_RL kNode_RM kNode_RR],3) = N*D;
        NODE_TYPE([kNode_BL:(kNode_RM-1) kNode_BR:(kNode_BR+nNodePerColLat-1)],1) = BALLAST;
        NODE_TYPE(kNode_BL:(kNode_RM-1),2) = (kCell*(N+M)+iN)*D;
        NODE_TYPE(kNode_BL:(kNode_RM-1),3) = -(0:1:(nNodePerColLat-1))*D;
        NODE_TYPE(kNode_BR:(kNode_BR+nNodePerColLat-1),2) = (kCell*(N+M)+iN+1)*D;
        NODE_TYPE(kNode_BR:(kNode_BR+nNodePerColLat-1),3) = -(0:1:(nNodePerColLat-1))*D;
        if ~isempty(kNode_RS)
            NODE_TYPE(kNode_S,1) = SLEEPER;
            NODE_TYPE(kNode_S,2) = NODE_TYPE(kNode_RS,2);
            NODE_TYPE(kNode_S,3) = N*D/2;
            NODE_TYPE(kNode_S,4) = Ms;
            NODE_TYPE(kNode_S,5) = Js;
            if jCell == (nCell+1) / 2
                kNodeCentral = kNode_RS;
            end
        end

        %% Assemble rails
        kCon = kCon + 1; ad2Connection(kCon,1:5) = [BEAM kNode_RL kNode_RM EI m];
        kCon = kCon + 1; ad2Connection(kCon,1:5) = [BEAM kNode_RM kNode_RR EI m];

        %% Assemble rail pads
        if ~isempty(kNode_RS)
            kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_RS kNode_S [1 0 -1  0] Kv];
            kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_RS kNode_S [0 1  0 -1] Kt];
        end

        %% Assemble ballast springs
        kDepth = 0;
        for iLayer = 1: 1: size(Nlat,1)
        for iDiv = 1: 1: Nlat(iLayer,1)
            % Add mass to the nodes
            NODE_TYPE([kNode_BL+kDepth+(0:1) kNode_BR+kDepth+(0:1)],4) = ...
                NODE_TYPE([kNode_BL+kDepth+(0:1) kNode_BR+kDepth+(0:1)],4) + 0.25*mlat(iLayer);
            if iN == 0
                NODE_TYPE(kNode_BL+kDepth+(0:1),4) = ...
                    NODE_TYPE(kNode_BL+kDepth+(0:1),4) + 0.25*mlat(iLayer);
            elseif iN == N+M-2
                NODE_TYPE(kNode_BR+kDepth+(0:1),4) = ...
                    NODE_TYPE(kNode_BR+kDepth+(0:1),4) + 0.25*mlat(iLayer);
            end
            % Add springs Left
            if iN == 0
                kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth+(0:1) [0 1 0 -1] knlat(iLayer)];
                kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth+(0:1) [1 0 -1 0] kslat(iLayer)];
            else
                kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth+(0:1) [0 1 0 -1] 0.5*knlat(iLayer)];
                kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth+(0:1) [1 0 -1 0] 0.5*kslat(iLayer)];
            end
            % Add springs right
            if iN == N+M-2
                kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR+kDepth+(0:1) [0 1 0 -1] knlat(iLayer)];
                kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR+kDepth+(0:1) [1 0 -1 0] kslat(iLayer)];
            else
                kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR+kDepth+(0:1) [0 1 0 -1] 0.5*knlat(iLayer)];
                kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR+kDepth+(0:1) [1 0 -1 0] 0.5*kslat(iLayer)];
            end
            % Add top and bottom springs
            kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth kNode_BR+kDepth [1 0 -1 0] 0.5*knlat(iLayer)];
            kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth kNode_BR+kDepth [0 1 0 -1] 0.5*kslat(iLayer)];
            kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth+1 kNode_BR+kDepth+1 [1 0 -1 0] 0.5*knlat(iLayer)];
            kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth+1 kNode_BR+kDepth+1 [0 1 0 -1] 0.5*kslat(iLayer)];
            % Add diagonal springs
            kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth kNode_BR+kDepth+1 sqrt(2)/2*[-1 1 1 -1] kdlat(iLayer)];
            kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth+1 kNode_BR+kDepth sqrt(2)/2*[-1 -1 1 1] kdlat(iLayer)];
            kDepth = kDepth + 1;
        end
        if Nlat(iLayer,1) == 0
            % Add top and bottom springs
            kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth -1 [0 1 0 0] 0.5*knlat(iLayer)];
            kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth -1 [1 0 0 0] 0.5*kslat(iLayer)];
            kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR+kDepth -1 [0 1 0 0] 0.5*knlat(iLayer)];
            kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR+kDepth -1 [1 0 0 0] 0.5*kslat(iLayer)];
            if iN == 0
                kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth -1 [0 1 0 0] 0.5*knlat(iLayer)];
                kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BL+kDepth -1 [1 0 0 0] 0.5*kslat(iLayer)];
            elseif iN == N+M-2
                kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR+kDepth -1 [0 1 0 0] 0.5*knlat(iLayer)];
                kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR+kDepth -1 [1 0 0 0] 0.5*kslat(iLayer)];
            end
        end
        end
    end
    % Add springs between sleeper and ballast
    SurfaceNodes = SurfaceNodes(1:N);
    for iNode = 1: 1: N
        kNode = SurfaceNodes(iNode);
        % Vertical connection
        dist = (-(N-1)/2+iNode-1)*D;
        kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode kNode_S [0 -1 1 dist] Ku];
        % Horizontal connection
        kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode -1 [1 0 0 0] Kuh];
    end
    kCell = kCell + 1;
    if jCell == 1
        % save this
        kNode_BR_Prev = kNode_BR;
        kNode_RR_Prev = kNode_RR;
        continue;
    end
    % Assemble connection with Previous cell
    kCon = kCon + 1; ad2Connection(kCon,1:5) = [BEAM kNode_RR_Prev kNode_RLS EI m];
    kDepth = 0;
    for iLayer = 1: 1: size(Nlat,1)
    for iDiv = 1: 1: Nlat(iLayer,1)
        % Add top and bottom springs
        kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR_Prev+kDepth kNode_BLS+kDepth [1 0 -1 0] 0.5*knlat(iLayer)];
        kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR_Prev+kDepth kNode_BLS+kDepth [0 1 0 -1] 0.5*kslat(iLayer)];
        kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR_Prev+kDepth+1 kNode_BLS+kDepth+1 [1 0 -1 0] 0.5*knlat(iLayer)];
        kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR_Prev+kDepth+1 kNode_BLS+kDepth+1 [0 1 0 -1] 0.5*kslat(iLayer)];
        % Add diagonal springs
        kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR_Prev+kDepth kNode_BLS+kDepth+1 sqrt(2)/2*[-1 1 1 -1] kdlat(iLayer)];
        kCon = kCon + 1; ad2Connection(kCon,1:8) = [SPRING kNode_BR_Prev+kDepth+1 kNode_BLS+kDepth sqrt(2)/2*[-1 -1 1 1] kdlat(iLayer)];
        kDepth = kDepth + 1;
    end
    end
    kNode_BR_Prev = kNode_BR;
    kNode_RR_Prev = kNode_RR;
end
%% Split the rail connections which are longer than D/2 into two,
%  for coherence purposes
nCon = kCon;
for iCon = 1: 1: nCon
    if ad2Connection(iCon,1) ~= BEAM, continue; end
    Node1 = ad2Connection(iCon,2);
    Node2 = ad2Connection(iCon,3);
    dX = NODE_TYPE(Node2,2) - NODE_TYPE(Node1,2);
    if abs(dX) < D/2*(1+1e-5), continue; end
    NODE_TYPE = [NODE_TYPE(1:Node2-1,:); (NODE_TYPE(Node2,:)+NODE_TYPE(Node1,:))/2; NODE_TYPE(Node2:end,:)];
    Node3 = Node2;
    ad2Connection(ad2Connection(:,2)>=Node3,2) = ad2Connection(ad2Connection(:,2)>=Node3,2) + 1;
    ad2Connection(ad2Connection(:,3)>=Node3,3) = ad2Connection(ad2Connection(:,3)>=Node3,3) + 1;
    if kNodeCentral >= Node3, kNodeCentral = kNodeCentral + 1; end
    kCon = kCon + 1;  ad2Connection(kCon,1:5) = [BEAM Node3 Node3+1 EI m];
    ad2Connection(iCon,3) = Node3;
end
%% Shift the x coordinate so that first cell of right side is 0 at the
%  sleeper position
Xcenter = NODE_TYPE(kNodeCentral,2);
NODE_TYPE(:,2) = NODE_TYPE(:,2) - Xcenter;
for iStar = star+1:1:50
    fprintf(1, '*');
end
fprintf(1, ']\n');
%% Make sure that there is one node at each loaded position (moving load)
fprintf(1, '\n');
fprintf(1, 'Adjunting rail discretization to time steps...\n');
fprintf(1, '[0%%                                            100%%]\n');
fprintf(1, '[');
STARS = zeros(50,1); star = 0;
RAIL_NODES = find(NODE_TYPE(:,1) == RAIL);
X_Rail = NODE_TYPE(RAIL_NODES,2);
xMin = min(X_Rail);
xMax = max(X_Rail);
T = -Tmax:dt:Tmax;
X = V*T;
for iX = 1: 1: length(X)
    if mod(iX+1,round(length(X)/50))==0
        star = star + 1;
        if star <= 50 && STARS(star) == 0
            fprintf(1, '*');
            STARS(star) = 1;
        end
    end
    x = X(iX);
    if x<= xMin || x >= xMax, continue; end
    % Add node
    kNodeLeft = find((NODE_TYPE(:,1)==RAIL).*(NODE_TYPE(:,2)<=x));
    kNodeLeft = kNodeLeft(end);
    if abs(x-NODE_TYPE(kNodeLeft,2)) < V*dt/1000, continue; end
    kNodeRight = find((NODE_TYPE(:,1)==RAIL).*(NODE_TYPE(:,2)>x));
    kNodeRight = kNodeRight(1);
    if abs(x-NODE_TYPE(kNodeRight,2)) < V*dt/1000, continue; end
    
    % Find the element with these nodes
    jCon = find((ad2Connection(:,1)==BEAM).*...
                (ad2Connection(:,2)==kNodeLeft).*...
                (ad2Connection(:,3)==kNodeRight));
    if isempty(jCon), continue; end
    
    % Add node and dhift all nodes by greater than NodeRight by 1
    NODE_TYPE = [NODE_TYPE(1:kNodeRight-1,:);
                 RAIL x NODE_TYPE(kNodeLeft,3:end);
                 NODE_TYPE(kNodeRight:end,:)];
    ad2Connection(ad2Connection(:,2)>=kNodeRight,2) = ad2Connection(ad2Connection(:,2)>=kNodeRight,2) + 1;
    ad2Connection(ad2Connection(:,3)>=kNodeRight,3) = ad2Connection(ad2Connection(:,3)>=kNodeRight,3) + 1;
    
    % Add new connection
    ad2Connection(jCon,3) = kNodeRight;
    kCon = kCon + 1;  ad2Connection(kCon,1:5) = [BEAM kNodeRight kNodeRight+1 EI m];
end
for iStar = star+1:1:50
    fprintf(1, '*');
end
fprintf(1, ']\n');
ad2Connection = ad2Connection(1:kCon,:);

%% Plot modeled section
if PLOT
    figure; hold on
    plot(NODE_TYPE(NODE_TYPE(:,1)==BALLAST,2),NODE_TYPE(NODE_TYPE(:,1)==BALLAST,3),'ob');
    plot(NODE_TYPE(NODE_TYPE(:,1)==SLEEPER,2),NODE_TYPE(NODE_TYPE(:,1)==SLEEPER,3),'or');
    plot(NODE_TYPE(NODE_TYPE(:,1)==RAIL,2),NODE_TYPE(NODE_TYPE(:,1)==RAIL,3),'ok');
    for iCon = 1: 1: size(ad2Connection,1)
        Nodes = ad2Connection(iCon,2:3);
        if Nodes(1) == -1, Nodes(1) = [];
        elseif Nodes(2) == -1, Nodes(2) = []; end
        if length(Nodes) == 1
            COLOR = 'vk';
        elseif ad2Connection(iCon,1) == SPRING
            COLOR = '.-g';
        elseif ad2Connection(iCon,1) == BEAM
            COLOR = '.-r';
        end
        plot(NODE_TYPE(Nodes,2),NODE_TYPE(Nodes,3),COLOR);
    end
    axis equal
end
%% Assemble stuctural elements
nNode = size(NODE_TYPE,1);
nElem = size(ad2Connection,1);
nDof = 2*nNode;
ad2M = zeros(16*nElem,3); NZT_M = 0;
ad2K = zeros(16*nElem,3); NZT_K = 0;
ad2C = zeros(16*nElem,3); NZT_C = 0;
% Assemble lumped masses
for iNode = 1:1:nNode
    if NODE_TYPE(iNode,1) == RAIL, continue; end
    if NODE_TYPE(iNode,1) == SLEEPER
        ad2M(NZT_M+(1:2),:) = [NODE_TYPE(iNode,4) 2*iNode-1 2*iNode-1;
                               NODE_TYPE(iNode,5) 2*iNode-0 2*iNode-0];
        NZT_M = NZT_M + 2;
    end
    if NODE_TYPE(iNode,1) == BALLAST
        ad2M(NZT_M+(1:2),:) = [NODE_TYPE(iNode,4) 2*iNode-1 2*iNode-1;
                               NODE_TYPE(iNode,4) 2*iNode-0 2*iNode-0];
        NZT_M = NZT_M + 2;
    end
end
% Assemble elastic elements - springs and beams
for iElem = 1: 1: nElem
    kNode1 = ad2Connection(iElem,2);
    kNode2 = ad2Connection(iElem,3);
    ROW = [2*kNode1-1; 2*kNode1; 2*kNode2-1; 2*kNode2;
           2*kNode1-1; 2*kNode1; 2*kNode2-1; 2*kNode2;
           2*kNode1-1; 2*kNode1; 2*kNode2-1; 2*kNode2;
           2*kNode1-1; 2*kNode1; 2*kNode2-1; 2*kNode2];
    COL = [2*kNode1-1; 2*kNode1-1; 2*kNode1-1; 2*kNode1-1 ;
           2*kNode1  ; 2*kNode1  ; 2*kNode1  ; 2*kNode1   ;
           2*kNode2-1; 2*kNode2-1; 2*kNode2-1; 2*kNode2-1 ;
           2*kNode2  ; 2*kNode2  ; 2*kNode2  ; 2*kNode2  ];
    if ad2Connection(iElem,1) == BEAM
        EI = ad2Connection(iElem,4);
        m = real(ad2Connection(iElem,5));
        l = NODE_TYPE(kNode2,2)-NODE_TYPE(kNode1,2);
        l2 = l*l;
        l3 = l2*l;
        
        Kelem = EI*[ 12/l3  6/l2  -12/l3  6/l2 ;
                      6/l2   4/l   -6/l2   2/l ;
                    -12/l3 -6/l2   12/l3 -6/l2 ;
                      6/l2   2/l   -6/l2   4/l ];
                  
        Melem = m*l/420*[  156  22*l    54 -13*l ;
                          22*l  4*l2  13*l -3*l2 ;
                            54  13*l   156 -22*l ;
                         -13*l -3*l2 -22*l  4*l2];
        ad2K(NZT_K+(1:16),:) = [real(Kelem(:)) ROW COL]; NZT_K = NZT_K + 16;
        ad2C(NZT_C+(1:16),:) = [imag(Kelem(:)) ROW COL]; NZT_C = NZT_C + 16;
        ad2M(NZT_M+(1:16),:) = [Melem(:) ROW COL]; NZT_M = NZT_M + 16;
    elseif ad2Connection(iElem,1) == SPRING
        K = ad2Connection(iElem,end);
        dofs = ad2Connection(iElem,end-4:end-1);
        if kNode1 == -1
            dofs = dofs(3:4);
            ROW = [2*kNode2-1; 2*kNode2;
                   2*kNode2-1; 2*kNode2];
            COL = [2*kNode2-1; 2*kNode2-1;
                   2*kNode2  ; 2*kNode2 ];
        elseif kNode2 == -1
            dofs = dofs(1:2);
            ROW = [2*kNode1-1; 2*kNode1;
                   2*kNode1-1; 2*kNode1];
            COL = [2*kNode1-1; 2*kNode1-1;
                   2*kNode1  ; 2*kNode1 ];
        end
        NZT = length(dofs)^2;
        Kelem = K*(dofs'*dofs);
        ad2K(NZT_K+(1:NZT),:) = [real(Kelem(:)) ROW COL]; NZT_K = NZT_K + NZT;
        ad2C(NZT_C+(1:NZT),:) = [imag(Kelem(:)) ROW COL]; NZT_C = NZT_C + NZT;
    end
end
ad2K = ad2K(1:NZT_K,:); ad2K = sparse(ad2K(:,2),ad2K(:,3),ad2K(:,1),nDof,nDof);
ad2C = ad2C(1:NZT_C,:); ad2C = sparse(ad2C(:,2),ad2C(:,3),ad2C(:,1),nDof,nDof);
ad2M = ad2M(1:NZT_M,:); ad2M = sparse(ad2M(:,2),ad2M(:,3),ad2M(:,1),nDof,nDof);
% Free dofs - remove last row of ballast nodes if bottom of lattice is
% fixed
ai1FreeDof = 1:1:nDof;
ai1FixedDof = [];
if Nlat(end,1) ~= 0
    ai1FixedNode = find((NODE_TYPE(:,1)==BALLAST).*(NODE_TYPE(:,3)==min(NODE_TYPE(:,3))));
    ai1FixedDof = [ai1FixedNode*2-1; ai1FixedNode*2];
    ai1FixedDof = sort(ai1FixedDof(:),'ascend');
end
% Left boundary
Nodes_Left = find(NODE_TYPE(:,2)==min(NODE_TYPE(:,2)));
ai1FixedDof = [ai1FixedDof; 2*Nodes_Left(:)-1; 2*Nodes_Left(:)];
% Right boundary
Nodes_Right = find(NODE_TYPE(:,2)==max(NODE_TYPE(:,2)));
ai1FixedDof = [ai1FixedDof; 2*Nodes_Right(:)-1; 2*Nodes_Right(:)];
ai1FixedDof = unique(ai1FixedDof);
ai1FixedDof = sort(ai1FixedDof(:),'ascend');
if PLOT
    ai1FixedNode = ai1FixedDof(2:2:end)/2;
    plot(NODE_TYPE(ai1FixedNode,2),NODE_TYPE(ai1FixedNode,3),'*m');
end
ai1FreeDof(ai1FixedDof) = [];

%% Newmark look
gamma = 0.5;
beta  = 0.25;
a0 = 1/(beta*dt^2);
a1 = gamma/(beta*dt);
a2 = 1/(beta*dt);
a3 = 1/(2*beta)-1;
a4 = gamma/beta-1;
a5 = dt*(gamma/(2*beta)-1);

% Time sample
kT = 0;
T = -Tmax:dt:Tmax;
nT = length(T);
fprintf(1, '\n');
fprintf(1, 'Newmark loop on time steps (%d time intervals)\n', nT);
fprintf(1, '[0%%                                            100%%]\n');
fprintf(1, '[');
STARS = zeros(50,1); star = 0;

% Outputs
NodeOutput = zeros(length(Xout),1);
RAIL_NODES = find(NODE_TYPE == RAIL);
for iOut = 1: 1: length(Xout)
    [MIN,NODE] = min(abs(NODE_TYPE(RAIL_NODES,2)-Xout(iOut)));
    NodeOutput(iOut) = RAIL_NODES(NODE);
end
Uout  = zeros(length(Xout),length(T));

for t = T(1):dt:T(end)
    if mod(kT+1,round(nT/50))==0
        star = star + 1;
        if star <= 50 && STARS(star) == 0
            fprintf(1, '*');
            STARS(star) = 1;
        end
    end
    %% Calculate system matrices
    if kT == 0
        ad2Keq = ad2K + a1*ad2C + a0*ad2M;

        % Factoeize Keq
        ad2L = chol(ad2Keq(ai1FreeDof,ai1FreeDof), 'lower');
        ad2U = ad2L';
        % Previous interation valuess
        up = zeros(nDof,1);
        vp = zeros(nDof,1);
        ap = zeros(nDof,1);
    end
    kT = kT + 1;
    %% Calculate external force
    Fext = zeros(nDof,1);
    x = V*t;
    if x >= min(NODE_TYPE(:,2)) && x < max(NODE_TYPE(:,2))
        kNode1 = find((NODE_TYPE(:,1)==RAIL) .* (NODE_TYPE(:,2)<=x)); kNode1 = kNode1(end);
        kNode2 = find((NODE_TYPE(:,1)==RAIL) .* (NODE_TYPE(:,2)>x)); kNode2 = kNode2(1);
        x1 = NODE_TYPE(kNode1,2); x2 = NODE_TYPE(kNode2,2);
        l = x2-x1;
        Fact = (x-x1)/l;
        N1 = 1 -            3*Fact^2 + 2*Fact^3;
        N2 =     l*Fact - 2*l*Fact^2 + l*Fact^3;
        N3 =                3*Fact^2 - 2*Fact^3;
        N4 =               -l*Fact^2 + l*Fact^3;
        Fext(2*kNode1-1,1) = N1;
        Fext(2*kNode1,1) = N2;
        Fext(2*kNode2-1,1) = N3;
        Fext(2*kNode2,1) = N4;
    end
    %% Add terms due to previous state
    Fext = Fext + ad2M*(a0*up+a2*vp+a3*ap) + ad2C*(a1*up+a4*vp+a5*ap);
    %% Calculate new dispalcements, velocities and accelerations
    uc = zeros(nDof,1);
    un = ad2U\(ad2L\Fext(ai1FreeDof,:));
    uc(ai1FreeDof,:) = un;
    vc = a1*(uc-up) - a4*vp - a5*ap;
    ac = a0*(uc-up) - a2*vp - a3*ap;
    
    %% store old values
    up = uc;
    vp = vc;
    ap = ac;
    Uout(:,kT) = uc(2*NodeOutput-1,1);
end
for iStar = star+1:1:50
    fprintf(1, '*');
end
fprintf(1, ']\n');
%% Remove fixed dofs from IR_L and IR_R
OUTPUT.Uout = Uout;
OUTPUT.Xout = Xout;
OUTPUT.T = T;
end
