function [T, Uleft,  Uright] = IncidentDisplacements(EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Kdlat,Nlat,N,M,DampType,dt,Tmax,V,Filename,W,INPUT_Freq)
if nargin < 21, Filename = []; end
if nargin < 22, W = []; end
if nargin < 23, INPUT_Freq = []; end

if isempty(W)
    dW = 2*pi/10/Tmax;
    Wf = 2*pi/dt;
    W = 0:dW:Wf;
end
DO = 1;
if ~isempty(Filename)
    try
        load(Filename);
        VALID = CheckInputs(sInputFile,...
            EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Kdlat,Nlat,N,M,DampType,dt,Tmax,V,W);
        if VALID, DO = 0; end
        Uleft = Uleft(:,find((T<=Tmax).*(T>=-Tmax)));
        Uright = Uright(:,find((T<=Tmax).*(T>=-Tmax)));
        T = T(find((T<=Tmax).*(T>=-Tmax)));
    catch
        DO = 1;
    end
end
if ~DO, return; end
VISCOUS = 1;
HYSTERETIC = 0;

T = -Tmax:dt:Tmax;
fprintf(1, '\n');
fprintf(1, 'Calculating incident displacements due to moding load ...\n');
fprintf(1, 'Solving for %d frequencies between %f and %f ...\n', length(W), W(1)/2/pi, W(end)/2/pi);
fprintf(1, '[0%%     20%%       40%%       60%%       80%%      100%%]\n');
fprintf(1, '[');
STARS = zeros(50,1); star = 0;
for iW = 1: 1: length(W)
    if mod(iW,round(length(W)/50))==0
        star = star + 1;
        if star <= 50 && STARS(star) == 0
            fprintf(1, '*');
            STARS(star) = 1;
        end
    end
    w = W(iW);
    wo = w;
    if w == 0, w = W(2)/100; end
%% Part 1 - calculate interaction forces in the frequency domain
    [ForcesP, ForcesM, UP, UM, UlatP, UlatM] = CalculateFrequencyDomainForces(...
            EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Nlat,N,M,V,0,w,DampType);
    if Nlat(end) ~= 0
        UlatP = UlatP(1:end-2,:);
    end
%% Part 2 - calculate displacements in the frequency domain of rail
%           and lattice for positions at interfaces and adjacent ones
    % Lattice
    I_out = [-1 0];
    Ulat = zeros(size(UlatP,1),length(I_out));
    for iM = 0: 1: N+M-1
        km = w/V + 2*pi*iM/(N+M)/D;
        for iOut = 1: 1: length(I_out)
            Ulat(:,iOut) = Ulat(:,iOut) + UlatP(:,iM+1) * exp(-1i*km*D*I_out(iOut));
        end
    end

    % Rail
    EPS = 1e-5*0;
    ForceRP = ForcesP([N+1 N+2]);
    Xout = [(-(N-1)/2-1+EPS)*D (-(N-1)/2-EPS)*D];
    Urail = zeros(2,length(Xout));
    Srail = zeros(2,length(Xout));
    if DampType == VISCOUS
        EIr = real(EI) + 1i*w*imag(EI);
    else
        EIr = real(EI) + 1i*imag(EI);
    end
    km = w/V;
    kr = (w^2*m/EIr)^.25;
    for iOut = 1: 1: length(Xout)
        [c1,d1] = CalcCD(1i*kr,km,-Xout(iOut),(N+M)*D);
        [c2,d2] = CalcCD(kr,km,-Xout(iOut),(N+M)*D);
        % Contribution of moving load
        Urail(:,iOut) = exp(-1i*km*Xout(iOut))/(V*(km^4*EIr-w^2*m))*[1; -1i*km];
        Srail(:,iOut) = EIr*exp(-1i*km*Xout(iOut))/(V*(km^4*EIr-w^2*m))*[-km^2; 1i*km^3];
        % Contribution of rail pads
        Urail(:,iOut) = Urail(:,iOut) - 1/(4*EIr) * ...
            [(-1i*c1-c2)/kr^3 (d1-d2)/kr^2; (-d1+d2)/kr^2 (-1i*c1+c2)/kr] * ForceRP;
        Srail(:,iOut) = Srail(:,iOut) - kr^2/4 * ...
            [(1i*c1-c2)/kr^3 (-d1-d2)/kr^2; (d1+d2)/kr^2 (1i*c1+c2)/kr] * ForceRP;
    end
%% Part 3 - Calculate displacements due to ficticious forces (fixed loads)
%           at adjacents of interfaces
    % Transmitting boundaries
    DO = 1;
    if ~isempty(INPUT_Freq)
        kIndex = find(INPUT_Freq.W == w);
        if ~isempty(kIndex)
            DO = 0;
            OUTPUT = INPUT_Freq.Mats(kIndex);
        end
    end
    if DO
        OUTPUT = TransmittingBoundaryFEM(...
                    EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Kdlat,Nlat,N,M,w,DampType);
    end
    KRight = OUTPUT.KRight;
    KLeft = OUTPUT.KLeft;
    ad2KCouple = full(OUTPUT.ad2KCouple);
    ad2K = ad2KCouple;
    ad2K(1:end/2,1:end/2) = ad2K(1:end/2,1:end/2) + KRight;
    ad2K(end/2+1:end,end/2+1:end) = ad2K(end/2+1:end,end/2+1:end) + KLeft;
    ad2Flex = inv(ad2K);
    % Forces due to ficticious forces
    ad2FextFict = ad2KCouple*ad2Flex;
    % Forces due to moving load
    ad2FextML = ad2KCouple * [Urail(:,1); Ulat(:,1); Urail(:,2); Ulat(:,2)];
    
%% Part 4 - Calculate amplitude of ficticious forces such that internal
%           forces at interfaces are zero and add them to displacements due
%           to moving loads
    % Left side
    ad2FicForce = -ad2FextFict(1:end/2,end/2+1:end)\ad2FextML(1:end/2);
%     MAX_L = max(abs(ad2FextML(1:end/2)+ad2KCouple(1:end/2,:)*ad2Flex(:,end/2+1:end)*ad2FicForce));
    ad1U_Left = [Urail(:,1); Ulat(:,1)] + ad2Flex(1:end/2,end/2+1:end)*ad2FicForce;
    % Right side
    ad2FicForce = -ad2FextFict(end/2+1:end,1:end/2)\ad2FextML(end/2+1:end);
%     MAX_R = max(abs(ad2FextML(end/2+1:end)+ad2KCouple(end/2+1:end,:)*ad2Flex(:,1:end/2)*ad2FicForce));
    ad1U_Right = [Urail(:,2); Ulat(:,2)] + ad2Flex(end/2+1:end,1:end/2)*ad2FicForce;
    if iW == 1
        Uleft_W = zeros(size(ad1U_Left,1),length(W));
        Uright_W = zeros(size(ad1U_Right,1),length(W));
    end
    Uleft_W(:,iW) = ad1U_Left;
    Uright_W(:,iW) = ad1U_Right;
    
%     fprintf(1, 'Freq = %f, Fl = %e, Fr = %e\n', w/2/pi, MAX_L, MAX_R);
    
%% Part 5 - Convert displacements to time domain
    if iW == 1
        Uleft = zeros(size(ad1U_Left,1),length(T));
        Uright = zeros(size(ad1U_Right,1),length(T));
        UleftP = ad1U_Left;
        UrightP = ad1U_Right;
        continue;
    end
    dw = W(iW)-W(iW-1);
    %% Real component of integral
    COS1 = cos(W(iW-1)*T)./T.^2/pi;
    SIN1 = sin(W(iW-1)*T)./T/pi;
    COS2 = cos(W(iW)*T)./T.^2/pi;
    SIN2 = sin(W(iW)*T)./T/pi;
    SIN1(T==0) = -dw/(2*pi);
    SIN2(T==0) = dw/(2*pi);
    COS1(T==0) = 0;
    COS2(T==0) = 0;
    % Left part
    A = real(UleftP);
    C = real(ad1U_Left);
    B = (C-A)/dw;
    Uleft  = Uleft  + C*SIN2 - A*SIN1 + B*(COS2-COS1);
    % Right part
    A = real(UrightP);
    C = real(ad1U_Right);
    B = (C-A)/dw;
    Uright  = Uright  + C*SIN2 - A*SIN1 + B*(COS2-COS1);
    %% Imaginary component of integral
    COS1 = cos(W(iW-1)*T)./T/pi;
    SIN1 = sin(W(iW-1)*T)./T.^2/pi;
    COS2 = cos(W(iW)*T)./T/pi;
    SIN2 = sin(W(iW)*T)./T.^2/pi;
    SIN1(T==0) = 0;
    SIN2(T==0) = 0;
    COS1(T==0) = 0;
    COS2(T==0) = 0;
    % Left part
    A = imag(UleftP);
    C = imag(ad1U_Left);
    B = (C-A)/dw;
    Uleft  = Uleft  + C*COS2 - A*COS1 - B*(SIN2-SIN1);
    % Right part
    A = imag(UrightP);
    C = imag(ad1U_Right);
    B = (C-A)/dw;
    Uright  = Uright  + C*COS2 - A*COS1 - B*(SIN2-SIN1);
    
    UleftP = ad1U_Left;
    UrightP = ad1U_Right;
end
if Nlat(end) ~= 0
    Uleft = [Uleft; zeros(2,size(Uleft,2))];
    Uright = [Uright; zeros(2,size(Uright,2))];
end
for iStar = star+1:1:50
    fprintf(1, '*');
end
fprintf(1, ']\n');

% Store results in Filename
if ~isempty(Filename)
    sInputFile.EI = EI;
    sInputFile.m = m;
    sInputFile.Kv = Kv;
    sInputFile.Kt = Kt;
    sInputFile.Ms = Ms;
    sInputFile.Js = Js;
    sInputFile.Ku = Ku;
    sInputFile.Kuh = Kuh;
    sInputFile.D = D;
    sInputFile.Mlat = Mlat;
    sInputFile.Knlat = Knlat;
    sInputFile.Kslat = Kslat;
    sInputFile.Kdlat = Kdlat;
    sInputFile.Nlat = Nlat;
    sInputFile.N = N;
    sInputFile.M = M;
    sInputFile.DampType = DampType;
    sInputFile.dt = dt;
    sInputFile.Tmax = Tmax;
    sInputFile.V = V;
    sInputFile.W = W;
    save(Filename, 'sInputFile', 'T', 'Uleft',  'Uright', ...
                                                    'Uleft_W', 'Uright_W');
end

end

function [c,d] = CalcCD(k1,k2,x,L)
    X = floor(x/L);
    exp1 = exp(1i*k2*L*(X+1));
    exp2 = exp(-k1*(x-(X+1)*L));
    exp3 = 1/exp2;
    exp4 = exp((1i*k2+k1)*L);
    exp5 = exp((1i*k2-k1)*L);
    c = exp1*(exp2/(-1+exp4)-exp3/(-1+exp5));
    d = exp1*(-exp2/(-1+exp4)-exp3/(-1+exp5));
end

function VALID = CheckInputs(sInputFile,EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Kdlat,Nlat,N,M,DampType,dt,Tmax,V,W)
VALID = 0;
if EI ~= sInputFile.EI, return; end
if m ~= sInputFile.m, return; end
if Kv ~= sInputFile.Kv, return; end
if Kt ~= sInputFile.Kt, return; end
if Ms ~= sInputFile.Ms, return; end
if Js ~= sInputFile.Js, return; end
if Ku ~= sInputFile.Ku, return; end
if Kuh ~= sInputFile.Kuh, return; end
if D ~= sInputFile.D, return; end
if length(Mlat) ~= length(sInputFile.Mlat), return; end
if length(Knlat) ~= length(sInputFile.Knlat), return; end
if length(Kslat) ~= length(sInputFile.Kslat), return; end
if length(Kdlat) ~= length(sInputFile.Kdlat), return; end
if length(Nlat) ~= length(sInputFile.Nlat), return; end
for iLayer = 1: 1: length(Nlat)
    if Mlat(iLayer) ~= sInputFile.Mlat(iLayer), return; end
    if Knlat(iLayer) ~= sInputFile.Knlat(iLayer), return; end
    if Kslat(iLayer) ~= sInputFile.Kslat(iLayer), return; end
    if Kdlat(iLayer) ~= sInputFile.Kdlat(iLayer), return; end
    if Nlat(iLayer) ~= sInputFile.Nlat(iLayer), return; end
end
if N ~= sInputFile.N, return; end
if M ~= sInputFile.M, return; end
if DampType ~= sInputFile.DampType, return; end
if dt ~= sInputFile.dt, return; end
if Tmax > sInputFile.Tmax, return; end
if V ~= sInputFile.V, return; end
if length(W) ~= length(sInputFile.W), return; end
for iW = 1: 1: length(W)
    if W(iW) ~= sInputFile.W(iW), return; end
end
VALID = 1;
end