function CreateVideo_ML(INPUT,Filename,V,TYPE,XLIM,STEP,FREQ)
close all
if nargin < 4, TYPE = 0; end
if nargin < 5, XLIM = 5; end
if nargin < 6, STEP = 1; end
if nargin < 7, FREQ = 60; end
SLEEPER = INPUT.SLEEPER;
RAIL = INPUT.RAIL;
BALLAST = INPUT.BALLAST;
BEAM = INPUT.BEAM;
SPRING = INPUT.SPRING;
SLAB = INPUT.SLAB;
SOIL = INPUT.SOIL;
FIXED = INPUT.FIXED;

NODE_TYPE = INPUT.NODE_TYPE;
ad2Connection = INPUT.ad2Connection;
T = INPUT.T;
ad2Displ = INPUT.ad2Displ;
ad2Vel = INPUT.ad2Vel;

RAIL_NODES = find(NODE_TYPE(:,1) == RAIL);
SLEEPER_NODES = find(NODE_TYPE(:,1) == SLEEPER);
BALLAST_NODES = find(NODE_TYPE(:,1) == BALLAST);
SLAB_NODES = find(NODE_TYPE(:,1) == SLAB);
SOIL_NODES = find(NODE_TYPE(:,1) == SOIL);
FIXED_NODES = find(NODE_TYPE(:,1) == FIXED);

LATTICE_NODES = unique(sort([BALLAST_NODES;SOIL_NODES;SLAB_NODES;FIXED_NODES],'ascend'));
XX = unique(NODE_TYPE(LATTICE_NODES,2));
YY = unique(NODE_TYPE(LATTICE_NODES,3));
YY = YY(end:-1:1);

%% Calculate enerny flow per ballast node
if TYPE == 2
    ENERGY_FLOW = zeros(2*size(NODE_TYPE,1), length(T));
    fprintf(1, '\n');
    fprintf(1, 'Creating energy flow for %d connections ...\n', size(ad2Connection,1));
    fprintf(1, '[0%%                                            100%%]\n');
    fprintf(1, '[');
    STARS = zeros(50,1); star = 0;
    for iCon = 1: 1: size(ad2Connection,1)
        if mod(iCon,round(size(ad2Connection,1)/50))==0
            star = star + 1;
            if star <= 50 && STARS(star) == 0
                fprintf(1, '*');
                STARS(star) = 1;
            end
        end
        Node1 = ad2Connection(iCon,2);
        Node2 = ad2Connection(iCon,3);
        if Node1 == -1, continue; end
        if Node2 == -1, continue; end
        if ~(NODE_TYPE(Node1,1) == BALLAST || NODE_TYPE(Node1,1) == SOIL || NODE_TYPE(Node1,1) == SLAB) || ...
           ~(NODE_TYPE(Node2,1) == BALLAST || NODE_TYPE(Node2,1) == SOIL || NODE_TYPE(Node2,1) == SLAB)
            continue;
        end
        % Calculate force on spring
        dofs =  ad2Connection(iCon,4:7);
        K = ad2Connection(iCon,8);
        C = ad2Connection(iCon,9);
        K = K*(dofs'*dofs);
        C = C*(dofs'*dofs);
        F = K*ad2Displ([2*Node1-1; 2*Node1; 2*Node2-1; 2*Node2],:) + ...
        C*ad2Vel([2*Node1-1; 2*Node1; 2*Node2-1; 2*Node2],:);
        % Node1
        EnergyFlow = sum(-F(1:2,:).*ad2Vel([2*Node1-1; 2*Node1],:),1);
        direction = NODE_TYPE(Node1,2:3)-NODE_TYPE(Node2,2:3);
        direction = direction'/norm(direction);
        ENERGY_FLOW(2*(Node1-1)+(1:2),:) = ENERGY_FLOW(2*(Node1-1)+(1:2),:) + ...
            direction * EnergyFlow;
        % Node2
        EnergyFlow = sum(-F(3:4,:).*ad2Vel([2*Node2-1; 2*Node2],:),1);
        direction = NODE_TYPE(Node2,2:3)-NODE_TYPE(Node1,2:3);
        direction = direction'/norm(direction);
        ENERGY_FLOW(2*(Node2-1)+(1:2),:) = ENERGY_FLOW(2*(Node2-1)+(1:2),:) + ...
            direction * EnergyFlow;
    end
    for iStar = star+1:1:50
        fprintf(1, '*');
    end
    fprintf(1, ']\n');
    % Group the energy
    GROUP_DIST = 0.1;
    NODES = sort([BALLAST_NODES(:);SOIL_NODES(:);SLAB_NODES(:)], 'ascend');
    ENERGY_FLOW = ENERGY_FLOW(sort([2*NODES-1;2*NODES],'ascend'),:);
    GROUPS = [];
    GROUPED_NODE = zeros(length(NODES),1);
    kGroup = 0;
    EnergyFlow = [];
    ENERGY_XY = [];
    for iNode = 1: 1: length(NODES)
        Node1 = NODES(iNode);
        if GROUPED_NODE(iNode) == 1, continue; end
        kGroup = kGroup + 1;
        GROUP = iNode;
        GROUPED_NODE(iNode) = 1;
        for jNode = iNode + 1: 1: length(NODES)
            if GROUPED_NODE(jNode) == 1, continue; end
            Node2 = NODES(jNode);
            direction = NODE_TYPE(Node1,2:3)-NODE_TYPE(Node2,2:3);
            direction = abs(direction);
            if max(direction) > GROUP_DIST, continue; end
            GROUPED_NODE(jNode) = 1;
            GROUP = [GROUP;jNode];
        end
        Nodes = NODES(GROUP);
        GROUPS.X = mean(NODE_TYPE(Nodes,2));
        GROUPS.Y = mean(NODE_TYPE(Nodes,3));
        GROUPS.ENERGY_FLOW = [sum(ENERGY_FLOW(2*(GROUP-1)+1,:),1);
                              sum(ENERGY_FLOW(2*(GROUP-1)+2,:),1)];
        EnergyFlow = [EnergyFlow; GROUPS.ENERGY_FLOW];
        ENERGY_XY = [ENERGY_XY; GROUPS.X GROUPS.Y];
    end
    ENERGY_FLOW = EnergyFlow;
    EnergyFlow = [];
    ENERGY_FLOW = ENERGY_FLOW / max(max(abs(ENERGY_FLOW))) * 1.0;
end

%% Create file with video
if TYPE == 0
    writerObj = VideoWriter([Filename '_Deform'],'MPEG-4');
elseif TYPE == 1
    writerObj = VideoWriter([Filename '_ColorMap'],'MPEG-4');
elseif TYPE == 2
    writerObj = VideoWriter([Filename '_EnergyFlow'],'MPEG-4');
end
writerObj.Quality = 100;
writerObj.FrameRate = FREQ;
% Start
open(writerObj); 

SCALE = 0.3/max(max(abs(ad2Displ)));
C_SCALE = ceil(log10(sqrt(2)*max(max(abs(ad2Displ)))));
%% Loop on timesteps
fprintf(1, '\n');
fprintf(1, 'Creating video ...\n');
fprintf(1, '[0%%                                            100%%]\n');
fprintf(1, '[');
STARS = zeros(50,1); star = 0;
X = T*V;
KT = find((X>=-XLIM).*(X<=max(NODE_TYPE(:,2)+XLIM)));
set(gcf, 'Position', get(0, 'Screensize'));
for iT = 1: STEP: length(KT)
    if mod(iT,round(length(KT)/50))==0
        star = star + 1;
        if star <= 50 && STARS(star) == 0
            fprintf(1, '*');
            STARS(star) = 1;
        end
    end
    % Plot the load
    t = T(KT(iT));
    x = V*t;
    plot([x x], [2.5 1.5] ,'-vk');
    hold on;
    % Plot Rail nodes
    plot(NODE_TYPE(RAIL_NODES,2), 0.6+ad2Displ(2*RAIL_NODES-1,KT(iT))*SCALE, 'b');
    plot(NODE_TYPE(RAIL_NODES,2), 0.3+ad2Displ(2*RAIL_NODES-1,KT(iT))*SCALE, 'b');
    % Plot Sleepers
    for iSleeper = 1:1:length(SLEEPER_NODES)
        kNode = SLEEPER_NODES(iSleeper);
        x = NODE_TYPE(kNode,2);
        y = 0.15+ad2Displ(2*kNode-1,KT(iT))*SCALE;
        r = ad2Displ(2*kNode,KT(iT));
        X = [x-0.15-0.15*r y+0.15-0.15*r;
             x-0.15+0.15*r y-0.15-0.15*r;
             x+0.15+0.15*r y-0.15+0.15*r;
             x+0.15-0.15*r y+0.15+0.15*r];
        plot(X([1 2 3 4 1],1), X([1 2 3 4 1],2), 'r');
    end
    if TYPE == 0
        % Plot Ballast nodes
        plot(NODE_TYPE(BALLAST_NODES,2)+ad2Displ(2*BALLAST_NODES-1,KT(iT))*SCALE, ...
             NODE_TYPE(BALLAST_NODES,3)+ad2Displ(2*BALLAST_NODES  ,KT(iT))*SCALE, '.c', 'MarkerSize', 0.1);
        % Plot Soil nodes
        plot(NODE_TYPE(SOIL_NODES,2)+ad2Displ(2*SOIL_NODES-1,KT(iT))*SCALE, ...
             NODE_TYPE(SOIL_NODES,3)+ad2Displ(2*SOIL_NODES  ,KT(iT))*SCALE, '.m', 'MarkerSize', 0.1);
    elseif TYPE == 1
        TOTAL_DISPL = log10(sqrt(ad2Displ(2*LATTICE_NODES-1,KT(iT)).^2+ad2Displ(2*LATTICE_NODES,KT(iT)).^2));
        TOTAL_DISPL = reshape(TOTAL_DISPL, [length(YY) length(XX)]);
        surface(XX,YY,zeros(size(TOTAL_DISPL)),TOTAL_DISPL,'LineStyle','none');
        caxis([C_SCALE-3 C_SCALE]);
    elseif TYPE == 2
        plot(ENERGY_XY(:,1),ENERGY_XY(:,2),'.b', 'MarkerSize', 0.1);
        for iNode = 1: 1: size(ENERGY_XY,1)
            plot(ENERGY_XY(iNode,1)+[0 ENERGY_FLOW(2*iNode-1,KT(iT))],...
                 ENERGY_XY(iNode,2)+[0 ENERGY_FLOW(2*iNode-0,KT(iT))],'b-');
        end
    end
    % Limits of the plot
    xlim([-XLIM max(NODE_TYPE(:,2)+XLIM)]);
    axis equal
    % Title
    title([' Time = ' num2str(t) ' s']);
    hold off
    writeVideo(writerObj,getframe(gcf));
end
for iStar = star+1:1:50
    fprintf(1, '*');
end
fprintf(1, ']\n');
%% Close video
close(writerObj);