function U = CalculateU(EI,m,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,k,iK)
if nargin < 12, iK = 1; end
if Knlat(1) ~= inf
    uxxk = zeros(N+M,1);
    uxzk = zeros(N+M,1);
    uzxk = zeros(N+M,1);
    uzzk = zeros(N+M,1);
    for iM = 0: 1: N+M-1
        if iK == 1, km = k + 2*pi*iM/(N+M)/Dlat;
        else,       km = k - 2*pi*iM/(N+M)/Dlat;
        end
        Klat = zeros(2*length(Nlat),2*length(Nlat));
        for iLayer = 1: 1: length(Nlat)
            if Nlat(iLayer) ~= 0
                klat = LayeredLattice_PSV(Mlat(iLayer), Knlat(iLayer), Kslat(iLayer), Nlat(iLayer), Dlat, w, km, 0, 0);
            else
                klat = [Kslat(iLayer) 0 0 0; 0 Knlat(iLayer) 0 0; zeros(2,4)];
            end
            if iLayer < length(Nlat)
                Klat(2*(iLayer-1)+(1:4),2*(iLayer-1)+(1:4)) = Klat(2*(iLayer-1)+(1:4),2*(iLayer-1)+(1:4)) + klat;
            else
                Klat(end-1:end,end-1:end) = Klat(end-1:end,end-1:end) + klat(1:2,1:2);
            end
        end
        Flat = zeros(size(Klat,1),1);
        % Force in x
        Flat(1) = 1;
        Ulat = Klat\Flat;
        uxxk(iM+1) = Ulat(1);
        uzxk(iM+1) = Ulat(2);
        % Force in z
        Flat(1) = 0; Flat(2) = 1;
        Ulat = Klat\Flat;
        uxzk(iM+1) = Ulat(1);
        uzzk(iM+1) = Ulat(2);
    end
    Ulat = zeros(2*N,2*N);
    for iN = 1: 1: N
        for jN = 1: 1: N
            for iM = 0: 1: N+M-1
                if iK == 1, km = k + 2*pi*iM/(N+M)/Dlat;
                else,       km = k - 2*pi*iM/(N+M)/Dlat;
                end
                Ulat(2*iN-1,2*jN-1) = Ulat(2*iN-1,2*jN-1) + ...
                                    uxxk(iM+1)*exp(-1i*km*Dlat*(iN-jN));
                Ulat(2*iN-0,2*jN-1) = Ulat(2*iN-0,2*jN-1) + ...
                                    uzxk(iM+1)*exp(-1i*km*Dlat*(iN-jN));
                Ulat(2*iN-1,2*jN-0) = Ulat(2*iN-1,2*jN-0) + ...
                                    uxzk(iM+1)*exp(-1i*km*Dlat*(iN-jN));
                Ulat(2*iN-0,2*jN-0) = Ulat(2*iN-0,2*jN-0) + ...
                                    uzzk(iM+1)*exp(-1i*km*Dlat*(iN-jN));
            end
        end
    end
    Ulat = Ulat / (N+M);
else
    Ulat = zeros(2*N,2*N);
end
%% Calculate matrix Urail
k1 = (w^2*m/EI)^.25;
if abs(k1-k)<eps
    k1 = (w^2*m/(EI*(1+1i*0.00001)))^.25;
end
a1 = A(1i*k1,k,(N+M)*Dlat);
a2 = A(k1,k,(N+M)*Dlat);
b1 = -A(1i*k,k1,(N+M)*Dlat);
b2 = -A(1i*k,-1i*k1,(N+M)*Dlat);
Urail = 1/4/EI/k1^3*[   -1i*a1-a2,         k1*b1-k1*b2;
                     -k1*b1+k1*b2, -1i*k1^2*a1+k1^2*a2];
%% Calculate U
U = [Ulat(2:2:end,2:2:end) zeros(N,2) Ulat(2:2:end,1:2:end);
     zeros(2,N)  Urail  zeros(2,N);
     Ulat(1:2:end,2:2:end) zeros(N,2) Ulat(1:2:end,1:2:end)];
end

function a = A(k1,k,X)
exp1 = exp(k1*X);
exp2 = exp(1i*k*X);
a = (exp2/exp1-exp2*exp1)/((exp1-exp2)*(1/exp1-exp2));
if abs(a) == inf, a = 1/eps; end
end
