function OUTPUT = CalculateFrequencyDomainResponse_FL_Quad(...
    EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,XlR,IlL,XoR,IoL,LoS,fTol,nDiv)
if nargin < 23, nDiv = 1; end
if nargin < 22, fTol = 1e-6; end
if real(Ku) == inf, Ku = real(Ku); end
if real(Kuh) == inf, Kuh = real(Kuh); end
if Knlat(1) == inf
    Nlat = 0; KnLat = inf; Kslat = inf; Mlat = inf;
    IlL = [];
    IoL = [];
end
if length(Mlat)~=length(Knlat) || length(Mlat)~=length(Kslat) || length(Mlat)~=length(Nlat)
    fprintf(1, 'ERROR: lattice inputs must have all the same dimensions (except for Dlat)');
    OUTPUT = [];
    return;
end
if ~isempty(IoL)
    IoL = IoL(:)';
end
%% Define load
SLEEPER = 0;
RAIL = 1;
LATTICE = 2;
XX = 1; % Horzintal
ZZ = 2; % Vertical
MM = 3; % Moment
nLoad = 2*length(XlR);
nLoad = nLoad + 2*length(IlL)*sum(Nlat);
if length(Nlat) > 1 && Nlat(end) == 0, nLoad = nLoad + 2*length(IlL); end
LOAD = zeros(nLoad,4);
kLoad = 0;
for iLoad = 1: 1: length(XlR)
    kLoad = kLoad + 1;
    LOAD(kLoad,1) = RAIL;
    LOAD(kLoad,2) = XlR(iLoad);
    LOAD(kLoad,3) = ZZ;
    kLoad = kLoad + 1;
    LOAD(kLoad,1) = RAIL;
    LOAD(kLoad,2) = XlR(iLoad);
    LOAD(kLoad,3) = MM;
end
for iLoad = 1: 1: length(IlL)
    for iZ = 1: 1: sum(Nlat)
        kLoad = kLoad + 1;
        LOAD(kLoad,1) = LATTICE;
        LOAD(kLoad,2) = IlL(iLoad);
        LOAD(kLoad,3) = iZ-1;
        LOAD(kLoad,4) = XX;
        kLoad = kLoad + 1;
        LOAD(kLoad,1) = LATTICE;
        LOAD(kLoad,2) = IlL(iLoad);
        LOAD(kLoad,3) = iZ-1;
        LOAD(kLoad,4) = ZZ;
    end
    if length(Nlat)>1 && Nlat(end) == 0
        kLoad = kLoad + 1;
        LOAD(kLoad,1) = LATTICE;
        LOAD(kLoad,2) = IlL(iLoad);
        LOAD(kLoad,3) = sum(Nlat);
        LOAD(kLoad,4) = XX;
        kLoad = kLoad + 1;
        LOAD(kLoad,1) = LATTICE;
        LOAD(kLoad,2) = IlL(iLoad);
        LOAD(kLoad,3) = sum(Nlat);
        LOAD(kLoad,4) = ZZ;
    end
end

%% Initialize outputs
OUTPUT = [];
Urail = zeros(2*length(XoR), nLoad);
Srail = zeros(2*length(XoR), nLoad);
Ulattice = zeros(2*sum(Nlat)+2,length(IoL), nLoad);
Usleeper = zeros(2*length(LoS), nLoad);

%% Add to Urail and Srail responses due to external load at the rails
kb = (w^2*m/EI)^.25;
for iLoad = 1: 1: nLoad
    if LOAD(iLoad,1) ~= RAIL, continue; end
    xp = LOAD(iLoad,2);
    for iOutput = 1: 1: length(XoR)
        x = XoR(iOutput) - xp;
        exp1 = exp(-1i*kb*abs(x));
        exp2 = exp(-kb*abs(x));
        if LOAD(iLoad,3) == ZZ
            Urail(2*iOutput-1,iLoad) = 1/(4*EI*kb^3)*(-1i*exp1-exp2);
            Urail(2*iOutput-0,iLoad) = sign(x)/(4*EI*kb^2)*(-exp1+exp2);
            Srail(2*iOutput-1,iLoad) = sign(x)/4*(exp1+exp2);
            Srail(2*iOutput-0,iLoad) = 1/(4*kb)*(1i*exp1-exp2);
        elseif LOAD(iLoad,3) == MM
            Urail(2*iOutput-1,iLoad) = sign(x)/(4*EI*kb^2)*(exp1-exp2);
            Urail(2*iOutput-0,iLoad) = 1/(4*EI*kb)*(-1i*exp1+exp2);
            Srail(2*iOutput-1,iLoad) = kb/4*(1i*exp1+exp2);
            Srail(2*iOutput-0,iLoad) = sign(x)/4*(-exp1-exp2);
        end
    end
end
%% Periodicity and wavenumber
L = (N+M)*Dlat;

%% Position of contact points
Dist = zeros(1,N);
for iN = 0: 1: N-1
    Dist(iN+1) = (iN-(N-1)/2)*Dlat;
end

%% Loop on wavenumbers
fprintf(1, '\n');
fprintf(1, 'Frequency = %f Hz ...\n', w/2/pi);
% fprintf(1, 'Integrating using integral ...');
% nK = 0;
% Z = integral(@(k)CalculateResponseK(k,...
%     EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,XoR,IoL,LoS,LOAD,L,Dist),...
%     -pi/(N+M)/Dlat,pi/(N+M)/Dlat,'ArrayValued',true,'AbsTol',fTol,'RelTol',1e-6);
fprintf(1, 'Integrating using quadv ... \n');
k2 = -pi/(N+M)/Dlat;
for iDiv = 1: 1: nDiv
    k1 = k2;
    k2 = k1 + 2*pi/(N+M)/Dlat/nDiv;
    fprintf(1, '   Part %d of %d: k = [%f, %f] ... ', iDiv, nDiv, k1, k2);
    [Z0,nK0] = quadv(@(k)CalculateResponseK(k,...
            EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,XoR,IoL,LoS,LOAD,L,Dist),...
            k1,k2,fTol);
    if iDiv == 1
        Z = Z0;
        nK = nK0;
    else
        Z = Z + Z0;
        nK = nK + nK0;
    end
    fprintf(1, ' done (%d points used in integraion).\n', nK0);
end

SIZE = size(Urail); Urail = Urail(:)+Z(1:length(Urail(:))); Z(1:length(Urail(:))) = []; Urail = reshape(Urail,SIZE);
SIZE = size(Srail); Srail = Srail(:)+Z(1:length(Srail(:))); Z(1:length(Srail(:))) = []; Srail = reshape(Srail,SIZE);
SIZE = size(Usleeper); Usleeper = Z(1:length(Usleeper(:))); Z(1:length(Usleeper(:))) = []; Usleeper = reshape(Usleeper,SIZE);
SIZE = size(Ulattice); Ulattice = Z(1:length(Ulattice(:))); Z(1:length(Ulattice(:))) = []; Ulattice = reshape(Ulattice,SIZE);

%% Store results
OUTPUT.RAIL = RAIL;
OUTPUT.SLEEPER = SLEEPER;
OUTPUT.LATTICE = LATTICE;
OUTPUT.XX = XX;
OUTPUT.ZZ = ZZ;
OUTPUT.MM = MM;
OUTPUT.LOAD = LOAD;
OUTPUT.XoR=XoR;
OUTPUT.LoS=LoS;
OUTPUT.IoL=IoL;
OUTPUT.Urail = Urail;
OUTPUT.Srail = Srail;
OUTPUT.Ulattice = Ulattice;
OUTPUT.Usleeper = Usleeper;

end

%% Integrating function
function Z = CalculateResponseK(k,...
    EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,XoR,IoL,LoS,LOAD,L,Dist)
SLEEPER = 0;
RAIL = 1;
LATTICE = 2;
XX = 1; % Horzintal
ZZ = 2; % Vertical
MM = 3; % Moment
%% Calculate matrix E
E = CalculateE(Kv,Kt,Ms,Js,Ku,Kuh,Dlat,N,w);

%% Calculate U
U = CalculateU(EI,m,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,k);

%% Flexibility - inverse of U+E
if Kuh == 0
    Flex = inv(U(1:N+2,1:N+2)+E(1:N+2,1:N+2));
else
    Flex = inv(U+E);
end

%% Calculate Ulat
Ulat = zeros(2*sum(Nlat)+2, 2*sum(Nlat)+2, N+M); FREE = 0;
if Knlat(1) ~= inf
    for iM = 1: 1: N+M
        last = size(Ulat,1)-2;
        km = k + 2*pi*(iM-1)/L;
        Klat = zeros(2*sum(Nlat)+2, 2*sum(Nlat)+2);
        kz = 0;
        for iLayer = 1: 1: length(Nlat)
            if iLayer < length(Nlat) || Nlat(iLayer) ~= 0
                Kelem = LayeredLattice_PSV(Mlat(iLayer),Knlat(iLayer),Kslat(iLayer),...
                                                1, Dlat, w, km, FREE, FREE);
                for iZ = 1: 1: Nlat(iLayer)
                    Klat(kz+(iZ-1)*2+(1:4),kz+(iZ-1)*2+(1:4)) = ...
                                Klat(kz+(iZ-1)*2+(1:4),kz+(iZ-1)*2+(1:4)) + Kelem;
                end
            else
                Kelem = [Kslat(iLayer) 0; 0 Knlat(iLayer)];
                Klat(kz+(1:2),kz+(1:2)) = Klat(kz+(1:2),kz+(1:2)) + Kelem;
                last = last + 2;
            end
            kz = kz + 2*Nlat(iLayer);
        end
        Ulat(1:last,1:last,iM) = inv(Klat(1:last,1:last));
    end
end

%% characteristic wavelength of rail
kb = (w^2*m/EI)^.25;
if abs(kb-k)<eps
    kb = (w^2*m/(EI*(1+1i*0.00001)))^.25;
end

%% Loop on loads
nLoad = size(LOAD,1);
Urail = zeros(2*length(XoR), nLoad);
Srail = zeros(2*length(XoR), nLoad);
Usleeper = zeros(2*length(LoS), nLoad);
Ulattice = zeros(2*sum(Nlat)+2, length(IoL), nLoad);
for iLoad = 1: 1: nLoad
    ulattice = zeros(2*sum(Nlat)+2, length(IoL));
    CONTINUE = 0;
    if LOAD(iLoad,1) == RAIL
        xp = LOAD(iLoad,2);
        [c1,d1] = CalcCD(1i*kb,k,xp,L);
        [c2,d2] = CalcCD(kb,k,xp,L);
        u_ext = zeros(2*N+2,1);
        if LOAD(iLoad,3) == ZZ
            u_ext(N+(1:2),1) = 1/(4*EI)*[(-1i*c1-c2)/kb^3; (-d1+d2)/kb^2];
        else
            u_ext(N+(1:2),1) = 1/(4*EI)*[(d1-d2)/kb^2; (-1i*c1+c2)/kb];
        end
    elseif LOAD(iLoad,1) == LATTICE
        iL = LOAD(iLoad,2);
        u_ext = zeros(2*N+2,1);
        % Add to lattice outputs the contribution due to point load
        if mod(iL,N+M)>=N || LOAD(iLoad,3) ~= 0 || LOAD(iLoad,4) ~= XX || Kuh ~= inf
            for iM = 1: 1: N+M
                km = k + 2*pi*(iM-1)/L;
                exp1 = exp(-1i*km*Dlat*((0:1:(N-1))'-iL));
                u_ext(1:N) = u_ext(1:N) + exp1.*Ulat(2,2*LOAD(iLoad,3)+LOAD(iLoad,4),iM);
                u_ext(N+3:end) = u_ext(N+3:end) + exp1.*Ulat(1,2*LOAD(iLoad,3)+LOAD(iLoad,4),iM);
            end
            u_ext = -u_ext/(N+M);

            for iM = 1: 1: N+M
                km = k + 2*pi*(iM-1)/L;
                exp1 = exp(-1i*km*Dlat*(IoL-iL));
                ulat = Dlat/(2*pi)*Ulat(:,2*LOAD(iLoad,3)+LOAD(iLoad,4),iM);
                ulattice = ulattice + ulat*exp1;
            end
        else
            CONTINUE = 1;
        end
    end
    if CONTINUE; continue; end
    %% Calculate forces and dispalcemetns of sleepers/rail
    if Kuh == 0
        Forces = zeros(2*N+2,1);
        Forces(1:N+2) = Flex*u_ext(1:N+2);
    else
        Forces = Flex*u_ext;
    end

    %% Calculate response of rail - contribution of interaction forces
    Fk = Forces(N+1);
    Mk = Forces(N+2);
    for iOutput = 1:1:length(XoR)
        xp = -XoR(iOutput);
        [c1,d1] = CalcCD(1i*kb,k,xp,L);
        [c2,d2] = CalcCD(kb,k,xp,L);
        Urail((iOutput-1)*2+(1:2),iLoad) = ...
               -[(-1i*c1-c2)/kb^3 (d1-d2)/kb^2;
                 (-d1+d2)/kb^2 (-1i*c1+c2)/kb]*[Fk;Mk]*L/(8*pi*EI);
        Srail((iOutput-1)*2+[2 1], iLoad) = ...
               -[(1i*c1-c2)/kb^3 (-d1-d2)/kb^2;
                 (+d1+d2)/kb^2 (1i*c1+c2)/kb]*[Fk;Mk]*L*kb^2/(8*pi);
    end

    %% Calculate response of sleepers - contribution of interaction forces
    for iOutput = 1: 1: length(LoS)
        exp1 = exp(-1i*k*LoS(iOutput)*L);
        Usleeper(2*iOutput-1,iLoad) = ...
            (sum(Forces(1:N))-Forces(N+1))/(w^2*Ms) * exp1 * L/(2*pi);
        Usleeper(2*iOutput-0,iLoad) = ...
            (Dist*Forces(1:N)-Forces(N+2))/(w^2*Js) * exp1 * L/(2*pi);
    end

    %% Calculate response of lattice - contribution of interaction forces
    for iM = 1: 1: N+M
        km = k + 2*pi*(iM-1)/L;
        Flat = zeros(2,1);
        for iN = 0:1:N-1
            Flat = Flat + Forces(iN+1+[N+2;0])*exp(1i*km*Dlat*iN);
        end
        ulat = Dlat/(2*pi)*Ulat(:,[1 2],iM)*Flat;
        exp1 = exp(-1i*km*IoL*Dlat);
        ulattice = ulattice + ulat*exp1;
    end
%     ulattice(abs(ulattice)<1e-8*max(max(abs(ulattice)))) = 0;
    Ulattice(:,:,iLoad) = ulattice;
end
% Rearrange outputs
Z = [Urail(:);Srail(:);Usleeper(:);Ulattice(:)];
end

%% CalcCD
function [c,d] = CalcCD(k1,k2,x,L)
    X = floor(x/L);
    exp1 = exp(1i*k2*L*(X+1));
    exp2 = exp(-k1*(x-(X+1)*L));
    exp3 = 1/exp2;
    exp4 = exp((1i*k2+k1)*L);
    exp5 = exp((1i*k2-k1)*L);
    c = exp1*(exp2/(-1+exp4)-exp3/(-1+exp5));
    d = exp1*(-exp2/(-1+exp4)-exp3/(-1+exp5));
end

