% MATLAB script that determines the minimum angular distance of the cyclist's gaze to the bounding box of the car (angular_distance_to_car_min), the coordinates of the bounding box (CX, CY) that are the closest to the cyclist's gaze, and the angular height of the bounding box of the car (height_bb)

xbox_all=round(CarBox(yolofile_nr,frame_no,1)):round(CarBox(yolofile_nr,frame_no,1))+round(CarBox(yolofile_nr,frame_no,3)); % all x coordinates of the bounding box
ybox_all=round(CarBox(yolofile_nr,frame_no,2)):round(CarBox(yolofile_nr,frame_no,2))+round(CarBox(yolofile_nr,frame_no,4)); % all y coordinates of the bounding box
xy_topborder=[xbox_all' repmat(min(ybox_all),1,length(xbox_all))']; % top border coordinates of the bounding box
xy_bottomborder=[xbox_all' repmat(max(ybox_all),1,length(xbox_all))']; % bottom border coordinates of the bounding box
xy_leftborder=[repmat(min(xbox_all),1,length(ybox_all))' ybox_all']; % left border coordinates of the bounding box
xy_rightborder=[repmat(max(xbox_all),1,length(ybox_all))' ybox_all']; % right border coordinates of the bounding box
xy_entirebox=[xy_topborder;xy_bottomborder;xy_leftborder;xy_rightborder]; % all border coordinates into one array
xy_entirebox=unique(xy_entirebox,'rows'); % remove the duplicate corners
CX=median(xy_entirebox(:,1)); % x coordinate of the middle of bounding box
CY=median(xy_entirebox(:,2)); % y coordinate of the middle of bounding box

y1 = CarBox(yolofile_nr,frame_no,2)+CarBox(yolofile_nr,frame_no,4)-960; % shift y coordinate of the bottom of the bounding box to center coordinate system
x1 = CX-540; % shift x coordinate of the center of the bounding box
y0 = CarBox(yolofile_nr,frame_no,2)-960; % shift y coordinate of the top of the bounding box to center coordinate system
x0 = CX-540; % x0 is the same as x1 (same vertical line)
height_bb=acosd((f^2+x0.*x1+y0.*y1)./ (sqrt(f^2+x0.^2+y0.^2).*sqrt(f^2+x1.^2+y1.^2))); % angular height of the bounding box (deg)

if Gaze(1)>min(xy_entirebox(:,1)) && Gaze(1)<max(xy_entirebox(:,1)) && Gaze(2)>min(xy_entirebox(:,2)) && Gaze(2)<max(xy_entirebox(:,2)) % if glancing within the box
    angular_distance_to_car_min =0;
else
    x1=Gaze(1)-960; % shift x gaze coordinate to center coordinate system
    y1=Gaze(2)-540; % shift y gaze coordinate to center coordinate system

    angular_distance_to_car_pixels=NaN(size(xy_entirebox,1),1);
    for pixels=1:size(xy_entirebox,1)

        x0=xy_entirebox(pixels,1)-960; % shift border pixel x coordinate to center coordinate system
        y0=xy_entirebox(pixels,2)-540; % shift border pixel y coordinate to center coordinate system

        angular_distance_to_car_pixels(pixels)=acosd((f^2+x0.*x1+y0.*y1)./ (sqrt(f^2+x0.^2+y0.^2).*sqrt(f^2+x1.^2+y1.^2))); % angular distance between gaze point and border pixel
    end

    [angular_distance_to_car_min,min_index]=min(angular_distance_to_car_pixels); % minimum angular distance and corresponding pixel index
    CX=xy_entirebox(min_index,1); % update CX to the x coordinate of the closest point on the bounding box of the car
    CY=xy_entirebox(min_index,2); % update CY to the y coordinate of the closest point on the bounding box of the car
end
