% MATLAB script for the following paper:
% Berge S. H., De Winter, J. C. F., Dodou, D., Pooyan Afghari, A., Papadimitriou, E., Reddy, N., Dong, Y., Raju, N., & Farah, H. (2024). Understanding cyclists’ perception of driverless vehicles through eye-tracking and interviews. Transportation Research Part F.

% Estimation of the average duration of the interviews after Session 1 and Session 2

clear variables;close all;clc
duration=NaN(74,80);
[~,Xt]=xlsread('Interview analysis full',3,'C2:C75'); %#ok<XLSRD>
for i=1:length(Xt)
    transcript=Xt{i};
    indices=strfind(transcript,'00:');
    counter=0;
    for j=1:length(indices)
        s=indices(j);
        e=indices(j)+7;
        transcript(s:e);

        if ~isempty(str2num(transcript(e)));
            counter=counter+1;
            duration(i,counter)=round(24*3600*(datenum(transcript(s:e))-floor(datenum(transcript(s:e)))));
        end
    end
end
%%
length_session=NaN(74,1);
for i=1:size(duration,1) % loop over 74 sessions (37 x 2)
    durations_session=duration(i,:);
    restart_idx=find(diff(durations_session)<0)+1;
    if ~isempty(restart_idx)
    durations_session(restart_idx:end)=durations_session(restart_idx:end)+durations_session(restart_idx-1); % correct in case of a microphone restart
    end
    length_session(i)=max(durations_session);
end
length_session(27)=4*60+01; % for participant 29, Session 1 interview, use 4 min 01 s based on audio duration (Amberscript transcript n/a)
disp('Duration_session_1, M SD')
disp([round(mean(length_session(1:37),'omitnan')) round(std(length_session(1:37),'omitnan'))])
disp('Duration_session_1, M SD')
disp([round(mean(length_session(38:74),'omitnan')) round( std(length_session(38:74),'omitnan'))])
