% MATLAB script for the following paper:
% Berge S. H., De Winter, J. C. F., Dodou, D., Pooyan Afghari, A., Papadimitriou, E., Reddy, N., Dong, Y., Raju, N., & Farah, H. (2024). Understanding cyclists’ perception of driverless vehicles through eye-tracking and interviews. Transportation Research Part F.

clear variables;close all;clc
import matlab.net.* matlab.net.http.* matlab.net.http.io.*
uri = URI('https://api.openai.com/v1/chat/completions');

Session1_intro='This is a transcript of an interview done with a participant who had cycled four rounds and interacted with a Wizard-of-Oz automated vehicle in each round. Before this session, the participant had received no particular instructions or information.';
Session2_intro='This is a transcript of an interview done with a participant who had cycled four rounds and interacted with a Wizard-of-Oz automated vehicle in each round. Before this session, the participant was told to look for and verbally indicate whether a driver was present.';
Speaker_info='Speaker 1 is the interviewer; Speaker 2 is the participant.';

[~,Xt]=xlsread('Interview analysis full',3,'C2:C75'); %#ok<XLSRD>

prompts={'Based on this interview, how did the participant interact with the vehicle?' % Q1 (Session 1)
    'Based on this interview, what did the participant look at? Which areas of the car, motion cues?, eye contact?' % Q2 (Session 1)
    'Based on this interview, according to the participant, did anything stand out, and if so, what? Did they notice anything was different between vehicles?' % Q3 (Session 1)
    'Based on this interview, did the participant interact differently with this vehicle as opposed to vehicles in daily life? and How?, Why?'; % Q4  (Session 1)
    'Based on this interview, what did the participant say about the extent to which the interactions affected their cycling behaviour?; do not report numbers; only explanations' % Q5 (Session 2)
    'Based on this interview, how was the participants'' (cycling) behaviour affected?' % Q6 (Session 2)
    'Based on this interview, did the participant feel safe? Please elaborate.' % Q7 (Session 2)
    'Based on this interview, when the participant was cycling and interacting with a vehicle without a driver, would the participant like to be able to distinguish the vehicle from a "normal vehicle" (e.g., a sign or marking that indicates automation)?' % Q8 (Session 2)
    'Based on this interview, when the participant was cycling and interacting with a vehicle without a driver, would the participant like additional communication from the vehicle? (e.g., extra lights or a display) Please elaborate. Also indicate the preferred modality and source of communication: visual, auditory, haptic, connectivity, vehicle, infrastructure, bike, cyclist' % Q9 (Session 2)
    'Based on this interview, to what extent did the participant think the experimental setup was realistic; do not report numbers; only explanations.' % Q10 (Session 2)
    'Based on this interview, was there anything else the participant would like to add, in response to the ''anything else'' question?'}; % Q11 (Session 2)

perform_api_transcripts=0; % if set to 1, then process the transcripts per participant per question
if perform_api_transcripts==1

    for i=38:length(Xt)
        if i<=37
            prompt_no=1:4;
            Session_intro=Session1_intro;
        else
            prompt_no=[6:9 11];
            Session_intro=Session2_intro;
        end
        for p=1:length(prompt_no)
            prompt=[Session_intro newline Speaker_info newline 'This is the transcript: ' newline Xt{i} prompts{prompt_no(p)} ];
            body = JSONProvider(struct('model','gpt-4-0613','temperature',0,'n',1,'messages', {{struct('role', 'user','content', prompt')}}));

            response = RequestMessage('post', [HeaderField('Content-Type', 'application/json') HeaderField('Authorization', 'Bearer sk-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx')], body).send(uri.EncodedURI);
            save(['Interview_API_transcript_no_' num2str(i) '_prompt_no_' num2str(prompt_no(p))],'response','prompt')
            response_text = response.Body.Data.choices.message.content;
            disp(['Interview_API_transcript_no_' num2str(i) '_prompt_no_' num2str(prompt_no(p))])
            disp(response_text);

        end
    end

end
%% Summarize the summaries
disp('DISPLAY OVERALL SUMMARIES')
import matlab.net.* matlab.net.http.* matlab.net.http.io.*
uri = URI('https://api.openai.com/v1/chat/completions');

Session1_intro='Participants had cycled four rounds and interacted with a Wizard-of-Oz automated vehicle in each round. Before this session, the participant had received no particular instructions or information.';
Session2_intro='Participants had cycled four rounds and interacted with a Wizard-of-Oz automated vehicle in each round. Before this session, the participant was told to look for and verbally indicate whether a driver was present.';

summarize_the_summaries=2; % if set to 0, to nothing, if set to 1, then submit to API and summarize the summaries, if set to 2, then output all individual prompts

for prompt_no=1:11
    text=[];
    for i=1:37*2
        if (ismember(i,1:37) && ismember (prompt_no,1:4)) || (ismember(i,38:37*2) && ismember (prompt_no,5:11)) % Prompt 1-4 apply to Session 1, Prompt 5-11 apply to Session 2
            load(['GPT-4/Interview_API_transcript_no_' num2str(i) '_prompt_no_' num2str(prompt_no)])
            response_text=response.Body.Data.choices.message.content;
            if ismember(prompt_no,1:4) % Session 1
                text=[text 'Participant No. ' num2str(i) ': ' response_text newline];
            else
                text=[text 'Participant No. ' num2str(i-37) ': ' response_text newline];
            end
        end
    end
    if ismember(prompt_no,1:4) % Session 1
        Session_intro=Session1_intro;
    else % Session 2
        Session_intro=Session2_intro;
    end
    prompt=['Please summarise the above summaries into a meta-summary, capturing the views of all 37 participants, in four sentences. The output should capture the essence in an interesting and specific manner, in UK English.' newline text];

    if summarize_the_summaries==1
        body = JSONProvider(struct('model','gpt-4-0613','temperature',0,'n',1,'messages', {{struct('role', 'user','content', prompt')}}));
    response = RequestMessage('post', [HeaderField('Content-Type', 'application/json') HeaderField('Authorization', 'Bearer sk-secret key')], body).send(uri.EncodedURI);
    response_text = response.Body.Data.choices.message.content;
    disp(['Prompt number: ' num2str(prompt_no)])
    disp(response_text)
    elseif summarize_the_summaries==2
        disp(['Prompt number: ' num2str(prompt_no)])
        disp(prompt)
    end
end
