# -*- coding: UTF-8 -*-
"""
Created on Fri Jul  3 11:12:57 2020

@author: curran
"""

#%%% Import modules and read data
import pandas as pd
import sys
import matplotlib.pyplot as plt


# Change path as required
EMDataPath = "C:/Users/SafeLevee/EM_DAT/"
sys.path.append(EMDataPath)
from FatalityAnalysisFns import ThreshFilter, Create_EMDAT_Event, CategoriseFloodEvents, CalcAddition, GraphOptions, GetSummaryStats, GetIndividualStats

# Import EMDAT, WB data and QCed data
EMDAT_Raw = pd.read_excel(EMDataPath + 'EMDAT_Downloads/emdat_public_2021_02_22_query_uid-nlkF0I.xlsx', 'emdat data',header=0)
EMDAT_Raw = pd.read_excel(EMDataPath + 'EMDAT_Downloads/emdat_public_2022_11_06_full.xlsx', 'emdat data',header=6)
#GDPData = pd.read_excel(EMDataPath + 'WB_Data/GDP_1971_2020.xlsx',header=0)
GDPData = pd.read_excel(EMDataPath + 'WB_Data/GDP_1960_2022.xlsx',header=0)
#IncomeData = pd.read_excel(EMDataPath + 'WB_Data/Income_1961_2020.xlsx',header=0)
IncomeData = pd.read_excel(EMDataPath + 'WB_Data/Income_1961_2022.xlsx',header=0)
QCData = pd.read_excel(EMDataPath + 'QCData\Data-storm-surge_AC.xlsx','Adjusted',header=0)

# Add Categories data for flood type analysis. Last item is category, others are conditions.
CategoryRules = [ [] for _ in range(3) ]
# The below can be understood as: if 'Disaster type' is 'Flood' and 'Disaster Subtype' is 'Riverine flood', then categorise as 'Riverine flood'
CategoryRules[0].append(['Disaster Type','==','Flood',       '&','Disaster Subtype','in',['Riverine flood'],             'Riverine Flood'])
CategoryRules[0].append(['Disaster Type','==','Flood',       '&','Disaster Subtype','in',['Flash flood'],                'Flash/pluvial Flood'])
CategoryRules[0].append(['Disaster Type','==','Flood',       '&','Disaster Subtype','in',['Coastal flood'],              'Coastal Flood'])
CategoryRules[0].append( ['Disaster Type','==','Flood',       '&','Disaster Subtype','in',['nan'],                       'Uncategorised Flood'])
# Add in storms and earthquakes
CategoryRules[1].append(['Disaster Type','==','Earthquake',  '&','Disaster Subtype','in',['Tsunami'],                    'Geophysical Flood'])
CategoryRules[1].append(['Disaster Type','==','Storm',       '&','Disaster Subtype','in',['Storm/Surge','Surge'],        'Coastal Flood'])
CategoryRules[1].append(['Disaster Type','==','Storm',       '&','Associated Dis','in',  ['Flood'],                      'Uncategorised Flood'])
CategoryRules[1].append(['Disaster Type','==','Storm',       '&','Associated Dis','in',  ['Surge'],                      'Coastal Flood'])
# Now that all floods are found, categorise those left uncategorised
CategoryRules[2].append(['Flood Category','==','Uncategorised Flood',       '&','Associated Dis','in',['Slide (land, mud, snow, rock)'],                                  'Flash/pluvial Flood'])
CategoryRules[2].append(['Flood Category','==','Uncategorised Flood',       '&','Origin','in',['Heavy rains, Heavy rain','Monsoon rain','Monsoonal rain'],                'Riverine Flood'])
CategoryRules[2].append(['Flood Category','==','Uncategorised Flood',       '&','Associated Dis2','in',['Surge'],                                                         'Coastal Flood'])
CategoryRules[2].append(['Flood Category','==','Uncategorised Flood',       '&','Associated Dis2','in',['Flood','nan'],                                                   'Riverine Flood'])
CategoryRules[2].append(['Flood Category','==','Uncategorised Flood',       '&','Disaster Type','in',['Flood','nan'],                                                     'Riverine Flood'])
CategoryRules[2].append(['Flood Category','==','Uncategorised Flood',       '&','Disaster Subtype','in',['Tropical cyclone','Extra-tropical storm','Convective storm'],   'Flash/pluvial Flood'])


#CategoryRules.append(['Disaster Type','==','Storm',       '&','Associated Dis','in',  ['Surge','Tsunami/Tidal wave'], 'Coastal Flood'])
# Implement above categorisation rules
EMDAT_Raw = CategoriseFloodEvents(EMDAT_Raw,CategoryRules)

# Add GDP, mortality and QC data to records/events
EMDAT_Raw = CalcAddition(EMDAT_Raw,GDPData,IncomeData,QCData)

# Create event based version of EMDAT - This is needed as individual events can have records for multiple years and countries
EMDAT_Evn = Create_EMDAT_Event(EMDAT_Raw)

# Create new filtered datasets for graphing analysis.
Thresholds = []
Thresholds.append(['Year','>=',1975,'&','Year','<=',2022]) # GDP starts at 1971,Income 1961, previous paper used 1975
#Thresholds.append(['Total Damages (\'000 US$)','<',10000,'|','Total Deaths','>',50]) # Include events based on death or damage filter
#Thresholds.append(['Income','<',1000]) # Events on lower income countries
Thresholds.append(['Disaster Category','==','\'Flood\'']) # Just floods)
#Thresholds.append(['Disaster Category','.isin','([\'Storm\',\'Landslide\',\'Drought\',\'Wildfire\',\'Extreme temperature \',\'Flood\'])']) # Ex weather events
#Thresholds.append(['Disaster Category','.isin','([\'Storm\',\'Landslide\',\'Drought\',\'Wildfire\',\'Extreme temperature \'])']) # Ex weather events minus flood

#Thresholds.append(['Flood Category','==','\'Uncategorised Flood\'']) # Flood type)
#Thresholds.append(['Flood Category','!=','\'Geophysical Flood\'']) # Extreme weather

#Thresholds.append(['Total Affected','>=','EMDAT_Filt[\'Total Deaths\']']) # This is necessary for mortality functions
Thresholds.append(['Total Affected','>','EMDAT_Filt[\'Total Deaths\']']) # This is necessary for mortality functions
Thresholds.append(['Total Deaths','>=',1]) 
Thresholds.append(['No Affected','>',0,'|','No Homeless','>',0]) 
# Thresholds.append(['Adjusted Damage','>',10000])
Thresholds.append(['Mortality','>',0])
# Thresholds.append(['Income','>',0])

EMDAT_Filt = ThreshFilter(EMDAT_Evn,Thresholds) # Use raw (EMDAT_Raw) or event based (EMDataEvn)

# Get Summary data
GetSummaryStats(EMDAT_Filt)
[LargestEvents, LargestExWeEvents, LargestFloodEvents, LargestFreshFloodEvents] = GetIndividualStats(EMDAT_Filt)

# # Graph data using filtered dataset
[Fig, Ax] = GraphOptions(EMDAT_Filt,EMDataPath)


#%%%% Make specific graphs
# Need to copy to console
#Ax.legend(loc="upper left") 

# Ax.set_yscale('log') # linear
# Ax.legend(labels = ['Total affected - trend','Average affected per event - trend','Total affected','Average affected per event'])
# Ax.set_ylabel('Probability of exceeding N')
Ax.set_ylabel('Adjusted Damage (in $100 mln)')

#Ax.set_xlabel('Fatalities (N)')

# Fig.suptitle('Probability of exceeding N', fontsize=12)
Fig.suptitle('Adjusted damage per year', fontsize=12)


# this has to be last for some reason
Ax.legend(loc='center left', bbox_to_anchor=(1, 0.5))
#Ax.legend(loc='upper right')


Fig.savefig(EMDataPath + '\\Pictures\\BoxpComp.svg', bbox_inches='tight')

#%%%% # To do

# - Show graphs delineating a certain year (e.g. 2002)
# - Automate saving graphs
# Show only certain disasters
# Separate geo floods
# Save plot infor for adjustment (handle?)
# add 7 events to coastal
# categorise last 33 events

# Create new filtered datasets for graphing analysis.
Thresholds = []
Thresholds.append(['Year','>=',2000,'&','Year','<=',2022]) # GDP starts at 1971,Income 1961, previous paper used 1975
#Thresholds.append(['Total Damages (\'000 US$)','<',10000,'|','Total Deaths','>',50]) # Include events based on death or damage filter
#Thresholds.append(['Income','<',1000]) # Events on lower income countries
Thresholds.append(['Disaster Category','==','\'Flood\'']) # Just floods)
#Thresholds.append(['Disaster Category','.isin','([\'Storm\',\'Landslide\',\'Drought\',\'Wildfire\',\'Extreme temperature \',\'Flood\'])']) # Ex weather events
#Thresholds.append(['Disaster Category','.isin','([\'Storm\',\'Landslide\',\'Drought\',\'Wildfire\',\'Extreme temperature \'])']) # Ex weather events minus flood
#Thresholds.append(['Flood Category','==','\'Uncategorised Flood\'']) # Flood type)
Thresholds.append(['Flood Category','!=','\'Geophysical Flood\'']) # Extreme weather
#Thresholds.append(['Total Affected','>=','EMDAT_Filt[\'Total Deaths\']']) # This is necessary for mortality functions
#Thresholds.append(['Total Affected','>','EMDAT_Filt[\'Total Deaths\']']) # This is necessary for mortality functions
Thresholds.append(['Total Deaths','>=',1]) 
Thresholds.append(['No Affected','>',0,'|','No Homeless','>',0]) 
# Thresholds.append(['Adjusted Damage','>',10000])
Thresholds.append(['Mortality','>',0])
# Thresholds.append(['Income','>',0])

EMDAT_Filt = ThreshFilter(EMDAT_Evn,Thresholds) # Use raw (EMDAT_Raw) or event based (EMDataEvn)


# Statistical signifcance tests
import pymannkendall as mk
import numpy as np
from scipy.stats import kstest


XValColumnString = 'Year'
XValues = list(pd.unique(EMDAT_Filt[XValColumnString])) 
NrXprYr = [len(EMDAT_Filt[(EMDAT_Filt[XValColumnString]==yr)]) for yr in XValues]
YValColumnString = 'Total Deaths'  # 'Total Deaths' 'Mortality' 'Total Affected'
TotXprYr = [sum(EMDAT_Filt[YValColumnString][(EMDAT_Filt['Year']==yr)].fillna(0)) for yr in XValues]
AvXprYr = [i/j for i,j in zip(TotXprYr, NrXprYr)]
mk.original_test(TotXprYr)
plt.plot(XValues,AvXprYr)

import numpy as np
print('Beta =:' + str(np.polyfit(TotXprYr,XValues,1)[0]))


# 'Mortality per event
XValColumnString = 'Year'
XValues = list(pd.unique(EMDAT_Filt[XValColumnString])) 
TotXprYr = [np.mean(EMDAT_Filt['Total Deaths'][(EMDAT_Filt['Year']==yr)].fillna(0)/EMDAT_Filt['Total Affected'][(EMDAT_Filt['Year']==yr)].fillna(0)) for yr in XValues]
mk.original_test(TotXprYr)

# Overall mortality
XValColumnString = 'Year'
XValues = list(pd.unique(EMDAT_Filt[XValColumnString])) 
TotXprYr = [sum(EMDAT_Filt['Total Deaths'][(EMDAT_Filt['Year']==yr)].fillna(0))/sum(EMDAT_Filt['Total Affected'][(EMDAT_Filt['Year']==yr)].fillna(0)) for yr in XValues]
mk.original_test(TotXprYr)

# Overall mortality grouped
XValColumnString = 'Year'
XValues = list(pd.unique(EMDAT_Filt[XValColumnString]))
XValuesGrouped = [XValues[n:n+5] for n in range(0, len(XValues), 5)]
TotXprYr = [sum(EMDAT_Filt['Total Deaths'][EMDAT_Filt['Year'].isin(yrs)])/sum(EMDAT_Filt['Total Affected'][EMDAT_Filt['Year'].isin(yrs)]) for yrs in XValuesGrouped]
mk.original_test(TotXprYr)


TotXprYr = [sum(EMDAT_Filt['Total Deaths'][(EMDAT_Filt['Year']==yr)].fillna(0))/sum(EMDAT_Filt['Total Affected'][(EMDAT_Filt['Year']==yr)].fillna(0)) for yr in XValues]
TotXprYr = [np.mean(EMDAT_Filt['Total Deaths'][(EMDAT_Filt['Year']==yr)].fillna(0)/EMDAT_Filt['Total Affected'][(EMDAT_Filt['Year']==yr)].fillna(0)) for yr in XValues]
YValColumnString = 'Mortality'  # 'Total Deaths' 'Mortality' 'Total Affected'


#Test if mortality is lognormal
LogMor = np.log(EMDAT_Filt['Mortality'].fillna(0).tolist()) - np.mean(np.log(EMDAT_Filt['Mortality'].fillna(0).tolist()))
kstest(LogMor,'norm')
plt.hist(LogMor, bins=50)

from numpy.random import seed
from numpy.random import normal, poisson

#set seed (e.g. make this example reproducible)
seed(0)

#generate dataset of 100 values that follow a Poisson distribution with mean=5
data = np.random.randn(1000)


from scipy.stats import f_oneway
 
# Performance when each of the engine
# oil is applied
performance1 = [89, 89, 88, 78, 79]
performance2 = [93, 92, 94, 89, 88]
performance3 = [89, 88, 89, 93, 90]
performance4 = [81, 78, 81, 92, 82]
 
# Conduct the one-way ANOVA
f_oneway(performance1, performance2, performance3, performance4)

 




#%% Figure 1:  Stacked Bar Charts

# Get LHS
#[Fig, Ax1] = GraphOptions(EMDAT_Filt,EMDataPath)

import numpy as np


# Create new filtered datasets for graphing analysis.
Thresholds = []
Thresholds.append(['Year','>=',1975,'&','Year','<=',2022]) # GDP starts at 1971,Income 1961, previous paper used 1975
#Thresholds.append(['Total Damages (\'000 US$)','<',10000,'|','Total Deaths','>',50]) # Include events based on death or damage filter
#Thresholds.append(['Income','<',1000]) # Events on lower income countries
#Thresholds.append(['Disaster Category','==','\'Flood\'']) # Just floods)
Thresholds.append(['Disaster Category','.isin','([\'Storm\',\'Landslide\',\'Drought\',\'Wildfire\',\'Extreme temperature \',\'Flood\'])']) # Ex weather events
#Thresholds.append(['Disaster Category','.isin','([\'Storm\',\'Landslide\',\'Drought\',\'Wildfire\',\'Extreme temperature \'])']) # Ex weather events minus flood

#Thresholds.append(['Flood Category','==','\'Uncategorised Flood\'']) # Flood type)
Thresholds.append(['Flood Category','!=','\'Geophysical Flood\'']) # Extreme weather

#Thresholds.append(['Total Affected','>=','EMDAT_Filt[\'Total Deaths\']']) # This is necessary for mortality functions
#Thresholds.append(['Total Affected','>','EMDAT_Filt[\'Total Deaths\']']) # This is necessary for mortality functions
Thresholds.append(['Total Deaths','>=',1]) 
Thresholds.append(['No Affected','>',0,'|','No Homeless','>',0]) 
# Thresholds.append(['Adjusted Damage','>',10000])
Thresholds.append(['Mortality','>',0])
# Thresholds.append(['Income','>',0])

EMDAT_Filt = ThreshFilter(EMDAT_Evn,Thresholds) # Use raw (EMDAT_Raw) or event based (EMDataEvn)



fig, ax = plt.subplots(1, 2)
fig.set_size_inches(15, 5)

## Chart 1
XValColumnString = 'Year'
XCatColumnString = 'Disaster Category'
XCatValues = list(pd.unique(EMDAT_Filt[XCatColumnString]))
YValColumnString = 'Number of events'
XValues = list(pd.unique(EMDAT_Filt[XValColumnString])) 
# Generate stacked bar chart data
# Generate data for each stack, for the Y-variable
YperX = {}
count = 0
CoverStack = (len(XCatValues)+1)*[len(XValues) *[0]]
for XCatValue in XCatValues:
    count +=1
    YperX[XCatValue] = [len(EMDAT_Filt[(EMDAT_Filt[XCatColumnString]==XCatValue) & (EMDAT_Filt[XValColumnString]==XVal)]) for XVal in XValues]
    CoverStack[count] = np.add(CoverStack[count-1], YperX[XCatValue]).tolist() 
# Plot (stacked) bar chart
colors = {'Original data':'skyblue', 'Updated data':'b'} 
labels = list(colors.keys()) 
ax[0].set_xlabel(XValColumnString,fontsize=18)
ax[0].set_ylabel(YValColumnString,fontsize=18)
ax[0].yaxis.set_tick_params(labelsize=12)
ax[0].xaxis.set_tick_params(labelsize=14)
#ax[0].set_xticks(list(Years[0::5]))
count = 0
for XCatValue in XCatValues:  
    ax[0].bar(XValues, YperX[XCatValue],width = 0.65, bottom=CoverStack[count], label = XCatValue)
    count +=1
ax[0].legend()
lgd = ax[0].legend(loc='upper left', borderaxespad=0.,fontsize=12)


## Chart 2
XValColumnString = 'Year'
XCatColumnString = 'Flood Category'
XCatValues = list(pd.unique(EMDAT_Filt[XCatColumnString]))
XCatValues = list(filter(None, XCatValues))
YValColumnString = 'Number of events'
XValues = list(pd.unique(EMDAT_Filt[XValColumnString])) 
# Generate stacked bar chart data
# Generate data for each stack, for the Y-variable
YperX = {}
count = 0
CoverStack = (len(XCatValues)+1)*[len(XValues) *[0]]
for XCatValue in XCatValues:
    count +=1
    YperX[XCatValue] = [len(EMDAT_Filt[(EMDAT_Filt[XCatColumnString]==XCatValue) & (EMDAT_Filt[XValColumnString]==XVal)]) for XVal in XValues]
    CoverStack[count] = np.add(CoverStack[count-1], YperX[XCatValue]).tolist() 
# Plot (stacked) bar chart
colors = {'Original data':'skyblue', 'Updated data':'b'} 
labels = list(colors.keys()) 
ax[1].set_xlabel(XValColumnString,fontsize=16)
#ax[1].set_ylabel(YValColumnString,fontsize=18)
ax[1].xaxis.set_tick_params(labelsize=14)
#ax[1].set_ylabel(YValColumnString)
#ax[0].set_xticks(list(Years[0::5]))
count = 0
blues = ['lightskyblue', 'deepskyblue', 'dodgerblue', 'navy']
for XCatValue in XCatValues:   
    ax[1].bar(XValues, YperX[XCatValue],width = 0.65, bottom=CoverStack[count], label = XCatValue, color=blues[count])
    count +=1
ax[1].legend()
ax[1].set_ylim(ax[0].get_ylim())
ax[1].set_yticklabels([])
lgd = ax[1].legend(loc='upper left', borderaxespad=0.,fontsize=12)
# Regression line
TotalFloods = [len(EMDAT_Filt[(EMDAT_Filt['Disaster Category']=='Flood') & (EMDAT_Filt['Year']==XVal)]) for XVal in XValues]
#z = np.polyfit(XValues, TotalFloods, 1,full=True)
# lr.fit(XValues, TotalFloods)
SplitYear = 25 # year 2000
z1 = np.polyfit(XValues[0:SplitYear], TotalFloods[0:SplitYear], 1,full=True)
z2 = np.polyfit(XValues[SplitYear-1:-1], TotalFloods[SplitYear-1:-1], 1,full=True)
p1 = np.poly1d(z1[0])
p2 = np.poly1d(z2[0])
ax[1].plot(XValues[0:SplitYear+1],p1(XValues[0:SplitYear+1]),color='red')
ax[1].plot(XValues[SplitYear:-1],p2(XValues[SplitYear:-1]),color='red')
#coefficient_of_dermination = r2_score(XValues,p(XValues))

## Overall
#tit = fig.suptitle("Number of events with 1 or more deaths",fontsize=24) # Change size
plt.subplots_adjust(wspace=0, hspace=0)

# To do: set colours in flood to blues, remove labels and shift lHs
# To do: trend lines

plt.show()


# # Save figure (or not)
SaveFig_YN = input('Save this figure? (y/n): ')
if SaveFig_YN in ['y','Y']:
    #FigName = input('Input figure name: ')
    fig.savefig(r'c:\Users\SafeLevee\EM_DAT\Pictures\Figure1_F1.svg',bbox_inches='tight')
    #fig.savefig(EMDataPath + '\\Pictures\\' + FigName + '.png', bbox_extra_artists=(tit,lgd), bbox_inches='tight')            

# #%%
# TotalFloods = [len(EMDAT_Filt[(EMDAT_Filt['Disaster Category']=='Flood') & (EMDAT_Filt['Year']==XVal)]) for XVal in XValues]

# for year in range(2,45):
#     print(XValues[year])
#     print(year)
#     Years1 = XValues[0:year]
#     Years2 = XValues[year-1:-1]
#     Floods1 = TotalFloods[0:year]
#     Floods2 = TotalFloods[year-1:-1]

#     z1 = np.polyfit(Years1, Floods1, 1,full=True)
#     z2 = np.polyfit(Years2, Floods2, 1,full=True)
#     CombSSE = z1[1] + z2[1]
#     print(CombSSE)
# # 2000 is best splitpoint

#%% Figure 2:  scatter trends

# Create new filtered datasets for graphing analysis.
Thresholds = []
Thresholds.append(['Year','>=',1975,'&','Year','<=',2022]) # GDP starts at 1971,Income 1961, previous paper used 1975
#Thresholds.append(['Total Damages (\'000 US$)','<',10000,'|','Total Deaths','>',50]) # Include events based on death or damage filter
#Thresholds.append(['Income','<',1000]) # Events on lower income countries
Thresholds.append(['Disaster Category','==','\'Flood\'']) # Just floods)
#Thresholds.append(['Disaster Category','.isin','([\'Storm\',\'Landslide\',\'Drought\',\'Wildfire\',\'Extreme temperature \',\'Flood\'])']) # Ex weather events
#Thresholds.append(['Disaster Category','.isin','([\'Storm\',\'Landslide\',\'Drought\',\'Wildfire\',\'Extreme temperature \'])']) # Ex weather events minus flood
#Thresholds.append(['Flood Category','==','\'Uncategorised Flood\'']) # Flood type)
Thresholds.append(['Flood Category','!=','\'Geophysical Flood\'']) # Extreme weather
#Thresholds.append(['Total Affected','>=','EMDAT_Filt[\'Total Deaths\']']) # This is necessary for mortality functions
#Thresholds.append(['Total Affected','>','EMDAT_Filt[\'Total Deaths\']']) # This is necessary for mortality functions
Thresholds.append(['Total Deaths','>=',1]) 
Thresholds.append(['No Affected','>',0,'|','No Homeless','>',0]) 
# Thresholds.append(['Adjusted Damage','>',10000])
Thresholds.append(['Mortality','>',0])
# Thresholds.append(['Income','>',0])

EMDAT_Filt = ThreshFilter(EMDAT_Evn,Thresholds) # Use raw (EMDAT_Raw) or event based (EMDataEvn)



fig, ax = plt.subplots(1, 2)
fig.set_size_inches(15, 5)

# Chart 1
XValColumnString = 'Year'
XValues = list(pd.unique(EMDAT_Filt[XValColumnString]))
YValColumnString = 'Total Deaths'
NrXprYr = [len(EMDAT_Filt[(EMDAT_Filt[XValColumnString]==yr)]) for yr in XValues]
TotXprYr = [sum(EMDAT_Filt[YValColumnString][(EMDAT_Filt['Year']==yr)].fillna(0)) for yr in XValues]
TrendTotXPrYr = np.polyfit(XValues,np.log([x or 1 for x in TotXprYr]), 1) # can't accept 0 values
#print('Beta total deaths is : ' + str(TrendTotXPrYr))

AvXprYr = [i/j for i,j in zip(TotXprYr, NrXprYr)]
TrendAvXPrYr = np.polyfit(XValues,np.log([x or 1 for x in AvXprYr]), 1) # can't accept 0 values
print('Total reduction in fatalities per event over this time : ' + str((np.exp(TrendAvXPrYr[1])*np.exp(TrendAvXPrYr[0]*XValues[0]) - np.exp(TrendAvXPrYr[1])*np.exp(TrendAvXPrYr[0]*XValues[-1]))))

#  Generate plot
ax[0].set_xlabel('Year',fontsize=16)
ax[0].set_ylabel('Fatalities (log scale)',fontsize=16)
ax[0].yaxis.set_tick_params(labelsize=12)
ax[0].xaxis.set_tick_params(labelsize=14)
# Total affected per year
ax[0].scatter(XValues,TotXprYr, s=10, c='b', marker="s", label='Fatalities')
ax[0].plot(XValues,np.exp(TrendTotXPrYr[1])*np.exp(TrendTotXPrYr[0]*np.asarray(XValues)),"b-", label=None) # 'Fatalities trend'
# Average affected per event per year - if applicable              
ax[0].scatter(XValues,AvXprYr, s=10, c='r', marker="s", label='Average fatalities per event')
ax[0].plot(XValues,np.exp(TrendAvXPrYr[1])*np.exp(TrendAvXPrYr[0]*np.asarray(XValues)),"r-", label=None) #'Average fatalities per event (trend)'
lgd = ax[0].legend(borderaxespad=1,fontsize=14)
ax[0].set_yscale('log')

# Chart 2
XValColumnString = 'Year'
XValues = list(pd.unique(EMDAT_Filt[XValColumnString]))
YValColumnString = 'Total Affected'
NrXprYr = [len(EMDAT_Filt[(EMDAT_Filt[XValColumnString]==yr)]) for yr in XValues]
TotXprYr = [sum(EMDAT_Filt[YValColumnString][(EMDAT_Filt['Year']==yr)].fillna(0)) for yr in XValues]
TrendTotXPrYr = np.polyfit(XValues,np.log([x or 1 for x in TotXprYr]), 1) # can't accept 0 values
#print('Beta total affected is : ' + str(TrendTotXPrYr))
AvXprYr = [i/j for i,j in zip(TotXprYr, NrXprYr)]
TrendAvXPrYr = np.polyfit(XValues,np.log([x or 1 for x in AvXprYr]), 1) # can't accept 0 values
print('Total reduction in affected per event over this time : ' + str((np.exp(TrendAvXPrYr[1])*np.exp(TrendAvXPrYr[0]*XValues[0]) - np.exp(TrendAvXPrYr[1])*np.exp(TrendAvXPrYr[0]*XValues[-1]))))

#  Generate plot
ax[1].set_xlabel('Year',fontsize=16)
ax[1].yaxis.set_tick_params(labelsize=12)
ax[1].xaxis.set_tick_params(labelsize=14)
ax[1].set_ylabel('Affected (log scale)',fontsize=16)
# Total affected per year
ax[1].scatter(XValues,TotXprYr, s=10, c='b', marker="s", label='Affected')
ax[1].plot(XValues,np.exp(TrendTotXPrYr[1])*np.exp(TrendTotXPrYr[0]*np.asarray(XValues)),"b-", label=None) # label='Affected (trend)'
# Average affected per event per year - if applicable              
ax[1].scatter(XValues,AvXprYr, s=10, c='r', marker="s", label='Average affected per event')
ax[1].plot(XValues,np.exp(TrendAvXPrYr[1])*np.exp(TrendAvXPrYr[0]*np.asarray(XValues)),"r-", label=None) # label='Average affected per event (trend)'
lgd = ax[1].legend(bbox_to_anchor=(0.85, 0.4), borderaxespad=0.,fontsize=14) #bbox_to_anchor=(1.05, 1), 
ax[1].set_yscale('log')

#Overall
ax[1].set_ylim(ax[0].get_ylim()[0],ax[1].get_ylim()[1])
ax[0].set_ylim(ax[0].get_ylim()[0],ax[1].get_ylim()[1])
#tit = fig.suptitle('Fatalities and affected per year for events with 1 or more deaths', fontsize=24)

plt.show()


# # Save figure (or not)
SaveFig_YN = input('Save this figure? (y/n): ')
if SaveFig_YN in ['y','Y']:
    #FigName = input('Input figure name: ')
    fig.savefig(r'c:\Users\SafeLevee\EM_DAT\Pictures\Figure2_F1.svg',bbox_inches='tight')
    #fig.savefig(EMDataPath + '\\Pictures\\' + FigName + '.png', bbox_extra_artists=(tit,lgd), bbox_inches='tight')            


#%% Figure 3:  Frequency curves

# Create new filtered datasets for graphing analysis.
Thresholds = []
Thresholds.append(['Year','>=',1975,'&','Year','<=',2022]) # GDP starts at 1971,Income 1961, previous paper used 1975
Thresholds.append(['Disaster Category','.isin','([\'Storm\',\'Landslide\',\'Drought\',\'Wildfire\',\'Extreme temperature \',\'Flood\',\'Earthquake\'])'])
Thresholds.append(['Total Deaths','>=',1]) 
Thresholds.append(['No Affected','>',0,'|','No Homeless','>',0]) 
Thresholds.append(['Mortality','>',0])
# Thresholds.append(['Income','>',0])

EMDAT_Filt = ThreshFilter(EMDAT_Evn,Thresholds) # Use raw (EMDAT_Raw) or event based (EMDataEvn)




fig, ax = plt.subplots(1, 2)
fig.set_size_inches(15, 5)



NMarkers = [1,2,5,10,20,50,100,200,500,1000,2000,5000,10000,20000,50000,100000,200000,500000,1000000,2000000,5000000,10000000,20000000,50000000,10000000]

YValColumnString = 'Year'
XValColumnString = 'Total Deaths'

#Chart 1
XCatColumnString = 'Disaster Category'
XCatValues = list(pd.unique(EMDAT_Filt[XCatColumnString]))  
# Visualisation variables
XCatFreq = pd.DataFrame(index=NMarkers, columns=pd.unique(EMDAT_Filt[XCatColumnString]).tolist())
NrYears = float(max(EMDAT_Filt['Year']) - min(EMDAT_Filt['Year']))
# Calculate disaster frequency (Disaster Type)
for XCat in XCatValues:
    for NMark in NMarkers:
        XCatFreq.at[NMark,XCat] = sum(EMDAT_Filt[XValColumnString][EMDAT_Filt[XCatColumnString]==XCat].fillna(0) > NMark)/NrYears
# Plot figure
lines = ["-","--","-.",":","-","--","-.",":","-","--","-.",":","-","--","-.",":","-","--","-.",":","-","--","-.",":"]
markers = ['.','o','v','^','<','>','4','s','p','*','h','H','+','x','X','D','.','o','v','^','<','>','4','s','p','*','h','H','+','x','X','D']
ax[0].set_xlabel('Fatalities (N) - all hazards',fontsize=16)
ax[0].set_ylabel('Annual exceedence frequency \n of event with N fatalities',fontsize=16)
ax[0].yaxis.set_tick_params(labelsize=12)
ax[0].xaxis.set_tick_params(labelsize=14)
count = 0
for XCat in XCatValues:
    ax[0].plot(NMarkers,XCatFreq[XCat].tolist(), linestyle=lines[count], marker=markers[count], label=XCat)
    count +=1        
ax[0].set_xscale('log')
ax[0].set_yscale('log')
ax[0].set_xticks([1,10,100,1000,10000,100000,1000000])
ax[0].set_xticklabels([1,10,100,1000,10000,100000,1000000])
ax[0].set_yticks([0.1,1,10,100])
ax[0].set_yticklabels([0.1,1,10,100])
#lgd = ax.legend(bbox_to_anchor=(1.05, 1), loc=2, borderaxespad=0.)
lgd = ax[0].legend(loc='upper right',fontsize=14)

#Chart 2
# Visualisation variables
XCatColumnString = 'Flood Category'
XCatValues = list(pd.unique(EMDAT_Filt[XCatColumnString]))
XCatValues = [XCatValues[i] for i in [0,2,3,4]]
XCatFreq = pd.DataFrame(index=NMarkers, columns=pd.unique(EMDAT_Filt[XCatColumnString]).tolist())
NrYears = float(max(EMDAT_Filt['Year']) - min(EMDAT_Filt['Year']))
# Calculate disaster frequency (Disaster Type)
for XCat in XCatValues:
    for NMark in NMarkers:
        XCatFreq.at[NMark,XCat] = sum(EMDAT_Filt[XValColumnString][EMDAT_Filt[XCatColumnString]==XCat].fillna(0) > NMark)/NrYears
# Plot figure
lines = ["-","--","-.",":","-","--","-.",":","-","--","-.",":","-","--","-.",":","-","--","-.",":","-","--","-.",":"]
markers = ['.','o','v','^','<','>','4','s','p','*','h','H','+','x','X','D','.','o','v','^','<','>','4','s','p','*','h','H','+','x','X','D']
ax[1].set_xlabel('Fatalities (N) - flood types',fontsize=16)
ax[1].yaxis.set_tick_params(labelsize=12)
ax[1].xaxis.set_tick_params(labelsize=14)
#ax[1].set_ylabel('Annual exceedence frequency of event with impact N')
count = 0
blues = ['lightskyblue', 'deepskyblue', 'dodgerblue', 'navy']
for XCat in XCatValues:
    ax[1].plot(NMarkers,XCatFreq[XCat].tolist(), linestyle=lines[count], marker=markers[count], label=XCat, color=blues[count])
    count +=1        
ax[1].set_xscale('log')
ax[1].set_yscale('log')
ax[1].set_xticks([1,10,100,1000,10000,100000,1000000])
ax[1].set_xticklabels([1,10,100,1000,10000,100000,1000000])
ax[1].set_yticks([0.1,1,10,100])
ax[1].set_yticklabels([0.1,1,10,100])

#lgd = ax.legend(bbox_to_anchor=(1.05, 1), loc=2, borderaxespad=0.)
lgd = ax[1].legend(loc='upper right',fontsize=14)
ax[1].set_ylim(ax[0].get_ylim())

#Overall
#tit = fig.suptitle('Fatality exceedence frequency', fontsize=18)
fig.autofmt_xdate(rotation=45)
# ax[1].set_ylim(ax[0].get_ylim()[0],ax[1].get_ylim()[1])
# ax[0].set_ylim(ax[0].get_ylim()[0],ax[1].get_ylim()[1])
  
plt.show()

# # Save figure (or not)
SaveFig_YN = input('Save this figure? (y/n): ')
if SaveFig_YN in ['y','Y']:
    #FigName = input('Input figure name: ')
    fig.savefig(r'c:\Users\SafeLevee\EM_DAT\Pictures\Figure3.svg',bbox_inches='tight')
    #fig.savefig(EMDataPath + '\\Pictures\\' + FigName + '.png', bbox_extra_artists=(tit,lgd), bbox_inches='tight')            

#%% Figure 4:  Frequency curve 2

# Get LHS
#[Fig, Ax1] = GraphOptions(EMDAT_Filt,EMDataPath) 5,5,3

# fig, ax = plt.subplots(1, 2)
# fig.set_size_inches(15, 5)

XValColumnString = 'Mortality'
XCatColumnString = 'Flood Category'
XCatValues = list(pd.unique(EMDAT_Filt[XCatColumnString])) 
XCatValues = [XCatValues[i] for i in [0,2,3]]


# Get XValue sorted data with associated exceedence probability
XCatXValSorted = []
XCatXValtProbs = []
for XCat in XCatValues:
    XSort = sorted(EMDAT_Filt[XValColumnString][(EMDAT_Filt[XValColumnString].notna()) & (EMDAT_Filt[XCatColumnString]== XCat)].tolist())
    # Now assign probability
    NewProb = []
    for evn in XSort:
        NewProb.append(1-float(XSort.index(evn))/max(float((len(XSort)-1)),1))
    XCatXValSorted.append(XSort)
    XCatXValtProbs.append(NewProb)             
            
# Plot graph
lines = ["-","--","-.",":","-","--","-.",":","-","--","-.",":","-","--","-.",":","-","--","-.",":","-","--","-.",":"]
markers = ['.','o','v','^','<','>','4','s','p','*','h','H','+','x','X','D','.','o','v','^','<','>','4','s','p','*','h','H','+','x','X','D']
fig, ax = plt.subplots()
count = 0
for XCat in XCatValues:
    plt.plot(XCatXValSorted[count],XCatXValtProbs[count], linestyle=lines[count], marker=markers[count], label=XCat)
    count +=1
ax.set_xscale('log')
lgd = ax.legend(bbox_to_anchor=(1.05, 1), loc=2, borderaxespad=0.) 
ax.set_ylabel('Conditional exceedence probability')
ax.set_xlabel('Mortality Fraction')
#tit = fig.suptitle('Impact exceedance probabilities per event - ' + XCatColumnString, fontsize=16)
plt.show()

# # Save figure (or not)
SaveFig_YN = input('Save this figure? (y/n): ')
if SaveFig_YN in ['y','Y']:
    #FigName = input('Input figure name: ')
    fig.savefig(r'c:\Users\SafeLevee\EM_DAT\Pictures\Figure4.svg',bbox_inches='tight')
    #fig.savefig(EMDataPath + '\\Pictures\\' + FigName + '.png', bbox_extra_artists=(tit,lgd), bbox_inches='tight')            


#%% Figure 4:  Boxplot

import math
import numpy as np
from scipy.stats import f_oneway

YearDivision = 2000
XValColumnString = 'Adjusted Income'
#print('Max ' + XValColumnString + ' value is: ' + str(max(EMDAT_Filt[XValColumnString])))
#print('Min ' + XValColumnString + ' is: ' + str(min(EMDAT_Filt[XValColumnString])))
# XValSplitPts = [min(EMDAT_Filt[XValColumnString])]
# XValSplitPts.extend([int(item) for item in input('Define splitting points between these max/min values as a list (e.g. 100,1000,10000): ').split(',')])
# XValSplitPts.append(max(EMDAT_Filt[XValColumnString]))
XValSplitPts = [85.53974821635273, 1046, 4095, 12695, 182992.02312503874]
XCatValues = []
for box in range(0,len(XValSplitPts)-1):
    XCatValues.append(str(round(XValSplitPts[box])) + ' - ' + str(round(XValSplitPts[box+1])))
print('X-axis boxes will be ' + ','.join([str(elem) for elem in XCatValues]))
YValColumnString = 'Mortality'

# Generate Data
DataBox1 = []
DataBox2 = []
for box in range(0,len(XValSplitPts)-1):
    TempList1 = list(EMDAT_Filt[YValColumnString][(EMDAT_Filt[XValColumnString] >= XValSplitPts[box]) & (EMDAT_Filt[XValColumnString] <= XValSplitPts[box+1]) & (EMDAT_Filt['Year'] <= int(YearDivision))])
    TempList1 = -np.log10(TempList1) # log vals
    TempList2 = list(EMDAT_Filt[YValColumnString][(EMDAT_Filt[XValColumnString] >= XValSplitPts[box]) & (EMDAT_Filt[XValColumnString] <= XValSplitPts[box+1]) & (EMDAT_Filt['Year'] > int(YearDivision))])
    TempList2 = -np.log10(TempList2) # log vals
    DataBox1.append([x for x in TempList1 if math.isnan(x) == False])
    DataBox2.append([x for x in TempList2 if math.isnan(x) == False])
    
#ANOVA Tests
#result = sm.stats.anova_lm(model, type=2)
res = f_oneway(DataBox1[0], DataBox1[1], DataBox1[2], DataBox1[3])
print('ANOVA test: Period1, all groups: ' + str(res))
res = f_oneway(DataBox2[0], DataBox2[1], DataBox2[2], DataBox2[3])
print('ANOVA test: Period2, all groups: '+ str(res))
res = f_oneway(sum(DataBox1, []), sum(DataBox2, []))
print('ANOVA test: Both periods: ' + str(res))
res = f_oneway(DataBox1[0], DataBox2[0])
print('ANOVA test: Both periods, group1: ' + str(res))
res = f_oneway(DataBox1[1], DataBox2[1])
print('ANOVA test: Both periods, group2: ' + str(res))
res = f_oneway(DataBox1[2], DataBox2[2])
print('ANOVA test: Both periods, group3: ' + str(res))
res = f_oneway(DataBox1[3], DataBox2[3])
print('ANOVA test: Both periods, group4: ' + str(res))

# Plot
fig, ax = plt.subplots()
pos1 = [x-0.2 for x in list(range(0,len(DataBox1)))]
pos2 = [x+0.2 for x in list(range(0,len(DataBox1)))]
bp1 = plt.boxplot(DataBox1, positions= pos1,widths=0.3, patch_artist=True, manage_ticks=False)
bp2 = plt.boxplot(DataBox2, positions= pos2,widths=0.3, patch_artist=True, manage_ticks=False)       

for element in ['boxes', 'whiskers', 'fliers', 'medians', 'caps']:
    plt.setp(bp1[element], color = "tomato")
for element in ['boxes', 'whiskers', 'fliers', 'medians', 'caps']:
    plt.setp(bp2[element], color = "skyblue")
for patch in bp1['boxes']:
    patch.set(facecolor='white')
for patch in bp2['boxes']:
    patch.set(facecolor='white')      

plt.xticks(list(range(0,len(XValSplitPts)-1)),XCatValues)
LegendAddition = ' (log scale)'
# To do
plt.ylim(7, 0) # Need to fix this as log of something
labels = [item.get_text() for item in ax.get_yticklabels()]
labels = ['0','$10^{-1}$','$10^{-}2$','$10^{-3}$','$10^{-4}$','$10^{-5}$','$10^{-6}$','$10^{-7}$']
ax.set_yticklabels(labels)
LegendAddition = ''
ax.set_ylabel('Mortality Fraction')
ax.set_xlabel('Income groups')
ax.set_xticklabels(['Low','Low \nmiddle','High \nmiddle','High'])

lgd = ax.legend([bp1['boxes'][0], bp2['boxes'][0], bp1['fliers'][0]],['1975-' + str(YearDivision),str(int(YearDivision)+1) + '-2022', 'Outliers'], bbox_to_anchor=(1.05, 1), loc=2, borderaxespad=0.)
#lgd.legendHandles[1].set_color("skyblue")
#tit = fig.suptitle('Mortality distributions', fontsize=16)
#fig.autofmt_xdate(rotation=45)
plt.grid(linestyle='dashed')
plt.show()


# Save figure (or not)
SaveFig_YN = input('Save this figure? (y/n): ')
if SaveFig_YN in ['y','Y']:
    #FigName = input('Input figure name: ')
    fig.savefig(r'c:\Users\SafeLevee\EM_DAT\Pictures\Figure5.svg',bbox_inches='tight')
    #fig.savefig(EMDataPath + '\\Pictures\\' + FigName + '.png', bbox_extra_artists=(tit,lgd), bbox_inches='tight')            


#%% Figure 5:  Scatter fatalities (Bas pics)
import copy
import numpy as np


# Create new filtered datasets for graphing analysis.
Thresholds = []
Thresholds.append(['Year','>=',1975,'&','Year','<=',2022]) # GDP starts at 1971,Income 1961, previous paper used 1975
Thresholds.append(['Disaster Category','==','\'Flood\'']) # Just floods)
Thresholds.append(['Total Affected','>','EMDAT_Filt[\'Total Deaths\']']) # This is necessary for mortality functions
Thresholds.append(['Total Deaths','>=',1]) 
Thresholds.append(['No Affected','>',0,'|','No Homeless','>',0]) 
# Thresholds.append(['Adjusted Damage','>',10000])
Thresholds.append(['Mortality','>',0])
# Thresholds.append(['Income','>',0])

Thresholds1 = copy.deepcopy(Thresholds)
Thresholds2 = copy.deepcopy(Thresholds)
Thresholds3 = copy.deepcopy(Thresholds)
Thresholds4 = copy.deepcopy(Thresholds)
Thresholds2[3] = ['Total Deaths','>=',10]
Thresholds3[3] = ['Total Deaths','>=',100]
Thresholds4[3] = ['Total Deaths','>=',1000]

EMDAT_Filt1 = ThreshFilter(EMDAT_Evn,Thresholds1) # Use raw (EMDAT_Raw) or event based (EMDataEvn)
EMDAT_Filt2 = ThreshFilter(EMDAT_Evn,Thresholds2) # Use raw (EMDAT_Raw) or event based (EMDataEvn)
EMDAT_Filt3 = ThreshFilter(EMDAT_Evn,Thresholds3) # Use raw (EMDAT_Raw) or event based (EMDataEvn)
EMDAT_Filt4 = ThreshFilter(EMDAT_Evn,Thresholds4) # Use raw (EMDAT_Raw) or event based (EMDataEvn)


fig, ax = plt.subplots()
#fig.set_size_inches(15, 5)

# Chart 1
XValColumnString = 'Year'
XValues = list(pd.unique(EMDAT_Filt1[XValColumnString]))
YValColumnString = 'Mortality' # Affected Deaths Mortality
NrXprYr1 = [len(EMDAT_Filt1[(EMDAT_Filt1[XValColumnString]==yr)]) for yr in XValues]
TotXprYr1 = [sum(EMDAT_Filt1[YValColumnString][(EMDAT_Filt1['Year']==yr)].fillna(0)) for yr in XValues]
NrXprYr2 = [len(EMDAT_Filt2[(EMDAT_Filt2[XValColumnString]==yr)]) for yr in XValues]
TotXprYr2 = [sum(EMDAT_Filt2[YValColumnString][(EMDAT_Filt2['Year']==yr)].fillna(0)) for yr in XValues]
NrXprYr3 = [len(EMDAT_Filt3[(EMDAT_Filt3[XValColumnString]==yr)]) for yr in XValues]
TotXprYr3 = [sum(EMDAT_Filt3[YValColumnString][(EMDAT_Filt3['Year']==yr)].fillna(0)) for yr in XValues]
NrXprYr4 = [len(EMDAT_Filt4[(EMDAT_Filt4[XValColumnString]==yr)]) for yr in XValues]
TotXprYr4 = [sum(EMDAT_Filt4[YValColumnString][(EMDAT_Filt4['Year']==yr)].fillna(0)) for yr in XValues]
# TrendTotXPrYr = np.polyfit(XValues,np.log([x or 1 for x in TotXprYr]), 1) # can't accept 0 values
#print('Beta total deaths is : ' + str(TrendTotXPrYr))
NZ = [i for i, e in enumerate(NrXprYr4) if e != 0]

AvXprYr1 = [i/j for i,j in zip(TotXprYr1, NrXprYr1)]
AvXprYr2 = [i/j for i,j in zip(TotXprYr2, NrXprYr2)]
AvXprYr3 = [i/j for i,j in zip(TotXprYr3, NrXprYr3)]
AvXprYr4 = [i/j for i,j in zip(np.take(TotXprYr4, NZ), list(np.take(NrXprYr4, NZ)))]
# NZ = [i for i, e in enumerate(NrXprYr3) if e != 0]

TrendAvXPrYr1 = np.polyfit(XValues,np.log([x or 1 for x in AvXprYr1]), 1) # can't accept 0 values
TrendAvXPrYr2 = np.polyfit(XValues,np.log([x or 1 for x in AvXprYr2]), 1) # can't accept 0 values
TrendAvXPrYr3 = np.polyfit(XValues,np.log([x or 1 for x in AvXprYr3]), 1) # can't accept 0 values
TrendAvXPrYr4 = np.polyfit(list(np.take(XValues, NZ)),np.log([x or 1 for x in AvXprYr4]), 1) # can't accept 0 values

np.take(XValues, NZ)

# print('Total reduction in fatalities per event over this time : ' + str((np.exp(TrendAvXPrYr[1])*np.exp(TrendAvXPrYr[0]*XValues[0]) - np.exp(TrendAvXPrYr[1])*np.exp(TrendAvXPrYr[0]*XValues[-1]))))

#  Generate plot
ax.set_xlabel('Year',fontsize=12)
ax.set_ylabel('Mortality (log scale)',fontsize=12) # Fatalities Affected Mortality
ax.yaxis.set_tick_params(labelsize=8)
ax.xaxis.set_tick_params(labelsize=10)
# Total affected per year
# ax.scatter(XValues,TotXprYr, s=10, c='b', marker="s", label='Fatalities')
# ax.plot(XValues,np.exp(TrendTotXPrYr[1])*np.exp(TrendTotXPrYr[0]*np.asarray(XValues)),"b-", label=None) # 'Fatalities trend'
# Average affected per event per year - if applicable              
ax.scatter(XValues,AvXprYr1, s=8, c='r', marker="o", label='Average Mortality per event with 1 or more fatalities') # Affected
ax.scatter(XValues,AvXprYr2, s=8, c='b', marker="o", label='Average Mortality per event with 10 or more fatalities') # Affected
ax.scatter(XValues,AvXprYr3, s=8, c='g', marker="o", label='Average Mortality per event with 100 or more fatalities') # Affected
ax.scatter(np.take(XValues, NZ),AvXprYr4, s=8, c='c', marker="o", label='Average Mortality per event with 1000 or more fatalities')


ax.plot(XValues,np.exp(TrendAvXPrYr1[1])*np.exp(TrendAvXPrYr1[0]*np.asarray(XValues)),"r-", label=None) #'Average fatalities per event (trend)'
ax.plot(XValues,np.exp(TrendAvXPrYr2[1])*np.exp(TrendAvXPrYr2[0]*np.asarray(XValues)),"b-", label=None) #'Average fatalities per event (trend)'
ax.plot(XValues,np.exp(TrendAvXPrYr3[1])*np.exp(TrendAvXPrYr3[0]*np.asarray(XValues)),"g-", label=None) #'Average fatalities per event (trend)'
ax.plot(XValues,np.exp(TrendAvXPrYr4[1])*np.exp(TrendAvXPrYr4[0]*np.asarray(XValues)),"c-", label=None) #'Average fatalities per event (trend)'

lgd = ax.legend(borderaxespad=1,fontsize=8)
ax.set_yscale('log')


#Overall
# ax.set_ylim(ax.get_ylim(),ax[1].get_ylim()[1])
#tit = fig.suptitle('Fatalities and affected per year for events with 1 or more deaths', fontsize=24)

plt.show()


# # Save figure (or not)
SaveFig_YN = input('Save this figure? (y/n): ')
if SaveFig_YN in ['y','Y']:
    #FigName = input('Input figure name: ')
    fig.savefig(r'c:\Users\SafeLevee\EM_DAT\Pictures\FigureApp_Affected.svg',bbox_inches='tight')
    #fig.savefig(EMDataPath + '\\Pictures\\' + FigName + '.png', bbox_extra_artists=(tit,lgd), bbox_inches='tight') 
    
# Get MK Values
mk.original_test(AvXprYr4)