%-------------------
%GENERAL INFORMATION
%-------------------

% 1. Dataset title: Supporting data belonging to publication: 
% "Near wake of the X-Rotor vertical-axis wind turbine"

% 2. Authorship: 
    % Name: David Bensason
    % Institution: Delft University of Technology 
    % Email: d.y.bensason@tudelft.nl
    % ORCID: 0000-0002-0590-1524

%-------------------
% DESCRIPTION
%-------------------

% This is a README file for an experimental data repository
% on 4TU DOI: 10.1088/1742-6596/2505/1/012040. The data concerns the
% experimental results presented in the manuscript titled 
% "Near wake of the X-Rotor vertical-axis wind turbine". 

% A zip folder contains the .mat files for the phase-locked measurement
% planes entitled "stitched_flowfield_corrected_mat.zip".
 
%% Description of "stitched_flowfield_corrected_mat.zip"
%{
This zip folder includes data structures of the stitched flowfields at each
cross-stream measurement plane and primary rotor phase combination. 
The datafiles are already fully stiched following the method explained in
the manuscript. An example of the file name is as follows: 
Phase_45_x_400.mat, where Phase_# -> indicates the phase-locked position of
the primary rotor at the time of recording, and x_# indicates the
cross-stream measurement plane in mm from the center of the crossbeam.
Negative and positive indicate upwind and downwind measurements from the
origin, respectivley. 

When loading the mat structure using load('Phase_45_x_400.mat'), it will load
a structure named "concat_data" with flow metrics of a 801×801 matrix. 
The definition of the entries of this structure is as follows: 
 
concat_data.x; % streamwise coordinate normalized by rotor radius R = 750mm
concat_data.y; % lateral coordinate normalized by rotor radius R = 750mm
concat_data.z; % axial coordinate normalized by rotor radius R = 750mm
concat_data.Ux; % streamwise velocity normalized by inflow Uinf = 4 m/s;
concat_data.Uy; % lateral velocity normalized by inflow Uinf = 4 m/s;
concat_data.Uz; % axial velocity normalized by inflow Uinf = 4 m/s;
concat_data.vortx; % Streamwise voriticty normalized by c/Uinf, where c = 0.075m is the chord of the blade (m/s)
concat_data.vortmag; % Vorticity magnitude (1/s)
concat_data.vmag; % velocity magnitude (m/s)
%}

