clear variables; close all; clc

% This commented code was used to replace the Prolific ID with a number, in order to maintain anonymity. The columns with new IDs were manually pasted into the Excel files.

% Qualtrics_data = readtable('ChatGPT_September+11,+2023_19.47.xlsx','VariableNamingRule','preserve'); % 2051 x 93 table
% Prolific_data = readtable('Demographic_Data_Prolific_September_2023.xlsx','VariableNamingRule','preserve'); % 2053 x 19 table
% Qualtrics_data2024 = readtable('ChatGPT_March+21,+2024_20.59.xlsx','VariableNamingRule','preserve'); % 2001 x 108 table
% Prolific_data2024 = readtable('Demographic_Data_Prolific_March_2024.csv','VariableNamingRule','preserve'); % 2045 x 20 table
% 
% Qualtrics_data_ID      = Qualtrics_data{:,93};
% Prolific_data_ID       = Prolific_data{:,2};
% Qualtrics_data2024_ID  = Qualtrics_data2024{:,108};
% Prolific_data2024_ID   = Prolific_data2024{:,2};
% 
% [~,~,IDnew]=unique([Qualtrics_data_ID;Prolific_data_ID;Qualtrics_data2024_ID;Prolific_data2024_ID],'stable'); % generate new ID (sequential numbers)
% 
% Qualtrics_data_IDnew     = IDnew(1:length(Qualtrics_data_ID));
% Prolific_data_IDnew      = IDnew(length(Qualtrics_data_ID)+1:length(Qualtrics_data_ID)+length(Prolific_data_ID));
% Qualtrics_data2024_IDnew = IDnew(length(Qualtrics_data_ID)+length(Prolific_data_ID)+1:length(Qualtrics_data_ID)+length(Prolific_data_ID)+length(Qualtrics_data2024_ID));
% Prolific_data2024_IDnew  = IDnew(length(Qualtrics_data_ID)+length(Prolific_data_ID)+length(Qualtrics_data2024_ID)+1:end);

%% Read data from 2023 questionnaire (also referred to as Questionnaire 1)
Qualtrics_data = readtable('ChatGPT_September+11,+2023_19.47.xlsx','VariableNamingRule','preserve'); % 2055 x 93 table
Qualtrics_data(strcmp(Qualtrics_data{:,19},'I do not agree to participate.'),:) = []; % remove participants who did not give consent: 2051 x 93 table
Prolific_data = readtable('Demographic_Data_Prolific_September_2023.xlsx','VariableNamingRule','preserve'); % 2053 x 19 table
[~,reorderIdx] = ismember(str2double(Qualtrics_data{:,93}),Prolific_data{:,2});
Prolific_data_reordered = Prolific_data(reorderIdx,:); % 2051 x 19 table

if any(strcmp(Prolific_data_reordered.Properties.VariableNames,'Status'))
    Prolific_data_reordered.Properties.VariableNames{'Status'} = 'Status_Prolific'; % adjust the header in case of identical headers between Qualtrics_data and Prolific_data
end

All_data = [Qualtrics_data,Prolific_data_reordered]; % append Prolific data
All_data(strcmp(All_data{:,25},'No') | strcmp(All_data{:,25},'I prefer not to respond'),:) = []; % remove participants who responded 'No' or 'I prefer not to respond' to the question 'Have you ever heard of ChatGPT?': 1975 x 112 table

% Extract the second row of Qualtrics headers
Qualtrics_headers = readmatrix('ChatGPT_September+11,+2023_19.47.xlsx','Range','A2:CO2','OutputType','string');

% Initialize X matrix with numerical data
X = NaN(size(All_data,1),size(All_data,2));
for i = 1:size(All_data,2)
    if isnumeric(All_data{:,i})
        X(:,i) = All_data{:,i};
    end
end

%% Read data from 2024 questionnaire (also referred to as Questionnaire 2)
Qualtrics_data2024 = readtable('ChatGPT_March+21,+2024_20.59.xlsx','VariableNamingRule','preserve'); % 2004 x 108 table
Qualtrics_data2024(strcmp(Qualtrics_data2024{:,19},'I do not agree to participate.'),:) = []; % remove participants who did not give consent: 2001 x 108 table
Prolific_data2024 = readtable('Demographic_Data_Prolific_March_2024.xlsx','VariableNamingRule','preserve'); % 2045 x 20 table
[~,reorderIdx2024] = ismember(str2double(Qualtrics_data2024{:,108}),Prolific_data2024{:,2});
Prolific_data_reordered2024 = Prolific_data2024(reorderIdx2024,:); % 2001 x 20 table

if any(strcmp(Prolific_data_reordered2024.Properties.VariableNames,'Status'))
    Prolific_data_reordered2024.Properties.VariableNames{'Status'} = 'Status_Prolific'; % adjust the header in case of identical headers between Qualtrics_data and Prolific_data
end

All_data2024 = [Qualtrics_data2024,Prolific_data_reordered2024]; % append Prolific data
All_data2024(strcmp(All_data2024{:,25},'No') | strcmp(All_data2024{:,25},'I prefer not to respond'),:) = []; % remove participants who responded 'No' or 'I prefer not to respond' to the question 'Have you ever heard of ChatGPT?': 1981 x 128 table

% Extract the second row of Qualtrics headers
Qualtrics_headers2024 = readmatrix('ChatGPT_March+21,+2024_20.59.xlsx','Range','A2:DD2','OutputType','string');

temp=Qualtrics_headers2024(:,35); % switch column 34 and 35 to match the order in the 2023 questionnaire
Qualtrics_headers2024(:,35)=Qualtrics_headers2024(:,34);
Qualtrics_headers2024(:,34)=temp;

temp=All_data2024(:,35); % switch column 34 and 35 to match the order in the 2023 questionnaire
All_data2024(:,35)=All_data2024(:,34);
All_data2024(:,34)=temp;

% Initialize X2024 matrix with numerical data
X2024 = NaN(size(All_data2024,1),size(All_data2024,2));
for i = 1:size(All_data2024,2)
    if isnumeric(All_data2024{:,i})
        X2024(:,i) = All_data2024{:,i};
    end
end

%% Sample size & duration - 2023 questionnaire
disp(['Number of valid participants, 2023 questionnaire: ' num2str(length(X))]) % sample size
disp(['Mean duration in minutes, 2023 questionnaire: ' num2str(mean(X(:,101))/60) ', SD: ' num2str(std(X(:,101))/60),', median: ' num2str(median(X(:,101))/60),', min: ' num2str(min(X(:,101))/60) ', max: ' num2str(max(X(:,101))/60)])
%% Sample size & duration - 2024 questionnaire
disp(newline)
disp(['Number of valid participants 2024 questionnaire: ' num2str(length(X2024))]) % sample size
disp(['Mean duration in minutes, 2024 questionnaire: ' num2str(mean(X2024(:,117))/60) ', SD: ' num2str(std(X2024(:,117))/60),', median: ' num2str(median(X2024(:,117))/60),', min: ' num2str(min(X2024(:,117))/60) ', max: ' num2str(max(X2024(:,117))/60)])
%%
disp(newline)
disp(['Number of respondents who participated in both the 2023 and 2024 questionnaires: ' num2str(sum(ismember(All_data{:,93},All_data2024{:,108})))])
%% Country information - 2023 questionnaire
disp(newline)
disp('2023 Questionnaire: ')
Country = All_data{:,108};
disp(['Number of countries included in the analysis: ' num2str(length(unique(Country))-1)]);
[~,~,ub] = unique(Country);
disp(['Number of participants with unknown country: ' num2str(sum(contains(Country,'EXPIRED')))])
[B,I] = maxk(histcounts(ub,'BinMethod','integers'),7);
country_unique = unique(Country);
if size(country_unique,1) > 0
    disp('Most common countries (after filtering): ')
    disp(country_unique(I)')
    disp(B)
end

%% Country information - 2024 questionnaire
disp(newline)
disp('2024 Questionnaire:')
Country2024 = All_data2024{:,124};
disp(['Number of countries included in the analysis:  ' num2str(length(unique(Country2024))-1)]);

[~,~,ub2024] = unique(Country2024);
disp(['Number of participants with unknown country: ' num2str(sum(contains(Country2024,'EXPIRED')))])
[B2024,I2024] = maxk(histcounts(ub2024,'BinMethod','integers'),7);
country_unique2024 = unique(Country2024);

if size(country_unique2024,1) > 0
    disp('Most common countries (after filtering): ')
    disp(country_unique2024(I2024)')
    disp(B2024)
end

%% Demographics 2023
% Table 3. Responses to the general questions (Questionnaire 1, n = 1975)

disp(' '); disp('G1. What is your age?')
fprintf('Mean age = %.1f years, SD = %.1f\n',mean(X(:,20)),std(X(:,20)));
bins = [18,28,38,48,58,68,78,88];
[counts,~] = histcounts(X(:,20),bins);
percentages = (counts/length(X))*100;
for i = 1:length(bins)-1
    fprintf('Age %d-%d: %d (%.1f%%)\n',bins(i),bins(i+1)-1,counts(i),percentages(i));
end

% Gender
disp(' '); disp('G2. How do you describe yourself?')
categories = {'Female','Male','Non-binary / third gender','Prefer to self-describe','I prefer not to respond'};
Gender = table2array(All_data(:,21));
for i = 1:length(categories)-1
    X(strcmp(Gender,categories{i}),21) = i-1;

    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(strcmp(Gender,categories{i})),(sum(strcmp(Gender,categories{i}))/length(Gender))*100);
end
X(strcmp(Gender,'I prefer not to respond'),21) = -1;
fprintf('%s: %d (%.1f%%)\n','I prefer not to respond',sum(strcmp(Gender,'I prefer not to respond')),(sum(strcmp(Gender,'I prefer not to respond'))/length(Gender))*100);

% Education
disp(' '); disp('G3. What is the highest level of education you have completed?')
categories = {'Less than Primary','Primary','Some Secondary','Secondary','Vocational or Similar','Some University but no degree','University - Bachelors Degree','Graduate or professional degree (MA, MS, MBA, PhD, Law Degree, Medical Degree etc)','I prefer not to respond'};
Education = table2array(All_data(:,23));
X(strcmp(Education,''),23) = NaN;
for i = 1:length(categories)-1
    X(strcmp(Education,categories{i}),23) = i;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(strcmp(Education,categories{i})),(sum(strcmp(Education,categories{i}))/sum(~strcmp(Education,'')))*100);
end
X(strcmp(Education,'I prefer not to respond'),23) = -1;
fprintf('%s: %d (%.1f%%)\n','I prefer not to respond',sum(strcmp(Education,'I prefer not to respond')),(sum(strcmp(Education,'I prefer not to respond'))/sum(~strcmp(Education,'')))*100);

% Occupation
disp(' '); disp('G4. What is your current occupation? (multiple answers possible)')
categories = {'Working full-time','Working part-time','Unemployed and looking for work','A homemaker or stay-at-home parent','Student','Retired','Other','I prefer not to respond'};
Occupation = table2array(All_data(:,24));
for j = 1:length(categories)
    fprintf('%s: %d (%.1f%%)\n',categories{j},sum(contains(Occupation,categories{j})),(sum(contains(Occupation,categories{j}))/length(Occupation))*100);
end

%% Demographics 2024
% Table 3. Responses to the general questions (Questionnaire 2, n = 1981)
disp(' '); disp('G1. What is your age? - 2024')
fprintf('Mean age = %.1f years, SD = %.1f\n',mean(X2024(:,20)),std(X2024(:,20)));
bins = [18,28,38,48,58,68,78,88];
[counts,~] = histcounts(X2024(:,20),bins);
percentages = (counts/length(X2024))*100;
for i = 1:length(bins)-1
    fprintf('Age %d-%d: %d (%.1f%%)\n',bins(i),bins(i+1)-1,counts(i),percentages(i));
end

% Gender
disp(' '); disp('G2. How do you describe yourself? - 2024')
categories = {'Female','Male','Non-binary / third gender','Prefer to self-describe','I prefer not to respond'};
Gender2024 = table2array(All_data2024(:,21));
for i = 1:length(categories)-1
    X2024(strcmp(Gender2024,categories{i}),21) = i-1;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(strcmp(Gender2024,categories{i})),(sum(strcmp(Gender2024,categories{i}))/length(Gender2024))*100);
end
X2024(strcmp(Gender2024,'I prefer not to respond'),21) = -1;
fprintf('%s: %d (%.1f%%)\n','I prefer not to respond',sum(strcmp(Gender2024,'I prefer not to respond')),(sum(strcmp(Gender2024,'I prefer not to respond'))/length(Gender2024))*100);

% Education
disp(' '); disp('G3. What is the highest level of education you have completed? - 2024')
categories = {'Less than Primary','Primary','Some Secondary','Secondary','Vocational or Similar','Some University but no degree','University - Bachelors Degree','Graduate or professional degree (MA, MS, MBA, PhD, Law Degree, Medical Degree, etc.)','I prefer not to respond'};
Education2024 = table2array(All_data2024(:,23));
X2024(strcmp(Education2024,''),23) = NaN;
for i = 1:length(categories)-1
    X2024(strcmp(Education2024,categories{i}),23) = i;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(strcmp(Education2024,categories{i})),(sum(strcmp(Education2024,categories{i}))/sum(~strcmp(Education2024,'')))*100);
end
X2024(strcmp(Education2024,'I prefer not to respond'),23) = -1;
fprintf('%s: %d (%.1f%%)\n','I prefer not to respond',sum(strcmp(Education2024,'I prefer not to respond')),(sum(strcmp(Education2024,'I prefer not to respond'))/sum(~strcmp(Education2024,'')))*100);

% Occupation
disp(' '); disp('G4. What is your current occupation? (multiple answers possible) - 2024')
categories = {'Working full-time','Working part-time','Unemployed and looking for work','A homemaker or stay-at-home parent','Student','Retired','Other','I prefer not to respond'};
Occupation2024 = table2array(All_data2024(:,24));
for j = 1:length(categories)
    fprintf('%s: %d (%.1f%%)\n',categories{j},sum(contains(Occupation2024,categories{j})),(sum(contains(Occupation2024,categories{j}))/length(Occupation2024))*100);
end

%% Table 3. Responses to the general questions (Questionnaire 1, n = 1975) G5-G12

X(:,25)=1; % G5. Have you ever heard of ChatGPT?

disp(' '); disp('G6. How often do you use ChatGPT?')
categories = {'Every day','4-6 days a week','1-3 days a week','About once every 2 weeks','About once a month','Less than once a month','Never','I prefer not to respond'};
Frequency = table2array(All_data(:,26));
for i = 1:length(categories)-1
    X(strcmp(Frequency,categories{i}),26) = i;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(strcmp(Frequency,categories{i})),(sum(strcmp(Frequency,categories{i}))/length(Frequency))*100);
end
X(strcmp(Frequency,'I prefer not to respond'),26) = -1;
fprintf('%s: %d (%.1f%%)\n','I prefer not to respond',sum(strcmp(Frequency,'I prefer not to respond')),(sum(strcmp(Frequency,'I prefer not to respond'))/length(Frequency))*100);

disp(' '); disp('G7. What do you use ChatGPT for? (multiple answers possible)')
categories = {'To generate new texts','To process (summarizing, translating, checking, correcting) texts','To answer questions','To brainstorm or generate ideas','To perform calculations','For enjoyment','To perform specialized tasks (e.g., customer service, sorting emails, coding assistance)','I do not use ChatGPT at all','I prefer not to respond'};
Tasks = table2array(All_data(:,27));
for i = 1:length(categories)
    X(contains(Tasks,categories{i}),27) = i;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(contains(Tasks,categories{i})),(sum(contains(Tasks,categories{i})) / length(Tasks)) * 100);
end

disp(' '); disp('G9. Do you use the paid version of ChatGPT (GPT-4)?')
categories = {'No','Yes','I prefer not to respond'};
Paid = table2array(All_data(:,29));
for i = 1:length(categories)-1
    X(strcmp(Paid,categories{i}),29) = i-1;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(strcmp(Paid,categories{i})),(sum(strcmp(Paid,categories{i}))/length(Paid))*100);
end
X(strcmp(Paid,'I prefer not to respond'),29) = -1;
fprintf('%s: %d (%.1f%%)\n','I prefer not to respond',sum(strcmp(Paid,'I prefer not to respond')),(sum(strcmp(Paid,'I prefer not to respond'))/length(Paid))*100);

disp(' '); disp('G10. Have you ever used a beta feature (''plugins'' or ''advanced data analysis'') within the ChatGPT interface?')
categories = {'No','Yes','I prefer not to respond'};
Plugins = table2array(All_data(:,30));
for i = 1:length(categories)-1
    X(strcmp(Plugins,categories{i}),30) = i-1;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(strcmp(Plugins,categories{i})),(sum(strcmp(Plugins,categories{i}))/length(Plugins))*100);
end
X(strcmp(Plugins,'I prefer not to respond'),30) = -1;
fprintf('%s: %d (%.1f%%)\n','I prefer not to respond',sum(strcmp(Plugins,'I prefer not to respond')),(sum(strcmp(Plugins,'I prefer not to respond'))/length(Plugins))*100);

disp(' '); disp('G12. How often do you use similar models like Bing Chat and Google Bard?')
categories = {'Every day','4-6 days a week','1-3 days a week','About once every 2 weeks','About once a month','Less than once a month','Never','I prefer not to respond'};
Other = table2array(All_data(:,56));
for i = 1:length(categories)-1
    X(strcmp(Other,categories{i}),56) = i;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(strcmp(Other,categories{i})),(sum(strcmp(Other,categories{i}))/length(Other))*100);
end
X(strcmp(Other,'I prefer not to respond'),56) = -1;
fprintf('%s: %d (%.1f%%)\n','I prefer not to respond',sum(strcmp(Other,'I prefer not to respond')),(sum(strcmp(Other,'I prefer not to respond'))/length(Other))*100);

% Table 4. Means, standard deviations, and factor loadings for the ChatGPT Acceptance Scale (Questionnaire 1)
disp(' '); disp('CA1-CA22. ChatGPT.')
CA=table2array(All_data(:,31:52));
Order=[32 33 34 35 36 31 52 42 49 40 48 38 44 46 45 43 51 47 39 37 50 41];
X(:,31:52)=1*strcmp(CA,'Strongly disagree')+2*strcmp(CA,'Disagree')+3*strcmp(CA,'Neither agree nor disagree')+4*strcmp(CA,'Agree')+5*strcmp(CA,'Strongly agree');
X(:,31:52) = X(:,Order);
CA_labels = cell(length(Order),1);
hyphenPos = strfind(Qualtrics_headers{31},'-');
for i = 1:length(Order)
    header = Qualtrics_headers{Order(i)};
    CA_labels{i} = strtrim(header(hyphenPos+1:end));
end
disp(table(CA_labels,mean(X(:,31:52),1)',std(X(:,31:52),[],1)','VariableNames',{'Label','Mean','SD'}))

%% Table 3. Responses to the general questions (Questionnaire 2, n = 1981) G5-G12

X2024(:,25)=1; % G5. Have you ever heard of ChatGPT?

disp(' '); disp('G6. How often do you use ChatGPT? - 2024')
categories = {'Every day','4-6 days a week','1-3 days a week','About once every 2 weeks','About once a month','Less than once a month','Never','I prefer not to respond'};
Frequency = table2array(All_data2024(:,26));
for i = 1:length(categories)-1
    X2024(strcmp(Frequency,categories{i}),26) = i;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(strcmp(Frequency,categories{i})),(sum(strcmp(Frequency,categories{i}))/length(Frequency))*100);
end
X2024(strcmp(Frequency,'I prefer not to respond'),26) = -1;
fprintf('%s: %d (%.1f%%)\n','I prefer not to respond',sum(strcmp(Frequency,'I prefer not to respond')),(sum(strcmp(Frequency,'I prefer not to respond'))/length(Frequency))*100);

disp(' '); disp('G7. What do you use ChatGPT for? (multiple answers possible) - 2024')
categories = {'To generate new texts','To process (summarizing, translating, checking, correcting) texts','To answer questions','To brainstorm or generate ideas','To perform calculations','For enjoyment','To perform specialized tasks (e.g., customer service, sorting emails, coding assistance)','I do not use ChatGPT at all','I prefer not to respond'};
Tasks = table2array(All_data2024(:,27));
for i = 1:length(categories)
    X2024(contains(Tasks,categories{i}),27) = i;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(contains(Tasks,categories{i})),(sum(contains(Tasks,categories{i})) / length(Tasks)) * 100);
end

disp(' '); disp('G9. Do you use the paid version of ChatGPT (GPT-4)? = 2024')
categories = {'No','Yes','I prefer not to respond'};
Paid = table2array(All_data2024(:,28));
for i = 1:length(categories)-1
    X2024(strcmp(Paid,categories{i}),28) = i-1;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(strcmp(Paid,categories{i})),(sum(strcmp(Paid,categories{i}))/length(Paid))*100);
end
X2024(strcmp(Paid,'I prefer not to respond'),28) = -1;
fprintf('%s: %d (%.1f%%)\n','I prefer not to respond',sum(strcmp(Paid,'I prefer not to respond')),(sum(strcmp(Paid,'I prefer not to respond'))/length(Paid))*100);

disp(' '); disp('G10. Have you ever used a beta feature (''plugins'' or ''advanced data analysis'') within the ChatGPT interface? - 2024')
categories = {'No','Yes','I prefer not to respond'};
Plugins = table2array(All_data2024(:,29));
for i = 1:length(categories)-1
    X2024(strcmp(Plugins,categories{i}),29) = i-1;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(strcmp(Plugins,categories{i})),(sum(strcmp(Plugins,categories{i}))/length(Plugins))*100);
end
X2024(strcmp(Plugins,'I prefer not to respond'),29) = -1;
fprintf('%s: %d (%.1f%%)\n','I prefer not to respond',sum(strcmp(Plugins,'I prefer not to respond')),(sum(strcmp(Plugins,'I prefer not to respond'))/length(Plugins))*100);

disp(' '); disp('G12. How often do you use similar models like Bing Chat and Google Bard? - 2024')
categories = {'Every day','4-6 days a week','1-3 days a week','About once every 2 weeks','About once a month','Less than once a month','Never','I prefer not to respond'};
Other = table2array(All_data2024(:,30));
for i = 1:length(categories)-1
    X2024(strcmp(Other,categories{i}),30) = i;
    fprintf('%s: %d (%.1f%%)\n',categories{i},sum(strcmp(Other,categories{i})),(sum(strcmp(Other,categories{i}))/length(Other))*100);
end
X2024(strcmp(Other,'I prefer not to respond'),30) = -1;
fprintf('%s: %d (%.1f%%)\n','I prefer not to respond',sum(strcmp(Other,'I prefer not to respond')),(sum(strcmp(Other,'I prefer not to respond'))/length(Other))*100);
%% Table 4. Means, standard deviations, and factor loadings for the ChatGPT Acceptance Scale (Questionnaire 1)
disp(' '); disp('CA1-CA22. ChatGPT.')
CA=table2array(All_data(:,31:52));
Order=[32 33 34 35 36 31 52 42 49 40 48 38 44 46 45 43 51 47 39 37 50 41];
X(:,31:52)=1*strcmp(CA,'Strongly disagree')+2*strcmp(CA,'Disagree')+3*strcmp(CA,'Neither agree nor disagree')+4*strcmp(CA,'Agree')+5*strcmp(CA,'Strongly agree');
X(:,31:52) = X(:,Order);
CA_labels = cell(length(Order),1);
hyphenPos = strfind(Qualtrics_headers{31},'-');
for i = 1:length(Order)
    header = Qualtrics_headers{Order(i)};
    CA_labels{i} = strtrim(header(hyphenPos+1:end));
end
disp(table(CA_labels,mean(X(:,31:52),1)',std(X(:,31:52),[],1)','VariableNames',{'Label','Mean','SD'}))
%% Table 7. Means, standard deviations, and factor loadings for the ChatGPT Acceptance Scale (Questionnaire 2)

disp(' '); disp('CA1-CA22. ChatGPT - 2024')
CA=table2array(All_data2024(:,31:39));
X2024(:,31:39)=1*strcmp(CA,'Strongly disagree')+2*strcmp(CA,'Disagree')+3*strcmp(CA,'Neither agree nor disagree')+4*strcmp(CA,'Agree')+5*strcmp(CA,'Strongly agree');
Order=31:39;
CA_labels = cell(length(Order),1);
hyphenPos = strfind(Qualtrics_headers2024{31},'-');
for i = 1:length(Order)
    header = Qualtrics_headers2024{Order(i)};
    CA_labels{i} = strtrim(header(hyphenPos+1:end));
end
disp(table(CA_labels,mean(X2024(:,31:39),1)',std(X(:,31:39),[],1)','VariableNames',{'Label','Mean','SD'}))

%% Create the 'Scree plot' for ChatGPT items (Questionnaire 1)
r = corr(X(:,31:52)); % correlation matrix of items
eigr=sort(eig(r),'descend'); % calculate the eigenvalues of the correlation matrix, and sort in descending order
opengl hardware %#ok<OPGLO> % settings for rendering
f=figure; plot(eigr,'k-o','Linewidth',3,'MarkerSize',7,'MarkerFaceColor','k') % plot the eigenvalues
ylabel('Eigenvalue'); xlabel('Eigenvalue number')
fig=gcf;
set(findall(fig,'-property','FontName'),'FontName','Arial','Fontsize',34)
set(gca,'LooseInset', [0.01 0.01 0.01 0.01])
set(gca,'xtick',[1 5:5:100]); set(gca,'ylim',[0 8.1]); set(gca,'xlim',[.5 length(eigr)+.5])
set(gca,'TickDir','out')
f.WindowState = 'maximized';

varexplained = 100*(eigr./sum(eigr)); % calculate the percentage of variance explained
for i = 1:5 % insert the percentage of variance explained, corresponding to the first eigenvalues
    text(i+0.2,eigr(i)+0.03,[sprintf('%0.1f',varexplained(i)) '%'],'color','b','fontsize',20);
end
grid on
%% Create the 'scree plot' for ChatGPT items (Questionnaire 2)
r = corr(X2024(:,31:39)); % correlation matrix of items
eigr=sort(eig(r),'descend'); % calculate eigenvalues of the correlation matrix, and sort in descending order
opengl hardware %#ok<OPGLO> % settings for rendering
f=figure; plot(eigr,'k-o','Linewidth',3,'MarkerSize',7,'MarkerFaceColor','k') % plot the eigenvalues
ylabel('Eigenvalue'); xlabel('Eigenvalue number')
fig=gcf;
set(findall(fig,'-property','FontName'),'FontName','Arial','Fontsize',34)
set(gca,'LooseInset', [0.01 0.01 0.01 0.01])
set(gca,'xtick',1:9); set(gca,'ylim',[0 4.1]); set(gca,'xlim',[.5 length(eigr)+.5])
set(gca,'TickDir','out')
f.WindowState = 'maximized';

varexplained = 100*(eigr./sum(eigr)); % calculate percentage of variance explained
for i = 1:5 % insert the percentage of variance explained, corresponding to the first eigenvalues
    text(i+0.2,eigr(i)+0.03,[sprintf('%0.1f',varexplained(i)) '%'],'color','b','fontsize',20);
end
grid on

%% Table 4. Means, standard deviations, and factor loadings for the ChatGPT Acceptance Scale (Questionnaire 1)
[loadings,~, ~, ~, factor_scores] = factoran(X(:,31:52),2,'rotate','promax'); % perform a maximum likelihood factor analysis
factor_scores=zscore(factor_scores);
X(:,53:54)=factor_scores; % factor scores, placed in columns 53 and 54 of X

disp('Table 4. Means, standard deviations, and factor loadings for the ChatGPT Acceptance Scale (Questionnaire 1)')
disp(table(loadings(:,1), loadings(:,2), 'VariableNames', {'Factor 1: Acceptance', 'Factor 2: Concerns'}))

%% Table 7. Means, standard deviations, and factor loadings for the ChatGPT Acceptance Scale (Questionnaire 2)
[loadings2024,~, ~, ~, factor_scores2024] = factoran(X2024(:,31:36),2,'rotate','promax'); % perform a maximum likelihood factor analysis
factor_scores2024=zscore(factor_scores2024);
X2024(:,[53 54])=factor_scores2024; % factor scores, placed in columns 53 and 54 of X2024 (Acceptance, Concerns)
disp('Table 7. Means, standard deviations, and factor loadings for the ChatGPT Acceptance Scale (Questionnaire 2)')
disp(table(mean(X2024(:,31:36))', std(X2024(:,31:36))', loadings2024(:,1), loadings2024(:,2),'VariableNames', {'Mean','SD','Factor 1: Acceptance', 'Factor 2: Concerns'}))
%% Table 8. Means, standard deviations, and factor loadings for the ChatGPT Opportunism Scale (Questionnaire 2)
[loadingsopportunism2024,~, ~, ~, factor_scoresopportunism2024] = factoran(X2024(:,37:39),1); % perform a maximum likelihood factor analysis
factor_scoresopportunism2024=zscore(factor_scoresopportunism2024);
X2024(:,55)=factor_scoresopportunism2024; % factor scores, placed in columns 53 and 54 of X2024 (Acceptance, Concerns, Opportunism)
disp('Table 8. Means, standard deviations, and factor loadings for the ChatGPT Opportunism Scale (Questionnaire 2)')
disp(table(mean(X2024(:,37:39))', std(X2024(:,37:39))', loadingsopportunism2024,'VariableNames', {'Mean','SD','Opportunism'}))

%% Table S2. Percentage of respondents who indicated that humans surpass machines relative to the total number of respondents excluding those who answered "I prefer not to respond" (n) (Questionnaire 1)
Fitts = table2array(All_data(:,57:67));
Fitts_labels = cell(11,1);
percentHumans = NaN(11,1); 
n = percentHumans;
for i = 57:67
    X(strcmp(Fitts(:,i-56),'Humans surpass machines'),i) = 1;
    X(strcmp(Fitts(:,i-56),'Machines surpass humans'),i) = 2;
    X(strcmp(Fitts(:,i-56),'I prefer not to respond'),i) = -1;
    Fitts_labels{i-56} = strcat('F',num2str(i-56));
    percentHumans(i-56) = (sum(strcmp(Fitts(:,i-56),'Humans surpass machines')) / sum(~strcmp(Fitts(:,i-56),'I prefer not to respond'))) * 100;
    n(i-56) = sum(~strcmp(Fitts(:,i-56),'I prefer not to respond'));
end

disp('Table S2. Percentage of respondents who indicated that humans surpass machines relative to the total number (n) of respondents excluding those who answered “I prefer not to respond” (Questionnaire 1).')
disp(table(Fitts_labels, percentHumans, n, 'VariableNames', {'Label', 'Humans surpass machines (%)', 'n (excl. no response)'}));
XX=X(:,57:67); XX(XX==-1) = NaN;

machineScore = sum(nanzscore(XX(:,1:11)),2,'omitnan'); 
X(:,91) = zscore(machineScore); % Machines score, placed in column 91 of X
%% Table S3. Means and standard deviations (SD) for the items of the Propensity to Trust Machines scale (Questionnaire 1)
disp('Table S3. Means and standard deviations (SD) for the items of the Propensity to Trust Machines scale.')
Trust=table2array(All_data(:,68:73));
X(:,68:73)=1*strcmp(Trust,'Strongly disagree')+2*strcmp(Trust,'Disagree')+3*strcmp(Trust,'Neither agree nor disagree')+4*strcmp(Trust,'Agree')+5*strcmp(Trust,'Strongly agree');
X(:,92) = zscore(mean(nanzscore([X(:,68) X(:,70) X(:,71) X(:,72) X(:,73) 6-X(:,69)]),2)); % Propensity to Trust Machines score, placed in column 92 of X
disp(table({'T1', 'T2', 'T3', 'T4', 'T5', 'T6'}', mean(X(:, 68:73), 'omitnan')', std(X(:, 68:73), 'omitnan')', 'VariableNames', {'Label', 'Mean', 'SD'}));
%% Table 5. Means, standard deviations (SD), and correlation matrix among key variables (Questionnaire 1)
Xg=X(:,21); Xg(Xg>1|Xg<0)=NaN;
Xe=X(:,23); Xe(Xe==-1)=NaN; % Education (G3)
Xc=X(:,26); Xc(Xc==-1)=NaN; Xc=8-Xc; % ChatGPT usage (G6)
Xp=X(:,30); Xp(Xp==-1)=NaN; % Used beta feature (G10)
Xs=X(:,56); Xs(Xs==-1)=NaN; Xs=8-Xs; % Similar models usage (G12)
DataMatrix=[X(:,20) Xg Xe Xc Xp Xs X(:,53:54) X(:,91:92)]; % 53 and 54 are acceptance scales, 91: F1-F11, 92: T1-T6
[r,p]= corr(DataMatrix,'rows','pairwise');

disp('Table 5. Means, standard deviations (SD), and correlation matrix among key variables (Questionnaire 1)')
disp(array2table([mean(DataMatrix,'omitnan')' std(DataMatrix,'omitnan')' r], 'VariableNames', {'Mean','SD','1', '2', '3', '4', '5', '6', '7', '8', '9','10'}, ...
    'RowNames', {'1. Age (years) (G1)', '2. Gender (0: Female / 1: Male) (G2)', '3. Education (1 to 8) (G3)', ...
    '4. ChatGPT usage (1 to 7) (G6)', '5. Used beta feature (0: No / 1: Yes) (G10)',...
    '6. Similar models usage (1 to 7) (G12)','7. ChatGPT Acceptance (CA1–22)', '8. ChatGPT Concerns (CA1–22)',...
    '9. Machines surpass Humans (F1–11)', '10. Propensity to Trust Machines (T1–6)'}));

disp('Table 5. p-values (Questionnaire 1)')
disp(array2table(p, 'VariableNames', {'1', '2', '3', '4', '5', '6', '7', '8', '9','10'}, ...
    'RowNames', {'1. Age (years) (G1)', '2. Gender (0: Female / 1: Male) (G2)', '3. Education (1 to 8) (G3)', ...
    '4. ChatGPT usage (1 to 7) (G6)', '5. Used beta feature (0: No / 1: Yes) (G10)',...
    '6. Similar models usage (1 to 7) (G12)','7. ChatGPT Acceptance (CA1–22)', '8. ChatGPT Concerns (CA1–22)',...
    '9. Machines surpass Humans (F1–11)', '10. Propensity to Trust Machines (T1–6)'}));
disp(['Gender (0: Female / 1: Male) (G2): ' num2str(sum(X(:,21)==0)) ' / ' num2str(sum(X(:,21)==1))])
disp(['Used beta feature (0: No / 1: Yes) (G10): ' num2str(sum(X(:,30)==0)) ' / ' num2str(sum(X(:,30)==1))])
%% Table 9. Means, standard deviations (SD), and correlation matrix among key variables (Questionnaire 2)
Xg=X2024(:,21); Xg(Xg>1|Xg<0)=NaN; % Gender
Xe=X2024(:,23); Xe(Xe==-1)=NaN; % Education (G3)
Xc=X2024(:,26); Xc(Xc==-1)=NaN; Xc=8-Xc; % ChatGPT usage (G6)
Xp=X2024(:,29); Xp(Xp==-1)=NaN; % Used beta feature (G10)
Xs=X2024(:,30); Xs(Xs==-1)=NaN; Xs=8-Xs; % Similar models usage (G12)
DataMatrix2024=[X2024(:,20) Xg Xe Xc Xp Xs X2024(:,53:55)]; % 53: ChatGPT Effectiveness, 54: ChatGPT Concerns, 55: ChatGPT Opportunism
[r2024,p2024]= corr(DataMatrix2024,'rows','pairwise');

disp('Table 9. Means, standard deviations (SD), and correlation matrix among key variables (Questionnaire 2)')
disp(array2table([mean(DataMatrix2024,'omitnan')' std(DataMatrix2024,'omitnan')' r2024], 'VariableNames', {'Mean','SD','1', '2', '3', '4', '5', '6', '7', '8', '9'}, ...
    'RowNames', {'1. Age (years) (G1)', '2. Gender (0: Female / 1: Male) (G2)', '3. Education (1 to 8) (G3)', ...
    '4. ChatGPT usage (1 to 7) (G6)', '5. Used beta feature (0: No / 1: Yes) (G10)',...
    '6. Similar models usage (1 to 7) (G12)','7. ChatGPT Effectiveness (CA1–22)', '8. ChatGPT Concerns (CA1–22)','9. ChatGPT Opportunism (CA1–22)'}));

disp('Table 9. Corresponding p-values')
disp(array2table(p2024, 'VariableNames', {'1', '2', '3', '4', '5', '6', '7', '8', '9'}, ...
    'RowNames', {'1. Age (years) (G1)', '2. Gender (0: Female / 1: Male) (G2)', '3. Education (1 to 8) (G3)', ...
    '4. ChatGPT usage (1 to 7) (G6)', '5. Used beta feature (0: No / 1: Yes) (G10)',...
    '6. Similar models usage (1 to 7) (G12)','7. ChatGPT Effectiveness (CA1–22)', '8. ChatGPT Concerns (CA1–22)','9. ChatGPT Opportunism (CA1–22)'}));
disp(['Gender (0: Female / 1: Male) (G2): ' num2str(sum(X2024(:,21)==0)) ' / ' num2str(sum(X2024(:,21)==1))])
disp(['Used beta feature (0: No / 1: Yes) (G10): ' num2str(sum(X2024(:,29)==0)) ' / ' num2str(sum(X2024(:,29)==1))])
%% Personality - Questionnaire 1
disp('Table 6. Means, standard deviations (SD), and correlation coefficients with between key variables and personality items. Partial correlation coefficients are shown in parentheses (Questionnaire 1)')
disp(' '); disp('P1-P17. Personality.')
Pers=table2array(All_data(:,74:90));
X(:,74:90)=1*strcmp(Pers,'Strongly disagree')+2*strcmp(Pers,'Disagree')+3*strcmp(Pers,'Neither agree nor disagree')+4*strcmp(Pers,'Agree')+5*strcmp(Pers,'Strongly agree');
for i = 74:90
    X(X(:,i)==0, i)=NaN;
end

Corr_p=corr(X(:,74:90),DataMatrix(:,[1:4 7:8 10]),'rows','pairwise');
disp(array2table([mean(X(:,74:90),'omitnan')' std(X(:,74:90),'omitnan')' Corr_p],...
    'VariableNames',{'Mean', 'SD', 'Age (G1)', 'Gender (0: Female, 1: Male) (G2)', 'Education (G3)', 'ChatGPT usage (G6)',...
    'ChatGPT Effectiveness (CA1–22)','ChatGPT Concerns (CA1–22)','Propensity to Trust Machines (T1–6)'}, ...
    'RowNames', {'P1. likes to use clever manipulation …','P2. makes sure my plans benefit myself …','P3. acts on impulse',...
    'P4. plans for the future','P5. is restless at lectures or talks','P6. likes to do frightening things',...
    'P7. … love … new and exciting experiences …','P8. is reserved','P9. is generally trusting','P10. tends to be lazy',...
    'P11. is relaxed, handles stress well','P12. has few artistic interests','P13. is outgoing, sociable',...
    'P14. tends to find fault with others','P15. does a thorough job','P16. gets nervous easily','P17. has an active imagination',}));

%% Test question (Questionnaire 2)
One44 = table2array(All_data2024(:,53));  % What is 6 x 19?
disp(['Number of participants giving the correct answer "114"  : ' num2str(sum(contains(One44,'114')))])
disp(['Number of participants giving the incorrect answer "144": ' num2str(sum(strcmp(One44,'144')))])
disp(['Number of participants giving the incorrect answer "104": ' num2str(sum(strcmp(One44,'104')))])

%% Personality - Questionnaire 2
disp('Table 10. Means, standard deviations (SD), and correlation coefficients with between key variables and personality constructs. Partial correlation coefficients are shown in parentheses (Questionnaire 2)')

Mach = table2array(All_data2024(:,54:62));
Mach = 1*strcmp(Mach,'Strongly disagree')+2*strcmp(Mach,'Disagree')+3*strcmp(Mach,'Neither agree nor disagree')+4*strcmp(Mach,'Agree')+5*strcmp(Mach,'Strongly agree');
M = mean(Mach,2); % Machiavellianism (mean of 9 items)
X2024(:,51) = M; % Store the Machiavellianism score in X2024(:,51) 

Lonely = table2array(All_data2024(:,52));
Lonely = 1*strcmp(Lonely,'Never')+2*strcmp(Lonely,'Hardly ever')+3*strcmp(Lonely,'Occasionally')+4*strcmp(Lonely,'Some of the time')+5*strcmp(Lonely,'Often/always');

disp(' '); disp('BFI - 2024')
BFI=table2array(All_data2024(:,63:106));

% Big Five Inventory (44 items)
X2024(:,63:106)=1*strcmp(BFI,'Strongly disagree')+2*strcmp(BFI,'Disagree')+3*strcmp(BFI,'Neither agree nor disagree')+4*strcmp(BFI,'Agree')+5*strcmp(BFI,'Strongly agree');
BFI = X2024(:,63:106);


R=[6 21 31   2 12 27 37    8 18 23 43   9 24 34  35 41 ]; % item numbers of the BFI-44 that are Reversed items
BFI(:,R)=6-BFI(:,R);
E = BFI(:,1:5:36); % Extraversion
A = BFI(:,2:5:42); % Agreeableness
C = BFI(:,3:5:43); % Conscientiousness
N = BFI(:,4:5:39); % Neuroticism
O = BFI(:,5:5:44); % Openness
E = mean(E,2);
A = mean(A,2);
C = mean(C,2);
N = mean(N,2);
O = mean(O,2);

Corr_p2014=corr([M O C E A N Lonely],DataMatrix2024(:,[1:4 9]),'rows','pairwise');
disp(array2table([mean([M O C E A N Lonely],'omitnan')' std([M O C E A N Lonely],'omitnan')' Corr_p2014],...
    'VariableNames',{'Mean', 'SD', 'Age (G1)', 'Gender (0: Female, 1: Male) (G2)', 'Education (G3)', 'ChatGPT usage (G6)','ChatGPT Opportunism'}, ...
    'RowNames', {'Machiavellianism','Openness','Conscientiousness','Extraversion',...
    'Agreeableness','Neuroticism','Loneliness'}));

%% Questionnaire 1 - Table 6 - partial correlations
disp('Table 6. Means, standard deviations (SD), and correlation coefficients with between key variables and personality items. Partial correlation coefficients are shown in parentheses (Questionnaire 1)')
Corr_p_partial = partialcorr(DataMatrix(:,4), X(:,74:90),[DataMatrix(:,1:3) dummyvar(categorical(All_data{:,108}))],'rows','pairwise')';

disp(array2table([mean(X(:,74:90),'omitnan')' std(X(:,74:90),'omitnan')' Corr_p_partial],...
    'VariableNames',{'Mean', 'SD', 'ChatGPT usage (G6)'}, ...
    'RowNames', {'P1. likes to use clever manipulation …','P2. makes sure my plans benefit myself …','P3. acts on impulse',...
    'P4. plans for the future','P5. is restless at lectures or talks','P6. likes to do frightening things',...
    'P7. … love … new and exciting experiences …','P8. is reserved','P9. is generally trusting','P10. tends to be lazy',...
    'P11. is relaxed, handles stress well','P12. has few artistic interests','P13. is outgoing, sociable',...
    'P14. tends to find fault with others','P15. does a thorough job','P16. gets nervous easily','P17. has an active imagination',}));
%% Questionnaire 2 - Table 10 - partial correlations
disp('Table 10. Means, standard deviations (SD), and correlation coefficients with between key variables and personality constructs. Partial correlation coefficients are shown in parentheses (Questionnaire 2)')
Corr_p_partial2014=partialcorr(DataMatrix2024(:,[4 9]),[M O C E A N Lonely],[DataMatrix2024(:,1:3) dummyvar(categorical(All_data2024{:,124}))],'rows','pairwise')';

disp(array2table([mean([M O C E A N Lonely],'omitnan')' std([M O C E A N Lonely],'omitnan')' Corr_p_partial2014],...
    'VariableNames',{'Mean', 'SD', 'ChatGPT usage (G6)','ChatGPT Opportunism'}, ...
    'RowNames', {'Machiavellianism','Openness','Conscientiousness','Extraversion',...
    'Agreeableness','Neuroticism','Loneliness'}));

%% Table S4. Country-based subgroup analysis (Questionnaire 1)
Country_m=NaN(10,5);
for i=1:5
    Country_m(:,i)=mean(DataMatrix(strcmp(All_data{:,108},country_unique(I(i))),:),'omitnan');
end
tblData = zeros(5, 11);
for i = 1:5
    tblData(i, :) = [size(DataMatrix(strcmp(All_data{:,108},country_unique(I(i))),:),1), Country_m(:,i)'];
end
T = array2table(tblData, 'VariableNames', {'n', 'Age', 'Gender', 'Education', 'ChatGPT_use', 'Used_beta_feature', 'Similar_models_usage', 'ChatGPT_Effectiveness', 'ChatGPT_Concerns', 'Fitts_list_machines_scores', 'Trust_machines_score'});
disp([cell2table(country_unique(I(1:5)), 'VariableNames', {'Country - Questionnaire 1'}),T])
%% Table S5. Country-based subgroup analysis (Questionnaire 2)
Country_m2024=NaN(9,5);
for i=1:5
    Country_m2024(:,i)=mean(DataMatrix2024(strcmp(All_data2024{:,124},country_unique2024(I2024(i))),:),'omitnan');
end
tblData2024 = zeros(5, 10);
for i = 1:5
    tblData2024(i, :) = [size(DataMatrix2024(strcmp(All_data2024{:,124},country_unique2024(I2024(i))),:),1), Country_m2024(:,i)'];
end
T = array2table(tblData2024, 'VariableNames', {'n', 'Age', 'Gender', 'Education', 'ChatGPT_use', 'Used_beta_feature', 'Similar_models_usage', 'ChatGPT_Effectiveness', 'ChatGPT_Concerns', 'ChatGPT_Opportunism'});
disp([cell2table(country_unique2024(I2024(1:5)),'VariableNames', {'Country - Questionnaire 2'}),T])
%% Prepare data points for Figure 1

vars=[20 92 53 54   20 51 53 54]; % Variable numbers for Questionnaire 1 (1-4) and Questionnaire 2 (5-8)

Labels={'Age',...  % Questionnaire 1
    'Propensity to Trust Machines score',... % Questionnaire 1
    'ChatGPT Effectiveness score',... % Questionnaire 1
    'ChatGPT Concerns score',... % Questionnaire 1
    'Age',... % Questionnaire 2
    'Machiavellianism score',... % Questionnaire 2
    'ChatGPT Effectiveness score',... % Questionnaire 2
    'ChatGPT Concerns score'}; % Questionnaire 2

Titles={'Age (Quest. 1)',...
    'Trust machines  (Quest. 1)',...
    'ChatGPT Effectiveness  (Quest. 1)',...
    'ChatGPT Concerns  (Quest. 1)',...
    'Age  (Quest. 2)',...
    'Machiavellianism  (Quest. 2)',...
    'ChatGPT Effectiveness  (Quest. 2)',...
    'ChatGPT Concerns  (Quest. 2)'};

Categories = [17   23    27   31    39   999 % thresholds used for dividing the x-values
            -999   -1  -0.5    0   0.5   999
            -999   -1  -0.5    0   0.5   999
            -999   -1  -0.5    0   0.5   999
             17    23    27   31    39   999
             0.9  1.5   2.5  3.5   4.5   5.1
            -999   -1  -0.5    0   0.5   999
            -999   -1  -0.5    0   0.5  999];

Xc = X(:,26); % ChatGPT usage (Questionnaire 1)
Xc(Xc==-1) = NaN;
Xc = 8 - Xc; % transform to a scale from 1 (Never) to 7 (Every day)

Xc2024 = X2024(:,26); % ChatGPT usage (Questionnaire 2)
Xc2024(Xc2024==-1) = NaN; 
Xc2024 = 8 - Xc2024;  % transform to a scale from 1 (Never) to 7 (Every day)

% preallocate matrices (8 variables x 5 levels)
XMean = NaN(length(vars),5);
YMean = NaN(length(vars),5);
NN = NaN(length(vars),5);
c = NaN(length(vars),5,2);
XMean2024 = NaN(length(vars),5);
YMean2024 = NaN(length(vars),5);
NN2024 = NaN(length(vars),5);
c2024 = NaN(length(vars),5,2);
r = NaN(length(vars),1);
p = NaN(length(vars),1);

for v = 1:length(vars) % loop over variables
    for i = 1:5 % loop over 5 levels
        if v<=4 % Questionnaire 1
            idx = find(X(:,vars(v))>Categories(v,i) & X(:,vars(v))<=Categories(v,i+1) & Xc > 0); % find all indices for level i
            XMean(v,i) = mean(X(idx,vars(v))); % x-mean of data point
            YMean(v,i) = mean(Xc(idx)); % y-mean of data point
            [~,~,c(v,i,:)] = ttest(Xc(idx)); % calculate 95% confidence intervals
            NN(v,i) = length(idx); % store sample size for data point
        elseif v>=5 % Questionnaire 2
            idx2024 = find(X2024(:,vars(v))>Categories(v,i) & X2024(:,vars(v))<=Categories(v,i+1) & Xc2024 > 0); % find all indices for level i
            XMean(v,i) = mean(X2024(idx2024,vars(v))); % x-mean of data point
            YMean(v,i) = mean(Xc2024(idx2024)); % y-mean of data point
            [~,~,c(v,i,:)] = ttest(Xc2024(idx2024)); % calculate 95% confidence intervals
            NN(v,i) = length(idx2024); % store sample size for data point
        end
    end
    if v<=4 % Questionnaire 1
        valid_idx = find( X(:,vars(v))>-999 & X(:,vars(v))<999 & Xc > 0);
        [r(v),p(v)] = corr( X(valid_idx,vars(v)),Xc(valid_idx)); % Calculate correlation coefficient with ChatGPT usage, with corresponding p-value (G6)
    elseif v>=5 % Questionnaire 2
        valid_idx = find( X2024(:,vars(v))>-999 & X2024(:,vars(v))<999 & Xc2024 > 0);
        [r(v),p(v)] = corr( X2024(valid_idx,vars(v)),Xc2024(valid_idx)); % Calculate correlation coefficient with ChatGPT usage (G6)
    end
end

% Figure 1. Means and surrounding 95% confidence intervals of self-reported ChatGPT use (G6, where 1: Never, 2: Less than once a month, 3: About once a month, 4: About once every 2 weeks, 5: 1–3 days a week, 6: 4–6 days a week, 7: Every day) as a function of scores on eight variables selected from Tables 6 and 7.
close all
opengl hardware %#ok<OPGLO>
figure
tiledlayout(2,4,'padding','normal','tilespacing','normal')
set(gcf,'renderer','painters')
for v=1:length(vars)
    
    nexttile
    
    if v<=4 % Questionnaire 1
        plot(XMean(v,:),YMean(v,:),'k-o','Linewidth',3,'markerfacecolor','k');hold on
        plot(XMean(v,:),squeeze(c(v,:,1)),'k:o','Linewidth',2,'markerfacecolor','w')
        plot(XMean(v,:),squeeze(c(v,:,2)),'k:o','Linewidth',2,'markerfacecolor','w')
    elseif v>=5 % Questionnaire 2
        plot(XMean(v,:),YMean(v,:),'-o','Linewidth',3,'color',[3 105 161]/255,'markerfacecolor',[3 105 161]/255);hold on
        plot(XMean(v,:),squeeze(c(v,:,1)),':o','Linewidth',2,'color',[3 105 161]/255,'markerfacecolor','w')
        plot(XMean(v,:),squeeze(c(v,:,2)),':o','Linewidth',2,'color',[3 105 161]/255,'markerfacecolor','w')
    end
    
    % insert correlation coefficient and corresponding p-value
    if p(v)<0.001 && v<=4 % Questionnaire 1
        text(0.5,0.95,['\itr\rm = ' sprintf('%0.2f',r(v)) ', \it{p}\rm < 0.001'],'unit','normalized','horizontalalignment','center','color','k','fontsize',18,'fontname','arial')
    elseif p(v)>=0.001 && v<=4 % Questionnaire 1
        text(0.5,0.95,['\itr\rm = ' sprintf('%0.2f',r(v)) ', \it{p}\rm = ' sprintf('%0.3f',p(v))],'unit','normalized','horizontalalignment','color','k','fontsize',18,'fontname','arial')
    elseif p(v)<0.001 && v>=5 % Questionnaire 2
        text(0.5,0.95,['\itr\rm = ' sprintf('%0.2f',r(v)) ', \it{p}\rm < 0.001'],'unit','normalized','horizontalalignment','center','color',[3 105 161]/255','fontsize',18,'fontname','arial')
    elseif p(v)>=0.001 && v>=5 % Questionnaire 2
        text(0.5,0.95,['\itr\rm = ' sprintf('%0.2f',r(v)) ', \it{p}\rm = ' sprintf('%0.3f',p(v))],'unit','normalized','horizontalalignment','color',[3 105 161]/255','fontsize',18,'fontname','arial')
    end

    ylabel('ChatGPT usage')
    
    if v<=4 % Questionnaire 1
        xlabel(Labels(v),'color','k')
    else % Questionnaire 2
        xlabel(Labels(v),'color',[3 105 161]/255)
    end
    
    grid on

    if ismember(v,[1 5]) % Age
        set(gca,'xlim',[18 53])
    end
    if ismember(v,[2:4 7 8]) % Variables that have been standaridized (z-scores)
        set(gca,'xlim',[-2 1.4])
    end
    if ismember(v,6) % Machiavellianism
        set(gca,'xlim',[1 5])
    end

    set(gca,'xtick',Categories(v,2:5))
    set(gca,'ticklength',[0.015 0.015],'tickdir','out')
    set(gca,'ylim',[1 7]);
    
    if v<=4 % axis color - Questionnaire 1
        set(gca,'xcolor','k')
        set(gca,'ycolor','k')
    else % axis color - Questionnaire 2
        set(gca,'xcolor',[3 105 161]/255)
        set(gca,'ycolor',[3 105 161]/255)
    end

    for i=1:5 % insert the sample size per data point
        text(XMean(v,i),c(v,i,2)+0.3,num2str(NN(v,i)),'horizontalalignment','center','color',[.5 .5 .5]','fontsize',16,'fontname','arial')
    end

end

fig=gcf;set(findall(fig,'type','axes'),'FontName','Arial','Fontsize',18)
set(gca,'LooseInset', [0.01 0.01 0.01 0.01])
