save_heroku=0;
load_heroku=0;
save_processed_heroku=0; % load_heroku should be set to 1, if save_processed_heroku==1
load_processed_heroku=1;

appen_indices = [15,... % 1. Instructions understood
    33,...              % 2. Gender
    32,...              % 3. Age
    14,...              % 4. Age of obtaining driver's license
    34,...              % 5. Primary mode of transportation
    29,...              % 6. How many times in past 12 months did you drive a vehicle
    13,...              % 7. Mileage
    16,...              % 8. Number of accidents
    9,...               % 9. Country
    17,...              % 10. DBQ1
    18,...              % 11. DBQ2
    19,...              % 12. DBQ3
    20,...              % 13. DBQ4
    21,...              % 14. DBQ5
    22,...              % 15. DBQ6
    23,...              % 16. DBQ7
    4,...               % 17. Start date and time
    2,...               % 18. End date and time
    8,...               % 19. Worker ID from Appen
    31,...              % 20. Worker code (code the participant receives at the end of the experiment)
    12];                % 21. IP

appen_file='survey_data.csv';
comments_file='Comments coding.xlsx';
num_stimuli=56; % Number of stimuli seen by each participant
num_stimuli_block=4; % A block is a data storage block in the Heroku data
code_pattern='Q6\d+\s?BV\d+\s?2M'; % Code pattern of the Worker code
%%
if save_heroku==1
    disp([datestr(now, 'HH:MM:SS.FFF') ' - Start of importing data']);
    raw_heroku1 = readmatrix('data_1.xlsx','outputtype','string','NumHeaderLines',0);
    raw_heroku2 = readmatrix('data_2.xlsx','outputtype','string','NumHeaderLines',0);
    raw_heroku2(:,5422:5741)=raw_heroku1(end,end); % Fill with 'missing' to make sure that the two data files have the same number of columns
    raw_heroku=[raw_heroku1;raw_heroku2]; % Append the two files to create 1 file 'raw_heroku'
    save('raw_heroku.mat','raw_heroku','-v7.3'); % Save raw_heroku as mat-file 'raw_heroku.mat'
end
if load_heroku==1
    load('raw_heroku.mat') % load raw_heroku.mat
    %% Check for duplicates in the database
    duplicate=NaN(size(raw_heroku,1),1);
    for i=2:size(raw_heroku,1) % loop over all rows and look for duplicate rows
        duplicate(i)=strcmp(raw_heroku(i,2),raw_heroku(i-1,2))&&...
            strcmp(raw_heroku(i,3),raw_heroku(i-1,3))&&...
            strcmp(raw_heroku(i,4),raw_heroku(i-1,4))&&...
            strcmp(raw_heroku(i,5),raw_heroku(i-1,5))&&...
            strcmp(raw_heroku(i,6),raw_heroku(i-1,6))&&...
            strcmp(raw_heroku(i,7),raw_heroku(i-1,7))&&...
            strcmp(raw_heroku(i,8),raw_heroku(i-1,8))&&...
            strcmp(raw_heroku(i,9),raw_heroku(i-1,9))&&...
            strcmp(raw_heroku(i,10),raw_heroku(i-1,10));
    end
    raw_heroku(duplicate==1,:)=[]; % remove duplicate rows
end

%% Read Appen data
Comments_coding=readtable(comments_file, 'ReadVariableNames', false);
Comments_coding=table2cell(Comments_coding);
raw_appen = readtable(appen_file, 'ReadVariableNames', false); % import Excel file with Appen data (i.e., responses to questionnaire items)
raw_appen = table2cell(raw_appen); % Convert to cell array
disp([datestr(now, 'HH:MM:SS.FFF') ' - Imported data from file with appen data ' appen_file]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - End of importing data']);

%%% Process Appen data
disp([datestr(now, 'HH:MM:SS.FFF') ' - Start of processing appen data']);
X=NaN(size(raw_appen,1),24); % Allocate matrix with NaNs
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents in appen data = ' num2str(size(raw_appen, 1))])

found_values=raw_appen(:,appen_indices(1)); % Instructions understood
X(:,1)=1*strcmp(found_values,'no')+2*strcmp(found_values,'yes');

found_values=raw_appen(:,appen_indices(2)); % Gender
X(:,2)=1*strcmp(found_values,'female') + 2*strcmp(found_values,'male') - 1*strcmp(found_values,'i_prefer_not_to_respond');

found_values=raw_appen(:,appen_indices(3)); % age
for i=1:size(found_values,1)
    try if strcmp(found_values(i),'?')
            X(i,3)=NaN;
        else
            X(i,3)=cell2mat(found_values(i));
        end
    catch error
        X(i,3)=NaN;
    end
end
X(X(:,3)>110,3)=NaN; % the age people who report an age greater than 110 years is set to NaN

found_values=raw_appen(:,appen_indices(4)); % age of obtaining driver's license
for i=1:size(found_values,1)
    try if strcmp(found_values(i),'?')
            X(i,4)=NaN;
        else
            X(i,4)=cell2mat(found_values(i));
        end
    catch error
        X(i,4)=NaN;
    end
end
X(X(:,4)>110,4)=NaN; % the years of driver's license of people who report a number greater than 110 years is set to NaN

found_values=raw_appen(:,appen_indices(5)); % What is your primary mode of transportation?
X(:,5)= 1*strcmp(found_values,'private_vehicle') ...
    + 2*strcmp(found_values,'public_transportation') ...
    + 3*strcmp(found_values,'motorcycle') ...
    + 4*strcmp(found_values,'walkingcycling') ...
    + 5*strcmp(found_values,'other') ...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');

found_values=raw_appen(:,appen_indices(6)); % On average, how often did you drive a vehicle in the last 12 months?
X(:,6)=1*strcmp(found_values,'never') ...
    + 2*strcmp(found_values,'less_than_once_a_month') ...
    + 3*strcmp(found_values,'once_a_month_to_once_a_week') ...
    + 4*strcmp(found_values,'1_to_3_days_a_week') ...
    + 5*strcmp(found_values,'4_to_6_days_a_week') ...
    + 6*strcmp(found_values,'every_day') ...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');

found_values=raw_appen(:,appen_indices(7)); % About how many kilometers (miles) did you drive in the last 12 months?
X(:,7)=1*strcmp(found_values,'0_km__mi') ...
    + 2*strcmp(found_values,'1__1000_km_1__621_mi') ...
    + 3*strcmp(found_values,'1001__5000_km_622__3107_mi') ...
    + 4*strcmp(found_values,'5001__15000_km_3108__9321_mi') ...
    + 5*strcmp(found_values,'15001__20000_km_9322__12427_mi') ...
    + 6*strcmp(found_values,'20001__25000_km_12428__15534_mi') ...
    + 7*strcmp(found_values,'25001__35000_km_15535__21748_mi') ...
    + 8*strcmp(found_values,'35001__50000_km_21749__31069_mi') ...
    + 9*strcmp(found_values,'50001__100000_km_31070__62137_mi') ...
    + 10*strcmp(found_values,'more_than_100000_km_more_than_62137_mi') ...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');

found_values=string(raw_appen(:,appen_indices(8))); % How many accidents were you involved in when driving a car in the last 3 years?
% (please include all accidents, regardless of how they were caused, how slight theywere, or where they happened)
X(:,8)=1*strcmp(found_values,'0') ...
    + 2*strcmp(found_values,'1') ...
    + 3*strcmp(found_values,'2') ...
    + 4*strcmp(found_values,'3') ...
    + 5*strcmp(found_values,'4') ...
    + 6*strcmp(found_values,'5') ...
    + 9*strcmp(found_values,'more_than_5') ...
    - 1*ismissing(found_values);

found_values=raw_appen(:,appen_indices(9)); % Country
Country=cell(size(X,1),1);
for i=1:size(found_values,1)
    try
        Country(i)=unique(found_values(i));
    catch error
        Country(i)={'NaN'};
    end
end

found_values=raw_appen(:,appen_indices(10:16)); % 7 violation items from the Driver Behaviour Questionnaire (DBQ)
X(:,9:15)=1*strcmp(found_values,'0_times_per_month') ...
    + 2*strcmp(found_values,'1_to_3_times_per_month') ...
    + 3*strcmp(found_values,'4_to_6_times_per_month') ...
    + 4*strcmp(found_values,'7_to_9_times_per_month') ...
    + 5*strcmp(found_values,'10_or_more_times_per_month')...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');

X(X<0)=NaN; % set -1 responses (prefer not to respond) to NaN

% Study completion time
for i=1:size(raw_appen, 1) % loop over all rows in the Appen data
    starttime=datenum(raw_appen{i,appen_indices(17)});
    endtime=datenum(raw_appen{i,appen_indices(18)});
    X(i,16)=starttime; % store start time
    X(i,17)=endtime; % store end time
    X(i,18)=round(2400*36*(endtime - starttime)); % compute the study completion time
end

disp([datestr(now, 'HH:MM:SS.FFF') ' - Study completion time mean (minutes) - before filtering = ' num2str(mean(X(:,18)/60))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Study completion time median (minutes) - before filtering = ' num2str(median(X(:,18)/60))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Study completion time SD (minutes) - before filtering = ' num2str(std(X(:,18)/60))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - First survey start date - before filtering = ' datestr(min(X(:,16)))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Last survey end date - before filtering = ' datestr(max(X(:,17)))]);

% Worker ID from Appen
found_values=raw_appen(:,appen_indices(19));
for i=1:size(found_values,1)
    try if strcmp(found_values(i),'?')
            X(i,19)=NaN;
        else
            X(i,19)= cell2mat(found_values(i));
        end
    catch error
        X(i,19)=NaN;
    end
end

disp([datestr(now, 'HH:MM:SS.FFF') ' - End of processing appen data']);
%% Process Heroku data

num_in_row = 1000; % assumed maximum possible number of values for 1 stimulus
RT   = NaN(size(raw_appen,1), num_stimuli, num_in_row); % reaction time values
RP   = NaN(size(raw_appen,1), num_stimuli); % question responses (slider question)
StimulusIDs  = NaN(size(raw_appen,1), num_stimuli); % Stimuli shown (number of participants x number of stimuli matrix)
found_values = zeros(size(raw_appen,1),1+num_stimuli/num_stimuli_block); % Flags for blocks that were found. The number of blocks equals num_stimuli/num_stimuli_block
TrialDuration  = NaN(size(raw_appen,1), num_stimuli); % Trial durations (number of participants x number of stimuli matrix)
cheater_worker_codes=[];  % store worker_codes of cheaters
disp([datestr(now, 'HH:MM:SS.FFF') ' - Start of processing heroku data']);

if save_processed_heroku==1
    for row_heroku=1:size(raw_heroku,1) % loop over rows in Heroku data
        if mod(row_heroku,100)==0 % Display progress every 100 rows
            disp([datestr(now, 'HH:MM:SS.FFF') ' - Processing row ' ...
                num2str(row_heroku) ' in heroku data ']);
        end
        RT_row           = NaN(num_stimuli_block,num_in_row);  % initialize values for row
        RP_row           = NaN(num_stimuli_block,1);           % initialize values for row
        Start_time_row   = NaN(num_stimuli_block,1);           % initialize values for row
        End_time_row     = NaN(num_stimuli_block,1);           % initialize values for row
        stimuli_id_row   = NaN(num_stimuli_block,1);           % initialize values for row
        clear Time_elapsed_string
        group_choice = -1;  % group choice value before assigning to X
        mapping_q = -1;  % Response to mapping question
        extracted_row = rmmissing(raw_heroku(row_heroku,:)); % row of data in heroku
        counter_rt = 0; % counter for reaction time
        counter_rp = 0; % counter for slider question answers
        counter_stimuli_id = 0; % counter for stimuli IDs
        counter_time_elapsed= 0; % counter of time elapsed
        rts_detected = false; % flag for starting to record RTs of stimulus
        heroku_code = '';  % worker_code in heroku data
        
        for cell_counter=1:length(extracted_row) % loop over the cells of the selected row
            
            cell_row=extracted_row{cell_counter}; % extract value from cell
            
            if contains(cell_row(1:4),'rts:') % start of rt values
                rts_detected = true; % flag to start recording RTs from stimulus
                counter_rt = 0; % reset countrer of RTs for stimulus
                endtimecell=extracted_row{cell_counter-3};
                End_time_row(counter_stimuli_id + 1, 1) = sscanf(endtimecell(1+max(strfind(endtimecell,':')):end),'%f'); % Store time elapsed in a single vector for row (not per block)
                if cell_counter-11>0
                starttimecell=extracted_row{cell_counter-11};
                Start_time_row(counter_stimuli_id + 1, 1) = sscanf(starttimecell(1+max(strfind(starttimecell,':')):end),'%f'); % Store time elapsed in a single vector for row (not per block)
                else
                Start_time_row(counter_stimuli_id + 1, 1) = NaN; % Store time elapsed in a single vector for row (not per block)
                end
            end
            % Keypress time
            if rts_detected
                if contains(cell_row,'"rt"') && rts_detected % keypress time found
                    counter_rt = counter_rt + 1;
                    RT_row(counter_stimuli_id + 1, counter_rt) = sscanf(cell_row(1+max(strfind(cell_row,':')):end),'%f'); % Store RT in RT_row
                    continue
                end
            end
            
            if contains(cell_row,'<strong>towards') % I prefer the <strong>towards me when stopping, and away from me when the car continues driving</strong>
                mapping_q = 0;
                continue
            end
            
            if contains(cell_row,'<strong>away') % I prefer the <strong>away from me when stopping, and towards me when the car continues driving</strong>
                mapping_q = 1;
                continue
            end
            
            if contains(cell_row(1:4),'resp') % Response to slider question found
                counter_rp = counter_rp + 1;
                RP_row(counter_rp) = sscanf(cell_row(1+min(strfind(cell_row,'"')):-1+max(strfind(cell_row,'"'))),'%f'); % Store response to slider question in RP_row
                continue
            end
            
            % Worker code (code the participant receives at the end of the experiment)
            if contains(cell_row,'"worker_code"')% Worker_code found
                code_regex = regexp(cell_row, code_pattern, 'match');
                heroku_code = code_regex(1);
                continue
            end
            
            % Experiment group
            if contains(cell_row,'group_') % Experiment group found
                group_choice = sscanf(cell_row(1+max(strfind(cell_row,':')):end),'%f');
                continue
            end
            
            if contains(cell_row,'stimulus:"[\"')
                rts_detected = false; % The stimulus ID is logged when the end of the RT recordings for the stimulus have been reached
                counter_stimuli_id = counter_stimuli_id + 1;
                stimuli_id_row(counter_stimuli_id) = sscanf(cell_row(1+min(strfind(cell_row,'_')):-1+max(strfind(cell_row,'.mp4'))),'%f');
                continue
            end
        end
        
        row_appen_matched=find(strcmp(heroku_code, raw_appen(:,appen_indices(20)))); % Find occurences of the Heroku Worker Code in the Appen data
        if ~isempty(row_appen_matched) % if the Heroku code is found in the Appen data
            if size(row_appen_matched, 1) > 1 % if the Heroku code is found more than once in the Appen data, this worker is labelled as a cheater
                if ~any(strcmp(cheater_worker_codes, heroku_code)) % If the Worker Code was not marked as a cheater before, then add to the list of cheaters
                    cheater_worker_codes = [cheater_worker_codes, heroku_code]; %#ok<AGROW>
                end
            end
            
            row_appen_matched=row_appen_matched(1); % Use only the first occurrence of Heroku Worker Code
            
            if found_values(row_appen_matched, 1) == 0 % If cell in found_values == 0, then it means that it is the first block for this participant
                block_number = 1;
                found_values(row_appen_matched, 1) = 1; 
                if group_choice ~= -1 % Experiment group. if -1, default value was not changed
                    X(row_appen_matched, 20) = group_choice; % Store Experiment Group
                end
                
                X(row_appen_matched, 23) = 1; % Flag that row was matched
            else % Not the first block (2nd - nth block)
                block_number = find(found_values(row_appen_matched,:),1,'last')+1; % determine block number from last indexed block
                found_values(row_appen_matched, block_number) = 1; % update cell in matrix of processed blocks
            end
            
            if counter_stimuli_id < num_stimuli_block || counter_stimuli_id > num_stimuli_block % Unexpected number of blocks found in Heroku row
                disp([datestr(now, 'HH:MM:SS.FFF') ...
                    ' - WARNING: ' ...
                    num2str(counter_stimuli_id) ...
                    ' values detected in row_heroku=' ...
                    num2str(row_heroku) ...
                    '; block_number=' ...
                    num2str(block_number) ...
                    '; database row id =' ...
                    char(extracted_row(1))]);
                if (counter_stimuli_id < num_stimuli_block) % fewer values than limit
                    number_of_blocks_to_store = counter_stimuli_id;
                else % more values than limit
                    number_of_blocks_to_store = num_stimuli_block;
                end
            else % expected number of datapoints found
                number_of_blocks_to_store = counter_stimuli_id;
            end
            
            startblock = block_number * num_stimuli_block - (num_stimuli_block - 1); % index of first block number
            endblock = startblock + (number_of_blocks_to_store - 1);                 % index of last block number
            
            RT(row_appen_matched, startblock:endblock, :)   = RT_row(1:number_of_blocks_to_store, 1:num_in_row);   % Store in matrix
            RP(row_appen_matched, startblock:endblock)      = RP_row(1:number_of_blocks_to_store);                 % Store in matrix
            
            TrialDuration(row_appen_matched, startblock:endblock) = End_time_row(1:number_of_blocks_to_store)-Start_time_row(1:number_of_blocks_to_store); 
            StimulusIDs(row_appen_matched, startblock:endblock) = stimuli_id_row(1:number_of_blocks_to_store);         % add stimuli ids as shown
            if mapping_q ~= -1 % mapping question. if -1, default value was not changed, hence no change in this row
                X(row_appen_matched, 22) = mapping_q; % add mapping question
            end
        end
    end
    disp([datestr(now, 'HH:MM:SS.FFF') ' - End of processing heroku data']);
    save('processed_heroku2.mat','X', 'Country','RT','RP','StimulusIDs','TrialDuration','cheater_worker_codes','-v7.3');
end
if load_processed_heroku==1
    load('processed_heroku2.mat')
end

%%
ok1=StimulusIDs>0&RP>=0; % trial data exists
ok2=~(TrialDuration<10000); % trial does not last shorter than 10000 ms
ok3=~(nanmax(RT,[],3)>TrialDuration); %#ok<*NANMAX> % maximum observed RT does not exceed observed trial duration

TrialDurationEstimated=TrialDuration;
TrialDurationEstimated(TrialDurationEstimated<10000)=NaN; % if a trial duration is found to be negative, then set to NaN

% In about 10% of the trials, the trial duration could not be determined
% because 'elapsed time' was not logged in that row. 
% For these trials, estimate the trial duration using a median substitution for each participant 
% This is a reasonable assumption as the trial durations show strong consistency per person
for i=1:size(TrialDurationEstimated,1) % loop over participants
    TrialDurationEstimated(i,isnan(TrialDurationEstimated(i,:)))=nanmedian(TrialDurationEstimated(i,1:num_stimuli));  %#ok<*NANMEDIAN>
end
TrialDurationEstimated=TrialDurationEstimated(:,1:num_stimuli); % final trial duration matrix
%%

invalid1 = find(X(:,1)==1); % respondents who did not read instructions
invalid2 = find(X(:,3)<18); % respondents who indicated they are under 18 years old
invalid3 = find(X(:,18)<300); % respondents who took less than 5 min to complete
invalid4 = find(X(:,23)~=1); % respondents with no match between Appen and Heroku
invalid5 = find(sum(~isnan(StimulusIDs'))' < num_stimuli/2); % participants that were shown fewer than half of stimuli

pp_multiple_ips=NaN(size(X(:,1))); % Find rows with identical IP addresses
ip_appen=NaN(size(raw_appen,1),1); % IP address in Appen data
for i=1:size(raw_appen,1)
    try
        ip_appen(i)=str2double(strrep(raw_appen(i,appen_indices(21)),'.','')); % reduce IP addresses of appen data to a single number
    catch
        ip_appen(i)=cell2mat(raw_appen(i,appen_indices(21)));
    end
end
for i=1:size(X,1) % go over rows in appen data
    found_ips=find(ip_appen==ip_appen(i)); % IPs for the value in question
    if length(found_ips)==1 % if the IP address occurs only once
        pp_multiple_ips(i)=1; % only IP found, so keep
    elseif length(found_ips)>1 % if the IP addres occurs more than once
        pp_multiple_ips(found_ips(1))=1; % keep the first survey for that IP address
        pp_multiple_ips(found_ips(2:end))=2; % do not keep the other ones
    end
end

invalid6=find(pp_multiple_ips>1); % respondents who completed the survey more than once, i.e., remove the doublets
invalid7=find(sum(TrialDurationEstimated'<12000)'<num_stimuli*0.75); % 
invalid7=setdiff(invalid7,invalid5); 
invalid8=unique([find(sum(ok2'==0)>1) find(sum(ok3'==0)>1)])'; % strange things in trial durations; remove participant if it happens more than once
invalid = unique([invalid1;invalid2;invalid3;invalid4;invalid5;invalid6;invalid7;invalid8]); % combine invalid rows
%%
X(invalid,:)=[]; % remove invalid respondents
Country(invalid)=[]; % remove invalid countries
Comments_coding(invalid,:)=[]; % remove invalid countries
RT(invalid,:,:)=[]; % remove invalid data
RP(invalid,:)=[]; % remove invalid data
StimulusIDs(invalid,:)=[]; % remove invalid data
TrialDuration(invalid,:)=[]; % remove invalid data
TrialDurationEstimated(invalid,:)=[]; % remove invalid data
ok1(invalid,:)=[]; % remove invalid data
ok2(invalid,:)=[]; % remove invalid data
ok3(invalid,:)=[]; % remove invalid data

%%
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents who imputed the same code multiple times (cheaters) = ' num2str(length(cheater_worker_codes))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents who did not read instructions = ' num2str(length(invalid1))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents under 18 = ' num2str(length(invalid2))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents who took less than 300 s = ' num2str(length(invalid3))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of rows in keypress data not matched =  ' num2str(length(invalid4))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of responses who had fewer than ' num2str(num_stimuli/2) ' stimuli = ' num2str(length(invalid5))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of responses coming from the same IP = ' num2str(length(invalid6))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of responses with delayed video playback = ' num2str(length(invalid7))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of responses with strange trial durations = ' num2str(length(invalid7))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents removed = ' num2str(length(invalid))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents after filtering =  ' num2str(size(X,1))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of countries after filtering =  ' num2str(length(unique(Country)))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Gender, male respondents after filtering = ' num2str(sum(X(:,2)==2))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Gender, female respondents after filtering = ' num2str(sum(X(:,2)==1))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Gender, I prefer not to respond after filtering = ' num2str(sum(isnan(X(:,2))))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Mean age after filtering = ' num2str(nanmean(X(:,3)))]) %#ok<*NANMEAN>
disp([datestr(now, 'HH:MM:SS.FFF') ' - SD Age after filtering = ' num2str(nanstd(X(:,3)))]) %#ok<*NANSTD>
disp([datestr(now, 'HH:MM:SS.FFF') ' - Study completion time mean (minutes) - after filtering = ' num2str(mean(X(:,18)/60))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Study completion time median (minutes) - after filtering = ' num2str(median(X(:,18)/60))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Study completion time P25 (minutes) - after filtering = ' num2str(prctile(X(:,18),25)/60)]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Study completion time P75 (minutes) - after filtering = ' num2str(prctile(X(:,18),75)/60)]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Study completion time SD (minutes) - after filtering = ' num2str(std(X(:,18)/60))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - First survey start date - after filtering = ' datestr(min(X(:,16)))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Last survey end date - after filtering = ' datestr(max(X(:,17)))]);
