function [imageStack,registerData] = imagestackpreprocessorV1(fileNamePrefix,plotFigureFlag,bkgdFlag,manualRegisterFlag,angleVec)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here

%%

%create name and location for data file
fileNameData = fullfile(fileNamePrefix,'RegisterData.mat');


%% Load raw images

directory = dir(fullfile(fileNamePrefix,'photo','*.jpg')); %record directory

imgArray = {}; %initialize image array

for k = 1:length({directory.name})
    imgArray{k,1} = imread(fullfile(fileNamePrefix,'photo',directory(k).name));
end

if plotFigureFlag == 1
    figure;montage(imgArray(:,1), 'Size', [2 ceil(size(imgArray,1)/2)])
end

if bkgdFlag == 1
    directory = dir(fullfile(fileNamePrefix,'background','*.jpg')); %record directory
    imgBkgd = {}; %initialize image background array
    for k = 1:length({directory.name})
        imgBkgd{k,1} = imread(fullfile(fileNamePrefix,'background',directory(k).name));
        %         imgArray{k,1} = imsubtract(imgArray{k,1},imgBkgd{k,1});
    end
    if plotFigureFlag == 1
        figure;montage(imgBkgd(:,1), 'Size', [2 ceil(size(imgBkgd,1)/2)])
    end
end

% if plotFigureFlag == 1
%     figure;montage(imgArray(:,1), 'Size', [2 ceil(size(imgArray,1)/2)])
% end


%% Rotate and crop images based on angle vector

imgArray{1,2} = imgArray{1,1}; %fixed reference for registration
for k = 2:size(imgArray,1)
    imgArray{k,2} = imrotate(imgArray{k,1},-angleVec(k),'crop');
end

if bkgdFlag == 1
    imgBkgd{1,2} = imgBkgd{1,1}; %fixed reference for registration
    for k = 2:size(imgArray,1)
        imgBkgd{k,2} = imrotate(imgBkgd{k,1},-angleVec(k),'crop');
    end
end


%% Register images

imregcorrType = 'similarity';
% imregcorrType = 'rigid';
% imregcorrType = 'translation';

% imregcorrType01 = 'translation';


% transformType = 'similarity';
% transformType = 'rigid';

% featureType = 'SURF';
% featureType = 'FAST';
% featureType = 'BRISK';
% featureType = 'Harris';
% featureType = 'MinEigen';
% featureType = 'ORB';
% featureType = 'KAZE';

imgArray{1,3} = imgArray{1,1}; %fixed reference for registration
Rfixed = imref2d(size(imgArray{1,1}));

if isfile(fileNameData)
    load(fileNameData,'registerData')
    for k = 2:size(imgArray,1)
        
        if registerData(k).peakcorr < 0.02
            imgArray{k,3} = imwarp(imgArray{k,2},registerData(k).tformEstimate,'OutputView',Rfixed);
        else
            imgArray{k,3} = imwarp(imgArray{k,1},registerData(k).tformEstimate,'OutputView',Rfixed);
        end
        
        if isfield(registerData(k),'tformEstimateRefined')
            imgArray{k,3} = imwarp(imgArray{k,3},registerData(k).tformEstimateRefined,'OutputView',Rfixed);
        end
        
        if plotFigureFlag == 1
            figure;imshowpair(imgArray{1,1},imgArray{k,3},'falsecolor');
        end
    end
else
    registerData = struct();
    
    for k = 2:size(imgArray,1)
        
        if plotFigureFlag == 1
            figure;imshowpair(imgArray{1,1},imgArray{k,1},'falsecolor');
            title('rotated')
        end
        tic
        [registerData(k).tformEstimate,registerData(k).peakcorr] = ...
            imregcorr(single(double(rgb2gray(imgArray{k,1}))),single(double(rgb2gray(imgArray{1,1}))),imregcorrType,'Window',1);
        toc
        
        %         if registerData(k).peakcorr < 0.02 && manualRegisterFlag == 0
        %             registerData(k).tformEstimate = ...
        %                 featurematchregistration(rgb2gray(imgArray{1,1}),rgb2gray(imgArray{k,1}),featureType,transformType);
        %         end
        
        if registerData(k).peakcorr < 0.02 && manualRegisterFlag == 0
            [optimizer, metric] = imregconfig('multimodal');
            optimizer.InitialRadius = optimizer.InitialRadius*0.20;
            optimizer.Epsilon = optimizer.Epsilon*0.10;
%             optimizer.GrowthFactor = optimizer.GrowthFactor*1.00;
            optimizer.MaximumIterations = optimizer.MaximumIterations*0.50;
            tic
            %             registerData(k).tformEstimate = imregtform(rgb2gray(imgArray{k,2}),rgb2gray(imgArray{1,1}),'rigid',optimizer,metric);
            registerData(k).tformEstimate = imregtform(rgb2gray(imgArray{k,2}),rgb2gray(imgArray{1,1}),'rigid',optimizer,metric,...
                'InitialTransformation',...
                imregcorr(single(double(rgb2gray(imgArray{k,2}))),single(double(rgb2gray(imgArray{1,1}))),'translation'));
            toc
            %image registration from multimodal optimization
            imgArray{k,3} = imwarp(imgArray{k,2},registerData(k).tformEstimate,'OutputView',Rfixed);
        else
            %image registration from phase correlation
            imgArray{k,3} = imwarp(imgArray{k,1},registerData(k).tformEstimate,'OutputView',Rfixed);
        end
        if plotFigureFlag == 1
            figure;imshowpair(imgArray{1,1},imgArray{k,3},'falsecolor');
            title('registered')
        end
        
        if registerData(k).peakcorr < 0.02 && manualRegisterFlag == 1 %correct registration manually
            % Select control points manually
            if isfield(registerData(k),'mp') == 1
                if isempty(registerData(k).mp)
                    [mp,fp] = cpselect(imgArray{k,1},imgArray{1,1},'Wait',true);
                    registerData(k).mp = mp;
                    registerData(k).fp = fp;
                else
                    %pass
                end
            else
                [mp,fp] = cpselect(imgArray{k,1},imgArray{1,1},'Wait',true);
                registerData(k).mp = mp;
                registerData(k).fp = fp;
            end
            registerData(k).tformEstimate = fitgeotrans(registerData(k).mp,registerData(k).fp,'nonreflectivesimilarity');
            imgArray{k,3} = imwarp(imgArray{k,1},registerData(k).tformEstimate,'OutputView',Rfixed);
            if plotFigureFlag == 1
                figure;imshowpair(imgArray{1,1},imgArray{k,3},'falsecolor');
                title('manual registration')
            end
        end
        
        if manualRegisterFlag == 0
            [optimizer, metric] = imregconfig('multimodal');
            optimizer.InitialRadius = optimizer.InitialRadius*0.1;
            optimizer.MaximumIterations = optimizer.MaximumIterations*0.25;
            
            
            
%             if registerData(k).peakcorr < 0.02
%                 optimizer.InitialRadius = optimizer.InitialRadius*0.3;
%                 optimizer.MaximumIterations = optimizer.MaximumIterations*1.0;
%             else
%                 optimizer.InitialRadius = optimizer.InitialRadius*0.3;
%                 optimizer.MaximumIterations = optimizer.MaximumIterations*1.0;
%             end
            tic
            registerData(k).tformEstimateRefined = imregtform(rgb2gray(imgArray{k,3}),rgb2gray(imgArray{1,1}),'rigid',optimizer,metric);
%             registerData(k).tformEstimateRefined = imregtform(rgb2gray(imgArray{k,3}),rgb2gray(imgArray{1,1}),'rigid',optimizer,metric,...
%                 'InitialTransformation',...
%                 imregcorr(single(double(rgb2gray(imgArray{k,3}))),single(double(rgb2gray(imgArray{1,1}))),'translation'));
            toc
            
            imgArray{k,3} = imwarp(imgArray{k,3},registerData(k).tformEstimateRefined,'OutputView',Rfixed);
            if plotFigureFlag == 1
                figure;imshowpair(imgArray{1,1},imgArray{k,3},'falsecolor');
                title('refined')
            end
        end
    end
    save(fileNameData,'registerData')
end
if plotFigureFlag == 1
    figure;montage(imgArray(:,3), 'Size', [2 ceil(size(imgArray,1)/2)])
end

imageStack = imgArray(:,3);


%% Subtract background

if bkgdFlag == 1
    for k = 1:size(imgArray,1)
        if k == 1
            bkgd = imgBkgd{k,1};
        else
            
            %         registerData(k).tformEstimate
            %             bkgd = imwarp(imrotate(imgBkgd{k,1},angleVec(k),'crop'),registerData(k).tformEstimate,'OutputView',Rfixed);
            
            if registerData(k).peakcorr < 0.02
                bkgd = imwarp(imgBkgd{k,2},registerData(k).tformEstimate,'OutputView',Rfixed);
            else
                bkgd = imwarp(imgBkgd{k,1},registerData(k).tformEstimate,'OutputView',Rfixed);
            end
            
            if isfield(registerData(k),'tformEstimateRefined')
                bkgd = imwarp(bkgd,registerData(k).tformEstimateRefined,'OutputView',Rfixed);
                %                 imgArray{k,2} = imwarp(imgArray{k,2},registerData(k).tformEstimateRefined,'OutputView',Rfixed);
            end
            
        end
        imgArray{k,4} = imsubtract(imgArray{k,3},bkgd);
    end
    
    if plotFigureFlag == 1
        figure;montage(imgArray(:,4), 'Size', [2 ceil(size(imgArray,1)/2)])
    end
    imageStack = imgArray(:,4);
end


end

