function [cropPosition,imageStackOut] = imagestackinteractivecrop(fileNamePrefix,imageStackIn,initialPosition)
%imagestackinteractivecrop Summary of this function goes here
%   Detailed explanation goes here

%%

%create name and location for data file
fileNameData = fullfile(fileNamePrefix,'CropData.mat');


%%


if isfile(fileNameData)
    load(fileNameData,'cropPosition')
else
    %% Manually define region of interest and save parameters
    
    figure;imshow(imageStackIn{1,1})
    %     initialPosition = [500,500,2500,2500];  %ROI initial position
    roi = drawrectangle(gca,'Position',initialPosition,'FixedAspectRatio',1,'Color','r');
    cropPosition = customWait(roi);
    I2 = imcrop(imageStackIn{1,1},cropPosition);
    figure;imshow(I2);   % the output image of your ROI
    
    
    %% Save crop position variable
    
    %create name and location for data file
    fileNameData = fullfile(fileNamePrefix,'CropData.mat');
    save(fileNameData,'cropPosition')
end

%% Plot cropped images

imageStackOut = {}; %initialize image array
for k = 1:size(imageStackIn,1)
    imageStackOut{k,1} = imcrop(imageStackIn{k,1},cropPosition);
end
figure;montage(imageStackOut(:,1), 'Size', [2 ceil(size(imageStackOut,1)/2)])


end

%% Following functions from:
% https://nl.mathworks.com/matlabcentral/answers/486491-cropping-image-from-a-rotatable-drawrectangle-roi

function pos = customWait(hROI)
% Listen for mouse clicks on the ROI
l = addlistener(hROI,'ROIClicked',@clickCallback);
% Block program execution
uiwait;
% Remove listener
delete(l);
% Return the current position
pos = hROI.Position;
end
function clickCallback(~,evt)
if strcmp(evt.SelectionType,'double')
    uiresume;
end
end

