%%
% clear memory and previously allocated variables
clc;clear all;close all;


%% Load input parameters

run ColorIcePreprocessorInput

gbap.fileNamePrefix = [pwd,gbap.subfolder];


%% Load and register images coarsely

[imageStack,registerData] = imagestackpreprocessorV1(gbap.fileNamePrefix,gbap.plotFigureFlagImageStackPreprocessor,gbap.bkgdFlag,gbap.manualRegisterFlag,gbap.angleVec);


%% Manually define region of interest for cropping and save parameters

[cropPosition,imageStack] = imagestackinteractivecrop(gbap.fileNamePrefix,imageStack,gbap.initialPosition);


%% Registration of cropped images for final refinement

%     close all;clc;
[imageStack,registerCropData] = imagestackregistration(gbap.fileNamePrefix,imageStack,gbap.plotFigureFlagCropRegister);


%% Save pre-processed image stack for later analysis

gbap.imageStack = imageStack;

saveimagestack(gbap.fileNamePrefix,gbap)

disp('pre-processing complete')
