function [mmPerPixel] = interactivescalemeasurement(fileNamePrefix)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here

%% Load parallel polarization image

% folderName = 'background';
folderName = 'scale';

directory = dir(fullfile(fileNamePrefix,folderName,'*.jpg')); %record directory

% imageParallel = {}; %initialize image array
imageParallel = imread(fullfile(fileNamePrefix,folderName,directory(1).name));
% for k = 1:length({directory.name})
%     imageParallel{k,1} = imread(fullfile(fileNamePrefix,'photo',directory(k).name));
% end

%% Plot interactive line

imgSize = size(imageParallel,1); %row dimension length in pixels

figure;imshow(imageParallel)
title('Drag line and stretch to scale length and double-click')

hROI = drawline('Position',[imgSize*1/4 imgSize/2;imgSize*3/4 imgSize/2],'Color','r');
scaleLength = customWait(hROI);

% input explicit number from list
scaleInput = input('Type measured distance in mm: ');

mmPerPixel = scaleInput/scaleLength;
end


%% Following functions from:
% https://nl.mathworks.com/matlabcentral/answers/486491-cropping-image-from-a-rotatable-drawrectangle-roi

function pos = customWait(hROI)

addlistener(hROI,'MovingROI',@allevents);
addlistener(hROI,'ROIMoved',@allevents);

% Listen for mouse clicks on the ROI
l = addlistener(hROI,'ROIClicked',@clickCallback);
% Block program execution
uiwait;
% Remove listener
delete(l);
% Return the current position
% pos = hROI.Position;
pos = norm([diff(hROI.Position(:,1)), diff(hROI.Position(:,2))]);


end
function clickCallback(~,evt)
if strcmp(evt.SelectionType,'double')
    uiresume;
end
end

function allevents(src,evt)
distance = norm([diff(evt.CurrentPosition(:,1)), diff(evt.CurrentPosition(:,2))]);
src.Label = num2str(distance,'%.0f');
end

