function [imageStackOut,pointPosition] = interactivechromaticadaptation(imageStackIn,fileNamePrefix)
%UNTITLED3 Summary of this function goes here
%   Detailed explanation goes here

%% Load parallel polarization image

directory = dir(fullfile(fileNamePrefix,'photoParallel','*.jpg')); %record directory

% imageParallel = {}; %initialize image array
imageParallel = imread(fullfile(fileNamePrefix,'photoParallel',directory(1).name));
% for k = 1:length({directory.name})
%     imageParallel{k,1} = imread(fullfile(fileNamePrefix,'photo',directory(k).name));
% end

%% Plot interactive point

figure;imshow(imageParallel)
roi = drawpoint('Position',[size(imageParallel,1)/2 size(imageParallel,2)/2],'Color','r');
title('Drag point to white light and double-click')
pointPosition = customWait(roi);
gray_val = impixel(imageParallel,pointPosition(1),pointPosition(2));

close gcf

stretchOpt = 1; Tol = 0.01;
% stretchOpt = 0;

B = chromadapt(imageParallel,gray_val,'ColorSpace','adobe-rgb-1998');
if stretchOpt == 1
    B = imadjust(B,stretchlim(B,Tol),[]);
end
figure;imshowpair(imageParallel,B,'montage')
drawpoint('Position',[pointPosition(1) pointPosition(2)],'Color','r');

%% Chromatic adaptation
imageStackOut = {}; %initialize image array
for k = 1:size(imageStackIn,1)
    BB = chromadapt(imageStackIn{k,1},gray_val,'ColorSpace','adobe-rgb-1998');
    %     BB = imadjust(BB,stretchlim(BB),[]);
    if stretchOpt == 1
        BB = imadjust(BB,stretchlim(B,Tol),[]);
    end
    imageStackOut{k,1} = BB;
    %     imageStackOut{k,1} = chromadapt(imageStackIn{k,1},gray_val,'ColorSpace','adobe-rgb-1998');
end

end



%% Following functions from:
% https://nl.mathworks.com/matlabcentral/answers/486491-cropping-image-from-a-rotatable-drawrectangle-roi

function pos = customWait(hROI)
% Listen for mouse clicks on the ROI
l = addlistener(hROI,'ROIClicked',@clickCallback);
% Block program execution
uiwait;
% Remove listener
delete(l);
% Return the current position
pos = hROI.Position;
end
function clickCallback(~,evt)
if strcmp(evt.SelectionType,'double')
    uiresume;
end
end