function [B,L,N] = imagestacksegmenter(imageStack,...
    kernelVal,Nmedfilt,SE0,SE,threshOutFactorRGB,threshOutFactorHSV,threshOutFactorYCbCr,plotFigureFlag)
%UNTITLED4 Summary of this function goes here
%   Detailed explanation goes here

%% Settings
imgArray = {}; %initialize image array
medval = [1 1]*kernelVal;
threshOutFactorVec = [threshOutFactorRGB*ones(1,3) threshOutFactorHSV*ones(1,3) threshOutFactorYCbCr*ones(1,3)];

for q = 1:size(imageStack,1)
    
    %% load image
    img = imageStack{q};
    
    %% RGB to HSV conversion
    imgHSV = uint8(rgb2hsv(img)*255); %RGB to HSV conversion
    %% Convert RGB color values to YCbCr color space
    imgYCBCR = rgb2ycbcr(img);
    
    %% Convert RGB color values to L*a*b color space
    imgLab = rgb2lab(img,'ColorSpace','adobe-rgb-1998');
    
    %%
    
    for k = 1:3
        if k<=3
            imgArray{k,1,q} = img(:,:,k);%red (1), green (2), blue (3) channels
%             imgArray{k,1,q} = imgLab(:,:,k);%red (1), green (2), blue (3) channels
%             imgArray{k,1,q} = imgHSV(:,:,k);
%             imgArray{k,1,q} = imgYCBCR(:,:,k);
        elseif k>3 && k<=6
            imgArray{k,1,q} = imgHSV(:,:,k-3);
        elseif k>6 && k<=9
            imgArray{k,1,q} = imgYCBCR(:,:,k-6);
        elseif k>9 && k<=12
            imgArray{k,1,q} = imgLab(:,:,k-9);
        end
    end
    %     figure;montage(imgArray(:,1,q), 'Size', [3 size(imgArray(:,1,q),1)/3])
    
    %% Morphological operations
    %     imgArray(:,2,q) = cellfun(@(x) imclose(imopen(x,SE0),SE0),imgArray(:,1,q),'UniformOutput',false );
    %     imgArray(:,2,q) = cellfun(@(x) imgaussfilt(x,2.0),imgArray(:,1,q),'UniformOutput',false );
    %     imgArray(:,2,q) = cellfun(@(x) imguidedfilter(x),imgArray(:,1,q),'UniformOutput',false );
    
    %% Morphological operations
    for k = 1:size(imgArray,1) %red (1), green (2), blue (3) channels
        imgPP = imgArray{k,1,q};
        
%                         imgPP = histeq(imgPP);
        %         imgPP = imopen(imgPP,SE0);
        %         imgPP = imclose(imgPP,SE0);
        %         imgPP = medfilt2N(imgPP,medval,Nmedfilt); %figure;imshow(imgPP)
        [~,threshOut] = edge(imgPP);
        [imgPP,~] = edge(imgPP,'Sobel',threshOut*threshOutFactorVec(k),'nothinning');
        
        %         imgPP = bwmorph(imgPP,'majority','Inf');
        %         imgPP = bwmorph(imgPP,'skel',Inf);figure;imshow(imgPP)
        
        imgArray{k,2,q} = ~imgPP;
    end
    %     figure;montage(imgArray(:,3,q), 'Size', [3 size(imgArray(:,3,q),1)/3])
end

%% Combine grayscale images

imgMat = ones(size(imgArray{1,1}));
for q = 1:size(imageStack,1)
    for k = 1:size(imgArray,1)
        imgMat = imgMat & imgArray{k,2,q};
    end
end
imgArray{1,3} = imgMat;
% if plotFigureFlag == 1
% figure;imshow(imgArray{1,3})
% end

%% Morphological operations on combined image

imgPP = imgArray{1,3};
imgPP = ~imgPP;
% figure;imshow(imgPP)
% if size(imageStack,1) == 1
%     imgPP = bwmorph(imgPP,'majority','Inf');
%     imgPP = imclose(imgPP,SE);
% else
% %     imgPP = imclose(imgPP,SE);
%
%     imgPP = bwmorph(imgPP,'majority','Inf');
% %     figure;imshow(imgPP)
% %         imgPP = imopen(imgPP,SE);
%     imgPP = imclose(imgPP,SE);
% %     figure;imshow(imgPP)
% end

imgPP = bwmorph(imgPP,'majority','Inf');
imgPP = imclose(imgPP,SE);

% BW2 = imfill(BW,'holes')
if plotFigureFlag == 1
    figure;montage({imgArray{1,3},imgPP},'Size',[1 2])
end
% imgPP = bwmorph(imgPP,'majority',Inf);
% imgPP = bwmorph(imgPP,'majority');
% figure;imshow(imgPP)
imgPP = bwmorph(imgPP,'skel',Inf);
% figure;imshow(imgPP)
imgPP = bwmorph(imgPP,'spur',Inf);
% figure;imshow(imgPP)
imgPP = bwmorph(imgPP,'clean',Inf);
% figure;imshow(imgPP)
% figure;imshow(imgPP)
imgArray{1,4} = ~imgPP;
% figure;imshow(imgArray{1,5})

%% Superimpose result on original image
% imgArray{1,5} = imoverlay(imageStack{1},~imgArray{1,4},'k');
% figure;imshow(imgArray{1,6});

% outputArg1 = imgArray{1,5};


%% Add perimeter mask

% mask = ones(size(imgArray{1,4},1)-4,size(imgArray{1,4},2)-4);
% mask = padarray(mask,[1 1],0,'both');
% mask = padarray(mask,[1 1],1,'both');
% 
% imgArray{1,4} = imgArray{1,4}.*mask;

% figure;imshowpair(imgArray{1,4},mask,'montage')

%% Trace region boundaries in binary image

bw = imgArray{1,4};
[B,L,N,~] = bwboundaries(~bw,'holes');
% [B,L] = bwboundaries(~bw,'holes');
% [B,L,n,A] = bwboundaries(~bw,'noholes');
% figure;imshow(label2rgb(L, @jet, [.5 .5 .5]))


if plotFigureFlag == 1
    % figure
    scrsz = get(groot,'ScreenSize');
    figure('Position',...
        [scrsz(3)*0.02 scrsz(4)*0.15 scrsz(3)*0.95 scrsz(4)*0.70]);
    % 'Position' definition: [left bottom width height]
    
    tiledlayout(1+(size(imageStack,1)>1),ceil(size(imageStack,1)/2),'TileSpacing','none','Padding','compact');
    for q = 1:size(imageStack,1)
        nexttile
        imshow(imageStack{q})
        %     image(imageStack{q})
        hold on
        for k = 1:N
            boundary = B{k};
            plot(boundary(:,2), boundary(:,1), 'k', 'LineWidth', 1.5)
        end
        
        for k = N+1:length(B)
            boundary = B{k};
            plot(boundary(:,2), boundary(:,1), 'w', 'LineWidth', 1.5)
        end
        hold off
        axis equal
    end
end

% for q = 1:size(imageStack,1)
%     figure;imshow(imageStack{q})
%     hold on
%     for k = 1:N
%         boundary = B{k};
%         plot(boundary(:,2), boundary(:,1), 'k', 'LineWidth', 2)
%     end
%
%     for k = N+1:length(B)
%         boundary = B{k};
%         plot(boundary(:,2), boundary(:,1), 'w', 'LineWidth', 2)
%     end
%     hold off
% end

end

