function [imageStackOut,cropPositionRegister] = imagestackinteractivecropCircle(imageStackIn,plotFigureFlag)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here

    %% Manually define region of interest and save parameters
    
    [rows, columns, numberOfColorChannels] = size(imageStackIn{1,1});
    
    
    figure;imshow(imageStackIn{1,1})
%         initialPosition = [500,500,500,500];  %ROI initial position
    roi = drawcircle(gca,'Center',[floor(columns/2),floor(rows/2)],'Radius',floor(columns/3),'Color','r');
%     roi

% addlistener(roi,'MovingROI',@allevents);
% addlistener(roi,'ROIMoved',@allevents);

    cropPosition = customWait(roi);
    
    pxlAdd = 50; %added pixels on edges for registration [-]
    
%     [xmin ymin width height]
    cropPosition = [(roi.Center(1)-roi.Radius-pxlAdd) (roi.Center(2)-roi.Radius-pxlAdd) (roi.Radius*2+pxlAdd*2) (roi.Radius*2+pxlAdd*2)];
    
    for k = 1:size(imageStackIn,1)
        imageStackIn{k,2} = imcrop(imageStackIn{k,1},cropPosition);
    end
    
    cropPositionRegister = [(roi.Center(1)-roi.Radius) (roi.Center(2)-roi.Radius) (roi.Radius*2) (roi.Radius*2)];
    
    %% Final image registration of ROI
    
%     imregcorrType = 'translation';imregType = 'rigid';
imregcorrType = 'similarity';imregType = 'affine';
    
Rfixed = imref2d(size(imageStackIn{1,1}));
RfixedLocal = imref2d(size(imageStackIn{1,2}));
% Rfixed = imref2d(size(imageStackIn{1,2}));
imageStackIn{1,4} = imageStackIn{1,2}; %fixed reference for registration
imageStackIn{1,3} = imageStackIn{1,1}; %fixed reference for registration
RegisterData = struct();
    
    for k = 2:size(imageStackIn,1)
        tic
        [RegisterData(k).tformEstimate,RegisterData(k).peakcorr] = ...
            imregcorr(single(double(rgb2gray(imageStackIn{k,2}))),single(double(rgb2gray(imageStackIn{1,2}))),imregcorrType,'Window',1);
        toc
        
        maxIterFactor = 2.00;
        if RegisterData(k).peakcorr < 0.02
            %             disp(RegisterData(k).peakcorr)
            tic
            [RegisterData(k).tformEstimate,RegisterData(k).peakcorr] = ...
                imregcorr(single(double(rgb2gray(imageStackIn{k,1}))),single(double(rgb2gray(imageStackIn{k-1,1}))),imregcorrType,'Window',1);
            toc
            %             disp(RegisterData(k).peakcorr)
            maxIterFactor = 4.00;
        end

        [optimizer, metric] = imregconfig('multimodal');
        optimizer.InitialRadius = optimizer.InitialRadius*0.10;
        optimizer.Epsilon = optimizer.Epsilon*0.10;
        optimizer.GrowthFactor = 1.01;
%         optimizer.GrowthFactor = 1.04;
        optimizer.MaximumIterations = optimizer.MaximumIterations*maxIterFactor;
        
        tic
        RegisterData(k).tformEstimate = imregtform(rgb2gray(imageStackIn{k,2}),rgb2gray(imageStackIn{1,2}),imregType,optimizer,metric,'InitialTransformation',RegisterData(k).tformEstimate);
        toc
        
%                 imageStackOut{k,1} = imwarp(imageStackIn{k,1},cropRegisterData(k).tformEstimate,'OutputView',Rfixed);
% imageStackIn{k,3} = imwarp(imageStackIn{k,2},RegisterData(k).tformEstimate,'OutputView',Rfixed);
imageStackIn{k,3} = imwarp(imageStackIn{k,1},RegisterData(k).tformEstimate,'OutputView',Rfixed);
imageStackIn{k,4} = imwarp(imageStackIn{k,2},RegisterData(k).tformEstimate,'OutputView',RfixedLocal);

% plotFigureFlag = 1;
        if plotFigureFlag == 1
            % figure;
            scrsz = get(groot,'ScreenSize');
            figure('Position',...
                [scrsz(3)*0.10 scrsz(4)*0.15 scrsz(3)*0.80 scrsz(4)*0.70]);
            % 'Position' definition: [left bottom width height]
            subplot(1,2,1);imshowpair(imageStackIn{1,2},imageStackIn{k,4},'falsecolor');
            subplot(1,2,2);imshowpair(imageStackIn{1,1},imageStackIn{k,3},'falsecolor');
            title('registered')
        end
        
    end
    
    %%
    
    
    [rows, columns, numberOfColorChannels] = size(imageStackIn{1,4});
    
%     cropPosition
%     roi.Center(1)-roi.Radius-pxlAdd roi.Center(2)-roi.Radius-pxlAdd
    
    
    % % Get coordinates of the circle.
angles = linspace(0, 2*pi, 10000);
% x = cos(angles) * roi.Radius + roi.Center(1);
% y = sin(angles) * roi.Radius + roi.Center(2);
x = cos(angles) * roi.Radius + (columns)/2;
y = sin(angles) * roi.Radius + (rows)/2;
    % % Get a mask of the circle
%     [rows, columns, numberOfColorChannels] = size(imageStackIn{1,1});
mask = poly2mask(x, y, rows, columns);
cropMaskCircle = mask;
% Mask the image with the circle.
if numberOfColorChannels == 1
	maskedImage = imageStackIn{1,4}; % Initialize with the entire image.
	maskedImage(~circleImage) = 0; % Zero image outside the circle mask.
else
	% Mask the image.
	maskedImage = bsxfun(@times, imageStackIn{1,4}, cast(mask, class(imageStackIn{1,4})));
end
% Crop the image to the bounding box.
props = regionprops(mask, 'BoundingBox');
I2 = imcrop(maskedImage, props.BoundingBox);

%     roi
%     I2 = imcrop(imageStackIn{1,1},cropPosition);
    figure;imshow(I2);   % the output image of your ROI
    
    
    %% Plot cropped images

imageStackOut = {}; %initialize image array
for k = 1:size(imageStackIn,1)
    maskedImage = bsxfun(@times, imageStackIn{k,4}, cast(mask, class(imageStackIn{k,4})));
    props = regionprops(mask, 'BoundingBox');
imageStackOut{k,1} = imcrop(maskedImage, props.BoundingBox);


%     imageStackOut{k,1} = imcrop(imageStackIn{k,1},cropPosition);
end

% size(imageStackOut)
% figure;montage(imageStackOut(:,1), 'Size', [2 ceil(size(imageStackOut,1)/2)])

% % Get coordinates of the circle.
% angles = linspace(0, 2*pi, 10000);
% x = cos(angles) * h.Radius + h.Center(1);
% y = sin(angles) * h.Radius + h.Center(2);









% fontSize = 15;
% % Get image.
% % originalImage = imread('peppers.png');
% [rows, columns, numberOfColorChannels] = size(originalImage)
% subplot(2, 2, 1);
% imshow(originalImage);
% axis('on', 'image');
% title('Original Image', 'FontSize', fontSize);
% % Maximize the window to make it easier to draw.
% g = gcf;
% g.WindowState = 'maximized'
% % Ask user to draw a circle:
% uiwait(helpdlg('Please click and drag out a circle.'));
% h.Radius = 0;
% while h.Radius == 0
% 	h = drawcircle('Color','k','FaceAlpha',0.4)
% 	if h.Radius == 0
% 		uiwait(helpdlg('You double-clicked.  You need to single click, then drag, then single click again.'));
% 	end
% end
% % Get coordinates of the circle.
% angles = linspace(0, 2*pi, 10000);
% x = cos(angles) * h.Radius + h.Center(1);
% y = sin(angles) * h.Radius + h.Center(2);
% % Show circle over image.
% subplot(2, 2, 2);
% imshow(originalImage);
% axis('on', 'image');
% hold on;
% plot(x, y, 'r-', 'LineWidth', 2);
% title('Original image with circle mask overlaid', 'FontSize', fontSize);
% % Get a mask of the circle
% mask = poly2mask(x, y, rows, columns);
% subplot(2, 2, 3);
% imshow(mask);
% axis('on', 'image');
% title('Circle Mask', 'FontSize', fontSize);
% % Mask the image with the circle.
% if numberOfColorChannels == 1
% 	maskedImage = originalImage; % Initialize with the entire image.
% 	maskedImage(~circleImage) = 0; % Zero image outside the circle mask.
% else
% 	% Mask the image.
% 	maskedImage = bsxfun(@times, originalImage, cast(mask, class(originalImage)));
% end
% % Crop the image to the bounding box.
% props = regionprops(mask, 'BoundingBox');
% maskedImage = imcrop(maskedImage, props.BoundingBox);
% % Display it in the lower right plot.
% subplot(2, 2, 4);
% imshow(maskedImage, []);
% % Change imshow to image() if you don't have the Image Processing Toolbox.
% title('Image masked with the circle', 'FontSize', fontSize);
% fprintf('Done running %s.m ...\n', mfilename);




















% outputArg1 = inputArg1;
% outputArg2 = inputArg2;
end



%% Following functions from:
% https://nl.mathworks.com/matlabcentral/answers/486491-cropping-image-from-a-rotatable-drawrectangle-roi

function pos = customWait(hROI)

addlistener(hROI,'MovingROI',@allevents);
addlistener(hROI,'ROIMoved',@allevents);

% Listen for mouse clicks on the ROI
l = addlistener(hROI,'ROIClicked',@clickCallback);
% Block program execution
uiwait;
% Remove listener
delete(l);
% Return the current position
pos = hROI.Position;
end
function clickCallback(~,evt)
if strcmp(evt.SelectionType,'double')
    uiresume;
end
end

function allevents(src,evt)
% delete(textVar)
% evname = evt.EventName;
src.Label = num2str(evt.CurrentRadius,'%.0f');
% switch(evname)
%     case{'MovingROI'}
        %             disp(['ROI moving previous position: ' mat2str(evt.PreviousPosition)]);
        %             disp(['ROI moving current position: ' mat2str(evt.CurrentPosition)]);
%         src.Label = num2str(evt.CurrentRadius,0);
%     case{'ROIMoved'}
        %             disp(['ROI moved previous position: ' mat2str(evt.Radius)]);
        %             disp(['ROI moved previous position: ' mat2str(evt.PreviousCenter)]);
        %             disp(['ROI moved current position: ' mat2str(evt.CurrentCenter)]);
        
%         src.Label = num2str(evt.CurrentRadius,0);
        
        %         textVar = text(evt.CurrentCenter(1),evt.CurrentCenter(2),num2str(evt.CurrentRadius),'Color','white');
        
        
% end
end
