function [intensity,RGBnonlinCLUT,quality] = ...
    birefringenceColorLookUpTableV01(thickness_vec,theta_vec,alfa_vec,lambdaFlag,polFlag,colorTemp,colorTempChrom)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here
% outputArg1 = inputArg1;
% outputArg2 = inputArg2;

%%
% clear memory and previously allocated variables
% clc;clear all;close all;

if polFlag == 1 %crossed-polarization, 90 degrees
    phi = (90)*pi/180; %angle between polarizer and analyzer [rad]
elseif polFlag == 0 %plane-polarization, 0 degrees
    phi = (0)*pi/180; %angle between polarizer and analyzer [rad]
end

%% input parameters

%target color [RGB]
% colorTarget = [139,69,234]./255; %purple
% colorTarget = [067,222,129]./255; %green
% colorTarget = [174,195,129]./255; %yellow-green

%ice cross section thickness [m]
% thickness_vec = ((0.7:0.05:1.3)*10^-3)';
% thickness_vec = ((0.8:0.05:1.2)*10^-3)';

%inclination/zenith angle between incident ray and c-axis [rad]
% theta_vec = (0:0.1:90)'*pi/180;

%azimuth angle between polarizatio planes of incident ray and extraordinary ray [rad]
% alfa_vec = (40:0.5:50)'*pi/180;


%% define birefringence of freshwater ice

%birefringence of ice [-]

%table from Table 9.2 of Physics of Ice by Petrenko & Whitworth (2002)
%Google books, page 220 (searched "extraordinary")
%col1: light wavelength [nm]
%col2: refractive index ordinary [-]
%col3: refractive index extraordinary
%all taken at -3.6 degrees Celsius
refrac_mat=[...
    405	1.3185	1.3200
    436	1.3161	1.3176
    492	1.3128	1.3143
    546	1.3105	1.3119
    589	1.3091	1.3105
    624	1.3082	1.3096
    691	1.3067	1.3081...
    ];

%ice, Image analysis in earth sciences (2014), page 419
refrac_mat_ice=[...
    486.1340 1.31335 1.31473
    527.0390 1.31140 1.31276
    535.1000 1.31098 1.31242
    589.5940 1.30911 1.31041
    656.2810 1.30715 1.30861
    670.8000 1.30669 1.30802
    686.7190 1.30645 1.30775
    759.3700 1.30496 1.30626 ...
    ];

%quartz, Image analysis in earth sciences (2014), page 419
refrac_mat_quartz=[...
    303.4120 1.57695 1.58720
    340.3650 1.56747 1.57738
    404.6560 1.55716 1.56671
    434.0470 1.55396 1.56340
    486.1330 1.54968 1.55898
    546.0720 1.54617 1.55535
    579.0660 1.54467 1.55379
    589.2900 1.54425 1.55336
    656.2780 1.54190 1.55093
    706.5200 1.54049 1.54947
    766.4940 1.53907 1.54800 ...
    ];

%Hobbs (1974), pg202, ice at -3°C
refrac_mat_ice_Hobbs1974 = [
    404.596	1.3183	1.3198
    435.806	1.3159	1.3174
    486.098	1.3129	1.3143
    491.594	1.3126	1.3140
    546.090	1.3104	1.3118
    578.001	1.3093	1.3107
    589.310	1.3090	1.3104
    623.403	1.3079	1.3093
    656.297	1.3070	1.3084
    690.799	1.3063	1.3077
    706.514	1.3060	1.3074
    ];

refrac_mat_ice = [refrac_mat;refrac_mat_ice;refrac_mat_ice_Hobbs1974];
% refrac_mat_ice_sorted = sortrows(refrac_mat_ice,1);
refrac_mat_ice = sortrows(refrac_mat_ice,1);

%% Cauchy fitting of ordinary and extraordinary indices as function of wavelength

modelFun = @(p,x) p(1) + p(2)./x.^2 + p(3)./x.^4;
startingVals = [1 1 1];

nlModel1 = fitnlm(refrac_mat_ice(:,1),refrac_mat_ice(:,2),modelFun,startingVals);
nlModel2 = fitnlm(refrac_mat_ice(:,1),refrac_mat_ice(:,3),modelFun,startingVals);
nlModel3= fitnlm(refrac_mat_quartz(:,1),refrac_mat_quartz(:,2),modelFun,startingVals);
nlModel4 = fitnlm(refrac_mat_quartz(:,1),refrac_mat_quartz(:,3),modelFun,startingVals);


%%

thickness_quartz = 59.5e-6/4; %thickness of quartz quarter-waveplate [m]
% thickness_quartz = 65e-6; %thickness of quartz waveplate [m]
% thickness_quartz = 1; %thickness of quartz waveplate [m]
alfa_quartz = (45)*pi/180; %azimuthal angle [rad]
% alfa_quartz = (45+90)*pi/180; %azimuthal angle [rad]
% alfa_quartz = (0)*pi/180; %azimuthal angle [rad]
theta_vec_quartz = (90)*pi/180; %inclination angle [rad]

refrac_mat = refrac_mat_ice;
% refrac_mat = refrac_mat_quartz;

% n_o = mean(refrac_mat(:,2)); %ordinary/incident ray refractive index [-]
% n_e = mean(refrac_mat(:,3)); %extraordinary ray refractive index [-]

% n_o_quartz = mean(refrac_mat_quartz(:,2)); %ordinary/incident ray refractive index [-]
% n_e_quartz = mean(refrac_mat_quartz(:,3)); %extraordinary ray refractive index [-]

% n_o_quartz = mean(refrac_mat_quartz(6,2)); %ordinary/incident ray refractive index [-]
% n_e_quartz = mean(refrac_mat_quartz(6,3)); %extraordinary ray refractive index [-]

% theta = 0*pi/180; %inclination/zenith angle (from horizontal to viewing axis) [rad]
%extraordinary ray refractive index [-]
% n_ep = n_o./(sqrt(1+(n_o^2/n_e^2-1)*sin(theta_vec).^2));
% n_ep_quartz = n_o_quartz./(sqrt(1+(n_o_quartz^2/n_e_quartz^2-1)*sin(theta_vec_quartz).^2));

% delta_n = n_ep - n_o; %birefringence (double refractive index difference) [-]
% delta_n_quartz = n_ep_quartz - n_o_quartz;



% n_o = mean(refrac_mat(:,2)); %ordinary/incident ray refractive index [-]
% n_e = mean(refrac_mat(:,3)); %extraordinary ray refractive index [-]
% % theta = 0*pi/180; %inclination/zenith angle (from horizontal to viewing axis) [rad]
% %extraordinary ray refractive index [-]
% n_ep = n_o./(sqrt(1+(n_o^2/n_e^2-1)*sin(theta_vec).^2));
%
% delta_n = n_ep-n_o; %birefringence (double refractice index difference) [-]


%% load visible light spectrum data

%load file
filename = 'ciexyz31_1.csv';
[cvrlmat,~,~] = xlsread(filename);

lambda_vec0 = (cvrlmat(:,1)*10^-9)'; %visible light spectrum vector [m]

%visible light spectrum (all colors)
ind1 = find(lambda_vec0>=350e-9,1); %start index (350nm ultraviolet)
ind2 = find(lambda_vec0<=750e-9,1,'last'); %end index (750nm infrared)

%ultraviolet filter
% ind1 = find(lambda_vec0>=350e-9,1); %start index (400nm ultraviolet)
% ind2 = find(lambda_vec0<=400e-9,1,'last'); %end index (700nm infrared)

%blue filter
% ind1 = find(lambda_vec0>=400e-9,1); %start index (400nm ultraviolet)
% ind2 = find(lambda_vec0<=500e-9,1,'last'); %end index (700nm infrared)

%green filter
% ind1 = find(lambda_vec0>=500e-9,1); %start index (400nm ultraviolet)
% ind2 = find(lambda_vec0<=600e-9,1,'last'); %end index (700nm infrared)

%red filter
% ind1 = find(lambda_vec0>=600e-9,1); %start index (400nm ultraviolet)
% ind2 = find(lambda_vec0<=700e-9,1,'last'); %end index (700nm infrared)

%infrared filter
% ind1 = find(lambda_vec0>=700e-9,1); %start index (400nm ultraviolet)
% ind2 = find(lambda_vec0<=750e-9,1,'last'); %end index (700nm infrared)


lambda_vec = (cvrlmat(ind1:ind2,1)*10^-9)'; %light spectrum 400-700nm [m]

rlin = cvrlmat(ind1:ind2,2)'; %red channel (RGB)
glin = cvrlmat(ind1:ind2,3)'; %green channel (RGB)
blin = cvrlmat(ind1:ind2,4)'; %blue channel (RGB)
csf = [rlin;glin;blin]; %collect RGB channel values

%%

del = zeros(length(lambda_vec),length(thickness_vec),length(theta_vec));
del_quartz = zeros(length(lambda_vec),1);

%initialize arrays
intensity = zeros(length(lambda_vec),length(thickness_vec),...
    length(theta_vec),length(alfa_vec));
intensity_waveplate = zeros(length(lambda_vec),length(thickness_vec),...
    length(theta_vec),length(alfa_vec));

if lambdaFlag == 1
    thickness_quartz = 59.5e-6/4; %thickness of quartz quarter-waveplate [m]
    tic
    for k=1:length(lambda_vec)
%         n_o = polyval(polyfit(refrac_mat(:,1),refrac_mat(:,2),3),lambda_vec(k)*1e9);
%         n_e = polyval(polyfit(refrac_mat(:,1),refrac_mat(:,3),3),lambda_vec(k)*1e9);
        
%         n_o_quartz = polyval(polyfit(refrac_mat_quartz(:,1),refrac_mat_quartz(:,2),3),lambda_vec(k)*1e9);
%         n_e_quartz = polyval(polyfit(refrac_mat_quartz(:,1),refrac_mat_quartz(:,3),3),lambda_vec(k)*1e9);
        
        n_o = predict(nlModel1,lambda_vec(k)*1e9);
        n_e = predict(nlModel2,lambda_vec(k)*1e9);
        n_o_quartz = predict(nlModel3,lambda_vec(k)*1e9);
        n_e_quartz = predict(nlModel4,lambda_vec(k)*1e9);
        
        delta_n_quartz = n_o_quartz./(sqrt(1+(n_o_quartz^2/n_e_quartz^2-1)*sin(theta_vec_quartz).^2)) - n_o_quartz;
        del_quartz(k,1) = 2*pi/lambda_vec(k)*delta_n_quartz*thickness_quartz;
        
        for kk=1:length(thickness_vec)
            for kkk=1:length(theta_vec)
                
                delta_n = n_o./(sqrt(1+(n_o^2/n_e^2-1)*sin(theta_vec(kkk)).^2)) - n_o;
                del(k,kk,kkk) = 2*pi/lambda_vec(k)*delta_n*thickness_vec(kk);
                
                %                 del(k,kk,kkk) = 2*pi/lambda_vec(k)*delta_n(kkk)*thickness_vec(kk);
                %                 del_quartz(k,kk,kkk) = 2*pi/lambda_vec(k)*delta_n_quartz(kkk)*thickness_quartz;
                for kkkk=1:length(alfa_vec)
                    %                 intensity(k,kk,kkk,kkkk) = sin(2*alfa_vec(kkkk))^2*sin(del(k,kk,kkk)/2)^2;
                    
                    intensity_waveplate(k,kk,kkk,kkkk) = ...
                        -sin(2*(alfa_vec(kkkk)-alfa_quartz))*sin(2*alfa_vec(kkkk))...
                        *cos(2*alfa_quartz)*sin(del(k,kk,kkk)/2)^2 ...
                        +sin(2*(alfa_vec(kkkk)-alfa_quartz))*cos(2*alfa_vec(kkkk))...
                        *sin(2*alfa_quartz)*sin(del_quartz(k,1)/2)^2 ...
                        +cos(alfa_vec(kkkk)-alfa_quartz)^2*sin(2*alfa_vec(kkkk))...
                        *sin(2*alfa_quartz)...
                        *sin((del(k,kk,kkk)+del_quartz(k,1))/2)^2 ...
                        -sin(alfa_vec(kkkk)-alfa_quartz)^2*sin(2*alfa_vec(kkkk))...
                        *sin(2*alfa_quartz) ...
                        *sin((del(k,kk,kkk)-del_quartz(k,1))/2)^2;
                    
                    %                     if intensity_waveplate(k,kk,kkk,kkkk) <= 0
                    %                         intensity(k,kk,kkk,kkkk) = 0+eps;
                    %                     else
                    %                         intensity(k,kk,kkk,kkkk) = (intensity_waveplate(k,kk,kkk,kkkk));
                    %                     end
                    %                     intensity(k,kk,kkk,kkkk) = (intensity_waveplate(k,kk,kkk,kkkk));
                    intensity(k,kk,kkk,kkkk) = abs(intensity_waveplate(k,kk,kkk,kkkk));
                    
                end
            end
        end
    end
    toc
    
elseif lambdaFlag == 0
    tic
    for k=1:length(lambda_vec)
        
                n_o = predict(nlModel1,lambda_vec(k)*1e9);
        n_e = predict(nlModel2,lambda_vec(k)*1e9);
%         n_o_quartz = predict(nlModel3,lambda_vec(k)*1e9);
%         n_e_quartz = predict(nlModel4,lambda_vec(k)*1e9);
        
%         n_o = polyval(polyfit(refrac_mat(:,1),refrac_mat(:,2),3),lambda_vec(k)*1e9);
%         n_e = polyval(polyfit(refrac_mat(:,1),refrac_mat(:,3),3),lambda_vec(k)*1e9);
        
%         n_o_quartz = polyval(polyfit(refrac_mat_quartz(:,1),refrac_mat_quartz(:,2),3),lambda_vec(k)*1e9);
%         n_e_quartz = polyval(polyfit(refrac_mat_quartz(:,1),refrac_mat_quartz(:,3),3),lambda_vec(k)*1e9);
%         delta_n_quartz = n_o_quartz./(sqrt(1+(n_o_quartz^2/n_e_quartz^2-1)*sin(theta_vec_quartz).^2)) - n_o_quartz;
%         del_quartz(k,1) = 2*pi/lambda_vec(k)*delta_n_quartz*thickness_quartz;
        
        for kk=1:length(thickness_vec)
            for kkk=1:length(theta_vec)
                
                delta_n = n_o./(sqrt(1+(n_o^2/n_e^2-1)*sin(theta_vec(kkk)).^2)) - n_o;
                del(k,kk,kkk) = 2*pi/lambda_vec(k)*delta_n*thickness_vec(kk);
                
                for kkkk=1:length(alfa_vec)
                    %                     intensity(k,kk,kkk,kkkk) = sin(2*alfa_vec(kkkk))^2*sin(del(k,kk,kkk)/2)^2;
                    intensity(k,kk,kkk,kkkk) = cos(phi)^2-sin(2*(alfa_vec(kkkk)-phi))*sin(2*alfa_vec(kkkk))*sin(del(k,kk,kkk)/2)^2;
                end
            end
        end
    end
    toc
elseif lambdaFlag == 2
    thickness_quartz = 59.5e-6/1; %thickness of quartz full-waveplate [m]
    tic
    for k=1:length(lambda_vec)
%         n_o = polyval(polyfit(refrac_mat(:,1),refrac_mat(:,2),3),lambda_vec(k)*1e9);
%         n_e = polyval(polyfit(refrac_mat(:,1),refrac_mat(:,3),3),lambda_vec(k)*1e9);
%         
%         n_o_quartz = polyval(polyfit(refrac_mat_quartz(:,1),refrac_mat_quartz(:,2),3),lambda_vec(k)*1e9);
%         n_e_quartz = polyval(polyfit(refrac_mat_quartz(:,1),refrac_mat_quartz(:,3),3),lambda_vec(k)*1e9);
        
                n_o = predict(nlModel1,lambda_vec(k)*1e9);
        n_e = predict(nlModel2,lambda_vec(k)*1e9);
        n_o_quartz = predict(nlModel3,lambda_vec(k)*1e9);
        n_e_quartz = predict(nlModel4,lambda_vec(k)*1e9);
        
        
        
        delta_n_quartz = n_o_quartz./(sqrt(1+(n_o_quartz^2/n_e_quartz^2-1)*sin(theta_vec_quartz).^2)) - n_o_quartz;
        del_quartz(k,1) = 2*pi/lambda_vec(k)*delta_n_quartz*thickness_quartz;
        
        for kk=1:length(thickness_vec)
            for kkk=1:length(theta_vec)
                
                delta_n = n_o./(sqrt(1+(n_o^2/n_e^2-1)*sin(theta_vec(kkk)).^2)) - n_o;
                del(k,kk,kkk) = 2*pi/lambda_vec(k)*delta_n*thickness_vec(kk);
                
                %                 del(k,kk,kkk) = 2*pi/lambda_vec(k)*delta_n(kkk)*thickness_vec(kk);
                %                 del_quartz(k,kk,kkk) = 2*pi/lambda_vec(k)*delta_n_quartz(kkk)*thickness_quartz;
                for kkkk=1:length(alfa_vec)
                    %                 intensity(k,kk,kkk,kkkk) = sin(2*alfa_vec(kkkk))^2*sin(del(k,kk,kkk)/2)^2;
                    
                    intensity_waveplate(k,kk,kkk,kkkk) = ...
                        -sin(2*(alfa_vec(kkkk)-alfa_quartz))*sin(2*alfa_vec(kkkk))...
                        *cos(2*alfa_quartz)*sin(del(k,kk,kkk)/2)^2 ...
                        +sin(2*(alfa_vec(kkkk)-alfa_quartz))*cos(2*alfa_vec(kkkk))...
                        *sin(2*alfa_quartz)*sin(del_quartz(k,1)/2)^2 ...
                        +cos(alfa_vec(kkkk)-alfa_quartz)^2*sin(2*alfa_vec(kkkk))...
                        *sin(2*alfa_quartz)...
                        *sin((del(k,kk,kkk)+del_quartz(k,1))/2)^2 ...
                        -sin(alfa_vec(kkkk)-alfa_quartz)^2*sin(2*alfa_vec(kkkk))...
                        *sin(2*alfa_quartz) ...
                        *sin((del(k,kk,kkk)-del_quartz(k,1))/2)^2;
                    
                    %                     if intensity_waveplate(k,kk,kkk,kkkk) <= 0
                    %                         intensity(k,kk,kkk,kkkk) = 0+eps;
                    %                     else
                    %                         intensity(k,kk,kkk,kkkk) = (intensity_waveplate(k,kk,kkk,kkkk));
                    %                     end
                    %                     intensity(k,kk,kkk,kkkk) = (intensity_waveplate(k,kk,kkk,kkkk));
                    intensity(k,kk,kkk,kkkk) = abs(intensity_waveplate(k,kk,kkk,kkkk));
                    
                end
            end
        end
    end
    toc
end

% del = zeros(length(lambda_vec),length(thickness_vec),length(theta_vec));
% intensity = zeros(length(lambda_vec),length(thickness_vec),...
%     length(theta_vec),length(alfa_vec));
% for k=1:length(lambda_vec)
%     for kk=1:length(thickness_vec)
%         for kkk=1:length(theta_vec)
%             del(k,kk,kkk) = 2*pi/lambda_vec(k)*delta_n(kkk)*thickness_vec(kk);
%             for kkkk=1:length(alfa_vec)
%                 intensity(k,kk,kkk,kkkk) = sin(2*alfa_vec(kkkk))^2*sin(del(k,kk,kkk)/2)^2;
%             end
%         end
%     end
% end

%%


%% Apply light source temperature as spectral power distribution of light

% colorTemp = 3200;

% constants:
c1 = 3.7400e-16; c2 = 0.014388;

%monochromatic irradiance [W/m^3]
E = c1.*lambda_vec.^(-5)./( exp((c2/colorTemp)./lambda_vec) -1 );
E_normalized = E./max(E(:));





%%

% M_D65 =  [
%     0.8446965 -0.1179225  0.3948108
%     -0.1366303  1.1041226  0.1291718
%     0.0798489 -0.1348999  3.1924009];
% % M_D65 = [1 1 1];
%
%
% M_D65 =  [
%  0.9415037 -0.0321240  0.0584672
% -0.0428238  1.0250998  0.0203309
%  0.0101511 -0.0161170  1.2847354];
%
% M_D65 = 1;


%%

LXYZ = zeros(size(csf,1),length(thickness_vec),...
    length(theta_vec),length(alfa_vec));
tic
for k=1:length(thickness_vec)
    for kk=1:length(theta_vec)
        for kkk=1:length(alfa_vec)
            
            %             size(csf)
            %             size(E_normalized)
            %             size(intensity(:,k,kk,kkk))
            %             size((E_normalized'.*intensity(:,k,kk,kkk)))
            
            
            LXYZ(:,k,kk,kkk) = (csf*(E_normalized'.*intensity(:,k,kk,kkk)));
            %             LXYZ(:,k,kk,kkk) = csf*intensity(:,k,kk,kkk);
            %             size(LXYZ(:,k,kk,kkk))
        end
    end
end
toc


%% Perform chromatic adaptation

%color temperature [K] for target chromatic adaption to 6500K
% colorTempChrom = 6500;
E_chrom = c1.*lambda_vec.^(-5)./( exp((c2/colorTempChrom)./lambda_vec) -1 );
E_chrom_normalized = E_chrom./max(E_chrom(:));

%linearized Bradford Matrix
MA = [0.8951000  0.2664000 -0.1614000
    -0.7502000  1.7135000  0.0367000
    0.0389000 -0.0685000  1.0296000];

% MAinv = [0.9869929 -0.1470543  0.1599627
%     0.4323053  0.5183603  0.0492912
%     -0.0085287  0.0400428  0.9684867]

% MAinv = MA^-1;

LXYZ_whiteoriginal = zeros(size(csf,1),length(thickness_vec),...
    length(theta_vec),length(alfa_vec));

LXYZ_whitetarget = zeros(size(csf,1),length(thickness_vec),...
    length(theta_vec),length(alfa_vec));

tic
for k=1:length(thickness_vec)
    for kk=1:length(theta_vec)
        for kkk=1:length(alfa_vec)
            
            LXYZ_whiteoriginal(:,k,kk,kkk) = MA*(csf*E_normalized');
            LXYZ_whitetarget(:,k,kk,kkk) = MA*(csf*E_chrom_normalized');
            
            MCA = (MA^-1)*diag(LXYZ_whitetarget(:,k,kk,kkk)./LXYZ_whiteoriginal(:,k,kk,kkk))*MA;
            
            LXYZ(:,k,kk,kkk) = MCA*LXYZ(:,k,kk,kkk);
        end
    end
end
toc



%% Apply light source temperature as spectral power distribution of light

% colorTemp = 3200;
%
% % constants:
% c1 = 3.7400e-16; c2 = 0.0144;
%
% %monochromatic irradiance [W/m^3]
%   E = c1.*lambda_vec.^(-5)./( exp((c2/colorTemp)./lambda_vec) -1 );
%   E_normalized = E./max(E(:));
%
%   size(E_normalized)

%   size(LXYZ(:,k,kk,kkk))
%
%   for k=1:length(thickness_vec)
%       for kk=1:length(theta_vec)
%           for kkk=1:length(alfa_vec)
%               LXYZ(:,k,kk,kkk) = E_normalized*LXYZ(:,k,kk,kkk);
%           end
%       end
%   end

%%


%%


MRGB = [
    2.0414 -0.5649 -0.3447
    -0.9693 1.8760 0.0416
    0.0134 -0.1184 1.0154
    ]*10^-2;

% MRGB = [
%     2.0414 -0.5649 -0.3447
%     -0.9693 1.8760 0.0416
%     0.0134 -0.1184 1.0154
%     ];

% RGBlin = MRGB*LXYZ;

RGBlin = zeros(size(MRGB,1),length(thickness_vec),...
    length(theta_vec),length(alfa_vec));

tic
for k=1:length(thickness_vec)
    for kk=1:length(theta_vec)
        for kkk=1:length(alfa_vec)
            %             RGBlin(:,k,kk,kkk) = (MAinv*MRGB*MA)*LXYZ(:,k,kk,kkk);
            RGBlin(:,k,kk,kkk) = (MRGB)*LXYZ(:,k,kk,kkk);
        end
    end
end
toc

RGBnonlin = RGBlin;
RGBnonlin(RGBnonlin>1)=1; %set all values above 1 to 1
RGBnonlin(RGBnonlin<0)=0; %set all values below 0 to 0

%gamma filter (gamma=1/2.19921875)
RGBnonlinfil = zeros(size(RGBnonlin,1),length(thickness_vec),...
    length(theta_vec),length(alfa_vec));

tic
for k=1:length(thickness_vec)
    for kk=1:length(theta_vec)
        for kkk=1:length(alfa_vec)
            RGBnonlinfil(:,k,kk,kkk) = ...
                lin2rgb(RGBnonlin(:,k,kk,kkk),'ColorSpace','adobe-rgb-1998');
        end
    end
end
toc

% RGBlinfil = lin2rgb(RGBlin,'ColorSpace','adobe-rgb-1998');

RGBnonlinCLUT = RGBnonlinfil;

%% Calculate distinguishability and quality of interference colors

%length of visible range of light spectrum [m]
delta_lambda = lambda_vec(end)-lambda_vec(1);

%maximum intensity over visible light spectrum [-]
%     int_max(k) = max(intensity(k,:));
int_max = max(intensity,[],1);
% size(int_max)

%distinguishability function [-]
distinguishability = 1 - trapz(lambda_vec,intensity,1)./(int_max.*delta_lambda);

%quality function [-]
quality = distinguishability.*int_max;




%% Find closest value of color to target

% minError = zeros(length(thickness_vec),length(theta_vec),length(alfa_vec));
% for k=1:length(thickness_vec)
%     for kk=1:length(theta_vec)
%         for kkk=1:length(alfa_vec)
%             minError(k,kk,kkk) = sum(abs((RGBnon(:,k,kk,kkk))-colorTarget'));
%         end
%     end
% end
% [minValue,closestIndex] = min(minError,[],'all','linear');
% [thicknessIndex,thetaIndex,alfaIndex] = ind2sub(size(minError),closestIndex);
% closestIndexFinal = [I1,I2,I3];

% NN = RGBnon(:,1,:);
% [minValue,closestIndex] = min(sum(abs((RGBnon(:,:,:,:))-colorTarget'),1),[],2);
% closestValue = NN(closestIndex)
% squeeze(RGBnon(:,1,:))
% thetaIndex = find(...
%     squeeze(RGBnon(1,1,:)) >= colorTarget(1) & ...
%     squeeze(RGBnon(2,1,:)) >= colorTarget(2) & ...
%     squeeze(RGBnon(3,1,:)) >= colorTarget(3),1,'first');

% thetaIndex = find(squeeze(RGBnon(1,1,:)) >= colorTarget(1),1)
% thetaIndex = find(squeeze(RGBnon(2,1,:)) >= colorTarget(2),1)


%% Plot color

% fsize = 10;
%
% figure
% rectangle('Position',[1 1 1 1],...
%     'FaceColor',RGBnon(:,thicknessIndex,thetaIndex,alfaIndex),...
%     'EdgeColor',RGBnon(:,thicknessIndex,thetaIndex,alfaIndex))
%
% str0 = ['$h =$ ',num2str(thickness_vec(thicknessIndex)*1e3),'mm',...
%     ', $\theta =$ ',num2str(theta_vec(thetaIndex)*180/pi),'$^{\circ}$',...
%     ', $\alpha =$ ',num2str(alfa_vec(alfaIndex)*180/pi),'$^{\circ}$'];
% xdim = get(gca,'XLim');
% ydim = get(gca,'YLim');
% text(xdim(1)+(xdim(2)-xdim(1))*0.05,...
%     ydim(1)+(ydim(2)-ydim(1))*0.95,str0,...
%     'Interpreter','Latex','FontName','Times New Roman','FontSize',fsize)
%
% set(gca,'xtick',[])
% set(gca,'xticklabel',[])
% set(gca,'ytick',[])
% set(gca,'yticklabel',[])
% set(gca,'ztick',[])
% set(gca,'zticklabel',[])
% set(gca,'XColor','none')
% set(gca,'YColor','none')
% set(gca,'ZColor','none')
% axis tight
% axis equal
% set(gcf,'color','w')








end

