%%
% clear memory and previously allocated variables
delete(gcp('nocreate'))
clc;clear all;close all;


%% Load Grain Boundary Analysis Preprocessing (gbap) data

run ColorIceInputFile


%% Make directory and select file to load

% record directory in output folder
directory = dir(fullfile([pwd,subfolder],['gbapResultsData_*','.mat']));
directoryNameList = {directory.name}';
clear directory

% list of relevant files
TOCs = cell(size(directoryNameList,1),1);
for k = 1:size(directoryNameList,1)
    TOCs{k} = [num2str(k),':',' ',directoryNameList{k}];
end
fprintf('Table of Contents for Files: \n')
disp(TOCs)
clear k TOCs

% input explicit number from list
fileInput = input('Type number from list to load: ');

clc
disp(horzcat('Loading ',directoryNameList{fileInput}))


%% Load data file

%create name and find location for data file and load 
% load(fullfile([pwd,'/practice',subfolder],['gbapResultsData_',num2str(cropscale,'%0.2f'),'.mat']),'gbap')
tic
load(fullfile([pwd,subfolder],directoryNameList{fileInput}),'gbap')
toc
clear subfolder clear cropscale

gbap.statOption = statOption;

% numWorkers = 6; %number of workers in parfor computing [-]
% numWorkers = 4; %number of workers in parfor computing [-]
numCores = feature('numcores');
% numWorkers = numCores/2;
% numWorkers = numCores-2;
numWorkers = numCores;


if isfield(gbap,'grainExtinction')
    gbap = rmfield(gbap,{'grainExtinction','grainMaximum','grainTheta',...
        'grainExtinctionModeColormap','grainExtinctionMeanColormap','grainExtinctionMedianColormap',...
        'grainMaximumModeColormap','grainMaximumMeanColormap','grainMaximumMedianColormap'});
end


%% Plot cropped color image stack

figure;montage(gbap.imageStack(:,2), 'Size', [2 ceil(size(gbap.imageStack,1)/2)])


%% Determine mode/mean/median of grayscale pixel value for each grain

% clear grainAzimuth
% grainAzimuth = zeros(size(gbap.imageStack,1),length(gbap.optA(q).B)-(gbap.optA(q).N + 0),3);
% grainAzimuthArray = {};

disp(' ')
disp('Calculating grain azimuth array ...')
disp(' ')

if size(gbap.imageStack{1,2},1) > gbap.pixNumLim %image pixel limit for using parfor
    
    gbapParfor = gbap; %create new structure for parallel for-loop
    % convert to constant arrays in parallel pool
    poolconst = parallel.pool.Constant(gbapParfor);
    
    parpool('local',numWorkers);
    tic
    parfor q = 1:size(gbap.threshfacVec,1)
        
        % redefine parallel pool constant with original input array name for brevity
        gbapParfor = poolconst.Value;
        
        disp(q)
        
        for k = 1:size(gbapParfor.imageStack,1)
            %     for kk = optA(q).N+1:length(optA(q).B)
            for kk = 1:(length(gbapParfor.optA(q).B)-(gbapParfor.optA(q).N + 0))
                qq = kk + gbapParfor.optA(q).N + 0;
                for kkk = 1:3 %3:RGB color channels
                    imageMonochrome = (gbapParfor.imageStack{k,2}(:,:,kkk));
                    gbapParfor.grainMode(k,kk,kkk) = im2double(mode(imageMonochrome(gbapParfor.optA(q).L == qq),'all'));
                    gbapParfor.grainMean(k,kk,kkk) = im2double(mean2(imageMonochrome(gbapParfor.optA(q).L == qq)))./255;
                    gbapParfor.grainMedian(k,kk,kkk) = im2double(median(imageMonochrome(gbapParfor.optA(q).L == qq),'all'));
                end
            end
        end
        grainModeArray{q} = gbapParfor.grainMode;
        grainMeanArray{q} = gbapParfor.grainMean;
        grainMedianArray{q} = gbapParfor.grainMedian;
    end
    toc
    delete(gcp('nocreate'))
    gbap.grainModeArray = grainModeArray;
    gbap.grainMeanArray = grainMeanArray;
    gbap.grainMedianArray = grainMedianArray;
    clear poolconst gbapParfor grainAzimuthArray
    
else
    grainMode = [];
    grainMean = [];
    grainMedian = [];
    tic
    for q = 1:size(gbap.threshfacVec,1)
        for k = 1:size(gbap.imageStack,1)
            %     for kk = optA(q).N+1:length(optA(q).B)
            for kk = 1:(length(gbap.optA(q).B)-(gbap.optA(q).N + 0))
                qq = kk + gbap.optA(q).N + 0;
                for kkk = 1:3 %3:RGB color channels
                    imageMonochrome = (gbap.imageStack{k,2}(:,:,kkk));
                    grainMode(k,kk,kkk) = im2double(mode(imageMonochrome(gbap.optA(q).L == qq),'all'));
                    grainMean(k,kk,kkk) = im2double(mean2(imageMonochrome(gbap.optA(q).L == qq)))./255;
                    grainMedian(k,kk,kkk) = im2double(median(imageMonochrome(gbap.optA(q).L == qq),'all'));
                end
            end
        end
        gbap.grainModeArray{q} = grainMode;
        gbap.grainMeanArray{q} = grainMean;
        gbap.grainMedianArray{q} = grainMedian;
        %     grainAzimuth = [];
    end
    toc
    % gbap.grainAzimuthArray = grainAzimuthArray;
    
end


%% Determine extinction and max brightness angles for each grain

% disp('calculating grain azimuth extinction')
% tic
% grainExtinction = zeros(size(gbap.threshfacVec,1),length(gbap.optA(q).B)-(gbap.optA(q).N + 0));
% grainExtinction = [];
% grainExtinction = {};

for q = 1:size(gbap.threshfacVec,1)
    for kk = 1:(length(gbap.optA(q).B)-(gbap.optA(q).N + 0))
        %         [profileMinMatValue,profileMinMatIndex] = min(rgb2gray(squeeze(grainAzimuth(:,kk,:,q))));
        %         [profileMinMatValue,profileMinMatIndex] = min(rgb2gray((grainAzimuth(:,kk,:,q))));
        
        
        if gbap.statOption == 1
            colorDistance = sqrt(...
                double(gbap.grainModeArray{q}(:,kk,1)).^2 + ...
                double(gbap.grainModeArray{q}(:,kk,2)).^2 + ...
                double(gbap.grainModeArray{q}(:,kk,3)).^2);
        elseif gbap.statOption == 2
            colorDistance = sqrt(...
                double(gbap.grainMeanArray{q}(:,kk,1)).^2 + ...
                double(gbap.grainMeanArray{q}(:,kk,2)).^2 + ...
                double(gbap.grainMeanArray{q}(:,kk,3)).^2);
        elseif gbap.statOption == 3
            colorDistance = sqrt(...
                double(gbap.grainMedianArray{q}(:,kk,1)).^2 + ...
                double(gbap.grainMedianArray{q}(:,kk,2)).^2 + ...
                double(gbap.grainMedianArray{q}(:,kk,3)).^2);
        end
        
        %         [profileMinMatValue,profileMinMatIndex] = min(colorDistance);
        %         [profileMaxMatValue,profileMaxMatIndex] = max(colorDistance);
        [~,profileMinMatIndex] = min(colorDistance);
        [~,profileMaxMatIndex] = max(colorDistance);
        
        %         [profileMinMatValue,profileMinMatIndex] = min(rgb2gray(uint8(gbap.grainAzimuthArray{q}(:,kk,:))));
        %         grainExtinction(q,kk) = gbap.angleVec(profileMinMatIndex);
        gbap.grainExtinction{q,kk} = gbap.angleVec(profileMinMatIndex);
        
        %define brightest grain angle as 45deg from extinction
        if gbap.angleVec(end) > 0 %positive angles
            if abs(gbap.grainExtinction{q,kk}) > (abs(gbap.angleVec(end)) - 45)
                grainMaximumIndex = find(gbap.angleVec >= gbap.grainExtinction{q,kk} - 45,1);
                gbap.grainMaximum{q,kk} = gbap.angleVec(grainMaximumIndex);
                %                 gbap.grainMaximum{q,kk} = gbap.grainExtinction{q,kk} - 45;
            else
                grainMaximumIndex = find(gbap.angleVec >= gbap.grainExtinction{q,kk} + 45,1);
                gbap.grainMaximum{q,kk} = gbap.angleVec(grainMaximumIndex);
                %                 gbap.grainMaximum{q,kk} = gbap.grainExtinction{q,kk} + 45;
            end
        elseif gbap.angleVec(end) < 0 %negative angles
            if abs(gbap.grainExtinction{q,kk}) > (abs(gbap.angleVec(end)) - 45)
                grainMaximumIndex = find(abs(gbap.angleVec) >= abs(gbap.grainExtinction{q,kk}) - 45,1);
                gbap.grainMaximum{q,kk} = gbap.angleVec(grainMaximumIndex);
                %                 gbap.grainMaximum{q,kk} = -1*(abs(gbap.grainExtinction{q,kk}) - 45);
            else
                grainMaximumIndex = find(abs(gbap.angleVec) >= abs(gbap.grainExtinction{q,kk}) + 45,1);
                gbap.grainMaximum{q,kk} = gbap.angleVec(grainMaximumIndex);
                %                 gbap.grainMaximum{q,kk} = -1*(abs(gbap.grainExtinction{q,kk}) + 45);
            end
        end
        
        %         [gbap.grainExtinction{q,kk} gbap.grainMaximum{q,kk}]
        
        %         gbap.grainMaximum{q,kk} = gbap.angleVec(profileMaxMatIndex);
    end
end
% toc
clear colorDistance


%% Generate birefringence color look-up table (CLUT)

% gbap.thicknessVecTolerance = 0.10; %thickness tolerance for look-up table [mm]
gbap.thicknessVecStep = 0.01; %thickness vector step size [mm]

%ice cross section thickness [m]
% thickness_vec = ((min(gbap.thicknessArrayInterpCrop(:))-0.1:0.05:max(gbap.thicknessArrayInterpCrop(:))+0.1)*10^-3)';
gbap.thickness_vec = ((round( min(gbap.thicknessArrayInterpCrop(:)) ,2)-gbap.thicknessVecTolerance:gbap.thicknessVecStep:round( max(gbap.thicknessArrayInterpCrop(:)) ,2)+gbap.thicknessVecTolerance)*1e-3)';

%inclination/zenith angle between incident ray and c-axis [rad]
% theta_vec = (0:0.5:90)'*pi/180;
% theta_vec = (0:0.1:90)'*pi/180;
gbap.theta_vec = (0:0.2:90)'*pi/180;
% theta_vec = (23.0:0.5:90)'*pi/180;
% theta_vec = (45.0:0.5:90)'*pi/180;

%azimuth angle between polarization planes of incident ray and extraordinary ray [rad]
% gbap.alfa_vec = (44:0.5:46)'*pi/180;
% gbap.alfa_vec = (40.5:0.5:49.5)'*pi/180;
% gbap.alfa_vec = (40.5:0.5:45.0)'*pi/180;
gbap.alfa_vec = (45)'*pi/180;

%chromatic adaptation target color temperature [k]
% colorTempChrom_vec = (6500:1000:12500)';
% colorTempChrom_vec = (5500)';
% gbap.colorTempChrom_vec = (6504)';
gbap.colorTempChrom = (6504)';
% gbap.colorTempChrom = (6000)';
% colorTempChrom_vec = (8500)';
% colorTempChrom_vec = (7500)';
% colorTempChrom_vec = (4000)';
% colorTempChrom_vec = (3200)';
% colorTempChrom_vec = (2500)';

gbap.colorShift = 1.15; %color perturbation (shift) factor [-]

disp(' ')
disp('Generating interference colors look-up table ...')
disp(' ')

tic
% [RGBnonlinCLUT] = birefringenceColorLookUpTable(thickness_vec,theta_vec,alfa_vec);
lambdaFlag = 0; %flag for wave plate inserted (0=no,1=quarter,2=full)
polFlag = 1; %flag for crossed- or plane-polarization (1 or 0) (only functions without wave plate)
% colorTemp = 4000; %light source color temperature [2700,3200,5500,6500,7500]K
% colorTemp = 3200; %light source color temperature [2700,3200,5500,6500,7500]K
% colorTempChrom = 7500; %chromatic adaption color temperature [K] (6500 target)
% colorTempChrom = 9500; %chromatic adaption color temperature [K] (6500 target)
% for ii = 1:length(colorTempChrom_vec)
%     gbap.colorTempChrom = colorTempChrom_vec(ii);
[~,gbap.RGBnonlinCLUT,~] = birefringenceColorLookUpTableV01(gbap.thickness_vec,gbap.theta_vec,gbap.alfa_vec,lambdaFlag,polFlag,gbap.colorTemp,gbap.colorTempChrom);
% end
toc


%% Convert RGB Look-up table to L*a*b colorspace

for r=1:size(gbap.RGBnonlinCLUT,2)
    for rr=1:size(gbap.RGBnonlinCLUT,3)
        for rrr=1:size(gbap.RGBnonlinCLUT,4)
            gbap.LabCLUT(:,r,rr,rrr) = rgb2lab(gbap.RGBnonlinCLUT(:,r,rr,rrr)','ColorSpace','adobe-rgb-1998','WhitePoint','d65')';
        end
    end
end

% disp(' ')
% disp('Converting interference colors look-up table to L*a*b ...')
% disp(' ')

% colorTargetLab = zeros(3,size(gbap.threshfacVec,1),(length(gbap.optA(q).B)-(gbap.optA(q).N + 0)));
tic
for q = 1:size(gbap.threshfacVec,1)
    for kk = 1:(length(gbap.optA(q).B)-(gbap.optA(q).N + 0))
        maximumIndex = find(gbap.angleVec == gbap.grainMaximum{q,kk},1);
        
        
        if gbap.statOption == 1
            colorTarget = squeeze(gbap.grainModeArray{q}(maximumIndex,kk,:));
            
        elseif gbap.statOption == 2
            colorTarget = squeeze(gbap.grainMeanArray{q}(maximumIndex,kk,:));
            
        elseif gbap.statOption == 3
            colorTarget = squeeze(gbap.grainMedianArray{q}(maximumIndex,kk,:));
            
        end
        
        
%         colorTarget = squeeze(gbap.grainModeArray{q}(maximumIndex,kk,:));
        
        
        
        
        gbap.colorTargetLab{q,kk} = rgb2lab(colorTarget','ColorSpace','adobe-rgb-1998','WhitePoint','d65')';
    end
end
toc


%% Determine inclination angles (theta) for each grain for each threshold

disp(' ')
disp('Finding grain inclination angles ...')
disp(' ')

% gbap.grainTheta
if isfield(gbap,'grainTheta')
    gbap = rmfield(gbap,'grainTheta');
end

gbapParfor = gbap; %create new structure for parallel for-loop
% convert to constant arrays in parallel pool
poolconst = parallel.pool.Constant(gbapParfor);

parpool('local',numWorkers);

tic
% for q = 1:size(gbap.threshfacVec,1)
parfor q = 1:size(gbap.threshfacVec,1)
    
    % redefine parallel pool constant with original input array name for brevity
    gbapParfor = poolconst.Value;
    
    disp(q)
    
    %         disp(length(gbapParfor.optA(q).B))
    
    for kk = 1:(length(gbapParfor.optA(q).B)-(gbapParfor.optA(q).N + 0))
        
        %         disp(kk)
        
        qq = kk + gbapParfor.optA(q).N;
        
        %         disp('test')
        
        %thickness from interpolated array, using centroid values
        %(x(1)=column, y(2)=row)
        thickness = round( gbapParfor.thicknessArrayInterpCrop(...
            round(gbapParfor.stats(q).regionProps.Centroid(qq,2)),...
            round(gbapParfor.stats(q).regionProps.Centroid(qq,1))) ,2)*1e-3;
        %         text(gbap.stats(q).regionProps.Centroid(qq,1),gbap.stats(q).regionProps.Centroid(qq,2)
        
        %find index of thickness corresponding to centroid of grain
        %         thicknessIndex_grain = find(gbapParfor.thickness_vec >= thickness,1)-1;
        thicknessIndex_grain = find(gbapParfor.thickness_vec >= thickness,1);
        
        %         disp(gbapParfor.thickness_vec(thicknessIndex_grain-(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep):thicknessIndex_grain+(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep))'*1e3)
        %         disp([gbapParfor.thickness_vec(thicknessIndex_grain-(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep))*1e3 gbapParfor.thickness_vec(thicknessIndex_grain+(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep))*1e3])
        
        %         for ii = 1:length(gbapParfor.colorTempChrom_vec)
        
        %limit color look-up table to thickness of centroid of grain with tolerance
        %             RGBnonlinCLUT_grain = gbapParfor.RGBnonlinCLUT(:,thicknessIndex_grain-(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep-1):thicknessIndex_grain+(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep-1),:,:);
        RGBnonlinCLUT_grain = gbapParfor.RGBnonlinCLUT(:,thicknessIndex_grain-(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep):thicknessIndex_grain+(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep),:,:);
        LabCLUT_grain = gbapParfor.LabCLUT(:,thicknessIndex_grain-(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep):thicknessIndex_grain+(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep),:,:);
        
        
        maximumIndex = find(gbapParfor.angleVec == gbapParfor.grainMaximum{q,kk},1);
        colorTarget = squeeze(gbapParfor.grainModeArray{q}(maximumIndex,kk,:));
%         colorTargetLab = rgb2lab(colorTarget')';
        
        % RGBnonlinCLUT_grain
        %             minError = zeros(length(colorTempChrom_vec),size(RGBnonlinCLUT_grain,2),size(RGBnonlinCLUT_grain,3),size(RGBnonlinCLUT_grain,4));
        
        %Find closest value of color to target
        minError = zeros(size(RGBnonlinCLUT_grain,2),size(RGBnonlinCLUT_grain,3),size(RGBnonlinCLUT_grain,4));
%         minErrorShift = zeros(size(RGBnonlinCLUT_grain,2),size(RGBnonlinCLUT_grain,3),size(RGBnonlinCLUT_grain,4));
        
        for r=1:size(RGBnonlinCLUT_grain,2)
            for rr=1:size(RGBnonlinCLUT_grain,3)
                for rrr=1:size(RGBnonlinCLUT_grain,4)
                    %                     minError(r,rr,rrr) = sum(abs((RGBnonlinCLUT_grain(:,r,rr,rrr))-colorTarget));
%                     minError(r,rr,rrr) = sqrt(sum(((RGBnonlinCLUT_grain(:,r,rr,rrr))-colorTarget).^2));
                    % disp(size(RGBnonlinCLUT_grain(:,r,rr,rrr)'))
                    % disp(size(colorTarget'))
%                     tic
%                     minError(r,rr,rrr) = deltaE(RGBnonlinCLUT_grain(:,r,rr,rrr)',colorTarget');
%                     minError(r,rr,rrr) = deltaE(LabCLUT_grain(:,r,rr,rrr)',colorTargetLab');
%                     minError(r,rr,rrr) = deltaE(LabCLUT_grain(:,r,rr,rrr)',gbapParfor.colorTargetLab{q,kk}','isInputLab',true);
                    minError(r,rr,rrr) = imcolordiff(LabCLUT_grain(:,r,rr,rrr)',gbapParfor.colorTargetLab{q,kk}','isInputLab',true);
%                     toc
                    %                         minErrorShift(ii,r,rr,rrr) = sqrt(sum(((RGBnonlinCLUT_grain(:,r,rr,rrr))-colorTarget*colorShift).^2));
%                     minErrorShift(r,rr,rrr) = sqrt( sum( ( (RGBnonlinCLUT_grain(:,r,rr,rrr)) - (colorTarget.*gbapParfor.colorShift) ).^2) ) + ...
%                         sqrt( ...
%                         ((RGBnonlinCLUT_grain(1,r,rr,rrr)/RGBnonlinCLUT_grain(2,r,rr,rrr))-(colorTarget(1)*gbapParfor.colorShift/colorTarget(2)*gbapParfor.colorShift)).^2 + ...
%                         ((RGBnonlinCLUT_grain(2,r,rr,rrr)/RGBnonlinCLUT_grain(3,r,rr,rrr))-(colorTarget(2)*gbapParfor.colorShift/colorTarget(3)*gbapParfor.colorShift)).^2 + ...
%                         ((RGBnonlinCLUT_grain(3,r,rr,rrr)/RGBnonlinCLUT_grain(1,r,rr,rrr))-(colorTarget(3)*gbapParfor.colorShift/colorTarget(1)*gbapParfor.colorShift)).^2 );
                end
            end
        end
        %         end
        [minValue,closestIndex] = min(minError,[],'all','linear');
        [thicknessIndex,thetaIndex,alfaIndex] = ind2sub(size(minError),closestIndex);
        
%         [minValueShift,closestIndexShift] = min(minErrorShift,[],'all','linear');
%         [thicknessIndexShift,thetaIndexShift,alfaIndexShift] = ind2sub(size(minErrorShift),closestIndexShift);
        
        %perturb color by brightness shift of (15%) and check angle change
%         if gbapParfor.theta_vec(thetaIndex)*180/pi <= 40 && abs( ((gbapParfor.theta_vec(thetaIndexShift)*180/pi) - (gbapParfor.theta_vec(thetaIndex)*180/pi))/(gbapParfor.theta_vec(thetaIndex)*180/pi) ) >= (gbapParfor.colorShift - 1)
%             %             disp(abs( ((gbapParfor.theta_vec(thetaIndexShift)*180/pi) - (gbapParfor.theta_vec(thetaIndex)*180/pi))/(gbapParfor.theta_vec(thetaIndex)*180/pi) ))
%             %             gbapParfor.grainTheta{q,kk} = gbapParfor.theta_vec(thetaIndexShift)*180/pi;
%             gbapParfor.grainTheta(kk) = gbapParfor.theta_vec(thetaIndexShift)*180/pi;
%             
%             disp([num2str(q), ' shifted! ', ...
%                 num2str(gbapParfor.thickness_vec(thicknessIndex_grain-(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep))*1e3,'%.4f'),...
%                 ' ',num2str(gbapParfor.thickness_vec(thicknessIndex_grain+(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep))*1e3,'%.4f'),...
%                 ' ',num2str(gbapParfor.theta_vec(thetaIndex)*180/pi,2),' ',...
%                 num2str(gbapParfor.theta_vec(thetaIndexShift)*180/pi,2) ])
%             
%             %             disp([gbapParfor.thickness_vec(thicknessIndex_grain-(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep))*1e3 gbapParfor.thickness_vec(thicknessIndex_grain+(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep))*1e3])
%             %             grainTheta{q,kk} = gbapParfor.theta_vec(thetaIndexShift)*180/pi;
%         elseif gbapParfor.theta_vec(thetaIndex)*180/pi <= 40 && abs( ((gbapParfor.theta_vec(thetaIndexShift)*180/pi) - (gbapParfor.theta_vec(thetaIndex)*180/pi))/(gbapParfor.theta_vec(thetaIndex)*180/pi) ) < (gbapParfor.colorShift - 1)
%             
%             gbapParfor.grainTheta(kk) = gbapParfor.theta_vec(thetaIndex)*180/pi;
%             
%             disp([num2str(q), ' not shifted, check! ', ...
%                 num2str(gbapParfor.thickness_vec(thicknessIndex_grain-(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep))*1e3,'%.4f'),...
%                 ' ',num2str(gbapParfor.thickness_vec(thicknessIndex_grain+(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep))*1e3,'%.4f'),...
%                 ' ',num2str(gbapParfor.theta_vec(thetaIndex)*180/pi,2),' ',...
%                 num2str(gbapParfor.theta_vec(thetaIndexShift)*180/pi,2) ])
%         else
%             %             gbapParfor.grainTheta{q,kk} = gbapParfor.theta_vec(thetaIndex)*180/pi;
%             gbapParfor.grainTheta(kk) = gbapParfor.theta_vec(thetaIndex)*180/pi;
%             %             grainTheta{q,kk} = gbapParfor.theta_vec(thetaIndex)*180/pi;
% %                         disp([num2str(q), ' not shifted ', ...
% %                 num2str(gbapParfor.thickness_vec(thicknessIndex_grain-(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep))*1e3,'%.4f'),...
% %                 ' ',num2str(gbapParfor.thickness_vec(thicknessIndex_grain+(gbapParfor.thicknessVecTolerance/gbapParfor.thicknessVecStep))*1e3,'%.4f'),...
% %                 ' ',num2str(gbapParfor.theta_vec(thetaIndex)*180/pi,2),' ',...
% %                 num2str(gbapParfor.theta_vec(thetaIndexShift)*180/pi,2) ])
%         end
        gbapParfor.grainTheta(kk) = gbapParfor.theta_vec(thetaIndex)*180/pi;
        
        %         disp(colorTempChrom_vec(colorTempChromIndex))
        %         gbap.grainTheta{q,kk} = theta_vec(thetaIndex)*180/pi;
        
        %         grainModeArray{q} = gbapParfor.grainMode;
        %         grainMeanArray{q} = gbapParfor.grainMean;
        %         grainMedianArray{q} = gbapParfor.grainMedian;
        
        
    end
    
    grainThetaArray{q} = gbapParfor.grainTheta;
    
    
end
toc
delete(gcp('nocreate'))
% gbap.grainTheta = grainTheta;
gbap.grainTheta = grainThetaArray;
clear gbapParfor


%% Create vibrant colormaps for schmidt plots

for q = 1:size(gbap.threshfacVec,1)
    %     nexttile
    %     hold on
    for kk = 1:(length(gbap.optA(q).B)-(gbap.optA(q).N + 0))
        
        %extinction color
        minimumIndex = find(gbap.angleVec == gbap.grainExtinction{q,kk},1);
        %         colorTarget = squeeze(gbap.grainModeArray{q}(minimumIndex,kk,:));
        gbap.grainExtinctionModeColormap{q,kk} = squeeze(gbap.grainModeArray{q}(minimumIndex,kk,:));
        gbap.grainExtinctionMeanColormap{q,kk} = squeeze(gbap.grainMeanArray{q}(minimumIndex,kk,:));
        gbap.grainExtinctionMedianColormap{q,kk} = squeeze(gbap.grainMedianArray{q}(minimumIndex,kk,:));
        
        %brightest color
        maximumIndex = find(gbap.angleVec == gbap.grainMaximum{q,kk},1);
        %         colorTarget = squeeze(gbap.grainModeArray{q}(maximumIndex,kk,:));
        gbap.grainMaximumModeColormap{q,kk} = squeeze(gbap.grainModeArray{q}(maximumIndex,kk,:));
        gbap.grainMaximumMeanColormap{q,kk} = squeeze(gbap.grainMeanArray{q}(maximumIndex,kk,:));
        gbap.grainMaximumMedianColormap{q,kk} = squeeze(gbap.grainMedianArray{q}(maximumIndex,kk,:));
    end
end


%% Schmidt plot

% figure
scrsz = get(groot,'ScreenSize');
figure('Position',...
    [scrsz(3)*0.02 scrsz(4)*0.15 scrsz(3)*0.95 scrsz(4)*0.70]);
% 'Position' definition: [left bottom width height]

% tiledlayout(1+(size(gbap.threshfacVec,1)>1),ceil(size(gbap.threshfacVec,1)/2),'TileSpacing','loose','Padding','loose');
tiledlayout(1+(size(gbap.threshfacVec,1)>1),ceil(size(gbap.threshfacVec,1)/2));
for q = 1:size(gbap.threshfacVec,1)
    nexttile
    %     ps = polarscatter(deg2rad([gbap.grainExtinction{q,:}]),[gbap.grainTheta{q,:}],[],[gbap.grainExtinctionModeColormap{q,:}]','filled');
    ps = polarscatter(deg2rad([gbap.grainExtinction{q,:}]),[gbap.grainTheta{q}(:)],[],[gbap.grainExtinctionModeColormap{q,:}]','filled');
    ps.SizeData = 10; %marker size (default=36)
    %     polarscatter(deg2rad([gbap.grainMaximum{q,:}]),[gbap.grainTheta{q,:}],[],[gbap.grainMaximumModeColormap{q,:}]','filled')
    
    title(['threshold=',num2str(gbap.threshfacVec(q),2)],...
        'Interpreter','Latex','FontName','Times New Roman','FontSize',gbap.fontSize+1)
    %     hold off
    ax = gca;
    ax.RLim = [0 90];
    set(gca,'FontName','Times New Roman')
    set(gca,'FontSize',8)
    set(gcf,'color','w')
end


%% Plot c-axes for each grain for each threshold

%limits plot to labeling at most 149 grains per threshold value
if (length(gbap.optA(1).B)-(gbap.optA(1).N + 0)) < 150
    
    % figure
    scrsz = get(groot,'ScreenSize');
    figure('Position',...
        [scrsz(3)*0.02 scrsz(4)*0.15 scrsz(3)*0.95 scrsz(4)*0.70]);
    % 'Position' definition: [left bottom width height]
    
    tiledlayout(1+(size(gbap.threshfacVec,1)>1),ceil(size(gbap.threshfacVec,1)/2),'TileSpacing','tight','Padding','compact');
    for q = 1:size(gbap.threshfacVec,1)
        nexttile
        baseImage = rgb2gray(gbap.imageStack{1,2});
        mask = boundarymask(gbap.optA(q).L);
        baseImage = imoverlay(baseImage,mask,gbap.CM(q,:));
        imshow(baseImage)
        
        for kk = 1:(length(gbap.optA(q).B)-(gbap.optA(q).N + 0))
            hold on
            % stats(q).regionProps.Centroid
            qq = kk + gbap.optA(q).N;
            text(gbap.stats(q).regionProps.Centroid(qq,1),gbap.stats(q).regionProps.Centroid(qq,2),['\leftarrow',num2str(gbap.grainExtinction{q,kk})],'Color','w')
        end
        hold off
        
        title(['threshold=',num2str(gbap.threshfacVec(q),2)])
    end
    
end

% for kk = 1:(length(gbap.optA(q).B)-(gbap.optA(q).N + 0))
%     hold on
%     % stats(q).regionProps.Centroid
%     qq = kk + gbap.optA(q).N;
%     text(stats(q).regionProps.Centroid(qq,1),stats(q).regionProps.Centroid(qq,2),['\leftarrow',num2str(grainExtinction(kk))],'Color','w')
% end
% hold off
% title(['threshold=',num2str(gbap.threshfacVec(q),2)])


%% C-axis azimuth distribution per grain
% figure;polarscatter(deg2rad(grainExtinction(:)),ones(length(grainExtinction(q,:)),1),1)

% figure
scrsz = get(groot,'ScreenSize');
figure('Position',...
    [scrsz(3)*0.02 scrsz(4)*0.15 scrsz(3)*0.95 scrsz(4)*0.70]);
% 'Position' definition: [left bottom width height]

tiledlayout(1+(size(gbap.threshfacVec,1)>1),ceil(size(gbap.threshfacVec,1)/2),'TileSpacing','loose','Padding','loose');
for q = 1:size(gbap.threshfacVec,1)
    nexttile
    polarhistogram(deg2rad([gbap.grainExtinction{q,:}])',length(gbap.angleVec)+0)
    title(['threshold=',num2str(gbap.threshfacVec(q),2)],'FontName','Times New Roman','FontSize',gbap.fontSize)
end
dim = [0.50 0.98 0.00 0.00]; %[x y w h]
str = 'Distribution of c-axis azimuth by grain';
annotation('textbox',dim,'String',str,'FitBoxToText','on',...
    'EdgeColor','none','HorizontalAlignment','center',...
    'VerticalAlignment','middle',...
    'FontName','Times New Roman','FontWeight','bold','FontSize',gbap.fontSize+1);
set(gcf,'color','w')
% title('Distribution of c-axis azimuth by grain')


%% Determine circular polarized image from image stack

% imageCirPol = im2double(rgb2gray(gbap.imageStack{1,2}));
% for k = 2:size(gbap.imageStack,1)
%     imageCirPol = imadd(imageCirPol,im2double(rgb2gray(gbap.imageStack{k,2})));
% end
% gbap.imageCirPoleq = histeq(im2uint8(imageCirPol/size(gbap.imageStack,1)));
% gbap.imageCirPol = (im2uint8(imageCirPol/size(gbap.imageStack,1)));
% 
% % figure;imshow(imageCirPol)
% figure;imshowpair(gbap.imageCirPoleq,gbap.imageCirPol,'montage')
% title('Digital circular polarization')


%% Determine grayscale value profile for a selected pixel

profileArray = zeros(size(gbap.imageStack{1,2},1),size(gbap.imageStack{1,2},2),size(gbap.imageStack,1));

for k = 1:size(gbap.imageStack,1)
    
    %     profileArray(:,:,k) = im2double(rgb2gray(imageStack{k,1}));
    profileArray(:,:,k) = (rgb2gray(gbap.imageStack{k,2}));
end


%% Determine minimum values from grayscale profiles for each pixel

[profileMinMatValue,profileMinMatIndex] = min(profileArray,[],3);

% figure;imshow(profileMinMatValue)
% figure;imshow(profileMinMatIndex)

gbap.imageAzimuthAngle = zeros(size(profileMinMatIndex));
for k = 1:size(profileMinMatIndex,1)
    for kk = 1:size(profileMinMatIndex,2)
        gbap.imageAzimuthAngle(k,kk) = gbap.angleVec(profileMinMatIndex(k,kk));
    end
end

% figure
scrsz = get(groot,'ScreenSize');
figure('Position',...
    [scrsz(3)*0.02 scrsz(4)*0.15 scrsz(3)*0.95 scrsz(4)*0.70]);
% 'Position' definition: [left bottom width height]

subplot(1,2,1)
% imhist(imageCirPol)
% figure;polarscatter(deg2rad(azimuthAngle(:)),90*ones(numel(azimuthAngle),1))
polarscatter(deg2rad(gbap.imageAzimuthAngle(:)),gbap.imageCirPol(:),1)
ax = gca;
ax.RLim = [0 255];
title('CirPol c-axis pixel azimuth and grayscale values')

subplot(1,2,2)
polarhistogram(deg2rad(gbap.imageAzimuthAngle(:)),length(gbap.angleVec)+0)
title('CirPol distribution of c-axis azimuth by pixel')


%% Extinction composite image

disp(' ')
disp('Building extinction composite image ...')
disp(' ')

% figure
scrsz = get(groot,'ScreenSize');
figure('Position',...
    [scrsz(3)*0.02 scrsz(4)*0.15 scrsz(3)*0.95 scrsz(4)*0.70]);
%'Position' definition: [left bottom width height]

tic
tiledlayout(1+(size(gbap.threshfacVec,1)>1),ceil(size(gbap.threshfacVec,1)/2),'TileSpacing','tight','Padding','compact');
for q = 1:size(gbap.threshfacVec,1)
    nexttile
    %     baseImage = (gbap.imageStack{1,2});
    %     imageExtinctionComposite = gbap.imageStack{1,2};
    imageExtinctionComposite = zeros(size(gbap.imageStack{1,2},1),...
        size(gbap.imageStack{1,2},2),size(gbap.imageStack{1,2},3),'uint8');
    
    
    for kk = 1:(length(gbap.optA(q).B)-(gbap.optA(q).N + 0))
        qq = kk + gbap.optA(q).N + 0;
        extinctionIndex = find(gbap.angleVec == gbap.grainExtinction{q,kk},1);
        exinctionImage = gbap.imageStack{extinctionIndex,2};
        imageExtinctionComposite(repmat(gbap.optA(q).L == qq,[1 1 3])) = ...
            exinctionImage(repmat(gbap.optA(q).L == qq,[1 1 3]));
    end
    %     imshow(imageExtinctionComposite)
    mask = boundarymask(gbap.optA(q).L);
    %     imageExtinctionComposite = imoverlay(imageExtinctionComposite,mask,gbap.CM(q,:));
    gbap.imageExtinctionComposite{q} = imoverlay(imageExtinctionComposite,mask,'w');
    imshow(gbap.imageExtinctionComposite{q})
    
    title(['threshold=',num2str(gbap.threshfacVec(q),2)],...
        'Interpreter','Latex','FontName','Times New Roman','FontSize',gbap.fontSize+1)
end
% set(gca,'FontName','Times New Roman') set(gca,'FontSize',gbap.fontSize)
dim = [0.50 0.98 0.00 0.00]; %[x y w h]
str = 'Extinction composite';
annotation('textbox',dim,'String',str,'FitBoxToText','on',...
    'EdgeColor','none','HorizontalAlignment','center',...
    'VerticalAlignment','middle',...
    'FontName','Times New Roman','FontWeight','bold','FontSize',gbap.fontSize+1);
set(gcf,'color','w')
toc

%% Maximum brightness composite image

disp(' ')
disp('Building maximum brightness composite image ...')
disp(' ')

% figure
scrsz = get(groot,'ScreenSize');
figure('Position',...
    [scrsz(3)*0.02 scrsz(4)*0.15 scrsz(3)*0.95 scrsz(4)*0.70]);
%'Position' definition: [left bottom width height]

tic
tiledlayout(1+(size(gbap.threshfacVec,1)>1),ceil(size(gbap.threshfacVec,1)/2),'TileSpacing','tight','Padding','compact');
for q = 1:size(gbap.threshfacVec,1)
    nexttile
    %     baseImage = (gbap.imageStack{1,2});
    %     imageMaximumComposite = gbap.imageStack{1,2};
    imageMaximumComposite = zeros(size(gbap.imageStack{1,2},1),...
        size(gbap.imageStack{1,2},2),size(gbap.imageStack{1,2},3),'uint8');
    
    
    
    for kk = 1:(length(gbap.optA(q).B)-(gbap.optA(q).N + 0))
        qq = kk + gbap.optA(q).N + 0;
        maximumIndex = find(gbap.angleVec == gbap.grainMaximum{q,kk},1);
        maximumImage = gbap.imageStack{maximumIndex,2};
        imageMaximumComposite(repmat(gbap.optA(q).L == qq,[1 1 3])) = ...
            maximumImage(repmat(gbap.optA(q).L == qq,[1 1 3]));
    end
    %     imshow(imageMaximumComposite)
    
    mask = boundarymask(gbap.optA(q).L);
    %     imageMaximumComposite = imoverlay(imageMaximumComposite,mask,gbap.CM(q,:));
    gbap.imageMaximumComposite{q} = imoverlay(imageMaximumComposite,mask,'w');
    imshow(gbap.imageMaximumComposite{q})
    
    title(['threshold=',num2str(gbap.threshfacVec(q),2)],...
        'Interpreter','Latex','FontName','Times New Roman','FontSize',gbap.fontSize+1)
end
% set(gca,'FontName','Times New Roman') set(gca,'FontSize',gbap.fontSize)
dim = [0.50 0.98 0.00 0.00]; %[x y w h]
str = 'Brightest composite';
annotation('textbox',dim,'String',str,'FitBoxToText','on',...
    'EdgeColor','none','HorizontalAlignment','center',...
    'VerticalAlignment','middle',...
    'FontName','Times New Roman','FontWeight','bold','FontSize',gbap.fontSize+1);
set(gcf,'color','w')
toc


%% Maximum composite image with mode values

disp(' ')
disp('Building mode maximum brightness composite image ...')
disp(' ')

% figure
scrsz = get(groot,'ScreenSize');
figure('Position',...
    [scrsz(3)*0.02 scrsz(4)*0.15 scrsz(3)*0.95 scrsz(4)*0.70]);
%'Position' definition: [left bottom width height]

tic
tiledlayout(1+(size(gbap.threshfacVec,1)>1),ceil(size(gbap.threshfacVec,1)/2),'TileSpacing','tight','Padding','compact');
for q = 1:size(gbap.threshfacVec,1)
    nexttile
    %     baseImage = (gbap.imageStack{1,2});
    %     imageMaximumModeComposite = gbap.imageStack{1,2};
    imageMaximumModeComposite = zeros(size(gbap.imageStack{1,2},1),...
        size(gbap.imageStack{1,2},2),size(gbap.imageStack{1,2},3),'uint8');
    for kk = 1:(length(gbap.optA(q).B)-(gbap.optA(q).N + 0))
        qq = kk + gbap.optA(q).N + 0;
        
        maximumIndex = find(gbap.angleVec == gbap.grainMaximum{q,kk},1);
        maximumImage = gbap.imageStack{maximumIndex,2};
        %         maximumImage = imoverlay(maximumImage,gbap.optA(q).L == qq,((squeeze(im2double(gbap.grainModeArray{q}(maximumIndex,kk,:))))./1'));
        maximumImage = imoverlay(maximumImage,gbap.optA(q).L == qq,((squeeze(gbap.grainModeArray{q}(maximumIndex,kk,:)))./1'));
        imageMaximumModeComposite(repmat(gbap.optA(q).L == qq,[1 1 3])) = maximumImage(repmat(gbap.optA(q).L == qq,[1 1 3]));
    end
    
    mask = boundarymask(gbap.optA(q).L);
    %     imageMaximumModeComposite = imoverlay(imageMaximumModeComposite,mask,gbap.CM(q,:));
    gbap.imageMaximumModeComposite{q} = imoverlay(imageMaximumModeComposite,mask,'w');
    imshow(gbap.imageMaximumModeComposite{q})
    
    title(['threshold=',num2str(gbap.threshfacVec(q),2)],...
        'Interpreter','Latex','FontName','Times New Roman','FontSize',gbap.fontSize+1)
end
% set(gca,'FontName','Times New Roman') set(gca,'FontSize',gbap.fontSize)
dim = [0.50 0.98 0.00 0.00]; %[x y w h]
str = 'Mode composite';
annotation('textbox',dim,'String',str,'FitBoxToText','on',...
    'EdgeColor','none','HorizontalAlignment','center',...
    'VerticalAlignment','middle',...
    'FontName','Times New Roman','FontWeight','bold','FontSize',gbap.fontSize+1);
set(gcf,'color','w')
toc



%% Maximum composite image with mean values

disp(' ')
disp('Building mean maximum brightness composite image ...')
disp(' ')

% figure
scrsz = get(groot,'ScreenSize');
figure('Position',...
    [scrsz(3)*0.02 scrsz(4)*0.15 scrsz(3)*0.95 scrsz(4)*0.70]);
%'Position' definition: [left bottom width height]

tic
tiledlayout(1+(size(gbap.threshfacVec,1)>1),ceil(size(gbap.threshfacVec,1)/2),'TileSpacing','tight','Padding','compact');
for q = 1:size(gbap.threshfacVec,1)
    nexttile
    %     baseImage = (gbap.imageStack{1,2});
    %     imageMaximumMeanComposite = gbap.imageStack{1,2};
    imageMaximumMeanComposite = zeros(size(gbap.imageStack{1,2},1),...
        size(gbap.imageStack{1,2},2),size(gbap.imageStack{1,2},3),'uint8');
    for kk = 1:(length(gbap.optA(q).B)-(gbap.optA(q).N + 0))
        qq = kk + gbap.optA(q).N + 0;
        maximumIndex = find(gbap.angleVec == gbap.grainMaximum{q,kk},1);
        maximumImage = gbap.imageStack{maximumIndex,2};
        % maximumImage = imoverlay(maximumImage,gbap.optA(q).L ==
        % qq,rescale(squeeze(im2double(gbap.grainMeanArray{q}(maximumIndex,kk,:))),0,1)');
        %         maximumImage = imoverlay(maximumImage,gbap.optA(q).L == qq,((squeeze(im2double(gbap.grainMeanArray{q}(maximumIndex,kk,:))))./1)');
        maximumImage = imoverlay(maximumImage,gbap.optA(q).L == qq,((squeeze((gbap.grainMeanArray{q}(maximumIndex,kk,:))))./1)');
        imageMaximumMeanComposite(repmat(gbap.optA(q).L == qq,[1 1 3])) = maximumImage(repmat(gbap.optA(q).L == qq,[1 1 3]));
    end
    mask = boundarymask(gbap.optA(q).L);
    %     imageMaximumMeanComposite = imoverlay(imageMaximumMeanComposite,mask,gbap.CM(q,:));
    gbap.imageMaximumMeanComposite{q} = imoverlay(imageMaximumMeanComposite,mask,'w');
    imshow(gbap.imageMaximumMeanComposite{q})
    
    title(['threshold=',num2str(gbap.threshfacVec(q),2)],...
        'Interpreter','Latex','FontName','Times New Roman','FontSize',gbap.fontSize+1)
end
% set(gca,'FontName','Times New Roman') set(gca,'FontSize',gbap.fontSize)
dim = [0.50 0.98 0.00 0.00]; %[x y w h]
str = 'Mean composite';
annotation('textbox',dim,'String',str,'FitBoxToText','on',...
    'EdgeColor','none','HorizontalAlignment','center',...
    'VerticalAlignment','middle',...
    'FontName','Times New Roman','FontWeight','bold','FontSize',gbap.fontSize+1);
set(gcf,'color','w')
toc


%% Maximum composite image with median values

disp(' ')
disp('Building median maximum brightness composite image ...')
disp(' ')

% figure
scrsz = get(groot,'ScreenSize');
figure('Position',...
    [scrsz(3)*0.02 scrsz(4)*0.15 scrsz(3)*0.95 scrsz(4)*0.70]);
%'Position' definition: [left bottom width height]

tic
tiledlayout(1+(size(gbap.threshfacVec,1)>1),ceil(size(gbap.threshfacVec,1)/2),'TileSpacing','tight','Padding','compact');
for q = 1:size(gbap.threshfacVec,1)
    nexttile
    %     baseImage = (gbap.imageStack{1,2});
    %     imageMaximumMedianComposite = gbap.imageStack{1,2};
    imageMaximumMedianComposite = zeros(size(gbap.imageStack{1,2},1),...
        size(gbap.imageStack{1,2},2),size(gbap.imageStack{1,2},3),'uint8');
    for kk = 1:(length(gbap.optA(q).B)-(gbap.optA(q).N + 0))
        qq = kk + gbap.optA(q).N + 0;
        maximumIndex = find(gbap.angleVec == gbap.grainMaximum{q,kk},1);
        maximumImage = gbap.imageStack{maximumIndex,2};
        % maximumImage = imoverlay(maximumImage,gbap.optA(q).L ==
        % qq,rescale(squeeze(im2double(gbap.grainMeanArray{q}(maximumIndex,kk,:))),0,1)');
        %         maximumImage = imoverlay(maximumImage,gbap.optA(q).L == qq,((squeeze(im2double(gbap.grainMedianArray{q}(maximumIndex,kk,:))))./1)');
        maximumImage = imoverlay(maximumImage,gbap.optA(q).L == qq,((squeeze((gbap.grainMedianArray{q}(maximumIndex,kk,:))))./1)');
        imageMaximumMedianComposite(repmat(gbap.optA(q).L == qq,[1 1 3])) = maximumImage(repmat(gbap.optA(q).L == qq,[1 1 3]));
    end
    mask = boundarymask(gbap.optA(q).L);
    %     imageMaximumMedianComposite = imoverlay(imageMaximumMedianComposite,mask,gbap.CM(q,:));
    gbap.imageMaximumMedianComposite{q} = imoverlay(imageMaximumMedianComposite,mask,'w');
    imshow(gbap.imageMaximumMedianComposite{q})
    
    title(['threshold=',num2str(gbap.threshfacVec(q),2)],...
        'Interpreter','Latex','FontName','Times New Roman','FontSize',gbap.fontSize+1)
end
% set(gca,'FontName','Times New Roman') set(gca,'FontSize',gbap.fontSize)
dim = [0.50 0.98 0.00 0.00]; %[x y w h]
str = 'Median composite';
annotation('textbox',dim,'String',str,'FitBoxToText','on',...
    'EdgeColor','none','HorizontalAlignment','center',...
    'VerticalAlignment','middle',...
    'FontName','Times New Roman','FontWeight','bold','FontSize',gbap.fontSize+1);
set(gcf,'color','w')
toc


%% Save results

% for k = 1:size(gbap.imageStack,1)
%     gbap.imageStack{k,1} = [];
% end

% load(fullfile([pwd,'/practice',subfolder],'ImageStackData.mat'),'gbap')
% fileNameData = fullfile([pwd,gbap.subfolder],['gbapResultsData_',num2str(gbap.cropscale),'.mat']);
% save(fullfile([pwd,gbap.subfolder],['gbapResultsData_',num2str(gbap.cropscale,'%0.2f'),'.mat']),'gbap')
save(fullfile([pwd,gbap.subfolder],directoryNameList{fileInput}),'gbap')

disp('analysis complete')
