%%
% clear memory and previously allocated variables
delete(gcp('nocreate'))
clc;clear all;close all;


%% Load Grain Boundary Analysis Preprocessing (gbap) data / Settings

run ColorIceInputFile


%% Make directory and select file to load

% record directory in output folder
directory = dir(fullfile([pwd,subfolder],['gbapResultsData_*','.mat']));
directoryNameList = {directory.name}';
clear directory

% list of relevant files
TOCs = cell(size(directoryNameList,1),1);
for k = 1:size(directoryNameList,1)
    TOCs{k} = [num2str(k),':',' ',directoryNameList{k}];
end
fprintf('Table of Contents for Files: \n')
disp(TOCs)
clear k TOCs

% input explicit number from list
fileInput = input('Type number from list to load: ');

clc
disp(horzcat('Loading ',directoryNameList{fileInput}))


%% Load data file

%create name and find location for data file and load 
% load(fullfile([pwd,'/practice',subfolder],['gbapResultsData_',num2str(cropscale,'%0.2f'),'.mat']),'gbap')
tic
load(fullfile([pwd,subfolder],directoryNameList{fileInput}),'gbap')
toc
clear subfolder clear cropscale

gbap.threshfacVec = threshfacVec;
gbap.plotFigureFlagSegmenter = plotFigureFlagSegmenter;
gbap.fontSize = fontSize;
gbap.markerSize = markerSize;
gbap.pixNumLim = pixNumLim;


%% Segmentation of image stacks

for k = 1:size(gbap.imageStack,1)
    gbap.imageStack{k,1} = [];
end

gbap.kernelVal = 3; gbap.Nmedfilt = 1; gbap.SE0 = strel('disk',3); gbap.SE = strel('square',3);

optA = struct(); %initialize structure

if parforopt == 1
    
    delete(gcp('nocreate'))
    
%     gbapParfor = gbap; %create new structure for parallel for-loop
    gbapParfor = struct();
    gbapParfor.imageStack = gbap.imageStack;
    gbapParfor.kernelVal = gbap.kernelVal;
    gbapParfor.Nmedfilt = gbap.Nmedfilt;
    gbapParfor.SE0 = gbap.SE0;
    gbapParfor.SE = gbap.SE;
    gbapParfor.threshfacVec = gbap.threshfacVec;
    gbapParfor.plotFigureFlagSegmenter = gbap.plotFigureFlagSegmenter;
%     valCheck = whos('gbapParfor');
%     valCheck.bytes/1e9*numWorkers
    
    % convert to constant arrays in parallel pool
    poolconst = parallel.pool.Constant(gbapParfor);
    
    tic
    parpool('local',numWorkers);
    parfor k = 1:size(gbap.threshfacVec,1)
        
        % redefine parallel pool constant with original input array name for brevity
        gbapParfor = poolconst.Value;
        
        %         optA = struct(); %initialize structure
        
        disp(k)
        %     tic
        %         [optA(k).B,optA(k).L,optA(k).N] = ...
        %             imagestacksegmenter(gbapParfor.imageStack(:,2),...
        %             gbapParfor.kernelVal,gbapParfor.Nmedfilt,gbapParfor.SE0,...
        %             gbapParfor.SE,gbapParfor.threshfacVec(k),gbapParfor.threshfacVec(k),...
        %             gbapParfor.threshfacVec(k),gbapParfor.plotFigureFlagSegmenter);
        [B,L,N] = ...
            imagestacksegmenter(gbapParfor.imageStack(:,2),...
            gbapParfor.kernelVal,gbapParfor.Nmedfilt,gbapParfor.SE0,...
            gbapParfor.SE,gbapParfor.threshfacVec(k),gbapParfor.threshfacVec(k),...
            gbapParfor.threshfacVec(k),gbapParfor.plotFigureFlagSegmenter);
        %     toc
        
        Barray{k} = B;
        Larray{k} = L;
        Narray{k} = N;
    end
    toc
    delete(gcp('nocreate'))
    for k = 1:size(gbap.threshfacVec,1)
        optA(k).B = Barray{k};
        optA(k).L = Larray{k};
        optA(k).N = Narray{k};
    end 
    gbap.optA = optA;
    clear poolconst optA
    clear gbapParfor
%     clear Barray Larray Narray
    
else
    
    
    gbapParfor = gbap; %create new structure for parallel for-loop
    % convert to constant arrays in parallel pool
    % poolconst = parallel.pool.Constant(gbapParfor);
    
    tic
    %     parpool('local',6);
    for k = 1:size(gbap.threshfacVec,1)
        
        % redefine parallel pool constant with original input array name for brevity
        %     gbapParfor = poolconst.Value;
        
        disp(k)
        %     tic
        [optA(k).B,optA(k).L,optA(k).N] = ...
            imagestacksegmenter(gbapParfor.imageStack(:,2),...
            gbapParfor.kernelVal,gbapParfor.Nmedfilt,gbapParfor.SE0,...
            gbapParfor.SE,gbapParfor.threshfacVec(k),gbapParfor.threshfacVec(k),...
            gbapParfor.threshfacVec(k),gbapParfor.plotFigureFlagSegmenter);
        %     toc
    end
    toc
    % delete(gcp('nocreate'))
    gbap.optA = optA;
    clear poolconst optA
    clear gbapParfor
    
end


%% High resolution grain boundary segmentation stack

gbap.CM = hsv(size(gbap.threshfacVec,1));

if plotFigureHighResGB == 1
    
    figure;
    imshow(gbap.imageStack{1,2})
    % image(imageStack{1})
    for q = 1:size(gbap.threshfacVec,1)
        hold on
        %     for k = 1:optA(q).N
        %         boundary = optA(q).B{k};
        %         plot(boundary(:,2), boundary(:,1), 'k', 'LineWidth', 0.5)
        %     end
        
        for k = gbap.optA(q).N+1:length(gbap.optA(q).B)
            boundary = gbap.optA(q).B{k};
            if k == length(gbap.optA(q).B)
                plot(boundary(1:end-1,2), boundary(1:end-1,1),'Color',gbap.CM(q,:),'LineWidth', 0.5)
                gbap.optA(q).hh = plot(boundary(end,2), boundary(end,1),'Color',gbap.CM(q,:),'LineWidth', 0.5,'DisplayName',num2str(gbap.threshfacVec(q)));
            else
                plot(boundary(:,2), boundary(:,1),'Color',gbap.CM(q,:),'LineWidth', 0.5)
            end
        end
        hold off
    end
    lgd = legend([gbap.optA(:).hh],'location','bestoutside',...
        'Interpreter','LaTeX','FontName','Times New Roman','FontSize',gbap.fontSize);
    set(gcf,'color','w')
end

%% Low resolution grain boundary segmentation stack

% figure
% for q = 1:size(gbap.threshfacVec,1)
%     subplot(2,ceil(size(gbap.threshfacVec,1))/2,q)
%     baseImage = rgb2gray(gbap.imageStack{1,2});
%     mask = boundarymask(gbap.optA(q).L);
%     baseImage = imoverlay(baseImage,mask,gbap.CM(q,:));
%     imshow(baseImage)
% end

% figure
scrsz = get(groot,'ScreenSize');
figure('Position',...
    [scrsz(3)*0.02 scrsz(4)*0.15 scrsz(3)*0.95 scrsz(4)*0.70]);
% 'Position' definition: [left bottom width height]

tiledlayout(1+(size(gbap.threshfacVec,1)>1),ceil(size(gbap.threshfacVec,1)/2),'TileSpacing','tight','Padding','compact');
for q = 1:size(gbap.threshfacVec,1)
    nexttile
    baseImage = rgb2gray(gbap.imageStack{1,2});
    mask = boundarymask(gbap.optA(q).L);
    baseImage = imoverlay(baseImage,mask,gbap.CM(q,:));
    imshow(baseImage)
    title(['threshold=',num2str(gbap.threshfacVec(q),2)])
end


%% Calculate measurements and statistics for image

gbap.stats = struct();

for q = 1:size(gbap.threshfacVec,1)
    gbap.stats(q).regionProps = regionprops('table',gbap.optA(q).L,'Area','Centroid','Perimeter',...
        'MajorAxisLength','MinorAxisLength','Orientation','EquivDiameter');
    
    gbap.stats(q).Area = gbap.stats(q).regionProps.Area(gbap.optA(q).N+1:end)*gbap.mmPerPixel^2;
    gbap.stats(q).meanArea = mean(gbap.stats(q).Area);
    gbap.stats(q).medianArea = median(gbap.stats(q).Area);
    gbap.stats(q).areaFraction = sum(gbap.stats(q).regionProps.Area(gbap.optA(q).N+1:end))/numel(gbap.imageStack{1,2}(:,:,1));
    
    gbap.stats(q).equivDia = gbap.stats(q).regionProps.EquivDiameter(gbap.optA(q).N+1:end)*gbap.mmPerPixel;
    gbap.stats(q).meanEquivDia = mean(gbap.stats(q).equivDia);
    gbap.stats(q).medianEquivDia = median(gbap.stats(q).equivDia);
    gbap.stats(q).numGrains = numel(gbap.stats(q).regionProps.EquivDiameter(gbap.optA(q).N+1:end));
    gbap.stats(q).Orientation = gbap.stats(q).regionProps.Orientation(gbap.optA(q).N+1:end);
end


%% Plot statistical trends

axset = struct();

% figure
scrsz = get(groot,'ScreenSize');
figure('Position',...
    [scrsz(3)*0.005 scrsz(4)*0.2 scrsz(3)*0.99 scrsz(4)*0.60]);
% 'Position' definition: [left bottom width height]
for q = 1:size(gbap.threshfacVec,1)
    %     figure
    %     subplot(1,2,1)
    axset(q).ax1 = subplot(2,size(gbap.threshfacVec,1),q);
    histogram(gbap.stats(q).Area,'FaceColor',gbap.CM(q,:),'FaceAlpha',1)
    %     title([num2str(threshfacVec(q),'%.1f'),': ','$\tilde{A}$=',...
    %         num2str(median(stats(q).regionProps.Area(optA(q).N+1:end)*mmPerPixel^2),'%.1f'),'mm$\textsuperscript{2}$',...
    %         ', $A_{f}$=',num2str(sum(stats(q).regionProps.Area(optA(q).N+1:end))/numel(imageStack{1})*100,'%.1f'),'$\%$'],...
    %         'Interpreter','LaTeX','FontName','Times New Roman','FontSize',fontSize)
    xlabel('grain area [mm$\textsuperscript{2}$]',...
        'Interpreter','LaTeX','FontName','Times New Roman','FontSize',gbap.fontSize)
    if q == 1
        ylabel('frequency [-]',...
            'Interpreter','LaTeX','FontName','Times New Roman','FontSize',gbap.fontSize)
    end
    axis tight
    grid on
    set(gca,'FontName','Times New Roman')
    set(gca,'FontSize',gbap.fontSize)
    title([num2str(gbap.threshfacVec(q),'%.1f'),': ','$\bar{A}$=',...
        num2str(gbap.stats(q).meanArea,'%.1f'),'mm$\textsuperscript{2}$',...
        ', $A_{f}$=',num2str(gbap.stats(q).areaFraction,'%.2f')],...
        'Interpreter','LaTeX','FontName','Times New Roman','FontSize',gbap.fontSize-1)
    
    %     subplot(1,2,2)
    axset(q).ax2 = subplot(2,size(gbap.threshfacVec,1),q+size(gbap.threshfacVec,1));
    histogram(gbap.stats(q).equivDia,'FaceColor',gbap.CM(q,:),'FaceAlpha',1)
    %     title([num2str(threshfacVec(q),'%.1f'),': ','$\tilde{d}$=',...
    %         num2str(median(stats(q).regionProps.EquivDiameter(optA(q).N+1:end)*mmPerPixel),'%.1f'),'mm',...
    %         ', N=',num2str(length(stats(q).regionProps.EquivDiameter(optA(q).N+1:end)))],...
    %         'Interpreter','LaTeX','FontName','Times New Roman','FontSize',fontSize)
    xlabel('equiv. grain dia. [mm]',...
        'Interpreter','LaTeX','FontName','Times New Roman','FontSize',gbap.fontSize)
    if q == 1
        ylabel('frequency [-]',...
            'Interpreter','LaTeX','FontName','Times New Roman','FontSize',gbap.fontSize)
    end
    axis tight
    grid on
    set(gca,'FontName','Times New Roman')
    set(gca,'FontSize',gbap.fontSize)
    title([num2str(gbap.threshfacVec(q),'%.1f'),': ','$\bar{d}$=',...
        num2str(gbap.stats(q).meanEquivDia,'%.1f'),'mm',...
        ', N=',num2str(gbap.stats(q).numGrains)],...
        'Interpreter','LaTeX','FontName','Times New Roman','FontSize',gbap.fontSize-1)
end

% linkaxes([axset(:).ax1],'xy');linkaxes([axset(:).ax2],'xy');
set(gcf,'color','w')


%% Thresholding trends

% figure
scrsz = get(groot,'ScreenSize');
figure('Position',...
    [scrsz(3)*0.3 scrsz(4)*0.1 scrsz(3)*0.50 scrsz(4)*0.80]);
% 'Position' definition: [left bottom width height]

subplot(4,1,1)
hold on
for q=1:size(gbap.threshfacVec,1)
    %     plot(threshfacVec(q),[stats(q).areaFraction]','o','MarkerEdgeColor',CM(q,:),'MarkerFaceColor',CM(q,:),'MarkerSize',4)
    plot(gbap.threshfacVec(q),[gbap.stats(q).areaFraction]','o','MarkerEdgeColor','k','MarkerFaceColor',gbap.CM(q,:),'MarkerSize',gbap.markerSize)
end
% plot(threshfacVec,[stats(:).areaFraction]')
hold off
% xlabel('threshold [-]',...
%     'Interpreter','LaTeX','FontName','Times New Roman','FontSize',fontSize)
ylabel('area fraction [-]',...
    'Interpreter','LaTeX','FontName','Times New Roman','FontSize',gbap.fontSize)
% axis tight
grid on
set(gca,'FontName','Times New Roman')
set(gca,'FontSize',gbap.fontSize)

subplot(4,1,2)
hold on
for q=1:size(gbap.threshfacVec,1)
    %     plot(threshfacVec(q),[stats(q).numGrains]','o','MarkerEdgeColor',CM(q,:),'MarkerFaceColor',CM(q,:),'MarkerSize',4)
    plot(gbap.threshfacVec(q),[gbap.stats(q).numGrains]','o','MarkerEdgeColor','k','MarkerFaceColor',gbap.CM(q,:),'MarkerSize',gbap.markerSize)
end
% plot(threshfacVec,[stats(:).numGrains]')
hold off
% xlabel('threshold scale [-]',...
%     'Interpreter','LaTeX','FontName','Times New Roman','FontSize',fontSize)
ylabel('number of grains [-]',...
    'Interpreter','LaTeX','FontName','Times New Roman','FontSize',gbap.fontSize)
% axis tight
grid on
set(gca,'FontName','Times New Roman')
set(gca,'FontSize',gbap.fontSize)

subplot(4,1,3)
hold on
for q=1:size(gbap.threshfacVec,1)
    %     plot(threshfacVec(q),[stats(q).meanArea]','o','MarkerEdgeColor',CM(q,:),'MarkerFaceColor',CM(q,:),'MarkerSize',4)
    plot(gbap.threshfacVec(q),[gbap.stats(q).meanArea]','o','MarkerEdgeColor','k','MarkerFaceColor',gbap.CM(q,:),'MarkerSize',gbap.markerSize)
end
% plot(threshfacVec,[stats(:).meanArea]')
hold off
% xlabel('threshold [-]',...
%     'Interpreter','LaTeX','FontName','Times New Roman','FontSize',fontSize)
ylabel('mean grain area [mm$\textsuperscript{2}$]',...
    'Interpreter','LaTeX','FontName','Times New Roman','FontSize',gbap.fontSize)
% axis tight
grid on
set(gca,'FontName','Times New Roman')
set(gca,'FontSize',gbap.fontSize)

subplot(4,1,4)
hold on
for q=1:size(gbap.threshfacVec,1)
    %     plot(threshfacVec(q),[stats(q).meanEquivDia]','o','MarkerEdgeColor',CM(q,:),'MarkerFaceColor',CM(q,:),'MarkerSize',4)
    plot(gbap.threshfacVec(q),[gbap.stats(q).meanEquivDia]','o','MarkerEdgeColor','k','MarkerFaceColor',gbap.CM(q,:),'MarkerSize',gbap.markerSize)
end
% plot(threshfacVec,[stats(:).meanEquivDia]')
hold off
xlabel('threshold [-]',...
    'Interpreter','LaTeX','FontName','Times New Roman','FontSize',gbap.fontSize)
ylabel('mean equiv. grain dia. [mm]',...
    'Interpreter','LaTeX','FontName','Times New Roman','FontSize',gbap.fontSize)
% axis tight
grid on
set(gca,'FontName','Times New Roman')
set(gca,'FontSize',gbap.fontSize)

set(gcf,'color','w')


%% Save results

% load(fullfile([pwd,'/practice',subfolder],'ImageStackData.mat'),'gbap')
% fileNameData = fullfile([pwd,gbap.subfolder],['gbapResultsData_',num2str(gbap.cropscale),'.mat']);

% for k = 1:size(gbap.imageStack,1)
%     gbap.imageStack{k,1} = [];
% end

% if strcmp(gbap.cropShape,'default') == 1
%     save(fullfile([pwd,gbap.subfolder],['gbapResultsData_',num2str(gbap.cropscale,'%0.2f'),'.mat']),'gbap')
% else
%     save(fullfile([pwd,gbap.subfolder],['gbapResultsData_',num2str(gbap.cropscale,'%0.2f'),'_',strrep(datestr(now,'yyyy-mm-dd HH-MM-SS'),' ','_'),'.mat']),'gbap')
% end
% 
% disp('analysis complete')


%% Save results

% for k = 1:size(gbap.imageStack,1)
%     gbap.imageStack{k,1} = [];
% end

% load(fullfile([pwd,'/practice',subfolder],'ImageStackData.mat'),'gbap')
% fileNameData = fullfile([pwd,gbap.subfolder],['gbapResultsData_',num2str(gbap.cropscale),'.mat']);
% save(fullfile([pwd,gbap.subfolder],['gbapResultsData_',num2str(gbap.cropscale,'%0.2f'),'.mat']),'gbap')
save(fullfile([pwd,gbap.subfolder],directoryNameList{fileInput}),'gbap')

disp('analysis complete')


