%%
% clear memory and previously allocated variables
delete(gcp('nocreate'))
clc;clear all;close all;

% delete(gcp('nocreate'))


%% Load Grain Boundary Analysis Preprocessing (gbap) data

run ColorIceInputFile

%create name and find location for data file and load file
% load(fullfile([pwd,'/practice',subfolder],'ImageStackData.mat'),'gbap')
load(fullfile([pwd,subfolder],'ImageStackData.mat'),'gbap','imageStack')
clear subfolder

gbap.imageStack = imageStack;


%% Select ROI type

figure;montage(gbap.imageStack(:,1), 'Size', [2 ceil(size(gbap.imageStack,1)/2)])

pause(3)

gbap.cropscale = 1.00;

% gbap.cropShape = 'circle';

cropShapeOptions = {'circle';'square';'default'};

% list of relevant files
TOCs = cell(size(cropShapeOptions,1),1);
for k = 1:size(cropShapeOptions,1)
    TOCs{k} = [num2str(k),':',' ',cropShapeOptions{k}];
end
fprintf('Table of contents for ROI types: \n')
disp(TOCs)
clear k TOCs

% input explicit number from list
fileInput = input('Type number from list to select: ');

% clc
disp(horzcat('Selected: ',cropShapeOptions{fileInput}))
gbap.cropShape = cropShapeOptions{fileInput};


%% Interpolate thickness array to dimensions of image

% gbap.thicknessArray = [0.63 0.93;1.10 1.23]; %remove this once placed in preprocessor!!!!!!!

[col,row] = meshgrid(...
    1:size(gbap.imageStack{1,1},1)-1:size(gbap.imageStack{1,1},1),...
    1:size(gbap.imageStack{1,1},2)-1:size(gbap.imageStack{1,1},2));

[gbap.thicknessColumns,gbap.thicknessRows] = meshgrid(...
    1:1:size(gbap.imageStack{1,1},1),...
    1:1:size(gbap.imageStack{1,1},2));

gbap.thicknessArrayInterp = interp2(col,row,gbap.thicknessArray,gbap.thicknessColumns,gbap.thicknessRows,'linear');

% figure
% surf(gbap.thicknessArrayInterp,'EdgeColor','none','FaceColor','interp');
% xlabel('column')
% ylabel('row')


%% Crop image stack to central part

figure;montage(gbap.imageStack(:,1), 'Size', [2 ceil(size(gbap.imageStack,1)/2)])

gbap.winCrop = centerCropWindow2d(size(gbap.imageStack{1,1}),ceil(size(gbap.imageStack{1,1})*gbap.cropscale));
for k = 1:size(gbap.imageStack,1)
    gbap.imageStack{k,2} = imcrop(gbap.imageStack{k,1},gbap.winCrop);
end

%crop ice thickness array by the image cropping
gbap.thicknessArrayInterpCrop = gbap.thicknessArrayInterp(...
    gbap.winCrop.XLimits(1):gbap.winCrop.XLimits(end),...
    gbap.winCrop.YLimits(1):gbap.winCrop.YLimits(end));

figure;montage(gbap.imageStack(:,2), 'Size', [2 ceil(size(gbap.imageStack,1)/2)])
% NOTE: use second column of imageStack for final cropped images


%% Create perimeter mask and circular interactive crop

if gbap.cropscale == 1 && strcmp(gbap.cropShape,'circle') == 1
%     [gbap.imageStack(:,2),gbap.cropMaskCircle] = imagestackinteractivecropCircle(gbap.imageStack(:,2),0);
    [gbap.imageStack(:,2),gbap.cropPosition] = imagestackinteractivecropCircle(gbap.imageStack(:,2),0);
    
        %crop ice thickness array by the image cropping
    gbap.thicknessArrayInterpCrop = gbap.thicknessArrayInterp(...
        gbap.cropPosition(2):gbap.cropPosition(2)+gbap.cropPosition(4),...
        gbap.cropPosition(1):gbap.cropPosition(1)+gbap.cropPosition(3));
    
%     [row,col] = find(gbap.cropMaskCircle==1);
    
    %crop ice thickness array by the image cropping
%     gbap.thicknessArrayInterpCrop = gbap.thicknessArrayInterp(...
%         min(row(:)):max(row(:)),min(col(:)):max(col(:)));
    
    figure;montage(gbap.imageStack(:,2), 'Size', [2 ceil(size(gbap.imageStack,1)/2)])
    
%     clear row col
    
elseif gbap.cropscale == 1 && strcmp(gbap.cropShape,'square') == 1
    [gbap.imageStack(:,2),gbap.cropPosition] = imagestackinteractivecropSquare(gbap.imageStack(:,2),0);
    
    %crop ice thickness array by the image cropping
    gbap.thicknessArrayInterpCrop = gbap.thicknessArrayInterp(...
        gbap.cropPosition(2):gbap.cropPosition(2)+gbap.cropPosition(4),...
        gbap.cropPosition(1):gbap.cropPosition(1)+gbap.cropPosition(3));
    
    figure;montage(gbap.imageStack(:,2), 'Size', [2 ceil(size(gbap.imageStack,1)/2)])
    
elseif gbap.cropscale == 1 && strcmp(gbap.cropShape,'squareEnclosed') == 1
    
    
end

%% Determine circular polarized image from image stack

imageCirPol = im2double(rgb2gray(gbap.imageStack{1,2}));
for k = 2:size(gbap.imageStack,1)
    imageCirPol = imadd(imageCirPol,im2double(rgb2gray(gbap.imageStack{k,2})));
end
gbap.imageCirPoleq = histeq(im2uint8(imageCirPol/size(gbap.imageStack,1)));
gbap.imageCirPol = (im2uint8(imageCirPol/size(gbap.imageStack,1)));

% figure;imshow(imageCirPol)
% figure;imshowpair(gbap.imageCirPoleq,gbap.imageCirPol,'montage')
% figure;montage({rgb2gray(gbap.imageStack{1,2}),gbap.imageCirPoleq,gbap.imageCirPol},'Size',[1 3])
figure;montage({(gbap.imageStack{1,2}),gbap.imageCirPoleq,gbap.imageCirPol},'Size',[1 3])
title('Digital circular polarization')


%% Save results

% load(fullfile([pwd,'/practice',subfolder],'ImageStackData.mat'),'gbap')
% fileNameData = fullfile([pwd,gbap.subfolder],['gbapResultsData_',num2str(gbap.cropscale),'.mat']);

for k = 1:size(gbap.imageStack,1)
    gbap.imageStack{k,1} = [];
end

if strcmp(gbap.cropShape,'default') == 1
    save(fullfile([pwd,gbap.subfolder],['gbapResultsData_',num2str(gbap.cropscale,'%0.2f'),'.mat']),'gbap')
else
    save(fullfile([pwd,gbap.subfolder],['gbapResultsData_',num2str(gbap.cropscale,'%0.2f'),'_',strrep(datestr(now,'yyyy-mm-dd HH-MM-SS'),' ','_'),'.mat']),'gbap')
end

disp('analysis complete')

