%%
% clear memory and previously allocated variables
clc;clear all;close all;


%% Load input parameters

run ColorIceInputFile

gbap = struct();

gbap.manualRegisterFlag = manualRegisterFlag;
gbap.plotFigureFlagImageStackPreprocessor = plotFigureFlagImageStackPreprocessor;
gbap.plotFigureFlagCropRegister = plotFigureFlagCropRegister;

gbap.subfolder = subfolder; 
gbap.cropscale = cropscale; 
gbap.bkgdFlag = bkgdFlag; 
gbap.mmPerPixel = mmPerPixel; 
gbap.angleVec = angleVec; 
gbap.initialPosition = initialPosition; 
gbap.thicknessArray = thicknessArray; 
gbap.thicknessVecTolerance = thicknessVecTolerance; 
gbap.colorTemp = colorTemp; 
gbap.ISO = ISO; 
gbap.description = description;

gbap.fileNamePrefix = [pwd,gbap.subfolder];

    
%% Load and register images coarsely
    
[imageStack,registerData] = imagestackpreprocessorV1(gbap.fileNamePrefix,gbap.plotFigureFlagImageStackPreprocessor,gbap.bkgdFlag,gbap.manualRegisterFlag,gbap.angleVec);


%% Manually define region of interest for cropping and save parameters

[cropPosition,imageStack] = imagestackinteractivecrop(gbap.fileNamePrefix,imageStack,gbap.initialPosition);


%% Registration of cropped images for final refinement

%     close all;clc;
[imageStack,registerCropData] = imagestackregistration(gbap.fileNamePrefix,imageStack,gbap.plotFigureFlagCropRegister);


%% Chromatic adaptation of images based on parallel polarized image

testflag = 1;
% testflag = 0;

if testflag == 1
[imageStack,gbap.pointPosition] = interactivechromaticadaptation(imageStack,gbap.fileNamePrefix);
figure;montage(imageStack(:,1), 'Size', [2 ceil(size(imageStack,1)/2)])
end


%% Interactive scale measurement for scaling photographs

testflag = 1;
% testflag = 0;

if testflag == 1
[gbap.mmPerPixel] = interactivescalemeasurement(gbap.fileNamePrefix);
end


%% Save pre-processed image stack for later analysis

% gbap.imageStack = imageStack;
gbap.angleVecTrue = [0,registerData.angleTrueRefined]';
% gbap.thicknessArray = (0.50)*[(1) (1);(1) (1)];
% gbap.thicknessArray = (1.00)*[(0.30) (0.40);(0.30) (0.40)];

disp('saving...')

% saveimagestack(gbap.fileNamePrefix,gbap)

saveimagestack(gbap.fileNamePrefix,gbap,imageStack)

disp('pre-processing complete')


%% Determine circular polarized image from image stack

imageCirPol = im2double(rgb2gray(imageStack{1,1}));
for k = 2:size(imageStack,1)
    imageCirPol = imadd(imageCirPol,im2double(rgb2gray(imageStack{k,1})));
end
imageCirPoleq = histeq(im2uint8(imageCirPol/size(imageStack,1)));
imageCirPol = (im2uint8(imageCirPol/size(imageStack,1)));

% figure;imshow(imageCirPol)
% figure;imshowpair(imageCirPoleq,imageCirPol,'montage')
figure;montage({(imageStack{1,1}),imageCirPoleq,imageCirPol},'Size',[1 3])
title('Digital circular polarization')
