%% Post-processing/visualisation
close all;clear all;clc
load('MSPA3_04_12_07_3000sim.mat');     % if running just plot, load data, 3000sim
% List of output variables 
list_names = {'Cdc42';'Rac1';'RhoA';'PAR';'Scribble';'ActivatedIntegrin'};
% Original values of varaied parameters
list_values = [0.5,1,2.5,0.5,1,1.5,3.3,1,0.7,2.5,0.5,2,2,0.2,4,2,0.2,10,1,30,1.5];
% Depict colors for plots
green1=[0.4660,0.6740,0.1880];red1=[0.6350,0.0780,0.1840];purple1=[0.4940,0.1840,0.5560];
yellow1=[0.9290,0.6940,0.1250];blue1=[0,0.4470,0.7410];orange1=[0.8500,0.3250,0.0980];
Par_values_all = zeros(length(list_names),n_MPSA, Np);  % To store parameters values
MeanValues=zeros(length(list_names),Np);MedianValues=zeros(length(list_names),Np);

%% Loop for each output variable
for i = 1:6
    %% Classification of acceptable vs unacceptable simulations
    flag  = zeros(n_MPSA, 1);
    Sa    = zeros(n_MPSA, Np);
    Su    = zeros(n_MPSA, Np);
    value = zeros(n_MPSA, Np);
    AccList = zeros(n_MPSA, Np);    
    Par_values = zeros(n_MPSA, Np);
    V1 = zeros(n_MPSA,length(list_names));

    %% Threshold is 20% of referent difference between apical and basal side
    threshold1 = 20;
    acc       = find(V(:,i) > threshold1);
    unacc     = find(V(:,i) <= threshold1);
    flag(acc) = 1;  % asign 1 to the ordinal number of the simulation that is acceptable 

    %% Cumulative distributions (for model parameters and dummies)
    % Go through parameter list (and dummies) 
    for j = 1 : Np+Nd
        temp = [par_MC(:,j), flag];     % Associate 1 to acceptable cases and 0 to unacceptable parameter values
        temp = sortrows(temp,1);        % Sorts temp based on column 1, parameter values from low to high

        value(:,j) = temp(:,1);         % Values of each parameter for all simulations
        AccList(:,j) = temp(:,2);       % Index of acceptability
        Sa(:,j) = cumsum(temp(:,end));                      % Cumulative sum of acc simulations
        Su(:,j) = cumsum(-1*temp(:,end)+ones(n_MPSA,1));    % Cumulative sum of unacc simulations, reversing 0 and 1
        Sa(:,j) = Sa(:,j)/max(Sa(:,j));                     % Normalisation, range [0,1]
        Su(:,j) = Su(:,j)/max(Su(:,j));                     % Normalisation, range [0,1]
    end

    K_S =  max(abs(Sa-Su));             % Kolmogovor-Smirnov distance, maximum
    
    % Temporarly to plot K-S example graph
        if i==3
            figure(20);hold on
            plot(1:1:3000,Sa(:,6),'Color','b', 'LineWidth', 2);     % Plot mean (average) value
            plot(1:1:3000,Su(:,6),'Color','r', 'LineWidth', 2);     % Plot mean (average) value
            x_max_KS = [1075 1075];
            y_max_KS = [Su(1075,6) Sa(1075,6)];
            line(x_max_KS,y_max_KS, 'Color','k','LineStyle', '--', 'LineWidth', 2);
        end
            
            
    names={'Ic';'δ_C';'α_C';'I_R';...
           'δ_R';'β_R';'I_ρ';'δ_ρ';...
           'β_ρ';'α_ρ';...
          'k_{on,P}'; 'k_{off,P}'; 'β_P_R';'β_P_S';...
          'k_{on,S}';'k_{off,S}';'β_S_P';'I_I';...
          'δ_I';'Itot';'α_I';};
    
    sens = K_S(end,1:Np);                    % maximum K-S of all parameters
    dummy_value = max(K_S(end,(Np+1):end));  % max K-S from all dummy parameters
    name = names(sens>dummy_value);           % if parameter's max K-S greater then max dummy K-S, depict the name of parameter
    sens = sens(:,sens>dummy_value);         % if parameter's max K-S greater then max dummy K-S, depict the value of parameter
    
    %% Find the most influential parameters, their positions and values
    for m = 1:length(name)
    Par_index(m) = find(strcmpi(names,name(m)));    % position of influential parameter
    end
    for k=1:length(name)
        for l=1:n_MPSA
            if AccList(l,Par_index(k))==1
                Par_values_all(i,l,Par_index(k))=value(l,Par_index(k));     % values of influential parameters
                Par_values(l,Par_index(k))=value(l,Par_index(k));
            end
        end
        Par_values_all(i,:,Par_index(k)) = sortrows(Par_values_all(i,:,Par_index(k)),2);    % sort values low to high
        Par_values(:,Par_index(k)) = sortrows(Par_values(:,Par_index(k)),1);
    end

    %% Plot acceptable ranges of the most influential parameters
    figure(i);hold on
    for s = 1:length(name)
        xplot=Par_values(:,Par_index(s));
        xplot(xplot==0)=nan;        % To exclude printing of zero values
        plot(xplot,0.5*s*ones(length(xplot),1),'Color',red1,'LineWidth', 3);
        x1=list_values(Par_index(s));y1=0.5*s;  % Original values
        plot(x1,y1,'*','Color',green1,'MarkerSize',10);
        for n=1:n_MPSA
            if Par_values(n,Par_index(s))==0
            Par_values(n,Par_index(s))=NaN;
            end
        end
        x2=mean(Par_values(:,Par_index(s)),'omitnan');
        MeanValues(i,Par_index(s))=x2;
        x3=median(Par_values(:,Par_index(s)),'omitnan');
        MedianValues(i,Par_index(s))=x3;
        plot(x2,y1,'*','Color',yellow1,'MarkerSize',10);
        ylim([0 0.5*length(name)+0.5]);      
    end
    ax = gca;
    ax.FontSize = 12;
    ax.FontName = 'Arial';
    set(gca,'ytick',[0.5:0.5:0.5*length(name)],'FontSize',12,'yticklabel',name(:))
    xlabel('Acceptable ranges','FontSize',12)
    title(list_names(i));
    %filename = list_names{i} + "_ranges.tif";
    %exportgraphics(ax,filename,'Resolution',300)
    
    %% Plot sensitivity bars
    figure(i+length(list_names))    
    bar(1:3,K_S(end,1:3),'FaceColor',green1)
    hold on
    bar(4:6,K_S(end,4:6),'FaceColor',purple1)
    bar(7:10,K_S(end,7:10),'FaceColor',red1)
    bar(11:14,K_S(end,11:14),'FaceColor',blue1)
    bar(15:17,K_S(end,15:17),'FaceColor',orange1)
    bar(18:21,K_S(end,18:21),'FaceColor',yellow1)
    yline(max(K_S(end,(Np+1):end)),'r','LineWidth',1);  
    ax = gca;
    ax.FontSize = 12;
    ax.FontName = 'Arial';
    xlim([1, Np]);ylabel('Sensitivity');
    xtickangle(90);
    set(gca,'xtick',[1:Np],'FontSize',12,'xticklabel',names)
    ylim([0 max(K_S(end,1:Np))+0.05]);
    title(list_names(i));
    filename = list_names{i} + "_sensitivity_5A-F.tif";
    exportgraphics(ax,filename,'Resolution',300)
    hold off  
    
    %% Plot histogram for output sesitivity
    figure(2*length(list_names)+i);
    for kk = 1:n_MPSA 
        if (V(kk,i) >= 0 && V(kk,i) <= 200)
            V1(kk,i)=V(kk,i);
        end
    end
    x3=mean(V1(:,i));
    x4=median(V1(:,i));y=zeros(1,1);
    bin=10;
    histogram(V1(:,i),bin, 'BinWidth',20);
    xlim([0, 200]);
    ylim([0, n_MPSA]);
    hold on
    plot(x3,y,'*','Color',yellow1,'MarkerSize',10);     % Plot mean (average) value
    plot(x4,y,'*','Color',purple1,'MarkerSize',10);     % Plot median value
    ax = gca;
    ax.FontSize = 12;
    ax.FontName = 'Arial';
    title(list_names(i));
    filename = list_names{i} + "_OutputsSensitivity_6A-F.tif";
    xlabel('Polarisaton strength');ylabel('Frequency')
    exportgraphics(ax,filename,'Resolution',300)
    hold off
    
    %% Look for convergence
    idx = 0; 
    samples = [1,500:500:n_MPSA];
    for n =samples
        idx = idx + 1;
        %disp(n)
        flag  = zeros(n , 1);
        Sa    = zeros(n , Np);
        Su    = zeros(n , Np);
        value = zeros(n , Np);
        
        threshold1 = 20; 
        acc       = find(V(1:n,i) > threshold1);
        unacc     = find(V(1:n,i) <= threshold1);
        flag(acc) = 1;

%         Cumulative distributions (for model parameters and dumrmies)
        for j = 1 : Np+Nd
            temp = [par_MC(1:n,j), flag];     % Associate 1 to acceptable cases and 0 to unacceptable parameter values
            temp = sortrows(temp,1);          % Sorts temp based on column 1, parameter values from low to high

            value(:,j) = temp(1:n,1);
            Sa(:,j) = cumsum(temp(1:n,end));
            Su(:,j) = cumsum(-1*temp(1:n,end)+ones(n,1));
            Sa(:,j) = Sa(1:n,j)/max(Sa(1:n,j));
            Su(:,j) = Su(1:n,j)/max(Su(1:n,j)); 
        end
        K_S(idx,:) = max(abs(Sa-Su));
    end 
    sd=std(K_S(:,(Np+1):end)');Mean=mean(K_S(:,(Np+1):end)');   %Calculating mean and Sd of the dumies 
       
    figure(3*length(list_names)+1);     
    subplot(3,2,i);hold on 
    errorbar(samples ,Mean,sd,'*')
    ax = gca;
    ax.FontSize = 12;
    ax.FontName = 'Arial';
    title(list_names(i));
    xlabel('n_{MPSA}');ylabel('Mean')   
    hold off
end

Par_Cdc42(:,:)=Par_values_all(1,:,:);
Par_Rac1(:,:)=Par_values_all(2,:,:);
Par_Rhoa(:,:)=Par_values_all(3,:,:);
Par_PAR(:,:)=Par_values_all(4,:,:);
Par_Sc(:,:)=Par_values_all(5,:,:);
Par_Ia(:,:)=Par_values_all(6,:,:);
