function colorMatrix = ColorMapCdc42(c1,c2,c3,n)
% This function creates a linear colormap between 3 colors.
% Syntax:
% colorArray = LinearColorMap3(c1,c2,c3,n)
% c1: RGB triple (as row) of first color (range between 0 and 1)
% c2: RGB triple (as row) of second color (range between 0 and 1)
% c1: RGB triple (as row) of third color (range between 0 and 1)
% n: number of intermediate colors between each pair of "main" colors (so
% from c1 to c2 and from c2 to c3). The total number of colors in
% colorMatrix is 2*n-1. If no n is given, default value of 25 is used

if nargin < 3
    c1 = [229,245,224]/255;             % Blue
    c2 = [161,217,155]/255;             % White
    c3 = [0.4660,0.6740,0.1880];        % Red
end

if nargin < 4
    n=25;
end

colorMatrix = zeros(2*n,3);

for i = 1:numel(c1)
    colorMatrix(1:n,i) = linspace(c1(i),c2(i),n);
    colorMatrix(n+1:end,i) = linspace(c2(i),c3(i),n);
end

colorMatrix = unique(colorMatrix,'rows','stable');    % Remove the duplicate rows n and n+1 (both containing the values c2), keeping the original order
