(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     83688,       1812]
NotebookOptionsPosition[     82590,       1783]
NotebookOutlinePosition[     83021,       1800]
CellTagsIndexPosition[     82978,       1797]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Figure S13", "Section",
 CellChangeTimes->{{3.9705863651838017`*^9, 
  3.970586368307002*^9}},ExpressionUUID->"71b6afb8-8a33-45e8-b3f1-\
6c2081f1a687"],

Cell[CellGroupData[{

Cell[TextData[{
 "Experimental voltage dependence of the relative PL efficiency of alpha-MADN \
\n",
 StyleBox[Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Eta]", "PL"], ",", " ", 
     RowBox[{"closed", " ", "blue", " ", "spheres"}]}]}], TraditionalForm]], 
  "Subsubsection",
  FormatType->TraditionalForm,ExpressionUUID->
  "16842019-f629-42e4-a1c5-512d8ef749b3"], "Subsubsection"],
 StyleBox[")", "Subsubsection"]
}], "Subsection",
 CellChangeTimes->{{3.935389460965311*^9, 3.9353894656436996`*^9}, {
  3.936872638076706*^9, 3.93687265310977*^9}, {3.970586423947388*^9, 
  3.9705864916432934`*^9}, {3.9705887125720844`*^9, 
  3.9705887151665373`*^9}},ExpressionUUID->"8ee6112c-a5a8-4efd-ac8d-\
a46604f4c957"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tabFIDalphaMADN", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", " ", "0.89495"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "45.00315"}], ",", " ", "0.91896"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40.11024"}], ",", " ", "0.9416"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "35.06651"}], ",", " ", "0.95943"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30.09517"}], ",", " ", "0.97314"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "24.97343"}], ",", " ", "0.98296"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20.07181"}], ",", " ", "0.98683"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15.02022"}], ",", " ", "0.98772"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10.11955"}], ",", " ", "0.99365"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5.06796"}], ",", " ", "0.99454"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.09895"}], ",", " ", "1.00048"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1.0000"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9353880410796022`*^9, 3.935388054372185*^9}, {
   3.935388136937257*^9, 3.9353881543732853`*^9}, {3.9353882729760904`*^9, 
   3.935388276416926*^9}, {3.9353883579239454`*^9, 3.935388373297589*^9}, {
   3.9353884358757367`*^9, 3.9353884442561445`*^9}, {3.935388512145947*^9, 
   3.935388519073512*^9}, {3.9353885938547163`*^9, 3.935388599435732*^9}, {
   3.9353886621045575`*^9, 3.9353886658258524`*^9}, {3.935388704952851*^9, 
   3.9353887051217847`*^9}, {3.93538874145364*^9, 3.9353888263041267`*^9}, {
   3.9353888646583924`*^9, 3.935389244231042*^9}, {3.9353892814402633`*^9, 
   3.935389445068162*^9}, {3.9353894934469156`*^9, 3.935389657958971*^9}, {
   3.9353898179919343`*^9, 3.935389818176486*^9}, {3.9353898524789*^9, 
   3.935390014485047*^9}, {3.9353906269556837`*^9, 3.935390787559397*^9}, {
   3.9353917143803263`*^9, 3.9353918201155076`*^9}, {3.9353918645164547`*^9, 
   3.9353919928900948`*^9}, {3.9353920278290043`*^9, 
   3.9353920484503136`*^9}, {3.935392162096511*^9, 3.9353922310581226`*^9}, {
   3.935392370516492*^9, 3.9353926348229504`*^9}, {3.9353927176495113`*^9, 
   3.935392822361189*^9}, {3.9353928627661686`*^9, 3.935392882454056*^9}, {
   3.935392927243447*^9, 3.9353930012491503`*^9}, {3.935393042652191*^9, 
   3.9353931464063053`*^9}, {3.935393182520608*^9, 3.935393213008102*^9}, {
   3.935393269266979*^9, 3.935393289872609*^9}, {3.935393363065728*^9, 
   3.935393406840316*^9}, {3.935393441692851*^9, 3.9353934934838195`*^9}, {
   3.935393536408184*^9, 3.9353935592155113`*^9}, {3.9353935942746544`*^9, 
   3.935393594706582*^9}, {3.935393633569473*^9, 3.9353936500575624`*^9}, {
   3.935393686526622*^9, 3.935393929405801*^9}, {3.9353939914166756`*^9, 
   3.9353940911132903`*^9}, {3.9353941213491755`*^9, 3.935394184745834*^9}, {
   3.935394230384841*^9, 3.9353944600537834`*^9}, {3.93539453282611*^9, 
   3.935394539261609*^9}, {3.9353945871946106`*^9, 3.935394588698885*^9}, {
   3.9353948109260817`*^9, 3.935394859185398*^9}, {3.9353948947367163`*^9, 
   3.935395044863637*^9}, {3.9353951466566467`*^9, 3.9353951847611113`*^9}, {
   3.935395219277851*^9, 3.9353953774632926`*^9}, {3.9353954321331315`*^9, 
   3.9353954591087074`*^9}, {3.9368726624978437`*^9, 
   3.9368726716463957`*^9}, {3.936872703801244*^9, 3.936872733507292*^9}, {
   3.936872906660584*^9, 3.936872908634121*^9}, {3.936872978040104*^9, 
   3.936873035571947*^9}, {3.9368732081515727`*^9, 3.9368732443710847`*^9}, {
   3.936873430172064*^9, 3.936873561888019*^9}, {3.936873601479887*^9, 
   3.936873624790057*^9}, {3.9368736632717605`*^9, 3.936873785411499*^9}, {
   3.93687383132244*^9, 3.9368738859987955`*^9}, {3.936874315238152*^9, 
   3.936874420841692*^9}, {3.9368744922687397`*^9, 3.936874513877606*^9}, {
   3.9368745448986273`*^9, 3.9368745450679283`*^9}, {3.9368745804690266`*^9, 
   3.936874623595765*^9}, {3.9368746613782983`*^9, 3.9368746650348377`*^9}, {
   3.9368747869847717`*^9, 3.9368748147816305`*^9}, {3.936874998400387*^9, 
   3.9368752148307934`*^9}, {3.9368752503708525`*^9, 3.936875442320125*^9}, {
   3.9368755469437895`*^9, 3.9368757244336424`*^9}, {3.9368759215735087`*^9, 
   3.936875941897917*^9}, 3.9368764346342325`*^9, {3.9368764667140803`*^9, 
   3.9368764712569494`*^9}, {3.936951111007985*^9, 3.9369512754464645`*^9}, {
   3.9705865075224257`*^9, 3.97058654599378*^9}, 3.9705868440119467`*^9, {
   3.9705882075655613`*^9, 3.970588207882612*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"d1f074df-c15f-42c2-85ab-7a6feade6b39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Simulated voltage dependence of the relative PL efficiency of alpha-MADN, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["E", 
      RowBox[{"exc", ",", "b"}]], "=", " ", 
     RowBox[{"1.05", " ", "eV"}]}], ","}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "db611273-06b9-4a85-9180-3d29b02a0fd2"],
 " \n",
 StyleBox["with field-dependent non-radiative decay (see Eq. S2)", 
  "Subsubsection"]
}], "Subsection",
 CellChangeTimes->{{3.935389460965311*^9, 3.9353894656436996`*^9}, {
  3.936872638076706*^9, 3.93687265310977*^9}, {3.970586423947388*^9, 
  3.9705864916432934`*^9}, {3.9705865859317117`*^9, 3.970586587869419*^9}, {
  3.970586626663226*^9, 3.970586640049574*^9}, {3.9705866974588537`*^9, 
  3.9705867373644466`*^9}},ExpressionUUID->"21b6261d-f2e0-4753-ba28-\
2c50481c0429"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"PL", " ", 
    RowBox[{"(", 
     RowBox[{"full", " ", "blue", " ", "curve"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tabetaPL", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.23321"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.33245"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.47444"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.62930"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.78487"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.8915"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.94965"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.9727"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.98306"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99156"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"etaJ", " ", 
     RowBox[{"(", 
      RowBox[{"full", " ", "red", " ", "curve"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabetaJ", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.74625"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.64133"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.49232"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.33309"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.17595"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.0693"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.01688"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.0023"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.00009"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"etatotabs", " ", 
     RowBox[{"(", 
      RowBox[{"full", " ", "black", " ", "curve"}], ")"}]}], " ", "*)"}], " ",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabtotabs", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.97946`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.97378`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.96676`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.96239`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.96082`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.9608`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.96653`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.975`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.9831500000000001`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99156`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"etatot", "=", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"dashed", " ", "black", " ", "curve"}], ",", " ", 
       RowBox[{"as", " ", "defined", " ", "in", " ", 
        RowBox[{"Eq", ".", " ", 
         RowBox[{"(", "6", ")"}]}], " ", "of", " ", "the", " ", "main", " ", 
        "paper"}]}], ")"}]}], " ", "*)"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabetatot", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "1.4015812121212123`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "1.3365525252525257`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "1.2452440404040406`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "1.1508045454545455`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "1.0603472727272727`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.9760782828282828`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.9763010101010101`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.9832009090909092`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99156`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"etaPLnoFID", "=", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"dashed", " ", "magenta", " ", "curve"}], ",", " ", 
       RowBox[{"no", " ", "FID"}], ",", " ", 
       RowBox[{
        RowBox[{
        "PL", " ", "variation", " ", "only", " ", "due", " ", "to", " ", 
         "field"}], "-", 
        RowBox[{"dependent", " ", "non"}], "-", 
        RowBox[{"radiative", " ", "decay"}]}]}], " ", ")"}]}], " ", "*)"}], 
   " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabetaPLnoFID", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.9208103130755064`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "99"}], ",", "0.9215400777779825`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "98"}], ",", "0.9222710001106726`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "97"}], ",", "0.9230030828302966`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "96"}], ",", "0.9237363287023352`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.924470740501063`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "94"}], ",", "0.9252063210095851`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "93"}], ",", "0.9259430730198708`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "92"}], ",", "0.9266809993327896`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "91"}], ",", "0.9274201027581473`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.9281603861147207`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "89"}], ",", "0.9289018522302933`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "88"}], ",", "0.9296445039416927`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "87"}], ",", "0.9303883440948253`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "86"}], ",", "0.931133375544713`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.9318796011555307`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "84"}], ",", "0.9326270238006416`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "83"}], ",", "0.9333756463626351`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "82"}], ",", "0.9341254717333632`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "81"}], ",", "0.9348765028139783`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.9356287425149701`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "79"}], ",", "0.9363821937562035`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "78"}], ",", "0.9371368594669566`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "77"}], ",", "0.9378927425859579`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "76"}], ",", "0.9386498460614252`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.9394081728511038`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "74"}], ",", "0.9401677259223046`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "73"}], ",", "0.940928508251943`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "72"}], ",", "0.9416905228265783`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "71"}], ",", "0.942453772642452`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.9432182607055273`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "69"}], ",", "0.9439839900315291`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "68"}], ",", "0.9447509636459829`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "67"}], ",", "0.9455191845842552`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "66"}], ",", "0.9462886558915933`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.947059380623165`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "64"}], ",", "0.9478313618441008`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "63"}], ",", "0.9486046026295321`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "62"}], ",", "0.9493791060646337`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "61"}], ",", "0.9501548752446649`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.9509319132750095`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "59"}], ",", "0.9517102232712183`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "58"}], ",", "0.9524898083590506`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "57"}], ",", "0.9532706716745152`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "56"}], ",", "0.9540528163639139`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.9548362455838825`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "54"}], ",", "0.9556209625014334`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "53"}], ",", "0.9564069702939996`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "52"}], ",", "0.9571942721494754`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "51"}], ",", "0.9579828712662618`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.9587727708533078`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "49"}], ",", "0.9595639741301552`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "48"}], ",", "0.9603564843269822`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "47"}], ",", "0.9611503046846467`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "46"}], ",", "0.9619454384547308`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.962741888899586`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "44"}], ",", "0.9635396592923764`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "43"}], ",", "0.9643387529171247`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "42"}], ",", "0.9651391730687566`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "41"}], ",", "0.965940923053146`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.9667440061871616`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "39"}], ",", "0.9675484257987114`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "38"}], ",", "0.9683541852267885`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "37"}], ",", "0.9691612878215193`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "36"}], ",", "0.9699697369442073`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.9707795359673818`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "34"}], ",", "0.9715906882748436`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "33"}], ",", "0.9724031972617125`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "32"}], ",", "0.9732170663344752`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "31"}], ",", "0.9740322989110319`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.9748488984207447`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "29"}], ",", "0.9756668683044861`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "28"}], ",", "0.9764862120146862`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "27"}], ",", "0.9773069330153827`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "26"}], ",", "0.9781290347822685`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "25"}], ",", "0.978952520802741`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "24"}], ",", "0.9797773945759524`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "23"}], ",", "0.9806036596128578`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "22"}], ",", "0.9814313194362658`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "21"}], ",", "0.9822603775808891`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.9830908375933936`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "19"}], ",", "0.9839227030324498`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "18"}], ",", "0.9847559774687833`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "17"}], ",", "0.9855906644852259`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "16"}], ",", "0.9864267676767677`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15"}], ",", "0.9872642906506073`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "14"}], ",", "0.9881032370262044`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "13"}], ",", "0.988943610435333`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "12"}], ",", "0.9897854145221315`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "11"}], ",", "0.9906286529431577`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99147332936744`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "9"}], ",", "0.9923194474765316`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "8"}], ",", "0.9931670109645638`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "7"}], ",", "0.9940160235382995`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "6"}], ",", "0.9948664889171872`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "0.9957184108334164`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "0.99657179303197`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "0.9974266392706816`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0.9982829533202892`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0.9991407389644904`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.9705866873821054`*^9, 3.970586688645297*^9}, {
  3.970586760694985*^9, 3.9705868038297815`*^9}, {3.9705868895264287`*^9, 
  3.970587139258057*^9}, {3.970587188051755*^9, 3.970587188508731*^9}, {
  3.9705872413641143`*^9, 3.9705872426516137`*^9}, {3.9705872731244245`*^9, 
  3.9705873124628773`*^9}, {3.970587576800623*^9, 3.970587650129058*^9}, {
  3.9705877685382833`*^9, 3.9705877722996535`*^9}, {3.9705878963764267`*^9, 
  3.970587974010084*^9}, {3.970588018773197*^9, 3.9705880471399717`*^9}, {
  3.9705881763110733`*^9, 3.9705882222807827`*^9}, {3.970588294826928*^9, 
  3.9705883269503407`*^9}, {3.9705884127072716`*^9, 3.9705884143119493`*^9}, {
  3.9705885441562605`*^9, 3.9705885756409583`*^9}, {3.9705886168950377`*^9, 
  3.9705886914717226`*^9}, {3.9705887313834105`*^9, 3.970588801341254*^9}, {
  3.9705888406896276`*^9, 3.970588857220708*^9}, {3.9705889952104335`*^9, 
  3.9705890050391016`*^9}},
 CellLabel->
  "In[226]:=",ExpressionUUID->"c903ae01-38d1-413d-98d5-0d14b8aaf851"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Figure", " ", "S13"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.970588886698604*^9, 
  3.9705888946303034`*^9}},ExpressionUUID->"dbb99c42-fdf8-40c1-8564-\
27ce85d3c563"],

Cell[BoxData[
 GraphicsBox[{
   {Thickness[0.005], 
    LineBox[{{-100, 0}, {0, 0}, {0, 1}, {-100, 1}, {-100, 0}}]}, {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 0, 1], PointSize[0.015], AbsoluteThickness[2], 
         PointBox[{{-50., 0.89495}, {-45.00315, 0.91896}, {-40.11024, 
          0.9416}, {-35.06651, 0.95943}, {-30.09517, 0.97314}, {-24.97343, 
          0.98296}, {-20.07181, 0.98683}, {-15.02022, 0.98772}, {-10.11955, 
          0.99365}, {-5.06796, 0.99454}, {-2.09895, 1.00048}, {0., 1.}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1], 
              PointSize[0.015]], 
             
             Point[{{-50., 0.89495}, {-45.00315, 0.91896}, {-40.11024, 
              0.9416}, {-35.06651, 0.95943}, {-30.09517, 0.97314}, {-24.97343,
               0.98296}, {-20.07181, 0.98683}, {-15.02022, 
              0.98772}, {-10.11955, 0.99365}, {-5.06796, 0.99454}, {-2.09895, 
              1.00048}, {0., 1.}}]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{-100., 1.}, {-0.01, 1.01}}, 
            "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
            "ImageSize" -> {360, 285.12}, "Axes" -> {False, False}, 
            "LabelStyle" -> {}, "AspectRatio" -> 0.792, "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               RGBColor[0, 0, 1], 
               PointSize[0.015]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{-100., 1.}, {-0.01, 1.01}}, 
           "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {360, 285.12}, "Axes" -> {False, False}, 
           "LabelStyle" -> {}, "AspectRatio" -> 0.792, "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1], 
              PointSize[0.015]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           AbsoluteThickness[2], 
           RGBColor[0, 0, 1], 
           PointSize[0.015]], 
          
          Point[{{-50., 0.89495}, {-45.00315, 0.91896}, {-40.11024, 
           0.9416}, {-35.06651, 0.95943}, {-30.09517, 0.97314}, {-24.97343, 
           0.98296}, {-20.07181, 0.98683}, {-15.02022, 0.98772}, {-10.11955, 
           0.99365}, {-5.06796, 0.99454}, {-2.09895, 1.00048}, {0., 1.}}]}, 
         "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{-100., 1.}, {-0.01, 1.01}}, 
         "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 285.12}, "Axes" -> {False, False}, 
         "LabelStyle" -> {}, "AspectRatio" -> 0.792, "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            RGBColor[0, 0, 1], 
            PointSize[0.015]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 1], PointSize[0.015], AbsoluteThickness[2], 
          LineBox[CompressedData["
1:eJxVlHs0lHkYx22xFdlOqhXpIKWSajRRbj0zboPJGOM6lXRxWV03pVabRajk
utWGJG0tSxc6oXLLoyKi5D6l3GKYMTNv65LI1vJ6/bGfc97z/vE77+f9fp/n
nJ/2nsM8nxlycnI+E8/kewo+KtXHWDe8eQnRrGLHnw54oIZrxkr/fa8hYH/p
DdtudzSWW3pVpaUOBCoDzFpfdzzyQ6FGE70BGrvNjusNumGzjnJFWlgjnD83
iRue7k7P213WBCrpJWWqum4YOrRAQXGoGeI6n+37vtoVe0eEDWfVBaDec6bm
9HFXrLmQbf7C8A00uknWF610Rab/2E60eQvvSVxwu+Y2Fz6nFZy0rTTVklxw
Ld/TJMLhHdhXzjJPcXXB54UX19Ks38NC37df/1jkgmeHdf6xM2oDbvnJhOgW
Zyztr4Bz2u2wpC8vjJPijD6CDz35Mzsgq3hpZ94uZ7y5Qf6E8bEOMDSwL7m0
0hmFl/K/xXZ1wAi9dvkzgofB8/zvDHA6QS+XqatWwMNH9+OzMgo6QT7V6LV/
OA+74q7oiJZ1AbZbGMRweMjOG7MZPd8FSf5f3N3UecigazN+HOiCilXDvGtC
J1TRCDEN8fgAIUrlNJNcJ5wbEulz9PEHINcR6oTBB9LFBsu74WXNBFudMHO/
fawwqhuuJE+g5oRJ7VV+h4lu8POdQMhFpxtH9RJdeoA+SS4X62ITI1cV9FA+
Li49FblapiGkfFyks2Ir7ocIIZn0cXFR1de5zE4h1JA44rPW1Xf3MnvBl8QR
mfyd7j1pvfCNhINxSyRFCeO9U98nc/DW+LJomnsfbCADcDCpmRcYn9NH+Ryw
OqbMLkhBBD6kzwHFrbVpDR4i+I4M6IAt/NHm1CwRJJK+rdiWnnNQMCKa6kPf
ijwv765wSzHlY2P4iqjc6zHiqf6+bHyaGO+1vkE81VeOjbtcRd401f6peSXb
4+1/Z1n85dFP5bPHz+s9A6MT++EV6bPDC9HbgoUN/VRfO6zJOSLIV5ZQfW3x
k+lChTErCeWzxXX6KXX5QRLYSPpsMZ8YZw/flkA16WNhIk+1vqJVQvlYKNaq
LNs8R0r1ZWG+rvQX/kYpJJE+G1Skebtu8pRSfW1wbLZSfke4dGpfNdYYE1w6
vDdTSvmsJ+blFVj7YtpnjX3+lb8b9EupfVhhRZAgM2mOjPJZYZTrwcULdGXU
/CxxsFc9IIcho3yWyG+rk4TyZdT8LPFaZrt32s8yymeBzk0s8bIz0z4LVB9U
jtW5IqPyMTEqwdCz4M60j4mGZk/2jZfIqPkxsCTiYbn8q2kfAx98Xvyb+N20
j4EFuuKb5WIZpJDngHtS17GyR2TUfrYgq190ongmQfnMcUaaps3seQTI1/eb
qdLN8ZuWfECmGgHSHWvyzviY4UdG/KlsHQKu8VWuZ1w2xe2Zost6awn4Gjpk
UltugpVyZgP6RgQMRq8o9RgwxuLB7NLyLQTsoI/6piwxxkK9/TQFFgE6tKcH
CMZmdHBMDvzCIUDPtEXx7u5N+ElxDz5yI2C7ctSv+sFGaD5LxnTYScBFL/3R
8guGeEvqs6bKh4BC8cLHdX9uxBK/gbtmBwl44HdZPjOLjvKaxWMPjxFQ39ah
dDFrA+ICwSH2KQIenyROp6QZYMX8RL5SBAHkdXqOhn73IsfnxRDAtUsN1X2y
Dovea5QfuTSRp6UyRcTWx5azTVp2qQQkDAqyav5ejU1XVwVnZxBwqGXywtbF
asV4VuG9if8XTaKDr0vDpBFFBOx6s5hzx1cLx7OC3uk+JyCODKSGvg+JsEcN
BFTZzmkMLJqPy5t3sHmdBFz/4cTsTwEzkDtknDH3IwFy/+Mj/Af1TT1L
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1], 
              PointSize[0.015]], 
             Line[CompressedData["
1:eJxVlHs0lHkYx22xFdlOqhXpIKWSajRRbj0zboPJGOM6lXRxWV03pVabRajk
utWGJG0tSxc6oXLLoyKi5D6l3GKYMTNv65LI1vJ6/bGfc97z/vE77+f9fp/n
nJ/2nsM8nxlycnI+E8/kewo+KtXHWDe8eQnRrGLHnw54oIZrxkr/fa8hYH/p
DdtudzSWW3pVpaUOBCoDzFpfdzzyQ6FGE70BGrvNjusNumGzjnJFWlgjnD83
iRue7k7P213WBCrpJWWqum4YOrRAQXGoGeI6n+37vtoVe0eEDWfVBaDec6bm
9HFXrLmQbf7C8A00uknWF610Rab/2E60eQvvSVxwu+Y2Fz6nFZy0rTTVklxw
Ld/TJMLhHdhXzjJPcXXB54UX19Ks38NC37df/1jkgmeHdf6xM2oDbvnJhOgW
Zyztr4Bz2u2wpC8vjJPijD6CDz35Mzsgq3hpZ94uZ7y5Qf6E8bEOMDSwL7m0
0hmFl/K/xXZ1wAi9dvkzgofB8/zvDHA6QS+XqatWwMNH9+OzMgo6QT7V6LV/
OA+74q7oiJZ1AbZbGMRweMjOG7MZPd8FSf5f3N3UecigazN+HOiCilXDvGtC
J1TRCDEN8fgAIUrlNJNcJ5wbEulz9PEHINcR6oTBB9LFBsu74WXNBFudMHO/
fawwqhuuJE+g5oRJ7VV+h4lu8POdQMhFpxtH9RJdeoA+SS4X62ITI1cV9FA+
Li49FblapiGkfFyks2Ir7ocIIZn0cXFR1de5zE4h1JA44rPW1Xf3MnvBl8QR
mfyd7j1pvfCNhINxSyRFCeO9U98nc/DW+LJomnsfbCADcDCpmRcYn9NH+Ryw
OqbMLkhBBD6kzwHFrbVpDR4i+I4M6IAt/NHm1CwRJJK+rdiWnnNQMCKa6kPf
ijwv765wSzHlY2P4iqjc6zHiqf6+bHyaGO+1vkE81VeOjbtcRd401f6peSXb
4+1/Z1n85dFP5bPHz+s9A6MT++EV6bPDC9HbgoUN/VRfO6zJOSLIV5ZQfW3x
k+lChTErCeWzxXX6KXX5QRLYSPpsMZ8YZw/flkA16WNhIk+1vqJVQvlYKNaq
LNs8R0r1ZWG+rvQX/kYpJJE+G1Skebtu8pRSfW1wbLZSfke4dGpfNdYYE1w6
vDdTSvmsJ+blFVj7YtpnjX3+lb8b9EupfVhhRZAgM2mOjPJZYZTrwcULdGXU
/CxxsFc9IIcho3yWyG+rk4TyZdT8LPFaZrt32s8yymeBzk0s8bIz0z4LVB9U
jtW5IqPyMTEqwdCz4M60j4mGZk/2jZfIqPkxsCTiYbn8q2kfAx98Xvyb+N20
j4EFuuKb5WIZpJDngHtS17GyR2TUfrYgq190ongmQfnMcUaaps3seQTI1/eb
qdLN8ZuWfECmGgHSHWvyzviY4UdG/KlsHQKu8VWuZ1w2xe2Zost6awn4Gjpk
UltugpVyZgP6RgQMRq8o9RgwxuLB7NLyLQTsoI/6piwxxkK9/TQFFgE6tKcH
CMZmdHBMDvzCIUDPtEXx7u5N+ElxDz5yI2C7ctSv+sFGaD5LxnTYScBFL/3R
8guGeEvqs6bKh4BC8cLHdX9uxBK/gbtmBwl44HdZPjOLjvKaxWMPjxFQ39ah
dDFrA+ICwSH2KQIenyROp6QZYMX8RL5SBAHkdXqOhn73IsfnxRDAtUsN1X2y
Dovea5QfuTSRp6UyRcTWx5azTVp2qQQkDAqyav5ejU1XVwVnZxBwqGXywtbF
asV4VuG9if8XTaKDr0vDpBFFBOx6s5hzx1cLx7OC3uk+JyCODKSGvg+JsEcN
BFTZzmkMLJqPy5t3sHmdBFz/4cTsTwEzkDtknDH3IwFy/+Mj/Af1TT1L
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{-100., 0.}, {0., 1.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               RGBColor[0, 0, 1], 
               PointSize[0.015]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{-100., 0.}, {0., 1.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1], 
              PointSize[0.015]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           AbsoluteThickness[2], 
           RGBColor[0, 0, 1], 
           PointSize[0.015]], 
          Line[CompressedData["
1:eJxVlHs0lHkYx22xFdlOqhXpIKWSajRRbj0zboPJGOM6lXRxWV03pVabRajk
utWGJG0tSxc6oXLLoyKi5D6l3GKYMTNv65LI1vJ6/bGfc97z/vE77+f9fp/n
nJ/2nsM8nxlycnI+E8/kewo+KtXHWDe8eQnRrGLHnw54oIZrxkr/fa8hYH/p
DdtudzSWW3pVpaUOBCoDzFpfdzzyQ6FGE70BGrvNjusNumGzjnJFWlgjnD83
iRue7k7P213WBCrpJWWqum4YOrRAQXGoGeI6n+37vtoVe0eEDWfVBaDec6bm
9HFXrLmQbf7C8A00uknWF610Rab/2E60eQvvSVxwu+Y2Fz6nFZy0rTTVklxw
Ld/TJMLhHdhXzjJPcXXB54UX19Ks38NC37df/1jkgmeHdf6xM2oDbvnJhOgW
Zyztr4Bz2u2wpC8vjJPijD6CDz35Mzsgq3hpZ94uZ7y5Qf6E8bEOMDSwL7m0
0hmFl/K/xXZ1wAi9dvkzgofB8/zvDHA6QS+XqatWwMNH9+OzMgo6QT7V6LV/
OA+74q7oiJZ1AbZbGMRweMjOG7MZPd8FSf5f3N3UecigazN+HOiCilXDvGtC
J1TRCDEN8fgAIUrlNJNcJ5wbEulz9PEHINcR6oTBB9LFBsu74WXNBFudMHO/
fawwqhuuJE+g5oRJ7VV+h4lu8POdQMhFpxtH9RJdeoA+SS4X62ITI1cV9FA+
Li49FblapiGkfFyks2Ir7ocIIZn0cXFR1de5zE4h1JA44rPW1Xf3MnvBl8QR
mfyd7j1pvfCNhINxSyRFCeO9U98nc/DW+LJomnsfbCADcDCpmRcYn9NH+Ryw
OqbMLkhBBD6kzwHFrbVpDR4i+I4M6IAt/NHm1CwRJJK+rdiWnnNQMCKa6kPf
ijwv765wSzHlY2P4iqjc6zHiqf6+bHyaGO+1vkE81VeOjbtcRd401f6peSXb
4+1/Z1n85dFP5bPHz+s9A6MT++EV6bPDC9HbgoUN/VRfO6zJOSLIV5ZQfW3x
k+lChTErCeWzxXX6KXX5QRLYSPpsMZ8YZw/flkA16WNhIk+1vqJVQvlYKNaq
LNs8R0r1ZWG+rvQX/kYpJJE+G1Skebtu8pRSfW1wbLZSfke4dGpfNdYYE1w6
vDdTSvmsJ+blFVj7YtpnjX3+lb8b9EupfVhhRZAgM2mOjPJZYZTrwcULdGXU
/CxxsFc9IIcho3yWyG+rk4TyZdT8LPFaZrt32s8yymeBzk0s8bIz0z4LVB9U
jtW5IqPyMTEqwdCz4M60j4mGZk/2jZfIqPkxsCTiYbn8q2kfAx98Xvyb+N20
j4EFuuKb5WIZpJDngHtS17GyR2TUfrYgq190ongmQfnMcUaaps3seQTI1/eb
qdLN8ZuWfECmGgHSHWvyzviY4UdG/KlsHQKu8VWuZ1w2xe2Zost6awn4Gjpk
UltugpVyZgP6RgQMRq8o9RgwxuLB7NLyLQTsoI/6piwxxkK9/TQFFgE6tKcH
CMZmdHBMDvzCIUDPtEXx7u5N+ElxDz5yI2C7ctSv+sFGaD5LxnTYScBFL/3R
8guGeEvqs6bKh4BC8cLHdX9uxBK/gbtmBwl44HdZPjOLjvKaxWMPjxFQ39ah
dDFrA+ICwSH2KQIenyROp6QZYMX8RL5SBAHkdXqOhn73IsfnxRDAtUsN1X2y
Dovea5QfuTSRp6UyRcTWx5azTVp2qQQkDAqyav5ejU1XVwVnZxBwqGXywtbF
asV4VuG9if8XTaKDr0vDpBFFBOx6s5hzx1cLx7OC3uk+JyCODKSGvg+JsEcN
BFTZzmkMLJqPy5t3sHmdBFz/4cTsTwEzkDtknDH3IwFy/+Mj/Af1TT1L
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{-100., 0.}, {0., 1.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            RGBColor[0, 0, 1], 
            PointSize[0.015]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[1, 0, 0], PointSize[0.015], AbsoluteThickness[2], 
          LineBox[CompressedData["
1:eJxdlHs0lHkYxyVFuWxZs8gK61Y4RVNynce4jeuYGZdRSeUyKOkmpEScldIi
ljChdEpKqzLdKB7XQwaRXEJYl5CyUdJ2W17vX/s553d+f7zn/Zzv93nO+an5
HOD4i4qIiPjPn4V7kW04GCn3F2PwNSQyHrsEBntiZa2qaYn8azi8ryLfbpiL
lUaKVAPuKHTJTtNbeFyUC5a6YZk3Au3DZmE6Mx448klCEDg1DGcTFvDAoFBl
fw3GMMhefVIpr+WBjcc8W2evDkHSYM3e5Y3uaH6pXmqP5BCsGYkXxoa541T0
Cd3hsL+h3WNyY5m2O66+E0tfMjYIfQRu2NY47mPsPQhsNWsVxUw39A3EK9Ld
A+BQL27Od3fD92spCj+4AyDHe/k9neKGw8rB61Xv9QOrNjIlsdMVb3xziq7A
V6A0JjjF5Lui0kNzVbe2Pih8rDwo2O2KFw03nPAc74UtBg5P/tR2xQwfmaWM
Zb3widqiUTPFwYOazRrZmj2gU0LXUnzEwbTAnWyh/UsQyzF8FhTHQT9K0Rz3
UDdgv6XBOSYHnSk3zj7gd0Fm0BeuxxoO3mczwv3rO6Fu3UdO7igbxQVHNvTO
dkC0ZK2+SQkbCzRVVDO0OoBYRwwbvyYbP5bmvoAm4TxObIzJkZUYOd0O2Vnz
KLKx62uEt9ej5xDAm2eUhajML+550wbUBUpYOHWg4M1TlTbSx0IlX6Foqnsr
6WPhV57RSOYfzyCL8LEwvYO6PDmlBYQELhhVQcuSlGoGHoELqgS+8w1PEsIP
AiZOFufZ5is0Lv6fxURWWLGa180G2EQEYGJFduSLUEY96XNG/X+9rB6+rQN/
wueMRsZ834zcWlhCBHTG79U+Nurba+AC4XPCTWIDcyGq1Yt9qE6Y4gtJZ95X
kj5HrHa8RYlrwsX+PEdc7lxE6wysWOwr4ohLy4Rh15yeLM4rywHHBHIf0mzL
yHwOuFamr6PC4xE0Ez57XJl9EhyiHpB97XG1HofpWnqP7GuH/Au31b9IC0if
Hf6caSxjE3EXNhM+OxxLuE6pnLsNjYSPgdI7fvTXKBeTPgZWpcZeMwotIvsy
sAn6J6pnCiGT8Nmi9LiiojO/gOxriz6UrTmlQVcX9yW0wTuOpkPTO6+QPhts
kdXl9oZdJn02aDtEeVrKyyP3YY1Sr8rfP9S4SPqssVx9+7dozSxyfla4xnGp
TQcvg/RZYbBJTP7kSBo5PyuM06Yf8s47T/os0Tf/vOIplWTSZ4l5k9TLLgGJ
ZD46+t4M0ef8lED66OjuxTh5d9Xv5PwsUC2qmp7tF0v6LPBY4pgBVSyG9Fng
uxURkszW48AnvgNmN8eP0X6JIPdDQ/vdEkHnGkJJnzmySsW/nOk7BGJtb8zk
qeb4cSLApSkxBN566Qri/c1w3CKrIfpTEORuk710LcMU65r3xivP+MP3mA8m
LbUm2DN5pSDziA/MJGpWeE4bY/eofG5djzd4UT/z+ErGmHK03az/1jZQ168O
nrIwwv2GUgd2MdxBx7Rz5a09W3HZS+cI3VQ27JA+c1wvyhAn1VhGLv84Qdou
vc+1qVswTt7V7GAdA0on5MpbL29G8dnKuNhIK7gfkCF2vZCKruahujkI0PZq
QDKtcBNubAgfLc80hvLIqVh+ngFWlXioHbbfDMRzmqCPVeZ07p64jcCyz4nR
qtqAo6oe56eHtEGns54/7qiH9b9eCE9PV4OUma5CYcF6DIz0VkueVoCQzoUH
WwvnlNLqpAZWwf2yBdSxYZ91l/m+ZbC7W4FZxFNFv+jTUaIv5mhJRCBFnDhL
3x8gPk5rsFvRfrRsNZr9JrB+V/icdkkmXGL2sCgWHnFY5yd3hybyP/4DMe0N
5g==
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0], 
              PointSize[0.015]], 
             Line[CompressedData["
1:eJxdlHs0lHkYxyVFuWxZs8gK61Y4RVNynce4jeuYGZdRSeUyKOkmpEScldIi
ljChdEpKqzLdKB7XQwaRXEJYl5CyUdJ2W17vX/s553d+f7zn/Zzv93nO+an5
HOD4i4qIiPjPn4V7kW04GCn3F2PwNSQyHrsEBntiZa2qaYn8azi8ryLfbpiL
lUaKVAPuKHTJTtNbeFyUC5a6YZk3Au3DZmE6Mx448klCEDg1DGcTFvDAoFBl
fw3GMMhefVIpr+WBjcc8W2evDkHSYM3e5Y3uaH6pXmqP5BCsGYkXxoa541T0
Cd3hsL+h3WNyY5m2O66+E0tfMjYIfQRu2NY47mPsPQhsNWsVxUw39A3EK9Ld
A+BQL27Od3fD92spCj+4AyDHe/k9neKGw8rB61Xv9QOrNjIlsdMVb3xziq7A
V6A0JjjF5Lui0kNzVbe2Pih8rDwo2O2KFw03nPAc74UtBg5P/tR2xQwfmaWM
Zb3widqiUTPFwYOazRrZmj2gU0LXUnzEwbTAnWyh/UsQyzF8FhTHQT9K0Rz3
UDdgv6XBOSYHnSk3zj7gd0Fm0BeuxxoO3mczwv3rO6Fu3UdO7igbxQVHNvTO
dkC0ZK2+SQkbCzRVVDO0OoBYRwwbvyYbP5bmvoAm4TxObIzJkZUYOd0O2Vnz
KLKx62uEt9ej5xDAm2eUhajML+550wbUBUpYOHWg4M1TlTbSx0IlX6Foqnsr
6WPhV57RSOYfzyCL8LEwvYO6PDmlBYQELhhVQcuSlGoGHoELqgS+8w1PEsIP
AiZOFufZ5is0Lv6fxURWWLGa180G2EQEYGJFduSLUEY96XNG/X+9rB6+rQN/
wueMRsZ834zcWlhCBHTG79U+Nurba+AC4XPCTWIDcyGq1Yt9qE6Y4gtJZ95X
kj5HrHa8RYlrwsX+PEdc7lxE6wysWOwr4ohLy4Rh15yeLM4rywHHBHIf0mzL
yHwOuFamr6PC4xE0Ez57XJl9EhyiHpB97XG1HofpWnqP7GuH/Au31b9IC0if
Hf6caSxjE3EXNhM+OxxLuE6pnLsNjYSPgdI7fvTXKBeTPgZWpcZeMwotIvsy
sAn6J6pnCiGT8Nmi9LiiojO/gOxriz6UrTmlQVcX9yW0wTuOpkPTO6+QPhts
kdXl9oZdJn02aDtEeVrKyyP3YY1Sr8rfP9S4SPqssVx9+7dozSxyfla4xnGp
TQcvg/RZYbBJTP7kSBo5PyuM06Yf8s47T/os0Tf/vOIplWTSZ4l5k9TLLgGJ
ZD46+t4M0ef8lED66OjuxTh5d9Xv5PwsUC2qmp7tF0v6LPBY4pgBVSyG9Fng
uxURkszW48AnvgNmN8eP0X6JIPdDQ/vdEkHnGkJJnzmySsW/nOk7BGJtb8zk
qeb4cSLApSkxBN566Qri/c1w3CKrIfpTEORuk710LcMU65r3xivP+MP3mA8m
LbUm2DN5pSDziA/MJGpWeE4bY/eofG5djzd4UT/z+ErGmHK03az/1jZQ168O
nrIwwv2GUgd2MdxBx7Rz5a09W3HZS+cI3VQ27JA+c1wvyhAn1VhGLv84Qdou
vc+1qVswTt7V7GAdA0on5MpbL29G8dnKuNhIK7gfkCF2vZCKruahujkI0PZq
QDKtcBNubAgfLc80hvLIqVh+ngFWlXioHbbfDMRzmqCPVeZ07p64jcCyz4nR
qtqAo6oe56eHtEGns54/7qiH9b9eCE9PV4OUma5CYcF6DIz0VkueVoCQzoUH
WwvnlNLqpAZWwf2yBdSxYZ91l/m+ZbC7W4FZxFNFv+jTUaIv5mhJRCBFnDhL
3x8gPk5rsFvRfrRsNZr9JrB+V/icdkkmXGL2sCgWHnFY5yd3hybyP/4DMe0N
5g==
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{-100., 0.}, {0., 1.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[0.015]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{-100., 0.}, {0., 1.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0], 
              PointSize[0.015]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0], 
           PointSize[0.015]], 
          Line[CompressedData["
1:eJxdlHs0lHkYxyVFuWxZs8gK61Y4RVNynce4jeuYGZdRSeUyKOkmpEScldIi
ljChdEpKqzLdKB7XQwaRXEJYl5CyUdJ2W17vX/s553d+f7zn/Zzv93nO+an5
HOD4i4qIiPjPn4V7kW04GCn3F2PwNSQyHrsEBntiZa2qaYn8azi8ryLfbpiL
lUaKVAPuKHTJTtNbeFyUC5a6YZk3Au3DZmE6Mx448klCEDg1DGcTFvDAoFBl
fw3GMMhefVIpr+WBjcc8W2evDkHSYM3e5Y3uaH6pXmqP5BCsGYkXxoa541T0
Cd3hsL+h3WNyY5m2O66+E0tfMjYIfQRu2NY47mPsPQhsNWsVxUw39A3EK9Ld
A+BQL27Od3fD92spCj+4AyDHe/k9neKGw8rB61Xv9QOrNjIlsdMVb3xziq7A
V6A0JjjF5Lui0kNzVbe2Pih8rDwo2O2KFw03nPAc74UtBg5P/tR2xQwfmaWM
Zb3widqiUTPFwYOazRrZmj2gU0LXUnzEwbTAnWyh/UsQyzF8FhTHQT9K0Rz3
UDdgv6XBOSYHnSk3zj7gd0Fm0BeuxxoO3mczwv3rO6Fu3UdO7igbxQVHNvTO
dkC0ZK2+SQkbCzRVVDO0OoBYRwwbvyYbP5bmvoAm4TxObIzJkZUYOd0O2Vnz
KLKx62uEt9ej5xDAm2eUhajML+550wbUBUpYOHWg4M1TlTbSx0IlX6Foqnsr
6WPhV57RSOYfzyCL8LEwvYO6PDmlBYQELhhVQcuSlGoGHoELqgS+8w1PEsIP
AiZOFufZ5is0Lv6fxURWWLGa180G2EQEYGJFduSLUEY96XNG/X+9rB6+rQN/
wueMRsZ834zcWlhCBHTG79U+Nurba+AC4XPCTWIDcyGq1Yt9qE6Y4gtJZ95X
kj5HrHa8RYlrwsX+PEdc7lxE6wysWOwr4ohLy4Rh15yeLM4rywHHBHIf0mzL
yHwOuFamr6PC4xE0Ez57XJl9EhyiHpB97XG1HofpWnqP7GuH/Au31b9IC0if
Hf6caSxjE3EXNhM+OxxLuE6pnLsNjYSPgdI7fvTXKBeTPgZWpcZeMwotIvsy
sAn6J6pnCiGT8Nmi9LiiojO/gOxriz6UrTmlQVcX9yW0wTuOpkPTO6+QPhts
kdXl9oZdJn02aDtEeVrKyyP3YY1Sr8rfP9S4SPqssVx9+7dozSxyfla4xnGp
TQcvg/RZYbBJTP7kSBo5PyuM06Yf8s47T/os0Tf/vOIplWTSZ4l5k9TLLgGJ
ZD46+t4M0ef8lED66OjuxTh5d9Xv5PwsUC2qmp7tF0v6LPBY4pgBVSyG9Fng
uxURkszW48AnvgNmN8eP0X6JIPdDQ/vdEkHnGkJJnzmySsW/nOk7BGJtb8zk
qeb4cSLApSkxBN566Qri/c1w3CKrIfpTEORuk710LcMU65r3xivP+MP3mA8m
LbUm2DN5pSDziA/MJGpWeE4bY/eofG5djzd4UT/z+ErGmHK03az/1jZQ168O
nrIwwv2GUgd2MdxBx7Rz5a09W3HZS+cI3VQ27JA+c1wvyhAn1VhGLv84Qdou
vc+1qVswTt7V7GAdA0on5MpbL29G8dnKuNhIK7gfkCF2vZCKruahujkI0PZq
QDKtcBNubAgfLc80hvLIqVh+ngFWlXioHbbfDMRzmqCPVeZ07p64jcCyz4nR
qtqAo6oe56eHtEGns54/7qiH9b9eCE9PV4OUma5CYcF6DIz0VkueVoCQzoUH
WwvnlNLqpAZWwf2yBdSxYZ91l/m+ZbC7W4FZxFNFv+jTUaIv5mhJRCBFnDhL
3x8gPk5rsFvRfrRsNZr9JrB+V/icdkkmXGL2sCgWHnFY5yd3hybyP/4DMe0N
5g==
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{-100., 0.}, {0., 1.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0], 
            PointSize[0.015]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0], PointSize[0.015], AbsoluteThickness[2], 
          LineBox[CompressedData["
1:eJxVlHs0lHkYx5mjVNIetpJkU8QmtcZIrj0uyRiMMeMy2k53g63TOhVFN9qz
1qVtOyGX2UoXod3a1KRcGo/LiDURKqUiilrp/dkGXVR2vM37x37Pec/vPOc9
v8/v+32ec54Fm34URrC0tLQi1N/E+UXhuOWv3Qcrwwik+1QGRm0TY+CQqvmF
P4EdW6vOcJ+HYdcNq6RyTwIPDN94tEjC0H9ntONSJwJ3n7vGWatCsSX1q2xH
WwJpKRMKxWJJDNyzImBYcLPayDIU9Xb1to/NJ3Ckp+6HyU0hyJ5XOXpuDoG5
fcnKQ3EhGNIo4jUaqHmhg99VWIXglb7xmI16BJ7QCsbER7P1JZMIBC1YNd84
Jxg/zCTYMk4Br0HXTRoSjMEfu5Zlf6BgpqTzc9asYCydytW/NkKBQJFwNL1D
hLLh1G7zfykweSlL4ktFuEvGGu0epKC40rRHtkGEQwEm1/peUrCczbuZaSVC
dr1rEruPgrecFos6IkSHhXfkVT0UWF/1sDQuE6J25Mq2w10U6JxwuBP9kxCz
cofmZz2iALs92Yf5QnwjD5x+7wEFOdFjYaFzhTjvcd0Y9z4F9d+OCE/2B+Hs
0RvC1+0UHNRT2DpfDcJug6xYeSsF9DgSgzDBvqbhRgsFt5Vq+QdhVLnI4OFt
CvJy1TIOwknrJmebKimIlKjVL0A224P1898UcCZ0VYAN3lvH9BsZngD/uPjK
+vothifAkoTFTgfrKcileQKskKc3b1FQoKQViGfT4zMkdRRIaAWiryrc9qda
CsZp8TFFNzOgrEZzP5ePKzuPZOiqazvaAB9995dc2FbN8AJQ3JSz5gVSEEHz
AnDFhVLHeHWtTRsMwI5pwiJLdZ1N8/xx4PyLJcNVmjwcf3RwHPbur2J4fhi7
Z3iPNmryS/xwy4IIHx5q8mr5YfVgDUeBmn7l8tA3Mw3jqhl/PKxsdYzZrPbb
TPN8sX0dT/FbLZPXF/kjLp5aCiYvFwf4adFl9QyPi7brN+2UN1BgT/O42Kp1
Zbt+EwVNNM8HuVwjs7O3GZ4PzuLZ+u+7w+T1wStzpdez1PPPoXmrUdo8Yjl4
n8m7GgMTutbt69TMS+mNXDuVuVcXw/NGHb02Z7dehueNLGPjqMh+Zh6rsDRG
EiMfYHirsNBSPAcI0z8vDGB5WfSrGJ4X2jztC7r8jumfF3aWRIvzPjE8T3xi
conKZxENzxOVNceaUJdo/Hmgg9/bgtHpRMPzwKLwCnswJJr+uWPJMfmybCOi
4bnjs7ynvLF5DM8dlbO13aMWEpDS/wHHL4zXdar3x5f5rMQpHyuOBi5leG4Y
e2nWmlo7Ajptr1yNOG44kCICe0cCr9cukSVHuKJdp/hjgRuBk+GG+eePu+Di
r2Nkpl4EPicOO7conFF27llaPpeAKn1RlfiNE14e/3SGwyewlvNeIjVxwpHM
qWaPRQTMbWu3EXdHjLonWHQqnIC1S8e0ixtX4DP2N/eT1hP4Xj91r81+B1xt
UhmSGkEgY73Ne8Wx5RjDir1VvpVA+cBMeetpe3QRZ/BNdhAojTyuU1TMwcO/
bpxxeQ+Btq6nehnFdljWK0s+cJCAPIEckp5i4++uj37JTCZAr9MUW9xrIbWb
coSAwPdEomXNMjRVeesMZan9dDRI//GzQV/tpQmbThI4qnpQrCxcjI2Fpw3i
Cgls75hY2Ja4GUZ8PErU71dMyBx7zeLzOisIbHg4h/+nxAz1Cg4ki2+p9zNt
yBiLLMJSW9sJNHKn3o2tMMAD70Rma3sI5M/YPWV0BwvXxNc3zBgioPU/DcF/
9OJAUw==
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0], 
              PointSize[0.015]], 
             Line[CompressedData["
1:eJxVlHs0lHkYx5mjVNIetpJkU8QmtcZIrj0uyRiMMeMy2k53g63TOhVFN9qz
1qVtOyGX2UoXod3a1KRcGo/LiDURKqUiilrp/dkGXVR2vM37x37Pec/vPOc9
v8/v+32ec54Fm34URrC0tLQi1N/E+UXhuOWv3Qcrwwik+1QGRm0TY+CQqvmF
P4EdW6vOcJ+HYdcNq6RyTwIPDN94tEjC0H9ntONSJwJ3n7vGWatCsSX1q2xH
WwJpKRMKxWJJDNyzImBYcLPayDIU9Xb1to/NJ3Ckp+6HyU0hyJ5XOXpuDoG5
fcnKQ3EhGNIo4jUaqHmhg99VWIXglb7xmI16BJ7QCsbER7P1JZMIBC1YNd84
Jxg/zCTYMk4Br0HXTRoSjMEfu5Zlf6BgpqTzc9asYCydytW/NkKBQJFwNL1D
hLLh1G7zfykweSlL4ktFuEvGGu0epKC40rRHtkGEQwEm1/peUrCczbuZaSVC
dr1rEruPgrecFos6IkSHhXfkVT0UWF/1sDQuE6J25Mq2w10U6JxwuBP9kxCz
cofmZz2iALs92Yf5QnwjD5x+7wEFOdFjYaFzhTjvcd0Y9z4F9d+OCE/2B+Hs
0RvC1+0UHNRT2DpfDcJug6xYeSsF9DgSgzDBvqbhRgsFt5Vq+QdhVLnI4OFt
CvJy1TIOwknrJmebKimIlKjVL0A224P1898UcCZ0VYAN3lvH9BsZngD/uPjK
+vothifAkoTFTgfrKcileQKskKc3b1FQoKQViGfT4zMkdRRIaAWiryrc9qda
CsZp8TFFNzOgrEZzP5ePKzuPZOiqazvaAB9995dc2FbN8AJQ3JSz5gVSEEHz
AnDFhVLHeHWtTRsMwI5pwiJLdZ1N8/xx4PyLJcNVmjwcf3RwHPbur2J4fhi7
Z3iPNmryS/xwy4IIHx5q8mr5YfVgDUeBmn7l8tA3Mw3jqhl/PKxsdYzZrPbb
TPN8sX0dT/FbLZPXF/kjLp5aCiYvFwf4adFl9QyPi7brN+2UN1BgT/O42Kp1
Zbt+EwVNNM8HuVwjs7O3GZ4PzuLZ+u+7w+T1wStzpdez1PPPoXmrUdo8Yjl4
n8m7GgMTutbt69TMS+mNXDuVuVcXw/NGHb02Z7dehueNLGPjqMh+Zh6rsDRG
EiMfYHirsNBSPAcI0z8vDGB5WfSrGJ4X2jztC7r8jumfF3aWRIvzPjE8T3xi
conKZxENzxOVNceaUJdo/Hmgg9/bgtHpRMPzwKLwCnswJJr+uWPJMfmybCOi
4bnjs7ynvLF5DM8dlbO13aMWEpDS/wHHL4zXdar3x5f5rMQpHyuOBi5leG4Y
e2nWmlo7Ajptr1yNOG44kCICe0cCr9cukSVHuKJdp/hjgRuBk+GG+eePu+Di
r2Nkpl4EPicOO7conFF27llaPpeAKn1RlfiNE14e/3SGwyewlvNeIjVxwpHM
qWaPRQTMbWu3EXdHjLonWHQqnIC1S8e0ixtX4DP2N/eT1hP4Xj91r81+B1xt
UhmSGkEgY73Ne8Wx5RjDir1VvpVA+cBMeetpe3QRZ/BNdhAojTyuU1TMwcO/
bpxxeQ+Btq6nehnFdljWK0s+cJCAPIEckp5i4++uj37JTCZAr9MUW9xrIbWb
coSAwPdEomXNMjRVeesMZan9dDRI//GzQV/tpQmbThI4qnpQrCxcjI2Fpw3i
Cgls75hY2Ja4GUZ8PErU71dMyBx7zeLzOisIbHg4h/+nxAz1Cg4ki2+p9zNt
yBiLLMJSW9sJNHKn3o2tMMAD70Rma3sI5M/YPWV0BwvXxNc3zBgioPU/DcF/
9OJAUw==
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{-100., 0.}, {0., 1.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               RGBColor[0, 0, 0], 
               PointSize[0.015]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{-100., 0.}, {0., 1.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0], 
              PointSize[0.015]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0], 
           PointSize[0.015]], 
          Line[CompressedData["
1:eJxVlHs0lHkYx5mjVNIetpJkU8QmtcZIrj0uyRiMMeMy2k53g63TOhVFN9qz
1qVtOyGX2UoXod3a1KRcGo/LiDURKqUiilrp/dkGXVR2vM37x37Pec/vPOc9
v8/v+32ec54Fm34URrC0tLQi1N/E+UXhuOWv3Qcrwwik+1QGRm0TY+CQqvmF
P4EdW6vOcJ+HYdcNq6RyTwIPDN94tEjC0H9ntONSJwJ3n7vGWatCsSX1q2xH
WwJpKRMKxWJJDNyzImBYcLPayDIU9Xb1to/NJ3Ckp+6HyU0hyJ5XOXpuDoG5
fcnKQ3EhGNIo4jUaqHmhg99VWIXglb7xmI16BJ7QCsbER7P1JZMIBC1YNd84
Jxg/zCTYMk4Br0HXTRoSjMEfu5Zlf6BgpqTzc9asYCydytW/NkKBQJFwNL1D
hLLh1G7zfykweSlL4ktFuEvGGu0epKC40rRHtkGEQwEm1/peUrCczbuZaSVC
dr1rEruPgrecFos6IkSHhXfkVT0UWF/1sDQuE6J25Mq2w10U6JxwuBP9kxCz
cofmZz2iALs92Yf5QnwjD5x+7wEFOdFjYaFzhTjvcd0Y9z4F9d+OCE/2B+Hs
0RvC1+0UHNRT2DpfDcJug6xYeSsF9DgSgzDBvqbhRgsFt5Vq+QdhVLnI4OFt
CvJy1TIOwknrJmebKimIlKjVL0A224P1898UcCZ0VYAN3lvH9BsZngD/uPjK
+vothifAkoTFTgfrKcileQKskKc3b1FQoKQViGfT4zMkdRRIaAWiryrc9qda
CsZp8TFFNzOgrEZzP5ePKzuPZOiqazvaAB9995dc2FbN8AJQ3JSz5gVSEEHz
AnDFhVLHeHWtTRsMwI5pwiJLdZ1N8/xx4PyLJcNVmjwcf3RwHPbur2J4fhi7
Z3iPNmryS/xwy4IIHx5q8mr5YfVgDUeBmn7l8tA3Mw3jqhl/PKxsdYzZrPbb
TPN8sX0dT/FbLZPXF/kjLp5aCiYvFwf4adFl9QyPi7brN+2UN1BgT/O42Kp1
Zbt+EwVNNM8HuVwjs7O3GZ4PzuLZ+u+7w+T1wStzpdez1PPPoXmrUdo8Yjl4
n8m7GgMTutbt69TMS+mNXDuVuVcXw/NGHb02Z7dehueNLGPjqMh+Zh6rsDRG
EiMfYHirsNBSPAcI0z8vDGB5WfSrGJ4X2jztC7r8jumfF3aWRIvzPjE8T3xi
conKZxENzxOVNceaUJdo/Hmgg9/bgtHpRMPzwKLwCnswJJr+uWPJMfmybCOi
4bnjs7ynvLF5DM8dlbO13aMWEpDS/wHHL4zXdar3x5f5rMQpHyuOBi5leG4Y
e2nWmlo7Ajptr1yNOG44kCICe0cCr9cukSVHuKJdp/hjgRuBk+GG+eePu+Di
r2Nkpl4EPicOO7conFF27llaPpeAKn1RlfiNE14e/3SGwyewlvNeIjVxwpHM
qWaPRQTMbWu3EXdHjLonWHQqnIC1S8e0ixtX4DP2N/eT1hP4Xj91r81+B1xt
UhmSGkEgY73Ne8Wx5RjDir1VvpVA+cBMeetpe3QRZ/BNdhAojTyuU1TMwcO/
bpxxeQ+Btq6nehnFdljWK0s+cJCAPIEckp5i4++uj37JTCZAr9MUW9xrIbWb
coSAwPdEomXNMjRVeesMZan9dDRI//GzQV/tpQmbThI4qnpQrCxcjI2Fpw3i
Cgls75hY2Ja4GUZ8PErU71dMyBx7zeLzOisIbHg4h/+nxAz1Cg4ki2+p9zNt
yBiLLMJSW9sJNHKn3o2tMMAD70Rma3sI5M/YPWV0BwvXxNc3zBgioPU/DcF/
9OJAUw==
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{-100., 0.}, {0., 1.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            RGBColor[0, 0, 0], 
            PointSize[0.015]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0], PointSize[0.009166666666666668], 
          AbsoluteThickness[2], Dashing[{0.01, 0.01}], LineBox[CompressedData["
1:eJw10g8slHEYwHHEVv6F2SSz/oitnMJR/j93zp1TqGlZxoi4hNjsjCidmqak
ku2QcFGJKDbacu16qhFL5LROjWhIKZ6LZrOG7t72frff3r377f38nnfvuyMp
KyrFyMDAwFO39NeIEktFsp8YDZi04MXVJ0ZHTvoEf43g7YC+UHRz7Y7lzxJI
mEJRdmvCzUhNYMg8F4onjS1cclUEVdX6RLjTSWpb0UrAcFwRmpeL+sV3CN4x
nhCztF22pWWsJ8TbU0u94TLWE+KYuWe7TErAcNUheMGyQWGfxnohqLmak2qa
SMBwAwKccnbtFsawngBnWzi1yiiC/+8lwFTzoTMxEawXjJVBnWnmYawXjJ3e
heqXQnY+PmpnBqckAtbjY7FAPP6dT7DOxMOW4GurXnzW42GVJuCSD5/1eFi8
/Ld1Undfw+wDPqpIf7ZV5w0yfhAGNbrNjoSwXiDm2U9LV0QExuqfAXbcQByN
Hy0v0M03H+faeTklAA3bfu+LDieoi7FRPJD742iHyqPkMMGa7I/fUI8fHnQY
PGt1lGCp1PnF8UVf5FU+npuPJojjrkhqHHyxYWRBsi2WwMn9dQbxfDC20HG4
MYFgj7/GtC3xAEYJ+83ykwliLa4UcM7vx+yPshXFaYKKBM5Kzy1vvDehPmeX
RdA9Z6savuuF7y0j88Z03+fpKbnxw2YuTlsXDS7kE6i/TJpVNHvirxGTzxFF
BKp8ulhT74HjqjzVhhKCEiZ3zFfmpTrfIDgSVitzebUXO+hJQJ9cN4+mr+bH
IQ5Ki/rqDesJbi6NNg807cYuecbytyaCTI3NIn/IBZOOie6XdejOV+pzwsyp
dSuz5wQnPm2JbJVsx16JoE76huA6M5A9xpsoOyZGCPrFmz7kKK1x14xVe+JX
AoVl7sblbCM05dDqZi37v7Bp4R+Vk5P5
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0], 
              Dashing[{0.01, 0.01}]], 
             Line[CompressedData["
1:eJw10g8slHEYwHHEVv6F2SSz/oitnMJR/j93zp1TqGlZxoi4hNjsjCidmqak
ku2QcFGJKDbacu16qhFL5LROjWhIKZ6LZrOG7t72frff3r377f38nnfvuyMp
KyrFyMDAwFO39NeIEktFsp8YDZi04MXVJ0ZHTvoEf43g7YC+UHRz7Y7lzxJI
mEJRdmvCzUhNYMg8F4onjS1cclUEVdX6RLjTSWpb0UrAcFwRmpeL+sV3CN4x
nhCztF22pWWsJ8TbU0u94TLWE+KYuWe7TErAcNUheMGyQWGfxnohqLmak2qa
SMBwAwKccnbtFsawngBnWzi1yiiC/+8lwFTzoTMxEawXjJVBnWnmYawXjJ3e
heqXQnY+PmpnBqckAtbjY7FAPP6dT7DOxMOW4GurXnzW42GVJuCSD5/1eFi8
/Ld1Undfw+wDPqpIf7ZV5w0yfhAGNbrNjoSwXiDm2U9LV0QExuqfAXbcQByN
Hy0v0M03H+faeTklAA3bfu+LDieoi7FRPJD742iHyqPkMMGa7I/fUI8fHnQY
PGt1lGCp1PnF8UVf5FU+npuPJojjrkhqHHyxYWRBsi2WwMn9dQbxfDC20HG4
MYFgj7/GtC3xAEYJ+83ykwliLa4UcM7vx+yPshXFaYKKBM5Kzy1vvDehPmeX
RdA9Z6savuuF7y0j88Z03+fpKbnxw2YuTlsXDS7kE6i/TJpVNHvirxGTzxFF
BKp8ulhT74HjqjzVhhKCEiZ3zFfmpTrfIDgSVitzebUXO+hJQJ9cN4+mr+bH
IQ5Ki/rqDesJbi6NNg807cYuecbytyaCTI3NIn/IBZOOie6XdejOV+pzwsyp
dSuz5wQnPm2JbJVsx16JoE76huA6M5A9xpsoOyZGCPrFmz7kKK1x14xVe+JX
AoVl7sblbCM05dDqZi37v7Bp4R+Vk5P5
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{-50., 0.}, {0., 1.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.009166666666666668], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 0], 
               Dashing[{0.01, 0.01}]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{-50., 0.}, {0., 1.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0], 
              Dashing[{0.01, 0.01}]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.009166666666666668], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0], 
           Dashing[{0.01, 0.01}]], 
          Line[CompressedData["
1:eJw10g8slHEYwHHEVv6F2SSz/oitnMJR/j93zp1TqGlZxoi4hNjsjCidmqak
ku2QcFGJKDbacu16qhFL5LROjWhIKZ6LZrOG7t72frff3r377f38nnfvuyMp
KyrFyMDAwFO39NeIEktFsp8YDZi04MXVJ0ZHTvoEf43g7YC+UHRz7Y7lzxJI
mEJRdmvCzUhNYMg8F4onjS1cclUEVdX6RLjTSWpb0UrAcFwRmpeL+sV3CN4x
nhCztF22pWWsJ8TbU0u94TLWE+KYuWe7TErAcNUheMGyQWGfxnohqLmak2qa
SMBwAwKccnbtFsawngBnWzi1yiiC/+8lwFTzoTMxEawXjJVBnWnmYawXjJ3e
heqXQnY+PmpnBqckAtbjY7FAPP6dT7DOxMOW4GurXnzW42GVJuCSD5/1eFi8
/Ld1Undfw+wDPqpIf7ZV5w0yfhAGNbrNjoSwXiDm2U9LV0QExuqfAXbcQByN
Hy0v0M03H+faeTklAA3bfu+LDieoi7FRPJD742iHyqPkMMGa7I/fUI8fHnQY
PGt1lGCp1PnF8UVf5FU+npuPJojjrkhqHHyxYWRBsi2WwMn9dQbxfDC20HG4
MYFgj7/GtC3xAEYJ+83ykwliLa4UcM7vx+yPshXFaYKKBM5Kzy1vvDehPmeX
RdA9Z6savuuF7y0j88Z03+fpKbnxw2YuTlsXDS7kE6i/TJpVNHvirxGTzxFF
BKp8ulhT74HjqjzVhhKCEiZ3zFfmpTrfIDgSVitzebUXO+hJQJ9cN4+mr+bH
IQ5Ki/rqDesJbi6NNg807cYuecbytyaCTI3NIn/IBZOOie6XdejOV+pzwsyp
dSuz5wQnPm2JbJVsx16JoE76huA6M5A9xpsoOyZGCPrFmz7kKK1x14xVe+JX
AoVl7sblbCM05dDqZi37v7Bp4R+Vk5P5
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{-50., 0.}, {0., 1.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.009166666666666668], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 0], 
            Dashing[{0.01, 0.01}]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-80, 0}, {-80, 0.03}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-60, 0}, {-60, 0.03}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-40, 0}, {-40, 0.03}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-20, 0}, {-20, 0.03}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-90, 0}, {-90, 0.015}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-70, 0}, {-70, 0.015}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-50, 0}, {-50, 0.015}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-30, 0}, {-30, 0.015}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-10, 0}, {-10, 0.015}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-80, 1.}, {-80, 0.97}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-60, 1.}, {-60, 0.97}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-40, 1.}, {-40, 0.97}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-20, 1.}, {-20, 0.97}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-90, 1.}, {-90, 0.985}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-70, 1.}, {-70, 0.985}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-50, 1.}, {-50, 0.985}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-30, 1.}, {-30, 0.985}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-10, 1.}, {-10, 0.985}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-100, 0.2}, {-97., 0.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-100, 0.4}, {-97., 0.4}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-100, 0.6}, {-97., 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-100, 0.8}, {-97., 0.8}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-100, 0.1}, {-98.5, 0.1}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-100, 0.3}, {-98.5, 0.3}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-100, 0.5}, {-98.5, 0.5}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-100, 0.7}, {-98.5, 0.7}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{-100, 0.9}, {-98.5, 0.9}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0.2}, {-3., 0.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0.4}, {-3., 0.4}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0.6}, {-3., 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0.8}, {-3., 0.8}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0.1}, {-1.5, 0.1}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0.3}, {-1.5, 0.3}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0.5}, {-1.5, 0.5}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0.7}, {-1.5, 0.7}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0.9}, {-1.5, 0.9}}]}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[1, 0, 1], AbsoluteThickness[2], Opacity[1.], 
          Dashing[{0.01, 0.01}], LineBox[CompressedData["
1:eJwV0Xs0lHkYB3DUWEVyVLu0a9dlVHaVW9Zo5Ilyv6QxGKYihbIqpxyXLbQz
s9oS1ZslTbXrlmrbVlEbZd5nKrrYqISSdShdxLw/UshlZt/94znf8znfc77/
PBaxOwVxOlpaWkHs/Z8Xq5LHNBoRVjwTO/ikqSB5zrKMWWoRPlnBM0ll7ZA4
MGE8JcKgwXOactY1VvFq63ER8gOCHuqkq6CuUMwJHBLhQp+CdAXrhr3e8473
iNC80vqV848q6PL9ys5eKcL5+duWWWeqQL/3TnyMRISRMcYSjlQFVr8l0XYT
EdhumubfdJjtKyelnD0RaCnnb74pV4Fx3aruSHU46h/qe5hTqYK2qFYLs7Rw
tL83bRNWo4KtXiGPXo+H4VB5aq0AVXC1fmHiN8lhSKJdXNc/YPc95Mfb+4V4
9IZw2qlTBZsMdZ0KkoS4cnbCXd5rFURtU1zFvlC0ylz8eeCICriGm86MxIVi
w5AwJFejAgNF7XcV/QIssR0sLtRnoGoy+kRDrACPPZcMXzZhgCsdShnsW4f9
Pc8/+8RlQHi8mSdZvw4TXDPXCBwZKL0WSxW2h+AZy9AD6cCA0rI34lJkCI62
Dfo2BjDg4hw1J7V8LY6GcjttIhnIu9boWVgZjO13XJXVcQxERTT7F/wahG+q
laVhuxmIM/DMOvxLIEplzn239jFgFHbwQFFeABqLXi4Kz2PAsXZ7QmamP7qa
V3BnyBn4WGVtlpzth9z5saOPKxkYVfipo3N8UVN34UFSDQM73updXprugzMv
bjDl3mQgp+LkSr293vj0n3evJpsZWJDVJMdEL+wq0o8b6WLgRVK8derGNbj5
utvHK+8YCCFtObwtq3F4lbW8cIwB57yeuqdCTxzgnW0p5hCoU9CNP0d4oLIk
uLfWmECmrr7aLnoVelBqqvQbAttbX8xNLnPHgn13K6uWErBQilqLL7ihYIue
/bMVBG69mumWnbsC09qnd9r4Eah0iBJm5fOwqL6/lwonoHt+/600+feo/cxp
+e3NBEIjBzpss5Yjr6PIxnwXgV67cfmkzBHNbd3bqGwCG1byOTmb7DHeOzHX
MZ/AeebCwQVHbLG5+L2H/CQBs0vOiYKKJVjmvsTU5DyBpN5vC3TjuXj7zAf9
hmsE3GN2mTE7zLGobP8jWSMBg+QnZwu+MMXZoQ8mZz8hIJw8+Qf/rBGmSD75
335BYLXP/E6K0sbY8eyneUMEWk6NUL6B2ri6QyFtYi3+8DhAzdHG+88H7GYN
E9hdcrR+W4YWin8wypWx9hoz8/wJ1fR2vixwz3sCM2PmPewST9B+EV9Obf1A
QOqgHjhGDdMvvZYaeo0TkHff2KDhDNMHgvgdEtbVuXtaEjOG6MLFvBJk3dA0
HCdFhs7dqnZx+0RAtvzNSLf4Hb3xSn2y0wSBGbqP5xZSvfQiF4O5llMEnGLW
jiRl9NDXmVlvolk3pBT/uR+7aVHLKH2KtezffP5LcScttDidYjpNQOevjIgT
1CPa4nerfiM1+7/Gt25HsJn+20V+N5i1xK77/oD4Pl1tpXPuEGtt7XuvSykl
TRmeTtLTENjXurd/SlxHB5u0rvVmrSlP4NRQl2jrQ2NOMtYTg+We7VQJLd2p
b3qTteXh6bLTXysV7XcMNRrW/wEM/ZXg
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[1, 0, 1]], 
             Line[CompressedData["
1:eJwV0Xs0lHkYB3DUWEVyVLu0a9dlVHaVW9Zo5Ilyv6QxGKYihbIqpxyXLbQz
s9oS1ZslTbXrlmrbVlEbZd5nKrrYqISSdShdxLw/UshlZt/94znf8znfc77/
PBaxOwVxOlpaWkHs/Z8Xq5LHNBoRVjwTO/ikqSB5zrKMWWoRPlnBM0ll7ZA4
MGE8JcKgwXOactY1VvFq63ER8gOCHuqkq6CuUMwJHBLhQp+CdAXrhr3e8473
iNC80vqV848q6PL9ys5eKcL5+duWWWeqQL/3TnyMRISRMcYSjlQFVr8l0XYT
EdhumubfdJjtKyelnD0RaCnnb74pV4Fx3aruSHU46h/qe5hTqYK2qFYLs7Rw
tL83bRNWo4KtXiGPXo+H4VB5aq0AVXC1fmHiN8lhSKJdXNc/YPc95Mfb+4V4
9IZw2qlTBZsMdZ0KkoS4cnbCXd5rFURtU1zFvlC0ylz8eeCICriGm86MxIVi
w5AwJFejAgNF7XcV/QIssR0sLtRnoGoy+kRDrACPPZcMXzZhgCsdShnsW4f9
Pc8/+8RlQHi8mSdZvw4TXDPXCBwZKL0WSxW2h+AZy9AD6cCA0rI34lJkCI62
Dfo2BjDg4hw1J7V8LY6GcjttIhnIu9boWVgZjO13XJXVcQxERTT7F/wahG+q
laVhuxmIM/DMOvxLIEplzn239jFgFHbwQFFeABqLXi4Kz2PAsXZ7QmamP7qa
V3BnyBn4WGVtlpzth9z5saOPKxkYVfipo3N8UVN34UFSDQM73updXprugzMv
bjDl3mQgp+LkSr293vj0n3evJpsZWJDVJMdEL+wq0o8b6WLgRVK8derGNbj5
utvHK+8YCCFtObwtq3F4lbW8cIwB57yeuqdCTxzgnW0p5hCoU9CNP0d4oLIk
uLfWmECmrr7aLnoVelBqqvQbAttbX8xNLnPHgn13K6uWErBQilqLL7ihYIue
/bMVBG69mumWnbsC09qnd9r4Eah0iBJm5fOwqL6/lwonoHt+/600+feo/cxp
+e3NBEIjBzpss5Yjr6PIxnwXgV67cfmkzBHNbd3bqGwCG1byOTmb7DHeOzHX
MZ/AeebCwQVHbLG5+L2H/CQBs0vOiYKKJVjmvsTU5DyBpN5vC3TjuXj7zAf9
hmsE3GN2mTE7zLGobP8jWSMBg+QnZwu+MMXZoQ8mZz8hIJw8+Qf/rBGmSD75
335BYLXP/E6K0sbY8eyneUMEWk6NUL6B2ri6QyFtYi3+8DhAzdHG+88H7GYN
E9hdcrR+W4YWin8wypWx9hoz8/wJ1fR2vixwz3sCM2PmPewST9B+EV9Obf1A
QOqgHjhGDdMvvZYaeo0TkHff2KDhDNMHgvgdEtbVuXtaEjOG6MLFvBJk3dA0
HCdFhs7dqnZx+0RAtvzNSLf4Hb3xSn2y0wSBGbqP5xZSvfQiF4O5llMEnGLW
jiRl9NDXmVlvolk3pBT/uR+7aVHLKH2KtezffP5LcScttDidYjpNQOevjIgT
1CPa4nerfiM1+7/Gt25HsJn+20V+N5i1xK77/oD4Pl1tpXPuEGtt7XuvSykl
TRmeTtLTENjXurd/SlxHB5u0rvVmrSlP4NRQl2jrQ2NOMtYTg+We7VQJLd2p
b3qTteXh6bLTXysV7XcMNRrW/wEM/ZXg
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{-100, 0}, {0.9208103145636427, 
             0.9999999982448979}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0.9208103145636447}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[1, 0, 1]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{-100, 0}, {0.9208103145636427, 0.9999999982448979}},
           "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {0, 0.9208103145636447}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             Dashing[{0.01, 0.01}], 
             RGBColor[1, 0, 1]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[1, 0, 1]], 
          Line[CompressedData["
1:eJwV0Xs0lHkYB3DUWEVyVLu0a9dlVHaVW9Zo5Ilyv6QxGKYihbIqpxyXLbQz
s9oS1ZslTbXrlmrbVlEbZd5nKrrYqISSdShdxLw/UshlZt/94znf8znfc77/
PBaxOwVxOlpaWkHs/Z8Xq5LHNBoRVjwTO/ikqSB5zrKMWWoRPlnBM0ll7ZA4
MGE8JcKgwXOactY1VvFq63ER8gOCHuqkq6CuUMwJHBLhQp+CdAXrhr3e8473
iNC80vqV848q6PL9ys5eKcL5+duWWWeqQL/3TnyMRISRMcYSjlQFVr8l0XYT
EdhumubfdJjtKyelnD0RaCnnb74pV4Fx3aruSHU46h/qe5hTqYK2qFYLs7Rw
tL83bRNWo4KtXiGPXo+H4VB5aq0AVXC1fmHiN8lhSKJdXNc/YPc95Mfb+4V4
9IZw2qlTBZsMdZ0KkoS4cnbCXd5rFURtU1zFvlC0ylz8eeCICriGm86MxIVi
w5AwJFejAgNF7XcV/QIssR0sLtRnoGoy+kRDrACPPZcMXzZhgCsdShnsW4f9
Pc8/+8RlQHi8mSdZvw4TXDPXCBwZKL0WSxW2h+AZy9AD6cCA0rI34lJkCI62
Dfo2BjDg4hw1J7V8LY6GcjttIhnIu9boWVgZjO13XJXVcQxERTT7F/wahG+q
laVhuxmIM/DMOvxLIEplzn239jFgFHbwQFFeABqLXi4Kz2PAsXZ7QmamP7qa
V3BnyBn4WGVtlpzth9z5saOPKxkYVfipo3N8UVN34UFSDQM73updXprugzMv
bjDl3mQgp+LkSr293vj0n3evJpsZWJDVJMdEL+wq0o8b6WLgRVK8derGNbj5
utvHK+8YCCFtObwtq3F4lbW8cIwB57yeuqdCTxzgnW0p5hCoU9CNP0d4oLIk
uLfWmECmrr7aLnoVelBqqvQbAttbX8xNLnPHgn13K6uWErBQilqLL7ihYIue
/bMVBG69mumWnbsC09qnd9r4Eah0iBJm5fOwqL6/lwonoHt+/600+feo/cxp
+e3NBEIjBzpss5Yjr6PIxnwXgV67cfmkzBHNbd3bqGwCG1byOTmb7DHeOzHX
MZ/AeebCwQVHbLG5+L2H/CQBs0vOiYKKJVjmvsTU5DyBpN5vC3TjuXj7zAf9
hmsE3GN2mTE7zLGobP8jWSMBg+QnZwu+MMXZoQ8mZz8hIJw8+Qf/rBGmSD75
335BYLXP/E6K0sbY8eyneUMEWk6NUL6B2ri6QyFtYi3+8DhAzdHG+88H7GYN
E9hdcrR+W4YWin8wypWx9hoz8/wJ1fR2vixwz3sCM2PmPewST9B+EV9Obf1A
QOqgHjhGDdMvvZYaeo0TkHff2KDhDNMHgvgdEtbVuXtaEjOG6MLFvBJk3dA0
HCdFhs7dqnZx+0RAtvzNSLf4Hb3xSn2y0wSBGbqP5xZSvfQiF4O5llMEnGLW
jiRl9NDXmVlvolk3pBT/uR+7aVHLKH2KtezffP5LcScttDidYjpNQOevjIgT
1CPa4nerfiM1+7/Gt25HsJn+20V+N5i1xK77/oD4Pl1tpXPuEGtt7XuvSykl
TRmeTtLTENjXurd/SlxHB5u0rvVmrSlP4NRQl2jrQ2NOMtYTg+We7VQJLd2p
b3qTteXh6bLTXysV7XcMNRrW/wEM/ZXg
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{-100, 0}, {0.9208103145636427, 0.9999999982448979}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {0, 0.9208103145636447}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[1, 0, 1]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]]},
  AspectRatio->0.8]], "Output",
 CellChangeTimes->{{3.936873541864053*^9, 3.9368735631826816`*^9}, {
   3.936874515960154*^9, 3.9368745458012495`*^9}, {3.936874616431029*^9, 
   3.936874624489343*^9}, 3.936874665890587*^9, 3.9368748156054916`*^9, {
   3.9368752017627544`*^9, 3.936875215964923*^9}, {3.9368754185262594`*^9, 
   3.9368754433072987`*^9}, 3.9368755626199646`*^9, {3.9368756886977973`*^9, 
   3.936875727641664*^9}, 3.936875947079463*^9, 3.936876585232585*^9, 
   3.9368766885838976`*^9, 3.936876739562291*^9, {3.9368768133945274`*^9, 
   3.936876837003749*^9}, {3.936951264189931*^9, 3.9369512762862234`*^9}, 
   3.970587060168565*^9, 3.970587143393379*^9, 3.9705871912423105`*^9, 
   3.970587229380951*^9, 3.970587274452775*^9, 3.970587659644543*^9, 
   3.970587755184338*^9, 3.9705878512530327`*^9, 3.9705879340533853`*^9, 
   3.970587975794798*^9, 3.9705880484331646`*^9, 3.970588177436672*^9, {
   3.97058821410676*^9, 3.970588223844407*^9}},
 CellLabel->
  "Out[215]=",ExpressionUUID->"998d810e-104f-4f91-ab4a-4993843c96cf"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1141.2, 568.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.1 Inherited,
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"598492a6-12d0-4e85-9a79-8eff48d5f532"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 157, 3, 74, "Section",ExpressionUUID->"71b6afb8-8a33-45e8-b3f1-6c2081f1a687"],
Cell[CellGroupData[{
Cell[762, 29, 743, 18, 87, "Subsection",ExpressionUUID->"8ee6112c-a5a8-4efd-ac8d-a46604f4c957"],
Cell[1508, 49, 4815, 87, 73, "Input",ExpressionUUID->"d1f074df-c15f-42c2-85ab-7a6feade6b39"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6360, 141, 853, 20, 88, "Subsection",ExpressionUUID->"21b6261d-f2e0-4753-ba28-2c50481c0429"],
Cell[7216, 163, 18535, 509, 924, "Input",ExpressionUUID->"c903ae01-38d1-413d-98d5-0d14b8aaf851"],
Cell[CellGroupData[{
Cell[25776, 676, 219, 5, 31, "Input",ExpressionUUID->"dbb99c42-fdf8-40c1-8564-27ce85d3c563"],
Cell[25998, 683, 56552, 1095, 335, "Output",ExpressionUUID->"998d810e-104f-4f91-ab4a-4993843c96cf"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

