(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    146970,       3291]
NotebookOptionsPosition[    145104,       3252]
NotebookOutlinePosition[    145577,       3270]
CellTagsIndexPosition[    145534,       3267]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Figure S12", "Section",
 CellChangeTimes->{{3.970820320513788*^9, 3.9708203239733734`*^9}, {
  3.9708205567910824`*^9, 
  3.970820578582902*^9}},ExpressionUUID->"95ca8d0f-f0c2-43f2-9b55-\
24a9fbb6c8e5"],

Cell[TextData[{
 "Data format: {voltage (V), current density ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["A",
      FontSlant->"Plain"], 
     StyleBox["/",
      FontSlant->"Italic"], 
     SuperscriptBox[
      StyleBox["m",
       FontSlant->"Plain"], "2"]}], ")"}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "d7c4fcae-ec88-4aae-ac40-9d501b7b6766"],
 "} "
}], "Subsection",
 CellChangeTimes->{{3.970820588886569*^9, 
  3.9708206465508766`*^9}},ExpressionUUID->"fa51468f-589b-4d15-8aef-\
61663bebbb66"],

Cell[CellGroupData[{

Cell["Fig. S12(a) J(V) curves 200 nm alpha-MADN devices", "Subsection",
 CellChangeTimes->{{3.9261369988842583`*^9, 3.926137024902232*^9}, {
  3.926138203569962*^9, 3.9261382237554054`*^9}, {3.934538194146787*^9, 
  3.9345382211831217`*^9}, {3.9347261560231304`*^9, 3.9347261602694116`*^9}, {
  3.97082035545655*^9, 3.9708203759066763`*^9}, {3.9708206532591915`*^9, 
  3.9708206682579875`*^9}, {3.970821032626897*^9, 3.970821034566263*^9}, {
  3.9708216686778336`*^9, 
  3.9708216901161146`*^9}},ExpressionUUID->"30abeb6d-17a7-46b2-bb7d-\
22f0d417268e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Experimental", " ", "J", 
     RowBox[{"(", "V", ")"}], " ", "curve"}], ",", " ", 
    RowBox[{"296", " ", "K"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tabJValpha296", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.99", ",", "6.49"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.94", ",", "61.48"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.78", ",", "250"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.38", ",", "691"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.75", ",", "1385"}], " ", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.94", ",", "2293"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"10.84", ",", "3513"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.57", ",", "6032"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.91", ",", "8984"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15.25", ",", "11942"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16.17", ",", "15364"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Experimental", " ", "J", 
      RowBox[{"(", "V", ")"}], " ", "curve"}], ",", " ", 
     RowBox[{"296", " ", "K"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabJValpha210", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", " ", "2.02"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.99", ",", "11.62"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.96", ",", " ", "44.71"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.88", ",", " ", "135.56"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.7", ",", " ", "336.47"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15.35", ",", "718.31"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16.81", ",", "1324.4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18.04", ",", "2178.96"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19.16", ",", "3158.52"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20.17", ",", "4251.67"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"21.06", ",", " ", "5491.22"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"J", 
      RowBox[{"(", "V", ")"}], " ", "curve", " ", "from", " ", "KMC", " ", 
      "simulations"}], ",", " ", 
     RowBox[{"296", " ", "K"}], ",", " ", 
     RowBox[{"200", " ", "nm"}], ",", " ", 
     RowBox[{"sigma_holes", " ", "=", " ", 
      RowBox[{"0.10", " ", "eV"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fac", "=", "1.2"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"prefactor", " ", "f"}], ",", " ", 
     RowBox[{"See", " ", 
      RowBox[{"Eq", ".", " ", "S1"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabJV296alphaMADNKMC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"fac", "*", "35"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"fac", "*", "85"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", 
         RowBox[{"fac", "*", "160"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", 
         RowBox[{"fac", "*", "275"}]}], "}"}], "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{"fac", "*", "419"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", 
         RowBox[{"fac", "*", "633"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", 
         RowBox[{"fac", "*", "904"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", 
         RowBox[{"fac", "*", "1700"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", 
         RowBox[{"fac", "*", "7000"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", 
         RowBox[{"fac", "*", "22500"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"J", 
      RowBox[{"(", "V", ")"}], " ", "curve", " ", "from", " ", "KMC", " ", 
      "simulations"}], ",", " ", 
     RowBox[{"210", " ", "K"}], ",", " ", 
     RowBox[{"200", " ", "nm"}], ",", " ", 
     RowBox[{"sigma_holes", " ", "=", " ", 
      RowBox[{"0.10", " ", "eV"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabJV210alphaMADNKMC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{"fac", "*", "13.8"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", 
         RowBox[{"fac", "*", "21.8"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", 
         RowBox[{"fac", "*", "38.0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", 
         RowBox[{"fac", "*", "123"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", 
         RowBox[{"fac", "*", "820"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", 
         RowBox[{"fac", "*", "4900"}]}], "}"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.9243551424699364`*^9, 3.9243552276569977`*^9}, {
   3.9243553136465287`*^9, 3.9243554441415224`*^9}, {3.92436445389097*^9, 
   3.9243644792479243`*^9}, {3.92436464573499*^9, 3.9243647790118265`*^9}, {
   3.924421454817116*^9, 3.9244214553177156`*^9}, {3.9244229006044827`*^9, 
   3.924423047385573*^9}, {3.924423100428915*^9, 3.9244235337443156`*^9}, {
   3.9244237145771303`*^9, 3.924423869663394*^9}, {3.924423903919711*^9, 
   3.9244239094171085`*^9}, {3.9244239440290375`*^9, 3.9244239447083807`*^9}, 
   3.9244241691653175`*^9, {3.9244246852098083`*^9, 3.9244247244427776`*^9}, {
   3.9244247559142284`*^9, 3.9244247629041944`*^9}, {3.9244249100052767`*^9, 
   3.924424958673731*^9}, 3.924449546201064*^9, {3.924449632936967*^9, 
   3.9244496768816614`*^9}, {3.924449734561226*^9, 3.9244497424415736`*^9}, {
   3.9244498375793877`*^9, 3.924449881838441*^9}, {3.9244499125024586`*^9, 
   3.9244499513955297`*^9}, {3.924450007642341*^9, 3.9244500490748796`*^9}, {
   3.9256265809266305`*^9, 3.925626813066043*^9}, {3.9256268515358257`*^9, 
   3.9256269749740906`*^9}, {3.9256272584527903`*^9, 3.925627258622172*^9}, {
   3.925627387501932*^9, 3.925627392246022*^9}, {3.925627572737281*^9, 
   3.9256276216660395`*^9}, {3.925627669483142*^9, 3.925627785232136*^9}, {
   3.9256278315792837`*^9, 3.9256278721086187`*^9}, {3.925640453251155*^9, 
   3.9256404659825068`*^9}, {3.925640542328603*^9, 3.925640553862445*^9}, {
   3.925640586056288*^9, 3.9256408973909087`*^9}, {3.925641004860258*^9, 
   3.925641011362437*^9}, {3.925641059782292*^9, 3.9256411051955504`*^9}, {
   3.925641173409655*^9, 3.925641224755372*^9}, {3.9256412861172185`*^9, 
   3.925641409384799*^9}, {3.925641459417472*^9, 3.925641871539464*^9}, {
   3.925648511354003*^9, 3.9256486551052337`*^9}, {3.9256486972881217`*^9, 
   3.9256486975193605`*^9}, {3.9256568888367014`*^9, 3.925656893979957*^9}, {
   3.925657124832982*^9, 3.9256571464084673`*^9}, {3.9256574199832954`*^9, 
   3.9256574469229956`*^9}, {3.9256577640975494`*^9, 3.925657773438473*^9}, 
   3.9256582786313457`*^9, {3.925666769567525*^9, 3.925666892567008*^9}, {
   3.9256670585854263`*^9, 3.9256671016274657`*^9}, {3.925702096984229*^9, 
   3.925702104961409*^9}, {3.9257024222477837`*^9, 3.9257024316973286`*^9}, {
   3.9257027112452927`*^9, 3.925702718677634*^9}, {3.9257029073361034`*^9, 
   3.925702916378188*^9}, {3.9257034118457575`*^9, 3.9257034409828033`*^9}, {
   3.9257036352336426`*^9, 3.9257036568872595`*^9}, {3.925703856418398*^9, 
   3.925703857019411*^9}, {3.9257151439189167`*^9, 3.9257151538253374`*^9}, {
   3.9257168916864104`*^9, 3.925717043337496*^9}, {3.9257170869797564`*^9, 
   3.9257170874503098`*^9}, {3.925717629324978*^9, 3.9257176605955667`*^9}, {
   3.925723706704939*^9, 3.925723711109227*^9}, {3.92572411123508*^9, 
   3.925724122337056*^9}, {3.9257246833250637`*^9, 3.925724691180379*^9}, {
   3.925725214514061*^9, 3.925725226005123*^9}, {3.9257253866584415`*^9, 
   3.9257253868431015`*^9}, {3.925905371941493*^9, 3.9259053927221117`*^9}, {
   3.9259054238927803`*^9, 3.9259054257665586`*^9}, {3.925905494014856*^9, 
   3.92590549648357*^9}, {3.925905563517888*^9, 3.9259055673444247`*^9}, {
   3.925981253912485*^9, 3.925981268686095*^9}, {3.925981596875747*^9, 
   3.92598159705217*^9}, {3.9259833663291044`*^9, 3.9259833865179276`*^9}, {
   3.9259835578383713`*^9, 3.9259835646764956`*^9}, {3.925983836423647*^9, 
   3.9259838634265223`*^9}, {3.9259849929975414`*^9, 
   3.9259850051462765`*^9}, {3.9261370324500875`*^9, 3.926137036877223*^9}, {
   3.9261370829877048`*^9, 3.926137125690347*^9}, {3.926137161464861*^9, 
   3.926137226828714*^9}, {3.926137322926796*^9, 3.92613738814528*^9}, {
   3.9261374286529837`*^9, 3.926137500673912*^9}, {3.9261375394011326`*^9, 
   3.926138058386633*^9}, {3.9261381086864705`*^9, 3.926138118256423*^9}, {
   3.9261381586314297`*^9, 3.9261381601349373`*^9}, {3.9264331005308146`*^9, 
   3.9264331066327744`*^9}, {3.926433171544403*^9, 3.926433172230709*^9}, {
   3.926433215018284*^9, 3.926433219765335*^9}, {3.926433376534212*^9, 
   3.926433382832738*^9}, {3.926433422826826*^9, 3.926433426577552*^9}, {
   3.9264334599480515`*^9, 3.9264334628034525`*^9}, {3.9264335206966534`*^9, 
   3.9264335439595947`*^9}, {3.926433659734727*^9, 3.926433662559676*^9}, {
   3.926433753876492*^9, 3.9264337711216*^9}, {3.934538233567692*^9, 
   3.9345382344694157`*^9}, {3.934538265104443*^9, 3.9345382655585546`*^9}, {
   3.9345383257497025`*^9, 3.9345384058665323`*^9}, {3.9345384436935935`*^9, 
   3.9345384864248714`*^9}, {3.934538575747225*^9, 3.93453861752734*^9}, {
   3.9345386902315702`*^9, 3.9345387425277414`*^9}, {3.934547073942102*^9, 
   3.9345471661523147`*^9}, 3.934558262337711*^9, {3.9346258619538403`*^9, 
   3.9346258622699833`*^9}, {3.9346271815267324`*^9, 3.934627227399317*^9}, {
   3.93462728493582*^9, 3.934627285167588*^9}, {3.9347059945206995`*^9, 
   3.9347061292950544`*^9}, {3.9347061638988433`*^9, 
   3.9347062943983774`*^9}, {3.9347063501800766`*^9, 
   3.9347063880280857`*^9}, {3.9347064565738297`*^9, 
   3.9347064674901876`*^9}, {3.934706586717143*^9, 3.93470659570433*^9}, {
   3.9347067020550127`*^9, 3.934706715753518*^9}, {3.934706783444546*^9, 
   3.9347068078518558`*^9}, {3.9347255119800515`*^9, 
   3.9347255801414766`*^9}, {3.9347259260924225`*^9, 
   3.9347259318573923`*^9}, {3.934726169524124*^9, 3.934726222889677*^9}, {
   3.934727565077572*^9, 3.9347275664288807`*^9}, {3.9347388628203835`*^9, 
   3.9347388836053686`*^9}, {3.934796081895567*^9, 3.9347961153135133`*^9}, {
   3.9347963286452255`*^9, 3.9347963625962105`*^9}, {3.934796562111245*^9, 
   3.934796617365877*^9}, {3.9347967668254056`*^9, 3.9347968220338955`*^9}, {
   3.934796948029863*^9, 3.934796978664096*^9}, {3.9347970910445814`*^9, 
   3.934797125502355*^9}, {3.9349035136459084`*^9, 3.9349035319143505`*^9}, {
   3.934903616195371*^9, 3.934903640690153*^9}, {3.9349037612954063`*^9, 
   3.9349038011206937`*^9}, {3.9349038546435895`*^9, 
   3.9349038557301397`*^9}, {3.9349039006994267`*^9, 3.934903935425845*^9}, {
   3.9350747802195454`*^9, 3.935074816133124*^9}, {3.9350750148559093`*^9, 
   3.935075048293787*^9}, {3.93507524106755*^9, 3.9350752807912645`*^9}, {
   3.935075452840108*^9, 3.9350754850011997`*^9}, {3.9351613636977005`*^9, 
   3.9351613881883593`*^9}, {3.935161496992919*^9, 3.935161503353717*^9}, {
   3.935161549116042*^9, 3.9351615630388107`*^9}, {3.9351616096486273`*^9, 
   3.935161643628955*^9}, {3.9351616836768656`*^9, 3.935161690848593*^9}, 
   3.935161857397036*^9, 3.935162000365829*^9, {3.93516204238923*^9, 
   3.9351620812719407`*^9}, {3.9351621133215837`*^9, 3.935162120599024*^9}, {
   3.935490787457032*^9, 3.9354908047442193`*^9}, {3.935490932295392*^9, 
   3.935490948571292*^9}, {3.9354910685271025`*^9, 3.9354910829872675`*^9}, {
   3.9354911901721087`*^9, 3.9354912023874073`*^9}, 3.9708204346234703`*^9, {
   3.970820514490823*^9, 3.9708205513696747`*^9}, {3.9708206823585243`*^9, 
   3.9708207653047285`*^9}, {3.9708207998775983`*^9, 
   3.9708208989507647`*^9}, {3.9708209737762303`*^9, 
   3.9708209911015806`*^9}, {3.970821501461005*^9, 3.970821502036261*^9}, {
   3.9708216011890335`*^9, 
   3.97082162371224*^9}},ExpressionUUID->"dd996736-44a4-4c03-8c02-\
fe7186ae1543"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Figure", " ", "S12", 
   RowBox[{"(", "a", ")"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.9708209195592337`*^9, 
  3.970820932825718*^9}},ExpressionUUID->"e7c67c41-0eae-4bc0-80de-\
f30b6fb060f0"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[1, 0, 0], PointSize[0.0125], Thickness[0.005], 
         GeometricTransformationBox[
          TagBox[InsetBox[
            StyleBox["\[FilledDiamond]",
             FontSize->12,
             FontColor->RGBColor[1, 0, 0]], {0., 0.}],
           "InsetString"], {{{0.688134638736401, 1.8702625307159986`}}, {{
          1.3711807233098425`, 4.118711918670395}}, {{1.7544036826842861`, 
          5.521460917862246}}, {{1.998773638612381, 6.53813982376767}}, {{
          2.169053700369523, 7.233455418621439}}, {{2.2965670206684825`, 
          7.737616282857904}}, {{2.3832429960115, 8.164225652265827}}, {{
          2.531313022602156, 8.704833909687792}}, {{2.6326080059353516`, 
          9.10320049641828}}, {{2.7245795030534206`, 9.387816877106937}}, {{
          2.783157673589016, 9.639782389465795}}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0], 
              PointSize[0.0125], 
              Thickness[0.005]], 
             GeometricTransformation[
              Inset[
              "\!\(\*StyleBox[\"\[FilledDiamond]\",FontSize->12,FontColor->\
RGBColor[1, 0, 0]]\)", {0., 0.}], {{{0.688134638736401, 
              1.8702625307159986`}}, {{1.3711807233098425`, 
              4.118711918670395}}, {{1.7544036826842861`, 
              5.521460917862246}}, {{1.998773638612381, 6.53813982376767}}, {{
              2.169053700369523, 7.233455418621439}}, {{2.2965670206684825`, 
              7.737616282857904}}, {{2.3832429960115, 8.164225652265827}}, {{
              2.531313022602156, 8.704833909687792}}, {{2.6326080059353516`, 
              9.10320049641828}}, {{2.7245795030534206`, 
              9.387816877106937}}, {{2.783157673589016, 
              9.639782389465795}}}]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 3.4011973816621555`}, {0., 
             11.512925464970229`}}, "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {0., 0.}, "ImageSize" -> {360, 324.}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 0.9, 
            "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[0.0125], 
               Thickness[0.005]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Exp[
                 Part[#, 1]], 
                Exp[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
            "Primitives" -> {}, "GCFlag" -> False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListLogLogPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 3.4011973816621555`}, {0., 
            11.512925464970229`}}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0., 0.}, "ImageSize" -> {360, 324.}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 0.9, 
           "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0], 
              PointSize[0.0125], 
              Thickness[0.005]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Exp[
                Part[#, 1]], 
               Exp[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
           "Primitives" -> {}, "GCFlag" -> False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListLogLogPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0], 
           PointSize[0.0125], 
           Thickness[0.005]], 
          GeometricTransformation[
           Inset[
           "\!\(\*StyleBox[\"\[FilledDiamond]\",FontSize->12,FontColor->\
RGBColor[1, 0, 0]]\)", {0., 0.}], {{{0.688134638736401, 
           1.8702625307159986`}}, {{1.3711807233098425`, 
           4.118711918670395}}, {{1.7544036826842861`, 5.521460917862246}}, {{
           1.998773638612381, 6.53813982376767}}, {{2.169053700369523, 
           7.233455418621439}}, {{2.2965670206684825`, 7.737616282857904}}, {{
           2.3832429960115, 8.164225652265827}}, {{2.531313022602156, 
           8.704833909687792}}, {{2.6326080059353516`, 9.10320049641828}}, {{
           2.7245795030534206`, 9.387816877106937}}, {{2.783157673589016, 
           9.639782389465795}}}]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 3.4011973816621555`}, {0., 11.512925464970229`}},
          "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0., 0.}, 
         "ImageSize" -> {360, 324.}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> 0.9, "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0], 
            PointSize[0.0125], 
            Thickness[0.005]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Exp[
              Part[#, 1]], 
             Exp[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
         "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListLogLogPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 0, 1], PointSize[0.0125], Thickness[0.005], 
         GeometricTransformationBox[
          TagBox[InsetBox[
            StyleBox["\[FilledDiamond]",
             FontSize->12,
             FontColor->RGBColor[0, 0, 1]], {0., 0.}],
           "InsetString"], {{{1.791759469228055, 0.7030975114131134}}, {{
          2.0781907597781832`, 2.4527277514237653`}}, {{2.298577071596507, 
          3.800197190245889}}, {{2.474856313934499, 4.909414346738851}}, {{
          2.617395832834079, 5.818508992064351}}, {{2.731115474033206, 
          6.57690123074356}}, {{2.821973947420524, 7.188714805673091}}, {{
          2.8925915146344776`, 7.686602977731612}}, {{2.9528247725427144`, 
          8.057858842438385}}, {{3.0041963519661206`, 8.355067125913767}}, {{
          3.0473755067058295`, 8.610905732038098}}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1], 
              PointSize[0.0125], 
              Thickness[0.005]], 
             GeometricTransformation[
              Inset[
              "\!\(\*StyleBox[\"\[FilledDiamond]\",FontSize->12,FontColor->\
RGBColor[0, 0, 1]]\)", {0., 0.}], {{{1.791759469228055, 
              0.7030975114131134}}, {{2.0781907597781832`, 
              2.4527277514237653`}}, {{2.298577071596507, 
              3.800197190245889}}, {{2.474856313934499, 
              4.909414346738851}}, {{2.617395832834079, 
              5.818508992064351}}, {{2.731115474033206, 6.57690123074356}}, {{
              2.821973947420524, 7.188714805673091}}, {{2.8925915146344776`, 
              7.686602977731612}}, {{2.9528247725427144`, 
              8.057858842438385}}, {{3.0041963519661206`, 
              8.355067125913767}}, {{3.0473755067058295`, 
              8.610905732038098}}}]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 3.4011973816621555`}, {0., 
             10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {0., 0.}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               RGBColor[0, 0, 1], 
               PointSize[0.0125], 
               Thickness[0.005]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Exp[
                 Part[#, 1]], 
                Exp[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
            "Primitives" -> {}, "GCFlag" -> False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListLogLogPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 3.4011973816621555`}, {0., 
            10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0., 0.}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1], 
              PointSize[0.0125], 
              Thickness[0.005]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Exp[
                Part[#, 1]], 
               Exp[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
           "Primitives" -> {}, "GCFlag" -> False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListLogLogPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           AbsoluteThickness[2], 
           RGBColor[0, 0, 1], 
           PointSize[0.0125], 
           Thickness[0.005]], 
          GeometricTransformation[
           Inset[
           "\!\(\*StyleBox[\"\[FilledDiamond]\",FontSize->12,FontColor->\
RGBColor[0, 0, 1]]\)", {0., 0.}], {{{1.791759469228055, 
           0.7030975114131134}}, {{2.0781907597781832`, 
           2.4527277514237653`}}, {{2.298577071596507, 3.800197190245889}}, {{
           2.474856313934499, 4.909414346738851}}, {{2.617395832834079, 
           5.818508992064351}}, {{2.731115474033206, 6.57690123074356}}, {{
           2.821973947420524, 7.188714805673091}}, {{2.8925915146344776`, 
           7.686602977731612}}, {{2.9528247725427144`, 8.057858842438385}}, {{
           3.0041963519661206`, 8.355067125913767}}, {{3.0473755067058295`, 
           8.610905732038098}}}]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 3.4011973816621555`}, {0., 10.308952660644293`}},
          "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0., 0.}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            RGBColor[0, 0, 1], 
            PointSize[0.0125], 
            Thickness[0.005]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Exp[
              Part[#, 1]], 
             Exp[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
         "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListLogLogPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[1, 0, 0], PointSize[0.0125], Thickness[0.005], 
          LineBox[{{0.688134638736401, 1.8702625307159986`}, {
           1.3711807233098425`, 4.118711918670395}, {1.7544036826842861`, 
           5.521460917862246}, {1.998773638612381, 6.53813982376767}, {
           2.169053700369523, 7.233455418621439}, {2.2965670206684825`, 
           7.737616282857904}, {2.3832429960115, 8.164225652265827}, {
           2.531313022602156, 8.704833909687792}, {2.6326080059353516`, 
           9.10320049641828}, {2.7245795030534206`, 9.387816877106937}, {
           2.783157673589016, 9.639782389465795}}]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0], 
              PointSize[0.0125], 
              Thickness[0.005]], 
             
             Line[{{0.688134638736401, 1.8702625307159986`}, {
              1.3711807233098425`, 4.118711918670395}, {1.7544036826842861`, 
              5.521460917862246}, {1.998773638612381, 6.53813982376767}, {
              2.169053700369523, 7.233455418621439}, {2.2965670206684825`, 
              7.737616282857904}, {2.3832429960115, 8.164225652265827}, {
              2.531313022602156, 8.704833909687792}, {2.6326080059353516`, 
              9.10320049641828}, {2.7245795030534206`, 9.387816877106937}, {
              2.783157673589016, 9.639782389465795}}]}, 
            "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 3.4011973816621555`}, {0., 
             10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {0., 0.}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[0.0125], 
               Thickness[0.005]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Exp[
                 Part[#, 1]], 
                Exp[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
            "Primitives" -> {}, "GCFlag" -> False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListLogLogPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 3.4011973816621555`}, {0., 
            10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0., 0.}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0], 
              PointSize[0.0125], 
              Thickness[0.005]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Exp[
                Part[#, 1]], 
               Exp[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
           "Primitives" -> {}, "GCFlag" -> False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListLogLogPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0], 
           PointSize[0.0125], 
           Thickness[0.005]], 
          
          Line[{{0.688134638736401, 1.8702625307159986`}, {
           1.3711807233098425`, 4.118711918670395}, {1.7544036826842861`, 
           5.521460917862246}, {1.998773638612381, 6.53813982376767}, {
           2.169053700369523, 7.233455418621439}, {2.2965670206684825`, 
           7.737616282857904}, {2.3832429960115, 8.164225652265827}, {
           2.531313022602156, 8.704833909687792}, {2.6326080059353516`, 
           9.10320049641828}, {2.7245795030534206`, 9.387816877106937}, {
           2.783157673589016, 9.639782389465795}}]}, 
         "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 3.4011973816621555`}, {0., 10.308952660644293`}},
          "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0., 0.}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0], 
            PointSize[0.0125], 
            Thickness[0.005]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Exp[
              Part[#, 1]], 
             Exp[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
         "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListLogLogPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 1], PointSize[0.0125], Thickness[0.005], 
          LineBox[{{1.791759469228055, 0.7030975114131134}, {
           2.0781907597781832`, 2.4527277514237653`}, {2.298577071596507, 
           3.800197190245889}, {2.474856313934499, 4.909414346738851}, {
           2.617395832834079, 5.818508992064351}, {2.731115474033206, 
           6.57690123074356}, {2.821973947420524, 7.188714805673091}, {
           2.8925915146344776`, 7.686602977731612}, {2.9528247725427144`, 
           8.057858842438385}, {3.0041963519661206`, 8.355067125913767}, {
           3.0473755067058295`, 8.610905732038098}}]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1], 
              PointSize[0.0125], 
              Thickness[0.005]], 
             
             Line[{{1.791759469228055, 0.7030975114131134}, {
              2.0781907597781832`, 2.4527277514237653`}, {2.298577071596507, 
              3.800197190245889}, {2.474856313934499, 4.909414346738851}, {
              2.617395832834079, 5.818508992064351}, {2.731115474033206, 
              6.57690123074356}, {2.821973947420524, 7.188714805673091}, {
              2.8925915146344776`, 7.686602977731612}, {2.9528247725427144`, 
              8.057858842438385}, {3.0041963519661206`, 8.355067125913767}, {
              3.0473755067058295`, 8.610905732038098}}]}, 
            "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 3.4011973816621555`}, {0., 
             10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {0., 0.}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               RGBColor[0, 0, 1], 
               PointSize[0.0125], 
               Thickness[0.005]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Exp[
                 Part[#, 1]], 
                Exp[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
            "Primitives" -> {}, "GCFlag" -> False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListLogLogPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 3.4011973816621555`}, {0., 
            10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0., 0.}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1], 
              PointSize[0.0125], 
              Thickness[0.005]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Exp[
                Part[#, 1]], 
               Exp[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
           "Primitives" -> {}, "GCFlag" -> False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListLogLogPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           AbsoluteThickness[2], 
           RGBColor[0, 0, 1], 
           PointSize[0.0125], 
           Thickness[0.005]], 
          
          Line[{{1.791759469228055, 0.7030975114131134}, {2.0781907597781832`,
            2.4527277514237653`}, {2.298577071596507, 3.800197190245889}, {
           2.474856313934499, 4.909414346738851}, {2.617395832834079, 
           5.818508992064351}, {2.731115474033206, 6.57690123074356}, {
           2.821973947420524, 7.188714805673091}, {2.8925915146344776`, 
           7.686602977731612}, {2.9528247725427144`, 8.057858842438385}, {
           3.0041963519661206`, 8.355067125913767}, {3.0473755067058295`, 
           8.610905732038098}}]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 3.4011973816621555`}, {0., 10.308952660644293`}},
          "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0., 0.}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            RGBColor[0, 0, 1], 
            PointSize[0.0125], 
            Thickness[0.005]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Exp[
              Part[#, 1]], 
             Exp[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
         "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListLogLogPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[1, 0, 0], PointSize[0.0125], AbsoluteThickness[2], 
         Dashing[{0.01, 0.01}], 
         PointBox[{{0.6931471805599453, 3.6506582412937387`}, {
          1.0986122886681098`, 4.537961436294641}, {1.3862943611198906`, 
          5.170483995038151}, {1.6094379124341003`, 5.7120812774708964`}, {
          1.791759469228055, 6.133181099726463}, {1.9459101490553132`, 
          6.545780601948501}, {2.0794415416798357`, 6.902139540196502}, {
          2.302585092994046, 7.533693709848633}, {2.70805020110221, 
          8.948975607841776}, {2.995732273553991, 10.116580767996837`}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[1, 0, 0], 
              PointSize[0.0125]], 
             
             Point[{{0.6931471805599453, 3.6506582412937387`}, {
              1.0986122886681098`, 4.537961436294641}, {1.3862943611198906`, 
              5.170483995038151}, {1.6094379124341003`, 
              5.7120812774708964`}, {1.791759469228055, 6.133181099726463}, {
              1.9459101490553132`, 6.545780601948501}, {2.0794415416798357`, 
              6.902139540196502}, {2.302585092994046, 7.533693709848633}, {
              2.70805020110221, 8.948975607841776}, {2.995732273553991, 
              10.116580767996837`}}]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 3.4011973816621555`}, {-4.605170185988091, 
             13.815510557964274`}}, "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {0., -4.60517018598808}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               Dashing[{0.01, 0.01}], 
               RGBColor[1, 0, 0], 
               PointSize[0.0125]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Exp[
                 Part[#, 1]], 
                Exp[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
            "Primitives" -> {}, "GCFlag" -> False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListLogLogPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 3.4011973816621555`}, {-4.605170185988091, 
            13.815510557964274`}}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0., -4.60517018598808}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[1, 0, 0], 
              PointSize[0.0125]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Exp[
                Part[#, 1]], 
               Exp[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
           "Primitives" -> {}, "GCFlag" -> False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListLogLogPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[1, 0, 0], 
           PointSize[0.0125]], 
          
          Point[{{0.6931471805599453, 3.6506582412937387`}, {
           1.0986122886681098`, 4.537961436294641}, {1.3862943611198906`, 
           5.170483995038151}, {1.6094379124341003`, 5.7120812774708964`}, {
           1.791759469228055, 6.133181099726463}, {1.9459101490553132`, 
           6.545780601948501}, {2.0794415416798357`, 6.902139540196502}, {
           2.302585092994046, 7.533693709848633}, {2.70805020110221, 
           8.948975607841776}, {2.995732273553991, 10.116580767996837`}}]}, 
         "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 3.4011973816621555`}, {-4.605170185988091, 
          13.815510557964274`}}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0., -4.60517018598808}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            Dashing[{0.01, 0.01}], 
            RGBColor[1, 0, 0], 
            PointSize[0.0125]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Exp[
              Part[#, 1]], 
             Exp[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
         "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListLogLogPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[
          {RGBColor[1, 0, 0], PointSize[0.0125], AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           LineBox[{{0.6931471805599453, 3.6506582412937387`}, {
            1.0986122886681098`, 4.537961436294641}, {1.3862943611198906`, 
            5.170483995038151}, {1.6094379124341003`, 5.7120812774708964`}, {
            1.791759469228055, 6.133181099726463}, {1.9459101490553132`, 
            6.545780601948501}, {2.0794415416798357`, 6.902139540196502}, {
            2.302585092994046, 7.533693709848633}, {2.70805020110221, 
            8.948975607841776}, {2.995732273553991, 10.116580767996837`}}]},
          Annotation[#, "Charting`Private`Tag#1"]& ]}, 
        TagBox[
         {RGBColor[1, 0, 0], PointSize[0.0125], AbsoluteThickness[2], 
          Dashing[{0.01, 0.01}], GeometricTransformationBox[
           TagBox[InsetBox[
             StyleBox["\[EmptyCircle]",
              FontSize->12,
              FontColor->RGBColor[1, 0, 0]], {0., 0.}],
            "InsetString"], {{{0.6931471805599453, 3.6506582412937387`}}, {{
           1.0986122886681098`, 4.537961436294641}}, {{1.3862943611198906`, 
           5.170483995038151}}, {{1.6094379124341003`, 
           5.7120812774708964`}}, {{1.791759469228055, 6.133181099726463}}, {{
           1.9459101490553132`, 6.545780601948501}}, {{2.0794415416798357`, 
           6.902139540196502}}, {{2.302585092994046, 7.533693709848633}}, {{
           2.70805020110221, 8.948975607841776}}, {{2.995732273553991, 
           10.116580767996837`}}}]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[1, 0, 0], 
              PointSize[0.0125]], 
             
             Line[{{0.6931471805599453, 3.6506582412937387`}, {
              1.0986122886681098`, 4.537961436294641}, {1.3862943611198906`, 
              5.170483995038151}, {1.6094379124341003`, 
              5.7120812774708964`}, {1.791759469228055, 6.133181099726463}, {
              1.9459101490553132`, 6.545780601948501}, {2.0794415416798357`, 
              6.902139540196502}, {2.302585092994046, 7.533693709848633}, {
              2.70805020110221, 8.948975607841776}, {2.995732273553991, 
              10.116580767996837`}}]}, "Charting`Private`Tag#1"]}, {
           Annotation[{
             Directive[
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[1, 0, 0], 
              PointSize[0.0125]], 
             GeometricTransformation[
              Inset[
              "\!\(\*StyleBox[\"\[EmptyCircle]\",FontSize->12,FontColor->\
RGBColor[1, 0, 0]]\)", {0., 0.}], {{{0.6931471805599453, 
              3.6506582412937387`}}, {{1.0986122886681098`, 
              4.537961436294641}}, {{1.3862943611198906`, 
              5.170483995038151}}, {{1.6094379124341003`, 
              5.7120812774708964`}}, {{1.791759469228055, 
              6.133181099726463}}, {{1.9459101490553132`, 
              6.545780601948501}}, {{2.0794415416798357`, 
              6.902139540196502}}, {{2.302585092994046, 
              7.533693709848633}}, {{2.70805020110221, 8.948975607841776}}, {{
              2.995732273553991, 10.116580767996837`}}}]}, 
            "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 3.4011973816621555`}, {-4.605170185988091, 
             10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {0., -4.60517018598808}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               Dashing[{0.01, 0.01}], 
               RGBColor[1, 0, 0], 
               PointSize[0.0125]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Exp[
                 Part[#, 1]], 
                Exp[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
            "Primitives" -> {}, "GCFlag" -> False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListLogLogPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 3.4011973816621555`}, {-4.605170185988091, 
            10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0., -4.60517018598808}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[1, 0, 0], 
              PointSize[0.0125]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Exp[
                Part[#, 1]], 
               Exp[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
           "Primitives" -> {}, "GCFlag" -> False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListLogLogPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[1, 0, 0], 
           PointSize[0.0125]], 
          
          Line[{{0.6931471805599453, 3.6506582412937387`}, {
           1.0986122886681098`, 4.537961436294641}, {1.3862943611198906`, 
           5.170483995038151}, {1.6094379124341003`, 5.7120812774708964`}, {
           1.791759469228055, 6.133181099726463}, {1.9459101490553132`, 
           6.545780601948501}, {2.0794415416798357`, 6.902139540196502}, {
           2.302585092994046, 7.533693709848633}, {2.70805020110221, 
           8.948975607841776}, {2.995732273553991, 10.116580767996837`}}]}, 
         "Charting`Private`Tag#1"]}, {
        Annotation[{
          Directive[
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[1, 0, 0], 
           PointSize[0.0125]], 
          GeometricTransformation[
           Inset[
           "\!\(\*StyleBox[\"\[EmptyCircle]\",FontSize->12,FontColor->\
RGBColor[1, 0, 0]]\)", {0., 0.}], {{{0.6931471805599453, 
           3.6506582412937387`}}, {{1.0986122886681098`, 
           4.537961436294641}}, {{1.3862943611198906`, 5.170483995038151}}, {{
           1.6094379124341003`, 5.7120812774708964`}}, {{1.791759469228055, 
           6.133181099726463}}, {{1.9459101490553132`, 6.545780601948501}}, {{
           2.0794415416798357`, 6.902139540196502}}, {{2.302585092994046, 
           7.533693709848633}}, {{2.70805020110221, 8.948975607841776}}, {{
           2.995732273553991, 10.116580767996837`}}}]}, 
         "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 3.4011973816621555`}, {-4.605170185988091, 
          10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0., -4.60517018598808}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            Dashing[{0.01, 0.01}], 
            RGBColor[1, 0, 0], 
            PointSize[0.0125]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Exp[
              Part[#, 1]], 
             Exp[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
         "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListLogLogPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 0, 1], PointSize[0.0125], AbsoluteThickness[2], 
         Dashing[{0.01, 0.01}], GeometricTransformationBox[
          TagBox[InsetBox[
            StyleBox["\[EmptyCircle]",
             FontSize->12,
             FontColor->RGBColor[0, 0, 1]], {0., 0.}],
           "InsetString"], {{{1.791759469228055, 2.719978771967484}}, {{
          1.9459101490553132`, 3.177220149599368}}, {{2.0794415416798357`, 
          3.732896339530711}}, {{2.302585092994046, 4.907494535176743}}, {{
          2.70805020110221, 6.804614520062624}}, {{2.995732273553991, 
          8.592300663903043}}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[0, 0, 1], 
              PointSize[0.0125]], 
             GeometricTransformation[
              Inset[
              "\!\(\*StyleBox[\"\[EmptyCircle]\",FontSize->12,FontColor->\
RGBColor[0, 0, 1]]\)", {0., 0.}], {{{1.791759469228055, 
              2.719978771967484}}, {{1.9459101490553132`, 
              3.177220149599368}}, {{2.0794415416798357`, 
              3.732896339530711}}, {{2.302585092994046, 
              4.907494535176743}}, {{2.70805020110221, 6.804614520062624}}, {{
              2.995732273553991, 8.592300663903043}}}]}, 
            "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 3.4011973816621555`}, {-4.605170185988091, 
             10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {0., -4.60517018598808}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               Dashing[{0.01, 0.01}], 
               RGBColor[0, 0, 1], 
               PointSize[0.0125]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Exp[
                 Part[#, 1]], 
                Exp[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
            "Primitives" -> {}, "GCFlag" -> False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListLogLogPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 3.4011973816621555`}, {-4.605170185988091, 
            10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0., -4.60517018598808}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[0, 0, 1], 
              PointSize[0.0125]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Exp[
                Part[#, 1]], 
               Exp[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
           "Primitives" -> {}, "GCFlag" -> False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListLogLogPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[0, 0, 1], 
           PointSize[0.0125]], 
          GeometricTransformation[
           Inset[
           "\!\(\*StyleBox[\"\[EmptyCircle]\",FontSize->12,FontColor->\
RGBColor[0, 0, 1]]\)", {0., 0.}], {{{1.791759469228055, 
           2.719978771967484}}, {{1.9459101490553132`, 3.177220149599368}}, {{
           2.0794415416798357`, 3.732896339530711}}, {{2.302585092994046, 
           4.907494535176743}}, {{2.70805020110221, 6.804614520062624}}, {{
           2.995732273553991, 8.592300663903043}}}]}, 
         "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 3.4011973816621555`}, {-4.605170185988091, 
          10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0., -4.60517018598808}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            Dashing[{0.01, 0.01}], 
            RGBColor[0, 0, 1], 
            PointSize[0.0125]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Exp[
              Part[#, 1]], 
             Exp[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
         "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListLogLogPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 1], PointSize[0.0125], AbsoluteThickness[2], 
          Dashing[{0.01, 0.01}], 
          LineBox[{{1.791759469228055, 2.719978771967484}, {
           1.9459101490553132`, 3.177220149599368}, {2.0794415416798357`, 
           3.732896339530711}, {2.302585092994046, 4.907494535176743}, {
           2.70805020110221, 6.804614520062624}, {2.995732273553991, 
           8.592300663903043}}]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[0, 0, 1], 
              PointSize[0.0125]], 
             
             Line[{{1.791759469228055, 2.719978771967484}, {
              1.9459101490553132`, 3.177220149599368}, {2.0794415416798357`, 
              3.732896339530711}, {2.302585092994046, 4.907494535176743}, {
              2.70805020110221, 6.804614520062624}, {2.995732273553991, 
              8.592300663903043}}]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 3.4011973816621555`}, {-4.605170185988091, 
             10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {0., -4.60517018598808}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               Dashing[{0.01, 0.01}], 
               RGBColor[0, 0, 1], 
               PointSize[0.0125]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Exp[
                 Part[#, 1]], 
                Exp[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
            "Primitives" -> {}, "GCFlag" -> False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListLogLogPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 3.4011973816621555`}, {-4.605170185988091, 
            10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0., -4.60517018598808}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[0, 0, 1], 
              PointSize[0.0125]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Exp[
                Part[#, 1]], 
               Exp[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
           "Primitives" -> {}, "GCFlag" -> False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListLogLogPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[0, 0, 1], 
           PointSize[0.0125]], 
          
          Line[{{1.791759469228055, 2.719978771967484}, {1.9459101490553132`, 
           3.177220149599368}, {2.0794415416798357`, 3.732896339530711}, {
           2.302585092994046, 4.907494535176743}, {2.70805020110221, 
           6.804614520062624}, {2.995732273553991, 8.592300663903043}}]}, 
         "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 3.4011973816621555`}, {-4.605170185988091, 
          10.308952660644293`}}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0., -4.60517018598808}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            Dashing[{0.01, 0.01}], 
            RGBColor[0, 0, 1], 
            PointSize[0.0125]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Exp[
              Part[#, 1]], 
             Exp[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Log, Exp}, {Log, Exp}}|>, 
         "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListLogLogPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}},
  AspectRatio->0.9,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
        FormBox["1000", TraditionalForm], {0.01, 0.}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm], {0.01, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.206072645530174`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.611537753638338`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.89921982609012, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.122363377404328`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.304684934198283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.458835614025542`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.592367006650065`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.710150042306449`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.815510557964274`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.206072645530174`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.611537753638338`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.89921982609012, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.122363377404328`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.304684934198283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.458835614025542`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.592367006650065`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.710150042306449`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.815510557964274`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {{{
       0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
        FormBox["2", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {2.995732273553991, 
        FormBox["20", TraditionalForm], {0.01, 0.}}, {0.4054651081081644, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       0.4054651081081644, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{269.33333333333337`, Automatic},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 3.4011973816621555`}, {0., 11.512925464970229`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Print",
 CellChangeTimes->{{3.925640841535844*^9, 3.9256408594122066`*^9}, 
   3.9256411069172106`*^9, 3.925641228449148*^9, {3.925641856664257*^9, 
   3.925641874177663*^9}, {3.925648644537024*^9, 3.925648657410074*^9}, 
   3.9256486992562637`*^9, 3.9256568957385535`*^9, 3.9256571496856956`*^9, 
   3.925657450432412*^9, 3.925657777163669*^9, 3.9256668753743763`*^9, 
   3.9256669074766235`*^9, {3.9256670831930213`*^9, 3.925667103162631*^9}, 
   3.9257021062143717`*^9, 3.925702433080428*^9, 3.9257027238230753`*^9, 
   3.9257029201730814`*^9, 3.9257034466022835`*^9, {3.925703643400112*^9, 
   3.925703658361624*^9}, 3.9257038582221203`*^9, 3.925715156619193*^9, 
   3.925717045913705*^9, 3.925717088954897*^9, 3.925717662314354*^9, 
   3.9257237160775013`*^9, 3.925724123840425*^9, 3.9257246946840296`*^9, 
   3.9257252343937864`*^9, 3.925725388664914*^9, {3.925905377385516*^9, 
   3.925905393709704*^9}, 3.925981269695574*^9, 3.9259833890311513`*^9, 
   3.9259835663440676`*^9, 3.9259838650634813`*^9, 3.925985006401696*^9, {
   3.9261380427779517`*^9, 3.9261380603248143`*^9}, 3.9261381192267733`*^9, 
   3.926138161106558*^9, 3.9264331098099933`*^9, 3.926433221569462*^9, 
   3.9264334279985075`*^9, 3.9264334797392836`*^9, 3.926433545501399*^9, 
   3.92643366414253*^9, 3.9264337740460377`*^9, 3.9345384922780466`*^9, {
   3.9345385817464676`*^9, 3.9345386224389524`*^9}, 3.9345387328897877`*^9, 
   3.934542980755294*^9, {3.9345471235461135`*^9, 3.934547167423208*^9}, 
   3.934558263192416*^9, 3.934625863510911*^9, {3.934627183678795*^9, 
   3.9346272285018044`*^9}, 3.9346272863714437`*^9, {3.934706110328066*^9, 
   3.9347061306151714`*^9}, 3.9347062192150035`*^9, {3.9347062588174963`*^9, 
   3.934706295200116*^9}, 3.934706389400406*^9, {3.93470668034109*^9, 
   3.9347067170032253`*^9}, 3.934706812194463*^9, 3.9347255157205534`*^9, {
   3.9347255469962406`*^9, 3.9347255820302944`*^9}, 3.9347259385749273`*^9, 
   3.934726224440874*^9, 3.9347275680016623`*^9, {3.93473886510878*^9, 
   3.9347388848617563`*^9}, 3.934796118984378*^9, 3.9347963645223703`*^9, 
   3.934796622475177*^9, 3.9347968236071696`*^9, 3.934796982735214*^9, 
   3.9347971270301356`*^9, 3.9349035350216007`*^9, 3.9349036423793993`*^9, 
   3.9349038030551534`*^9, 3.9349038583031707`*^9, 3.93490394095278*^9, 
   3.935074818970998*^9, 3.9350750499981165`*^9, 3.935075282109847*^9, 
   3.935075486366995*^9, 3.935161390902583*^9, 3.935161504870229*^9, 
   3.9351615669082756`*^9, 3.9351616150766687`*^9, 3.935161645084033*^9, 
   3.935161692389741*^9, 3.9351619345265737`*^9, 3.9351620120352488`*^9, 
   3.935162122439872*^9, 3.9354908094884768`*^9, 3.9354909500431585`*^9, 
   3.93549108504626*^9, 3.9354912063182573`*^9, 3.9708204844975214`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"f92695bc-244f-4966-8d0a-566a089c4069"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. S12(b) J(V) curves 160 nm beta-MADN devices", "Subsection",
 CellChangeTimes->{{3.9261369988842583`*^9, 3.926137024902232*^9}, {
  3.926138203569962*^9, 3.9261382237554054`*^9}, {3.934538194146787*^9, 
  3.9345382211831217`*^9}, {3.9347261560231304`*^9, 3.9347261602694116`*^9}, {
  3.97082035545655*^9, 3.9708203759066763`*^9}, {3.9708206532591915`*^9, 
  3.9708206682579875`*^9}, {3.9708210097017765`*^9, 3.9708210406098504`*^9}, {
  3.9708216594941382`*^9, 
  3.9708216868213325`*^9}},ExpressionUUID->"45a9f283-b61f-4526-8361-\
72ad412c2cc4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Experimental", " ", "J", 
     RowBox[{"(", "V", ")"}], " ", "curve"}], ",", " ", 
    RowBox[{"296", " ", "K"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tabJVbeta296", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.97", ",", " ", "20.93"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.78", ",", " ", "138.45"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.29", ",", " ", "444.13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.48", ",", " ", "947.88"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5", ",", " ", "1565.61"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.27", ",", "2332.83"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.06", ",", " ", "3090.59"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.68", ",", " ", "3948.47"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.31", ",", " ", "4805.52"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.94", ",", " ", "5664.67"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.49", ",", " ", "6569.29"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.96", ",", " ", "7526.01"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Experimental", " ", "J", 
      RowBox[{"(", "V", ")"}], " ", "curve"}], ",", " ", 
     RowBox[{"210", " ", "K"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabJVbeta210", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5.99", ",", " ", "9.16"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.93", ",", " ", "42.41"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.78", ",", " ", "137.6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.43", ",", " ", "358.72"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.81", ",", " ", "744.27"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.91", ",", " ", "1304.94"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.88", ",", " ", "1952.46"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15.76", ",", " ", "2650.95"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16.44", ",", " ", "3471.89"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17.01", ",", " ", "4366.94"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"J", 
      RowBox[{"(", "V", ")"}], " ", "curve", " ", "from", " ", "KMC", " ", 
      "simulations"}], ",", " ", 
     RowBox[{"296", " ", "K"}], ",", " ", 
     RowBox[{"160", " ", "nm"}], ",", " ", 
     RowBox[{"sigma_holes", " ", "=", " ", 
      RowBox[{"0.10", " ", "eV"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fac", "=", "0.7"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"prefactor", " ", "f"}], ",", " ", 
     RowBox[{"See", " ", 
      RowBox[{"Eq", ".", " ", "S1"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabJV296betaMADKMC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"fac", "*", "67"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"fac", "*", "166"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", 
         RowBox[{"fac", "*", "328"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", 
         RowBox[{"fac", "*", "561"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{"fac", "*", "914"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", 
         RowBox[{"fac", "*", "1373"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", 
         RowBox[{"fac", "*", "2126"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", 
         RowBox[{"fac", "*", "4370"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", 
         RowBox[{"fac", "*", "2.04", "*", 
          SuperscriptBox["10", "4"]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", 
         RowBox[{"fac", "*", "6.92", "*", 
          SuperscriptBox["10", "4"]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"J", 
      RowBox[{"(", "V", ")"}], " ", "curve", " ", "from", " ", "KMC", " ", 
      "simulations"}], ",", " ", 
     RowBox[{"210", " ", "K"}], ",", " ", 
     RowBox[{"160", " ", "nm"}], ",", " ", 
     RowBox[{"sigma_holes", " ", "=", " ", 
      RowBox[{"0.10", " ", "eV"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabJV210betaMADNa10N", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{"fac", "*", "37.3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", 
         RowBox[{"fac", "*", "67.7"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", 
         RowBox[{"fac", "*", "127"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", 
         RowBox[{"fac", "*", "375"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", 
         RowBox[{"fac", "*", "4015"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", 
         RowBox[{"fac", "*", "24338"}]}], "}"}]}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.9708211053828835`*^9, 3.970821258378949*^9}, {
  3.9708216387278633`*^9, 
  3.970821639629506*^9}},ExpressionUUID->"2b50a27b-02c6-474a-a8af-\
2df3de9d8171"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Figure", " ", "S12", 
   RowBox[{"(", "b", ")"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.970821730025011*^9, 
  3.9708217385277424`*^9}},ExpressionUUID->"b2c031e9-6dde-4212-b8eb-\
eefb0249dc73"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[1, 0, 0], PointSize[0.0125], Thickness[0.01], 
     GeometricTransformationBox[
      TagBox[InsetBox[
        StyleBox["\[FilledDiamond]",
         FontSize->12,
         FontColor->RGBColor[1, 0, 0]], {0., 0.}],
       "InsetString"], {{{0.6780335427498971, 3.0411835364579085`}}, {{
      1.3297240096314962`, 4.9305092496169705`}}, {{1.665818245870208, 
      6.096117312369572}}, {{1.8687205103641833`, 6.854227911964328}}, {{
      2.0149030205422647`, 7.35603080338901}}, {{2.1126345090356, 
      7.754837401813953}}, {{2.203869120054888, 8.03611729017668}}, {{
      2.2700619012884857`, 8.281083441086814}}, {{2.333114298028869, 
      8.477520536152504}}, {{2.392425796993835, 8.642003919338183}}, {{
      2.4414770918606643`, 8.79016103866792}}, {{2.481567748522486, 
      8.92612029987958}}}]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.0125], Thickness[0.005], 
      LineBox[{{0.6780335427498971, 3.0411835364579085`}, {
       1.3297240096314962`, 4.9305092496169705`}, {1.665818245870208, 
       6.096117312369572}, {1.8687205103641833`, 6.854227911964328}, {
       2.0149030205422647`, 7.35603080338901}, {2.1126345090356, 
       7.754837401813953}, {2.203869120054888, 8.03611729017668}, {
       2.2700619012884857`, 8.281083441086814}, {2.333114298028869, 
       8.477520536152504}, {2.392425796993835, 8.642003919338183}, {
       2.4414770918606643`, 8.79016103866792}, {2.481567748522486, 
       8.92612029987958}}]}}, {{}, {}}}, {{}, 
    {RGBColor[0, 0, 1], PointSize[0.0125], Thickness[0.005], 
     GeometricTransformationBox[
      TagBox[InsetBox[
        StyleBox["\[FilledDiamond]",
         FontSize->12,
         FontColor->RGBColor[0, 0, 1]], {0., 0.}],
       "InsetString"], {{{1.7900914121273581`, 2.214846178686039}}, {{
      2.0706530356467567`, 3.747384183486499}}, {{2.280339484046726, 
      4.924350925499243}}, {{2.4362414778067194`, 5.882542139883795}}, {{
      2.550226115908643, 6.61240387222545}}, {{2.6326080059353516`, 
      7.173912341688324}}, {{2.700018029404946, 7.576845394948291}}, {{
      2.757475084429733, 7.882673345303916}}, {{2.799717389628034, 
      8.152454393250705}}, {{2.8338014064077703`, 
      8.38181781398197}}}]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.0125], Thickness[0.005], 
      LineBox[{{1.7900914121273581`, 2.214846178686039}, {2.0706530356467567`,
        3.747384183486499}, {2.280339484046726, 4.924350925499243}, {
       2.4362414778067194`, 5.882542139883795}, {2.550226115908643, 
       6.61240387222545}, {2.6326080059353516`, 7.173912341688324}, {
       2.700018029404946, 7.576845394948291}, {2.757475084429733, 
       7.882673345303916}, {2.799717389628034, 8.152454393250705}, {
       2.8338014064077703`, 8.38181781398197}}]}}, {{}, {}}}, {{}, 
    {RGBColor[1, 0, 0], PointSize[0.0125], AbsoluteThickness[1.6], 
     GeometricTransformationBox[
      TagBox[InsetBox[
        StyleBox["\[EmptyCircle]",
         FontSize->12,
         FontColor->RGBColor[1, 0, 0]], {0., 0.}],
       "InsetString"], {{{0.6931471805599453, 3.8480176754522337`}}, {{
      1.0986122886681098`, 4.75531284441781}}, {{1.3862943611198906`, 
      5.436338664445412}}, {{1.6094379124341003`, 5.9730459615839635`}}, {{
      1.791759469228055, 6.461155627515417}}, {{1.9459101490553132`, 
      6.8680784618292385`}}, {{2.0794415416798357`, 7.305322614963161}}, {{
      2.302585092994046, 8.025843344150903}}, {{2.70805020110221, 
      9.566615235893575}}, {{2.995732273553991, 
      10.788081197667028`}}}]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.0125], AbsoluteThickness[1.6], 
      Dashing[{0.01, 0.01}], 
      LineBox[{{0.6931471805599453, 3.8480176754522337`}, {
       1.0986122886681098`, 4.75531284441781}, {1.3862943611198906`, 
       5.436338664445412}, {1.6094379124341003`, 5.9730459615839635`}, {
       1.791759469228055, 6.461155627515417}, {1.9459101490553132`, 
       6.8680784618292385`}, {2.0794415416798357`, 7.305322614963161}, {
       2.302585092994046, 8.025843344150903}, {2.70805020110221, 
       9.566615235893575}, {2.8828869755144413`, 
       10.308952660644293`}}]}}, {{}, {}}}, {{}, 
    {RGBColor[0, 0, 1], PointSize[0.0125], AbsoluteThickness[1.6], 
     GeometricTransformationBox[
      TagBox[InsetBox[
        StyleBox["\[EmptyCircle]",
         FontSize->12,
         FontColor->RGBColor[0, 0, 1]], {0., 0.}],
       "InsetString"], {{{1.791759469228055, 3.262318382711037}}, {{
      1.9459101490553132`, 3.858411235979497}}, {{2.0794415416798357`, 
      4.487512142519859}}, {{2.302585092994046, 5.570251082031678}}, {{
      2.70805020110221, 7.94111768244213}}, {{2.995732273553991, 
      9.743119249958013}}}]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.0125], AbsoluteThickness[1.6], 
      Dashing[{0.01, 0.01}], 
      LineBox[{{1.791759469228055, 3.262318382711037}, {1.9459101490553132`, 
       3.858411235979497}, {2.0794415416798357`, 4.487512142519859}, {
       2.302585092994046, 5.570251082031678}, {2.70805020110221, 
       7.94111768244213}, {2.995732273553991, 
       9.743119249958013}}]}}, {{}, {}}}},
  AspectRatio->0.9,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
        FormBox["1000", TraditionalForm], {0.01, 0.}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.206072645530174`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.611537753638338`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.206072645530174`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.611537753638338`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {{{
       0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
        FormBox["2", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {2.995732273553991, 
        FormBox["20", TraditionalForm], {0.01, 0.}}, {0.4054651081081644, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       0.4054651081081644, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{269.33333333333337`, Automatic},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 3.4011973816621555`}, {0., 10.308952660644293`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Input",ExpressionUUID->\
"ad826cc4-c792-4997-b5f7-beedb1db9226"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fig. S12(c) J(V) curves 160 nm beta-MADN devices", "Subsection",
 CellChangeTimes->{{3.9261369988842583`*^9, 3.926137024902232*^9}, {
  3.926138203569962*^9, 3.9261382237554054`*^9}, {3.934538194146787*^9, 
  3.9345382211831217`*^9}, {3.9347261560231304`*^9, 3.9347261602694116`*^9}, {
  3.97082035545655*^9, 3.9708203759066763`*^9}, {3.9708206532591915`*^9, 
  3.9708206682579875`*^9}, {3.9708210097017765`*^9, 3.9708210406098504`*^9}, {
  3.9708216632705*^9, 
  3.9708216831276035`*^9}},ExpressionUUID->"36763645-db87-4996-ae4a-\
befac5d5b3e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"J", 
     RowBox[{"(", "V", ")"}], " ", "curve", " ", "from", " ", "KMC", " ", 
     "simulations"}], ",", " ", 
    RowBox[{"296", " ", "K"}], ",", " ", 
    RowBox[{"160", " ", "nm"}], ",", " ", 
    RowBox[{"sigma_holes", " ", "=", " ", 
     RowBox[{"0.13", " ", "eV"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"fac", "=", "8."}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"prefactor", " ", "f"}], ",", " ", 
     RowBox[{"See", " ", 
      RowBox[{"Eq", ".", " ", "S1"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabJV296betaMADNKMC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"fac", "*", "4.6"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"fac", "*", "9.4"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", 
         RowBox[{"fac", "*", "21.1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", 
         RowBox[{"fac", "*", "39.1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{"fac", "*", "72"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", 
         RowBox[{"fac", "*", "106"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", 
         RowBox[{"fac", "*", "175"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", 
         RowBox[{"fac", "*", "402"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", 
         RowBox[{"fac", "*", "2282"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", 
         RowBox[{"fac", "*", "10593"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"J", 
      RowBox[{"(", "V", ")"}], " ", "curve", " ", "from", " ", "KMC", " ", 
      "simulations"}], ",", " ", 
     RowBox[{"210", " ", "K"}], ",", " ", 
     RowBox[{"160", " ", "nm"}], ",", " ", 
     RowBox[{"sigma_holes", " ", "=", " ", 
      RowBox[{"0.13", " ", "eV"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabJV210betaMADNKMC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{"fac", "*", "2.2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", 
         RowBox[{"fac", "*", "3.35"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", 
         RowBox[{"fac", "*", "6.9"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", 
         RowBox[{"fac", "*", "21.7"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", 
         RowBox[{"fac", "*", "289"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", 
         RowBox[{"fac", "*", "2631"}]}], "}"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.970821288166232*^9, 3.9708212930988293`*^9}, {
  3.970821329643611*^9, 3.970821457577593*^9}, {3.970821635480569*^9, 
  3.970821635991121*^9}, {3.970821775728103*^9, 
  3.9708217759254026`*^9}},ExpressionUUID->"37205b10-f32d-4e26-8ab0-\
e2885b250203"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Figure", " ", "S12", 
   RowBox[{"(", "c", ")"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.970821742868639*^9, 
  3.970821748775776*^9}},ExpressionUUID->"2db5adf0-eb24-498a-8c48-\
a85be4cab1e9"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[1, 0, 0], PointSize[0.0125], Thickness[0.01], 
     GeometricTransformationBox[
      TagBox[InsetBox[
        StyleBox["\[FilledDiamond]",
         FontSize->12,
         FontColor->RGBColor[1, 0, 0]], {0., 0.}],
       "InsetString"], {{{0.6780335427498971, 3.0411835364579085`}}, {{
      1.3297240096314962`, 4.9305092496169705`}}, {{1.665818245870208, 
      6.096117312369572}}, {{1.8687205103641833`, 6.854227911964328}}, {{
      2.0149030205422647`, 7.35603080338901}}, {{2.1126345090356, 
      7.754837401813953}}, {{2.203869120054888, 8.03611729017668}}, {{
      2.2700619012884857`, 8.281083441086814}}, {{2.333114298028869, 
      8.477520536152504}}, {{2.392425796993835, 8.642003919338183}}, {{
      2.4414770918606643`, 8.79016103866792}}, {{2.481567748522486, 
      8.92612029987958}}}]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.0125], Thickness[0.005], 
      LineBox[{{0.6780335427498971, 3.0411835364579085`}, {
       1.3297240096314962`, 4.9305092496169705`}, {1.665818245870208, 
       6.096117312369572}, {1.8687205103641833`, 6.854227911964328}, {
       2.0149030205422647`, 7.35603080338901}, {2.1126345090356, 
       7.754837401813953}, {2.203869120054888, 8.03611729017668}, {
       2.2700619012884857`, 8.281083441086814}, {2.333114298028869, 
       8.477520536152504}, {2.392425796993835, 8.642003919338183}, {
       2.4414770918606643`, 8.79016103866792}, {2.481567748522486, 
       8.92612029987958}}]}}, {{}, {}}}, {{}, 
    {RGBColor[0, 0, 1], PointSize[0.0125], Thickness[0.005], 
     GeometricTransformationBox[
      TagBox[InsetBox[
        StyleBox["\[FilledDiamond]",
         FontSize->12,
         FontColor->RGBColor[0, 0, 1]], {0., 0.}],
       "InsetString"], {{{1.7900914121273581`, 2.214846178686039}}, {{
      2.0706530356467567`, 3.747384183486499}}, {{2.280339484046726, 
      4.924350925499243}}, {{2.4362414778067194`, 5.882542139883795}}, {{
      2.550226115908643, 6.61240387222545}}, {{2.6326080059353516`, 
      7.173912341688324}}, {{2.700018029404946, 7.576845394948291}}, {{
      2.757475084429733, 7.882673345303916}}, {{2.799717389628034, 
      8.152454393250705}}, {{2.8338014064077703`, 
      8.38181781398197}}}]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.0125], Thickness[0.005], 
      LineBox[{{1.7900914121273581`, 2.214846178686039}, {2.0706530356467567`,
        3.747384183486499}, {2.280339484046726, 4.924350925499243}, {
       2.4362414778067194`, 5.882542139883795}, {2.550226115908643, 
       6.61240387222545}, {2.6326080059353516`, 7.173912341688324}, {
       2.700018029404946, 7.576845394948291}, {2.757475084429733, 
       7.882673345303916}, {2.799717389628034, 8.152454393250705}, {
       2.8338014064077703`, 8.38181781398197}}]}}, {{}, {}}}, {{}, 
    {RGBColor[1, 0, 0], PointSize[0.0125], AbsoluteThickness[1.6], 
     Dashing[{0.01, 0.01}], GeometricTransformationBox[
      TagBox[InsetBox[
        StyleBox["\[EmptyCircle]",
         FontSize->12,
         FontColor->RGBColor[1, 0, 0]], {0., 0.}],
       "InsetString"], {{{0.6931471805599453, 3.6054978451748854`}}, {{
      1.0986122886681098`, 4.320151230955794}}, {{1.3862943611198906`, 
      5.128714582161857}}, {{1.6094379124341003`, 5.745564008671156}}, {{
      1.791759469228055, 6.3561076606958915`}}, {{1.9459101490553132`, 
      6.742880635791903}}, {{2.0794415416798357`, 7.24422751560335}}, {{
      2.302585092994046, 8.075893630298857}}, {{2.70805020110221, 
      9.812249072101856}}, {{2.995732273553991, 
      11.347390226276332`}}}]}, {{}, {}}}, {{}, 
    {RGBColor[0, 0, 1], PointSize[0.0125], AbsoluteThickness[1.6], 
     Dashing[{0.01, 0.01}], GeometricTransformationBox[
      TagBox[InsetBox[
        StyleBox["\[EmptyCircle]",
         FontSize->12,
         FontColor->RGBColor[0, 0, 1]], {0., 0.}],
       "InsetString"], {{{1.791759469228055, 2.8678989020441064`}}, {{
      1.9459101490553132`, 3.288401887516811}}, {{2.0794415416798357`, 
      4.01096295328305}}, {{2.302585092994046, 5.15675380222625}}, {{
      2.70805020110221, 7.7458682297922685`}}, {{2.995732273553991, 
      9.95456082272013}}}]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.0125], AbsoluteThickness[1.6], 
      Dashing[{0.01, 0.01}], 
      LineBox[{{0.6931471805599453, 3.6054978451748854`}, {
       1.0986122886681098`, 4.320151230955794}, {1.3862943611198906`, 
       5.128714582161857}, {1.6094379124341003`, 5.745564008671156}, {
       1.791759469228055, 6.3561076606958915`}, {1.9459101490553132`, 
       6.742880635791903}, {2.0794415416798357`, 7.24422751560335}, {
       2.302585092994046, 8.075893630298857}, {2.70805020110221, 
       9.812249072101856}, {2.8011313600285797`, 
       10.308952660644293`}}]}}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.0125], AbsoluteThickness[1.6], 
      Dashing[{0.01, 0.01}], 
      LineBox[{{1.791759469228055, 2.8678989020441064`}, {1.9459101490553132`,
        3.288401887516811}, {2.0794415416798357`, 4.01096295328305}, {
       2.302585092994046, 5.15675380222625}, {2.70805020110221, 
       7.7458682297922685`}, {2.995732273553991, 
       9.95456082272013}}]}}, {{}, {}}}},
  AspectRatio->0.9,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
        FormBox["1000", TraditionalForm], {0.01, 0.}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.206072645530174`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.611537753638338`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.206072645530174`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.611537753638338`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {{{
       0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
        FormBox["2", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {2.995732273553991, 
        FormBox["20", TraditionalForm], {0.01, 0.}}, {0.4054651081081644, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       0.4054651081081644, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{269.33333333333337`, Automatic},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 3.4011973816621555`}, {0., 10.308952660644293`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Input",ExpressionUUID->\
"dfbb8ecb-e4fd-407d-ae81-4fc69bf86795"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1440, 831.75},
WindowMargins->{{-6, Automatic}, {Automatic, -6}},
TaggingRules-><|"TryRealOnly" -> False|>,
Magnification:>1. Inherited,
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"d6017423-d7ea-4ebb-9331-83dbb49e99f1"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 208, 4, 67, "Section",ExpressionUUID->"95ca8d0f-f0c2-43f2-9b55-24a9fbb6c8e5"],
Cell[791, 28, 559, 19, 55, "Subsection",ExpressionUUID->"fa51468f-589b-4d15-8aef-61663bebbb66"],
Cell[CellGroupData[{
Cell[1375, 51, 553, 8, 38, "Subsection",ExpressionUUID->"30abeb6d-17a7-46b2-bb7d-22f0d417268e"],
Cell[1931, 61, 12562, 248, 257, "Input",ExpressionUUID->"dd996736-44a4-4c03-8c02-fe7186ae1543"],
Cell[CellGroupData[{
Cell[14518, 313, 248, 6, 28, "Input",ExpressionUUID->"e7c67c41-0eae-4bc0-80de-f30b6fb060f0"],
Cell[14769, 321, 75584, 1622, 245, "Print",ExpressionUUID->"f92695bc-244f-4966-8d0a-566a089c4069"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[90402, 1949, 556, 8, 54, "Subsection",ExpressionUUID->"45a9f283-b61f-4526-8361-72ad412c2cc4"],
Cell[90961, 1959, 5646, 155, 243, "Input",ExpressionUUID->"2b50a27b-02c6-474a-a8af-2df3de9d8171"],
Cell[96610, 2116, 248, 6, 28, "Input",ExpressionUUID->"b2c031e9-6dde-4212-b8eb-eefb0249dc73"],
Cell[96861, 2124, 22078, 505, 247, "Input",ExpressionUUID->"ad826cc4-c792-4997-b5f7-beedb1db9226"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118976, 2634, 552, 8, 54, "Subsection",ExpressionUUID->"36763645-db87-4996-ae4a-befac5d5b3e9"],
Cell[119531, 2644, 3169, 89, 105, "Input",ExpressionUUID->"37205b10-f32d-4e26-8ab0-e2885b250203"],
Cell[122703, 2735, 246, 6, 28, "Input",ExpressionUUID->"2db5adf0-eb24-498a-8c48-a85be4cab1e9"],
Cell[122952, 2743, 22124, 505, 247, "Input",ExpressionUUID->"dfbb8ecb-e4fd-407d-ae81-4fc69bf86795"]
}, Open  ]]
}, Open  ]]
}
]
*)

