(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     52306,       1387]
NotebookOptionsPosition[     51471,       1364]
NotebookOutlinePosition[     51902,       1381]
CellTagsIndexPosition[     51859,       1378]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Figure 8", "Section",
 CellChangeTimes->{{3.9704904839763684`*^9, 
  3.97049048780785*^9}},ExpressionUUID->"9f842f1e-c66d-4996-9a94-\
a8929be8cfe7"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Figures 8(a) and 8(b) - Sensitivity of the FID curves \
for \[Alpha]-MADN to a variation of the simulation parameters.\nData format: \
{voltage (V), normalized PL efficiency}", "Subsection"]], "Section",
 CellChangeTimes->{{3.9237507185965595`*^9, 3.923750726285319*^9}, {
  3.9703058772842503`*^9, 3.970305914941142*^9}, {3.9703061859450207`*^9, 
  3.970306186806161*^9}, {3.970306466890758*^9, 3.970306508217021*^9}, {
  3.9703070802027197`*^9, 
  3.9703071195610013`*^9}},ExpressionUUID->"a1372411-a43c-41fa-8f75-\
6a8f2efe2d20"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Experimemtal", " ", "FID", " ", "data"}], ",", " ", 
    RowBox[{"closed", " ", 
     RowBox[{"spheres", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tabalphaMADNexpt", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", " ", "0.89495", ",", " ", "0.01", ",", " ",
          "0.89495"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45.00315"}], ",", " ", "0.91896", ",", " ", "0.01", 
         ",", " ", "0.91896"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40.11024"}], ",", " ", "0.9416", ",", " ", "0.01", ",",
          " ", "0.9416"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35.06651"}], ",", " ", "0.95943", ",", " ", "0.01", 
         ",", " ", "0.95943"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30.09517"}], ",", " ", "0.97314", ",", " ", "0.01", 
         ",", " ", "0.97314"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "24.97343"}], ",", " ", "0.98296", ",", " ", "0.01", 
         ",", " ", "0.98296"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20.07181"}], ",", " ", "0.98683", ",", " ", "0.01", 
         ",", " ", "0.988"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15.02022"}], ",", " ", "0.98772", ",", " ", "0.01", 
         ",", " ", "0.993"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10.11955"}], ",", " ", "0.99365", ",", " ", "0.01", 
         ",", " ", "0.996"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5.06796"}], ",", " ", "0.99454", ",", " ", "0.01", ",",
          " ", "0.998"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2.09895"}], ",", " ", "1.00048", ",", " ", "0.01", ",",
          " ", "0.999"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1.00001", ",", " ", "0.01", ",", "1.00001"}], 
        "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"result", " ", "for", " ", "sigma_exc"}], " ", "=", " ", 
      RowBox[{"0.05", " ", "eV", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"reference", " ", "case", " ", "with", " ", "taurad"}], " ", 
         "=", " ", 
         RowBox[{"10", " ", "ns"}]}], ")"}]}]}], ",", " ", 
     RowBox[{"model", " ", "2"}], ",", " ", 
     RowBox[{"thick", " ", "dashed", " ", "curve"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPLref1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.0316`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.04699`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.0702`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.10593`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.1526`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.21451`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.2958`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.38692`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.4882`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.58911`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.6885`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.78297`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.8631`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.92294`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.967`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.9967`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "result", " ", "for", " ", "the", " ", "reference", " ", "parameters"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"but", " ", "with", " ", "taurad"}], " ", "=", " ", 
      RowBox[{"0.45", " ", 
       RowBox[{"ns", ".", " ", "Thin"}], " ", "dashed", " ", 
       RowBox[{"curve", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPLref2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.22866`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.35252`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.50981`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.66765`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.8163`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.87943`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.92726`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.95998`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.98207`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.9931`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.99774`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.99999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "result", " ", "for", " ", "the", " ", "reference", " ", "parameters"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"but", " ", "with", " ", "taurad"}], " ", "=", " ", 
      RowBox[{
       RowBox[{"0.45", " ", "ns", " ", "and", " ", "epsilonr"}], " ", "=", 
       " ", 
       RowBox[{
        RowBox[{"3.2", ".", " ", "Dashed"}], "-", 
        RowBox[{"dotted", " ", 
         RowBox[{"curve", "."}]}]}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPLref3", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.28865`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.43249`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.5913`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.73997`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.86528`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.95076`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.98859`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.99855`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.99996`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "result", " ", "for", " ", "the", " ", "reference", " ", "parameters"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"but", " ", "with", " ", "taurad"}], " ", "=", " ", 
      RowBox[{"0.45", " ", "ns"}]}], ",", " ", 
     RowBox[{"epsilonr", " ", "=", " ", 
      RowBox[{"3.2", " ", "and", " ", "RF", "  ", "1.5", " ", 
       RowBox[{"nm", ".", " ", "Dotted"}], " ", 
       RowBox[{"curve", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPLref4", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.19633`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.24618`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.30648`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.38183`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.47065`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.56645`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.66813`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.76125`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.84793`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.9135`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.95755`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.9828`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.99409`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.99971`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.99997`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99998`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "result", " ", "for", " ", "the", " ", "reference", " ", "parameters"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"but", " ", "with", " ", "taurad"}], " ", "=", " ", 
      RowBox[{"0.45", " ", "ns"}]}], ",", " ", 
     RowBox[{"epsilonr", " ", "=", " ", "3.2"}], ",", " ", 
     RowBox[{"RF", "  ", "1.5", " ", "nm"}], ",", " ", 
     RowBox[{
      RowBox[{"sigma_h", 
       RowBox[{"(", "e", ")"}]}], " ", "=", " ", 
      RowBox[{"0.10", " ", 
       RowBox[{"(", "0.14", ")"}], " ", 
       RowBox[{"eV", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Thick", " ", "magenta", " ", "curve"}], ",", " ", 
     RowBox[{"panels", " ", 
      RowBox[{"(", "a", ")"}], " ", "and", " ", 
      RowBox[{"(", "b", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPL10a", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.16081`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.19845`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.23876`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.29159`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.35385`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.42325`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.50505`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.59199`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.68118`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.76745`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.84325`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.90638`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.94859`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.97706`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.99146`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.99925`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99998`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "result", " ", "for", " ", "the", " ", "reference", " ", "parameters"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"but", " ", "with", " ", "taurad"}], " ", "=", " ", 
      RowBox[{"0.45", " ", "ns"}]}], ",", " ", 
     RowBox[{"epsilonr", " ", "=", " ", "3.2"}], ",", " ", 
     RowBox[{"RF", "  ", "1.5", " ", "nm"}], ",", " ", 
     RowBox[{
      RowBox[{"sigma_h", 
       RowBox[{"(", "e", ")"}]}], " ", "=", " ", 
      RowBox[{"0.10", " ", 
       RowBox[{"(", "0.14", ")"}], " ", 
       RowBox[{"eV", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Eexcb", " ", "=", " ", 
      RowBox[{"1.1", " ", "eV"}]}], ",", " ", 
     RowBox[{"Thick", " ", "green", " ", "curve"}], ",", " ", 
     RowBox[{"panel", " ", 
      RowBox[{"(", "b", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPL11a", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.34578`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.41384`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.4888`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.56708`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.64938`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.72483`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.79866`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.86142`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.91011`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.94894`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.97411`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.98749`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.99494`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.9984`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.99942`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "25"}], ",", "0.99986`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.99909`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "result", " ", "for", " ", "the", " ", "reference", " ", "parameters"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"but", " ", "with", " ", "taurad"}], " ", "=", " ", 
      RowBox[{"0.45", " ", "ns"}]}], ",", " ", 
     RowBox[{"epsilonr", " ", "=", " ", "3.2"}], ",", " ", 
     RowBox[{"RF", "  ", "1.5", " ", "nm"}], ",", " ", 
     RowBox[{
      RowBox[{"sigma_h", 
       RowBox[{"(", "e", ")"}]}], " ", "=", " ", 
      RowBox[{"0.10", " ", 
       RowBox[{"(", "0.14", ")"}], " ", 
       RowBox[{"eV", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Eexcb", " ", "=", " ", 
      RowBox[{"0.9", " ", "eV"}]}], ",", " ", 
     RowBox[{"thick", " ", "blue", " ", "curve"}], ",", " ", 
     RowBox[{"panel", " ", 
      RowBox[{"(", "b", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPL09a", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.07605`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.09146`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.10798`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.13304`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.15919`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.196`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.24294`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.29229`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.36385`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.44828`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.53583`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.64063`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.74539`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.84253`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.91959`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "25"}], ",", "0.96556`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.98897`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15"}], ",", "0.99749`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99979`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.923750819193486*^9, 3.923750875136276*^9}, {
   3.923750908862853*^9, 3.9237512523270197`*^9}, {3.9237522910349855`*^9, 
   3.9237524798960238`*^9}, {3.9237526363639307`*^9, 3.92375268254186*^9}, {
   3.923752713629755*^9, 3.923752806257427*^9}, {3.923752842755101*^9, 
   3.9237529840625978`*^9}, {3.9237530745504704`*^9, 
   3.9237530757157097`*^9}, {3.9237533328254633`*^9, 
   3.9237534011702433`*^9}, {3.923753525264427*^9, 3.923753722711417*^9}, {
   3.9237543750559764`*^9, 3.9237544726565523`*^9}, {3.923762249419099*^9, 
   3.9237622914149404`*^9}, {3.923762488015709*^9, 3.923762509753824*^9}, {
   3.923762700268732*^9, 3.923762710340501*^9}, {3.923762828958853*^9, 
   3.9237628313942814`*^9}, {3.923763019725277*^9, 3.923763081675411*^9}, {
   3.9237632003966904`*^9, 3.9237632059098425`*^9}, {3.9237634804101133`*^9, 
   3.923763573710225*^9}, {3.923763627355791*^9, 3.923763675945402*^9}, {
   3.9237640519820848`*^9, 3.9237641830718665`*^9}, {3.92376435933626*^9, 
   3.923764475017749*^9}, {3.923805492342395*^9, 3.9238056985366893`*^9}, {
   3.923806614814147*^9, 3.923806759022026*^9}, {3.9238067934334755`*^9, 
   3.9238067982299356`*^9}, {3.923806980031822*^9, 3.9238069819533896`*^9}, {
   3.9238072159079876`*^9, 3.923807258677023*^9}, {3.923810122876378*^9, 
   3.9238101322855964`*^9}, {3.923810171682138*^9, 3.9238102448624797`*^9}, 
   3.923810278359837*^9, {3.9238103330138845`*^9, 3.92381038764215*^9}, {
   3.923810448430422*^9, 3.9238104675744543`*^9}, {3.9238105085819435`*^9, 
   3.9238105175018873`*^9}, {3.923810561494194*^9, 3.923810585000399*^9}, {
   3.923810637135619*^9, 3.923810640327029*^9}, {3.9238106771875343`*^9, 
   3.9238106824219294`*^9}, {3.9238107279141855`*^9, 
   3.9238107510042706`*^9}, {3.9238108143371134`*^9, 
   3.9238108261288447`*^9}, {3.9238108726346626`*^9, 
   3.9238109573666925`*^9}, {3.923811258714841*^9, 3.9238112666661854`*^9}, {
   3.923844608440095*^9, 3.9238446138529196`*^9}, {3.923844667291856*^9, 
   3.9238446702524047`*^9}, {3.923890410303314*^9, 3.923890414111866*^9}, {
   3.9238904488786774`*^9, 3.9238905721430397`*^9}, {3.9238906429807568`*^9, 
   3.923890691236092*^9}, {3.9354006695316963`*^9, 3.9354006700636873`*^9}, {
   3.9354007375276823`*^9, 3.935400740683745*^9}, {3.9354007746343036`*^9, 
   3.9354007765392027`*^9}, {3.9354010623213606`*^9, 3.935401144556381*^9}, {
   3.9354011930932927`*^9, 3.9354013896961894`*^9}, {3.93540145593836*^9, 
   3.9354017955253067`*^9}, {3.9593322969386625`*^9, 3.959332309053418*^9}, {
   3.9593323432203164`*^9, 3.9593323522532187`*^9}, {3.959332382653558*^9, 
   3.9593323829717274`*^9}, {3.9593327829707603`*^9, 
   3.9593328118707113`*^9}, {3.959332842953947*^9, 3.959332848866299*^9}, {
   3.9593330165099106`*^9, 3.959333022577344*^9}, {3.9593331060708323`*^9, 
   3.959333127760204*^9}, {3.9593400423368573`*^9, 3.9593400744704747`*^9}, {
   3.9593980621885157`*^9, 3.959398081906412*^9}, {3.959418131361392*^9, 
   3.9594181347033467`*^9}, {3.97030598963413*^9, 3.970305997905985*^9}, {
   3.9703062081815643`*^9, 3.9703062220806785`*^9}, {3.970306298431449*^9, 
   3.9703064129992247`*^9}, {3.970306523250759*^9, 3.9703067292351203`*^9}, {
   3.9703067594186373`*^9, 3.9703068623186584`*^9}, {3.970307033791144*^9, 
   3.9703070730282817`*^9}, {3.970307132176118*^9, 3.970307219069336*^9}, {
   3.9703078100759573`*^9, 
   3.9703078116570444`*^9}},ExpressionUUID->"6ddb85af-8c0b-4f4a-b128-\
9f692a786b1d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Figures 8(c) and 8(d) - Sensitivity of the FID curves \
for \[Beta]-MADN to a variation of the simulation parameters.\nData format: \
{voltage (V), normalized PL efficiency}", "Subsection"]], "Section",
 CellChangeTimes->{{3.9237507185965595`*^9, 3.923750726285319*^9}, {
  3.9703058772842503`*^9, 3.970305914941142*^9}, {3.9703061859450207`*^9, 
  3.970306186806161*^9}, {3.970306466890758*^9, 3.970306508217021*^9}, {
  3.9703070802027197`*^9, 3.9703071195610013`*^9}, {3.9703072552527704`*^9, 
  3.9703072720626626`*^9}},ExpressionUUID->"661879ef-4971-4ae1-a074-\
b67572ff954d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Experimemtal", " ", "FID", " ", 
    RowBox[{"data", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tabbetaMADNexpt", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", " ", "0.906", ",", " ", "0.01", ",", " ", 
         "0.906"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45.00315"}], ",", " ", "0.93", ",", " ", "0.01", ",", 
         " ", "0.93"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40.11024"}], ",", " ", "0.94", ",", " ", "0.01", ",", 
         " ", "0.94"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35.06651"}], ",", " ", "0.958", ",", " ", "0.01", ",", 
         " ", "0.958"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30.09517"}], ",", " ", "0.963", ",", " ", "0.01", ",", 
         " ", "0.963"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "24.97343"}], ",", " ", "0.975", ",", " ", "0.01", ",", 
         " ", "0.975"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20.07181"}], ",", " ", "0.986", ",", " ", "0.01", ",", 
         " ", "0.986"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15.02022"}], ",", " ", "1", ",", " ", "0.01", ",", " ",
          "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10.11955"}], ",", " ", "0.992", ",", " ", "0.01", ",", 
         " ", "0.992"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5.06796"}], ",", " ", "1.008", ",", " ", "0.01", ",", 
         " ", "1.008"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2.09895"}], ",", " ", "1", ",", " ", "0.01", ",", " ", 
         "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0.01", ",", " ", "1"}], 
        "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"result", " ", "for", " ", "sigma_exc"}], " ", "=", " ", 
      RowBox[{"0.05", " ", "eV", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"reference", " ", "case", " ", "with", " ", "taurad"}], " ", 
         "=", " ", 
         RowBox[{"10", " ", "ns"}]}], ")"}]}]}], ",", " ", 
     RowBox[{"model", " ", "2.", " ", "Thick", " ", "dashed", " ", 
      RowBox[{"curve", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPLref1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.0316`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.04699`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.0702`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.10593`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.1526`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.21451`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.2958`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.38692`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.4882`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.58911`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.6885`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.78297`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.8631`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.92294`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.967`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.9967`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "result", " ", "for", " ", "the", " ", "reference", " ", "parameters"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"but", " ", "with", " ", "taurad"}], " ", "=", " ", 
      RowBox[{"0.30", " ", "ns"}]}], ",", " ", 
     RowBox[{"Excb", " ", "=", " ", 
      RowBox[{"1.0", " ", "V"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Thin", " ", "dashed", " ", 
     RowBox[{"curve", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPLref2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.28601`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.34429`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.41131`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.48029`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.55488`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.62788`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.7005`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.77156`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.83446`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.88884`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.93186`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.96327`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.98263`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.99305`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.99771`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "25"}], ",", "0.99937`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.99988`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15"}], ",", "0.99999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "0.99999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "result", " ", "for", " ", "the", " ", "reference", " ", "parameters"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"but", " ", "with", " ", "taurad"}], " ", "=", " ", 
      RowBox[{"0.30", " ", "ns"}]}], ",", " ", 
     RowBox[{"sigma_exc", " ", "=", " ", 
      RowBox[{"0.07", " ", "V"}]}], ",", " ", 
     RowBox[{
      RowBox[{"epsilonr", "  ", 
       RowBox[{"3.12", ".", " ", "Dashed"}]}], "-", 
      RowBox[{"dotted", " ", 
       RowBox[{"curve", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPLref3", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.28601`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.34429`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.41131`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.48029`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.55488`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.62788`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.7005`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.77156`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.83446`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.88884`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.93186`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.96327`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.98263`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.99305`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.99771`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "25"}], ",", "0.99937`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.99988`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15"}], ",", "0.99999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "0.99999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "result", " ", "for", " ", "the", " ", "reference", " ", "parameters"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"but", " ", "with", " ", "taurad"}], " ", "=", " ", 
      RowBox[{"0.30", " ", "ns"}]}], ",", " ", 
     RowBox[{"sigma_exc", " ", "=", " ", 
      RowBox[{"0.07", " ", "V"}]}], ",", " ", 
     RowBox[{
      RowBox[{"epsilonr", "  ", "3.12", " ", "and", " ", "RF"}], " ", "=", 
      " ", 
      RowBox[{"1.35", " ", 
       RowBox[{"nm", ".", " ", "Dotted"}], " ", 
       RowBox[{"curve", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPLref4", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.32015`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.38464`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.46318`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.54966`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.63136`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.71405`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.79417`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.85761`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.91168`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.95097`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.97393`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.98953`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.9962`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.99888`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.99968`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "25"}], ",", "0.99989`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.99998`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15"}], ",", "0.99999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "result", " ", "for", " ", "the", " ", "reference", " ", "parameters"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"but", " ", "with", " ", "taurad"}], " ", "=", " ", 
      RowBox[{"0.30", " ", "ns"}]}], ",", " ", 
     RowBox[{"epsilonr", " ", "=", " ", "3.12"}], ",", " ", 
     RowBox[{"RF", "  ", "1.5", " ", "nm"}], ",", " ", 
     RowBox[{
      RowBox[{"sigma_h", 
       RowBox[{"(", "e", ")"}]}], " ", "=", " ", 
      RowBox[{"0.13", " ", 
       RowBox[{"(", "0.19", ")"}], " ", "eV"}]}], ",", " ", 
     RowBox[{"Excb", " ", "=", " ", 
      RowBox[{"1.0", " ", "V"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Magenta", " ", "curve", " ", "in", " ", "panels", " ", 
     RowBox[{"(", "c", ")"}], " ", "and", " ", 
     RowBox[{
      RowBox[{"(", "d", ")"}], "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPL10a", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.20606`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.2363`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.27197`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.30934`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.35523`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.40066`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.45743`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.51203`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.56658`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.63043`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.68702`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.74667`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.80631`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.86002`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.90885`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "25"}], ",", "0.94745`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.97599`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15"}], ",", "0.99238`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99866`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "0.99991`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "result", " ", "for", " ", "the", " ", "reference", " ", "parameters"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"but", " ", "with", " ", "taurad"}], " ", "=", " ", 
      RowBox[{"0.30", " ", "ns"}]}], ",", " ", 
     RowBox[{"epsilonr", " ", "=", " ", "3.12"}], ",", " ", 
     RowBox[{"RF", "  ", "1.5", " ", "nm"}], ",", " ", 
     RowBox[{
      RowBox[{"sigma_h", 
       RowBox[{"(", "e", ")"}]}], " ", "=", " ", 
      RowBox[{"0.13", " ", 
       RowBox[{"(", "0.19", ")"}], " ", "eV"}]}], ",", " ", 
     RowBox[{"Excb", " ", "=", " ", 
      RowBox[{"1.1", " ", "V"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Green", " ", "curve", " ", "in", " ", "panel", " ", 
     RowBox[{"(", "d", ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPL11a", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.35829`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.4081`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.45926`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.51331`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.57028`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.63236`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.68534`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.73951`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.79045`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.83722`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.88038`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.91048`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.94222`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.96344`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.98`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "25"}], ",", "0.99093`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.99627`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15"}], ",", "0.99919`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99985`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "0.99999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "result", " ", "for", " ", "the", " ", "reference", " ", "parameters"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"but", " ", "with", " ", "taurad"}], " ", "=", " ", 
      RowBox[{"0.30", " ", "ns"}]}], ",", " ", 
     RowBox[{"epsilonr", " ", "=", " ", "3.12"}], ",", " ", 
     RowBox[{"RF", "  ", "1.5", " ", "nm"}], ",", " ", 
     RowBox[{
      RowBox[{"sigma_h", 
       RowBox[{"(", "e", ")"}]}], " ", "=", " ", 
      RowBox[{"0.13", " ", 
       RowBox[{"(", "0.19", ")"}], " ", "eV"}]}], ",", " ", 
     RowBox[{"Excb", " ", "=", " ", 
      RowBox[{"1.2", " ", "V"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Red", " ", "curve", " ", "in", " ", "panel", " ", 
     RowBox[{"(", "d", ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPL12a", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.56892`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "95"}], ",", "0.62231`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.67849`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "85"}], ",", "0.73013`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.7795`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "75"}], ",", "0.82164`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.86085`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "65"}], ",", "0.89506`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.92436`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "55"}], ",", "0.94746`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.96373`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "45"}], ",", "0.97653`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.987`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "35"}], ",", "0.9936`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.9967`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "25"}], ",", "0.99866`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.99949`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15"}], ",", "0.99988`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.99998`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "0.99999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.923750819193486*^9, 3.923750875136276*^9}, {
   3.923750908862853*^9, 3.9237512523270197`*^9}, {3.9237522910349855`*^9, 
   3.9237524798960238`*^9}, {3.9237526363639307`*^9, 3.92375268254186*^9}, {
   3.923752713629755*^9, 3.923752806257427*^9}, {3.923752842755101*^9, 
   3.9237529840625978`*^9}, {3.9237530745504704`*^9, 
   3.9237530757157097`*^9}, {3.9237533328254633`*^9, 
   3.9237534011702433`*^9}, {3.923753525264427*^9, 3.923753722711417*^9}, {
   3.9237543750559764`*^9, 3.9237544726565523`*^9}, {3.923762249419099*^9, 
   3.9237622914149404`*^9}, {3.923762488015709*^9, 3.923762509753824*^9}, {
   3.923762700268732*^9, 3.923762710340501*^9}, {3.923762828958853*^9, 
   3.9237628313942814`*^9}, {3.923763019725277*^9, 3.923763081675411*^9}, {
   3.9237632003966904`*^9, 3.9237632059098425`*^9}, {3.9237634804101133`*^9, 
   3.923763573710225*^9}, {3.923763627355791*^9, 3.923763675945402*^9}, {
   3.9237640519820848`*^9, 3.9237641830718665`*^9}, {3.92376435933626*^9, 
   3.923764475017749*^9}, {3.923805492342395*^9, 3.9238056985366893`*^9}, {
   3.923806614814147*^9, 3.923806759022026*^9}, {3.9238067934334755`*^9, 
   3.9238067982299356`*^9}, {3.923806980031822*^9, 3.9238069819533896`*^9}, {
   3.9238072159079876`*^9, 3.923807258677023*^9}, {3.923810122876378*^9, 
   3.9238101322855964`*^9}, {3.923810171682138*^9, 3.9238102448624797`*^9}, 
   3.923810278359837*^9, {3.9238103330138845`*^9, 3.92381038764215*^9}, {
   3.923810448430422*^9, 3.9238104675744543`*^9}, {3.9238105085819435`*^9, 
   3.9238105175018873`*^9}, {3.923810561494194*^9, 3.923810585000399*^9}, {
   3.923810637135619*^9, 3.923810640327029*^9}, {3.9238106771875343`*^9, 
   3.9238106824219294`*^9}, {3.9238107279141855`*^9, 
   3.9238107510042706`*^9}, {3.9238108143371134`*^9, 
   3.9238108261288447`*^9}, {3.9238108726346626`*^9, 
   3.9238109573666925`*^9}, {3.923811258714841*^9, 3.9238112666661854`*^9}, {
   3.9238113468665133`*^9, 3.9238113535885925`*^9}, {3.923811611267658*^9, 
   3.9238116511762805`*^9}, {3.923823282956459*^9, 3.9238233329446025`*^9}, {
   3.9238239580624657`*^9, 3.9238240232440996`*^9}, {3.9238247243065653`*^9, 
   3.9238247794146414`*^9}, {3.92382494805203*^9, 3.923825109379575*^9}, {
   3.9238252012964735`*^9, 3.923825227270499*^9}, {3.9238253018064938`*^9, 
   3.9238253977622356`*^9}, {3.9238254607072225`*^9, 3.923825629018239*^9}, 
   3.9238256658866262`*^9, {3.9238257593748164`*^9, 3.9238257597755203`*^9}, {
   3.923828662475346*^9, 3.9238288241437216`*^9}, {3.9238288595211425`*^9, 
   3.9238288722823887`*^9}, {3.9238302586482954`*^9, 
   3.9238302937484856`*^9}, {3.923830574861334*^9, 3.9238306444722414`*^9}, {
   3.9238310277418485`*^9, 3.923831162227667*^9}, {3.9238311971803083`*^9, 
   3.92383120299531*^9}, {3.923831711009231*^9, 3.92383181836794*^9}, {
   3.923838947001516*^9, 3.9238390681716228`*^9}, {3.9238393913727007`*^9, 
   3.923839491161719*^9}, {3.923841093417432*^9, 3.9238412370126853`*^9}, {
   3.9238413956111927`*^9, 3.923841396428725*^9}, {3.9238418410809617`*^9, 
   3.9238419060463886`*^9}, {3.923843645286763*^9, 3.923843646411313*^9}, {
   3.9238436790042353`*^9, 3.9238437529525337`*^9}, {3.923843799034911*^9, 
   3.92384390890615*^9}, {3.923844080529893*^9, 3.9238441026831155`*^9}, {
   3.92384423145642*^9, 3.9238442654489317`*^9}, {3.923844373878324*^9, 
   3.9238443747809563`*^9}, {3.923844442208313*^9, 3.923844517429344*^9}, {
   3.923844552419667*^9, 3.9238445570614986`*^9}, {3.9238446949035196`*^9, 
   3.9238446970718207`*^9}, {3.9238451667944546`*^9, 
   3.9238452168598585`*^9}, {3.923845432639787*^9, 3.9238454805885525`*^9}, {
   3.9238459966648397`*^9, 3.9238460167921343`*^9}, {3.923846156158827*^9, 
   3.923846164723032*^9}, {3.923890607636083*^9, 3.9238906099093037`*^9}, {
   3.923891461148693*^9, 3.923891465643771*^9}, {3.935400800189212*^9, 
   3.935400878948058*^9}, {3.9354039937142057`*^9, 3.9354041666337805`*^9}, {
   3.9354042038334975`*^9, 3.9354042350357018`*^9}, {3.9354042766238575`*^9, 
   3.935404326639539*^9}, {3.9593328885207357`*^9, 3.9593328962284207`*^9}, {
   3.959332953847289*^9, 3.959333001637292*^9}, {3.959333056355009*^9, 
   3.9593330625657487`*^9}, {3.959333345514388*^9, 3.959333409371083*^9}, {
   3.9593400997575674`*^9, 3.9593400999420385`*^9}, {3.9593981904125085`*^9, 
   3.959398214165676*^9}, {3.9594181671371098`*^9, 3.9594181792538157`*^9}, {
   3.970307285379331*^9, 3.970307334253586*^9}, {3.9703073879205704`*^9, 
   3.9703074392377415`*^9}, 3.970307695408965*^9, {3.970307934094944*^9, 
   3.970307996091057*^9}, 3.9703084120824537`*^9, {3.970308451229608*^9, 
   3.9703085058776617`*^9}, {3.9703088317667427`*^9, 3.970308845796955*^9}, {
   3.9703088881305375`*^9, 3.970308901201046*^9}, {3.9703089721217155`*^9, 
   3.970309256385125*^9}},ExpressionUUID->"e27dd85c-d7f7-4bae-917b-\
71965ab8cc27"]
}, Open  ]]
},
WindowSize->{1141.2, 574.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.1 Inherited,
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"9c87925b-dd89-45d1-9e4d-7efb9c79ff9f"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 154, 3, 74, "Section",ExpressionUUID->"9f842f1e-c66d-4996-9a94-a8929be8cfe7"],
Cell[CellGroupData[{
Cell[737, 27, 556, 8, 78, "Section",ExpressionUUID->"a1372411-a43c-41fa-8f75-6a8f2efe2d20"],
Cell[1296, 37, 22672, 608, 743, "Input",ExpressionUUID->"6ddb85af-8c0b-4f4a-b128-9f692a786b1d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24005, 650, 605, 8, 94, "Section",ExpressionUUID->"661879ef-4971-4ae1-a074-b67572ff954d"],
Cell[24613, 660, 26842, 701, 1078, "Input",ExpressionUUID->"e27dd85c-d7f7-4bae-917b-71965ab8cc27"]
}, Open  ]]
}
]
*)

