(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    701660,      13131]
NotebookOptionsPosition[    698371,      13080]
NotebookOutlinePosition[    698802,      13097]
CellTagsIndexPosition[    698759,      13094]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Figure 3\n",
 StyleBox["Data points: {energy (eV), peak-normalized intensity}", 
  "Subsubsection"]
}], "Section",
 CellChangeTimes->{{3.9704784084386873`*^9, 
  3.9704784371009707`*^9}},ExpressionUUID->"b9fbdcd2-79ec-4fc3-b7c6-\
2e80748e5064"],

Cell[CellGroupData[{

Cell[TextData[{
 "Figure 3(a).\n",
 StyleBox["The mirror-imaged absorption spectrum (dashed curve) is obtained \
from the absorption spectrum, with a Stokes shift of 0.08 eV.", 
  "Subsubsection"]
}], "Section",
 CellChangeTimes->{{3.8833843525810685`*^9, 3.883384363491805*^9}, {
  3.8833843945097036`*^9, 3.883384460977248*^9}, {3.8833845019553537`*^9, 
  3.883384543737305*^9}, {3.8833846683921633`*^9, 3.8833847899712024`*^9}, {
  3.883387868027631*^9, 3.8833878804621415`*^9}, {3.970475105180176*^9, 
  3.970475119574576*^9}, {3.9704779775538044`*^9, 3.9704780487464247`*^9}, {
  3.970478466036618*^9, 
  3.9704784697732944`*^9}},ExpressionUUID->"34911472-dad0-4328-977d-\
96524b7c61aa"],

Cell[BoxData["\<\"Absorption spectrum fig. 3(a):\"\>"], "Print",
 CellChangeTimes->{{3.9704761067130833`*^9, 3.9704761328876963`*^9}, 
   3.9704762035906963`*^9},
 CellLabel->
  "During evaluation of \
In[144]:=",ExpressionUUID->"586233ef-ec25-4534-9bb1-68e91a7cc843"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.755204387962557`", ",", 
     RowBox[{"-", "0.00043612007431309216`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.761340700630625`", ",", 
     RowBox[{"-", "0.0001433860423932278`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7675044075516757`", ",", "0.0009858124572210828`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.7736956925797553`", ",", "0.002134713593103226`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7799147412178264`", ",", "0.0018111412003085554`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.786161740636294`", ",", "0.00015883792086307828`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.7924368796917807`", ",", "0.0011159248720706656`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.798740348946164`", ",", "0.001540946258813818`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8050723406858613`", ",", "0.0016268241637060962`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.811433048941385`", ",", "0.0005989336071184143`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8178226695071604`", ",", "0.001384376106819642`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8242413999616187`", ",", "0.0023807187537346684`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.8306894396875584`", ",", "0.0029139600893060896`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.8371669898927934`", ",", "0.0026159774398922275`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.84367425363108`", ",", "0.0018880567343524256`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.850211435823335`", ",", "0.0022836483898829897`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.856778743279149`", ",", "0.0011419724313636043`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.863376384718593`", ",", "0.002578485292200386`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8700045707943302`", ",", "0.00463424816661778`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8766635141140386`", ",", "0.005104822335756118`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.883353429263141`", ",", "0.005785314499744686`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.890074532827857`", ",", "0.004902515734493662`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8968270434185763`", ",", "0.003859988700933262`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9036111816935612`", ",", "0.004800530439577155`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.910427170382983`", ",", "0.005769432091522441`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9172752343132955`", ",", "0.0068574982616820416`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.924155600431959`", ",", "0.008308758688873687`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9310684978325074`", ",", "0.008926453285420952`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9380141577799783`", ",", "0.010707076860815056`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9449928137367003`", ",", "0.011361576439816175`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9520047013884545`", ",", "0.01338755532740133`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.959050058671004`", ",", "0.018674029901785044`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9661291257970115`", ",", "0.0240407470856013`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9732421452833346`", ",", "0.02962042950849061`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9803893619787276`", ",", "0.038593136425366416`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9875710230919297`", ",", "0.05052270498571322`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.994787378220171`", ",", "0.06701652043610055`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.002038679378089`", ",", "0.0883800313141684`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0093251810270645`", ",", "0.11466652172354233`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0166471401049897`", ",", "0.14747643992210166`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.024004816056465`", ",", "0.19113844491161744`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0313984708634494`", ",", "0.2422655508729616`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0388283690763496`", ",", "0.3056757505296438`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.046294777845579`", ",", "0.38006127875558166`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0537979669535735`", ",", "0.46470379310213705`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0613382088472854`", ",", "0.5576435772953947`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0689157786711654`", ",", "0.653240828330237`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.076530954300622`", ",", "0.7497740654965617`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0841840163759966`", ",", "0.8386481663407324`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.091875248337034`", ",", "0.9170792908912141`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.099604936457877`", ",", "0.9773521723542259`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.107373369882583`", ",", "1.0110400933721198`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.115180840661183`", ",", "1.0187553479895266`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1230276437862736`", ",", "0.9988177283796709`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.130914077230179`", ",", "0.9524622488510804`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.13884044198266`", ",", "0.8886489798110669`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1468070420892147`", ",", "0.8181960282856928`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1548141846899513`", ",", "0.7484042488999707`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1628621800590575`", ",", "0.6843742400182525`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.170951341644887`", ",", "0.6315685750899036`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1790819861106425`", ",", "0.5919150171930513`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1872544333757085`", ",", "0.5649455403968799`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.195469006657605`", ",", "0.5530832232760776`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2037260325146018`", ",", "0.5591014559499365`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.212025840888992`", ",", "0.5820491789924275`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.220368765151041`", ",", "0.6213988696859079`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2287551421436214`", ",", "0.6762140060623841`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2371853122275476`", ",", "0.7419771173772043`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.24565961932762`", ",", "0.8108848712449617`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.254178410979398`", ",", "0.8786450491427923`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2627420383767123`", ",", "0.937206602674837`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2713508564199225`", ",", "0.9780259108568825`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.280005223764949`", ",", "1.0000000000000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.288705502873079`", ",", "0.9906747534956489`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.297452060061571`", ",", "0.9519162011668462`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3062452655550687`", ",", "0.8972201036472084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3150854935378358`", ",", "0.8340837778429651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.323973122206838`", ",", "0.7695603703595061`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3329085338256745`", ",", "0.7086584934976045`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.341892114779382`", ",", "0.6567723532017645`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.350924255630137`", ",", "0.6153943969666352`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3600053511738497`", ",", "0.5852488673609076`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.369135800497692`", ",", "0.5642853179492195`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3783160070385576`", ",", "0.5525820739790099`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.387546378642488`", ",", "0.5510297158013104`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3968273276250707`", ",", "0.5574275574459764`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4061592708328323`", ",", "0.5710085485588258`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4155426297056493`", ",", "0.5906027421775693`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.424977830340195`", ",", "0.6134528542963616`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.434465303554434`", ",", "0.6347949988972547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.444005484953197`", ",", "0.6499298924415763`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4535988149948493`", ",", "0.6546978954238781`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4632457390590807`", ",", "0.646426870696305`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4729467075158285`", ",", "0.626651181211499`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.482702175795367`", ",", "0.5941089434394795`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4925126044595802`", ",", "0.5546081559977403`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.502378459274437`", ",", "0.5145656587464557`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.512300211283714`", ",", "0.4735035950045087`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.522278336883951`", ",", "0.4373744558521561`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.532313317900714`", ",", "0.4070377736872985`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5424056416661447`", ",", "0.3820742556468173`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5525558010978533`", ",", "0.36333296263431225`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.562764294779169`", ",", "0.3484726004693458`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.57303162704078`", ",", "0.339734633070956`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5833583080437883`", ",", "0.3351657159425487`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.593744853864205`", ",", "0.33291585614875663`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.604191786578927`", ",", "0.33482288910617863`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.614699634353209`", ",", "0.3353982037607423`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.62526893152968`", ",", "0.33445740593526946`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.635900218718917`", ",", "0.32966162866812254`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.6465940428916195`", ",", "0.32183115234184034`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.657350957472421`", ",", "0.3097210051905088`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.668171522435357`", ",", "0.2949882147311584`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.679056304401041`", ",", "0.2777758692268831`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.690005876735567`", ",", "0.25927688980150587`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.701020819651196`", ",", "0.24204008047868936`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.712101720308835`", ",", "0.22836531328292214`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7232491729223742`", ",", "0.21800108308888252`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7344637788649124`", ",", "0.20912125440283347`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7457461467768907`", ",", "0.20217258962930373`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.757096892676214`", ",", "0.19860176697304527`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7685166400703674`", ",", "0.1962943937181535`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7800060200705814`", ",", "0.19691658605217133`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7915656715081063`", ",", "0.19700170119943944`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8031962410526097`", ",", "0.197851517301696`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.814898383332771`", ",", "0.19939560266668843`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8266727610591067`", ",", "0.20107694661190972`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.838520045149074`", ",", "0.20361943880305944`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.850440914854505`", ",", "0.20487141200851783`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8624360578914345`", ",", "0.205417169950458`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8745061705723467`", ",", "0.20688666905685388`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.886651957940911`", ",", "0.20860708641884781`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.898874133909279`", ",", "0.21058588672142375`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9111734213979514`", ",", "0.21436770608031036`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9235505524783245`", ",", "0.2179853549645275`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.936006268517939`", ",", "0.22089276779603015`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9485413203285056`", ",", "0.2241211869235032`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9611564683167755`", ",", "0.22744359763914693`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9738524826383035`", ",", "0.23167883243701318`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9866301433541826`", ",", "0.2377235337722586`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.999490240590809`", ",", "0.24451542931021378`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.0124335747027535`", ",", "0.2506703305465923`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.025460956438802`", ",", "0.2577254022359115`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.038573207111241`", ",", "0.2661457847989527`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.051771158768466`", ",", "0.276082602278283`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.065055654370986`", ",", "0.28723778936203737`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.0784275479708905`", ",", "0.29946404689112704`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.091887704894887`", ",", "0.3154284909553144`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.105437001930962`", ",", "0.33655780261399576`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.119076327518774`", ",", "0.3630190644915963`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.132806581943837`", ",", "0.3987677186206447`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.146628677535621`", ",", "0.44236627859804656`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.160543538869634`", ",", "0.49635845441261156`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.174552102973572`", ",", "0.5586258787767674`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.188655319537672`", ",", "0.6219659093901764`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.202854151129324`", ",", "0.685564585438328`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.217149573412077`", ",", "0.7413407039698839`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.231542575369115`", ",", 
     RowBox[{"0.7958236911008987`", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "0.026`"}], "+", "\<\"1.01684.883\"\>"}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.246034159531337`", ",", "0.8279139626261641`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.26062534221014`", ",", "0.8601872290261074`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.275317153735002`", ",", "0.8890561157285185`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.2901106386960235`", ",", "0.9148211268401727`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8835404315993776`*^9, {3.88354056695799*^9, 3.883540581373435*^9}, 
   3.883543671316295*^9, 3.8835455259034863`*^9, {3.9704761067130833`*^9, 
   3.970476132899742*^9}, 3.9704762036107492`*^9},
 CellLabel->
  "Out[149]=",ExpressionUUID->"e85a0e0c-d521-462c-b82d-d957945825d1"],

Cell[BoxData["\<\"PL spectrum fig. 3(a):\"\>"], "Print",
 CellChangeTimes->{{3.9704761067130833`*^9, 3.9704761328876963`*^9}, 
   3.9704762036107492`*^9},
 CellLabel->
  "During evaluation of \
In[144]:=",ExpressionUUID->"2b227ea7-958d-4fa1-8d4b-957087d13ecd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.220368765151041`", ",", "0.0024350397712949645`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.212025840888992`", ",", "0.0030876441314200706`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2037260325146018`", ",", "0.004261003059808636`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.195469006657605`", ",", "0.006166993334551682`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1872544333757085`", ",", "0.009058008578999084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1790819861106425`", ",", "0.013819311268655113`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.170951341644887`", ",", "0.020631458232543278`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1628621800590575`", ",", "0.029650442434454978`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1548141846899513`", ",", "0.04441962148988129`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1468070420892147`", ",", "0.06565528723619873`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.13884044198266`", ",", "0.09407787123721817`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.130914077230179`", ",", "0.13201104618759107`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1230276437862736`", ",", "0.17900730137074936`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.115180840661183`", ",", "0.2384378800110496`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.107373369882583`", ",", "0.3068526062712338`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.099604936457877`", ",", "0.3818887626177886`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.091875248337034`", ",", "0.46404261085341164`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0841840163759966`", ",", "0.5519255660576313`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.076530954300622`", ",", "0.6356178550933319`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0689157786711654`", ",", "0.7169525912618777`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0613382088472854`", ",", "0.7856838881061933`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0537979669535735`", ",", "0.8447650011069227`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.046294777845579`", ",", "0.8899345777896898`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0388283690763496`", ",", "0.9249286043771326`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0313984708634494`", ",", "0.9416417350864084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.024004816056465`", ",", "0.9503911083240613`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0166471401049897`", ",", "0.9521551552120723`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0093251810270645`", ",", "0.9422601787344644`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.002038679378089`", ",", "0.9222024708839615`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.994787378220171`", ",", "0.8908656749126723`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9875710230919297`", ",", "0.8621906346890311`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9803893619787276`", ",", "0.8420667273710304`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9732421452833346`", ",", "0.8208762660575339`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9661291257970115`", ",", "0.8036746557650968`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.959050058671004`", ",", "0.7912389205963136`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9520047013884545`", ",", "0.787617512675619`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9449928137367003`", ",", "0.7908641188839726`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9380141577799783`", ",", "0.804765652824932`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9310684978325074`", ",", "0.8211485770436364`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.924155600431959`", ",", "0.8457345109911368`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9172752343132955`", ",", "0.8743956929587188`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.910427170382983`", ",", "0.9105533444832198`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9036111816935612`", ",", "0.9508389211152866`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8968270434185763`", ",", "0.978010289824779`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.890074532827857`", ",", "0.9847498435624651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.883353429263141`", ",", "0.9843229666380541`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8766635141140386`", ",", "0.9884527919573376`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8700045707943302`", ",", "0.9967002217908757`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.863376384718593`", ",", "0.9999999999999999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.856778743279149`", ",", "0.9928756489962265`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.850211435823335`", ",", "0.9745358943172544`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.84367425363108`", ",", "0.9519560966361412`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8371669898927934`", ",", "0.9271336067955576`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8306894396875584`", ",", "0.8961924602617268`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8242413999616187`", ",", "0.8655353025352245`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8178226695071604`", ",", "0.8264160781601632`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.811433048941385`", ",", "0.7905375167678479`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8050723406858613`", ",", "0.7585678009007218`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.798740348946164`", ",", "0.7219820506788206`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7924368796917807`", ",", "0.6937994752750897`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.786161740636294`", ",", "0.6647225043420807`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7799147412178264`", ",", "0.6383663085131707`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7736956925797553`", ",", "0.6197044255023554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7675044075516757`", ",", "0.6025432341676066`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.761340700630625`", ",", "0.5868699225824274`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.755204387962557`", ",", "0.5752854294028561`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7490952873240593`", ",", "0.5649995365993572`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7430132181043154`", ",", "0.5568440473053639`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.736958001287308`", ",", "0.5502714235174044`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7309294594342526`", ",", "0.5470256589095673`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.724927416666265`", ",", "0.5430597274657903`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.71895169864726`", ",", "0.5354522709554573`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7130021325670692`", ",", "0.5288557014046833`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7070785471247834`", ",", "0.5229832463139289`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7011807725123114`", ",", "0.5161342368246976`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.695308640398154`", ",", "0.5054124409452404`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.68946198391139`", ",", "0.49145591084195095`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6836406376258672`", ",", "0.4782815795956644`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.677844437544602`", ",", "0.4657553945822198`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6720732210843767`", ",", "0.4498108436049071`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6663268270605394`", ",", "0.4339004405438028`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6606050956719973`", ",", "0.416201407142143`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.654907868486404`", ",", "0.39913372013848203`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.649234988425536`", ",", "0.38033313717915945`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6435862997508544`", ",", "0.36167268045522355`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.637961648049257`", ",", "0.3433649511438318`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6323608802190037`", ",", "0.3272836435754592`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.626783844455828`", ",", "0.31226348959002337`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6212303902392193`", ",", "0.2978999382823353`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6157003683188833`", ",", "0.28391997957947024`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.61019363070137`", ",", "0.27063016343968443`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.604710030636871`", ",", "0.259309109817209`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5992494226061864`", ",", "0.24810268958323725`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5938116623078464`", ",", "0.23817829487123499`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5883966066454085`", ",", "0.2296799875694383`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.583004113714897`", ",", "0.22120427108236718`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.577634042792414`", ",", "0.21394449708726443`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5722862543218894`", ",", "0.20719338411978594`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5669606099030036`", ",", "0.20071694192876705`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5616569722792373`", ",", "0.1942693477399219`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.556375205326084`", ",", "0.18944735943127228`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.551115174039405`", ",", "0.18390440849920084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5458767445239237`", ",", "0.17820955517836282`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5406597839818668`", ",", "0.17376208837507667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.53546416070174`", ",", "0.16815881921745596`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5302897440472467`", ",", "0.16386983944865302`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5251364044463354`", ",", "0.159710050011683`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.520004013380388`", ",", "0.15472884011626442`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.514892443373531`", ",", "0.1483071818920412`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.509801567982086`", ",", "0.14290185561080374`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.504731261784143`", ",", "0.1379251526862754`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.499681400369256`", ",", "0.13376750283461677`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.494651860328271`", ",", "0.1283688287044394`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4896425192432745`", ",", "0.12287019584057596`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4846532556776566`", ",", "0.1173159354632024`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4796839491663016`", ",", "0.11194570774146458`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4747344802058895`", ",", "0.106673535525103`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4698047302453205`", ",", "0.10112987773401651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4648945816762438`", ",", "0.09686428288849117`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4600039178237116`", ",", "0.09184852978506765`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.455132622936932`", ",", "0.08773070374256714`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4502805821801394`", ",", "0.08301319250149178`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4454476816235715`", ",", "0.07889844501512124`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4406338082345482`", ",", "0.07527317321045872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.435838849868665`", ",", "0.07220864519392342`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4310626952610797`", ",", "0.06896398528414632`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.426305234017907`", ",", "0.06528533748438549`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.421566356607716`", ",", "0.06253282206427067`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4168459543531204`", ",", "0.0598115281981252`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4121439194224723`", ",", "0.05703215452802118`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.407460144821652`", ",", "0.054492587635166984`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4027945243859508`", ",", "0.05178991105144885`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3981469527720516`", ",", "0.05000256651857334`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.393517325450098`", ",", "0.04748353409892127`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3889055386958584`", ",", "0.046271329077447604`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.384311489582982`", ",", "0.044654145129136805`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3797350759753373`", ",", "0.04296382971033681`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.375176196519446`", ",", "0.0411626371214654`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.370634750636999`", ",", "0.03938399857723651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.366110638517463`", ",", "0.03804541859938984`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3616037611107634`", ",", "0.036870848636204975`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.357114020120058`", ",", "0.03507747785005053`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3526413179945935`", ",", "0.03387222296442663`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.348185557922634`", ",", "0.03241175973309499`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3437466438244816`", ",", "0.03127809442157817`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3393244803455677`", ",", "0.030189460318299877`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.334918972849625`", ",", "0.028469365205181216`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3305300274119376`", ",", "0.027310119211164965`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3261575508126655`", ",", "0.026444257802455955`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.321801450530245`", ",", "0.02525840483379009`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3174616347348613`", ",", "0.02365224004095848`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3131380122819976`", ",", "0.022956107582055522`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3088304927060532`", ",", "0.021700970522266716`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3045389862140344`", ",", "0.020917729002920125`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.300263403679315`", ",", "0.020080492621861953`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.296003656635464`", ",", "0.018574110173219673`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2917596572701493`", ",", "0.0178346943057451`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2875313184190973`", ",", "0.01705513257988444`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.28331855356013`", ",", "0.016086419213206325`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2791212768072624`", ",", "0.015474045127492177`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.274939402904864`", ",", "0.014439039834756077`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2707728472218878`", ",", "0.013861592497992173`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.266621525746162`", ",", "0.013043731919472727`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2624853550787423`", ",", "0.012286727274348106`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2583642524283256`", ",", "0.011787034090987426`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2542581356057285`", ",", "0.010848874365577646`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2501669230184222`", ",", "0.01055419558921872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.246090533665128`", ",", "0.010041969374688313`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2420288871304717`", ",", "0.009341961689215387`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.237981903579694`", ",", "0.008995663344693263`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2339495037534247`", ",", "0.008213515898042199`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2299316089625014`", ",", "0.008075286497171985`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2259281410828557`", ",", "0.007503925507473322`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2219390225504494`", ",", "0.00731265225206457`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2179641763562628`", ",", "0.007044727707157588`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2140035260413407`", ",", "0.006568530876146919`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2100569956918905`", ",", "0.006417963763959639`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2061245099344315`", ",", "0.006256249453644394`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.202205993930996`", ",", "0.005697778650343829`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1983013733743806`", ",", "0.005299983452665986`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1944105744834523`", ",", "0.0051494937072503666`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.1905335239984995`", ",", "0.004920809064450632`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1866701491766323`", ",", "0.004600593665621275`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1828203777872375`", ",", "0.004379628433964759`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1789841381074706`", ",", "0.004126031087751917`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1751613589178085`", ",", "0.003809838153613116`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.171351969497637`", ",", "0.003661026783356957`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.167555899620893`", ",", "0.003606929057643223`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1637730795517465`", ",", "0.00344292320290124`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1600034400403323`", ",", "0.003266825807241067`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.156246912318523`", ",", "0.0030034241535264227`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1525034280957476`", ",", "0.002893740621030637`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1487729195548537`", ",", "0.0027289177524707406`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.1450553193480117`", ",", "0.002493114817240393`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.141350560592661`", ",", "0.0023137699249810065`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.137658576867501`", ",", "0.002147384900932227`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1339793022085214`", ",", "0.0020614346507659325`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8835404315993776`*^9, {3.88354056695799*^9, 3.883540581373435*^9}, 
   3.883543671316295*^9, 3.8835455259034863`*^9, {3.9704761067130833`*^9, 
   3.970476132899742*^9}, 3.9704762036223583`*^9},
 CellLabel->
  "Out[151]=",ExpressionUUID->"15bc8be5-1d5b-485e-8b4e-60656561911a"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0], PointSize[0.009166666666666668], 
          AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlHk4FYgaxoXOvlF22qRJltBGuN+XShJzzClCKjmE0VCYGB20SVGKTIQp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           "]], 
          LineBox[{{4.246034159531337, 0.8279139626261641}, {4.26062534221014,
            0.8601872290261074}, {4.275317153735002, 0.8890561157285185}, {
           4.2901106386960235`, 0.9148211268401727}}]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0]], 
             Line[CompressedData["
1:eJwtlHk4FYgaxoXOvlF22qRJltBGuN+XShJzzClCKjmE0VCYGB20SVGKTIQp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              "]], 
             
             Line[{{4.246034159531337, 0.8279139626261641}, {4.26062534221014,
               0.8601872290261074}, {4.275317153735002, 0.8890561157285185}, {
              4.2901106386960235`, 0.9148211268401727}}]}, 
            "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {2.0000000000000044`, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.009166666666666668], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{215.51091860472155`, 
        288.57687887933344`}, {-46.974140961922, -15.30818068731007}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.009166666666666668], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0]], 
          Line[CompressedData["
1:eJwtlHk4FYgaxoXOvlF22qRJltBGuN+XShJzzClCKjmE0VCYGB20SVGKTIQp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           "]], 
          
          Line[{{4.246034159531337, 0.8279139626261641}, {4.26062534221014, 
           0.8601872290261074}, {4.275317153735002, 0.8890561157285185}, {
           4.2901106386960235`, 0.9148211268401727}}]}, 
         "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {2.0000000000000044`, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.009166666666666668], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[1, 0, 0], PointSize[0.009166666666666668], 
          AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVUXk41gkX9f7eXUrIEkaWkrUJyZK6lxEiEdkmS4WiDC0YYwllVyEkS0Io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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]], 
             Line[CompressedData["
1:eJwVUXk41gkX9f7eXUrIEkaWkrUJyZK6lxEiEdkmS4WiDC0YYwllVyEkS0Io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              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {2.0000000000000044`, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.009166666666666668], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.009166666666666668], 
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0]], 
          Line[CompressedData["
1:eJwVUXk41gkX9f7eXUrIEkaWkrUJyZK6lxEiEdkmS4WiDC0YYwllVyEkS0Io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           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {2.0000000000000044`, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.009166666666666668], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0], AbsoluteThickness[2], Opacity[1.], 
          Dashing[{0.01, 0.01}], LineBox[CompressedData["
1:eJwUl3k81F8Xx2efSZKKkpSQ0ErWFOdkyb5GJEqKIiVLthSl1S8qWiipbO2i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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[0, 0, 0]], 
             Line[CompressedData["
1:eJwUl3k81F8Xx2efSZKKkpSQ0ErWFOdkyb5GJEqKIiVLthSl1S8qWiipbO2i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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 3.3}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[0, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{2., 3.3}, {0., 1.1}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {2.0000000000000044`, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             Dashing[{0.01, 0.01}], 
             RGBColor[0, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[0, 0, 0]], 
          Line[CompressedData["
1:eJwUl3k81F8Xx2efSZKKkpSQ0ErWFOdkyb5GJEqKIiVLthSl1S8qWiipbO2i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           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{2., 3.3}, {0., 1.1}}, 
        "Frame" -> {{True, True}, {True, True}}, 
        "AxesOrigin" -> {2.0000000000000044`, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[0, 0, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.0000000000000044`, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentSet", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{2., 4.}, {0., 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8835404315993776`*^9, {3.88354056695799*^9, 3.883540581373435*^9}, 
   3.883543671316295*^9, 3.8835455259034863`*^9, {3.9704761067130833`*^9, 
   3.970476132899742*^9}, 3.970476203638088*^9},
 CellLabel->
  "Out[152]=",ExpressionUUID->"9827b1c6-6b12-420d-947f-e003d5e8ec27"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Figure 3(b)\n",
 StyleBox["The mirror-imaged absorption spectrum (dashed curve) is obtained \
from the absorption spectrum, with a Stokes shift of 0.18 eV.", 
  "Subsubsection"]
}], "Section",
 CellChangeTimes->{{3.8833843525810685`*^9, 3.883384363491805*^9}, {
  3.8833843945097036`*^9, 3.883384460977248*^9}, {3.8833845019553537`*^9, 
  3.883384543737305*^9}, {3.8833846683921633`*^9, 3.8833847899712024`*^9}, {
  3.883387868027631*^9, 3.8833878804621415`*^9}, {3.970475105180176*^9, 
  3.970475119574576*^9}, {3.9704778555301237`*^9, 3.9704778559275365`*^9}, {
  3.970478121282547*^9, 
  3.970478126140499*^9}},ExpressionUUID->"278b78d4-c062-450a-9713-\
28b44995ac92"],

Cell[BoxData["\<\"Absorption spectrum fig. 3(b):\"\>"], "Print",
 CellChangeTimes->{3.970476318880828*^9},
 CellLabel->
  "During evaluation of \
In[181]:=",ExpressionUUID->"dcda6778-205d-42d1-9368-e812e51ed29d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.755204387962557`", ",", 
     RowBox[{"-", "0.23057972026440327`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.761340700630625`", ",", 
     RowBox[{"-", "0.231048188105468`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7675044075516757`", ",", 
     RowBox[{"-", "0.23001582124021372`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7736956925797553`", ",", 
     RowBox[{"-", "0.22822901626025993`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7799147412178264`", ",", 
     RowBox[{"-", "0.22985437602859365`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.786161740636294`", ",", 
     RowBox[{"-", "0.22832196642189534`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7924368796917807`", ",", 
     RowBox[{"-", "0.22832493425830885`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.798740348946164`", ",", 
     RowBox[{"-", "0.22696119478429255`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8050723406858613`", ",", 
     RowBox[{"-", "0.22604450539132664`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.811433048941385`", ",", 
     RowBox[{"-", "0.2272129243307892`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8178226695071604`", ",", 
     RowBox[{"-", "0.22568492616691405`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8242413999616187`", ",", 
     RowBox[{"-", "0.22401717805234872`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8306894396875584`", ",", 
     RowBox[{"-", "0.22273542955697365`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8371669898927934`", ",", 
     RowBox[{"-", "0.22224681941307994`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.84367425363108`", ",", 
     RowBox[{"-", "0.22135924554274702`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.850211435823335`", ",", 
     RowBox[{"-", "0.21962084597378614`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.856778743279149`", ",", 
     RowBox[{"-", "0.21812972161169356`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.863376384718593`", ",", 
     RowBox[{"-", "0.21578603953061726`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8700045707943302`", ",", 
     RowBox[{"-", "0.21365198400341529`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8766635141140386`", ",", 
     RowBox[{"-", "0.21060079439678794`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.883353429263141`", ",", 
     RowBox[{"-", "0.207921253383547`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.890074532827857`", ",", 
     RowBox[{"-", "0.20696284248520894`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8968270434185763`", ",", 
     RowBox[{"-", "0.20137488442596052`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9036111816935612`", ",", 
     RowBox[{"-", "0.19707584252229537`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.910427170382983`", ",", 
     RowBox[{"-", "0.19222470936322725`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9172752343132955`", ",", 
     RowBox[{"-", "0.18458673266213954`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.924155600431959`", ",", 
     RowBox[{"-", "0.1749133455435282`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9310684978325074`", ",", 
     RowBox[{"-", "0.16159965859696176`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9380141577799783`", ",", 
     RowBox[{"-", "0.14685079744507865`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9449928137367003`", ",", 
     RowBox[{"-", "0.13117631140721475`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9520047013884545`", ",", 
     RowBox[{"-", "0.11126737419017559`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.959050058671004`", ",", 
     RowBox[{"-", "0.086554535266873`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9661291257970115`", ",", 
     RowBox[{"-", "0.056553004744295456`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9732421452833346`", ",", 
     RowBox[{"-", "0.022551942953828952`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9803893619787276`", ",", "0.0159307996431973`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9875710230919297`", ",", "0.06251242058819131`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.994787378220171`", ",", "0.11507756630604746`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.002038679378089`", ",", "0.1738098309544665`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0093251810270645`", ",", "0.23898046454839864`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0166471401049897`", ",", "0.3082229445157466`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.024004816056465`", ",", "0.38458200311359264`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0313984708634494`", ",", "0.463800640341365`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0388283690763496`", ",", "0.5451683827514361`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.046294777845579`", ",", "0.6273481106292289`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0537979669535735`", ",", "0.7086904978240183`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0613382088472854`", ",", "0.7853142527582885`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0689157786711654`", ",", "0.853426429915369`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.076530954300622`", ",", "0.9118566686307509`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0841840163759966`", ",", "0.9576393951866914`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.091875248337034`", ",", "0.986695594208226`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.099604936457877`", ",", "0.9978033676582316`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.107373369882583`", ",", "0.9939539863158618`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.115180840661183`", ",", "0.9740776671572957`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1230276437862736`", ",", "0.9376567705049585`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.130914077230179`", ",", "0.8882708745483585`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.13884044198266`", ",", "0.8350368753892509`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1468070420892147`", ",", "0.7841942493875311`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1548141846899513`", ",", "0.738384236426636`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1628621800590575`", ",", "0.7037587253784354`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.170951341644887`", ",", "0.6850023722545175`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1790819861106425`", ",", "0.6783214176188747`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1872544333757085`", ",", "0.68546887117912`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.195469006657605`", ",", "0.707371581955921`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2037260325146018`", ",", "0.7392381858565318`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.212025840888992`", ",", "0.7788943364320761`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.220368765151041`", ",", "0.824604803229005`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2287551421436214`", ",", "0.8740404030388657`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2371853122275476`", ",", "0.9207097807671061`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.24565961932762`", ",", "0.958446491408378`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.254178410979398`", ",", "0.9860943918412048`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2627420383767123`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2713508564199225`", ",", "0.9956730400899713`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.280005223764949`", ",", "0.9736300318356829`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.288705502873079`", ",", "0.9345075155075863`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.297452060061571`", ",", "0.8815613149714513`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3062452655550687`", ",", "0.8186904392009888`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3150854935378358`", ",", "0.7552754225392395`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.323973122206838`", ",", "0.695945102409445`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3329085338256745`", ",", "0.6477348868941594`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.341892114779382`", ",", "0.6129539628314884`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.350924255630137`", ",", "0.5919426591986118`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3600053511738497`", ",", "0.5830626638013165`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.369135800497692`", ",", "0.5776881994676467`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3783160070385576`", ",", "0.5755520434555479`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.387546378642488`", ",", "0.5765826131869`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3968273276250707`", ",", "0.5808359714258446`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4061592708328323`", ",", "0.5885640034183953`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4155426297056493`", ",", "0.6003476229316246`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.424977830340195`", ",", "0.6085205660252007`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.434465303554434`", ",", "0.6090914438803107`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.444005484953197`", ",", "0.6000039250967167`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4535988149948493`", ",", "0.5820022640303322`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4632457390590807`", ",", "0.553747504764549`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4729467075158285`", ",", "0.514230302670065`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.482702175795367`", ",", "0.46856627102632664`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4925126044595802`", ",", "0.42408801242372063`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.502378459274437`", ",", "0.3839086022984767`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.512300211283714`", ",", "0.34644332667276573`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.522278336883951`", ",", "0.3147674788470499`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.532313317900714`", ",", "0.292683374177442`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5424056416661447`", ",", "0.27602546138474365`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5525558010978533`", ",", "0.26204176197578527`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.562764294779169`", ",", "0.24984673821992473`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.57303162704078`", ",", "0.2393295961609128`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5833583080437883`", ",", "0.2331765333308526`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.593744853864205`", ",", "0.2289285626649392`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.604191786578927`", ",", "0.22384118721657748`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.614699634353209`", ",", "0.21664552301298212`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.62526893152968`", ",", "0.20645389334348313`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.635900218718917`", ",", "0.19326404853502513`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.6465940428916195`", ",", "0.17841235624071802`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.657350957472421`", ",", "0.15974982522696934`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.668171522435357`", ",", "0.14189746952432875`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.679056304401041`", ",", "0.12233654411004057`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.690005876735567`", ",", "0.10320644899219493`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.701020819651196`", ",", "0.08770868705980299`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.712101720308835`", ",", "0.07560729984050125`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7232491729223742`", ",", "0.06800118588073938`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7344637788649124`", ",", "0.06206612646240181`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7457461467768907`", ",", "0.05529917636496293`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.757096892676214`", ",", "0.049737679878299954`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7685166400703674`", ",", "0.04858974891646608`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7800060200705814`", ",", "0.04716596441189468`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7915656715081063`", ",", "0.04718611514041581`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8031962410526097`", ",", "0.04708533047771253`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.814898383332771`", ",", "0.04443215336673661`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8266727610591067`", ",", "0.043926245236028116`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.838520045149074`", ",", "0.04432802972040092`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.850440914854505`", ",", "0.04448641976531706`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8624360578914345`", ",", "0.04526165648833334`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8745061705723467`", ",", "0.04646043079050453`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.886651957940911`", ",", "0.05214676239687067`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.898874133909279`", ",", "0.061205793430564544`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9111734213979514`", ",", "0.07297993892267478`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9235505524783245`", ",", "0.08735962254028871`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.936006268517939`", ",", "0.10214832667170667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9485413203285056`", ",", "0.12053897549609854`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9611564683167755`", ",", "0.13941878007684116`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9738524826383035`", ",", "0.1580678222462864`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9866301433541826`", ",", "0.17429402839233454`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.999490240590809`", ",", "0.18930345117039313`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.0124335747027535`", ",", "0.20325370117715275`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.025460956438802`", ",", "0.21380163811531722`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.038573207111241`", ",", "0.22386901754103852`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.051771158768466`", ",", "0.23253930116384883`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.065055654370986`", ",", "0.243270151823146`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.0784275479708905`", ",", "0.2559773549126512`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.091887704894887`", ",", "0.27034669524329047`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.105437001930962`", ",", "0.28923182285651755`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.119076327518774`", ",", "0.3117470567718847`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.132806581943837`", ",", "0.3381244812056964`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.146628677535621`", ",", "0.3673037415757725`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.160543538869634`", ",", "0.39645491847293834`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.174552102973572`", ",", "0.43098722867234707`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.188655319537672`", ",", "0.465447647004286`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.202854151129324`", ",", "0.5024544933835737`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.217149573412077`", ",", "0.5420129052690842`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.231542575369115`", ",", "0.5786454236325189`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.246034159531337`", ",", "0.6135332310099295`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.26062534221014`", ",", "0.6485910954385768`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.275317153735002`", ",", "0.6854971297684034`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.2901106386960235`", ",", "0.7198647808296377`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.305006856191495`", ",", "0.7576321990197722`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.320006880080665`", ",", "0.7924682395644284`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.335111799241786`", ",", "0.845320197044335`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.350322717835617`", ",", "0.897783251231527`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.365640755574475`", ",", "0.9498574021260047`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.381067047996999`", ",", "1.0198859217008038`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.396602746748761`", ",", "1.0711174487944002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.412249019868863`", ",", "1.1310668913663473`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.883396113638477*^9, 3.8833962166577387`*^9, 
  3.8833962694306164`*^9, 3.883396526195014*^9, 3.883541067690028*^9, 
  3.8835410990919724`*^9, 3.8835411370111237`*^9, 3.883543911487029*^9, 
  3.8835439612680674`*^9, 3.9704763188963947`*^9},
 CellLabel->
  "Out[186]=",ExpressionUUID->"11c48034-d7cb-486d-a6fa-f9597d9ee2ab"],

Cell[BoxData["\<\"PL spectrum fig. 3(b):\"\>"], "Print",
 CellChangeTimes->{3.970476318897477*^9},
 CellLabel->
  "During evaluation of \
In[181]:=",ExpressionUUID->"c44b5dcf-83cd-41fe-a412-4efc4bb3e832"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.220368765151041`", ",", "0.0024350397712949645`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.212025840888992`", ",", "0.0030876441314200706`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2037260325146018`", ",", "0.004261003059808636`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.195469006657605`", ",", "0.006166993334551682`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1872544333757085`", ",", "0.009058008578999084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1790819861106425`", ",", "0.013819311268655113`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.170951341644887`", ",", "0.020631458232543278`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1628621800590575`", ",", "0.029650442434454978`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1548141846899513`", ",", "0.04441962148988129`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1468070420892147`", ",", "0.06565528723619873`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.13884044198266`", ",", "0.09407787123721817`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.130914077230179`", ",", "0.13201104618759107`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1230276437862736`", ",", "0.17900730137074936`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.115180840661183`", ",", "0.2384378800110496`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.107373369882583`", ",", "0.3068526062712338`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.099604936457877`", ",", "0.3818887626177886`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.091875248337034`", ",", "0.46404261085341164`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0841840163759966`", ",", "0.5519255660576313`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.076530954300622`", ",", "0.6356178550933319`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0689157786711654`", ",", "0.7169525912618777`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0613382088472854`", ",", "0.7856838881061933`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0537979669535735`", ",", "0.8447650011069227`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.046294777845579`", ",", "0.8899345777896898`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0388283690763496`", ",", "0.9249286043771326`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0313984708634494`", ",", "0.9416417350864084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.024004816056465`", ",", "0.9503911083240613`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0166471401049897`", ",", "0.9521551552120723`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0093251810270645`", ",", "0.9422601787344644`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.002038679378089`", ",", "0.9222024708839615`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.994787378220171`", ",", "0.8908656749126723`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9875710230919297`", ",", "0.8621906346890311`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9803893619787276`", ",", "0.8420667273710304`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9732421452833346`", ",", "0.8208762660575339`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9661291257970115`", ",", "0.8036746557650968`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.959050058671004`", ",", "0.7912389205963136`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9520047013884545`", ",", "0.787617512675619`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9449928137367003`", ",", "0.7908641188839726`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9380141577799783`", ",", "0.804765652824932`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9310684978325074`", ",", "0.8211485770436364`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.924155600431959`", ",", "0.8457345109911368`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9172752343132955`", ",", "0.8743956929587188`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.910427170382983`", ",", "0.9105533444832198`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9036111816935612`", ",", "0.9508389211152866`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8968270434185763`", ",", "0.978010289824779`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.890074532827857`", ",", "0.9847498435624651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.883353429263141`", ",", "0.9843229666380541`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8766635141140386`", ",", "0.9884527919573376`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8700045707943302`", ",", "0.9967002217908757`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.863376384718593`", ",", "0.9999999999999999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.856778743279149`", ",", "0.9928756489962265`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.850211435823335`", ",", "0.9745358943172544`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.84367425363108`", ",", "0.9519560966361412`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8371669898927934`", ",", "0.9271336067955576`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8306894396875584`", ",", "0.8961924602617268`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8242413999616187`", ",", "0.8655353025352245`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8178226695071604`", ",", "0.8264160781601632`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.811433048941385`", ",", "0.7905375167678479`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8050723406858613`", ",", "0.7585678009007218`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.798740348946164`", ",", "0.7219820506788206`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7924368796917807`", ",", "0.6937994752750897`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.786161740636294`", ",", "0.6647225043420807`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7799147412178264`", ",", "0.6383663085131707`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7736956925797553`", ",", "0.6197044255023554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7675044075516757`", ",", "0.6025432341676066`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.761340700630625`", ",", "0.5868699225824274`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.755204387962557`", ",", "0.5752854294028561`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7490952873240593`", ",", "0.5649995365993572`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7430132181043154`", ",", "0.5568440473053639`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.736958001287308`", ",", "0.5502714235174044`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7309294594342526`", ",", "0.5470256589095673`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.724927416666265`", ",", "0.5430597274657903`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.71895169864726`", ",", "0.5354522709554573`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7130021325670692`", ",", "0.5288557014046833`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7070785471247834`", ",", "0.5229832463139289`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7011807725123114`", ",", "0.5161342368246976`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.695308640398154`", ",", "0.5054124409452404`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.68946198391139`", ",", "0.49145591084195095`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6836406376258672`", ",", "0.4782815795956644`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.677844437544602`", ",", "0.4657553945822198`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6720732210843767`", ",", "0.4498108436049071`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6663268270605394`", ",", "0.4339004405438028`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6606050956719973`", ",", "0.416201407142143`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.654907868486404`", ",", "0.39913372013848203`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.649234988425536`", ",", "0.38033313717915945`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6435862997508544`", ",", "0.36167268045522355`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.637961648049257`", ",", "0.3433649511438318`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6323608802190037`", ",", "0.3272836435754592`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.626783844455828`", ",", "0.31226348959002337`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6212303902392193`", ",", "0.2978999382823353`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6157003683188833`", ",", "0.28391997957947024`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.61019363070137`", ",", "0.27063016343968443`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.604710030636871`", ",", "0.259309109817209`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5992494226061864`", ",", "0.24810268958323725`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5938116623078464`", ",", "0.23817829487123499`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5883966066454085`", ",", "0.2296799875694383`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.583004113714897`", ",", "0.22120427108236718`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.577634042792414`", ",", "0.21394449708726443`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5722862543218894`", ",", "0.20719338411978594`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5669606099030036`", ",", "0.20071694192876705`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5616569722792373`", ",", "0.1942693477399219`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.556375205326084`", ",", "0.18944735943127228`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.551115174039405`", ",", "0.18390440849920084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5458767445239237`", ",", "0.17820955517836282`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5406597839818668`", ",", "0.17376208837507667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.53546416070174`", ",", "0.16815881921745596`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5302897440472467`", ",", "0.16386983944865302`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5251364044463354`", ",", "0.159710050011683`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.520004013380388`", ",", "0.15472884011626442`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.514892443373531`", ",", "0.1483071818920412`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.509801567982086`", ",", "0.14290185561080374`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.504731261784143`", ",", "0.1379251526862754`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.499681400369256`", ",", "0.13376750283461677`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.494651860328271`", ",", "0.1283688287044394`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4896425192432745`", ",", "0.12287019584057596`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4846532556776566`", ",", "0.1173159354632024`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4796839491663016`", ",", "0.11194570774146458`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4747344802058895`", ",", "0.106673535525103`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4698047302453205`", ",", "0.10112987773401651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4648945816762438`", ",", "0.09686428288849117`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4600039178237116`", ",", "0.09184852978506765`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.455132622936932`", ",", "0.08773070374256714`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4502805821801394`", ",", "0.08301319250149178`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4454476816235715`", ",", "0.07889844501512124`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4406338082345482`", ",", "0.07527317321045872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.435838849868665`", ",", "0.07220864519392342`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4310626952610797`", ",", "0.06896398528414632`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.426305234017907`", ",", "0.06528533748438549`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.421566356607716`", ",", "0.06253282206427067`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4168459543531204`", ",", "0.0598115281981252`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4121439194224723`", ",", "0.05703215452802118`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.407460144821652`", ",", "0.054492587635166984`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4027945243859508`", ",", "0.05178991105144885`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3981469527720516`", ",", "0.05000256651857334`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.393517325450098`", ",", "0.04748353409892127`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3889055386958584`", ",", "0.046271329077447604`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.384311489582982`", ",", "0.044654145129136805`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3797350759753373`", ",", "0.04296382971033681`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.375176196519446`", ",", "0.0411626371214654`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.370634750636999`", ",", "0.03938399857723651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.366110638517463`", ",", "0.03804541859938984`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3616037611107634`", ",", "0.036870848636204975`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.357114020120058`", ",", "0.03507747785005053`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3526413179945935`", ",", "0.03387222296442663`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.348185557922634`", ",", "0.03241175973309499`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3437466438244816`", ",", "0.03127809442157817`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3393244803455677`", ",", "0.030189460318299877`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.334918972849625`", ",", "0.028469365205181216`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3305300274119376`", ",", "0.027310119211164965`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3261575508126655`", ",", "0.026444257802455955`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.321801450530245`", ",", "0.02525840483379009`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3174616347348613`", ",", "0.02365224004095848`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3131380122819976`", ",", "0.022956107582055522`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3088304927060532`", ",", "0.021700970522266716`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3045389862140344`", ",", "0.020917729002920125`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.300263403679315`", ",", "0.020080492621861953`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.296003656635464`", ",", "0.018574110173219673`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2917596572701493`", ",", "0.0178346943057451`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2875313184190973`", ",", "0.01705513257988444`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.28331855356013`", ",", "0.016086419213206325`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2791212768072624`", ",", "0.015474045127492177`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.274939402904864`", ",", "0.014439039834756077`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2707728472218878`", ",", "0.013861592497992173`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.266621525746162`", ",", "0.013043731919472727`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2624853550787423`", ",", "0.012286727274348106`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2583642524283256`", ",", "0.011787034090987426`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2542581356057285`", ",", "0.010848874365577646`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2501669230184222`", ",", "0.01055419558921872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.246090533665128`", ",", "0.010041969374688313`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2420288871304717`", ",", "0.009341961689215387`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.237981903579694`", ",", "0.008995663344693263`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2339495037534247`", ",", "0.008213515898042199`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2299316089625014`", ",", "0.008075286497171985`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2259281410828557`", ",", "0.007503925507473322`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2219390225504494`", ",", "0.00731265225206457`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2179641763562628`", ",", "0.007044727707157588`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2140035260413407`", ",", "0.006568530876146919`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2100569956918905`", ",", "0.006417963763959639`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2061245099344315`", ",", "0.006256249453644394`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.202205993930996`", ",", "0.005697778650343829`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1983013733743806`", ",", "0.005299983452665986`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1944105744834523`", ",", "0.0051494937072503666`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.1905335239984995`", ",", "0.004920809064450632`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1866701491766323`", ",", "0.004600593665621275`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1828203777872375`", ",", "0.004379628433964759`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1789841381074706`", ",", "0.004126031087751917`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1751613589178085`", ",", "0.003809838153613116`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.171351969497637`", ",", "0.003661026783356957`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.167555899620893`", ",", "0.003606929057643223`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1637730795517465`", ",", "0.00344292320290124`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1600034400403323`", ",", "0.003266825807241067`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.156246912318523`", ",", "0.0030034241535264227`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1525034280957476`", ",", "0.002893740621030637`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1487729195548537`", ",", "0.0027289177524707406`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.1450553193480117`", ",", "0.002493114817240393`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.141350560592661`", ",", "0.0023137699249810065`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.137658576867501`", ",", "0.002147384900932227`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1339793022085214`", ",", "0.0020614346507659325`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.883396113638477*^9, 3.8833962166577387`*^9, 
  3.8833962694306164`*^9, 3.883396526195014*^9, 3.883541067690028*^9, 
  3.8835410990919724`*^9, 3.8835411370111237`*^9, 3.883543911487029*^9, 
  3.8835439612680674`*^9, 3.970476318911477*^9},
 CellLabel->
  "Out[188]=",ExpressionUUID->"899d00f1-a6a9-47e0-b9fd-c24df1b5402b"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0], PointSize[0.009166666666666668], 
          AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtlXk0FAgcxyVl7oMkEVmrkmFJYZf290s6kMV4STkSaZGomZJ2SQedssnV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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0]], 
             Line[CompressedData["
1:eJwtlXk0FAgcxyVl7oMkEVmrkmFJYZf290s6kMV4STkSaZGomZJ2SQedssnV
oqKEKecgEjmSHDHKMWKIwchNkspi2/f28973ff/8/PN976vu7s/2lJaSkrr6
Pf+14MFrjVdvZFHqf0jORW5tQlncL+rq0rK9CaXbZu5fl8iiWGOZe5NUDhD9
yxTsZ2Qxi1f709NTpaBOGe5gyRCwUrnt6hGohnl24goleQKqawj8h2IbwTiG
PaD4AwEl8SnFo0+bgbfjvb+WPgHn9M+1zie2w/wyX6E1EnA7+0rvh6wu2FT0
B4TZENDmkPCzDKcXtKMl9QJXAl4JtXI0le+H37YNJOn4EbD9z/7cuEwJOH6S
7bsbTMDs5wpOVupDEBhpWqhxg4DvhsqnzG1G4N7bRrOSRAKqyVsTx3XGYD/H
+7FXBgFjZAIOzqWMw1InRUWtEgJ6e19+IB01AfEd5hnz9QQU1czbLxmfgHWd
5ZGSTgKuiVKNC2ycALHa8/G+EQI+v35pLEV7An643DI8M0dAGY1LL3cvGQcd
O+ksFQoR02PCSIW+ozB9NNPNUYWIZNl2vFc0DJMvUrR5LCIaxnRcVV01BKvj
1Y3pW4ko4vt8EyYNAv19TfY1ayJKNxTJ6IdJICcqo0TZlYgRIbarro0MwFdd
66uVfkQM1lVWFeQPQAwxAUNCiCgIlvFxnhiAvsZZKvsmEds77Itr70tAMG20
xiSZiM685cK2tEHgGKTE/8InIv1seVPe6Ad4xJzj274goterskQtj2Eo8OBE
BbcQUeODdbTGlxGY6S7yrhgg4mtGjtPJgDH4lDnroTJLxAH5j1/jHo9DA7kl
J4JAwpPbTzcrREyAsuR4yKrVpP/3NAmcsOOLT7VJqIgrC26IJiDd9LMbdysJ
l3r9qP1t/QRMqaa3mNuQsHOF2m9Bg2MwV5JzXfcQCSPl18uXbxkFnaHyQj0u
CcW2pZZPNg2D2kXmdaswEvoMf3A20v4AFyw9jUPiSLhZtZWnu0MCF5+Sput5
JLxDDLj4a3E/iCRd4/olJNSTJyXb3emDWn9Lt9xGEibnWD3TnxKD0Ns6yLKX
hCu4TAI3XQzDzqcD56dJqDAT8vlokBi4O8av1S0nY7zBGdVRHzFo3/MfzlUi
41yE+yEXrhj2BrIb81hkVOHl2W2JFUPVjat+TUBG7zUWOqGtYmj2f7iUYE9G
xbVCI4phHwTltFUfOEJGdi6qSZ3pgwerJ6dqzpCxNn3WITO4DwY+epWxb5Ax
0j3Qz8SgD5aaHfT5kkTGDt5Owxf3vvu14nWL88m48ZYke09RL/yC4btv15DR
/OYt5aiTPQALe2duicgYsSPUff6fLvidVcN5NEnGOrlFstmPnfCnx5HFbhkK
0uJ73Wci28E52rtDT4mCzy6dTV7LagN2QuX2JB0KskPfn12n2QKibpUgHTMK
jhmQKfbP3kLL156qdgcK5uW48Y88egOHThi53T9KQae3pwWWL5ugM4Acee0c
Bfc5tTp++yaAwQJqQmQMBd+MmW48cL8RCD8VVhY+ouBdse+V4vYGaFfdYz1f
RsFOOfGXy9YNYPGx+5x7KwW7B62+Nqe+Brnd9imDwxQM1VdwJT2rh4xFt8Vw
KSrGHl5Ws+JYHUg7xHWwV1LxIe/rvp6SGjBluIX8zKJidl2SnVFbNQzlSxtv
M6PiblUOL4tTBaXNaTY+jlQsXjgLfK1K2O/sLFfgR0XBCC2JY1cGpjIKDeph
VIzy2NBXcrQYjpbkNuQkUHG7cUis/Mkn0Gm4xMOdT8VMt/VSUk55sDmoSmRY
S0VlP07MJa9c0LnFv67bQ0Xnjpy76q+y4cmmoAqLWSo2+M5yWbYZkBAtaLpC
o+HKmKHbRqd5wN/hTB3VpGFzKeFYRU86yCsK67lbaXjQylxTY106tCsvHFq7
l4ZlY/mWrzakQ0Rx4rqPvjQ8ICSHRSqnw5c3f50YCqXhbL7BY0FZKvhN1SYs
v0PDDcrcLeeCU8Hm4b5FiwIamnzu69Tip4JE6DGb10BDlq5M+Gh1KvjuMu0x
l9AwK7WSdZWVBmZMB8X5BRre2Z3gwqtNAxV79pxIkY6RAayFb/xH8FgsPdqv
R8cKtvF9F4dsGFL2t1SwpOOcaGJTUxYfJqrbA/086Hhau2GbgcsTiFOo6JgM
oqPq757XDq8rhitPx1oSY+mYsTH1WErnc9gp79fAyaFjoM/xs2faK6DojyRt
bh0d6y6EL940qYLGZCPHu/10PPxweJe5TTUImFj6aYGOCf8MnFhlUgOLvXIe
zygM7Diccc9Ipg7IIyJ/udUMvJBRpd7hUg/ZOiolIesZmBwd4Fea9hpOa6aF
LN3CQItdVaR3Lxpg8CV9+o4ZA/v0Vk6d0RDAm79SbWxsGXiKOyscP9QEtk+C
BYquDJTK5/3sbP0GSux9M2ePMrDQk6BffeEtLMtmak6cYSDXy2WMN90MpZHt
nIXLDJTer9fV8qAV9mZ/a9aMZaAj5cSNwfNCEK8JveSZwsC2s1bc0IPvoLbH
obaUz8AqCvGUVUwndIfpinQrGGgWHjjWX9sFFq0PFosEDDSdUuIor+iBgmi9
U87dDLQ5V8XRduwFlqtBiNIYA119bLy2h4ph8/Vpt8k5Bmbt2XmCcb8Pbm9+
6NpLYiLRYVTFrKIfbHYdKx1VYqLomElm3Pe/MMj2fCGnxcTAqCNd6sRBaIxL
LrQ3ZmL27MPesF8/ALlKX5y9i4nnr5w/IHEaArX5DeHr9zHxcajqlIgyAl5/
Jy0WH2Gix3TX5IPiUShXLr3sE8DEjJay/Sae4zA4wj9ueImJJrmnJFy7SUjb
UC+rFstEu+l6yh6NKVDIOr5KeIeJ8X//xxT8C8KO+gI=
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {2.0000000000000044`, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.009166666666666668], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.009166666666666668], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0]], 
          Line[CompressedData["
1:eJwtlXk0FAgcxyVl7oMkEVmrkmFJYZf290s6kMV4STkSaZGomZJ2SQedssnV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           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {2.0000000000000044`, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.009166666666666668], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[1, 0, 0], PointSize[0.009166666666666668], 
          AbsoluteThickness[2], LineBox[CompressedData["
1:eJxFlQkw1w0Tx/+//01KOcqZ3EfyJEKi3VB0p8NRkUKODkLlcaR/pNDjvu9C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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]], 
             Line[CompressedData["
1:eJxFlQkw1w0Tx/+//01KOcqZ3EfyJEKi3VB0p8NRkUKODkLlcaR/pNDjvu9C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              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {2.0000000000000044`, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.009166666666666668], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.009166666666666668], 
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0]], 
          Line[CompressedData["
1:eJxFlQkw1w0Tx/+//01KOcqZ3EfyJEKi3VB0p8NRkUKODkLlcaR/pNDjvu9C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           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {2.0000000000000044`, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.009166666666666668], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0], AbsoluteThickness[2], Opacity[1.], 
          Dashing[{0.01, 0.01}], LineBox[CompressedData["
1:eJwtl3k4FN73x2cfSbJEEZVkK0nK0npOElKSpUiRLCVaSQkhpb2IFkkSGmPJ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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[0, 0, 0]], 
             Line[CompressedData["
1:eJwtl3k4FN73x2cfSbJEEZVkK0nK0npOElKSpUiRLCVaSQkhpb2IFkkSGmPJ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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 3.3}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[0, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{2., 3.3}, {0., 1.1}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {2.0000000000000044`, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             Dashing[{0.01, 0.01}], 
             RGBColor[0, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[0, 0, 0]], 
          Line[CompressedData["
1:eJwtl3k4FN73x2cfSbJEEZVkK0nK0npOElKSpUiRLCVaSQkhpb2IFkkSGmPJ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           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{2., 3.3}, {0., 1.1}}, 
        "Frame" -> {{True, True}, {True, True}}, 
        "AxesOrigin" -> {2.0000000000000044`, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[0, 0, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.0000000000000044`, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{242.66666666666657`, Automatic},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentSet", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{2., 4.}, {0., 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.883396113638477*^9, 3.8833962166577387`*^9, 
  3.8833962694306164`*^9, 3.883396526195014*^9, 3.883541067690028*^9, 
  3.8835410990919724`*^9, 3.8835411370111237`*^9, 3.883543911487029*^9, 
  3.8835439612680674`*^9, 3.970476318914106*^9},
 CellLabel->
  "Out[189]=",ExpressionUUID->"5e14acec-7fd4-4384-a54b-066a16cb328b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 3(c)", "Section",
 CellChangeTimes->{{3.8833843525810685`*^9, 3.883384363491805*^9}, {
  3.8833843945097036`*^9, 3.883384460977248*^9}, {3.8833845019553537`*^9, 
  3.883384543737305*^9}, {3.8833846683921633`*^9, 3.8833847899712024`*^9}, {
  3.883387868027631*^9, 3.8833878804621415`*^9}, {3.970475105180176*^9, 
  3.970475119574576*^9}, {3.9704778555301237`*^9, 3.9704778559275365`*^9}, {
  3.970477897090831*^9, 
  3.9704778974591646`*^9}},ExpressionUUID->"c9388f8b-f9f7-43b7-9247-\
d7f9cb9e95c1"],

Cell[BoxData["\<\"Absorption spectrum fig. 3(c):\"\>"], "Print",
 CellChangeTimes->{3.970477453371951*^9},
 CellLabel->
  "During evaluation of \
In[246]:=",ExpressionUUID->"2fea6550-f0e1-4297-854a-477ff6c895c7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.755204387962557`", ",", "0.014749619090678621`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.761340700630625`", ",", "0.014179017362844328`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7675044075516757`", ",", "0.013805948370561823`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7736956925797553`", ",", "0.013483079263113611`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7799147412178264`", ",", "0.012141620735405454`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.786161740636294`", ",", "0.011048330401921389`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7924368796917807`", ",", "0.010056528772701011`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.798740348946164`", ",", "0.00897260327673487`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8050723406858613`", ",", "0.008422909093126565`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.811433048941385`", ",", "0.008451874753356303`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8178226695071604`", ",", "0.008097317649190559`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8242413999616187`", ",", "0.006692592021506886`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8306894396875584`", ",", "0.005484963555536963`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8371669898927934`", ",", "0.0039020882280943435`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.84367425363108`", ",", "0.0031809957392167003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.850211435823335`", ",", "0.0032210685323165295`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.856778743279149`", ",", "0.0018903904570998853`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.863376384718593`", ",", "0.0019331855866874725`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8700045707943302`", ",", "0.0012230913372204095`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.8766635141140386`", ",", "0.0009855947020283018`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.883353429263141`", ",", "0.0011237805021469464`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.890074532827857`", ",", "0.00014014588238983112`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.8968270434185763`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9036111816935612`", ",", "0.000418477564898323`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.910427170382983`", ",", "0.001901933163807998`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9172752343132955`", ",", "0.003609818182768538`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.924155600431959`", ",", "0.006371574102870341`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9310684978325074`", ",", "0.009212386674576696`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9380141577799783`", ",", "0.013648052854271802`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9449928137367003`", ",", "0.020721554197145952`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9520047013884545`", ",", "0.030596884253221723`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.959050058671004`", ",", "0.044075063310657366`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9661291257970115`", ",", "0.060856852142718375`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9732421452833346`", ",", "0.08178083928109409`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9803893619787276`", ",", "0.11003292067067916`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9875710230919297`", ",", "0.14519799444382012`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.994787378220171`", ",", "0.18880296468977123`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.002038679378089`", ",", "0.24190976042567758`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0093251810270645`", ",", "0.3031018955302283`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0166471401049897`", ",", "0.3734822429613445`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.024004816056465`", ",", "0.4534726559811691`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0313984708634494`", ",", "0.5401944270940865`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0388283690763496`", ",", "0.6314627179284806`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.046294777845579`", ",", "0.7226316979278008`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0537979669535735`", ",", "0.8090124147255318`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0613382088472854`", ",", "0.884815438653345`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0689157786711654`", ",", "0.9444848076201027`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.076530954300622`", ",", "0.9843634436816092`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0841840163759966`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.091875248337034`", ",", "0.9925344822028882`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.099604936457877`", ",", "0.9618777065469359`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.107373369882583`", ",", "0.9123748487469846`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.115180840661183`", ",", "0.8514063808082681`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1230276437862736`", ",", "0.7852424970228528`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.130914077230179`", ",", "0.7212122716830833`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.13884044198266`", ",", "0.6640764179452937`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1468070420892147`", ",", "0.6186331083158887`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1548141846899513`", ",", "0.5863788656089189`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1628621800590575`", ",", "0.5688794688786848`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.170951341644887`", ",", "0.5678965965131441`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1790819861106425`", ",", "0.5821150333083314`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1872544333757085`", ",", "0.6112907490214833`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.195469006657605`", ",", "0.6555190254296718`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2037260325146018`", ",", "0.7121116096979642`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.212025840888992`", ",", "0.776095010850144`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.220368765151041`", ",", "0.8425462644752075`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2287551421436214`", ",", "0.9053802951622555`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2371853122275476`", ",", "0.9574491184421092`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.24565961932762`", ",", "0.9937595336223798`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.254178410979398`", ",", "1.0103257134046104`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2627420383767123`", ",", "1.0035359884172204`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2713508564199225`", ",", "0.9727072699887012`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.280005223764949`", ",", "0.9084393302268206`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.288705502873079`", ",", "0.8333314821445215`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.297452060061571`", ",", "0.766961898614091`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3062452655550687`", ",", "0.7033020199301164`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3150854935378358`", ",", "0.6472200370934681`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.323973122206838`", ",", "0.601744712786967`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3329085338256745`", ",", "0.5684944216058561`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.341892114779382`", ",", "0.547534064052004`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.350924255630137`", ",", "0.5381209867315498`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3600053511738497`", ",", "0.5393185969992448`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.369135800497692`", ",", "0.5483961735709475`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3783160070385576`", ",", "0.5634110571289934`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.387546378642488`", ",", "0.5829990304126365`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3968273276250707`", ",", "0.6047768511670327`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4061592708328323`", ",", "0.6240880172766005`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4155426297056493`", ",", "0.6390149149193621`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.424977830340195`", ",", "0.6462027543947221`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.434465303554434`", ",", "0.6414693734967257`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.444005484953197`", ",", "0.6249526313451128`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4535988149948493`", ",", "0.5970245079975712`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4632457390590807`", ",", "0.5600810951371663`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4729467075158285`", ",", "0.5191362832135938`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.482702175795367`", ",", "0.47690021264714766`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4925126044595802`", ",", "0.43663282693518907`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.502378459274437`", ",", "0.4021357056426848`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.512300211283714`", ",", "0.37409215522806194`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.522278336883951`", ",", "0.3532921977400686`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.532313317900714`", ",", "0.339293181265795`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5424056416661447`", ",", "0.3302085266192239`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5525558010978533`", ",", "0.3264907950180806`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.562764294779169`", ",", "0.3259342405465231`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.57303162704078`", ",", "0.3282472465199828`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5833583080437883`", ",", "0.33152112838016184`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.593744853864205`", ",", "0.33334302485122974`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.604191786578927`", ",", "0.33338821563692644`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.614699634353209`", ",", "0.3302900878203972`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.62526893152968`", ",", "0.32258642002733656`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.635900218718917`", ",", "0.3110232413488502`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.6465940428916195`", ",", "0.2971898518264917`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.657350957472421`", ",", "0.2827310871661653`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.668171522435357`", ",", "0.26776357226300646`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.679056304401041`", ",", "0.2541273887958212`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.690005876735567`", ",", "0.24265295828683583`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.701020819651196`", ",", "0.2342336426778731`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.712101720308835`", ",", "0.22967917373385213`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7232491729223742`", ",", "0.22917281914712903`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7344637788649124`", ",", "0.22956919133974665`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7457461467768907`", ",", "0.2320495665604737`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.757096892676214`", ",", "0.2370621502886548`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7685166400703674`", ",", "0.243007406497542`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7800060200705814`", ",", "0.24987651481691522`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7915656715081063`", ",", "0.25637876107119795`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8031962410526097`", ",", "0.2634045670788066`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.814898383332771`", ",", "0.2700639465951628`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8266727610591067`", ",", "0.2765362471480803`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.838520045149074`", ",", "0.28342070944524433`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.850440914854505`", ",", "0.29116891466324474`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8624360578914345`", ",", "0.2999471431147537`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8745061705723467`", ",", "0.3097801136150798`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.886651957940911`", ",", "0.3201015801747696`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.898874133909279`", ",", "0.33710474941001517`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9111734213979514`", ",", "0.3529936118740912`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9235505524783245`", ",", "0.3669173829678433`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.936006268517939`", ",", "0.3812948042139155`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9485413203285056`", ",", "0.3973857729388428`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9611564683167755`", ",", "0.41554789526365715`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9738524826383035`", ",", "0.43586218792223425`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9866301433541826`", ",", "0.45935660517235216`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.999490240590809`", ",", "0.4855602916950878`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.0124335747027535`", ",", "0.5139071103944468`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.025460956438802`", ",", "0.5460850187862996`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.038573207111241`", ",", "0.5816202214283163`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.051771158768466`", ",", "0.6220771906532823`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.065055654370986`", ",", "0.666940315930416`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.0784275479708905`", ",", "0.7178518195225936`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.091887704894887`", ",", "0.7763657199904868`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.105437001930962`", ",", "0.8413838267949345`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.119076327518774`", ",", "0.9138863988584476`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.132806581943837`", ",", "0.9921609776367678`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.146628677535621`", ",", "1.0723028614587713`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.160543538869634`", ",", "1.152340860920402`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.174552102973572`", ",", "1.229003925391428`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.188655319537672`", ",", "1.2999030412636516`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.202854151129324`", ",", "1.3651875014700618`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.217149573412077`", ",", "1.4261258059204935`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.231542575369115`", ",", "1.4855651919007655`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.246034159531337`", ",", "1.5448201123606269`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.26062534221014`", ",", "1.6090214093252868`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.275317153735002`", ",", "1.6782082844401698`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8834028169523864`*^9, 3.8834029739274936`*^9, 3.8834032367241*^9, {
   3.8834033084906893`*^9, 3.883403328861749*^9}, {3.883403375406251*^9, 
   3.8834034294824767`*^9}, {3.883414440850815*^9, 3.883414468567665*^9}, 
   3.8834905203581343`*^9, 3.8834906033517857`*^9, 3.883490660619734*^9, 
   3.883490905514903*^9, 3.8835441713272667`*^9, 3.8835442121747713`*^9, 
   3.8835442519207196`*^9, 3.8835457969884577`*^9, 3.883546207223902*^9, 
   3.970477453371951*^9},
 CellLabel->
  "Out[250]=",ExpressionUUID->"5b05f0ae-6945-4cf3-acf4-b6822cc862fb"],

Cell[BoxData["\<\"PL spectrum fig. 3(b), solution processed (red):\"\>"], \
"Print",
 CellChangeTimes->{3.9704774533844705`*^9},
 CellLabel->
  "During evaluation of \
In[246]:=",ExpressionUUID->"b734200a-0c67-4ace-9126-6968396c8bdf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.099604936457877`", ",", "0.002403916341047743`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.091875248337034`", ",", "0.003632634931275249`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0841840163759966`", ",", "0.005119020022542031`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.076530954300622`", ",", "0.0070215420702888455`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0689157786711654`", ",", "0.009503047438769768`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0613382088472854`", ",", "0.01279020968751439`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0537979669535735`", ",", "0.01723199075436083`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.046294777845579`", ",", "0.02243640954997182`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0388283690763496`", ",", "0.029572737693419303`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0313984708634494`", ",", "0.037663640562201305`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.024004816056465`", ",", "0.04838298323043081`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0166471401049897`", ",", "0.06129369069042321`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0093251810270645`", ",", "0.07683181193202766`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.002038679378089`", ",", "0.09603938898859563`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.994787378220171`", ",", "0.11801024049655616`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9875710230919297`", ",", "0.14450946857302738`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9803893619787276`", ",", "0.17486957349129398`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9732421452833346`", ",", "0.20834304473201296`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9661291257970115`", ",", "0.24563043536585813`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.959050058671004`", ",", "0.28641733073763603`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9520047013884545`", ",", "0.33241847244843087`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9449928137367003`", ",", "0.3795719869389862`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9380141577799783`", ",", "0.42697774652235776`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9310684978325074`", ",", "0.47846436309433`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.924155600431959`", ",", "0.5291821914478552`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9172752343132955`", ",", "0.5819513567616237`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.910427170382983`", ",", "0.6335208973316554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9036111816935612`", ",", "0.6837812172045387`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8968270434185763`", ",", "0.7221388211094326`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.890074532827857`", ",", "0.7525000266662797`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.883353429263141`", ",", "0.7764494131608831`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8766635141140386`", ",", "0.8031173514292587`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8700045707943302`", ",", "0.8329976569731875`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.863376384718593`", ",", "0.8635730634498816`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.856778743279149`", ",", "0.8875266128045348`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.850211435823335`", ",", "0.908105729463468`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.84367425363108`", ",", "0.9247920321014504`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8371669898927934`", ",", "0.9387214179665738`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8306894396875584`", ",", "0.951058293866367`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8242413999616187`", ",", "0.9609945707222399`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8178226695071604`", ",", "0.9662577014808247`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.811433048941385`", ",", "0.9708938676697189`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8050723406858613`", ",", "0.9762871841358138`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.798740348946164`", ",", "0.9806597729822351`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7924368796917807`", ",", "0.9831419637154526`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.786161740636294`", ",", "0.9892756643270024`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7799147412178264`", ",", "0.989093832980159`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7736956925797553`", ",", "0.9925583354931099`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7675044075516757`", ",", "0.9954829326689971`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.761340700630625`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.755204387962557`", ",", "0.99988365350752`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7490952873240593`", ",", "0.9975571765755198`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7430132181043154`", ",", "1.0001673664931785`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.736958001287308`", ",", "0.9948625938344897`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7309294594342526`", ",", "0.9955612284701094`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.724927416666265`", ",", "0.9953638795891537`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.71895169864726`", ",", "0.9898169613672168`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7130021325670692`", ",", "0.9825583814439187`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7070785471247834`", ",", "0.9771645374115744`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7011807725123114`", ",", "0.9733515403199671`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.695308640398154`", ",", "0.9648163458021626`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.68946198391139`", ",", "0.9556078583728844`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6836406376258672`", ",", "0.9455340157257689`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.677844437544602`", ",", "0.9349906322874777`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6720732210843767`", ",", "0.9255690142019554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6663268270605394`", ",", "0.9102709537294932`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6606050956719973`", ",", "0.896288290760906`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.654907868486404`", ",", "0.8823064226694416`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.649234988425536`", ",", "0.8651551144820997`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6435862997508544`", ",", "0.8467777260405167`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.637961648049257`", ",", "0.829834347650218`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6323608802190037`", ",", "0.8127473054510013`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.626783844455828`", ",", "0.7953263770616329`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6212303902392193`", ",", "0.7805865316338602`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6157003683188833`", ",", "0.7648888937849638`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.61019363070137`", ",", "0.7490605658972421`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.604710030636871`", ",", "0.7324088079739356`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5992494226061864`", ",", "0.7172611494457697`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5938116623078464`", ",", "0.7005596354144437`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5883966066454085`", ",", "0.6900271717568696`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.583004113714897`", ",", "0.6722616659517147`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.577634042792414`", ",", "0.6567624352803857`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5722862543218894`", ",", "0.6457366636253623`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5669606099030036`", ",", "0.6311441105636804`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5616569722792373`", ",", "0.6138366797275264`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.556375205326084`", ",", "0.6028046244727684`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.551115174039405`", ",", "0.5920413199632898`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5458767445239237`", ",", "0.577594401410153`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5406597839818668`", ",", "0.5679102002182237`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.53546416070174`", ",", "0.5561242662779641`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5302897440472467`", ",", "0.5446532839822975`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5251364044463354`", ",", "0.5331233415894487`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.520004013380388`", ",", "0.5240674252634979`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.514892443373531`", ",", "0.5111228880255906`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.509801567982086`", ",", "0.5001670599649387`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.504731261784143`", ",", "0.49031637220848007`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.499681400369256`", ",", "0.4804242290922158`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.494651860328271`", ",", "0.4707509394866293`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4896425192432745`", ",", "0.45976732725691394`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4846532556776566`", ",", "0.4480989425744584`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4796839491663016`", ",", "0.43613485096963345`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4747344802058895`", ",", "0.4239002679465346`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4698047302453205`", ",", "0.4119426633630314`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4648945816762438`", ",", "0.4038314416204532`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4600039178237116`", ",", "0.3936776978830177`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.455132622936932`", ",", "0.3841698973693164`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4502805821801394`", ",", "0.37260049868694967`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4454476816235715`", ",", "0.36337669657877764`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4406338082345482`", ",", "0.3524550406544461`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.435838849868665`", ",", "0.34430841185944927`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4310626952610797`", ",", "0.33507677143298525`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.426305234017907`", ",", "0.3256496308183144`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.421566356607716`", ",", "0.3172783797877318`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4168459543531204`", ",", "0.30781528190377616`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4121439194224723`", ",", "0.2999700613172195`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.407460144821652`", ",", "0.2927435050519042`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4027945243859508`", ",", "0.2859039829965377`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3981469527720516`", ",", "0.2763733692909211`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.393517325450098`", ",", "0.2695845277591954`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3889055386958584`", ",", "0.26216573358691175`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.384311489582982`", ",", "0.25551535100662354`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3797350759753373`", ",", "0.2507440853459037`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.375176196519446`", ",", "0.24599096696072403`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.370634750636999`", ",", "0.23866913149851582`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.366110638517463`", ",", "0.23399274655309116`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3616037611107634`", ",", "0.22777409749829247`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.357114020120058`", ",", "0.22267906007085572`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3526413179945935`", ",", "0.21753388907585608`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.348185557922634`", ",", "0.21187041193241693`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3437466438244816`", ",", "0.20708571574928406`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3393244803455677`", ",", "0.2014432965626194`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.334918972849625`", ",", "0.19737769610626846`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3305300274119376`", ",", "0.1921310026941717`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3261575508126655`", ",", "0.18733871119033557`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.321801450530245`", ",", "0.18408254435404559`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3174616347348613`", ",", "0.18023624010179648`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3131380122819976`", ",", "0.17572872156798403`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3088304927060532`", ",", "0.1716286163398873`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3045389862140344`", ",", "0.16784526008753395`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.300263403679315`", ",", "0.16372206032719666`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.296003656635464`", ",", "0.15848284377005656`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2917596572701493`", ",", "0.1562045018253743`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2875313184190973`", ",", "0.15163810387674675`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.28331855356013`", ",", "0.14894255210756158`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2791212768072624`", ",", "0.14578687500868776`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.274939402904864`", ",", "0.14121250466109697`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2707728472218878`", ",", "0.13775958341372635`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.266621525746162`", ",", "0.134867437803795`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2624853550787423`", ",", "0.1308838924239052`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2583642524283256`", ",", "0.12790558227849202`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2542581356057285`", ",", "0.12611824953727496`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2501669230184222`", ",", "0.12273053448347596`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.246090533665128`", ",", "0.1200281688815195`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2420288871304717`", ",", "0.11651827018073216`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.237981903579694`", ",", "0.11427004909649831`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2339495037534247`", ",", "0.11071449433868637`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2299316089625014`", ",", "0.11037553506574926`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2259281410828557`", ",", "0.10673862419105819`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2219390225504494`", ",", "0.10462937726740082`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2179641763562628`", ",", "0.10347228716289186`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2140035260413407`", ",", "0.10074459163392789`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2100569956918905`", ",", "0.09877962433721191`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2061245099344315`", ",", "0.0962810035823951`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.202205993930996`", ",", "0.09521312561001465`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1983013733743806`", ",", "0.09274357945154427`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1944105744834523`", ",", "0.09032519364926422`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1905335239984995`", ",", "0.08967382396731327`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1866701491766323`", ",", "0.08895240763180995`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1828203777872375`", ",", "0.08691724901786592`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1789841381074706`", ",", "0.08517404856276149`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1751613589178085`", ",", "0.08415806597121527`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.171351969497637`", ",", "0.082602375438872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.167555899620893`", ",", "0.08141865572510323`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1637730795517465`", ",", "0.07991146296559755`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1600034400403323`", ",", "0.07936347531145589`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.156246912318523`", ",", "0.07788895223702393`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1525034280957476`", ",", "0.07634836139993796`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1487729195548537`", ",", "0.07515598755526363`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1450553193480117`", ",", "0.07497398122213693`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.141350560592661`", ",", "0.0741041793106638`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.137658576867501`", ",", "0.07342066840062307`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1339793022085214`", ",", "0.07128203446726568`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.13031267110507`", ",", "0.07134798844882465`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.12665861849597`", ",", "0.06959912638969071`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1230170797656687`", ",", "0.06980058893519299`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1193879907404285`", ",", "0.0695810916687447`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1157712876845576`", ",", "0.06866528165534215`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1121669072966793`", ",", "0.06806525600542682`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1085747867060385`", ",", "0.06693350067813764`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1049948634688467`", ",", "0.06562710118174027`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.101427075564662`", ",", "0.06729071440793198`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.09787136139281`", ",", "0.06541908491165521`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.094327659768836`", ",", "0.06536219425194825`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.090795909920996`", ",", "0.06597770303696744`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.087276051486786`", ",", "0.06487625998393931`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.083768024509497`", ",", "0.06341155460298457`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.080271769434817`", ",", "0.06353712185666628`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.076787227107455`", ",", "0.06323661901430837`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0733143387678106`", ",", "0.06183237286030143`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.069853046048666`", ",", "0.061273120235234846`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0664032909719183`", ",", "0.06084036414660877`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0629650159453425`", ",", "0.05983282980176157`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.059538163759387`", ",", "0.05997165016384433`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.056122677583998`", ",", "0.05957893691217273`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.052718500965481`", ",", "0.059534308234033315`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0493255778233896`", ",", "0.05811665418572023`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0459438524474436`", ",", "0.05916149443564359`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0425732694944827`", ",", "0.05733109752372156`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0392137739854452`", ",", "0.057382308591793475`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.035865311302382`", ",", "0.05656238152389204`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.032527827185493`", ",", "0.05877232692561184`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.029201267730198`", ",", "0.05692398815950672`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.025885579384233`", ",", "0.056428787911376524`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.022580708944781`", ",", "0.056675807037316527`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0192866035556203`", ",", "0.05744152962460583`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.01600321070431`", ",", "0.05677568518491949`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.012730478219401`", ",", "0.05667498484627819`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0094683542676677`", ",", "0.0555651241383095`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0062167873513768`", ",", "0.05618817312634008`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.002975726305575`", ",", "0.05546218922977412`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9997451202954044`", ",", "0.05529889076121253`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9965249188134475`", ",", "0.05629160315381173`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9933150716770913`", ",", "0.05549150172157214`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9901155290259238`", ",", "0.05517545681907337`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9869262413191517`", ",", "0.05507117490674113`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9837471593330411`", ",", "0.0555734376039142`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9805782341583877`", ",", "0.05575077262203871`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9774194171980075`", ",", "0.057034282030189815`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9742706601642528`", ",", "0.05534726219306934`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9711319150765512`", ",", "0.055196142631538526`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9680031342589694`", ",", "0.05621391959277866`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9648842703377982`", ",", "0.05717183005328022`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9617752762391623`", ",", "0.056079657670365025`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9586761051866524`", ",", "0.05654758697595096`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9555867106989757`", ",", "0.056124653969577554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9525070465876386`", ",", "0.05679277526769997`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9494370669546395`", ",", "0.0564240537350161`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9463767261901894`", ",", "0.05762032211869297`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9433259789704556`", ",", "0.058530112116227245`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9402847802553218`", ",", "0.05716220007123113`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9372530852861733`", ",", "0.057599261786518835`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9342308495836986`", ",", "0.05793430170066067`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9312180289457173`", ",", "0.05736398018282876`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9282145794450247`", ",", "0.05869783110496296`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9252204574272525`", ",", "0.058566059565985054`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9222356195087604`", ",", "0.0583347136916725`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.919260022574537`", ",", "0.0586928097461979`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9162936237761217`", ",", "0.06045634008241971`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9133363805295533`", ",", "0.06026526091360418`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9103882505133296`", ",", "0.05970667665403303`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9074491916663856`", ",", "0.05947733187426874`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8834028169523864`*^9, 3.8834029739274936`*^9, 3.8834032367241*^9, {
   3.8834033084906893`*^9, 3.883403328861749*^9}, {3.883403375406251*^9, 
   3.8834034294824767`*^9}, {3.883414440850815*^9, 3.883414468567665*^9}, 
   3.8834905203581343`*^9, 3.8834906033517857`*^9, 3.883490660619734*^9, 
   3.883490905514903*^9, 3.8835441713272667`*^9, 3.8835442121747713`*^9, 
   3.8835442519207196`*^9, 3.8835457969884577`*^9, 3.883546207223902*^9, 
   3.9704774534027076`*^9},
 CellLabel->
  "Out[252]=",ExpressionUUID->"153cccae-663c-401e-9b3b-50d9d2e56c1e"],

Cell[BoxData["\<\"PL spectrum fig. 3(c), evaporated (blue):\"\>"], "Print",
 CellChangeTimes->{3.970477453408717*^9},
 CellLabel->
  "During evaluation of \
In[246]:=",ExpressionUUID->"8af83270-b94e-40bc-a77b-ca4c6da29da8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.099604936457877`", ",", "0.034671601622747225`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.091875248337034`", ",", "0.04898749233075424`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0841840163759966`", ",", "0.06592398214830825`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.076530954300622`", ",", "0.08542311559980864`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0689157786711654`", ",", "0.11012298100436493`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0613382088472854`", ",", "0.13843206861275664`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0537979669535735`", ",", "0.17324530974000105`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.046294777845579`", ",", "0.21061457301557676`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0388283690763496`", ",", "0.2536628404663739`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0313984708634494`", ",", "0.2973504964951584`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.024004816056465`", ",", "0.34316867758444775`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0166471401049897`", ",", "0.38771882602695185`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0093251810270645`", ",", "0.43124868162784025`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.002038679378089`", ",", "0.470411085684575`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.994787378220171`", ",", "0.5052712689393329`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9875710230919297`", ",", "0.5358119032584855`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9803893619787276`", ",", "0.5616771610369845`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9732421452833346`", ",", "0.5811460105412197`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9661291257970115`", ",", "0.594418998668754`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.959050058671004`", ",", "0.6034167668680284`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9520047013884545`", ",", "0.6101883720336647`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9449928137367003`", ",", "0.6140972875168884`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9380141577799783`", ",", "0.614717479533769`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9310684978325074`", ",", "0.6172968643797316`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.924155600431959`", ",", "0.6207636161333232`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9172752343132955`", ",", "0.6278638282735921`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.910427170382983`", ",", "0.6429333060508815`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9036111816935612`", ",", "0.662403539682668`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8968270434185763`", ",", "0.6768322775393256`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.890074532827857`", ",", "0.687910478157435`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.883353429263141`", ",", "0.7040865099710799`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8766635141140386`", ",", "0.7290614443032362`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8700045707943302`", ",", "0.7597496519170914`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.863376384718593`", ",", "0.7938064075541322`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.856778743279149`", ",", "0.8280961389157738`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.850211435823335`", ",", "0.8608237346763997`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.84367425363108`", ",", "0.8902275739473782`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8371669898927934`", ",", "0.9157350535786906`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8306894396875584`", ",", "0.941302853663783`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8242413999616187`", ",", "0.9600424182952757`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8178226695071604`", ",", "0.9746570329404911`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.811433048941385`", ",", "0.983868499825248`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8050723406858613`", ",", "0.9901722227371863`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.798740348946164`", ",", "0.9960100230113447`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7924368796917807`", ",", "0.9999999999999999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.786161740636294`", ",", "0.9973519053690756`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7799147412178264`", ",", "0.994115097619087`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7736956925797553`", ",", "0.98867713963815`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7675044075516757`", ",", "0.9863159526078289`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.761340700630625`", ",", "0.9809166269505287`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.755204387962557`", ",", "0.97349058581165`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7490952873240593`", ",", "0.9657736636101713`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7430132181043154`", ",", "0.960512223920458`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.736958001287308`", ",", "0.9535528894447155`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7309294594342526`", ",", "0.9508335631002924`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.724927416666265`", ",", "0.9475043922044004`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.71895169864726`", ",", "0.9443842666386812`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7130021325670692`", ",", "0.9442477963885721`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7070785471247834`", ",", "0.9425805247338855`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7011807725123114`", ",", "0.9407403094670407`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.695308640398154`", ",", "0.9422966002190372`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.68946198391139`", ",", "0.9440429889903863`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6836406376258672`", ",", "0.9469625962593924`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.677844437544602`", ",", "0.9466687627187148`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6720732210843767`", ",", "0.9495208500839748`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6663268270605394`", ",", "0.9465441915408287`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6606050956719973`", ",", "0.9449041915939084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.654907868486404`", ",", "0.9431684337685515`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.649234988425536`", ",", "0.936397813115055`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6435862997508544`", ",", "0.9286421955094964`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.637961648049257`", ",", "0.9234499507028263`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6323608802190037`", ",", "0.9149726657998484`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.626783844455828`", ",", "0.9088780904592889`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6212303902392193`", ",", "0.9005193867622658`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6157003683188833`", ",", "0.8924508511754605`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.61019363070137`", ",", "0.8860079558342134`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.604710030636871`", ",", "0.8753189097038817`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5992494226061864`", ",", "0.8656747393667784`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5938116623078464`", ",", "0.8543575277219368`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5883966066454085`", ",", "0.8477577428880783`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.583004113714897`", ",", "0.835228054595022`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.577634042792414`", ",", "0.8240692512854244`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5722862543218894`", ",", "0.8143962751959846`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5669606099030036`", ",", "0.8036885232444019`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5616569722792373`", ",", "0.7925086681042488`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.556375205326084`", ",", "0.7826793830768076`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.551115174039405`", ",", "0.7728821907677355`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5458767445239237`", ",", "0.7629281004559131`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5406597839818668`", ",", "0.7513526295660041`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.53546416070174`", ",", "0.7430196504521913`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5302897440472467`", ",", "0.7339776273652291`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5251364044463354`", ",", "0.7264027885334962`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.520004013380388`", ",", "0.7176878119266424`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.514892443373531`", ",", "0.708174495311714`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.509801567982086`", ",", "0.6985812569093622`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.504731261784143`", ",", "0.6911103688986621`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.499681400369256`", ",", "0.6836950598682506`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.494651860328271`", ",", "0.6759689301553051`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4896425192432745`", ",", "0.6668404043686402`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4846532556776566`", ",", "0.6575459290268595`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4796839491663016`", ",", "0.648860554516554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4747344802058895`", ",", "0.6374699574073289`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4698047302453205`", ",", "0.6278476064997717`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4648945816762438`", ",", "0.6197113550945011`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4600039178237116`", ",", "0.6102455693817881`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.455132622936932`", ",", "0.6017445597202588`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4502805821801394`", ",", "0.5920329661564304`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4454476816235715`", ",", "0.5823705685923667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4406338082345482`", ",", "0.575300498287294`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.435838849868665`", ",", "0.566354052141323`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4310626952610797`", ",", "0.5569444813355964`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.426305234017907`", ",", "0.5508816732721697`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.421566356607716`", ",", "0.5420193291720647`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4168459543531204`", ",", "0.5335977754176094`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4121439194224723`", ",", "0.5242392365688403`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.407460144821652`", ",", "0.5167519740291173`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4027945243859508`", ",", "0.5092090966027588`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3981469527720516`", ",", "0.49858869201182054`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.393517325450098`", ",", "0.4916222378289458`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3889055386958584`", ",", "0.4839390334571224`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.384311489582982`", ",", "0.47743362558683156`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3797350759753373`", ",", "0.47069562413960064`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.375176196519446`", ",", "0.46450082601235543`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.370634750636999`", ",", "0.4578705706024284`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.366110638517463`", ",", "0.4507273783487774`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3616037611107634`", ",", "0.4447652240448047`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.357114020120058`", ",", "0.4387139628186555`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3526413179945935`", ",", "0.4297964708073931`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.348185557922634`", ",", "0.4241072839355283`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3437466438244816`", ",", "0.4192165237465137`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3393244803455677`", ",", "0.4118996920452424`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.334918972849625`", ",", "0.40319026381221096`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3305300274119376`", ",", "0.39866457313735393`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3261575508126655`", ",", "0.39181283090504776`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.321801450530245`", ",", "0.38541004405445034`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3174616347348613`", ",", "0.38275295011374416`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3131380122819976`", ",", "0.37515056013125964`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3088304927060532`", ",", "0.3693547133461752`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3045389862140344`", ",", "0.3633228307332415`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.300263403679315`", ",", "0.35756597700711246`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.296003656635464`", ",", "0.35017699422444787`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2917596572701493`", ",", "0.3450606353223996`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2875313184190973`", ",", "0.33847386229267085`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.28331855356013`", ",", "0.3328125411398335`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2791212768072624`", ",", "0.32748524778107624`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.274939402904864`", ",", "0.32195178259812934`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2707728472218878`", ",", "0.31701464651286815`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.266621525746162`", ",", "0.3124457470756158`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2624853550787423`", ",", "0.3058030327011705`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2583642524283256`", ",", "0.3007510630043659`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2542581356057285`", ",", "0.2963836563552797`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2501669230184222`", ",", "0.2913952168413926`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.246090533665128`", ",", "0.28672565972849967`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2420288871304717`", ",", "0.28214653659521016`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.237981903579694`", ",", "0.27675685651881604`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2339495037534247`", ",", "0.27435825749822573`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2299316089625014`", ",", "0.2679368679184508`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2259281410828557`", ",", "0.2645154029310274`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2219390225504494`", ",", "0.2596520045692065`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2179641763562628`", ",", "0.25660773673993137`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2140035260413407`", ",", "0.25373018532691344`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2100569956918905`", ",", "0.2476675820960884`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2061245099344315`", ",", "0.24436115257855648`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.202205993930996`", ",", "0.24102664231463236`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1983013733743806`", ",", "0.23689800434639413`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1944105744834523`", ",", "0.23334747411950343`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1905335239984995`", ",", "0.23113083210265287`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1866701491766323`", ",", "0.22708794692794357`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1828203777872375`", ",", "0.22322352546835947`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1789841381074706`", ",", "0.2200469805183852`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1751613589178085`", ",", "0.2168746581947317`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.171351969497637`", ",", "0.21331780085990393`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.167555899620893`", ",", "0.2105288155060812`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1637730795517465`", ",", "0.20666116395457118`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1600034400403323`", ",", "0.20533372078911324`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.156246912318523`", ",", "0.20133097734417038`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1525034280957476`", ",", "0.19906472525692237`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1487729195548537`", ",", "0.19675471124731447`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1450553193480117`", ",", "0.19228987823577465`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.141350560592661`", ",", "0.19117333081294674`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.137658576867501`", ",", "0.18825303845090127`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1339793022085214`", ",", "0.18643815556491108`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.13031267110507`", ",", "0.18228429802641463`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.12665861849597`", ",", "0.18011832352360088`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1230170797656687`", ",", "0.17722115600616195`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1193879907404285`", ",", "0.1752730485771674`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1157712876845576`", ",", "0.17194396829386158`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1121669072966793`", ",", "0.1699767110700516`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1085747867060385`", ",", "0.16838854118930982`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1049948634688467`", ",", "0.164493452089265`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.101427075564662`", ",", "0.161849129258721`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.09787136139281`", ",", "0.15855860128110424`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.094327659768836`", ",", "0.15666480129802976`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.090795909920996`", ",", "0.15516785748891523`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.087276051486786`", ",", "0.15394765457009676`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.083768024509497`", ",", "0.15159730939414245`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.080271769434817`", ",", "0.1490414881406126`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.076787227107455`", ",", "0.14755290399137722`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0733143387678106`", ",", "0.14520199634208705`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.069853046048666`", ",", "0.14488195577791385`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0664032909719183`", ",", "0.14316602112356963`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0629650159453425`", ",", "0.142339372529791`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.059538163759387`", ",", "0.13783533418824323`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.056122677583998`", ",", "0.13491220951263125`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.052718500965481`", ",", "0.13531683111312262`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0493255778233896`", ",", "0.13407458991278676`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0459438524474436`", ",", "0.1326377576710275`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0425732694944827`", ",", "0.12991153769188715`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0392137739854452`", ",", "0.1279968263139389`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.035865311302382`", ",", "0.12812443019707573`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.032527827185493`", ",", "0.12676769466654814`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.029201267730198`", ",", "0.12523225514040823`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.025885579384233`", ",", "0.12235942086729422`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.022580708944781`", ",", "0.1217137067717784`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0192866035556203`", ",", "0.12111659434776338`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.01600321070431`", ",", "0.11800419163318682`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.012730478219401`", ",", "0.11716979510977742`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0094683542676677`", ",", "0.11452295649878151`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0062167873513768`", ",", "0.11567738873349194`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.002975726305575`", ",", "0.11289593666433408`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9997451202954044`", ",", "0.11221768753561215`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9965249188134475`", ",", "0.11131756807628701`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9933150716770913`", ",", "0.10773881148338779`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9901155290259238`", ",", "0.10834384382839837`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9869262413191517`", ",", "0.10694677753792338`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9837471593330411`", ",", "0.10500320035945435`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9805782341583877`", ",", "0.10310947426944556`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9774194171980075`", ",", "0.10188538875907495`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9742706601642528`", ",", "0.10104683402655121`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9711319150765512`", ",", "0.10226760520802762`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9680031342589694`", ",", "0.10058855286371277`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9648842703377982`", ",", "0.09862261221392091`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9617752762391623`", ",", "0.09747829851867185`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9586761051866524`", ",", "0.0958811742851936`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9555867106989757`", ",", "0.09724920457752503`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9525070465876386`", ",", "0.09314983551900577`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9494370669546395`", ",", "0.09281950892673886`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9463767261901894`", ",", "0.09287401055333362`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9433259789704556`", ",", "0.09031733474961488`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9402847802553218`", ",", "0.0919539719122372`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9372530852861733`", ",", "0.0901089451046019`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9342308495836986`", ",", "0.08924183058103413`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9312180289457173`", ",", "0.0855582724091376`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9282145794450247`", ",", "0.08935148610856808`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9252204574272525`", ",", "0.08785296679436548`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9222356195087604`", ",", "0.08539047083751744`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.919260022574537`", ",", "0.08590067469479536`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9162936237761217`", ",", "0.08417414022127354`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9133363805295533`", ",", "0.08326543703459836`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9103882505133296`", ",", "0.08121133841705754`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9074491916663856`", ",", "0.08119863354628831`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8834028169523864`*^9, 3.8834029739274936`*^9, 3.8834032367241*^9, {
   3.8834033084906893`*^9, 3.883403328861749*^9}, {3.883403375406251*^9, 
   3.8834034294824767`*^9}, {3.883414440850815*^9, 3.883414468567665*^9}, 
   3.8834905203581343`*^9, 3.8834906033517857`*^9, 3.883490660619734*^9, 
   3.883490905514903*^9, 3.8835441713272667`*^9, 3.8835442121747713`*^9, 
   3.8835442519207196`*^9, 3.8835457969884577`*^9, 3.883546207223902*^9, 
   3.9704774534234467`*^9},
 CellLabel->
  "Out[254]=",ExpressionUUID->"f8bd30d0-8939-4d94-909b-8a42955acd8b"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0], PointSize[0.009166666666666668], 
          AbsoluteThickness[2], LineBox[CompressedData["
1:eJwtVAk0FQgbleXtz3tIslSWJFvRRlLfF1pojOYZUgn1YhLjFfNrQSRiErJF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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0]], 
             Line[CompressedData["
1:eJwtVAk0FQgbleXtz3tIslSWJFvRRlLfF1pojOYZUgn1YhLjFfNrQSRiErJF
llJDpciSLA3JkiHZ6dm3x7MM8ZJlCL85Z+453/nOPeeec+937jmf0jkOy1FY
SEjower8u4+XKT54TiGg77tFW9ruMFiOkqzZK0PA0rXDN3jkUNhWXn+yXYWA
JsaTYscO3wUtHzG7IB0Cpm3pMxZNCoGjsQ+mjPcT8OtyS0ludzDU6r7UYJgR
MJUtUncz+TaonYlSHbUm4DWdwMsBcQFgXTq00MgmoEGQxK8GDv4QceRyRfUl
Am57V1RAxJtwpBITG3wIWBl54Fc9i5vwW2ZCIv8OASNTR6IsY/zgZCmhjxpH
QM3CwqUsZy9IKDS5iakEFG33yHa64gl9lBMJATkEnC9wfXFojgO86BumbSUE
nLzvKE1iXARpe8Nn+2oJKP9ss5Ak+yJ0W7EaXnUQcHO42g+983bAplT06Y4Q
sCusVs8u3R6k/sf9VjFDwPS/KlmilJ+B+1Za/YIIERd51TigehwIM8fi5SWI
2ON6TPG6MwvUv4c49m4kollIyOwtO2WI3K39/LUWEYX+Qxe71jfOYJVnRfzG
c90HVtd/ooQdJaKamN52U3V7YHvwHaOtiWgUbnzWOvJXENIQzn55noj2162c
1speh117zlNa3IloojiQIOj2h6pP6yLoN4mYtv3HVP/pEFj/hHPeJpyIIs6O
s0T9GNjRwEzJTSIiL3hk88efH4Hu+1GOcjoRBYyFvDURT0FYRn/k8dvVe26f
lX+8NRO8U4O1d1YTsYu7pe7+ZC5QbAscPnOJ2HevXGqjZhEUH5x5EsIn4ga7
j+LtMWVA5pRIW84QUfrGGUaORhUo0cY6tERJ+N2kbgt/tg6WWIlrZaVImCGv
cUPMqRn0Y1hDMsokXDNXzVQe5kLaoV6Oui4JCy9VaOWIdcOSmCvXHEn4Qe/P
pkOm/bCj4DoEWpCwJd3EXLBrEDSj+TX1diTUHcz1/7RpGH48OJSs7UbC6D9H
hdx4o2Dzjch76ENCx3N+Vy4cH4erEYb5KqEkjPcn79Lf+wUeNdUZFSWSsDy7
pHzYdxJOuju/vJBO+q+fKRA5LSOjXkTCR5+fpnPLJiG+wyR9qYaE7ztDSl//
9QW2dL6P4Heu5p1RKtbaMQEDm9594f1NQv5L1biCA3+DclDL2MwiCRPCA3pz
FUdB+yfhVwo0MjqZUss01w7DtEuGg40CGSdaVXQ24BBMladopmmRcYopnsat
4YFcvJI+Yz8ZXdinE5PKB4DRW5V5x5yMH84fzjfaNQBZUelF8nZkLJXK9tqt
NQD/bDP/vcyNjBp6TbmZyQMQQ05AX18yZiaPJ2WH84BXN0dn3SOjLEWULLIw
CPXTehv2PSbjkS02pg+r+eC+MyXeIIeMUdKHd31oHYEXEos5x8vJuFXPOUZl
dgzesN2jfFrIeOLQh/V98+Mw01PgXDpExlP2zlauf3yBbxlzbIU5Ms71b6rp
+zQJtdSWrDASBQ1k7h87pjEF8vxLvuvlKJhSmfbeS3wK3AMvrRRqUtCtQ3Xl
ouIkPDecdfDYT8Eq7fzTkxITINj4vMXEgoK5exqrnr4Yg8WirJBtZym412Uh
Y/rOCGiPvs/X8aDg6al2Q4+bfNh0SyLkWCAF9xlG1xDyBsHfzFHfN5aCSyXv
FG8c5MGtQsp0TRoFK7Xj9sjrDkAXv/uLbhEFpaN/2uoU2A/VHDOH7DoKHskd
9TPV7weus7m3WT8Fje8RpWSN+mHM9srVpWkKjv3BVfK82w8eh77c+UigYpat
ZLIncQA0H3HGsmWp6C2nFjPxbACsrrLqXmtRke6TsvjzKR5UhP7u1gBUtBwV
4gTN86CZkypCsqSieoDahXr3QfDO+lx5yomKYkXrnLIzBuEPuSlB1TUqlryN
+Gvs9iAMfb1QwgqlolyqalriCg9EjOwvzidT8RfW+s3NcjzQVI/f9jaXilFy
J3S2j/eDAd49GldFxdP6TdnliX0Ay1YzkV1UzInTvRoc2AO/aFW5v5iiYvh3
4YaPgk7wYjut9IjS0Mtf0im2qB1so507dGRp6Gkku1dRwAVWQplxsjYNIzl1
fdaJn6GrR8Fb24iG/nmskoW8Vmj5p6+izZqGgWrpAmXlVjh7Wc/hiQsNPejl
qXuHWqDTkxpxx4+G3vVfTeW7WmD4DT0hIoaGR0N2FgsJtwJpe35Z/gsabuhY
65ii1wptG38wXyqhYb934KKPVSuYfu3xO9dKwzLJstv7rFtB8qhlyvAYDd+4
2JCvqbRC+orDyl0hOm5IJ986mNoCwtaxHax1dFw3epVQN9wMhkwH371adDRh
RsVsFWuG0Vxh/YNGdHxjaKhksr4JipufWVy0oeO0n1cTWaURTtraSr5xoyPf
+p/AR8YNYCgqXasUSEcPC8ZdZNSDS1F2bVYCHQ0sPXfbLdZC55417HM5dLTX
7g9VdKqFXd4VXXuq6VhumCkItqoF7cickG19dEyL9f4WeK4W8nZ4l5rO0TG6
Pq/90+taSIiubwgWF8fIBXMPuk0d5ByypY+riuPhnprebrl6kJLh1njsF8fQ
l/eVvi3WQ5v88llFq1W96l1P/wsNEPY2cctXV3HsV/ix5WFnA8w3hl8eDRBH
yw1JZm+PNoKboDqBkCSOQXsurvuQ0wgWqSdWTN+I46XBgKR7Kk3A57LnXteK
43R1oMD/SRO4HjHsM+Gv+uuF+lntaAYjCWuZpWVx3M/eN89pbgYFS9ZilwwD
z4yEW4d4t8DLAeHxQR0G8v59x1GtMCrPMZM2Y+Cd0PQA99jPMFnZdtWNzUCV
SCotyosLsdKlHVPeDPQThLGUf2mD4MKJlsT7DMx9/6Kowq0dDku51bpnMXAN
Q2yndVwHFFxP1vT4yMCk9ekBGkOdUPdYz+bhIAP/lyEHsk7dUC+Bxd+WGRhi
bHLNRaoXVvol2X/SmPjKjWI5cbkPqH93cSTlmLhQyDQLutYPmdoKRb5qTCw2
yhd+kjgAV1Sf+YrsZqKdzitX8REeDH9gTCcZMXGiLE0v6sQQNIY/tbA4zkTh
rcSzKfN8OJ7nUy9jx8QDRJXx79wRKLJ0zZhzYeKpWbfKpPExEMuUUJ28tsqd
XLLCDkxAcUSb+3IQE8+ojTlUlUyCVeZCs+p9Jp6YjaGqbRVA7M7vCmsTmBj/
4F8I4P82pVQa
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {2.0000000000000044`, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.009166666666666668], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.009166666666666668], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0]], 
          Line[CompressedData["
1:eJwtVAk0FQgbleXtz3tIslSWJFvRRlLfF1pojOYZUgn1YhLjFfNrQSRiErJF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           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {2.0000000000000044`, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.009166666666666668], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[1, 0, 0], PointSize[0.007333333333333334], 
          AbsoluteThickness[2], LineBox[CompressedData["
1:eJwdlmk41A3Uxv+zS7yyZGmRfUtlqR4lzzkiWwslSyUqKdoo2kRR2igRSfbs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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.007333333333333334], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]], 
             Line[CompressedData["
1:eJwdlmk41A3Uxv+zS7yyZGmRfUtlqR4lzzkiWwslSyUqKdoo2kRR2igRSfbs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              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {2.0000000000000044`, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.007333333333333334], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.007333333333333334], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.007333333333333334], 
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0]], 
          Line[CompressedData["
1:eJwdlmk41A3Uxv+zS7yyZGmRfUtlqR4lzzkiWwslSyUqKdoo2kRR2igRSfbs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           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {2.0000000000000044`, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.007333333333333334], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0], AbsoluteThickness[2], Opacity[1.], 
          Dashing[{0.01, 0.01}], LineBox[CompressedData["
1:eJwtl3k4lN/7x80+UtKmUlHIUpKkSHHflZAtpD2lkkSSpRKSSiIhylYSZQtJ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           "]], LineBox[CompressedData["
1:eJwtlnk4Ve3Xx1HSvRuEHg2UiCaESEpai5Qhw3GiZA4VB5nKkEPOkQwdKkJU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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[0, 0, 0]], 
             Line[CompressedData["
1:eJwtl3k4lN/7x80+UtKmUlHIUpKkSHHflZAtpD2lkkSSpRKSSiIhylYSZQtJ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              "]], 
             Line[CompressedData["
1:eJwtlnk4Ve3Xx1HSvRuEHg2UiCaESEpai5Qhw3GiZA4VB5nKkEPOkQwdKkJU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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 3.3}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[0, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{2., 3.3}, {0., 1.1}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {2.0000000000000044`, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             Dashing[{0.01, 0.01}], 
             RGBColor[0, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[0, 0, 0]], 
          Line[CompressedData["
1:eJwtl3k4lN/7x80+UtKmUlHIUpKkSHHflZAtpD2lkkSSpRKSSiIhylYSZQtJ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           "]], 
          Line[CompressedData["
1:eJwtlnk4Ve3Xx1HSvRuEHg2UiCaESEpai5Qhw3GiZA4VB5nKkEPOkQwdKkJU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           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{2., 3.3}, {0., 1.1}}, 
        "Frame" -> {{True, True}, {True, True}}, 
        "AxesOrigin" -> {2.0000000000000044`, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[0, 0, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 1], PointSize[0.007333333333333334], 
          AbsoluteThickness[2], LineBox[CompressedData["
1:eJwdVAk0FYrzvvu9oTwkVAjJElL0UtRMKltERClbpCgPqWyRbjwVPSItlqRs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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.007333333333333334], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1]], 
             Line[CompressedData["
1:eJwdVAk0FYrzvvu9oTwkVAjJElL0UtRMKltERClbpCgPqWyRbjwVPSItlqRs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              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {2.0000000000000044`, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.007333333333333334], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 1]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.007333333333333334], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.007333333333333334], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 1]], 
          Line[CompressedData["
1:eJwdVAk0FYrzvvu9oTwkVAjJElL0UtRMKltERClbpCgPqWyRbjwVPSItlqRs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           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {2.0000000000000044`, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.007333333333333334], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 1]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.0000000000000044`, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{210.06666666666604`, Automatic},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentSet", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{2., 4.}, {0., 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8834028169523864`*^9, 3.8834029739274936`*^9, 3.8834032367241*^9, {
   3.8834033084906893`*^9, 3.883403328861749*^9}, {3.883403375406251*^9, 
   3.8834034294824767`*^9}, {3.883414440850815*^9, 3.883414468567665*^9}, 
   3.8834905203581343`*^9, 3.8834906033517857`*^9, 3.883490660619734*^9, 
   3.883490905514903*^9, 3.8835441713272667`*^9, 3.8835442121747713`*^9, 
   3.8835442519207196`*^9, 3.8835457969884577`*^9, 3.883546207223902*^9, 
   3.9704774534356804`*^9},
 CellLabel->
  "Out[255]=",ExpressionUUID->"950556f6-c84b-41b6-9b44-62e58285218d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 3(d)", "Section",
 CellChangeTimes->{{3.8833843525810685`*^9, 3.883384363491805*^9}, {
  3.8833843945097036`*^9, 3.883384460977248*^9}, {3.8833845019553537`*^9, 
  3.883384543737305*^9}, {3.8833846683921633`*^9, 3.8833847899712024`*^9}, {
  3.883387868027631*^9, 3.8833878804621415`*^9}, {3.970475105180176*^9, 
  3.970475119574576*^9}, {3.9704778555301237`*^9, 3.9704778559275365`*^9}, {
  3.970477931501977*^9, 
  3.970477931926512*^9}},ExpressionUUID->"97926c78-de20-4f82-ac02-\
36a2abd82efe"],

Cell[BoxData["\<\"Absorption spectrum fig. 3(d):\"\>"], "Print",
 CellChangeTimes->{3.9704776767574067`*^9},
 CellLabel->
  "During evaluation of \
In[288]:=",ExpressionUUID->"f054e3a0-b353-4248-ae41-cd802b9cc83e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.755204387962557`", ",", 
     RowBox[{"-", "0.00025514369693010065`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.761340700630625`", ",", "0.0005091534218738454`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7675044075516757`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7736956925797553`", ",", "0.00038016410842585006`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.7799147412178264`", ",", "0.00012643787647869433`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.786161740636294`", ",", 
     RowBox[{"-", "0.00037846315044635974`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7924368796917807`", ",", "0.00037761267145654904`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.798740348946164`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8050723406858613`", ",", "0.0005012156179693534`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.811433048941385`", ",", "0.00025004082299149867`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.8178226695071604`", ",", "0.001621579940489128`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8242413999616187`", ",", "0.003111335637564413`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8306894396875584`", ",", "0.004842627367733484`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8371669898927934`", ",", "0.005822662656941702`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.84367425363108`", ",", "0.006550956165178885`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.850211435823335`", ",", "0.009495597920748965`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.856778743279149`", ",", "0.01316484777560053`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.863376384718593`", ",", "0.0176763553233181`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8700045707943302`", ",", "0.02314663618549967`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8766635141140386`", ",", "0.029691072011757004`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.883353429263141`", ",", "0.03839912638798172`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.890074532827857`", ",", "0.04901225370128456`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8968270434185763`", ",", "0.06030349626242833`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9036111816935612`", ",", "0.07493088440743158`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.910427170382983`", ",", "0.09238753265839321`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9172752343132955`", ",", "0.11277351404310912`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.924155600431959`", ",", "0.137029174831265`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9310684978325074`", ",", "0.16404719137818424`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9380141577799783`", ",", "0.19452495645547574`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9449928137367003`", ",", "0.2291530590028304`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9520047013884545`", ",", "0.26849621706945354`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.959050058671004`", ",", "0.3131134788446186`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9661291257970115`", ",", "0.3611882212061833`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9732421452833346`", ",", "0.41233942956673203`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9803893619787276`", ",", "0.46689708977429434`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9875710230919297`", ",", "0.526128982509616`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.994787378220171`", ",", "0.5875346995427827`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.002038679378089`", ",", "0.6475839025872705`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0093251810270645`", ",", "0.7075690362145297`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0166471401049897`", ",", "0.7669058213585893`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.024004816056465`", ",", "0.8237370953987954`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0313984708634494`", ",", "0.8744846097322013`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0388283690763496`", ",", "0.9200005443065535`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.046294777845579`", ",", "0.9573215468285072`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0537979669535735`", ",", "0.9846647298425141`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0613382088472854`", ",", "1.0021023840627044`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0689157786711654`", ",", "1.0077597703026346`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.076530954300622`", ",", "1.0035516002612674`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0841840163759966`", ",", "0.9880694807315483`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.091875248337034`", ",", "0.9651490719573266`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.099604936457877`", ",", "0.9367742579287323`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.107373369882583`", ",", "0.9050227588177663`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.115180840661183`", ",", "0.8739828271282387`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1230276437862736`", ",", "0.8446631309420135`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.130914077230179`", ",", "0.8210932397126062`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.13884044198266`", ",", "0.806590021500109`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1468070420892147`", ",", "0.8014205267073086`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1548141846899513`", ",", "0.8049571018397562`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1628621800590575`", ",", "0.817133409536251`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.170951341644887`", ",", "0.8367746548189274`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1790819861106425`", ",", "0.8617223220117574`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1872544333757085`", ",", "0.8898394409064522`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.195469006657605`", ",", "0.9198905490238771`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2037260325146018`", ",", "0.949226404310908`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.212025840888992`", ",", "0.9735835555918427`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.220368765151041`", ",", "0.9908165278684957`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2287551421436214`", ",", "1.0000000000000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2371853122275476`", ",", "0.9981558780571886`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.24565961932762`", ",", "0.9846120001451485`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.254178410979398`", ",", "0.9611883913019814`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2627420383767123`", ",", "0.9277478409173382`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2713508564199225`", ",", "0.8848000693990858`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.280005223764949`", ",", "0.8255633572828218`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.288705502873079`", ",", "0.7689790056426448`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.297452060061571`", ",", "0.727393134480006`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3062452655550687`", ",", "0.6916520384280428`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3150854935378358`", ",", "0.6647854071413023`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.323973122206838`", ",", "0.646723501342623`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3329085338256745`", ",", "0.6360256096233399`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.341892114779382`", ",", "0.6315812899158141`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.350924255630137`", ",", "0.6314523006023661`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3600053511738497`", ",", "0.6335115937295887`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.369135800497692`", ",", "0.6359677770520358`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3783160070385576`", ",", "0.6378810712860152`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.387546378642488`", ",", "0.6390482119529721`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3968273276250707`", ",", "0.6380265031932651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4061592708328323`", ",", "0.6325635931489949`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4155426297056493`", ",", "0.6225931444589593`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.424977830340195`", ",", "0.6065105867624648`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.434465303554434`", ",", "0.5827294932505989`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.444005484953197`", ",", "0.5543762246897453`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4535988149948493`", ",", "0.5221005470280863`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4632457390590807`", ",", "0.48756032730967414`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4729467075158285`", ",", "0.45441942902242555`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.482702175795367`", ",", "0.4228694934320343`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4925126044595802`", ",", "0.3960184542601059`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.502378459274437`", ",", "0.37473124863923374`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.512300211283714`", ",", "0.3578611473982147`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.522278336883951`", ",", "0.3451720008708905`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.532313317900714`", ",", "0.33513634879163956`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5424056416661447`", ",", "0.3276328561579215`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5525558010978533`", ",", "0.3216508704368967`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.562764294779169`", ",", "0.31589511212714994`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.57303162704078`", ",", "0.3108557406197838`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5833583080437883`", ",", "0.3050554739095726`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.593744853864205`", ",", "0.2973274548225561`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.604191786578927`", ",", "0.2882738224834894`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.614699634353209`", ",", "0.27742029310907906`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.62526893152968`", ",", "0.265073889614631`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.635900218718917`", ",", "0.25115154855214455`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.6465940428916195`", ",", "0.2370171547282096`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.657350957472421`", ",", "0.22344209258654474`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.668171522435357`", ",", "0.2120510604906017`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.679056304401041`", ",", "0.20101014224544594`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.690005876735567`", ",", "0.1930791421728718`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.701020819651196`", ",", "0.18766102402206256`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.712101720308835`", ",", "0.18463898867842368`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7232491729223742`", ",", "0.18408617733507518`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7344637788649124`", ",", "0.18419220371579942`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7457461467768907`", ",", "0.18551413155889396`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.757096892676214`", ",", "0.1888828788373612`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7685166400703674`", ",", "0.1926941586835039`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7800060200705814`", ",", "0.19843148994847234`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7915656715081063`", ",", "0.20375945732636622`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8031962410526097`", ",", "0.21089951193845705`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.814898383332771`", ",", "0.2189132919660353`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8266727610591067`", ",", "0.2294456237753103`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.838520045149074`", ",", "0.2424726939545685`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.850440914854505`", ",", "0.25724041113288343`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8624360578914345`", ",", "0.2760067970280863`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8745061705723467`", ",", "0.2966470716307424`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.886651957940911`", ",", "0.31805731321213443`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.898874133909279`", ",", "0.34771153113433484`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9111734213979514`", ",", "0.37573509734015537`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9235505524783245`", ",", "0.40115619783728873`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.936006268517939`", ",", "0.4261410026126715`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9485413203285056`", ",", "0.45033599589955736`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9611564683167755`", ",", "0.4730372645874157`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9738524826383035`", ",", "0.4961150119747443`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9866301433541826`", ",", "0.519828634153422`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.999490240590809`", ",", "0.5454887192466797`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.0124335747027535`", ",", "0.5720236637274113`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.025460956438802`", ",", "0.6022173688221206`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.038573207111241`", ",", "0.6355972517054939`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.051771158768466`", ",", "0.6729108834095363`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.065055654370986`", ",", "0.7131663219391828`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.0784275479708905`", ",", "0.7565044633137383`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.091887704894887`", ",", "0.8038370210102329`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.105437001930962`", ",", "0.8533235584948112`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.119076327518774`", ",", "0.9063047141483418`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.132806581943837`", ",", "0.9624020248203787`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.146628677535621`", ",", "1.01997009715872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.160543538869634`", ",", "1.0800039915813917`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.174552102973572`", ",", "1.1423905943827564`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.188655319537672`", ",", "1.2046683358734307`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.202854151129324`", ",", "1.270597183667175`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.217149573412077`", ",", "1.3379684438275636`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.231542575369115`", ",", "1.4070117456818347`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.246034159531337`", ",", "1.4792777959213301`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.26062534221014`", ",", "1.5540683512954494`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.275317153735002`", ",", "1.6320918608026713`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.883412773239509*^9, 3.883413024058403*^9, 3.883413075422851*^9, {
   3.883413127637083*^9, 3.883413155103816*^9}, 3.8834132086613703`*^9, {
   3.883491456513119*^9, 3.883491471307083*^9}, 3.8835445735134554`*^9, 
   3.8835449132561483`*^9, 3.88354618202835*^9, {3.883546219395859*^9, 
   3.88354624230682*^9}, 3.970477676773119*^9},
 CellLabel->
  "Out[292]=",ExpressionUUID->"612e3b4d-6279-4b7b-aa03-b5b77d07d327"],

Cell[BoxData["\<\"PL spectrum fig. 3(b), solution processed (red):\"\>"], \
"Print",
 CellChangeTimes->{3.970477676773119*^9},
 CellLabel->
  "During evaluation of \
In[288]:=",ExpressionUUID->"b76a10d8-b3de-47b2-aa49-d28f1dc1df72"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.0613382088472854`", ",", "0.01467392334240132`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0537979669535735`", ",", "0.019732591325289633`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.046294777845579`", ",", "0.024808102254747406`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0388283690763496`", ",", "0.03223981658836714`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0313984708634494`", ",", "0.04037945865815157`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.024004816056465`", ",", "0.05202615068138718`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0166471401049897`", ",", "0.06482636815595247`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0093251810270645`", ",", "0.0781361096369225`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.002038679378089`", ",", "0.09444949475655226`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.994787378220171`", ",", "0.11606836964217447`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9875710230919297`", ",", "0.13543883644904017`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9803893619787276`", ",", "0.16161669285342803`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9732421452833346`", ",", "0.1923334056989602`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9661291257970115`", ",", "0.2226351592956838`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.959050058671004`", ",", "0.2546094083920625`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9520047013884545`", ",", "0.28851411542975175`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9449928137367003`", ",", "0.32538290578101975`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9380141577799783`", ",", "0.36198475618938397`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9310684978325074`", ",", "0.40310426707976404`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.924155600431959`", ",", "0.4390091990588054`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9172752343132955`", ",", "0.48380166672988884`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.910427170382983`", ",", "0.5268801543064279`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9036111816935612`", ",", "0.5754154332318243`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8968270434185763`", ",", "0.6110537521369122`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.890074532827857`", ",", "0.6374733732745814`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.883353429263141`", ",", "0.6572630795019639`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8766635141140386`", ",", "0.6810848296740332`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8700045707943302`", ",", "0.7074898497230844`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.863376384718593`", ",", "0.7424629430735624`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.856778743279149`", ",", "0.7701931455172275`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.850211435823335`", ",", "0.7949414732075449`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.84367425363108`", ",", "0.8052968534113307`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8371669898927934`", ",", "0.8264029836984653`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8306894396875584`", ",", "0.8471884635522463`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8242413999616187`", ",", "0.8482731645984342`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8178226695071604`", ",", "0.8668728212936146`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.811433048941385`", ",", "0.8656247991970334`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8050723406858613`", ",", "0.8776917682976618`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.798740348946164`", ",", "0.8903379924672983`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7924368796917807`", ",", "0.8983644663627888`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.786161740636294`", ",", "0.9019317634860191`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7799147412178264`", ",", "0.9082989922775522`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7736956925797553`", ",", "0.9215198858709982`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7675044075516757`", ",", "0.9341126285121156`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.761340700630625`", ",", "0.9369011892539897`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.755204387962557`", ",", "0.9535208213961528`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7490952873240593`", ",", "0.9532955691051643`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7430132181043154`", ",", "0.965914479779938`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.736958001287308`", ",", "0.9689658632556455`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7309294594342526`", ",", "0.9698738837249232`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.724927416666265`", ",", "0.9812482600364933`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.71895169864726`", ",", "0.9882441285792678`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7130021325670692`", ",", "0.986962962417823`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7070785471247834`", ",", "0.9976391168893627`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7011807725123114`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.695308640398154`", ",", "0.9897645181288727`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.68946198391139`", ",", "0.9833758677211402`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6836406376258672`", ",", "0.9872173407133172`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.677844437544602`", ",", "0.9827823660508769`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6720732210843767`", ",", "0.9868957451068058`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6663268270605394`", ",", "0.9760809337997459`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6606050956719973`", ",", "0.9648132781690044`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.654907868486404`", ",", "0.9567041702498958`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.649234988425536`", ",", "0.9544702853151444`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6435862997508544`", ",", "0.9378501388478426`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.637961648049257`", ",", "0.9319178764639019`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6323608802190037`", ",", "0.9115599174412768`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.626783844455828`", ",", "0.893337303082892`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6212303902392193`", ",", "0.8825304345423219`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6157003683188833`", ",", "0.8692349376556538`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.61019363070137`", ",", "0.8578646755108275`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.604710030636871`", ",", "0.8428104295491746`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5992494226061864`", ",", "0.8375133154242611`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5938116623078464`", ",", "0.8252371785281215`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5883966066454085`", ",", "0.815773144390464`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.583004113714897`", ",", "0.7960368111402354`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.577634042792414`", ",", "0.7921154613003479`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5722862543218894`", ",", "0.7709552276570473`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5669606099030036`", ",", "0.7649888729258629`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5616569722792373`", ",", "0.7523203663050655`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.556375205326084`", ",", "0.7365111816584845`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.551115174039405`", ",", "0.7218882101512297`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5458767445239237`", ",", "0.719741437594209`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5406597839818668`", ",", "0.6989099658491075`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.53546416070174`", ",", "0.6897716840576826`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5302897440472467`", ",", "0.681025339421858`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5251364044463354`", ",", "0.6631925309700599`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.520004013380388`", ",", "0.6573505860821456`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.514892443373531`", ",", "0.6423816548887459`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.509801567982086`", ",", "0.6356549036620585`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.504731261784143`", ",", "0.6222288053835869`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.499681400369256`", ",", "0.6143691664257314`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.494651860328271`", ",", "0.6119641724323583`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4896425192432745`", ",", "0.5931737401024924`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4846532556776566`", ",", "0.5807600638518151`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4796839491663016`", ",", "0.5602876028570701`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4747344802058895`", ",", "0.5640215261098909`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4698047302453205`", ",", "0.5356048948884576`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4648945816762438`", ",", "0.5250851323104674`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4600039178237116`", ",", "0.5173510858556821`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.455132622936932`", ",", "0.507121455923854`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4502805821801394`", ",", "0.49655724664608564`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4454476816235715`", ",", "0.48369839965745676`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4406338082345482`", ",", "0.47675052570178`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.435838849868665`", ",", "0.4610241787418348`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4310626952610797`", ",", "0.45091679858318084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.426305234017907`", ",", "0.4402820383949334`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.421566356607716`", ",", "0.4287757127044824`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4168459543531204`", ",", "0.41852430759001646`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4121439194224723`", ",", "0.4081738000785201`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.407460144821652`", ",", "0.40162923809572`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4027945243859508`", ",", "0.3931799373082255`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3981469527720516`", ",", "0.3807345716386204`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.393517325450098`", ",", "0.3675128956131116`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3889055386958584`", ",", "0.3624241575105012`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.384311489582982`", ",", "0.3553969948024864`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3797350759753373`", ",", "0.3487585622417437`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.375176196519446`", ",", "0.3359834193208898`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.370634750636999`", ",", "0.33804160670557226`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.366110638517463`", ",", "0.32610595236172724`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3616037611107634`", ",", "0.3234223296241922`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.357114020120058`", ",", "0.3086086076906504`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3526413179945935`", ",", "0.3059337841621239`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.348185557922634`", ",", "0.2939637250546912`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3437466438244816`", ",", "0.29026890463661037`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3393244803455677`", ",", "0.2804710174145094`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.334918972849625`", ",", "0.2780453784894412`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3305300274119376`", ",", "0.2695629330058168`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3261575508126655`", ",", "0.2668601095136048`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.321801450530245`", ",", "0.2579150785282889`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3174616347348613`", ",", "0.2533122242255983`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3131380122819976`", ",", "0.2521537380379405`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3088304927060532`", ",", "0.25061823996002247`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3045389862140344`", ",", "0.23275109701967298`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.300263403679315`", ",", "0.23021138741964944`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.296003656635464`", ",", "0.22747944629514563`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2917596572701493`", ",", "0.22328429780619807`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2875313184190973`", ",", "0.21522612146536946`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.28331855356013`", ",", "0.21262841178029354`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2791212768072624`", ",", "0.20878356285202235`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.274939402904864`", ",", "0.2017878644427234`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2707728472218878`", ",", "0.20270218541232377`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.266621525746162`", ",", "0.1923124375464862`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2624853550787423`", ",", "0.19134913856714822`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2583642524283256`", ",", "0.18348041773940374`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2542581356057285`", ",", "0.18076605187680864`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2501669230184222`", ",", "0.17587478892794833`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.246090533665128`", ",", "0.1724388906789237`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2420288871304717`", ",", "0.16234445518763427`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.237981903579694`", ",", "0.1622540616244303`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2339495037534247`", ",", "0.15497704920759114`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2299316089625014`", ",", "0.15648999794833204`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2259281410828557`", ",", "0.14868692066359854`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2219390225504494`", ",", "0.1515903939834883`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2179641763562628`", ",", "0.14535039936109492`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2140035260413407`", ",", "0.144368188715995`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2100569956918905`", ",", "0.14055034935177532`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2061245099344315`", ",", "0.1346758677187301`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.202205993930996`", ",", "0.13439168945581376`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1983013733743806`", ",", "0.1310898182591208`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1944105744834523`", ",", "0.1302283654723705`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1905335239984995`", ",", "0.12314091673792932`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1866701491766323`", ",", "0.12192228371823201`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1828203777872375`", ",", "0.12169601749461113`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1789841381074706`", ",", "0.11825649982054358`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1751613589178085`", ",", "0.1120882260868091`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.171351969497637`", ",", "0.10931000252557689`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.167555899620893`", ",", "0.11233046984236285`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1637730795517465`", ",", "0.10769873093580899`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1600034400403323`", ",", "0.10896932666270495`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.156246912318523`", ",", "0.1077082148541531`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1525034280957476`", ",", "0.10554860189080525`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1487729195548537`", ",", "0.10071934186623188`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1450553193480117`", ",", "0.10352804211765707`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.141350560592661`", ",", "0.0973121558138416`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.137658576867501`", ",", "0.09708587864037019`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1339793022085214`", ",", "0.09489816272869434`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.13031267110507`", ",", "0.09466465886004168`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.12665861849597`", ",", "0.09218828975462459`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1230170797656687`", ",", "0.08826828863190923`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1193879907404285`", ",", "0.0917276526468156`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1157712876845576`", ",", "0.0916425858595152`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1121669072966793`", ",", "0.08458754949917986`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1085747867060385`", ",", "0.08483020540415773`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1049948634688467`", ",", "0.09103155164186033`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.101427075564662`", ",", "0.08440376402360576`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.09787136139281`", ",", "0.08019459016174801`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.094327659768836`", ",", "0.07712971027203624`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.090795909920996`", ",", "0.0759717439016842`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.087276051486786`", ",", "0.07447658149274844`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.083768024509497`", ",", "0.0756543914313499`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.080271769434817`", ",", "0.0758969863891037`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.076787227107455`", ",", "0.07187194317059467`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0733143387678106`", ",", "0.07356123538428512`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.069853046048666`", ",", "0.07502958342255063`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0664032909719183`", ",", "0.06924073389464855`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.883412773239509*^9, 3.883413024058403*^9, 3.883413075422851*^9, {
   3.883413127637083*^9, 3.883413155103816*^9}, 3.8834132086613703`*^9, {
   3.883491456513119*^9, 3.883491471307083*^9}, 3.8835445735134554`*^9, 
   3.8835449132561483`*^9, 3.88354618202835*^9, {3.883546219395859*^9, 
   3.88354624230682*^9}, 3.9704776767887397`*^9},
 CellLabel->
  "Out[294]=",ExpressionUUID->"654953c5-f9d5-4788-8292-a727b75da5cd"],

Cell[BoxData["\<\"PL spectrum fig. 3(c), evaporated (blue):\"\>"], "Print",
 CellChangeTimes->{3.9704776767887397`*^9},
 CellLabel->
  "During evaluation of \
In[288]:=",ExpressionUUID->"f32d7521-6cb9-4a5c-9ecd-9e558a948bd4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.099604936457877`", ",", "0.002403916341047743`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.091875248337034`", ",", "0.003632634931275249`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0841840163759966`", ",", "0.005119020022542031`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.076530954300622`", ",", "0.0070215420702888455`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0689157786711654`", ",", "0.009503047438769768`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0613382088472854`", ",", "0.01279020968751439`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0537979669535735`", ",", "0.01723199075436083`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.046294777845579`", ",", "0.02243640954997182`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0388283690763496`", ",", "0.029572737693419303`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0313984708634494`", ",", "0.037663640562201305`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.024004816056465`", ",", "0.04838298323043081`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0166471401049897`", ",", "0.06129369069042321`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0093251810270645`", ",", "0.07683181193202766`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.002038679378089`", ",", "0.09603938898859563`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.994787378220171`", ",", "0.11801024049655616`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9875710230919297`", ",", "0.14450946857302738`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9803893619787276`", ",", "0.17486957349129398`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9732421452833346`", ",", "0.20834304473201296`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9661291257970115`", ",", "0.24563043536585813`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.959050058671004`", ",", "0.28641733073763603`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9520047013884545`", ",", "0.33241847244843087`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9449928137367003`", ",", "0.3795719869389862`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9380141577799783`", ",", "0.42697774652235776`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9310684978325074`", ",", "0.47846436309433`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.924155600431959`", ",", "0.5291821914478552`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9172752343132955`", ",", "0.5819513567616237`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.910427170382983`", ",", "0.6335208973316554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9036111816935612`", ",", "0.6837812172045387`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8968270434185763`", ",", "0.7221388211094326`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.890074532827857`", ",", "0.7525000266662797`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.883353429263141`", ",", "0.7764494131608831`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8766635141140386`", ",", "0.8031173514292587`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8700045707943302`", ",", "0.8329976569731875`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.863376384718593`", ",", "0.8635730634498816`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.856778743279149`", ",", "0.8875266128045348`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.850211435823335`", ",", "0.908105729463468`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.84367425363108`", ",", "0.9247920321014504`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8371669898927934`", ",", "0.9387214179665738`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8306894396875584`", ",", "0.951058293866367`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8242413999616187`", ",", "0.9609945707222399`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8178226695071604`", ",", "0.9662577014808247`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.811433048941385`", ",", "0.9708938676697189`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8050723406858613`", ",", "0.9762871841358138`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.798740348946164`", ",", "0.9806597729822351`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7924368796917807`", ",", "0.9831419637154526`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.786161740636294`", ",", "0.9892756643270024`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7799147412178264`", ",", "0.989093832980159`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7736956925797553`", ",", "0.9925583354931099`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7675044075516757`", ",", "0.9954829326689971`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.761340700630625`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.755204387962557`", ",", "0.99988365350752`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7490952873240593`", ",", "0.9975571765755198`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7430132181043154`", ",", "1.0001673664931785`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.736958001287308`", ",", "0.9948625938344897`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7309294594342526`", ",", "0.9955612284701094`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.724927416666265`", ",", "0.9953638795891537`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.71895169864726`", ",", "0.9898169613672168`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7130021325670692`", ",", "0.9825583814439187`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7070785471247834`", ",", "0.9771645374115744`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7011807725123114`", ",", "0.9733515403199671`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.695308640398154`", ",", "0.9648163458021626`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.68946198391139`", ",", "0.9556078583728844`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6836406376258672`", ",", "0.9455340157257689`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.677844437544602`", ",", "0.9349906322874777`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6720732210843767`", ",", "0.9255690142019554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6663268270605394`", ",", "0.9102709537294932`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6606050956719973`", ",", "0.896288290760906`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.654907868486404`", ",", "0.8823064226694416`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.649234988425536`", ",", "0.8651551144820997`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6435862997508544`", ",", "0.8467777260405167`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.637961648049257`", ",", "0.829834347650218`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6323608802190037`", ",", "0.8127473054510013`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.626783844455828`", ",", "0.7953263770616329`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6212303902392193`", ",", "0.7805865316338602`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6157003683188833`", ",", "0.7648888937849638`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.61019363070137`", ",", "0.7490605658972421`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.604710030636871`", ",", "0.7324088079739356`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5992494226061864`", ",", "0.7172611494457697`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5938116623078464`", ",", "0.7005596354144437`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5883966066454085`", ",", "0.6900271717568696`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.583004113714897`", ",", "0.6722616659517147`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.577634042792414`", ",", "0.6567624352803857`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5722862543218894`", ",", "0.6457366636253623`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5669606099030036`", ",", "0.6311441105636804`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5616569722792373`", ",", "0.6138366797275264`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.556375205326084`", ",", "0.6028046244727684`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.551115174039405`", ",", "0.5920413199632898`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5458767445239237`", ",", "0.577594401410153`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5406597839818668`", ",", "0.5679102002182237`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.53546416070174`", ",", "0.5561242662779641`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5302897440472467`", ",", "0.5446532839822975`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5251364044463354`", ",", "0.5331233415894487`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.520004013380388`", ",", "0.5240674252634979`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.514892443373531`", ",", "0.5111228880255906`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.509801567982086`", ",", "0.5001670599649387`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.504731261784143`", ",", "0.49031637220848007`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.499681400369256`", ",", "0.4804242290922158`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.494651860328271`", ",", "0.4707509394866293`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4896425192432745`", ",", "0.45976732725691394`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4846532556776566`", ",", "0.4480989425744584`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4796839491663016`", ",", "0.43613485096963345`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4747344802058895`", ",", "0.4239002679465346`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4698047302453205`", ",", "0.4119426633630314`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4648945816762438`", ",", "0.4038314416204532`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4600039178237116`", ",", "0.3936776978830177`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.455132622936932`", ",", "0.3841698973693164`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4502805821801394`", ",", "0.37260049868694967`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4454476816235715`", ",", "0.36337669657877764`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4406338082345482`", ",", "0.3524550406544461`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.435838849868665`", ",", "0.34430841185944927`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4310626952610797`", ",", "0.33507677143298525`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.426305234017907`", ",", "0.3256496308183144`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.421566356607716`", ",", "0.3172783797877318`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4168459543531204`", ",", "0.30781528190377616`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4121439194224723`", ",", "0.2999700613172195`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.407460144821652`", ",", "0.2927435050519042`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4027945243859508`", ",", "0.2859039829965377`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3981469527720516`", ",", "0.2763733692909211`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.393517325450098`", ",", "0.2695845277591954`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3889055386958584`", ",", "0.26216573358691175`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.384311489582982`", ",", "0.25551535100662354`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3797350759753373`", ",", "0.2507440853459037`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.375176196519446`", ",", "0.24599096696072403`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.370634750636999`", ",", "0.23866913149851582`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.366110638517463`", ",", "0.23399274655309116`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3616037611107634`", ",", "0.22777409749829247`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.357114020120058`", ",", "0.22267906007085572`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3526413179945935`", ",", "0.21753388907585608`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.348185557922634`", ",", "0.21187041193241693`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3437466438244816`", ",", "0.20708571574928406`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3393244803455677`", ",", "0.2014432965626194`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.334918972849625`", ",", "0.19737769610626846`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3305300274119376`", ",", "0.1921310026941717`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3261575508126655`", ",", "0.18733871119033557`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.321801450530245`", ",", "0.18408254435404559`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3174616347348613`", ",", "0.18023624010179648`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3131380122819976`", ",", "0.17572872156798403`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3088304927060532`", ",", "0.1716286163398873`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3045389862140344`", ",", "0.16784526008753395`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.300263403679315`", ",", "0.16372206032719666`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.296003656635464`", ",", "0.15848284377005656`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2917596572701493`", ",", "0.1562045018253743`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2875313184190973`", ",", "0.15163810387674675`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.28331855356013`", ",", "0.14894255210756158`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2791212768072624`", ",", "0.14578687500868776`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.274939402904864`", ",", "0.14121250466109697`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2707728472218878`", ",", "0.13775958341372635`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.266621525746162`", ",", "0.134867437803795`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2624853550787423`", ",", "0.1308838924239052`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2583642524283256`", ",", "0.12790558227849202`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2542581356057285`", ",", "0.12611824953727496`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2501669230184222`", ",", "0.12273053448347596`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.246090533665128`", ",", "0.1200281688815195`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2420288871304717`", ",", "0.11651827018073216`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.237981903579694`", ",", "0.11427004909649831`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2339495037534247`", ",", "0.11071449433868637`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2299316089625014`", ",", "0.11037553506574926`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2259281410828557`", ",", "0.10673862419105819`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2219390225504494`", ",", "0.10462937726740082`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2179641763562628`", ",", "0.10347228716289186`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2140035260413407`", ",", "0.10074459163392789`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2100569956918905`", ",", "0.09877962433721191`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2061245099344315`", ",", "0.0962810035823951`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.202205993930996`", ",", "0.09521312561001465`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1983013733743806`", ",", "0.09274357945154427`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1944105744834523`", ",", "0.09032519364926422`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1905335239984995`", ",", "0.08967382396731327`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1866701491766323`", ",", "0.08895240763180995`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1828203777872375`", ",", "0.08691724901786592`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1789841381074706`", ",", "0.08517404856276149`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1751613589178085`", ",", "0.08415806597121527`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.171351969497637`", ",", "0.082602375438872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.167555899620893`", ",", "0.08141865572510323`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1637730795517465`", ",", "0.07991146296559755`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1600034400403323`", ",", "0.07936347531145589`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.156246912318523`", ",", "0.07788895223702393`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1525034280957476`", ",", "0.07634836139993796`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1487729195548537`", ",", "0.07515598755526363`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1450553193480117`", ",", "0.07497398122213693`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.141350560592661`", ",", "0.0741041793106638`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.137658576867501`", ",", "0.07342066840062307`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1339793022085214`", ",", "0.07128203446726568`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.13031267110507`", ",", "0.07134798844882465`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.12665861849597`", ",", "0.06959912638969071`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1230170797656687`", ",", "0.06980058893519299`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1193879907404285`", ",", "0.0695810916687447`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1157712876845576`", ",", "0.06866528165534215`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1121669072966793`", ",", "0.06806525600542682`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1085747867060385`", ",", "0.06693350067813764`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1049948634688467`", ",", "0.06562710118174027`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.101427075564662`", ",", "0.06729071440793198`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.09787136139281`", ",", "0.06541908491165521`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.094327659768836`", ",", "0.06536219425194825`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.090795909920996`", ",", "0.06597770303696744`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.087276051486786`", ",", "0.06487625998393931`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.083768024509497`", ",", "0.06341155460298457`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.080271769434817`", ",", "0.06353712185666628`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.076787227107455`", ",", "0.06323661901430837`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0733143387678106`", ",", "0.06183237286030143`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.069853046048666`", ",", "0.061273120235234846`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0664032909719183`", ",", "0.06084036414660877`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0629650159453425`", ",", "0.05983282980176157`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.059538163759387`", ",", "0.05997165016384433`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.056122677583998`", ",", "0.05957893691217273`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.052718500965481`", ",", "0.059534308234033315`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0493255778233896`", ",", "0.05811665418572023`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0459438524474436`", ",", "0.05916149443564359`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0425732694944827`", ",", "0.05733109752372156`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0392137739854452`", ",", "0.057382308591793475`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.035865311302382`", ",", "0.05656238152389204`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.032527827185493`", ",", "0.05877232692561184`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.029201267730198`", ",", "0.05692398815950672`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.025885579384233`", ",", "0.056428787911376524`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.022580708944781`", ",", "0.056675807037316527`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0192866035556203`", ",", "0.05744152962460583`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.01600321070431`", ",", "0.05677568518491949`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.012730478219401`", ",", "0.05667498484627819`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0094683542676677`", ",", "0.0555651241383095`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0062167873513768`", ",", "0.05618817312634008`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.002975726305575`", ",", "0.05546218922977412`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9997451202954044`", ",", "0.05529889076121253`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9965249188134475`", ",", "0.05629160315381173`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9933150716770913`", ",", "0.05549150172157214`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9901155290259238`", ",", "0.05517545681907337`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9869262413191517`", ",", "0.05507117490674113`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9837471593330411`", ",", "0.0555734376039142`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9805782341583877`", ",", "0.05575077262203871`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9774194171980075`", ",", "0.057034282030189815`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9742706601642528`", ",", "0.05534726219306934`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9711319150765512`", ",", "0.055196142631538526`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9680031342589694`", ",", "0.05621391959277866`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9648842703377982`", ",", "0.05717183005328022`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9617752762391623`", ",", "0.056079657670365025`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9586761051866524`", ",", "0.05654758697595096`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9555867106989757`", ",", "0.056124653969577554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9525070465876386`", ",", "0.05679277526769997`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9494370669546395`", ",", "0.0564240537350161`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9463767261901894`", ",", "0.05762032211869297`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9433259789704556`", ",", "0.058530112116227245`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9402847802553218`", ",", "0.05716220007123113`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9372530852861733`", ",", "0.057599261786518835`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9342308495836986`", ",", "0.05793430170066067`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9312180289457173`", ",", "0.05736398018282876`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9282145794450247`", ",", "0.05869783110496296`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9252204574272525`", ",", "0.058566059565985054`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9222356195087604`", ",", "0.0583347136916725`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.919260022574537`", ",", "0.0586928097461979`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9162936237761217`", ",", "0.06045634008241971`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9133363805295533`", ",", "0.06026526091360418`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9103882505133296`", ",", "0.05970667665403303`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9074491916663856`", ",", "0.05947733187426874`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.883412773239509*^9, 3.883413024058403*^9, 3.883413075422851*^9, {
   3.883413127637083*^9, 3.883413155103816*^9}, 3.8834132086613703`*^9, {
   3.883491456513119*^9, 3.883491471307083*^9}, 3.8835445735134554`*^9, 
   3.8835449132561483`*^9, 3.88354618202835*^9, {3.883546219395859*^9, 
   3.88354624230682*^9}, 3.970477676804366*^9},
 CellLabel->
  "Out[296]=",ExpressionUUID->"81277924-898a-4641-bb7e-d66ecb237412"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0], PointSize[0.009166666666666668], 
          AbsoluteThickness[2], 
          LineBox[{{2.757252860292402, 0.}, {2.761340700630625, 
           0.0005091534218738454}, {2.7675044075516757`, 0.}, {
           2.7736956925797553`, 0.00038016410842585006`}, {
           2.7799147412178264`, 0.00012643787647869433`}, {
           2.7814791217572066`, 0.}}], LineBox[CompressedData["
1:eJxFVWk0FQgbtuTuGzJkqakZNQYNoUwx74usM5auiEZ166YouaEFkfZFy0Qq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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0]], 
             
             Line[{{2.757252860292402, 0.}, {2.761340700630625, 
              0.0005091534218738454}, {2.7675044075516757`, 0.}, {
              2.7736956925797553`, 0.00038016410842585006`}, {
              2.7799147412178264`, 0.00012643787647869433`}, {
              2.7814791217572066`, 0.}}], 
             Line[CompressedData["
1:eJxFVWk0FQgbtuTuGzJkqakZNQYNoUwx74usM5auiEZ166YouaEFkfZFy0Qq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              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {2.0000000000000044`, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.009166666666666668], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.009166666666666668], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0]], 
          
          Line[{{2.757252860292402, 0.}, {2.761340700630625, 
           0.0005091534218738454}, {2.7675044075516757`, 0.}, {
           2.7736956925797553`, 0.00038016410842585006`}, {
           2.7799147412178264`, 0.00012643787647869433`}, {
           2.7814791217572066`, 0.}}], 
          Line[CompressedData["
1:eJxFVWk0FQgbtuTuGzJkqakZNQYNoUwx74usM5auiEZ166YouaEFkfZFy0Qq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           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {2.0000000000000044`, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.009166666666666668], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[1, 0, 0], PointSize[0.009166666666666668], 
          AbsoluteThickness[2], LineBox[CompressedData["
1:eJwdk3lYzYvzx8/nc7ZW7atIpb1o0806g6gUUSpdFBKFlCikRbRQtK8K0a6u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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]], 
             Line[CompressedData["
1:eJwdk3lYzYvzx8/nc7ZW7atIpb1o0806g6gUUSpdFBKFlCikRbRQtK8K0a6u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              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {2.0000000000000044`, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.009166666666666668], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.009166666666666668], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.009166666666666668], 
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0]], 
          Line[CompressedData["
1:eJwdk3lYzYvzx8/nc7ZW7atIpb1o0806g6gUUSpdFBKFlCikRbRQtK8K0a6u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           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {2.0000000000000044`, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.009166666666666668], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0], AbsoluteThickness[2], Opacity[1.], 
          Dashing[{0.01, 0.01}], LineBox[CompressedData["
1:eJwtl3k0Fd7Xxu/sZiqzJKGIUgkhYu+klChKKVESKkKGylBRSSOKypCkRIok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           "]], LineBox[CompressedData["
1:eJxF03tM03cQAPAOyuyVFXlWkJcgMEAefdmWqr2rgiAChUUewjDSgWOo80XY
soziBIukNe4BKq7DQQrOZUMZzAzNwIFBsWBnnKKCzWYA18KG4MAtSLffkiX7
JpdvPn/cXXKXC9Hse63EicViyZn49x/qmqp+sgyI9d/rnW0SZnEY9/TWjy3O
Kw9zuq6FAFB5yYJCkuOOquDB3DnG78ZaP+3y8EcnqdXexwX63FF6MSAsFPvT
nlV+4gqUlzHc/nV3ONa8wfEofgWo7MXtRlFkFCa9F2iS8IB2zNQeV+2JwZc/
Eslc3IAu8Vht+4/E4/VzyTfvMnY0tf79pViIx3peL2xbDpQv/v5hv16EW+4e
eFrhDiSQqeeGr4uRO62rTvYAGggs3uY9KUGzk5Hv6wlUmM9e/nh8LRr8Os7/
yli+Uy440ifFdMHA+m4voDMtnAGslKFb8qilzpvJr6+0lnjJ0VL4VJPvw/Q/
f7YWq+X4YbnLQjQf6Gj2O5YVZjlm6VfWLTI+y+VdS7DJ0bMlPmBoBZC/oXOh
wSzDO98lXjD6AlliGwwVJMV6y/aNe/2AbA81u2YaJMhfqi518wfS7Rn3+XFJ
gCvz7ndlBgHtdbaWdThCsW9K+EgUDLR/sPEObA7Csiq9i88qoMNT42rXJT56
ek3EPmcsaXrb4JzkjpfblDkPQph9hLufDPyAjRrFae2VUGY+NpCGb/lDyb01
2/bZaia/7+dv7Y1m5TdFWy1VYUBz6geXbrr+pSyYNz0vCgdaZu0v4N5wQ3ad
IzgxAmj7xi+CTWo//CogLyXiVaCLB7lpLHsIvtjk2miPBJqYqJWPzsSgaaT4
h6EooMns37RjJMS03T229migjmdb769xiNH48QHFoRigl2ok7MCwBEyMMGuy
Y4GaUxKLRg6tw+nuML0sDihj2jt1tW4D1qdrO/3igfh5NufjGYjrfxkZXWRc
rXAqy9xJOF4uZFsFQD4nf6qaf0Jo4OhjrgqBUsW8yUWZCiXG8W0tIqBzuvTe
qFQVPopXVtaIgbLYsrgkXxXq+k+17pIw9VbtzvY2Esblzg6nrAU61sy/cLkJ
8Z49dSFaClThebB9KHcDarWmIJ4MaOz9Nb/bcxQY4enYPMN4cPBoZ/MJKd5q
zd13Ww6U8rh/U+W8ECsSOk51JgDd25F1w+vPSAwa5l5tUABNl469qS7wxbdG
tFcy1/1/b/8AJcJhDw==
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[0, 0, 0]], 
             Line[CompressedData["
1:eJwtl3k0Fd7Xxu/sZiqzJKGIUgkhYu+klChKKVESKkKGylBRSSOKypCkRIok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              "]], 
             Line[CompressedData["
1:eJxF03tM03cQAPAOyuyVFXlWkJcgMEAefdmWqr2rgiAChUUewjDSgWOo80XY
soziBIukNe4BKq7DQQrOZUMZzAzNwIFBsWBnnKKCzWYA18KG4MAtSLffkiX7
JpdvPn/cXXKXC9Hse63EicViyZn49x/qmqp+sgyI9d/rnW0SZnEY9/TWjy3O
Kw9zuq6FAFB5yYJCkuOOquDB3DnG78ZaP+3y8EcnqdXexwX63FF6MSAsFPvT
nlV+4gqUlzHc/nV3ONa8wfEofgWo7MXtRlFkFCa9F2iS8IB2zNQeV+2JwZc/
Eslc3IAu8Vht+4/E4/VzyTfvMnY0tf79pViIx3peL2xbDpQv/v5hv16EW+4e
eFrhDiSQqeeGr4uRO62rTvYAGggs3uY9KUGzk5Hv6wlUmM9e/nh8LRr8Os7/
yli+Uy440ifFdMHA+m4voDMtnAGslKFb8qilzpvJr6+0lnjJ0VL4VJPvw/Q/
f7YWq+X4YbnLQjQf6Gj2O5YVZjlm6VfWLTI+y+VdS7DJ0bMlPmBoBZC/oXOh
wSzDO98lXjD6AlliGwwVJMV6y/aNe/2AbA81u2YaJMhfqi518wfS7Rn3+XFJ
gCvz7ndlBgHtdbaWdThCsW9K+EgUDLR/sPEObA7Csiq9i88qoMNT42rXJT56
ek3EPmcsaXrb4JzkjpfblDkPQph9hLufDPyAjRrFae2VUGY+NpCGb/lDyb01
2/bZaia/7+dv7Y1m5TdFWy1VYUBz6geXbrr+pSyYNz0vCgdaZu0v4N5wQ3ad
IzgxAmj7xi+CTWo//CogLyXiVaCLB7lpLHsIvtjk2miPBJqYqJWPzsSgaaT4
h6EooMns37RjJMS03T229migjmdb769xiNH48QHFoRigl2ok7MCwBEyMMGuy
Y4GaUxKLRg6tw+nuML0sDihj2jt1tW4D1qdrO/3igfh5NufjGYjrfxkZXWRc
rXAqy9xJOF4uZFsFQD4nf6qaf0Jo4OhjrgqBUsW8yUWZCiXG8W0tIqBzuvTe
qFQVPopXVtaIgbLYsrgkXxXq+k+17pIw9VbtzvY2Esblzg6nrAU61sy/cLkJ
8Z49dSFaClThebB9KHcDarWmIJ4MaOz9Nb/bcxQY4enYPMN4cPBoZ/MJKd5q
zd13Ww6U8rh/U+W8ECsSOk51JgDd25F1w+vPSAwa5l5tUABNl469qS7wxbdG
tFcy1/1/b/8AJcJhDw==
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 3.3}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              Dashing[{0.01, 0.01}], 
              RGBColor[0, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{2., 3.3}, {0., 1.1}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {2.0000000000000044`, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             Dashing[{0.01, 0.01}], 
             RGBColor[0, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[0, 0, 0]], 
          Line[CompressedData["
1:eJwtl3k0Fd7Xxu/sZiqzJKGIUgkhYu+klChKKVESKkKGylBRSSOKypCkRIok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           "]], 
          Line[CompressedData["
1:eJxF03tM03cQAPAOyuyVFXlWkJcgMEAefdmWqr2rgiAChUUewjDSgWOo80XY
soziBIukNe4BKq7DQQrOZUMZzAzNwIFBsWBnnKKCzWYA18KG4MAtSLffkiX7
JpdvPn/cXXKXC9Hse63EicViyZn49x/qmqp+sgyI9d/rnW0SZnEY9/TWjy3O
Kw9zuq6FAFB5yYJCkuOOquDB3DnG78ZaP+3y8EcnqdXexwX63FF6MSAsFPvT
nlV+4gqUlzHc/nV3ONa8wfEofgWo7MXtRlFkFCa9F2iS8IB2zNQeV+2JwZc/
Eslc3IAu8Vht+4/E4/VzyTfvMnY0tf79pViIx3peL2xbDpQv/v5hv16EW+4e
eFrhDiSQqeeGr4uRO62rTvYAGggs3uY9KUGzk5Hv6wlUmM9e/nh8LRr8Os7/
yli+Uy440ifFdMHA+m4voDMtnAGslKFb8qilzpvJr6+0lnjJ0VL4VJPvw/Q/
f7YWq+X4YbnLQjQf6Gj2O5YVZjlm6VfWLTI+y+VdS7DJ0bMlPmBoBZC/oXOh
wSzDO98lXjD6AlliGwwVJMV6y/aNe/2AbA81u2YaJMhfqi518wfS7Rn3+XFJ
gCvz7ndlBgHtdbaWdThCsW9K+EgUDLR/sPEObA7Csiq9i88qoMNT42rXJT56
ek3EPmcsaXrb4JzkjpfblDkPQph9hLufDPyAjRrFae2VUGY+NpCGb/lDyb01
2/bZaia/7+dv7Y1m5TdFWy1VYUBz6geXbrr+pSyYNz0vCgdaZu0v4N5wQ3ad
IzgxAmj7xi+CTWo//CogLyXiVaCLB7lpLHsIvtjk2miPBJqYqJWPzsSgaaT4
h6EooMns37RjJMS03T229migjmdb769xiNH48QHFoRigl2ok7MCwBEyMMGuy
Y4GaUxKLRg6tw+nuML0sDihj2jt1tW4D1qdrO/3igfh5NufjGYjrfxkZXWRc
rXAqy9xJOF4uZFsFQD4nf6qaf0Jo4OhjrgqBUsW8yUWZCiXG8W0tIqBzuvTe
qFQVPopXVtaIgbLYsrgkXxXq+k+17pIw9VbtzvY2Esblzg6nrAU61sy/cLkJ
8Z49dSFaClThebB9KHcDarWmIJ4MaOz9Nb/bcxQY4enYPMN4cPBoZ/MJKd5q
zd13Ww6U8rh/U+W8ECsSOk51JgDd25F1w+vPSAwa5l5tUABNl469qS7wxbdG
tFcy1/1/b/8AJcJhDw==
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{2., 3.3}, {0., 1.1}}, 
        "Frame" -> {{True, True}, {True, True}}, 
        "AxesOrigin" -> {2.0000000000000044`, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           Dashing[{0.01, 0.01}], 
           RGBColor[0, 0, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 1], PointSize[0.007333333333333334], 
          AbsoluteThickness[2], LineBox[CompressedData["
1:eJwdlmk41A3Uxv+zS7yyZGmRfUtlqR4lzzkiWwslSyUqKdoo2kRR2igRSfbs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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.007333333333333334], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1]], 
             Line[CompressedData["
1:eJwdlmk41A3Uxv+zS7yyZGmRfUtlqR4lzzkiWwslSyUqKdoo2kRR2igRSfbs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              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {2.0000000000000044`, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.007333333333333334], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 1]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {2.0000000000000044`, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.007333333333333334], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.007333333333333334], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 1]], 
          Line[CompressedData["
1:eJwdlmk41A3Uxv+zS7yyZGmRfUtlqR4lzzkiWwslSyUqKdoo2kRR2igRSfbs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           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{2., 4.}, {0., 1.1}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {2.0000000000000044`, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.007333333333333334], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 1]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.0000000000000044`, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{238.0666666666666, Automatic},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentSet", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{2., 4.}, {0., 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.883412773239509*^9, 3.883413024058403*^9, 3.883413075422851*^9, {
   3.883413127637083*^9, 3.883413155103816*^9}, 3.8834132086613703`*^9, {
   3.883491456513119*^9, 3.883491471307083*^9}, 3.8835445735134554`*^9, 
   3.8835449132561483`*^9, 3.88354618202835*^9, {3.883546219395859*^9, 
   3.88354624230682*^9}, 3.9704776768200893`*^9},
 CellLabel->
  "Out[297]=",ExpressionUUID->"e4de8041-d07a-4bd0-b59f-35597e3b9ba9"]
}, Open  ]]
},
WindowSize->{1141.2, 568.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>0.9 Inherited,
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"6f722c00-02a6-460d-90e8-c6c7fcab8c7d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 262, 7, 83, "Section",ExpressionUUID->"b9fbdcd2-79ec-4fc3-b7c6-2e80748e5064"],
Cell[CellGroupData[{
Cell[845, 31, 692, 13, 71, "Section",ExpressionUUID->"34911472-dad0-4328-977d-96524b7c61aa"],
Cell[1540, 46, 268, 5, 19, "Print",ExpressionUUID->"586233ef-ec25-4534-9bb1-68e91a7cc843"],
Cell[1811, 53, 15978, 349, 423, "Output",ExpressionUUID->"e85a0e0c-d521-462c-b82d-d957945825d1"],
Cell[17792, 404, 260, 5, 19, "Print",ExpressionUUID->"2b227ea7-958d-4fa1-8d4b-957087d13ecd"],
Cell[18055, 411, 19166, 405, 492, "Output",ExpressionUUID->"15bc8be5-1d5b-485e-8b4e-60656561911a"],
Cell[37224, 818, 122232, 2136, 215, "Output",ExpressionUUID->"9827b1c6-6b12-420d-947f-e003d5e8ec27"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159493, 2959, 689, 13, 83, "Section",ExpressionUUID->"278b78d4-c062-450a-9713-28b44995ac92"],
Cell[160185, 2974, 212, 4, 19, "Print",ExpressionUUID->"dcda6778-205d-42d1-9368-e812e51ed29d"],
Cell[160400, 2980, 17211, 383, 423, "Output",ExpressionUUID->"11c48034-d7cb-486d-a6fa-f9597d9ee2ab"],
Cell[177614, 3365, 204, 4, 19, "Print",ExpressionUUID->"c44b5dcf-83cd-41fe-a412-4efc4bb3e832"],
Cell[177821, 3371, 19207, 405, 492, "Output",ExpressionUUID->"899d00f1-a6a9-47e0-b9fd-c24df1b5402b"],
Cell[197031, 3778, 102920, 1812, 150, "Output",ExpressionUUID->"5e14acec-7fd4-4384-a54b-066a16cb328b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[299988, 5595, 511, 8, 59, "Section",ExpressionUUID->"c9388f8b-f9f7-43b7-9247-d7f9cb9e95c1"],
Cell[300502, 5605, 212, 4, 19, "Print",ExpressionUUID->"2fea6550-f0e1-4297-854a-477ff6c895c7"],
Cell[300717, 5611, 15903, 339, 406, "Output",ExpressionUUID->"5b05f0ae-6945-4cf3-acf4-b6822cc862fb"],
Cell[316623, 5952, 234, 5, 19, "Print",ExpressionUUID->"b734200a-0c67-4ace-9126-6968396c8bdf"],
Cell[316860, 5959, 24508, 515, 629, "Output",ExpressionUUID->"153cccae-663c-401e-9b3b-50d9d2e56c1e"],
Cell[341371, 6476, 223, 4, 19, "Print",ExpressionUUID->"8af83270-b94e-40bc-a77b-ca4c6da29da8"],
Cell[341597, 6482, 24456, 515, 629, "Output",ExpressionUUID->"f8bd30d0-8939-4d94-909b-8a42955acd8b"],
Cell[366056, 6999, 144700, 2535, 132, "Output",ExpressionUUID->"950556f6-c84b-41b6-9b44-62e58285218d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[510793, 9539, 509, 8, 59, "Section",ExpressionUUID->"97926c78-de20-4f82-ac02-36a2abd82efe"],
Cell[511305, 9549, 214, 4, 19, "Print",ExpressionUUID->"f054e3a0-b353-4248-ae41-cd802b9cc83e"],
Cell[511522, 9555, 15797, 340, 406, "Output",ExpressionUUID->"612e3b4d-6279-4b7b-aa03-b5b77d07d327"],
Cell[527322, 9897, 232, 5, 19, "Print",ExpressionUUID->"b76a10d8-b3de-47b2-aa49-d28f1dc1df72"],
Cell[527557, 9904, 19074, 403, 492, "Output",ExpressionUUID->"654953c5-f9d5-4788-8292-a727b75da5cd"],
Cell[546634, 10309, 225, 4, 19, "Print",ExpressionUUID->"f32d7521-6cb9-4a5c-9ecd-9e558a948bd4"],
Cell[546862, 10315, 24374, 513, 629, "Output",ExpressionUUID->"81277924-898a-4641-bb7e-d66ecb237412"],
Cell[571239, 10830, 127116, 2247, 147, "Output",ExpressionUUID->"e4de8041-d07a-4bd0-b59f-35597e3b9ba9"]
}, Open  ]]
}
]
*)

