This folder contains data and results related to the project: Optimising fleet sizing and management of shared automated vehicle (SAV) services: A mixed-integer programming approach integrating endogenous demand, congestion effects, and accept/reject mechanism impacts

## Folder Structure

- `data_delft/`: Contains data files related to the Delft network.
  - `Explaination.txt`: Provides an explanation of the data format and fields.
  - `network-delft_simplified.xlsx`: Simplified network data for Delft.
  - `Request_original.xlsx`: Original request data.
  - `Request_processed_700am-1000am.xlsx`: Processed request data for the time window 7:00 AM to 10:00 AM.
- `data_toynetwork/`: Contains data files related to the toy network.
#### Network Data Files:
  - `network-16nodes.xlsx`: Toy network data with 16 nodes.
  - `network-64nodes.xlsx`: Toy network data with 64 nodes.
  - `network-144nodes.xlsx`: Toy network data with 144 nodes.
  #### Trip Data Files:
  - `request_1000_16nodes.xlsx`: Toy network data with 1000 trips and 16 nodes.
  - `request_1000_64nodes.xlsx`: Toy network data with 1000 trips and 64 nodes.
  - `request_1000_144nodes.xlsx`: Toy network data with 1000 trips and 144 nodes.
  - `request_2000_16nodes.xlsx`: Toy network data with 2000 trips and 16 nodes.
  - `request_2000_64nodes.xlsx`: Toy network data with 2000 trips and 64 nodes.
  - `request_2000_144nodes.xlsx`: Toy network data with 2000 trips and 144 nodes.
  - `request_3000_16nodes.xlsx`: Toy network data with 3000 trips and 16 nodes.
  - `request_3000_64nodes.xlsx`: Toy network data with 3000 trips and 64 nodes.
  - `request_3000_144nodes.xlsx`: Toy network data with 3000 trips and 144 nodes.
  - `request_6000_144nodes.xlsx`: Toy network data with 6000 trips and 144 nodes.

- `Experiments_results.xlsx`: Contains the results of the experiments conducted in the project.

## Data Explanation

The `Explaination.txt` file in the `data_delft/` folder provides details about the data fields:
### Delft Network Data Fields

- `ID`: Unique identifier for each data entry.
- `Time`: Timestamp of the data entry.
- `Origin`: Starting point of the request.
- `Destination`: Ending point of the request.
- `Distance`: Distance between origin and destination.
- `Duration`: Estimated travel time between origin and destination.


### Experiment Results
The `Experiments_results.xlsx` file includes various sheets with detailed results from different experiments conducted, including performance metrics, fleet sizing outcomes, and equilibrium analysis between automated and non-automated traffic.