clear all
close all
clc

load('meas_sep_sources_z=diff_l=same.mat')

% % What is the Rayleigh limit
f_R = 1.22*343*2.32/(1*0.3); % f = 1.22*c*h/(D*R) --> take smallest distance and furthest z

% 3 sources
mon_x = [-0.3 0.0 0.5];
mon_y = [0.0 0.0 0.0]; 
% mon_z = [2.32 2.32 2.32]; % z = same
mon_z = [2.22 2.32 2.12]; % z = diff

N_src = input('Number of sources searched: ');

index_x = 1:4:N_src*4;
index_ampl = index_x+3;
index_y = index_x+1;
index_z = index_x+2;
index_s = index_x+3;

color_line = [[0, 0.4470, 0.7410];[0.8500, 0.3250, 0.0980];[0.9290, 0.6940, 0.1250]];

vlb = repmat([-2 -2 0 0],1,N_src);           % values lower bound [x y z amplitude]
vub = repmat([ 2  2 4.0 0.5],1,N_src);           % values upper bound [x y z amplitude]

dr = dir([cd filesep 'CAE S1S2S3 diff z - same l analysis\GO analysis\results_calibrated_CAE_S1S2S3_z=diff_l=same_incoh_q=64_F=06_pc=075_Nsrc=3_Nruns=5_Ngen=600_*Hz.mat']);
for k = 1:length(dr)
    I_in1 = findstr(dr(k).name,'600_'); % finds first one of this series, so add 4 indices
    I_in2 = findstr(dr(k).name,'Hz'); % finds first one of this series, so subtract 1 index       
    freq_tt(k) = str2num(dr(k).name(I_in1+4:I_in2-1));
end

figure(1)
set(gcf, 'Position',  [1,41,1680,933])

subplot(2,2,1) % freq,x
axis([min(freq_tt) max(freq_tt) -2 2])
hold on
plot([min(freq_tt) max(freq_tt)],[mon_x(1) mon_x(1)],'-k','LineWidth',2,'AlignVertexCenters','on')
text(max(xlim)+100,mon_x(1)-0.1,sprintf('1'),'FontSize',20)
if N_src > 1
    plot([min(freq_tt) max(freq_tt)],[mon_x(2) mon_x(2)],'-k','LineWidth',2,'AlignVertexCenters','on')
    text(max(xlim)+100,mon_x(2),sprintf('2'),'FontSize',20)
    plot([min(freq_tt) max(freq_tt)],[mon_x(3) mon_x(3)],'-k','LineWidth',2,'AlignVertexCenters','on')
    text(max(xlim)+100,mon_x(3),sprintf('3'),'FontSize',20)
    plot([f_R f_R],[-2 2],'Color',[0.5 0.5 0.5],'LineWidth',1.5,'AlignVertexCenters','on')
end

subplot(2,2,2) %figure(2) % freq,y
axis([min(freq_tt) max(freq_tt) -2 2])
hold on 
plot([min(freq_tt) max(freq_tt)],[mon_y(1) mon_y(1)],'-k','LineWidth',2,'AlignVertexCenters','on')
text(max(xlim)+100,mon_y(1),sprintf('1'),'FontSize',20)
if N_src > 1
    text(max(xlim)+100,mon_y(1),sprintf('1, 2, 3'),'FontSize',20)
    plot([min(freq_tt) max(freq_tt)],[mon_y(2) mon_y(2)],'-k','LineWidth',2,'AlignVertexCenters','on')
    plot([min(freq_tt) max(freq_tt)],[mon_y(3) mon_y(3)],'-k','LineWidth',2,'AlignVertexCenters','on')
    plot([f_R f_R],[-2 2],'Color',[0.5 0.5 0.5],'LineWidth',1.5,'AlignVertexCenters','on')
end

subplot(2,2,3) %figure(3) % freq,z
axis([min(freq_tt) max(freq_tt) 0 4])
hold on
plot([min(freq_tt) max(freq_tt)],[mon_z(1) mon_z(1)],'-k','LineWidth',2,'AlignVertexCenters','on')
text(max(xlim)+400,mon_z(1),sprintf('1'),'FontSize',20)
plot(f_GOz,S1_zdiff_lsame_GOz,'Color',[0.5 0.5 0.5],'LineWidth',1)
if N_src > 1
    plot([min(freq_tt) max(freq_tt)],[mon_z(2) mon_z(2)],'-k','LineWidth',2,'AlignVertexCenters','on')
    text(max(xlim)+100,mon_z(2)+0.2,sprintf('2'),'FontSize',20)
    plot(f_GOz,S2_zdiff_lsame_GOz,'Color',[0.5 0.5 0.5],'LineWidth',1)
    plot([min(freq_tt) max(freq_tt)],[mon_z(3) mon_z(3)],'-k','LineWidth',2,'AlignVertexCenters','on')
    text(max(xlim)+100,mon_z(3)-0.1,sprintf('3'),'FontSize',20)
    plot(f_GOz,S3_zdiff_lsame_GOz,'Color',[0.5 0.5 0.5],'LineWidth',1)
end


subplot(2,2,4) %figure(4) % freq,SPL
hold on
axis([min(freq_tt) max(freq_tt) 0 60])
[~,index_sep] = find(round(S1_SPL_f,0) == max(freq_tt));
[~,index_all] = find(round(Stotal_SPL_f,0) == max(freq_tt));
plot(S1_SPL_f,S1_SPL,'-k','LineWidth',1,'AlignVertexCenters','on')
text(max(freq_tt)+100,S1_SPL(index_sep)-2,sprintf('1'),'FontSize',20)
if N_src > 1 
    plot(S2_SPL_f,S2_SPL,'-k','LineWidth',1,'AlignVertexCenters','on')
    text(max(freq_tt)+100,S2_SPL(index_sep),sprintf('2'),'FontSize',20)
    plot(S3_SPL_f,S3_SPL,'-k','LineWidth',1,'AlignVertexCenters','on')
    text(max(freq_tt)+400,S3_SPL(index_sep),sprintf('3'),'FontSize',20)
    plot(Stotal_SPL_f,Stotal_SPL,'-k','LineWidth',2,'AlignVertexCenters','on')
    text(max(freq_tt)+100,Stotal_SPL(index_all)+3,sprintf('All'),'FontSize',20)
end
        
for k = 1:length(dr)
    % eval(['load results_',num2str(freq_tt(k)),'Hz.mat'])
    eval(['load ',dr(k).name])   
    freq_tt(k) = f;
    [~,I1] = sort(G); %order of strongest run (lowest energy = strongest run = first in I1)
    
    
    figure(1)
    hold on
    subplot(2,2,1)
    % sort the estimes corresponding to the lowest energy (I1(1)) based on
    % amplitude (last one in I2 is strongest source, so count back from
    % end)    
    [~,I2] = sort(F1(index_ampl,I1(1)));
    for i = 1:N_src
        scatter(freq_tt(k),F1(index_x(I2(end-(i-1))),I1(1)),10,'filled','MarkerEdgeColor',color_line(i,:),'MarkerFaceColor',color_line(i,:)); % highest amplitude, best individual
        hold on
    end
    h = get(gcf,'Children');
    set(h,'FontSize',20)
    xlabel('Frequency (Hz)')
    ylabel('x (m)')
    axis([min(freq_tt) max(freq_tt) min(vlb(index_x)) max(vub(index_x))])
    
%     figure(2) % gives the y-location of the 3 strongest sources 'filled'
    subplot(2,2,2)
    for i = 1:N_src
        scatter(freq_tt(k),F1(index_y(I2(end-(i-1))),I1(1)),10,'filled','MarkerEdgeColor',color_line(i,:),'MarkerFaceColor',color_line(i,:))
        hold on
    end 
    h = get(gcf,'Children');
    set(h,'FontSize',20)
    xlabel('Frequency (Hz)')
    ylabel('y (m)')
    axis([min(freq_tt) max(freq_tt) min(vlb(index_y)) max(vub(index_y))])
    
%     figure(3)
    subplot(2,2,3)
    for i = 1:N_src
        scatter(freq_tt(k),F1(index_z(I2(end-(i-1))),I1(1)),10,'filled','MarkerEdgeColor',color_line(i,:),'MarkerFaceColor',color_line(i,:))
        hold on
    end
    h = get(gcf,'Children');
    set(h,'FontSize',20)
    xlabel('Frequency (Hz)')
    ylabel('z (m)')
    axis([min(freq_tt) max(freq_tt) min(vlb(index_z)) max(vub(index_z))])
    
%     figure(4)
    subplot(2,2,4)
    % SPL = 10*log10(0.5*S_1(1,I5)./((2E-5)^2))
    for i = 1:N_src
        scatter(freq_tt(k),10*log10(0.5*F1(index_s(I2(end-(i-1))),I1(1))/(2E-5)^2),10,'filled','MarkerEdgeColor',color_line(i,:),'MarkerFaceColor',color_line(i,:))
        hold on
    end
    h = get(gcf,'Children');
    set(h,'FontSize',20)
    xlabel('Frequency (Hz)')
    ylabel('SPL (dB)')
    axis([min(freq_tt) max(freq_tt) 0 60])

    % convergence behaviour
%     figure(5)
%     plot(G2')
%     hold on
%     h = get(gcf,'Children');
%     set(h,'FontSize',14)
%     xlabel('Generation')
%     ylabel('Enegry function value')
    % parameters used for determining the percentage converged (I1 indicates energy function, increasing (getting worse) during loop)
    % the distance between the estimated source position and the true
    % source position is estimated for the three sources: R_1, R_2 and R_3
    for k2 = 1:5
        sol_k2 = F1(:,I1(k2)); % solutions for the k2th run
        [~,I3] = sort(sol_k2(index_ampl)); % sort those solution on strength (last one is strongest source)
        if N_src>=1
        % strongest source - if N_src = 1, then the values for k2 = 1 are the same as the other plots    
            X_1(k2,k) = sol_k2(index_x(I3(end))); 
            Y_1(k2,k) = sol_k2(index_y(I3(end)));
            Z_1(k2,k) = sol_k2(index_z(I3(end)));
            S_1(k2,k) = sol_k2(index_ampl(I3(end)));
        end
        if N_src>=2 
            % 1 but strongest source - for k2 = 1 it gives the values of the large plot made before
            X_2(k2,k) = sol_k2(index_x(I3(end-1)));
            Y_2(k2,k) = sol_k2(index_y(I3(end-1)));
            Z_2(k2,k) = sol_k2(index_z(I3(end-1)));
            S_2(k2,k) = sol_k2(index_ampl(I3(end-1)));
        end
        if N_src>=3
            % 2 but strongest source
            X_3(k2,k) = sol_k2(index_x(I3(end-2)));
            Y_3(k2,k) = sol_k2(index_y(I3(end-2)));
            Z_3(k2,k) = sol_k2(index_z(I3(end-2)));
            S_3(k2,k) = sol_k2(index_ampl(I3(end-2)));
            R_1(k2,k) = min([sqrt( ([X_1(k2,k) X_2(k2,k) X_3(k2,k)]-mon_x(1)).^2 + ([Y_1(k2,k) Y_2(k2,k) Y_3(k2,k)]-mon_y(1)).^2 + ([Z_1(k2,k) Z_2(k2,k) Z_3(k2,k)]-mon_z(1)).^2 ) ]); % the min is needed to check which source estimate _1 _2 _3 belongs to source 1
            R_2(k2,k) = min([sqrt( ([X_1(k2,k) X_2(k2,k) X_3(k2,k)]-mon_x(2)).^2 + ([Y_1(k2,k) Y_2(k2,k) Y_3(k2,k)]-mon_y(2)).^2 + ([Z_1(k2,k) Z_2(k2,k) Z_3(k2,k)]-mon_z(2)).^2 ) ]); % the min is needed to check which source estimate _1 _2 _3 belongs to source 2
            R_3(k2,k) = min([sqrt( ([X_1(k2,k) X_2(k2,k) X_3(k2,k)]-mon_x(3)).^2 + ([Y_1(k2,k) Y_2(k2,k) Y_3(k2,k)]-mon_y(3)).^2 + ([Z_1(k2,k) Z_2(k2,k) Z_3(k2,k)]-mon_z(3)).^2 ) ]); % the min is needed to check which source estimate _1 _2 _3 belongs to source 3
        end
    end 
end

if N_src > 1
    SPL_GO = 10*log10(0.5*(S_1(1,:)+S_2(1,:)+S_3(1,:)))-20*log10(2e-5);
    figure(1)
    subplot(2,2,4)
    hold on
    scatter(freq_tt,SPL_GO,10,'filled','MarkerEdgeColor','k','MarkerFaceColor','k')
end

