import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm
import cblind as cb
from functions import fixPlot
#
# USER INPUT PARAMETERS
# 
save_Fig = True                         # Save the Figure prompt
show_Fig = True                         # Show the Figure prompt
figname_c = 'figures/figure1_c.pdf'     # Name of panel (c)
# Flow properties
nphases = 10                            # Number of wave phases
Ub = 0.072360125                        # Wave orbital velocity in m/s
Tw = 6.0                                # Wave Period in s
# 
# LOAD DATA
#
z = np.loadtxt('data/zgrid.dat')
# Load URMS
serCy_u = np.loadtxt('data/serialCylinder_urms.dat')
staCy_u = np.loadtxt('data/staggeredCylinder_urms.dat')
serMa_u = np.loadtxt('data/serialMassive_urms.dat')
staMa_u = np.loadtxt('data/staggeredMassive_urms.dat')
serBr_u = np.loadtxt('data/serialBranching_urms.dat')
staBr_u = np.loadtxt('data/staggeredBranching_urms.dat')
morph1_u = np.loadtxt('data/morph1_urms.dat')
morph2_u = np.loadtxt('data/morph2_urms.dat')
# Load VRMS
serCy_v = np.loadtxt('data/serialCylinder_vrms.dat')
staCy_v = np.loadtxt('data/staggeredCylinder_vrms.dat')
serMa_v = np.loadtxt('data/serialMassive_vrms.dat')
staMa_v = np.loadtxt('data/staggeredMassive_vrms.dat')
serBr_v = np.loadtxt('data/serialBranching_vrms.dat')
staBr_v = np.loadtxt('data/staggeredBranching_vrms.dat')
morph1_v = np.loadtxt('data/morph1_vrms.dat')
morph2_v = np.loadtxt('data/morph2_vrms.dat')
# Load WRMS
serCy_w = np.loadtxt('data/serialCylinder_wrms.dat')
staCy_w = np.loadtxt('data/staggeredCylinder_wrms.dat')
serMa_w = np.loadtxt('data/serialMassive_wrms.dat')
staMa_w = np.loadtxt('data/staggeredMassive_wrms.dat')
serBr_w = np.loadtxt('data/serialBranching_wrms.dat')
staBr_w = np.loadtxt('data/staggeredBranching_wrms.dat')
morph1_w = np.loadtxt('data/morph1_wrms.dat')
morph2_w = np.loadtxt('data/morph2_wrms.dat')
#
# PLOT
#
color, linestyle = cb.Colorplots().cblind(10)
# Define the subplot type and size
fixPlot(thickness=1.5, fontsize=15, markersize=4, labelsize=15, texuse=True, tickSize = 15)
fig, axs = plt.subplots(4, 3,figsize=(8,8))
# Define some global characteristics
plt.setp(plt.gcf().axes,xlim=[0,0.2],xticks=[0,0.05,0.1,0.15,0.2])
plt.setp(plt.gcf().axes,ylim=[0,1.0],yticks=[0.25,0.5,0.75,1.0])
# Plot the figure below
plt.subplot(4,3,1)
plt.plot(np.nanmean(serCy_u,axis=1)/Ub,z/z[-1],'-x',color=color[5],markevery=10,label='C-Ser')
plt.plot(np.nanmean(staCy_u,axis=1)/Ub,z/z[-1],'-o',color=color[0],markevery=20,label='C-Stag')
plt.xticks([0,0.05,0.1,0.15,0.2],labels=[])
plt.legend(frameon=False,fontsize=10)
plt.ylabel(r'$x_3/H$',fontsize=20)
plt.subplot(4,3,2)
plt.plot(np.nanmean(serCy_v,axis=1)/Ub,z/z[-1],'-x',color=color[5],markevery=10)
plt.plot(np.nanmean(staCy_v,axis=1)/Ub,z/z[-1],'-o',color=color[0],markevery=20)
plt.xticks([0,0.05,0.1,0.15,0.2],labels=[]); plt.yticks([0.25,0.5,0.75,1.0],labels=[])
plt.subplot(4,3,3)
plt.plot(np.nanmean(serCy_w,axis=1)/Ub,z/z[-1],'-x',color=color[5],markevery=10)
plt.plot(np.nanmean(staCy_w,axis=1)/Ub,z/z[-1],'-o',color=color[0],markevery=20)
plt.xticks([0,0.05,0.1,0.15,0.2],labels=[]); plt.yticks([0.25,0.5,0.75,1.0],labels=[])
# Massive
plt.subplot(4,3,4)
plt.plot(np.nanmean(serMa_u,axis=1)/Ub,z/z[-1],'-x',color=color[5],markevery=10,label='M-Ser')
plt.plot(np.nanmean(staMa_u,axis=1)/Ub,z/z[-1],'-o',color=color[0],markevery=20,label='M-Stag')
plt.xticks([0,0.05,0.1,0.15,0.2],labels=[])
plt.ylabel(r'$x_3/H$',fontsize=20)
plt.legend(frameon=False,fontsize=10)
plt.subplot(4,3,5)
plt.plot(np.nanmean(serMa_v,axis=1)/Ub,z/z[-1],'-x',color=color[5],markevery=10)
plt.plot(np.nanmean(staMa_v,axis=1)/Ub,z/z[-1],'-o',color=color[0],markevery=20)
plt.xticks([0,0.05,0.1,0.15,0.2],labels=[]); plt.yticks([0.25,0.5,0.75,1.0],labels=[])
plt.subplot(4,3,6)
plt.plot(np.nanmean(serMa_w,axis=1)/Ub,z/z[-1],'-x',color=color[5],markevery=10)
plt.plot(np.nanmean(staMa_w,axis=1)/Ub,z/z[-1],'-o',color=color[0],markevery=20)
plt.xticks([0,0.05,0.1,0.15,0.2],labels=[]); plt.yticks([0.25,0.5,0.75,1.0],labels=[])
# Branching
plt.subplot(4,3,7)
plt.plot(np.nanmean(serBr_u,axis=1)/Ub,z/z[-1],'-x',color=color[5],markevery=10,label='B-Ser')
plt.plot(np.nanmean(staBr_u,axis=1)/Ub,z/z[-1],'-o',color=color[0],markevery=20,label='B-Stag')
plt.xticks([0,0.05,0.1,0.15,0.2],labels=[])
plt.ylabel(r'$x_3/H$',fontsize=20)
plt.legend(frameon=False,fontsize=10)
plt.subplot(4,3,8)
plt.plot(np.nanmean(serBr_v,axis=1)/Ub,z/z[-1],'-x',color=color[5],markevery=10)
plt.plot(np.nanmean(staBr_v,axis=1)/Ub,z/z[-1],'-o',color=color[0],markevery=20)
plt.xticks([0,0.05,0.1,0.15,0.2],labels=[]); plt.yticks([0.25,0.5,0.75,1.0],labels=[])
plt.subplot(4,3,9)
plt.plot(np.nanmean(serBr_w,axis=1)/Ub,z/z[-1],'-x',color=color[5],markevery=10)
plt.plot(np.nanmean(staBr_w,axis=1)/Ub,z/z[-1],'-o',color=color[0],markevery=20)
plt.xticks([0,0.05,0.1,0.15,0.2],labels=[]); plt.yticks([0.25,0.5,0.75,1.0],labels=[])
# Morphology
plt.subplot(4,3,10)
plt.plot(np.nanmean(morph1_u,axis=1)/Ub,z/z[-1],'-x',color=color[5],markevery=10,label='Morph-1')
plt.plot(np.nanmean(morph2_u,axis=1)/Ub,z/z[-1],'-o',color=color[0],markevery=20,label='Morph-2')
plt.xlabel(r'$\langle \overline{u_1^{rms}} \rangle U_b^{-1}$',fontsize=20)
plt.ylabel(r'$x_3/H$',fontsize=20)
plt.legend(frameon=False,fontsize=10)
plt.subplot(4,3,11)
plt.plot(np.nanmean(morph1_v,axis=1)/Ub,z/z[-1],'-x',color=color[5],markevery=10)
plt.plot(np.nanmean(morph2_v,axis=1)/Ub,z/z[-1],'-o',color=color[0],markevery=20)
plt.yticks([0.25,0.5,0.75,1.0],labels=[])
plt.xlabel(r'$\langle \overline{u_2^{rms}} \rangle U_b^{-1}$',fontsize=20)
plt.subplot(4,3,12)
plt.plot(np.nanmean(morph1_w,axis=1)/Ub,z/z[-1],'-x',color=color[5],markevery=10)
plt.plot(np.nanmean(morph2_w,axis=1)/Ub,z/z[-1],'-o',color=color[0],markevery=20)
plt.yticks([0.25,0.5,0.75,1.0],labels=[])
plt.xlabel(r'$\langle \overline{u_3^{rms}} \rangle U_b^{-1}$',fontsize=20)
# Add horizontal line to all subplot
for ii in range(1,13):
    plt.subplot(4,3,ii)
    plt.axhline(0.035/z[-1],linestyle=':',linewidth=2.0,color='r')
    plt.grid()
# Set tight layout
plt.tight_layout()
## SAVE FIG
if(save_Fig):
    plt.savefig(figname_c,dpi=800)
if(show_Fig):
    plt.show()
