clc
clear all
close all

%% Script starts
color_order = [0,0.447000000000000,0.741000000000000;
0.850000000000000,0.325000000000000,0.0980000000000000;
0.929000000000000,0.694000000000000,0.125000000000000;
0.494000000000000,0.184000000000000,0.556000000000000;
0.466000000000000,0.674000000000000,0.188000000000000;
0.301000000000000,0.745000000000000,0.933000000000000;
0.635000000000000,0.0780000000000000,0.184000000000000];

% Scripts settings
font_size = 9;

pf = 9.6808; % gram (stationary)
m_s = 6.418; % gram (moving)

mu = pf/m_s;


% Smoothdata function parameters
method = 'gaussian';
window = 10; %10; 20

% Smoothdata parameters correction factors
window_correction = 30;
method_correction = method;

f_min = 18; % Hz 18
f_max = 21; % Hz 25 23

% legend formatting settings
x1 = 7;%30;
x2 = 5;

%% get correction factors
[mag_phase_complex_force, mag_phase_accel_x, mag_phase_accel_y, mag_phase_accel_z, mag_phase_mov_accel,mag_phase_complex_stab_mov_x, mag_phase_complex_stab_mov_y, mag_phase_complex_stab_mov_z] = Calculate_Correction_Factors(method_correction, window_correction);

filename_AoA_0_22 = "Middle_LE_Shroud_FRF_data/Lower_Gain_half/AoA_0_22ms_z_FRF_z";
filename_AoA_0_23 = "Middle_LE_Shroud_FRF_data/Lower_Gain_half/AoA_0_23ms_z_FRF_z";
filename_AoA_0_24 = "Middle_LE_Shroud_FRF_data/Lower_Gain_half/AoA_0_24ms_z_FRF_z";


AoA_0_22 = load(filename_AoA_0_22);
AoA_0_23 = load(filename_AoA_0_23);
AoA_0_24 = load(filename_AoA_0_24);

FRF_AoA_0_22 = AoA_0_22.FRF.y_values.values;
FRF_AoA_0_23 = AoA_0_23.FRF.y_values.values;
FRF_AoA_0_24 = AoA_0_24.FRF.y_values.values;

complex_lst = [FRF_AoA_0_22, FRF_AoA_0_23, FRF_AoA_0_24];

start = AoA_0_22.FRF.x_values.start_value;
step = AoA_0_22.FRF.x_values.increment;
number = AoA_0_22.FRF.x_values.number_of_values;

freq = linspace(start, step*(number-1), number);
freq = reshape(freq, number, 1);

%     Y1 = mu*data.Real;
%     Y2 = mu*data.Im;

%     sig_complex = Y1 + 1i*Y2;
% sig_complex_data = data.FRF.y_values.values;
% sig_complex = sig_complex_data;

% freq_lst = [freq_lst, freq];
% sig_complex_lst = [sig_complex_lst, sig_complex];

% Data needed for linear interpolation SISO PFM
% G_omega_plus_all = struct();
% G_omega_min_all = struct();
% phase_plus_all = struct();
% phase_min_all = struct();
% omega_plus_all = struct();
% omega_min_all = struct();



smooth_complex_all = [];
mag_phase_complex_all_V = [];
for idx=1:min(size(complex_lst))
    complex = complex_lst(:, idx);
    % Specify bounds of interest (min and max frequency)
%     [~, idx_min] = min(abs(freq - f_min));
%     [~, idx_max] = min(abs(freq - f_max));
% 
%     freq = freq(idx_min:idx_max);
    %% Apply correction factors to raw FRF data
    % raw FRF scaled with all correction factors
    complex_new = mu*complex; 
    mag_phase_complex_all = [];
    for m=1:length(complex_new)
        % multiply complex number of PFM FRF with 1/shaker force FRF
        complex_new_m = complex_new(m);
        complex_new_m = complex_new_m*1/(mag_phase_complex_force(m));

        mag_phase_complex_all = [mag_phase_complex_all; complex_new_m];% [smooth_mag_db, smooth_phase];
    end
    mag_phase_complex_all_V = [mag_phase_complex_all_V, mag_phase_complex_all];

    %% use smoothdata to get smoothed complex number
    raw_signal = mag_phase_complex_all;
    method = 'gaussian';
    window = [];
    
    if idx == 1
        smoothing_factor = 0.105;
    elseif idx == 2
        smoothing_factor = 0.12;
    elseif idx == 3
        smoothing_factor = 0.16;
    end
    
    smooth_complex = smoothdata(raw_signal, method, window, 'SmoothingFactor', smoothing_factor);
    
% %% Create smoothed data from complex using S(x) = (Y(x-1) + 2*Y(x) + Y(x+1))/4 --> Smooth_FRF function in TestLab
%     smooth_complex = [];
%     
%     mag_test = abs(mag_phase_complex_all);
%     phase_test = angle(mag_phase_complex_all);
%     for m=1:length(mag_phase_complex_all) 
% %        
%             % Smooth complex number (when using z-excitation)
%             if m > 3 && m < length(mag_phase_complex_all)-2 
%                 Y_x_min_3 = mag_phase_complex_all(m-3);
%                 Y_x_min_2 = mag_phase_complex_all(m-2);
%                 Y_x_min_1 = mag_phase_complex_all(m-1);
%                 Y_x = mag_phase_complex_all(m);
%                 Y_x_plus_1 = mag_phase_complex_all(m+1);
%                 Y_x_plus_2 = mag_phase_complex_all(m+2);
%                 Y_x_plus_3 = mag_phase_complex_all(m+3);
% 
%                 S_x = (Y_x_min_3 + 1.5*Y_x_min_2 + 2*Y_x_min_1 + 4*Y_x + 2*Y_x_plus_1 + 1.5*Y_x_plus_2 + Y_x_plus_3)/13;
%     %             S_x = (Y_x_min_2 + Y_x_min_1 + 2*Y_x + Y_x_plus_1 + Y_x_plus_2)/6;
%     %             disp("Taking Moving Average")
%             else
%                 S_x = mag_phase_complex_all(m);
%     %             disp("Not taking Moving Average")
%             end
%     %         
%     %         
%         
%         
%         smooth_complex = [smooth_complex; S_x];
%     end
    smooth_complex_all = [smooth_complex_all, smooth_complex];
end


%% Plot FRFs
% Compare raw to smooth FRF

% 22 m/s
fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
t = tiledlayout(2, 1);

nexttile(t)
plot(freq, abs(mag_phase_complex_all_V(:, 1)), 'Displayname', 'Raw', 'color', color_order(1,:))
hold on
plot(freq, abs(smooth_complex_all(:, 1)), 'Displayname', "Smooth", 'color', color_order(2,:))
yline(1,'HandleVisibility','off')

xlim([f_min, f_max])
% xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size)
set(gca,'XTickLabel',[]);
ylabel('Magnitude','Interpreter','latex','FontSize', font_size) 

leg = legend('Interpreter','latex', 'Location', 'northwest','FontSize', font_size) ;
leg.ItemTokenSize = [x1,x2];
%grid()
set(gca,'FontSize', font_size)

nexttile(t)
plot(freq, angle(mag_phase_complex_all_V(:, 1)), 'Displayname', 'Raw', 'color', color_order(1,:))
hold on
plot(freq, angle(smooth_complex_all(:, 1)), 'Displayname', "Smooth", 'color', color_order(2,:))
yline(0,'HandleVisibility','off')
yline(pi,'HandleVisibility','off')
yline(-pi,'HandleVisibility','off')

xlim([f_min, f_max])
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
ylabel('$\phi$ [rad]','Interpreter','latex','FontSize', font_size) 
% leg = legend('Interpreter','latex', 'Location', 'southwest','FontSize', font_size) ;
% leg.ItemTokenSize = [x1,x2];
%grid()

t.TileSpacing = 'none';
t.Padding = 'none';

set(gca,'FontSize', font_size)
%sgtitle("AoA = 0, 22 m/s", 'Interpreter','latex')

set(gcf,'Units','Inches');
pos = get(gcf,'Position');
set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);
    
export_path = "Figures/Lower_shaker_gain/AoA_0_22ms_lower_shaker_gain";
exportgraphics(gcf, export_path + ".pdf")
saveas(gcf, export_path + ".jpg")


% 23 m/s
fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
t = tiledlayout(2, 1);

nexttile(t)
plot(freq, abs(mag_phase_complex_all_V(:, 2)), 'Displayname', 'Raw', 'color', color_order(1,:))
hold on
plot(freq, abs(smooth_complex_all(:, 2)), 'Displayname', "Smooth", 'color', color_order(2,:))
yline(1,'HandleVisibility','off')

xlim([f_min, f_max])
% xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
set(gca,'XTickLabel',[]);
ylabel('Magnitude','Interpreter','latex','FontSize', font_size) 

leg = legend('Interpreter','latex', 'Location', 'northwest','FontSize', font_size) ;
leg.ItemTokenSize = [x1,x2];

%grid()
set(gca,'FontSize', font_size)

nexttile(t)
plot(freq, angle(mag_phase_complex_all_V(:, 2)), 'Displayname', 'Raw', 'color', color_order(1,:))
hold on
plot(freq, angle(smooth_complex_all(:, 2)), 'Displayname', "Smooth", 'color', color_order(2,:))
yline(0,'HandleVisibility','off')
yline(pi,'HandleVisibility','off')
yline(-pi,'HandleVisibility','off')

xlim([f_min, f_max])
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
ylabel('$\phi$ [rad]','Interpreter','latex','FontSize', font_size) 
% leg = legend('Interpreter','latex', 'Location', 'southwest','FontSize', font_size) ;
% 
% leg.ItemTokenSize = [x1,x2];

t.TileSpacing = 'none';
t.Padding = 'none';


%grid()
set(gca,'FontSize', font_size)

%sgtitle("AoA = 0, 23 m/s", 'Interpreter','latex')

set(gcf,'Units','Inches');
pos = get(gcf,'Position');
set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

export_path = "Figures/Lower_shaker_gain/AoA_0_23ms_lower_shaker_gain";
exportgraphics(gcf, export_path + ".pdf")
saveas(gcf, export_path + ".jpg")


% 24 m/s
fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];

t = tiledlayout(2, 1);

nexttile(t)
plot(freq, abs(mag_phase_complex_all_V(:, 3)), 'Displayname', 'Raw', 'color', color_order(1,:))
hold on
plot(freq, abs(smooth_complex_all(:, 3)), 'Displayname', "Smooth", 'color', color_order(2,:))
yline(1,'HandleVisibility','off')

set(gca,'FontSize', font_size)

xlim([f_min, f_max])
% xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
set(gca,'XTickLabel',[]);
ylabel('Magnitude','Interpreter','latex','FontSize', font_size) 

leg = legend('Interpreter','latex', 'Location', 'northwest','FontSize', font_size) ;
leg.ItemTokenSize = [x1,x2];

%grid()

nexttile(t)
plot(freq, angle(mag_phase_complex_all_V(:, 3)), 'Displayname', 'Raw', 'color', color_order(1,:))
hold on
plot(freq, angle(smooth_complex_all(:, 3)), 'Displayname', "Smooth", 'color', color_order(2,:))
yline(0,'HandleVisibility','off')
yline(pi,'HandleVisibility','off')
yline(-pi,'HandleVisibility','off')

xlim([f_min, f_max])
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
ylabel('$\phi$ [rad]','Interpreter','latex','FontSize', font_size)  
% leg = legend('Interpreter','latex', 'Location', 'southwest','FontSize', font_size) ;
% leg.ItemTokenSize = [x1,x2];

%grid()

set(gca,'FontSize', font_size)

%sgtitle("AoA = 0, 24 m/s", 'Interpreter','latex')

t.TileSpacing = 'none';
t.Padding = 'none';


set(gcf,'Units','Inches');
pos = get(gcf,'Position');
set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);



export_path = "Figures/Lower_shaker_gain/AoA_0_24ms_lower_shaker_gain";
exportgraphics(gcf, export_path + ".pdf")
saveas(gcf, export_path + ".jpg")


% Smooth FRFs
fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];

t = tiledlayout(2, 1);
nexttile(t)
plot(freq, abs(smooth_complex_all(:, 1)), 'Displayname', "22 m/s")
hold on
plot(freq, abs(smooth_complex_all(:, 2)), 'Displayname', "23 m/s")
plot(freq, abs(smooth_complex_all(:, 3)), 'Displayname', "24 m/s")
yline(1,'HandleVisibility','off')

xlim([f_min, f_max])
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
ylabel('Magnitude','Interpreter','latex','FontSize', font_size) 

leg = legend('Interpreter','latex', 'Location', 'northwest','FontSize', font_size);
leg.ItemTokenSize = [x1,x2];

%grid()

set(gca,'FontSize', font_size)

nexttile(t)

plot(freq, angle(smooth_complex_all(:, 1)), 'Displayname', "22 m/s")
hold on
plot(freq, angle(smooth_complex_all(:, 2)), 'Displayname', "23 m/s")
plot(freq, angle(smooth_complex_all(:, 3)), 'Displayname', "24 m/s")
yline(0,'HandleVisibility','off')
yline(pi,'HandleVisibility','off')
yline(-pi,'HandleVisibility','off')


xlim([f_min, f_max])
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
ylabel('$\phi$ [rad]','Interpreter','latex','FontSize', font_size) 
% leg = legend('Interpreter','latex', 'Location', 'southwest','FontSize', font_size);
% leg.ItemTokenSize = [x1,x2];
%grid()

set(gca,'FontSize', font_size)

t.TileSpacing = 'none';
t.Padding = 'none';


%sgtitle("AoA = 0, Smooth FRF Comparison Lower Shaker Gain", 'Interpreter','latex')

set(gcf,'Units','Inches');
pos = get(gcf,'Position');
set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

export_path = "Figures/Lower_shaker_gain/Smooth_FRF_lower_shaker_gain";
exportgraphics(gcf, export_path + ".pdf")
saveas(gcf, export_path + ".jpg")


%% Comparison Plot Smooth FRFs lower shaker gain with Smooth FRFs Gain 2
Column_name = ["Freq","20_x/x", "20_y/x", "20_z/x", "20_x/z", "20_y/z", "20_z/z", "21_x/x", "21_y/x", "21_z/x", "21_x/z", "21_y/z", "21_z/z", "22_x/x", "22_y/x", "22_z/x", "22_x/z", "22_y/z", "22_z/z", "22_5_x/x", "22_5_y/x", "22_5_z/x", "22_5_x/z", "22_5_y/z", "22_5_z/z","23_x/x", "23_y/x", "23_z/x", "23_x/z", "23_y/z", "23_z/z", "23_5_x/x", "23_5_y/x", "23_5_z/x", "23_5_x/z", "23_5_y/z", "23_5_z/z", "24_x/x", "24_y/x", "24_z/x", "24_x/z", "24_y/z", "24_z/z", "24_5_x/x", "24_5_y/x", "24_5_z/x", "24_5_x/z", "24_5_y/z", "24_5_z/z", "25_x/x", "25_y/x", "25_z/x", "25_x/z", "25_y/z", "25_z/z"];
Velocity_lst = [20, 21, 22, 22.5, 23, 23.5, 24, 24.5, 25];

smooth_FRF_filename = "Middle_LE_Smooth_FRF/Smooth_FRF_AoA_0.mat";

AoA_0_mag_phase = load(smooth_FRF_filename).AoA_0_mag_phase;



smooth_FRF_22ms = AoA_0_mag_phase(:, 7+ 6*(3-1));
smooth_FRF_23ms = AoA_0_mag_phase(:, 7+ 6*(5-1));
smooth_FRF_24ms = AoA_0_mag_phase(:, 7+ 6*(7-1));

% start = AoA_0_22.FRF.x_values.start_value;
% step = AoA_0_22.FRF.x_values.increment;
% number = AoA_0_22.FRF.x_values.number_of_values;
% 
% freq = linspace(start, step*(number-1), number);
% 
% 
% [~, idx_min] = min(abs(freq - f_min));
% [~, idx_max] = min(abs(freq - f_max));

freq_high_gain = AoA_0_mag_phase(:, 1);

% 22 m/s
fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];

t=tiledlayout(2, 1);

nexttile(t)
plot(freq_high_gain, abs(smooth_FRF_22ms), 'Displayname', "Gain 1", 'color', color_order(1,:))
hold on
plot(freq, abs(smooth_complex_all(:, 1)), 'Displayname', "Gain 2", 'color', color_order(2,:))


yline(1,'HandleVisibility','off')

xlim([f_min, f_max])
% xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
set(gca,'XTickLabel',[]);
ylabel('Magnitude','Interpreter','latex','FontSize', font_size) 

leg = legend('Interpreter','latex', 'Location', 'northwest','FontSize', font_size) ;
leg.ItemTokenSize = [x1,x2];
%grid()

nexttile(t)

plot(freq_high_gain, angle(smooth_FRF_22ms), 'Displayname', "Gain 1", 'color', color_order(1,:))
hold on
plot(freq, angle(smooth_complex_all(:, 1)), 'Displayname', "Gain 2", 'color', color_order(2,:))


yline(0,'HandleVisibility','off')
yline(pi,'HandleVisibility','off')
yline(-pi,'HandleVisibility','off')


xlim([f_min, f_max])
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
ylabel('$\phi$ [rad]','Interpreter','latex','FontSize', font_size) 
% leg = legend('Interpreter','latex', 'Location', 'southwest','FontSize', font_size) ;
% leg.ItemTokenSize = [x1,x2];

%grid()

%sgtitle("AoA = 0, 22 m/s,  Smooth FRF Comparison Lower Shaker Gain", 'Interpreter','latex')

t.TileSpacing = 'none';
t.Padding = 'none';


set(gcf,'Units','Inches');
pos = get(gcf,'Position');
set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

export_path = "Figures/Lower_shaker_gain/Smooth_FRF_shaker_gain_comparison_22ms_";
exportgraphics(gcf, export_path + ".pdf")
saveas(gcf, export_path + ".jpg")


% 23 m/s
fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];

t = tiledlayout(2, 1);

nexttile(t)
plot(freq_high_gain, abs(smooth_FRF_23ms), 'Displayname', "Gain 1", 'color', color_order(1,:))
hold on
plot(freq, abs(smooth_complex_all(:, 2)), 'Displayname', "Gain 2", 'color', color_order(2,:))


yline(1,'HandleVisibility','off')

xlim([f_min, f_max])
% xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
set(gca,'XTickLabel',[]);
ylabel('Magnitude','Interpreter','latex','FontSize', font_size) 

leg = legend('Interpreter','latex', 'Location', 'northwest','FontSize', font_size) ;
leg.ItemTokenSize = [x1,x2];
%grid()

nexttile(t)

plot(freq_high_gain, angle(smooth_FRF_23ms), 'Displayname', "Gain 1", 'color', color_order(1,:))
hold on
plot(freq, angle(smooth_complex_all(:, 2)), 'Displayname', "Gain 2", 'color', color_order(2,:))


yline(0,'HandleVisibility','off')
yline(pi,'HandleVisibility','off')
yline(-pi,'HandleVisibility','off')


xlim([f_min, f_max])
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
ylabel('$\phi$ [rad]','Interpreter','latex','FontSize', font_size) 
% leg = legend('Interpreter','latex', 'Location', 'southwest','FontSize', font_size) ;
% leg.ItemTokenSize = [x1,x2];
%grid()

%sgtitle("AoA = 0, 23 m/s,  Smooth FRF Comparison Lower Shaker Gain", 'Interpreter','latex')

t.TileSpacing = 'none';
t.Padding = 'none';


set(gcf,'Units','Inches');
pos = get(gcf,'Position');
set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

export_path = "Figures/Lower_shaker_gain/Smooth_FRF_shaker_gain_comparison_23ms_";
exportgraphics(gcf, export_path + ".pdf")
saveas(gcf, export_path + ".jpg")


% 24 m/s
fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];

t= tiledlayout(2, 1);

nexttile(t)
plot(freq_high_gain, abs(smooth_FRF_24ms), 'Displayname', "Gain 1", 'color', color_order(1,:))
hold on
plot(freq, abs(smooth_complex_all(:, 3)), 'Displayname', "Gain 2", 'color', color_order(2,:))


yline(1,'HandleVisibility','off')

xlim([f_min, f_max])
% xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
set(gca,'XTickLabel',[]);
ylabel('Magnitude','Interpreter','latex','FontSize', font_size) 

leg = legend('Interpreter','latex', 'Location', 'northwest','FontSize', font_size) ;
leg.ItemTokenSize = [x1,x2];
%grid()

nexttile(t)
plot(freq_high_gain, angle(smooth_FRF_24ms), 'Displayname', "Gain 1", 'color', color_order(1,:))
hold on
plot(freq, angle(smooth_complex_all(:, 3)), 'Displayname', "Gain 2", 'color', color_order(2,:))


yline(0,'HandleVisibility','off')
yline(pi,'HandleVisibility','off')
yline(-pi,'HandleVisibility','off')


xlim([f_min, f_max])
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
ylabel('$\phi$ [rad]','Interpreter','latex','FontSize', font_size) 
% leg = legend('Interpreter','latex', 'Location', 'southwest','FontSize', font_size) ;
% leg.ItemTokenSize = [x1,x2];
%grid()

%sgtitle("AoA = 0, 24 m/s,  Smooth FRF Comparison Lower Shaker Gain", 'Interpreter','latex')

t.TileSpacing = 'none';
t.Padding = 'none';

set(gcf,'Units','Inches');
pos = get(gcf,'Position');
set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

export_path = "Figures/Lower_shaker_gain/Smooth_FRF_shaker_gain_comparison_24ms_";
exportgraphics(gcf, export_path + ".pdf")
saveas(gcf, export_path + ".jpg")



% All V
fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];

t = tiledlayout(2, 1);
nexttile(t)
plot(freq, abs(smooth_complex_all(:, 1)), 'Displayname', "22 m/s, Gain 2", 'color', color_order(1,:))
hold on
plot(freq_high_gain, abs(smooth_FRF_22ms), 'Displayname', "22 m/s, Gain 1", 'color', color_order(2,:))

plot(freq, abs(smooth_complex_all(:, 2)), 'Displayname', "23 m/s, Gain 2", 'color', color_order(3,:))
plot(freq_high_gain, abs(smooth_FRF_23ms), 'Displayname', "23 m/s, Gain 1", 'color', color_order(4,:))

plot(freq, abs(smooth_complex_all(:, 3)), 'Displayname', "24 m/s, Gain 2", 'color', color_order(5,:))
hold on
plot(freq_high_gain, abs(smooth_FRF_24ms), 'Displayname', "24 m/s, Gain 1", 'color', color_order(6,:))
yline(1,'HandleVisibility','off')

xlim([f_min, f_max])
% xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
set(gca,'XTickLabel',[]);
ylabel('Magnitude','Interpreter','latex','FontSize', font_size) 

leg = legend('Interpreter','latex', 'Location', 'northwest','FontSize', font_size) ;
leg.ItemTokenSize = [x1,x2];
%grid()

nexttile(t)

plot(freq, angle(smooth_complex_all(:, 1)), 'Displayname', "22 m/s, Gain 2", 'color', color_order(1,:))
hold on
plot(freq_high_gain, angle(smooth_FRF_22ms), 'Displayname', "22 m/s, Gain 1", 'color', color_order(2,:))

plot(freq, angle(smooth_complex_all(:, 2)), 'Displayname', "23 m/s, Gain 2", 'color', color_order(3,:))
plot(freq_high_gain, angle(smooth_FRF_23ms), 'Displayname', "23 m/s, Gain 1", 'color', color_order(4,:))

plot(freq, angle(smooth_complex_all(:, 3)), 'Displayname', "24 m/s, Gain 2", 'color', color_order(5,:))
hold on
plot(freq_high_gain, angle(smooth_FRF_24ms), 'Displayname', "24 m/s, Gain 1", 'color', color_order(6,:))
yline(0,'HandleVisibility','off')
yline(pi,'HandleVisibility','off')
yline(-pi,'HandleVisibility','off')


xlim([f_min, f_max])
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size) 
ylabel('$\phi$ [rad]','Interpreter','latex','FontSize', font_size) 
% leg = legend('Interpreter','latex', 'Location', 'southwest','FontSize', font_size) ;
% leg.ItemTokenSize = [x1,x2];
%grid()

%sgtitle("AoA = 0,  Smooth FRF Comparison Lower Shaker Gain", 'Interpreter','latex')
t.TileSpacing = 'none';
t.Padding = 'none';


set(gcf,'Units','Inches');
pos = get(gcf,'Position');
set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

export_path = "Figures/Lower_shaker_gain/Smooth_FRF_shaker_gain_comparison";
exportgraphics(gcf, export_path + ".pdf")
saveas(gcf, export_path + ".jpg")


%% PFM plot G, omega_PCO vs. Velocity (for high and low excitation gain)


V_lst_Test = [22, 23, 24];
omega_PCO_lst_Test = [20.13718449,19.94316114,20.59608456];
G_PCO_lst_Test = [3.769347594,3.670450149,0.55998946];


V_lst = [22, 23, 24];
omega_PCO_lst = [20.0359,19.8435,20.471];
G_PCO_lst = [2.3249,2.0604,0.505];

fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
plot(V_lst, G_PCO_lst, 'Displayname', "Gain 2")
hold on
plot(V_lst_Test, G_PCO_lst_Test, 'Displayname', "Gain 1")


xlabel('V [m/s]','Interpreter','latex','FontSize', font_size) 
ylabel('Magnitude','Interpreter','latex','FontSize', font_size) 

leg = legend('Interpreter','latex', 'Location', 'northeast','FontSize', font_size) ;
leg.ItemTokenSize = [x1,x2];
%grid()

set(gca,'FontSize', font_size)

set(gcf,'Units','Inches');
pos = get(gcf,'Position');
set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

export_path = "Figures/Lower_shaker_gain/PFM_comparison_Gain";
exportgraphics(gcf, export_path + ".pdf")
saveas(gcf, export_path + ".jpg")




fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
plot(V_lst, omega_PCO_lst, 'Displayname', "Gain 2")
hold on
plot(V_lst_Test, omega_PCO_lst_Test, 'Displayname', "Gain 1")

xlabel('V [m/s]','Interpreter','latex','FontSize', font_size) 
ylabel('$\omega_{PCO}$ [Hz]','Interpreter','latex','FontSize', font_size) 

leg = legend('Interpreter','latex', 'Location', 'northwest','FontSize', font_size) ;
leg.ItemTokenSize = [x1,x2];
%grid()

set(gca,'FontSize', font_size)


% set(gcf,'Units','Inches');
% pos = get(gcf,'Position');
% set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

% export_path = "Figures/Lower_shaker_gain/Smooth_FRF_shaker_gain_comparison";
% exportgraphics(gcf, export_path + ".pdf")
% saveas(gcf, export_path + ".jpg")

set(gcf,'Units','Inches');
pos = get(gcf,'Position');
set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

export_path = "Figures/Lower_shaker_gain/PFM_comparison_omega_PCO";
exportgraphics(gcf, export_path + ".pdf")
saveas(gcf, export_path + ".jpg")
