clc
clear all
close all

%% Start script

% font settings
font = 'Times New Roman';
font_size = 9;
legend_font_size = 9;

f_min = 18; % Hz
f_max = 21; % Hz

%% xx
% Load coherence files
AoA_2_21ms_xx = load('Middle_LE_Shroud_FRF_data/Coherences/Coherence_AoA_2_21ms_x_x.mat').Coherence;

AoA_2_21ms_xx_coherence = AoA_2_21ms_xx.y_values.values;

start_val = AoA_2_21ms_xx.x_values.start_value;
step = AoA_2_21ms_xx.x_values.increment;
number = AoA_2_21ms_xx.x_values.number_of_values;
freq = linspace(0, step*(number-1), number);

% Specify bounds of interest (min and max frequency)
[~, idx_min] = min(abs(freq - f_min));
[~, idx_max] = min(abs(freq - f_max));

freq = freq(idx_min:idx_max);
AoA_2_21ms_xx_coherence = AoA_2_21ms_xx_coherence(idx_min:idx_max);


fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
plot(freq, AoA_2_21ms_xx_coherence)

set(gca,'FontSize', font_size) 
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size,'FontName', font) 
ylabel('Coherence','Interpreter','latex','FontSize', font_size,'FontName', font) 


ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

exportgraphics(gcf, 'Figures/FRF/Coherence/Coherence_AoA_2_21ms_xx.pdf', 'Resolution', 600)
saveas(gcf, 'Figures/FRF/Coherence/Coherence_AoA_2_21ms_xx.jpg')


%% xz
% Load coherence files
AoA_2_21ms_xz = load('Middle_LE_Shroud_FRF_data/Coherences/Coherence_AoA_2_21ms_x_z.mat').Coherence;

AoA_2_21ms_xz_coherence = AoA_2_21ms_xz.y_values.values;

start_val = AoA_2_21ms_xz.x_values.start_value;
step = AoA_2_21ms_xz.x_values.increment;
number = AoA_2_21ms_xz.x_values.number_of_values;
freq = linspace(0, step*(number-1), number);

% Specify bounds of interest (min and max frequency)
[~, idx_min] = min(abs(freq - f_min));
[~, idx_max] = min(abs(freq - f_max));

freq = freq(idx_min:idx_max);
AoA_2_21ms_xz_coherence = AoA_2_21ms_xz_coherence(idx_min:idx_max);


fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
plot(freq, AoA_2_21ms_xz_coherence)

set(gca,'FontSize', font_size) 
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size,'FontName', font) 
ylabel('Coherence','Interpreter','latex','FontSize', font_size,'FontName', font) 


ax = gca;
ax.FontSize = font_size;
ax.FontName = font;
% axis square

exportgraphics(gcf, 'Figures/FRF/Coherence/Coherence_AoA_2_21ms_xz.pdf', 'Resolution', 600)
saveas(gcf, 'Figures/FRF/Coherence/Coherence_AoA_2_21ms_xz.jpg')


%% zx
% Load coherence files
AoA_2_21ms_zx = load('Middle_LE_Shroud_FRF_data/Coherences/Coherence_AoA_2_21ms_z_x.mat').Coherence;

AoA_2_21ms_zx_coherence = AoA_2_21ms_zx.y_values.values;

start_val = AoA_2_21ms_zx.x_values.start_value;
step = AoA_2_21ms_zx.x_values.increment;
number = AoA_2_21ms_zx.x_values.number_of_values;
freq = linspace(0, step*(number-1), number);

% Specify bounds of interest (min and max frequency)
[~, idx_min] = min(abs(freq - f_min));
[~, idx_max] = min(abs(freq - f_max));

freq = freq(idx_min:idx_max);
AoA_2_21ms_zx_coherence = AoA_2_21ms_zx_coherence(idx_min:idx_max);


fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
plot(freq, AoA_2_21ms_zx_coherence)

set(gca,'FontSize', font_size) 
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size,'FontName', font) 
ylabel('Coherence','Interpreter','latex','FontSize', font_size,'FontName', font) 


ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

exportgraphics(gcf, 'Figures/FRF/Coherence/Coherence_AoA_2_21ms_zx.pdf', 'Resolution', 600)
saveas(gcf, 'Figures/FRF/Coherence/Coherence_AoA_2_21ms_zx.jpg')


%% zz
% Load coherence files
AoA_2_21ms_zz = load('Middle_LE_Shroud_FRF_data/Coherences/Coherence_AoA_2_21ms_z_z.mat').Coherence;

AoA_2_21ms_zz_coherence = AoA_2_21ms_zz.y_values.values;

start_val = AoA_2_21ms_zz.x_values.start_value;
step = AoA_2_21ms_zz.x_values.increment;
number = AoA_2_21ms_zz.x_values.number_of_values;
freq = linspace(0, step*(number-1), number);

% Specify bounds of interest (min and max frequency)
[~, idx_min] = min(abs(freq - f_min));
[~, idx_max] = min(abs(freq - f_max));

freq = freq(idx_min:idx_max);
AoA_2_21ms_zz_coherence = AoA_2_21ms_zz_coherence(idx_min:idx_max);


fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
plot(freq, AoA_2_21ms_zz_coherence)

set(gca,'FontSize', font_size) 
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size,'FontName', font) 
ylabel('Coherence','Interpreter','latex','FontSize', font_size,'FontName', font) 


ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

exportgraphics(gcf, 'Figures/FRF/Coherence/Coherence_AoA_2_21ms_zz.pdf', 'Resolution', 600)
saveas(gcf, 'Figures/FRF/Coherence/Coherence_AoA_2_21ms_zz.jpg')



%% zz and xz
% Load coherence files
AoA_2_21ms_zz = load('Middle_LE_Shroud_FRF_data/Coherences/Coherence_AoA_2_21ms_z_z.mat').Coherence;

AoA_2_21ms_xz = load('Middle_LE_Shroud_FRF_data/Coherences/Coherence_AoA_2_21ms_x_z.mat').Coherence;

AoA_2_21ms_xz_coherence = AoA_2_21ms_xz.y_values.values;

AoA_2_21ms_zz_coherence = AoA_2_21ms_zz.y_values.values;

start_val = AoA_2_21ms_zz.x_values.start_value;
step = AoA_2_21ms_zz.x_values.increment;
number = AoA_2_21ms_zz.x_values.number_of_values;
freq = linspace(0, step*(number-1), number);

% Specify bounds of interest (min and max frequency)
[~, idx_min] = min(abs(freq - f_min));
[~, idx_max] = min(abs(freq - f_max));

freq = freq(idx_min:idx_max);
AoA_2_21ms_zz_coherence = AoA_2_21ms_zz_coherence(idx_min:idx_max);
AoA_2_21ms_xz_coherence = AoA_2_21ms_xz_coherence(idx_min:idx_max);


fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
plot(freq, AoA_2_21ms_zz_coherence, 'Displayname', 'zz')
hold on
plot(freq, AoA_2_21ms_xz_coherence, 'Displayname', 'xz')

set(gca,'FontSize', font_size) 
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size,'FontName', font) 
ylabel('Coherence','Interpreter','latex','FontSize', font_size,'FontName', font) 

legend('Interpreter','latex','FontSize', font_size,'FontName', font, 'Location', 'southeast')

ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

exportgraphics(gcf, 'Figures/FRF/Coherence/Coherence_AoA_2_21ms_zz_xz.pdf', 'Resolution', 600)
saveas(gcf, 'Figures/FRF/Coherence/Coherence_AoA_2_21ms_zz_xz.jpg')


%% zz and xz
% Load coherence files
AoA_2_21ms_xx = load('Middle_LE_Shroud_FRF_data/Coherences/Coherence_AoA_2_21ms_x_x.mat').Coherence;

AoA_2_21ms_zx = load('Middle_LE_Shroud_FRF_data/Coherences/Coherence_AoA_2_21ms_z_x.mat').Coherence;

AoA_2_21ms_zx_coherence = AoA_2_21ms_zx.y_values.values;

AoA_2_21ms_xx_coherence = AoA_2_21ms_xx.y_values.values;

start_val = AoA_2_21ms_zz.x_values.start_value;
step = AoA_2_21ms_zz.x_values.increment;
number = AoA_2_21ms_zz.x_values.number_of_values;
freq = linspace(0, step*(number-1), number);

% Specify bounds of interest (min and max frequency)
[~, idx_min] = min(abs(freq - f_min));
[~, idx_max] = min(abs(freq - f_max));

freq = freq(idx_min:idx_max);
AoA_2_21ms_xx_coherence = AoA_2_21ms_xx_coherence(idx_min:idx_max);
AoA_2_21ms_zx_coherence = AoA_2_21ms_zx_coherence(idx_min:idx_max);


fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
plot(freq, AoA_2_21ms_xx_coherence, 'Displayname', 'xx')
hold on
plot(freq, AoA_2_21ms_zx_coherence, 'Displayname', 'zx')

set(gca,'FontSize', font_size) 
xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size,'FontName', font) 
ylabel('Coherence','Interpreter','latex','FontSize', font_size,'FontName', font) 

legend('Interpreter','latex','FontSize', font_size,'FontName', font, 'Location', 'northwest')

ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

exportgraphics(gcf, 'Figures/FRF/Coherence/Coherence_AoA_2_21ms_xx_zx.pdf', 'Resolution', 600)
saveas(gcf, 'Figures/FRF/Coherence/Coherence_AoA_2_21ms_xx_zx.jpg')
