clc
clear all
close all

%% Script starts
% Scripts settings

% % font settings
% font = 'Times New Roman';
% font_size = 10;

% legend formatting settings
x1 = 15;
x2 = 18;%18

color_order = [0,0.447000000000000,0.741000000000000;
0.850000000000000,0.325000000000000,0.0980000000000000;
0.929000000000000,0.694000000000000,0.125000000000000;
0.494000000000000,0.184000000000000,0.556000000000000;
0.466000000000000,0.674000000000000,0.188000000000000;
0.301000000000000,0.745000000000000,0.933000000000000;
0.635000000000000,0.0780000000000000,0.184000000000000];

% font settings
font = 'Times New Roman';
font_size = 9;
legend_font_size = 9;

% legend settings
% x1 = 15; % 30
% x2 = 5;



% f_min = 18; % Hz 18
% f_max = 25; % Hz 25

% mu = 9.6808/6.418;

pf = 9.6808; % gram (stationary)
m_s = 6.418; % gram (moving)

mu = pf/m_s;

% mu = 1;
% mu = 28.90682/6.418;


n_round = 10;

% zoom in onto section of plot and have original plot in same figure
% http://we15hang.blogspot.com/2012/02/matlab-making-zoom-in-plot-on-top-of.html

% Smoothdata parameters correction factors
window_correction = 30;
method_correction = 'gaussian';

% Plot FRF's
Plot_FRF = 1; % 0: False; 1: True

% Plot FRF as an eigenvalue evolution
plot_FRF_eigval = 0; % 0: False; 1: True

% Save plots
savefig = 1; % 0: False; 1: True 

% Perform SISO PFM Interpolation
interp_SISO = 0; % 0: False; 1: True

% Plot Eigvals
plot_eigvals = 0; % 0: False; 1: True

% Plot Bode Plot of eigenvalues
Bode_eigval = 0; % 0: False; 1: True



smooth_param = struct();
smoothing_factor_data = struct();

% % AoA_0
% AoA = 0; % Needed for title in plots
% filename = "Middle_LE_Shroud_FRF_data/Matlab_Analysis_Files/Middle_LE_shroud_AoA_0.mat";
% Column_name = ["Freq","20_x/x", "20_y/x", "20_z/x", "20_x/z", "20_y/z", "20_z/z", "21_x/x", "21_y/x", "21_z/x", "21_x/z", "21_y/z", "21_z/z", "22_x/x", "22_y/x", "22_z/x", "22_x/z", "22_y/z", "22_z/z", "22_5_x/x", "22_5_y/x", "22_5_z/x", "22_5_x/z", "22_5_y/z", "22_5_z/z","23_x/x", "23_y/x", "23_z/x", "23_x/z", "23_y/z", "23_z/z", "23_5_x/x", "23_5_y/x", "23_5_z/x", "23_5_x/z", "23_5_y/z", "23_5_z/z", "24_x/x", "24_y/x", "24_z/x", "24_x/z", "24_y/z", "24_z/z", "24_5_x/x", "24_5_y/x", "24_5_z/x", "24_5_x/z", "24_5_y/z", "24_5_z/z", "25_x/x", "25_y/x", "25_z/x", "25_x/z", "25_y/z", "25_z/z"];
% Velocity_lst = [20, 21, 22, 22.5, 23, 23.5, 24, 24.5, 25];
% SISO_figures_filename = "Figures/FRF/SISO_PFM_AoA_0_";
% MIMO_figures_filename = "Figures/MIMO/MIMO_PFM_AoA_0_";
% eigval_fig_name_bode = "Figures/Eigenvalues/Bode/Bode_PFM_AoA_0";
% eigval_fig_name_real_im = "Figures/Eigenvalues/Real_v_Im/real_v_im_PFM_AoA_0_";
% f_min = 18; % Hz 18
% f_max = 23; % Hz 25 23
% time_data_file = "Middle_LE_Shroud_Time_data/Analysis_data_Matlab/Middle_LE_shroud_Time_AoA_0.mat"';
% new_filename = "Middle_LE_Smooth_FRF/Smooth_FRF_AoA_0.mat";
% raw_signal_set = 0;
% new_filename = "Middle_LE_Smooth_FRF/Raw_FRF_AoA_0.mat";
% raw_signal_set = 1;
% 
% smoothing_factor_data.("alpha_0").zz = 0.15;
% smoothing_factor_data.("alpha_0").xz = 0.15;
% 
% smooth_param.("V_20").sdx = 0.08;
% smooth_param.("V_20").q_val = 7; % 3
% smooth_param.("V_20").nmin = 9; % 5
% 
% smooth_param.("V_21").sdx = 0.08;
% smooth_param.("V_21").q_val = 7;
% smooth_param.("V_21").nmin = 9;
% 
% smooth_param.("V_21_5").sdx = 0.08;
% smooth_param.("V_21_5").q_val = 7;
% smooth_param.("V_21_5").nmin = 9;
% 
% smooth_param.("V_22").sdx = 0.08;
% smooth_param.("V_22").q_val = 7;
% smooth_param.("V_22").nmin = 9;
% 
% smooth_param.("V_22_5").sdx = 0.08;
% smooth_param.("V_22_5").q_val = 7;
% smooth_param.("V_22_5").nmin = 9;
% 
% smooth_param.("V_23").sdx = 0.08;
% smooth_param.("V_23").q_val = 7;
% smooth_param.("V_23").nmin = 9;
% 
% smooth_param.("V_23_5").sdx = 0.08;
% smooth_param.("V_23_5").q_val = 7;
% smooth_param.("V_23_5").nmin = 9;
% 
% smooth_param.("V_24").sdx = 0.05;
% smooth_param.("V_24").q_val = 3;
% smooth_param.("V_24").nmin = 5;
% 
% smooth_param.("V_24_5").sdx = 0.08;
% smooth_param.("V_24_5").q_val = 7;
% smooth_param.("V_24_5").nmin = 9;
% 
% smooth_param.("V_25").sdx = 0.08;
% smooth_param.("V_25").q_val = 7;
% smooth_param.("V_25").nmin = 9;



% % AoA_2 
AoA = 2; % Needed for title in plots
filename = "Middle_LE_Shroud_FRF_data/Matlab_Analysis_Files/Middle_LE_shroud_AoA_2.mat";
Column_name = ["Freq", "19_x/x", "19_y/x", "19_z/x", "19_x/z", "19_y/z", "19_z/z", "20_x/x", "20_y/x", "20_z/x", "20_x/z", "20_y/z", "20_z/z", "21_x/x", "21_y/x", "21_z/x", "21_x/z", "21_y/z", "21_z/z", "21_5_x/x", "21_5_y/x", "21_5_z/x", "21_5_x/z", "21_5_y/z", "21_5_z/z", "22_x/x", "22_y/x", "22_z/x", "22_x/z", "22_y/z", "22_z/z","23_x/x", "23_y/x", "23_z/x", "23_x/z", "23_y/z", "23_z/z", "23_5_x/x", "23_5_y/x", "23_5_z/x", "23_5_x/z", "23_5_y/z", "23_5_z/z"];
Velocity_lst = [19, 20, 21, 21.5, 22, 23, 23.5];
SISO_figures_filename = "Figures/FRF/SISO_PFM_AoA_2_";
MIMO_figures_filename = "Figures/MIMO/MIMO_PFM_AoA_2_";
eigval_fig_name_bode = "Figures/Eigenvalues/Bode/Bode_PFM_AoA_2";
eigval_fig_name_real_im = "Figures/Eigenvalues/Real_v_Im/real_v_im_PFM_AoA_2_";
f_min = 18; % Hz
f_max = 21; % Hz
time_data_file = "Middle_LE_Shroud_Time_data/Analysis_data_Matlab/Middle_LE_shroud_Time_AoA_2.mat"';
new_filename = "Middle_LE_Smooth_FRF/Smooth_FRF_AoA_2.mat";
raw_signal_set = 0;
% new_filename = "Middle_LE_Smooth_FRF/Raw_FRF_AoA_2.mat";
% raw_signal_set = 1;


smoothing_factor_data.("alpha_2").zz = 0.15;
smoothing_factor_data.("alpha_2").xz = 0.15;


smooth_param.("V_19").sdx = 0.08;
smooth_param.("V_19").q_val = 7;
smooth_param.("V_19").nmin = 9;

smooth_param.("V_20").sdx = 0.08;
smooth_param.("V_20").q_val = 7;
smooth_param.("V_20").nmin = 9;

smooth_param.("V_21").sdx = 0.08;
smooth_param.("V_21").q_val = 7;
smooth_param.("V_21").nmin = 9;

smooth_param.("V_21_5").sdx = 0.08;
smooth_param.("V_21_5").q_val = 7;
smooth_param.("V_21_5").nmin = 9;

smooth_param.("V_22").sdx = 0.08;
smooth_param.("V_22").q_val = 7;
smooth_param.("V_22").nmin = 9;

smooth_param.("V_23").sdx = 0.08;
smooth_param.("V_23").q_val = 7;
smooth_param.("V_23").nmin = 9;

smooth_param.("V_23_5").sdx = 0.08;
smooth_param.("V_23_5").q_val = 7;
smooth_param.("V_23_5").nmin = 9;

% % AoA_4
% AoA = 4; % Needed for title in plots
% filename = "Middle_LE_Shroud_FRF_data/Matlab_Analysis_Files/Middle_LE_shroud_AoA_4.mat";
% Column_name = ["Freq","18_x/x", "18_y/x", "18_z/x", "18_x/z", "18_y/z", "18_z/z", "18_5_x/x", "18_5_y/x", "18_5_z/x", "18_5_x/z", "18_5_y/z", "18_5_z/z", "19_x/x", "19_y/x", "19_z/x", "19_x/z", "19_y/z", "19_z/z", "20_x/x", "20_y/x", "20_z/x", "20_x/z", "20_y/z", "20_z/z", "21_x/x", "21_y/x", "21_z/x", "21_x/z", "21_y/z", "21_z/z", "21_5_x/x", "21_5_y/x", "21_5_z/x", "21_5_x/z", "21_5_y/z", "21_5_z/z", "22_x/x", "22_y/x", "22_z/x", "22_x/z", "22_y/z", "22_z/z","23_x/x", "23_y/x", "23_z/x", "23_x/z", "23_y/z", "23_z/z"];
% Velocity_lst = [18, 18.5, 19, 20, 21, 21.5, 22, 23];
% SISO_figures_filename = "Figures/FRF/SISO_PFM_AoA_4_";
% MIMO_figures_filename = "Figures/MIMO/MIMO_PFM_AoA_4";
% eigval_fig_name_bode = "Figures/Eigenvalues/Bode/Bode_PFM_AoA_4";
% eigval_fig_name_real_im = "Figures/Eigenvalues/Real_v_Im/real_v_im_PFM_AoA_4_";
% f_min = 17; % Hz
% f_max = 21; % Hz 
% time_data_file = "Middle_LE_Shroud_Time_data/Analysis_data_Matlab/Middle_LE_shroud_Time_AoA_4.mat"';
% new_filename = "Middle_LE_Smooth_FRF/Smooth_FRF_AoA_4.mat";
% raw_signal_set = 0;
% % new_filename = "Middle_LE_Smooth_FRF/Raw_FRF_AoA_4.mat";
% % raw_signal_set = 1;
% 
% 
% smoothing_factor_data.("alpha_4").zz = 0.15; % 0.15
% smoothing_factor_data.("alpha_4").xz = 0.25;
% 
% smooth_param.("V_18").sdx = 0.08;
% smooth_param.("V_18").q_val = 7;
% smooth_param.("V_18").nmin = 9;
% 
% smooth_param.("V_18_5").sdx = 0.1; 
% smooth_param.("V_18_5").q_val = 7;
% smooth_param.("V_18_5").nmin = 15;
% 
% smooth_param.("V_19").sdx = 0.08;
% smooth_param.("V_19").q_val = 7;
% smooth_param.("V_19").nmin = 9;
% 
% smooth_param.("V_20").sdx = 0.08;
% smooth_param.("V_20").q_val = 7;
% smooth_param.("V_20").nmin = 9;
% 
% smooth_param.("V_21").sdx = 0.08;
% smooth_param.("V_21").q_val = 7;
% smooth_param.("V_21").nmin = 9;
% 
% smooth_param.("V_21_5").sdx = 0.08;
% smooth_param.("V_21_5").q_val = 7;
% smooth_param.("V_21_5").nmin = 9;
% 
% smooth_param.("V_22").sdx = 0.08;
% smooth_param.("V_22").q_val = 7;
% smooth_param.("V_22").nmin = 9;
% 
% smooth_param.("V_23").sdx = 0.08;
% smooth_param.("V_23").q_val = 7;
% smooth_param.("V_23").nmin = 9;

% % AoA_6
% AoA = 6; % Needed for title in plots
% filename = "Middle_LE_Shroud_FRF_data/Matlab_Analysis_Files/Middle_LE_shroud_AoA_6.mat";
% Column_name = ["Freq","16_x/x", "16_y/x", "16_z/x", "16_x/z", "16_y/z", "16_z/z", "17_x/x", "17_y/x", "17_z/x", "17_x/z", "17_y/z", "17_z/z",  "18_x/x", "18_y/x", "18_z/x", "18_x/z", "18_y/z", "18_z/z", "19_x/x", "19_y/x", "19_z/x", "19_x/z", "19_y/z", "19_z/z", "20_x/x", "20_y/x", "20_z/x", "20_x/z", "20_y/z", "20_z/z", "21_x/x", "21_y/x", "21_z/x", "21_x/z", "21_y/z", "21_z/z"];
% Velocity_lst = [16, 17, 18, 19, 20, 21];
% SISO_figures_filename = "Figures/FRF/SISO_PFM_AoA_6_";
% MIMO_figures_filename = "Figures/MIMO/MIMO_PFM_AoA_6_";
% eigval_fig_name_bode = "Figures/Eigenvalues/Bode/Bode_PFM_AoA_6_";
% eigval_fig_name_real_im = "Figures/Eigenvalues/Real_v_Im/real_v_im_PFM_AoA_6_";
% f_min = 17; % Hz
% f_max = 21; % Hz
% new_filename = "Middle_LE_Smooth_FRF/Smooth_FRF_AoA_6.mat";
% raw_signal_set = 0;
% % new_filename = "Middle_LE_Smooth_FRF/Raw_FRF_AoA_6.mat";
% % raw_signal_set = 1;
% 
% smoothing_factor_data.("alpha_6").zz = 0.3;
% smoothing_factor_data.("alpha_6").xz = 0.3;
% 
% smooth_param.("V_16").sdx = 0.08;
% smooth_param.("V_16").q_val = 7;
% smooth_param.("V_16").nmin = 9;
% 
% smooth_param.("V_17").sdx = 0.08;
% smooth_param.("V_17").q_val = 7;
% smooth_param.("V_17").nmin = 9;
% 
% smooth_param.("V_18").sdx = 0.08;
% smooth_param.("V_18").q_val = 7;
% smooth_param.("V_18").nmin = 9;
% 
% smooth_param.("V_18_5").sdx = 0.08;
% smooth_param.("V_18_5").q_val = 7;
% smooth_param.("V_18_5").nmin = 9;
% 
% smooth_param.("V_19").sdx = 0.08;
% smooth_param.("V_19").q_val = 7;
% smooth_param.("V_19").nmin = 9;
% 
% smooth_param.("V_20").sdx = 0.08;
% smooth_param.("V_20").q_val = 7;
% smooth_param.("V_20").nmin = 9;
% 
% smooth_param.("V_21").sdx = 0.08;
% smooth_param.("V_21").q_val = 7;
% smooth_param.("V_21").nmin = 9;

%% Set input variables to variables used in script
Velocity_AoA_0 = Velocity_lst;
column_name_AoA_0 = Column_name;
filename_AoA_0 = filename;
%% Get correction factors

[mag_phase_complex_force, mag_phase_accel_x, mag_phase_accel_y, mag_phase_accel_z, mag_phase_mov_accel,mag_phase_complex_stab_mov_x, mag_phase_complex_stab_mov_y, mag_phase_complex_stab_mov_z] = Calculate_Correction_Factors(method_correction, window_correction);


%% load FRF data (.mat file)

data_AoA_0 = load(filename_AoA_0).freq_and_sig_complex_table;


% Time_data = load(time_data_file).AoA_data;

test_array = [7, 13, 19, 25, 31, 37, 43, 49, 55]; 
test_xx = [];
% test_y = [];
test_zz = [];
test_xz = [];
test_zx= [];

for mdx=1:(length(column_name_AoA_0)-1)/6
    test_xx = [test_xx, 2 + 6*(mdx-1)];
    test_zz = [test_zz, 7 + 6*(mdx-1)];
    test_xz = [test_xz, 5 + 6*(mdx-1)];
    test_zx = [test_zx, 4 + 6*(mdx-1)];
end


% Apply mass scaling mu and smooth FRF data
AoA_0_mag_phase = [];

% Data needed for linear interpolation SISO PFM
G_omega_plus_all = struct();
G_omega_min_all = struct();
phase_plus_all = struct();
phase_min_all = struct();
omega_plus_all = struct();
omega_min_all = struct();

% Using different smoothing parameters for different velocities
Vel_smooth_lst = repelem(Velocity_AoA_0, 6);
test_fig = 0;
for k=2:min(size(data_AoA_0))
    Vel_smooth = "V_" + string(Vel_smooth_lst(k-1));
    Vel_smooth = strrep(Vel_smooth, ".", "_");
    
    Vel_smooth_time = Vel_smooth + "ms"; 
    
    Vel_val = "V_" + column_name_AoA_0(k);
    Vel_val = strrep(Vel_val, "/", "");
    
    % Get complex number and frequency
    complex = data_AoA_0(:, k);
    complex = table2array(complex);
    freq_all = linspace(0, 80, length(complex));
    freq = freq_all;
    


% Specify bounds of interest (min and max frequency)
    [~, idx_min] = min(abs(freq - f_min));
    [~, idx_max] = min(abs(freq - f_max));
    
    freq = freq(idx_min:idx_max);
%% Apply correction factors to raw FRF data
% raw FRF scaled with all correction factors
    complex_new = mu*complex; 
    mag_phase_complex_all = [];
    for m=1:length(complex_new)
        % multiply complex number of PFM FRF with 1/shaker force FRF
        complex_new_m = complex_new(m);
        complex_new_m = complex_new_m*1/(mag_phase_complex_force(m));
    
        mag_phase_complex_all = [mag_phase_complex_all; complex_new_m];% [smooth_mag_db, smooth_phase];
    end
    
%     %% Use Time Data to get TF
% %     Get TF from time data using tfestimate
%     Time_mov_z = Time_data.z_excitation.(Vel_smooth_time).('Moving_mass');
%     Time_stab_zz = Time_data.z_excitation.(Vel_smooth_time).('Stab_mass_z');
%     Time_stab_xz = Time_data.z_excitation.(Vel_smooth_time).('Stab_mass_x');
%     
%     Time_mov_x = Time_data.x_excitation.(Vel_smooth_time).('Moving_mass');
%     Time_stab_zx = Time_data.x_excitation.(Vel_smooth_time).('Stab_mass_z');
%     Time_stab_xx = Time_data.x_excitation.(Vel_smooth_time).('Stab_mass_x');
%     
%     freq_all = linspace(0, 80, length(complex));
% 
% %     freq = freq_all;
%     fs = 160; % Hz (sampling rate)
%     
%     
%     
% % %     % apply mass fraction
% %     window = 5;
% %     noverlap = 2;
%     Txx_all = mu*tfestimate(Time_mov_x, Time_stab_xx, [], [], freq_all, fs, 'Estimator', 'H1');
%     Tzx_all = mu*tfestimate(Time_mov_x, Time_stab_zx, [], [], freq_all, fs, 'Estimator', 'H1'); % freq_all
%     Txz_all = mu*tfestimate(Time_mov_z, Time_stab_xz, [], [], freq_all, fs, 'Estimator', 'H1');
%     Tzz_all = mu*tfestimate(Time_mov_z, Time_stab_zz, [], [], freq_all, fs, 'Estimator', 'H1');
%     
%     % Apply force correction factors
%     Txx_all_corrected = []; %Txx_all;%*1./mag_phase_complex_force;
%     Txz_all_corrected = []; %Txz_all;%*1./mag_phase_complex_force;
%     Tzx_all_corrected = []; %Tzx_all;%*1./mag_phase_complex_force;
%     Tzz_all_corrected = []; %Tzz_all;%*1./mag_phase_complex_force;
%     
%     for m=1:length(Txx_all)
%         % multiply complex number of PFM FRF with 1/shaker force FRF
%         Txx_m = Txx_all(m);
%         Txx_m = Txx_m*1/(mag_phase_complex_force(m));
%         
%         Txz_m = Txz_all(m);
%         Txz_m = Txz_m*1/(mag_phase_complex_force(m));
%         
%         Tzx_m = Tzx_all(m);
%         Tzx_m = Tzx_m*1/(mag_phase_complex_force(m));
%         
%         Tzz_m = Tzz_all(m);
%         Tzz_m = Tzz_m*1/(mag_phase_complex_force(m));
%         
%         Txx_all_corrected = [Txx_all_corrected; Txx_m];
%         Txz_all_corrected = [Txz_all_corrected; Txz_m];
%         Tzx_all_corrected = [Tzx_all_corrected; Tzx_m];
%         Tzz_all_corrected = [Tzz_all_corrected; Tzz_m];
%     end
%      
%     % Specify bounds of interest (min and max frequency)
% %     [~, idx_min] = min(abs(freq - f_min));
% %     [~, idx_max] = min(abs(freq - f_max));
% %     
% %     freq = freq(idx_min:idx_max);
%     
%     Txx_corrected = Txx_all_corrected(idx_min:idx_max);
%     Tzx_corrected = Tzx_all_corrected(idx_min:idx_max);
%     Txz_corrected = Txz_all_corrected(idx_min:idx_max);
%     Tzz_corrected = Tzz_all_corrected(idx_min:idx_max);
%     
%% Create smoothed data from complex using S(x) = (Y(x-1) + 2*Y(x) + Y(x+1))/4 --> Smooth_FRF function in TestLab
%     freq_smooth = reshape(freq, length(freq), 1);
% 
%     
%     if ismember(k, test_xx) == 1 || ismember(k, test_zx) == 1
%         removed_outliers_complex =mag_phase_complex_all(idx_min:idx_max);
%         avg_complex = mean(removed_outliers_complex);
% 
%         smooth_complex = repmat(avg_complex, length(freq_smooth), 1);
%         
%     elseif ismember(k, test_xz) == 1 || ismember(k, test_zz) == 1
%         smooth_complex = []; 
%         for m=1:length(mag_phase_complex_all) 
%                 % Smooth complex number (when using z-excitation)
%             if m > 1 && m < length(mag_phase_complex_all)
% %                 Y_x_min_3 = mag_phase_complex_all(m-3);
% %                 Y_x_min_2 = mag_phase_complex_all(m-2);
%                 Y_x_min_1 = mag_phase_complex_all(m-1);
%                 Y_x = mag_phase_complex_all(m);
%                 Y_x_plus_1 = mag_phase_complex_all(m+1);
% %                 Y_x_plus_2 = mag_phase_complex_all(m+2);
% %                 Y_x_plus_3 = mag_phase_complex_all(m+3);
% 
%                 S_x = (Y_x_min_1 + 2*Y_x + Y_x_plus_1)/4;
%                 
% %                 S_x = (Y_x_min_3 + 1.5*Y_x_min_2 + 2*Y_x_min_1 + 4*Y_x + 2*Y_x_plus_1 + 1.5*Y_x_plus_2 + Y_x_plus_3)/13;
%     %             S_x = (Y_x_min_2 + Y_x_min_1 + 2*Y_x + Y_x_plus_1 + Y_x_plus_2)/6;
%     %             disp("Taking Moving Average")
%             else
%                 S_x = mag_phase_complex_all(m);
%     %             disp("Not taking Moving Average")
%             end
%     %         
%             smooth_complex = [smooth_complex; S_x];   
%         end
%         
%         smooth_complex = smooth_complex(idx_min:idx_max);
%     end
    
    
    
    
    %% Smooth data using adaptive smoothing and apply limits based on f_min and f_max
    freq_smooth = reshape(freq, length(freq), 1);
    dados = [freq_smooth, mag_phase_complex_all(idx_min:idx_max)];
    xnew = freq_smooth;
    
    
    if ismember(k, test_zx) == 1 || ismember(k, test_xx) == 1 
        sdx = 0.013;
        isdx = 0.8*sdx;
        q_val = 5; % 3 
        nmin = 7; % 5 
        
        raw_signal = mag_phase_complex_all(idx_min:idx_max);
%         method = 'rlowess';
%         window = [];
%         smoothing_factor = 0.75;
%         smooth_complex = smoothdata(raw_signal, method, window, 'SmoothingFactor', smoothing_factor);
        if raw_signal_set == 1
            smooth_complex = raw_signal;
        else
            method = 'gaussian';
            window = [];
            smoothing_factor = 0.45;
            mag_smooth_complex = smoothdata(abs(raw_signal), method, window, 'SmoothingFactor', smoothing_factor);
            smoothing_factor = 0.8;
    %         phase_smooth_complex = smoothdata(angle(raw_signal), method, window, 'SmoothingFactor', smoothing_factor);
            phase_smooth_complex = angle(raw_signal);

            smooth_complex = [];
            for m =1:length(raw_signal)
                smooth_complex_m = mag_smooth_complex(m)*(cos(phase_smooth_complex(m)) + j*sin(phase_smooth_complex(m)));
                smooth_complex = [smooth_complex; smooth_complex_m];
            end
        end
%         smooth_complex = raw_signal;
        
%         ynew=adsmoothdiff2(dados,xnew,sdx,isdx,q_val,nmin);
%     
%         smooth_complex = ynew(:, 2);
%         
%         % Add outlier detection
%         mag = real(mag_phase_complex_all(idx_min:idx_max));
%         phase = angle(mag_phase_complex_all(idx_min:idx_max));
%         removed_outliers = rmoutliers([mag, phase]);
%         
% %         removed_outliers_complex = removed_outliers(:, 1).*(cos(removed_outliers(:, 2)) + j*sin(removed_outliers(:, 2)));
%         
%         R = filloutliers(mag, 'linear');
%         I = filloutliers(phase, 'linear');
% 
%         removed_outliers_complex = R.*(cos(I) + j*sin(I));
%         
% %         removed_outliers_complex = [];
% %         for rem_idx =1:length(removed_outliers)
%         
%         % Use average position of all values to create constant complex
%         % number, as the FRF is represented by a blob around a constant
%         % value
        
%         raw_signal = mag_phase_complex_all(idx_min:idx_max);
%         R = filloutliers(real(raw_signal), 'linear', "percentiles", [10 90]); %"gesd");
%         I = filloutliers(imag(raw_signal), 'linear',"percentiles", [10 90]); %"gesd");
%         removed_outliers_complex = R + j*I;
        
%         
        
%         phase = angle(removed_outliers_complex);
%         mag = abs(removed_outliers_complex);
%         
%         avg_mag = mean(mag);
%         avg_phase = mean(phase);
%         
%         
%         avg_complex =  avg_mag*(cos(avg_phase) + j*sin(avg_phase));
        
        
%         removed_outliers_complex =mag_phase_complex_all(idx_min:idx_max);
%         avg_complex = mean(removed_outliers_complex);
%         
%         smooth_complex = repmat(avg_complex, length(freq_smooth), 1);
        
        
%         % Use Moving weighted average for xx and zx response
%         smooth_complex = []; 
%         for m=1:length(mag_phase_complex_all) 
%                 % Smooth complex number (when using z-excitation)
%             if m > 1 && m < length(mag_phase_complex_all)
% %                 Y_x_min_3 = mag_phase_complex_all(m-3);
% %                 Y_x_min_2 = mag_phase_complex_all(m-2);
%                 Y_x_min_1 = mag_phase_complex_all(m-1);
%                 Y_x = mag_phase_complex_all(m);
%                 Y_x_plus_1 = mag_phase_complex_all(m+1);
% %                 Y_x_plus_2 = mag_phase_complex_all(m+2);
% %                 Y_x_plus_3 = mag_phase_complex_all(m+3);
% 
%                 S_x = (Y_x_min_1 + 2*Y_x + Y_x_plus_1)/4;
%                 
% %                 S_x = (Y_x_min_3 + 1.5*Y_x_min_2 + 2*Y_x_min_1 + 4*Y_x + 2*Y_x_plus_1 + 1.5*Y_x_plus_2 + Y_x_plus_3)/13;
%     %             S_x = (Y_x_min_2 + Y_x_min_1 + 2*Y_x + Y_x_plus_1 + Y_x_plus_2)/6;
%     %             disp("Taking Moving Average")
%             else
%                 S_x = mag_phase_complex_all(m);
%     %             disp("Not taking Moving Average")
%             end
%     %         
%             smooth_complex = [smooth_complex; S_x];   
%         end
%         
%         smooth_complex = smooth_complex(idx_min:idx_max);
%         
    elseif ismember(k, test_zz) == 1 %|| ismember(k, test_xz) == 1
        sdx = 0.04; % 0.05
        isdx = 0.8*sdx; % 0.8
        q_val = 3; 
        nmin =  5;
        
        sdx = smooth_param.(Vel_smooth).sdx;
        isdx = 0.8*sdx;
        q_val = smooth_param.(Vel_smooth).q_val;
        nmin = smooth_param.(Vel_smooth).nmin;
        
        % Add outlier detection
%         
        
%         R = filloutliers(real(raw_signal), 'linear', "percentiles", [0 90]); %"gesd");
%         I = filloutliers(imag(raw_signal), 'linear', "percentiles", [0 90]); % "gesd");
% 
%         raw_complex_outliers_rem = R.*(cos(I) + j*sin(I));
%         
%         dados = [freq_smooth, raw_complex_outliers_rem];
        
        dados = [freq_smooth, mag_phase_complex_all(idx_min:idx_max)];
        xnew = freq_smooth;
        
        ynew=adsmoothdiff2(dados,xnew,sdx,isdx,q_val,nmin);
    
        smooth_complex = ynew(:, 2);
        
        raw_signal = mag_phase_complex_all(idx_min:idx_max);
%         method = 'sgolay';
        if raw_signal_set == 1
            smooth_complex = raw_signal;
        else
            method = 'gaussian';
            window = [];
            smoothing_factor = 0.25; %AoA = 4, 0.2, AoA = 6, 0.3
            smoothing_factor = smoothing_factor_data.("alpha_"+string(AoA)).zz;
            smooth_complex = smoothdata(raw_signal, method, window, 'SmoothingFactor', smoothing_factor);
        end
        
        
        
%         smooth_complex = raw_signal;
%         raw_signal = mag_phase_complex_all(idx_min:idx_max);

    elseif ismember(k, test_xz) == 1
        raw_signal = mag_phase_complex_all(idx_min:idx_max);
%         method = 'sgolay';
        if raw_signal_set == 1
            smooth_complex = raw_signal;
        else
            method = 'gaussian';
            window = [];
            smoothing_factor = 0.25; %AoA = 4, 0.25, AoA = 6, 0.3
            smoothing_factor = smoothing_factor_data.("alpha_"+string(AoA)).xz;
            smooth_complex = smoothdata(raw_signal, method, window, 'SmoothingFactor', smoothing_factor);
        end
        
        
        
    end
    
%     %% Using Time data
%     if ismember(k, test_xx) == 1
%         smooth_complex = Txx_corrected;
%     elseif ismember(k, test_xz) == 1
%         smooth_complex = Txz_corrected;
%     elseif ismember(k, test_zx) == 1
%         smooth_complex = Tzx_corrected;
%     elseif ismember(k, test_zz) == 1
%         smooth_complex = Tzz_corrected;
%     end
%     
    
%     q_val = 3;  nmin =  5; seems to provide good fitting with peaks of
%     z-excitation
%     Because of noise in x-excitation signal, use larger gval and nval
%     (mainly larger nval)
    % Allow for different parameters when smoothing x-excitation and
    % y-excitation --> May also be different for different velocities
%     ynew=adsmoothdiff2(dados,xnew,sdx,isdx,q_val,nmin);
%     
%     smooth_complex = ynew(:, 2);
    
    % Get im and re components of FRF and smoothed FRF
    
    if plot_FRF_eigval == 1
        smooth_real = real(smooth_complex);
        smooth_imag = imag(smooth_complex);

        raw_real = real(mag_phase_complex_all(idx_min:idx_max));
        raw_imag = imag(mag_phase_complex_all(idx_min:idx_max));

        if  ismember(k, test_zx) == 1 || ismember(k, test_xx) == 1 || ismember(k, test_zz) == 1 || ismember(k, test_xz) == 1 %|| ismember(k, test_zx) == 1 || ismember(k, test_xx) == 1
            marker_symbols = ["o", "o", "<", "<","d", "d", "^", "^", "h", "h", ">", ">", "s", "s", "v", "v",  "p", "p"];
            spacing = 1;
            cmap = cool(length(freq(1:spacing:end)));

            v = freq;

            numValues = length(freq(1:spacing:end));
            markerColors = zeros(numValues, 3);

        % Now assign marker colors according to the value of the data.
            for k_idx = 1 : numValues
    %                 row = round(v(k));
                row = k_idx;
                markerColors(k_idx, :) = cmap(row, :);
            end 
            current_fig_n = get(gcf,'Number');
            if current_fig_n == 1 && test_fig == 0
                figure(1)
                test_fig=1;
            else
                figure(current_fig_n+1)
            end
            
            plot(raw_real, raw_imag, 'Color', [0, 0, 0, 0.2],'HandleVisibility','off')
            hold on
            scatter(raw_real, raw_imag, [], markerColors, marker_symbols(3), 'filled', 'DisplayName', "raw")
            
            if ismember(k, test_zz) == 1 || ismember(k, test_xz) == 1
                plot(smooth_real, smooth_imag, 'Color', [0, 0, 0, 0.2],'HandleVisibility','off')
                hold on
                scatter(smooth_real, smooth_imag, [], markerColors, marker_symbols(1), 'filled', 'DisplayName', "smooth")
            else
                plot(smooth_real, smooth_imag, 'Color', [0, 0, 0, 0.2],'HandleVisibility','off')
                hold on
                scatter(smooth_real, smooth_imag, [], 'r', marker_symbols(1), 'filled', 'DisplayName', "smooth") 
            end
            
            

            titlename = strrep(column_name_AoA_0(k), "_5", ".5");
            titlename = strrep(titlename, "_", "m/s_");
            title(titlename,'Interpreter','latex')

            legend()
            colormap(cmap);
            q = colorbar;

            caxis([min(freq), max(freq)]);
            ylabel(q, 'Frequency [hZ]', 'Rotation', 270,'Interpreter','latex', 'FontSize', 10);
            q.Label.Position(1) = 3;

%             fig_idx = fig_idx + 1;
        end
        if savefig == 1
            set(gcf,'Units','Inches');
            pos = get(gcf,'Position');
            set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])

            condition = strrep(column_name_AoA_0(k), "/", '_') + "_real_v_im";
%                 saveas(gcf, SISO_figures_filename + condition + ".pdf", 'Resolution', 600);
            path = "Figures/FRF/real_v_im/AoA_" + AoA + "_"; 
            exportgraphics(gcf, path + condition + ".pdf", 'Resolution', 600)
%             exportgraphics(gcf, "Figures/FRF/real_v_im/" + condition + ".jpg")
            saveas(gcf, path + condition + ".jpeg");
        end
    end
    
    smooth_mag = abs(smooth_complex);
    smooth_mag_db = mag2db(smooth_mag);
    smooth_phase = angle(smooth_complex);
%     
%     
    smooth_mag_2 = smooth_mag;
    smooth_phase_2 = smooth_phase;

    
    % Convert TF (mag_db and phase) at omega to complex number
%     mag_phase_complex = [];
%     for m=1:length(complex)
%         % multiply smooth complex number of PFM FRF with 1/shaker force FRF
%         % and multiply with actual moving mass acceleration scaling
% %         smooth_complex_number = db2mag(smooth_mag_db(m))*(cos(smooth_phase(m)) + j*sin(smooth_phase(m)));
%         smooth_complex_number = smooth_complex(m);
%         smooth_complex_number = smooth_complex_number*1/(mag_phase_complex_force_new(m));
% %         smooth_complex_number = smooth_complex_number*1/mag_phase_mov_accel_new(m);
%         
%         
%         
% %         if ismember(k, test_xx) == 1
% % %             smooth_complex_number = smooth_complex_number*1/mag_phase_accel_x_new(m);
% %             smooth_complex_number = smooth_complex_number*mag_phase_complex_stab_mov_y_new(m);
% %         end
% %         if ismember(k, test_zz) == 1
% % %             smooth_complex_number = smooth_complex_number*1/mag_phase_accel_z_new(m); 
% %             smooth_complex_number = smooth_complex_number*mag_phase_complex_stab_mov_z_new(m);
% %         end
% %         if ismember(k, test_xz) == 1
% % %             smooth_complex_number = smooth_complex_number*1/mag_phase_accel_x_new(m);
% %             smooth_complex_number = smooth_complex_number*mag_phase_complex_stab_mov_y_new(m);
% %         end
% %         if ismember(k, test_zx) == 1
% % %             smooth_complex_number = smooth_complex_number*1/mag_phase_accel_z_new(m); 
% %             smooth_complex_number = smooth_complex_number*mag_phase_complex_stab_mov_z_new(m);
% %         end
%         
%         mag_phase_complex = [mag_phase_complex; smooth_complex_number];% [smooth_mag_db, smooth_phase];
%     end


    
    
    AoA_0_mag_phase = [AoA_0_mag_phase, smooth_complex];
    
%     smooth_mag_2 = abs(smooth_complex);
%     smooth_mag_db_2 = mag2db(smooth_mag_2);
%     smooth_phase_2 = angle(smooth_complex);
    
    mag_all_freq = abs(mag_phase_complex_all);
    phase_all_freq = angle(mag_phase_complex_all);
    
%     mag_all_freq = abs(complex_new);
%     phase_all_freq = angle(complex_new);
%     size(mag_phase_complex)
%     AoA_0_mag_phase = [AoA_0_mag_phase, smooth_phase];
    
    if Plot_FRF == 1
%         if ismember(k, test_zz) == 1
%             figure(k-1)
%             subplot(2, 1, 1)
%             plot(freq, mag_db)
%             hold on
%             plot(freq, smooth_mag_db)
%             plot(freq, smooth_mag_db_2)
%             xlabel('$\omega$ [Hz]','Interpreter','latex')
%             ylabel('Magnitude [dB]','Interpreter','latex')
%             yline(0)
%             xlim([f_min,f_max])
%             hold off
%             legend('Mag', 'Smoothed mag', 'Smoothed mag with corrections','Interpreter','latex')
%             titlename = strrep(column_name_AoA_0(k), "_5", ".5");
%             titlename = strrep(titlename, "_", "m/s_");
%             title(titlename,'Interpreter','latex')
%             subplot(2, 1, 2)
%             plot(freq, phase)
%             hold on
%             plot(freq, smooth_phase)
%             plot(freq, smooth_phase_2)
%             xlabel('$\omega$ [Hz]','Interpreter','latex')
%             ylabel('$\phi$ [rad]','Interpreter','latex')
%             yline(0)
%             yline(pi)
% %             yline(2*pi)
% %             yline(3*pi)
%             yline(-pi)
% %             yline(-2*pi)
% %             yline(-3*pi)
%             xlim([f_min,f_max])
%             hold off
%             legend('phase', 'smoothed phase', 'smoothed phase with corrections','Interpreter','latex')
%             ylim([-1.1*pi, 1.1*pi])
%         current_fig_n = get(gcf,'Number');
%         if current_fig_n == 1 && test_fig == 0
%             n = current_fig_n;
%             test_fig=1;
%         else
%             n = current_fig_n + 1;
%         end
        if  ismember(k, test_zz) == 1 || ismember(k, test_xx) == 1 || ismember(k, test_zx) == 1 || ismember(k, test_xz) == 1 %|| ismember(k, test_zx) == 1 || ismember(k, test_xx) == 1
%             fh = figure(k-1);
            fh = figure;
%             fh = figure;
            fh.Units = 'inches';
            fh.Position(3:4) = [3.25,3.5];
%             fh.Units = 'Inches';
%             fh.Position = [1, 1, 3.25,3.5];
            t = tiledlayout(2, 1);
%             subplot(2, 1, 1)
            nexttile
            plot(freq_all, mag_all_freq, 'color', color_order(1,:))
            hold on
            plot(freq, smooth_mag_2, 'color', color_order(2,:))
            set(gca,'FontSize', font_size) 
%             xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size,'FontName', font) 
            set(gca,'XTickLabel',[]);
            ylabel('Magnitude','Interpreter','latex','FontSize', font_size,'FontName', font) 
            yline(1)
            ylim([0, ceil(max(mag_all_freq(idx_min:idx_max)))])
%             % grid on
%             % grid minor
            xlim([f_min,f_max])
            
            set(gca,'FontSize', font_size)
            set(gca,'FontName', font)
            
%             legend('Raw', 'Smooth','Interpreter','latex','FontSize', font_size, "Location", 'northeast','FontName', font);
            leg2 = legend('Raw', 'Smooth','Interpreter','latex','FontSize', font_size, "Location", 'northeast','FontName', font);
            leg2.ItemTokenSize = [x1,x2];
            leg2.FontSize = font_size;
            leg2.FontName = font;
%             titlename = strrep(column_name_AoA_0(k), "_5", ".5");
%             titlename = strrep(titlename, "_", " m/s ");
            %sgtitle(titlename,'Interpreter','latex','FontName', font)
            
%             subplot(2, 1, 2)
            nexttile(t)
            plot(freq_all, phase_all_freq, 'color', color_order(1,:))
            hold on
            plot(freq, smooth_phase_2, 'color', color_order(2,:))
%             set(gca,'FontSize', font_size) 
            xlabel('Frequency [Hz]','Interpreter','latex','FontSize', font_size,'FontName', font) 
            ylabel('Phase angle [rad]','Interpreter','latex','FontSize', font_size,'FontName', font) 
            set(gca,'FontSize', font_size)
            set(gca,'FontName', font)
%             % grid on
%             % grid minor
            yline(0)
            yline(pi)
%             yline(2*pi)
%             yline(3*pi)
            yline(-pi)
%             yline(-2*pi)
%             yline(-3*pi)
            xlim([f_min,f_max])
            set(gca,'FontSize', font_size)
            set(gca,'FontName', font)
            hold off
%             leg = legend('Raw', 'Smooth','Interpreter','latex','FontSize', font_size, "Location", 'northeast','FontName', font) ;
%             leg.ItemTokenSize = [x1,x2];
%             leg.FontSize = font_size;
%             leg.FontName = font;
            ylim([-1.1*pi, 1.1*pi])
            
            t.TileSpacing = 'none';
            t.Padding = 'none';
            
            if savefig == 1
%                 set(gcf,'Units','Inches');
%                 pos = get(gcf,'Position');
%                 set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])

                condition = strrep(column_name_AoA_0(k), "/", '_');
%                 saveas(gcf, SISO_figures_filename + condition + ".pdf", 'Resolution', 600);
                
                exportgraphics(gcf, SISO_figures_filename + condition + ".pdf", 'Resolution', 600)
%                 exportgraphics(gcf, SISO_figures_filename + condition + ".jpg")
                saveas(gcf, SISO_figures_filename + condition + ".jpg");
            end
             
            
        end
    end
    
    % Save data to find omega_PCO and G(omega_PCO) for SISO PFM
    if interp_SISO == 1
        G_omega_plus = [];
        G_omega_min = [];
        phase_plus = [];
        phase_min = [];
        omega_plus = [];
        omega_min = [];
        if ismember(k, test_zz) == 1
            
                % Find locations of phase cross-over
            % Do not allow for unwrapping of phase --> Check only for crossing of 0
            idx_pos = [];
            idx_neg = [];
            for kdx=2:length(smooth_phase_2)
                x_new = smooth_phase_2(kdx); 
                x_old = smooth_phase_2(kdx-1);

                if sign(x_new) == 1 && sign(x_old) == -1 
                    % Crossing 0 from positive to negative 
                    idx_pos = [idx_pos, kdx];
                    idx_neg = [idx_neg, kdx-1];
%                     x_new
%                     x_old
%                     freq(kdx)
                end
                if sign(x_new) == -1 && sign(x_old) == 1 
                    % Crossing 0 from negative to positive
                    idx_neg = [idx_neg, kdx];
                    idx_pos = [idx_pos, kdx-1];
%                     x_new
%                     x_old
%                     freq(kdx)
                end
            end
            G_omega_plus = smooth_mag_2(idx_pos);
            G_omega_min = smooth_mag_2(idx_neg);
            phase_plus = smooth_phase_2(idx_pos);
            phase_min = smooth_phase_2(idx_neg);
            omega_plus = freq(idx_pos);
            omega_min = freq(idx_neg);
            
            
%             if abs(phase_min - phase_plus) < 1.7*pi
%                 disp("Phase flip");
                % Use a struct to save all data for SISO PFM interpolation
            G_omega_plus_all.(Vel_val) = G_omega_plus;
            G_omega_min_all.(Vel_val) = G_omega_min;
            phase_plus_all.(Vel_val) = phase_plus;
            phase_min_all.(Vel_val) = phase_min;
            omega_plus_all.(Vel_val) = omega_plus;
            omega_min_all.(Vel_val) = omega_min;
        end    
    end
end
    
% end
% size(AoA_0_mag_phase)
% freq_new = reshape(freq, length(freq), 1);
% size(freq_new)
freq = reshape(freq, length(freq), 1); % make sure that freq_new is a column vector so that it can be added to the Full TF matrix list
AoA_0_mag_phase = [freq, AoA_0_mag_phase];


save(new_filename, 'AoA_0_mag_phase')



%% Linear interpolation on SISO PFM data
if interp_SISO == 1
    omega_PCO_lst = struct();
    G_PCO_lst = struct();
    SISO_PFM_data = struct();
    for interp_idx = 2:length(column_name_AoA_0)
        omega_PCO_lst_single_vel = [];
        G_PCO_lst_single_vel = [];
        if ismember(interp_idx, test_zz) == 1
            Vel_val = "V_" + column_name_AoA_0(interp_idx);
            Vel_val = strrep(Vel_val, "/", "");
            
            
            phase_min_test =phase_min_all.(Vel_val);
            if isempty(phase_min_test) == 1
                    omega_PCO = NaN;
% 
                    G_PCO = NaN;
                    
                    omega_PCO_lst_single_vel = [omega_PCO_lst_single_vel; omega_PCO];
                    G_PCO_lst_single_vel = [G_PCO_lst_single_vel; G_PCO];
            else
                for phase_idx = 1:length(phase_min_all.(Vel_val))
                    phase_min = phase_min_all.(Vel_val)(phase_idx);
                    phase_plus = phase_plus_all.(Vel_val)(phase_idx);

                    G_plus = G_omega_plus_all.(Vel_val)(phase_idx);
                    G_min = G_omega_min_all.(Vel_val)(phase_idx); 
                    omega_plus = omega_plus_all.(Vel_val)(phase_idx); 
                    omega_min = omega_min_all.(Vel_val)(phase_idx); 

%                     if isempty(phase_min) == 1
%                         omega_PCO = NaN;
%     % 
%                         G_PCO = NaN;
%                     else
                    if abs(phase_min - phase_plus) <  1.7*pi
                        omega_lst = [omega_plus, omega_min];
                        phase_lst = [phase_plus, phase_min];
                        G_lst = [G_plus, G_min];

                        omega_PCO = interp1(phase_lst, omega_lst, 0);

                        G_PCO = interp1(omega_lst, G_lst, omega_PCO);
                    else
                        omega_PCO = NaN;
                        G_PCO = NaN;
                        disp("Phase Flip")
                    end
%                 end
                
                omega_PCO_lst_single_vel = [omega_PCO_lst_single_vel; omega_PCO];
                G_PCO_lst_single_vel = [G_PCO_lst_single_vel; G_PCO];
               
                end
            end
%             
            
            omega_PCO_lst.(Vel_val) = omega_PCO_lst_single_vel;
            G_PCO_lst.(Vel_val) = G_PCO_lst_single_vel;
%             

            omega_G_lst = [G_PCO_lst_single_vel, omega_PCO_lst_single_vel];
            omega_G_table = array2table(omega_G_lst, 'VariableNames',{'Gain_PCO', 'Omega_PCO'});
            SISO_PFM_data.(Vel_val) = omega_G_table;
        end
        
    end
    
%% Plot SISO PFM Data
if interp_SISO == 1
    current_fig_n = get(gcf,'Number');
    if current_fig_n == 1
        n = current_fig_n;
    else
        n = current_fig_n + 1;
    end
    
    G_PCO_SISO = [];
    omega_PCO_SISO = [];
    for SISO_idx = 2:length(column_name_AoA_0)
        if ismember(SISO_idx, test_zz) == 1
            Vel_val = "V_" + column_name_AoA_0(SISO_idx);
            Vel_val = strrep(Vel_val, "/", "");
            
%             if Vel_val == "V_18_zz" || Vel_val == "V_18_5_zz"
%                 Gain_PCO_PFM_lst = NaN;
%                 omega_PCO_PFM_lst = NaN;
%             else
            Gain_PCO_PFM_lst = SISO_PFM_data.(Vel_val).('Gain_PCO');
            omega_PCO_PFM_lst = SISO_PFM_data.(Vel_val).('Omega_PCO');
%             end
            
            
            if isnan(Gain_PCO_PFM_lst(1)) == 1
                add_gain = Gain_PCO_PFM_lst(2);
                add_omega = omega_PCO_PFM_lst(2);
            else
                add_gain = Gain_PCO_PFM_lst(1); 
                add_omega = omega_PCO_PFM_lst(1);
            end
            
            G_PCO_SISO = [G_PCO_SISO, add_gain];
            omega_PCO_SISO = [omega_PCO_SISO, add_omega];
        end
    end
    figure(n)
    plot(Velocity_AoA_0, G_PCO_SISO)
    set(gca,'FontSize', font_size) 
    xlabel('V [m/s]','Interpreter','latex', 'FontSize', 10)
    ylabel('$G(\omega_{PCO})$','Interpreter','latex', 'FontSize', 10)
    xlim([min(Velocity_AoA_0), max(Velocity_AoA_0)]);
    % grid()
    
    if savefig == 1
        set(gcf,'Units','Inches');
        pos = get(gcf,'Position');
        set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);
        
%         evolution_filename = "Figures/SISO/Allow_PCO_at_plus_PI/SISO_PFM_G_PCO_AoA_" + AoA;
        evolution_filename = "Figures/SISO/SISO_PFM_G_PCO_AoA_" + AoA;
%         saveas(gcf, evolution_filename + ".pdf", 'Resolution', 600);
%         saveas(gcf, evolution_filename + ".jpeg");
        
        exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution', 600)
        exportgraphics(gcf, evolution_filename + ".jpg")
    end
    
    figure(n+1)
    plot(Velocity_AoA_0, omega_PCO_SISO)
    set(gca,'FontSize', font_size)
    xlabel('V [m/s]','Interpreter','latex', 'FontSize', 10)
    ylabel('$\omega_{PCO}$ [Hz]','Interpreter','latex', 'FontSize', 10)
    xlim([min(Velocity_AoA_0), max(Velocity_AoA_0)]);
    % grid()
    
    if savefig == 1
        set(gcf,'Units','Inches');
        pos = get(gcf,'Position');
        set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);
        
%         evolution_filename = "Figures/SISO/Allow_PCO_at_plus_PI/SISO_PFM_omega_PCO_AoA_" + AoA;
        evolution_filename = "Figures/SISO/SISO_PFM_omega_PCO_AoA_" + AoA;
%         saveas(gcf, evolution_filename + ".pdf", 'Resolution', 600);
%         saveas(gcf, evolution_filename + ".jpeg");
        exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution', 600)
        exportgraphics(gcf, evolution_filename + ".jpeg")
        
    end
end 
        
%         omega_lst = [omega_plus(interp_idx), omega_min(interp_idx)];
%         phase_lst = [phase_plus(interp_idx), phase_min(interp_idx)];
% 
%         G_lst = [G_omega_plus(interp_idx), G_omega_min(interp_idx)];
% 
%         if isnan(G_omega_plus(interp_idx)) == 1
%             omega_PCO = "#N/A";
% 
%             G_PCO = "#N/A";
%         else
%             omega_PCO = interp1(phase_lst, omega_lst, 0);
%             
%             if isnan(omega_PCO) == 1
%                 % Allow for phase unwrapping
%                 omega_PCO = interp1(phase_lst, omega_lst, pi);
%             end
%             
%             G_PCO = interp1(omega_lst, G_lst, omega_PCO);
%             
%            
%         end
%         omega_PCO_lst = [omega_PCO_lst; omega_PCO];
%         G_PCO_lst = [G_PCO_lst; G_PCO];
% 
%     end
end
% omega_PCO_lst
