close all
clc

%% Start new plotting
font = 'times';

Vel_lst = repelem(Velocity_AoA_0, 2);
test_test = 0;



% V_eigvec_lst_2_all


for V_idx =1:2:min(size(V_eigvec_lst_2_all))
    Vel_val = Vel_lst(V_idx);
    current_fig_n = get(gcf,'Number');
    if current_fig_n == 1 && test_test == 0
        n = current_fig_n;
        test_test = 1;
    else
        n = current_fig_n + 1;
    end

    smooth_complex_comp_x = smooth_eigvec_lst_2_all(V_idx, :);
    smooth_real_comp_z = smooth_eigvec_lst_2_all(V_idx+1, :);
    
    complex_comp_x = V_eigvec_lst_2_all(V_idx, :);
    real_comp_z = V_eigvec_lst_2_all(V_idx+1, :);
       
    
    figure(n)
    set(gca,'fontsize', font_size)
    subplot(2, 1, 1)
    plot(freq, abs(real_comp_z), 'Displayname', "z-contribution")
    hold on
    plot(freq, abs(smooth_real_comp_z), 'Displayname', "Smooth z-contribution")
    
    plot(freq, abs(complex_comp_x), 'Displayname', "x-contribution")
    plot(freq, abs(smooth_complex_comp_x), 'Displayname', "Smooth x-contribution")
    
    ylim([0,1.05])
    xlim([f_min, f_max])
    xlabel('$\omega$ [Hz]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
    ylabel('Magnitude','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
    
%     yticklabels(linspace(0, 1, 11));
    
    legend('Interpreter','latex', 'FontSize', font_size_legend, 'Location', 'best', 'FontName', font)
    grid on
    grid minor
    set(gca,'fontname',font)
    
    title("Complex Eigenvector AoA " + AoA + ", " + string(Vel_val) + " m/s", 'FontName', font)
    
    
    
    subplot(2, 1, 2)
    delta_smooth = angle(smooth_complex_comp_x) - angle(smooth_real_comp_z);
    delta = angle(complex_comp_x) - angle(real_comp_z);
    
    plot(freq, delta, 'Displayname', 'Angle between x and z component')
    hold on
    plot(freq, delta_smooth, 'Displayname', 'Smooth Angle between x and z component')
    xlim([f_min, f_max])
    
    xlabel('$\omega$ [Hz]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
    ylabel('$\phi$ [rad]','Interpreter','latex', 'FontSize', font_size, 'FontName', font) 
    
%     yticklabels({'-\pi', '-0.75\pi','-0.5\pi','-0.25\pi', '0', '0.25\pi', '0.5\pi', '0.75\pi', '\pi'});
    grid on
    grid minor
    
    legend('Interpreter','latex', 'FontSize', font_size_legend, 'Location', 'best', 'FontName', font)
    yline(0,'HandleVisibility','off')
    yline(pi,'HandleVisibility','off')
    yline(-pi,'HandleVisibility','off')
    set(gca,'fontname',font)
    
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);


    evolution_filename = "Figures/Eigenvectors/Smoothing_Comparison/Smoothing_Comparison_Eigenvector_contribution_AoA_" + AoA + "_" + string(Vel_val) + "_ms";
%         saveas(gcf, evolution_filename + ".pdf");
%         saveas(gcf, evolution_filename + ".jpg");
    exportgraphics(gcf, evolution_filename + ".pdf")
%         exportgraphics(gcf, evolution_filename + ".jpg")
    saveas(gcf, evolution_filename + ".jpg");
    
end



% for V_idx =1:2:min(size(smooth_eigvec_lst_2_all))
%     Vel_val = Vel_lst(V_idx);
% %     current_fig_n = get(gcf,'Number');
% %     if current_fig_n == 1 && test_test == 0
% %         n = current_fig_n;
% %         test_test = 1;
% %     else
% %         n = current_fig_n + 1;
% %     end
% 
%     complex_comp_x = smooth_eigvec_lst_2_all(V_idx, :);
%     real_comp_z = smooth_eigvec_lst_2_all(V_idx+1, :);
%        
%     
% %     figure(n)
%     set(gca,'fontsize', font_size)
%     subplot(2, 1, 1)
%     plot(freq, abs(real_comp_z), 'Displayname', "z-contribution")
%     hold on
%     plot(freq, abs(complex_comp_x), 'Displayname', "x-contribution")
%     ylim([0,1.05])
%     xlim([f_min, f_max])
%     xlabel('$\omega$ [Hz]','Interpreter','latex', 'FontSize', font_size)
%     ylabel('Magnitude','Interpreter','latex', 'FontSize', font_size)
%     
% %     yticklabels(linspace(0, 1, 11));
%     
%     legend('Interpreter','latex', 'FontSize', font_size_legend, 'Location', 'best')
%     grid on
%     grid minor
%     
%     title("Complex Eigenvector AoA " + AoA + ", " + string(Vel_val) + " m/s")
%     
%     
%     
%     subplot(2, 1, 2)
%     delta = angle(complex_comp_x) - angle(real_comp_z);
%     plot(freq, delta, 'Displayname', 'Angle between x and z component')
%     xlim([f_min, f_max])
%     
%     xlabel('$\omega$ [Hz]','Interpreter','latex', 'FontSize', font_size)
%     ylabel('$\phi$ [rad]','Interpreter','latex', 'FontSize', font_size) 
%     
% %     yticklabels({'-\pi', '-0.75\pi','-0.5\pi','-0.25\pi', '0', '0.25\pi', '0.5\pi', '0.75\pi', '\pi'});
%     grid on
%     grid minor
%     
%     legend('Interpreter','latex', 'FontSize', font_size_legend, 'Location', 'best')
%     yline(0,'HandleVisibility','off')
%     yline(pi,'HandleVisibility','off')
%     yline(-pi,'HandleVisibility','off')
%     
% %     if savefig == 1
% %         set(gcf,'Units','Inches');
% %         pos = get(gcf,'Position');
% %         set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);
% % 
% %     
% %         evolution_filename = "Figures/Eigenvectors/Eigenvector_contribution_AoA_" + AoA + "_" + string(Vel_val) + "_ms";
% % %         saveas(gcf, evolution_filename + ".pdf");
% % %         saveas(gcf, evolution_filename + ".jpg");
% %         exportgraphics(gcf, evolution_filename + ".pdf")
% % %         exportgraphics(gcf, evolution_filename + ".jpg")
% %         saveas(gcf, evolution_filename + ".jpg");
% %     end
% 
% end