***Impact Aware Robotics Archive***
===================================

***General Info***

Authors:
- M.J. Jongeneel
- S. Dingemans
- A. Oliva

Title: Archive_016_BOXScenario
Files:
- 221130_Archive_016_BOXScenario.h5
- README.md

Dynamics & Control Group, Faculty of Mechanical Engineering, Eindhoven University of Technology

Corresponding author: M.J. Jongeneel 

Contact Information: m.j.jongeneel@tue.nl

Eindhoven University of Technology - Faculty of Mechanical Engineering

P.O. Box 513 5600 MB Eindhoven The Netherlands

***General Introduction***
I.AM. archive as part of the Impact-Aware Robotics Archives Collection. This archive contains recordings of experiments where Box006, Box009, and Box010 are placed inside a tote while exploiting impacts between the object being manipulated and other objects and the environment. The purpose of these experiments is to validate the simulation software on a scenario relevant for the BOX scenario of the I.AM. project. The involved contact is between the robot, object, and the environment, which in these recordings are Box006, Box009, and Box010 and a tote (Tote001), respectively. All the recordings in the archive were performed at the Innovation Lab of Vanderlande, located within the TU/e campus. More information about the dataset, the objects, and the environments used, can be found on https://impact-aware-robotics-database.tue.nl/.      

This archive is published accompanying the deliverable ``I.AM. - D1.1 - Publication of I.AM. dataset - v1.0``, see [https://i-am-project.eu/index.php/results/deliverables](https://i-am-project.eu/index.php/results/deliverables) for more info.
This research project has received funding from the European Union’s Horizon 2020 research and innovation program under grant agreement No. 871899.

***Test equipment***

The experiments involve placing of different carton boxes (Box006, Box009, and Box010) into a plastic tote (Tote001) where we exploit impacts between the objects and the tote to increase the stacking density of the tote. This means that the box that is being manipulated is pushed against other boxes to replace them and put them tight together. The box is placed by the UR10. Data was logged using an OptiTrack motion capture system, an Intel Realsense D415 reference camera, and sensors from the UR10 robot such as joint encoders. Further details of the equipment are provided as metadata in each recording subfolder of the archive. 

***Description of the data in this archive***

This archive contains a total of 20 subfolders, each corresponding to a specific recording. Each folder follows the naming convention ``Rec_<timestamp>``, where the timestamp corresponds to the start time of the recording, expressed according to ISO 8601. The contents of these subfolders all have the same structure, which is described in the file called "recording_format".