%% Data processing file
% Clear matlab
clear all
close all
clc

%% Part 1: Initialization
% Load raw data file
load('Test_Mat.mat')

% Clean samples that filters seem not to clean
% Plate C, alpha=5, Bending freq, 100% release
Results(3).Dynamic(2).results(4).results(5).SR(3)=[];
Results(3).Dynamic(2).results(4).results(5).results(:,:,3)=[];

%Folders where files are saved, one per Plate + Number of variations for
%variable
Fold = {'Plate A','Plate B','Plate C','Plate B Right','Plate B Left'};
NFold = 5;
An = 2;
Freq = 5;
Rel = 6;
%               Accel_f  Accel_r   Pot_Vo  Pot_sens
Calibration = [    98.6,    99.5,   2.600,  0.0208;
                  100.8,   100.7,   2.443,  0.0208;
                   99.3,    99.5,   2.511,  0.0208;
                   98.0,    99.6,   2.600,  0.0208;
                  101.0,    99.5,   2.600,  0.0208;];
              
% Compute Pot_Vo from locked polar (voltage at fold angle =0deg)
Pot_Vo = zeros(NFold,1);
for i=1:1:NFold
    Pot_Vo(i) = mean(Results(i).Polar.locked(1,2,:));
end
% Introduce Pot_Vo new values into calibration constants
Calibration(:,3) = Pot_Vo;

% Data for moment coefficient computation
A_factor = (40*40)/(35*40);     % Correction factor accounting for WT contraction (A_outlet/A_gust generator)
rho = 1.225;                    % Air density [kg/m3]
U = 10*A_factor;                % Airspeed [m/s]
q = 0.5*rho*U*U;                % Dynamic pressure [Pa]
B = 700;                        % Semispan [mm]
%Notice moment is computed in N-mm!!
surf = 0.1*0.7;                 % Wing surface: Chord[m] x Semispan[m] [m2]

%Factor to convert Moment [N-mm] to Moment coefficient
Cm_factor = q*B*surf;
Cm_res = zeros(NFold,An,Freq,Rel,5);

%% Part 2: Processing
% Save summary of files
count=1;
for i=1:1:NFold
    % Processiing polars
        % Processing free polar
    n = size(Results(i).Polar.free,3);
    Polar = zeros(2,3,n);
    Polar(:,1,:) = Results(i).Polar.free(:,1,:);
    Polar(:,2,:) = (Results(i).Polar.free(:,2,:)-Calibration(i,3))/Calibration(i,4);
    Polar(2,2,:) = Results(i).Polar.free(2,3,:);
    Polar(:,3,:) = (Results(i).Polar.free(:,11,:)/Cm_factor);
    Results(i).Polar.free_proc = Polar;
    
        % Processing locked polars
    n = size(Results(i).Polar.locked,3);
    Polar = zeros(2,3,n);
    Polar(:,1,:) = Results(i).Polar.locked(:,1,:);
    Polar(:,2,:) = (Results(i).Polar.locked(:,2,:)-Calibration(i,3))/Calibration(i,4);
    Polar(2,2,:) = Results(i).Polar.locked(2,3,:);
    Polar(:,3,:) = (Results(i).Polar.locked(:,11,:)/Cm_factor);
    Results(i).Polar.locked_proc = Polar;
    
    clearvars Polar n
    
    for j=1:1:An
        for k=1:1:Freq
            for z=1:1:Rel
                n = size(Results(i).Dynamic(j).results(k).results(z).results,1);
                Results_proc = zeros(n,7);
                
                % Create Column headers for processed data
                Headers = Results(i).Dynamic(j).results(k).results(z).headers;
                remove=[2,4,6,8,9,10];
                Headers(remove)=[];
                Headers(3)={'Front Accel. [g]'};
                Headers(4)={'Rear Accel. [g]'};
                Headers(5)={'C_m [-]'};
                Headers(6)={'Servo pos [-]'};
                Headers(7)={'Trigger [-]'};
                Results(i).Dynamic(j).results(k).results(z).proc_headers=Headers;
                
                % Average Results
                Results_proc(:,1) = mean(Results(i).Dynamic(j).results(k).results(z).results(:,1,:),3);
                Results_proc(:,2) = mean((Results(i).Dynamic(j).results(k).results(z).results(:,2,:)-Calibration(i,3))/Calibration(i,4),3);
                Results_proc(:,3) = mean((Results(i).Dynamic(j).results(k).results(z).results(:,5,:)*1000/Calibration(i,1)),3);
                Results_proc(:,4) = mean((Results(i).Dynamic(j).results(k).results(z).results(:,7,:)*1000/Calibration(i,2)),3);
                Results_proc(:,5) = mean((Results(i).Dynamic(j).results(k).results(z).results(:,11,:))/Cm_factor,3);
                Results_proc(:,6) = mean((Results(i).Dynamic(j).results(k).results(z).results(:,12,:)),3);
                Results_proc(:,7) = mean((Results(i).Dynamic(j).results(k).results(z).results(:,13,:)),3);
                Results(i).Dynamic(j).results(k).results(z).average=Results_proc;
                
                % Standard deviation
                Results_proc(:,1) = std(Results(i).Dynamic(j).results(k).results(z).results(:,1,:),0,3);
                Results_proc(:,2) = std((Results(i).Dynamic(j).results(k).results(z).results(:,2,:)-Calibration(i,3))/Calibration(i,4),0,3);
                Results_proc(:,3) = std((Results(i).Dynamic(j).results(k).results(z).results(:,5,:)*1000/Calibration(i,1)),0,3);
                Results_proc(:,4) = std((Results(i).Dynamic(j).results(k).results(z).results(:,7,:)*1000/Calibration(i,2)),0,3);
                Results_proc(:,5) = std((Results(i).Dynamic(j).results(k).results(z).results(:,11,:))/Cm_factor,0,3);
                Results_proc(:,6) = std((Results(i).Dynamic(j).results(k).results(z).results(:,12,:)),0,3);
                Results_proc(:,7) = std((Results(i).Dynamic(j).results(k).results(z).results(:,13,:)),0,3);
                Results(i).Dynamic(j).results(k).results(z).std=Results_proc;
                
                
                %Save interesting moment data
                    %Average of first 10 samples
                Cm_res(i,j,k,z,1)= mean(Results(i).Dynamic(j).results(k).results(z).average(1:10,5));
                    %Average of last 10 samples
                Cm_res(i,j,k,z,2)= mean(Results(i).Dynamic(j).results(k).results(z).average(end-500:end,5));
                    %Max value
                Cm_res(i,j,k,z,3)= max(Results(i).Dynamic(j).results(k).results(z).average(:,5));
                    %Min value
                Cm_res(i,j,k,z,4)= min(Results(i).Dynamic(j).results(k).results(z).average(:,5));              

                X = Results(i).Dynamic(j).results(k).results(z).average(:,5);
                X(:) = 0;

                %Find when the servo is locked and when unlocked
                finder_L = find(Results(i).Dynamic(j).results(k).results(z).average(:,6)>.5);   %Locked
                finder_F = find(Results(i).Dynamic(j).results(k).results(z).average(:,6)<=.5);   %Free
                refB0 = Cm_res(i,j,k,z,1);      %Average of first samples
                refB1 = Cm_res(i,j,k,z,2);      %Average of last samples

                %Subtract initial load when servo is locked
                X(finder_L) = Results(i).Dynamic(j).results(k).results(z).average(finder_L,5)-refB0;

                %Subtract final load when servo is free
                X(finder_F) = Results(i).Dynamic(j).results(k).results(z).average(finder_F,5)-refB1;
                Cm_res(i,j,k,z,5)= rms(X);      %Compute RMS
                
                %Release signal
                Release = [0,0];
                Release(1) = finder_F(1);
                Release(2) = Results(i).Dynamic(j).results(k).results(z).average(finder_F(1),1);
                Results(i).Dynamic(j).results(k).results(z).release = Release;
                
                %Sampling rate average
                SR_av = mean(Results(i).Dynamic(j).results(k).results(z).SR);
                Results(i).Dynamic(j).results(k).results(z).SR_mean = SR_av;

            end
        end
    end
end

% Save into .mat file
save('Processed_Mat.mat','Results','Cm_res');
