%% Analyse wave attenuation data of all foreshores in the Westerschelde based on Vaklodingen and SWAN analysis
clear all; clc;

%% Load and summarize data
addpath('M:\Documents\PhD\Scripts\MATLAB\Chapter1');

%---Zuidgors--- #Transects=11 (9 effective) --- #Years=37 ---
ZUI.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Zuidgors_S250\Zuidgors_S250.mat')
ZUI.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Zuidgors_S250\Zuidgors_S250.mat');
ZUI.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Zuidgors_S250\Zuidgors_S250.mat');
ZUI.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Zuidgors_S250.mat');

for i = 1:9
    ZUI.result_length(i) = length(ZUI.ScN.result(i).year(1).Hsig)*5;
    for j = 1:37
        ZUI.ScN.result_matr_Hsig(j,i) = min(ZUI.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1)
            ZUI.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1);
        else
            ZUI.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1))
            ZUI.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1));
        else
            ZUI.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1)
            ZUI.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1);
        else
            ZUI.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(end);
        end
        
        ZUI.ScD.result_matr_Hsig(j,i) = min(ZUI.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1)
            ZUI.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1);
        else
            ZUI.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1))
            ZUI.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1));
        else
            ZUI.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1)
            ZUI.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1);
        else
            ZUI.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(end);
        end
        
        ZUI.ScDV.result_matr_Hsig(j,i) = min(ZUI.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1)
            ZUI.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1);
        else
            ZUI.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1))
            ZUI.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1));
        else
            ZUI.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1)
            ZUI.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1);
        else
            ZUI.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(end);
        end
        
        ZUI.result_veglength(j,i) = nansum(ZUI.input.Zuidgors_S250.Veg{i}(j,:))*5;
        ZUI.result_relveglength(j,i) = (ZUI.result_veglength(j,i)/ZUI.result_length(i)).*100;
        ZUI.result_barelength(j,i) =...
            length(find(ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS &...
            ZUI.ScN.result(i).year(j).Botlev>-ZUI.input.Zuidgors_S250.veg_edge))*5;
    end
end

ZUI.result_trans_relveglength = min(ZUI.result_relveglength);
ZUI.result_mm_trans_relveglength =...
    [min(ZUI.result_trans_relveglength),max(ZUI.result_trans_relveglength)];
ZUI.result_mean_trans_relveglength =...
    mean(ZUI.result_trans_relveglength);

ZUI.ScN.result_matr_Hsig(ZUI.ScN.result_matr_Hsig<0) = 0;
ZUI.ScN.result_matr_Hsig_MHWS(ZUI.ScN.result_matr_Hsig_MHWS<0) = 0;
ZUI.ScN.result_matr_WA = (1-ZUI.ScN.result_matr_Hsig./1.6550).*100;
ZUI.ScN.result_matr_WA_MHWS =...
    (ZUI.ScN.result_matr_Hsig_MLWS./1.6550-ZUI.ScN.result_matr_Hsig_MHWS./1.6550).*100;
ZUI.ScN.result_matr_WA_bar =...
    (ZUI.ScN.result_matr_Hsig_MLWS./1.6550-ZUI.ScN.result_matr_Hsig_vegedge./1.6550).*100;
ZUI.ScN.result_matr_WA_veg =...
    (ZUI.ScN.result_matr_Hsig_vegedge./1.6550-ZUI.ScN.result_matr_Hsig_MHWS./1.6550).*100;
ZUI.ScN.result_trans_WA = min(ZUI.ScN.result_matr_WA_MHWS);
ZUI.ScN.result_mm_WA = [min(ZUI.ScN.result_trans_WA),max(ZUI.ScN.result_trans_WA)];
ZUI.ScN.result_mean_WA = mean(ZUI.ScN.result_trans_WA);

ZUI.ScD.result_matr_Hsig(ZUI.ScD.result_matr_Hsig<0) = 0;
ZUI.ScD.result_matr_Hsig_MHWS(ZUI.ScD.result_matr_Hsig_MHWS<0) = 0;
ZUI.ScD.result_matr_WA = (1-ZUI.ScD.result_matr_Hsig./0.2).*100;
ZUI.ScD.result_matr_WA_MHWS =...
    (ZUI.ScD.result_matr_Hsig_MLWS./0.2-ZUI.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScD.result_matr_WA_bar =...
    (ZUI.ScD.result_matr_Hsig_MLWS./0.2-ZUI.ScD.result_matr_Hsig_vegedge./0.2).*100;
ZUI.ScD.result_matr_WA_veg =...
    (ZUI.ScD.result_matr_Hsig_vegedge./0.2-ZUI.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScD.result_trans_WA = nanmin(ZUI.ScD.result_matr_WA_MHWS);
ZUI.ScD.result_mm_WA = [min(ZUI.ScD.result_trans_WA),max(ZUI.ScD.result_trans_WA)];
ZUI.ScD.result_mean_WA = nanmean(ZUI.ScD.result_trans_WA);

ZUI.ScDV.result_matr_Hsig(ZUI.ScDV.result_matr_Hsig<0) = 0;
ZUI.ScDV.result_matr_Hsig_MHWS(ZUI.ScDV.result_matr_Hsig_MHWS<0) = 0;
ZUI.ScDV.result_matr_WA = (1-ZUI.ScDV.result_matr_Hsig./0.2).*100;
ZUI.ScDV.result_matr_WA_MHWS =...
    (ZUI.ScDV.result_matr_Hsig_MLWS./0.2-ZUI.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScDV.result_matr_WA_bar =...
    (ZUI.ScDV.result_matr_Hsig_MLWS./0.2-ZUI.ScDV.result_matr_Hsig_vegedge./0.2).*100;
ZUI.ScDV.result_matr_WA_veg =...
    (ZUI.ScDV.result_matr_Hsig_vegedge./0.2-ZUI.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScDV.result_trans_WA = nanmin(ZUI.ScDV.result_matr_WA_MHWS);
ZUI.ScDV.result_mm_WA = [min(ZUI.ScDV.result_trans_WA),max(ZUI.ScDV.result_trans_WA)];
ZUI.ScDV.result_mean_WA = nanmean(ZUI.ScDV.result_trans_WA);

%---Baarland--- #Transects=7 (3 effective) --- #Years=37 ---
BAA.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Baarland_S250\Baarland_S250.mat')
BAA.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Baarland_S250\Baarland_S250.mat');
BAA.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Baarland_S250\Baarland_S250.mat');
BAA.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Baarland_S250.mat');

for i = 1:3
    BAA.result_length(i) = length(BAA.ScN.result(i).year(1).Hsig)*5;
    for j = 1:37
        BAA.ScN.result_matr_Hsig(j,i) = min(BAA.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1)
            BAA.ScN.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1);
        else
            BAA.ScN.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1))
            BAA.ScN.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1));
        else
            BAA.ScN.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1)
            BAA.ScN.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1);
        else
            BAA.ScN.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(end);
        end
        
        BAA.ScD.result_matr_Hsig(j,i) = min(BAA.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1)
            BAA.ScD.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1);
        else
            BAA.ScD.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1))
            BAA.ScD.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1));
        else
            BAA.ScD.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1)
            BAA.ScD.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1);
        else
            BAA.ScD.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(end);
        end
        
        BAA.ScDV.result_matr_Hsig(j,i) = min(BAA.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1)
            BAA.ScDV.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1);
        else
            BAA.ScDV.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1))
            BAA.ScDV.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1));
        else
            BAA.ScDV.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1)
            BAA.ScDV.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1);
        else
            BAA.ScDV.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(end);
        end
        BAA.result_veglength(j,i) = nansum(BAA.input.Baarland_S250.Veg{i}(j,:))*5;
        BAA.result_relveglength(j,i) = (BAA.result_veglength(j,i)/BAA.result_length(i)).*100;
        BAA.result_barelength(j,i) =...
            length(find(BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS &...
            BAA.ScN.result(i).year(j).Botlev>-BAA.input.Baarland_S250.veg_edge))*5;
    end
end

BAA.result_trans_relveglength = min(BAA.result_relveglength);
BAA.result_mm_trans_relveglength =...
    [min(BAA.result_trans_relveglength),max(BAA.result_trans_relveglength)];
BAA.result_mean_trans_relveglength =...
    mean(BAA.result_trans_relveglength);

BAA.ScN.result_matr_Hsig(BAA.ScN.result_matr_Hsig<0) = NaN;
BAA.ScN.result_matr_Hsig_MHWS(BAA.ScN.result_matr_Hsig_MHWS<0) = NaN;
BAA.ScN.result_matr_WA = (1-BAA.ScN.result_matr_Hsig./1.7200).*100;
BAA.ScN.result_matr_WA_MHWS =...
    (BAA.ScN.result_matr_Hsig_MLWS./1.7200-BAA.ScN.result_matr_Hsig_MHWS./1.7200).*100;
BAA.ScN.result_matr_WA_bar =...
    (BAA.ScN.result_matr_Hsig_MLWS./1.7200-BAA.ScN.result_matr_Hsig_vegedge./1.7200).*100;
BAA.ScN.result_matr_WA_veg =...
    (BAA.ScN.result_matr_Hsig_vegedge./1.7200-BAA.ScN.result_matr_Hsig_MHWS./1.7200).*100;
BAA.ScN.result_trans_WA = min(BAA.ScN.result_matr_WA_MHWS);
BAA.ScN.result_mm_WA = [min(BAA.ScN.result_trans_WA(1:3)),max(BAA.ScN.result_trans_WA(1:3))];
BAA.ScN.result_mean_WA = mean(BAA.ScN.result_trans_WA);

BAA.ScD.result_matr_Hsig(BAA.ScD.result_matr_Hsig<0) = NaN;
BAA.ScD.result_matr_Hsig_MHWS(BAA.ScD.result_matr_Hsig_MHWS<0) = NaN;
BAA.ScD.result_matr_WA = (1-BAA.ScD.result_matr_Hsig./0.2).*100;
BAA.ScD.result_matr_WA_MHWS =...
    (BAA.ScD.result_matr_Hsig_MLWS./0.2-BAA.ScD.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScD.result_matr_WA_bar =...
    (BAA.ScD.result_matr_Hsig_MLWS./0.2-BAA.ScD.result_matr_Hsig_vegedge./0.2).*100;
BAA.ScD.result_matr_WA_veg =...
    (BAA.ScD.result_matr_Hsig_vegedge./0.2-BAA.ScD.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScD.result_trans_WA = min(BAA.ScD.result_matr_WA_MHWS);
BAA.ScD.result_mm_WA = [min(BAA.ScD.result_trans_WA(1:3)),max(BAA.ScD.result_trans_WA(1:3))];
BAA.ScD.result_mean_WA = mean(BAA.ScD.result_trans_WA);

BAA.ScDV.result_matr_Hsig(BAA.ScDV.result_matr_Hsig<0) = NaN;
BAA.ScDV.result_matr_Hsig_MHWS(BAA.ScDV.result_matr_Hsig_MHWS<0) = NaN;
BAA.ScDV.result_matr_WA = (1-BAA.ScDV.result_matr_Hsig./0.2).*100;
BAA.ScDV.result_matr_WA_MHWS =...
    (BAA.ScDV.result_matr_Hsig_MLWS./0.2-BAA.ScDV.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScDV.result_matr_WA_bar =...
    (BAA.ScDV.result_matr_Hsig_MLWS./0.2-BAA.ScDV.result_matr_Hsig_vegedge./0.2).*100;
BAA.ScDV.result_matr_WA_veg =...
    (BAA.ScDV.result_matr_Hsig_vegedge./0.2-BAA.ScDV.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScDV.result_trans_WA = min(BAA.ScDV.result_matr_WA_MHWS);
BAA.ScDV.result_mm_WA = [min(BAA.ScDV.result_trans_WA(1:3)),max(BAA.ScDV.result_trans_WA(1:3))];
BAA.ScDV.result_mean_WA = mean(BAA.ScDV.result_trans_WA);

%---Zimmermanpolder--- #Transects=6 (5 effective) --- #Years=51 ---
ZIM.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Zimmermanpolder_S250\Zimmermanpolder_S250.mat')
ZIM.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Zimmermanpolder_S250\Zimmermanpolder_S250.mat');
ZIM.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Zimmermanpolder_S250\Zimmermanpolder_S250.mat');
ZIM.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Zimmermanpolder_S250.mat');

for i = 1:5
    ZIM.result_length(i) = length(ZIM.ScN.result(i).year(1).Hsig)*5;
    for j = 1:51
        ZIM.ScN.result_matr_Hsig(j,i) = min(ZIM.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1)
            ZIM.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1);
        else
            ZIM.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1))
            ZIM.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1));
        else
            ZIM.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1)
            ZIM.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1);
        else
            ZIM.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(end);
        end
        
        ZIM.ScD.result_matr_Hsig(j,i) = min(ZIM.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1)
            ZIM.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1);
        else
            ZIM.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1))
            ZIM.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1));
        else
            ZIM.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1)
            ZIM.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1);
        else
            ZIM.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(end);
        end
        
        ZIM.ScDV.result_matr_Hsig(j,i) = min(ZIM.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1)
            ZIM.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1);
        else
            ZIM.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1))
            ZIM.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1));
        else
            ZIM.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1)
            ZIM.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1);
        else
            ZIM.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(end);
        end
        ZIM.result_veglength(j,i) = nansum(ZIM.input.Zimmermanpolder_S250.Veg{i}(j,:))*5;
        ZIM.result_relveglength(j,i) = (ZIM.result_veglength(j,i)/ZIM.result_length(i)).*100;
        ZIM.result_barelength(j,i) =...
            length(find(ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS &...
            ZIM.ScN.result(i).year(j).Botlev>-ZIM.input.Zimmermanpolder_S250.veg_edge))*5;
    end
end

ZIM.result_trans_relveglength = min(ZIM.result_relveglength);
ZIM.result_mm_trans_relveglength =...
    [min(ZIM.result_trans_relveglength),max(ZIM.result_trans_relveglength)];
ZIM.result_mean_trans_relveglength =...
    mean(ZIM.result_trans_relveglength);

ZIM.ScN.result_matr_Hsig(ZIM.ScN.result_matr_Hsig<0) = NaN;
ZIM.ScN.result_matr_Hsig_MHWS(ZIM.ScN.result_matr_Hsig_MHWS<0) = NaN;
ZIM.ScN.result_matr_WA = (1-ZIM.ScN.result_matr_Hsig./1.8150).*100;
ZIM.ScN.result_matr_WA_MHWS =...
    (ZIM.ScN.result_matr_Hsig_MLWS./1.8150-ZIM.ScN.result_matr_Hsig_MHWS./1.8150).*100;
ZIM.ScN.result_matr_WA_bar =...
    (ZIM.ScN.result_matr_Hsig_MLWS./1.8150-ZIM.ScN.result_matr_Hsig_vegedge./1.8150).*100;
ZIM.ScN.result_matr_WA_veg =...
    (ZIM.ScN.result_matr_Hsig_vegedge./1.8150-ZIM.ScN.result_matr_Hsig_MHWS./1.8150).*100;
ZIM.ScN.result_trans_WA = min(ZIM.ScN.result_matr_WA_MHWS);
ZIM.ScN.result_mm_WA = [min(ZIM.ScN.result_trans_WA(1:5)),max(ZIM.ScN.result_trans_WA(1:5))];
ZIM.ScN.result_mean_WA = mean(ZIM.ScN.result_trans_WA);

ZIM.ScD.result_matr_Hsig(ZIM.ScD.result_matr_Hsig<0) = NaN;
ZIM.ScD.result_matr_Hsig_MHWS(ZIM.ScD.result_matr_Hsig_MHWS<0) = NaN;
ZIM.ScD.result_matr_WA = (1-ZIM.ScD.result_matr_Hsig./0.2).*100;
ZIM.ScD.result_matr_WA_MHWS =...
    (ZIM.ScD.result_matr_Hsig_MLWS./0.2-ZIM.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScD.result_matr_WA_bar =...
    (ZIM.ScD.result_matr_Hsig_MLWS./0.2-ZIM.ScD.result_matr_Hsig_vegedge./0.2).*100;
ZIM.ScD.result_matr_WA_veg =...
    (ZIM.ScD.result_matr_Hsig_vegedge./0.2-ZIM.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScD.result_trans_WA = min(ZIM.ScD.result_matr_WA_MHWS);
ZIM.ScD.result_mm_WA = [min(ZIM.ScD.result_trans_WA(1:5)),max(ZIM.ScD.result_trans_WA(1:5))];
ZIM.ScD.result_mean_WA = mean(ZIM.ScD.result_trans_WA);

ZIM.ScDV.result_matr_Hsig(ZIM.ScDV.result_matr_Hsig<0) = NaN;
ZIM.ScDV.result_matr_Hsig_MHWS(ZIM.ScDV.result_matr_Hsig_MHWS<0) = NaN;
ZIM.ScDV.result_matr_WA = (1-ZIM.ScDV.result_matr_Hsig./0.2).*100;
ZIM.ScDV.result_matr_WA_MHWS =...
    (ZIM.ScDV.result_matr_Hsig_MLWS./0.2-ZIM.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScDV.result_matr_WA_bar =...
    (ZIM.ScDV.result_matr_Hsig_MLWS./0.2-ZIM.ScDV.result_matr_Hsig_vegedge./0.2).*100;
ZIM.ScDV.result_matr_WA_veg =...
    (ZIM.ScDV.result_matr_Hsig_vegedge./0.2-ZIM.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScDV.result_trans_WA = min(ZIM.ScDV.result_matr_WA_MHWS);
ZIM.ScDV.result_mm_WA = [min(ZIM.ScDV.result_trans_WA(1:5)),max(ZIM.ScDV.result_trans_WA(1:5))];
ZIM.ScDV.result_mean_WA = mean(ZIM.ScDV.result_trans_WA);

%---Hoofdplaat--- #Transects=6 --- #Years=42 ---
HOO.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Hoofdplaat_S250\Hoofdplaat_S250.mat')
HOO.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Hoofdplaat_S250\Hoofdplaat_S250.mat');
HOO.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Hoofdplaat_S250\Hoofdplaat_S250.mat');
HOO.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Hoofdplaat_S250.mat');

for i = 1:6
    HOO.result_length(i) = length(HOO.ScN.result(i).year(1).Hsig)*5;
    for j = 1:42
        HOO.ScN.result_matr_Hsig(j,i) = min(HOO.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1)
            HOO.ScN.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1);
        else
            HOO.ScN.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1))
            HOO.ScN.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1));
        else
            HOO.ScN.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1)
            HOO.ScN.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1);
        else
            HOO.ScN.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(end);
        end
        
        HOO.ScD.result_matr_Hsig(j,i) = min(HOO.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1)
            HOO.ScD.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1);
        else
            HOO.ScD.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1))
            HOO.ScD.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1));
        else
            HOO.ScD.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1)
            HOO.ScD.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1);
        else
            HOO.ScD.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(end);
        end
        
        HOO.ScDV.result_matr_Hsig(j,i) = min(HOO.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1)
            HOO.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1);
        else
            HOO.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1))
            HOO.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1));
        else
            HOO.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1)
            HOO.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1);
        else
            HOO.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(end);
        end
        HOO.result_veglength(j,i) = nansum(HOO.input.Hoofdplaat_S250.Veg{i}(j,:))*5;
        HOO.result_relveglength(j,i) = (HOO.result_veglength(j,i)/HOO.result_length(i)).*100;
        HOO.result_barelength(j,i) =...
            length(find(HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS &...
            HOO.ScN.result(i).year(j).Botlev>-HOO.input.Hoofdplaat_S250.veg_edge))*5;
    end
end

HOO.result_trans_relveglength = min(HOO.result_relveglength);
HOO.result_mm_trans_relveglength =...
    [min(HOO.result_trans_relveglength),max(HOO.result_trans_relveglength)];
HOO.result_mean_trans_relveglength =...
    mean(HOO.result_trans_relveglength);

HOO.ScN.result_matr_Hsig(HOO.ScN.result_matr_Hsig<0) = NaN;
HOO.ScN.result_matr_Hsig_MHWS(HOO.ScN.result_matr_Hsig_MHWS<0) = NaN;
HOO.ScN.result_matr_WA = (1-HOO.ScN.result_matr_Hsig./2.3600).*100;
HOO.ScN.result_matr_WA_MHWS =...
    (HOO.ScN.result_matr_Hsig_MLWS./2.3600-HOO.ScN.result_matr_Hsig_MHWS./2.3600).*100;
HOO.ScN.result_matr_WA_bar =...
    (HOO.ScN.result_matr_Hsig_MLWS./2.3600-HOO.ScN.result_matr_Hsig_vegedge./2.3600).*100;
HOO.ScN.result_matr_WA_veg =...
    (HOO.ScN.result_matr_Hsig_vegedge./2.3600-HOO.ScN.result_matr_Hsig_MHWS./2.3600).*100;
HOO.ScN.result_trans_WA = min(HOO.ScN.result_matr_WA_MHWS);
HOO.ScN.result_mm_WA = [min(HOO.ScN.result_trans_WA),max(HOO.ScN.result_trans_WA)];
HOO.ScN.result_mean_WA = mean(HOO.ScN.result_trans_WA);

HOO.ScD.result_matr_Hsig(HOO.ScD.result_matr_Hsig<0) = NaN;
HOO.ScD.result_matr_Hsig_MHWS(HOO.ScD.result_matr_Hsig_MHWS<0) = NaN;
HOO.ScD.result_matr_WA = (1-HOO.ScD.result_matr_Hsig./0.2).*100;
HOO.ScD.result_matr_WA_MHWS =...
    (HOO.ScD.result_matr_Hsig_MLWS./0.2-HOO.ScD.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScD.result_matr_WA_bar =...
    (HOO.ScD.result_matr_Hsig_MLWS./0.2-HOO.ScD.result_matr_Hsig_vegedge./0.2).*100;
HOO.ScD.result_matr_WA_veg =...
    (HOO.ScD.result_matr_Hsig_vegedge./0.2-HOO.ScD.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScD.result_trans_WA = min(HOO.ScD.result_matr_WA_MHWS);
HOO.ScD.result_mm_WA = [min(HOO.ScD.result_trans_WA),max(HOO.ScD.result_trans_WA)];
HOO.ScD.result_mean_WA = mean(HOO.ScD.result_trans_WA);

HOO.ScDV.result_matr_Hsig(HOO.ScDV.result_matr_Hsig<0) = NaN;
HOO.ScDV.result_matr_Hsig_MHWS(HOO.ScDV.result_matr_Hsig_MHWS<0) = NaN;
HOO.ScDV.result_matr_WA = (1-HOO.ScDV.result_matr_Hsig./0.2).*100;
HOO.ScDV.result_matr_WA_MHWS =...
    (HOO.ScDV.result_matr_Hsig_MLWS./0.2-HOO.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScDV.result_matr_WA_bar =...
    (HOO.ScDV.result_matr_Hsig_MLWS./0.2-HOO.ScDV.result_matr_Hsig_vegedge./0.2).*100;
HOO.ScDV.result_matr_WA_veg =...
    (HOO.ScDV.result_matr_Hsig_vegedge./0.2-HOO.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScDV.result_trans_WA = min(HOO.ScDV.result_matr_WA_MHWS);
HOO.ScDV.result_mm_WA = [min(HOO.ScDV.result_trans_WA),max(HOO.ScDV.result_trans_WA)];
HOO.ScDV.result_mean_WA = mean(HOO.ScDV.result_trans_WA);

%---Paulinapolder--- #Transects=7 --- #Years=41 ---
PAU.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Paulinapolder_S250\Paulinapolder_S250.mat')
PAU.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Paulinapolder_S250\Paulinapolder_S250.mat');
PAU.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Paulinapolder_S250\Paulinapolder_S250.mat');
PAU.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Paulinapolder_S250.mat');

for i = 1:7
    PAU.result_length(i) = length(PAU.ScN.result(i).year(1).Hsig)*5;
    for j = 1:41
        PAU.ScN.result_matr_Hsig(j,i) = min(PAU.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1)
            PAU.ScN.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1);
        else
            PAU.ScN.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1))
            PAU.ScN.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1));
        else
            PAU.ScN.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1)
            PAU.ScN.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1);
        else
            PAU.ScN.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(end);
        end
        
        PAU.ScD.result_matr_Hsig(j,i) = min(PAU.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1)
            PAU.ScD.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1);
        else
            PAU.ScD.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1))
            PAU.ScD.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1));
        else
            PAU.ScD.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1)
            PAU.ScD.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1);
        else
            PAU.ScD.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(end);
        end
        
        PAU.ScDV.result_matr_Hsig(j,i) = min(PAU.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1)
            PAU.ScDV.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1);
        else
            PAU.ScDV.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1))
            PAU.ScDV.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1));
        else
            PAU.ScDV.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1)
            PAU.ScDV.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1);
        else
            PAU.ScDV.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(end);
        end
        PAU.result_veglength(j,i) = nansum(PAU.input.Paulinapolder_S250.Veg{i}(j,:))*5;
        PAU.result_relveglength(j,i) = (PAU.result_veglength(j,i)/PAU.result_length(i)).*100;
        PAU.result_barelength(j,i) =...
            length(find(PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS &...
            PAU.ScN.result(i).year(j).Botlev>-PAU.input.Paulinapolder_S250.veg_edge))*5;
    end
end

PAU.result_trans_relveglength = min(PAU.result_relveglength);
PAU.result_mm_trans_relveglength =...
    [min(PAU.result_trans_relveglength),max(PAU.result_trans_relveglength)];
PAU.result_mean_trans_relveglength =...
    mean(PAU.result_trans_relveglength);

PAU.ScN.result_matr_Hsig(PAU.ScN.result_matr_Hsig<0) = NaN;
PAU.ScN.result_matr_Hsig_MHWS(PAU.ScN.result_matr_Hsig_MHWS<0) = NaN;
PAU.ScN.result_matr_WA = (1-PAU.ScN.result_matr_Hsig./2.1450).*100;
PAU.ScN.result_matr_WA_MHWS =...
    (PAU.ScN.result_matr_Hsig_MLWS./2.1450-PAU.ScN.result_matr_Hsig_MHWS./2.1450).*100;
PAU.ScN.result_matr_WA_bar =...
    (PAU.ScN.result_matr_Hsig_MLWS./2.1450-PAU.ScN.result_matr_Hsig_vegedge./2.1450).*100;
PAU.ScN.result_matr_WA_veg =...
    (PAU.ScN.result_matr_Hsig_vegedge./2.1450-PAU.ScN.result_matr_Hsig_MHWS./2.1450).*100;
PAU.ScN.result_trans_WA = min(PAU.ScN.result_matr_WA_MHWS);
PAU.ScN.result_mm_WA = [min(PAU.ScN.result_trans_WA),max(PAU.ScN.result_trans_WA)];
PAU.ScN.result_mean_WA = mean(PAU.ScN.result_trans_WA);

PAU.ScD.result_matr_Hsig(PAU.ScD.result_matr_Hsig<0) = NaN;
PAU.ScD.result_matr_Hsig_MHWS(PAU.ScD.result_matr_Hsig_MHWS<0) = NaN;
PAU.ScD.result_matr_WA = (1-PAU.ScD.result_matr_Hsig./0.2).*100;
PAU.ScD.result_matr_WA_MHWS =...
    (PAU.ScD.result_matr_Hsig_MLWS./0.2-PAU.ScD.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScD.result_matr_WA_bar =...
    (PAU.ScD.result_matr_Hsig_MLWS./0.2-PAU.ScD.result_matr_Hsig_vegedge./0.2).*100;
PAU.ScD.result_matr_WA_veg =...
    (PAU.ScD.result_matr_Hsig_vegedge./0.2-PAU.ScD.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScD.result_trans_WA = min(PAU.ScD.result_matr_WA_MHWS);
PAU.ScD.result_mm_WA = [min(PAU.ScD.result_trans_WA),max(PAU.ScD.result_trans_WA)];
PAU.ScD.result_mean_WA = mean(PAU.ScD.result_trans_WA);

PAU.ScDV.result_matr_Hsig(PAU.ScDV.result_matr_Hsig<0) = NaN;
PAU.ScDV.result_matr_Hsig_MHWS(PAU.ScDV.result_matr_Hsig_MHWS<0) = NaN;
PAU.ScDV.result_matr_WA = (1-PAU.ScDV.result_matr_Hsig./0.2).*100;
PAU.ScDV.result_matr_WA_MHWS =...
    (PAU.ScDV.result_matr_Hsig_MLWS./0.2-PAU.ScDV.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScDV.result_matr_WA_MHWS(PAU.ScDV.result_matr_WA_MHWS==-9) = NaN;
PAU.ScDV.result_matr_WA_bar =...
    (PAU.ScDV.result_matr_Hsig_MLWS./0.2-PAU.ScDV.result_matr_Hsig_vegedge./0.2).*100;
PAU.ScDV.result_matr_WA_bar(PAU.ScDV.result_matr_WA_bar==-9) = NaN;
PAU.ScDV.result_matr_WA_veg =...
    (PAU.ScDV.result_matr_Hsig_vegedge./0.2-PAU.ScDV.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScDV.result_matr_WA_veg(PAU.ScDV.result_matr_WA_veg==-9) = NaN;
PAU.ScDV.result_trans_WA = min(PAU.ScDV.result_matr_WA_MHWS);
PAU.ScDV.result_mm_WA = [min(PAU.ScDV.result_trans_WA),max(PAU.ScDV.result_trans_WA)];
PAU.ScDV.result_mean_WA = mean(PAU.ScDV.result_trans_WA);

%---Hellegatpolder--- #Transects=6 --- #Years=52 ---
HEL.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Hellegatpolder_S250\Hellegatpolder_S250.mat')
HEL.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Hellegatpolder_S250\Hellegatpolder_S250.mat');
HEL.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Hellegatpolder_S250\Hellegatpolder_S250.mat');
HEL.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Hellegatpolder_S250.mat');

for i = 1:6
    HEL.result_length(i) = length(HEL.ScN.result(i).year(1).Hsig)*5;
    for j = 1:52
        HEL.ScN.result_matr_Hsig(j,i) = min(HEL.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1)
            HEL.ScN.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1);
        else
            HEL.ScN.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1))
            HEL.ScN.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1));
        else
            HEL.ScN.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1)
            HEL.ScN.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1);
        else
            HEL.ScN.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(end);
        end
        
        HEL.ScD.result_matr_Hsig(j,i) = min(HEL.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1)
            HEL.ScD.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1);
        else
            HEL.ScD.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1))
            HEL.ScD.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1));
        else
            HEL.ScD.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1)
            HEL.ScD.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1);
        else
            HEL.ScD.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(end);
        end
        
        HEL.ScDV.result_matr_Hsig(j,i) = min(HEL.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1)
            HEL.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1);
        else
            HEL.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1))
            HEL.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1));
        else
            HEL.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1)
            HEL.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1);
        else
            HEL.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(end);
        end
        HEL.result_veglength(j,i) = nansum(HEL.input.Hellegatpolder_S250.Veg{i}(j,:))*5;
        HEL.result_relveglength(j,i) = (HEL.result_veglength(j,i)/HEL.result_length(i)).*100;
        HEL.result_barelength(j,i) =...
            length(find(HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS &...
            HEL.ScN.result(i).year(j).Botlev>-HEL.input.Hellegatpolder_S250.veg_edge))*5;
    end
end

HEL.result_trans_relveglength = min(HEL.result_relveglength);
HEL.result_mm_trans_relveglength =...
    [min(HEL.result_trans_relveglength),max(HEL.result_trans_relveglength)];
HEL.result_mean_trans_relveglength =...
    mean(HEL.result_trans_relveglength);

HEL.ScN.result_matr_Hsig(HEL.ScN.result_matr_Hsig<0) = NaN;
HEL.ScN.result_matr_Hsig_MHWS(HEL.ScN.result_matr_Hsig_MHWS<0) = NaN;
HEL.ScN.result_matr_WA = (1-HEL.ScN.result_matr_Hsig./2.6500).*100;
HEL.ScN.result_matr_WA_MHWS =...
    (HEL.ScN.result_matr_Hsig_MLWS./2.6500-HEL.ScN.result_matr_Hsig_MHWS./2.6500).*100;
HEL.ScN.result_matr_WA_bar =...
    (HEL.ScN.result_matr_Hsig_MLWS./2.6500-HEL.ScN.result_matr_Hsig_vegedge./2.6500).*100;
HEL.ScN.result_matr_WA_veg =...
    (HEL.ScN.result_matr_Hsig_vegedge./2.6500-HEL.ScN.result_matr_Hsig_MHWS./2.6500).*100;
HEL.ScN.result_trans_WA = min(HEL.ScN.result_matr_WA_MHWS);
HEL.ScN.result_mm_WA = [min(HEL.ScN.result_trans_WA),max(HEL.ScN.result_trans_WA)];
HEL.ScN.result_mean_WA = mean(HEL.ScN.result_trans_WA);

HEL.ScD.result_matr_Hsig(HEL.ScD.result_matr_Hsig<0) = NaN;
HEL.ScD.result_matr_Hsig_MHWS(HEL.ScD.result_matr_Hsig_MHWS<0) = NaN;
HEL.ScD.result_matr_WA = (1-HEL.ScD.result_matr_Hsig./0.2).*100;
HEL.ScD.result_matr_WA_MHWS =...
    (HEL.ScD.result_matr_Hsig_MLWS./0.2-HEL.ScD.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScD.result_matr_WA_bar =...
    (HEL.ScD.result_matr_Hsig_MLWS./0.2-HEL.ScD.result_matr_Hsig_vegedge./0.2).*100;
HEL.ScD.result_matr_WA_veg =...
    (HEL.ScD.result_matr_Hsig_vegedge./0.2-HEL.ScD.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScD.result_trans_WA = min(HEL.ScD.result_matr_WA_MHWS);
HEL.ScD.result_mm_WA = [min(HEL.ScD.result_trans_WA),max(HEL.ScD.result_trans_WA)];
HEL.ScD.result_mean_WA = mean(HEL.ScD.result_trans_WA);

HEL.ScDV.result_matr_Hsig(HEL.ScDV.result_matr_Hsig<0) = NaN;
HEL.ScDV.result_matr_Hsig_MHWS(HEL.ScDV.result_matr_Hsig_MHWS<0) = NaN;
HEL.ScDV.result_matr_WA = (1-HEL.ScDV.result_matr_Hsig./0.2).*100;
HEL.ScDV.result_matr_WA_MHWS =...
    (HEL.ScDV.result_matr_Hsig_MLWS./0.2-HEL.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScDV.result_matr_WA_bar =...
    (HEL.ScDV.result_matr_Hsig_MLWS./0.2-HEL.ScDV.result_matr_Hsig_vegedge./0.2).*100;
HEL.ScDV.result_matr_WA_veg =...
    (HEL.ScDV.result_matr_Hsig_vegedge./0.2-HEL.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScDV.result_trans_WA = min(HEL.ScDV.result_matr_WA_MHWS);
HEL.ScDV.result_mm_WA = [min(HEL.ScDV.result_trans_WA),max(HEL.ScDV.result_trans_WA)];
HEL.ScDV.result_mean_WA = mean(HEL.ScDV.result_trans_WA);

ZUI.ScN.result_matr_WA(isnan(ZUI.ScN.result_matr_WA)) = 100;
BAA.ScN.result_matr_WA(isnan(BAA.ScN.result_matr_WA)) = 100;
ZIM.ScN.result_matr_WA(isnan(ZIM.ScN.result_matr_WA)) = 100;
HOO.ScN.result_matr_WA(isnan(HOO.ScN.result_matr_WA)) = 100;
PAU.ScN.result_matr_WA(isnan(PAU.ScN.result_matr_WA)) = 100;
HEL.ScN.result_matr_WA(isnan(HEL.ScN.result_matr_WA)) = 100;


%% Find additional statistics
% ZUI --------------------------------------------------------------------
for i = 1:9
    for j = 1:length(ZUI.ScN.result(i).year)
        ZUI.Z_interp(j+length(ZUI.ScN.result(i).year)*(i-1),:) = interp1(linspace(0,1,length(ZUI.ScN.result(i).year(j).Botlev)),...
            -ZUI.ScN.result(i).year(j).Botlev,linspace(0,1,3000));
        ZUI.result_veglengthMHWS(j,i) =...
            length(find(ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge &...
            ZUI.ScN.result(i).year(j).Botlev>-ZUI.input.Zuidgors_S250.h_daily))*5;
    end
end

% BAA --------------------------------------------------------------------
for i = 1:3
    for j = 1:length(BAA.ScN.result(i).year)
        BAA.Z_interp(j+length(BAA.ScN.result(i).year)*(i-1),:) = interp1(linspace(0,1,length(BAA.ScN.result(i).year(j).Botlev)),...
            -BAA.ScN.result(i).year(j).Botlev,linspace(0,1,3000));
        BAA.result_veglengthMHWS(j,i) =...
            length(find(BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge &...
            BAA.ScN.result(i).year(j).Botlev>-BAA.input.Baarland_S250.h_daily))*5;
    end
end

% ZIM --------------------------------------------------------------------
for i = 1:5
    for j = 1:length(ZIM.ScN.result(i).year)
        ZIM.Z_interp(j+length(ZIM.ScN.result(i).year)*(i-1),:) = interp1(linspace(0,1,length(ZIM.ScN.result(i).year(j).Botlev)),...
            -ZIM.ScN.result(i).year(j).Botlev,linspace(0,1,3000));
        ZIM.result_veglengthMHWS(j,i) =...
            length(find(ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge &...
            ZIM.ScN.result(i).year(j).Botlev>-ZIM.input.Zimmermanpolder_S250.h_daily))*5;
    end
end

% HOO --------------------------------------------------------------------
for i = 1:length(HOO.ScN.result)
    for j = 1:length(HOO.ScN.result(i).year)
        HOO.Z_interp(j+length(HOO.ScN.result(i).year)*(i-1),:) = interp1(linspace(0,1,length(HOO.ScN.result(i).year(j).Botlev)),...
            -HOO.ScN.result(i).year(j).Botlev,linspace(0,1,3000));
        HOO.result_veglengthMHWS(j,i) =...
            length(find(HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge &...
            HOO.ScN.result(i).year(j).Botlev>-HOO.input.Hoofdplaat_S250.h_daily))*5;
    end
end

% PAU --------------------------------------------------------------------
for i = 1:length(PAU.ScN.result)
    for j = 1:length(PAU.ScN.result(i).year)
        PAU.Z_interp(j+length(PAU.ScN.result(i).year)*(i-1),:) = interp1(linspace(0,1,length(PAU.ScN.result(i).year(j).Botlev)),...
            -PAU.ScN.result(i).year(j).Botlev,linspace(0,1,3000));
        PAU.result_veglengthMHWS(j,i) =...
            length(find(PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge &...
            PAU.ScN.result(i).year(j).Botlev>-PAU.input.Paulinapolder_S250.h_daily))*5;
    end
end

% HEL --------------------------------------------------------------------
for i = 1:length(HEL.ScN.result)
    for j = 1:length(HEL.ScN.result(i).year)
        HEL.Z_interp(j+length(HEL.ScN.result(i).year)*(i-1),:) = interp1(linspace(0,1,length(HEL.ScN.result(i).year(j).Botlev)),...
            -HEL.ScN.result(i).year(j).Botlev,linspace(0,1,3000));
        HEL.result_veglengthMHWS(j,i) =...
            length(find(HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge &...
            HEL.ScN.result(i).year(j).Botlev>-HEL.input.Hellegatpolder_S250.h_daily))*5;
    end
end



%% Manuscript Figure 8
AL = [0,1500,0,30];
CL1 = [0.3,0.3,0.3];
CL2 = [0.5,0.5,0.5];
XW = 1.15;
YW = 1.15;
TX1 = 900;
TY1 = 20;
cmap6 = jet(6);

MS_Fig8 = figure;
SP1 = subplot(3,4,1);
ZUI.fitR.R2 = fitlm(ZUI.result_veglengthMHWS(:),...
    ZUI.ScN.result_matr_WA_veg(:));
% plot(ZUI.result_veglengthMHWS(1:37,1:9),ZUI.ScN.result_matr_WA_veg(1:37,1:9),'.','color',CL1);
% hold on;
plot(ZUI.result_barelength(1:37,1:9),ZUI.ScN.result_matr_WA_bar(1:37,1:9),'*','color',CL2);
hold on
[ZUI.fit.p, ZUI.fit.s] = polyfit(ZUI.result_veglengthMHWS(:),...
    ZUI.ScN.result_matr_WA_veg(:),1);
[ZUI.fit.yfit, ZUI.fit.dy] = polyval(ZUI.fit.p,...
    ZUI.result_veglengthMHWS(:), ZUI.fit.s);
plot(ZUI.result_veglengthMHWS(:),ZUI.fit.yfit,'color',...
    cmap6(1,:),'linewidth',2);
plot(0:1000, 0.0273*[0:1000]+0.8726,'--r')
%plot(ZUI.result_veglengthMHWS(:),ZUI.fit.yfit+2*ZUI.fit.dy,'color',...
    %cmap6(1,:));
%plot(ZUI.result_veglengthMHWS(:),ZUI.fit.yfit-2*ZUI.fit.dy,'color',...
    %cmap6(1,:));
%text(TX1,TY1,{'ZUI','6.04m','1.66m','0.27'},'color','r');
grid on; box on; axis(AL);
% set(gca,'xticklabel',[]);
SP1.Position(3) = SP1.Position(3)*XW;
SP1.Position(4) = SP1.Position(4)*YW;
set(gca,'xtick',[0,500,1000]);

SP2 = subplot(3,4,2);
BAA.fitR.R2 = fitlm(BAA.result_veglengthMHWS(:),...
    BAA.ScN.result_matr_WA_veg(:));
% plot(BAA.result_veglengthMHWS(1:37,1:3),BAA.ScN.result_matr_WA_veg(1:37,1:3),'.','color',CL1);
% hold on;
plot(BAA.result_barelength(1:37,1:3),BAA.ScN.result_matr_WA_bar(1:37,1:3),'*','color',CL2);
hold on
[BAA.fit.p, BAA.fit.s] = polyfit(BAA.result_veglengthMHWS(:),...
    BAA.ScN.result_matr_WA_veg(:),1);
[BAA.fit.yfit, BAA.fit.dy] = polyval(BAA.fit.p,...
    BAA.result_veglengthMHWS(:), BAA.fit.s);
%plot(BAA.result_veglengthMHWS(:),BAA.fit.yfit,'color',...
    %cmap6(2,:),'linewidth',2);
%plot(BAA.result_veglengthMHWS(:),BAA.fit.yfit+2*BAA.fit.dy,'color',...
    %cmap6(2,:));
%plot(BAA.result_veglengthMHWS(:),BAA.fit.yfit-2*BAA.fit.dy,'color',...
    %cmap6(2,:));
%text(TX1,TY1,{'BAA','6.13m','1.72m','0.28'},'color','r');
grid on; box on; axis(AL);
set(gca,'yticklabel',[]);
SP2.Position(3) = SP2.Position(3)*XW;
SP2.Position(4) = SP2.Position(4)*YW;
set(gca,'xtick',[0,500,1000]);

SP3 = subplot(3,4,3);
ZIM.fitR.R2 = fitlm(ZIM.result_veglengthMHWS(:),...
    ZIM.ScN.result_matr_WA_veg(:));
% plot(ZIM.result_veglengthMHWS(1:51,1:5),ZIM.ScN.result_matr_WA_veg(1:51,1:5),'.','color',CL1);
% hold on;
plot(ZIM.result_barelength(1:51,1:5),ZIM.ScN.result_matr_WA_bar(1:51,1:5),'*','color',CL2);
hold on
[ZIM.fit.p, ZIM.fit.s] = polyfit(ZIM.result_veglengthMHWS(:),...
    ZIM.ScN.result_matr_WA_veg(:),1);
[ZIM.fit.yfit, ZIM.fit.dy] = polyval(ZIM.fit.p,...
    ZIM.result_veglengthMHWS(:), ZIM.fit.s);
%plot(ZIM.result_veglengthMHWS(:),ZIM.fit.yfit,'color',...
    %cmap6(3,:),'linewidth',2);
%plot(ZIM.result_veglengthMHWS(:),ZIM.fit.yfit+2*ZIM.fit.dy,'color',...
    %cmap6(3,:));
%plot(ZIM.result_veglengthMHWS(:),ZIM.fit.yfit-2*ZIM.fit.dy,'color',...
    %cmap6(3,:));
%text(TX1,TY1,{'ZIM','6.71m','1.82m','0.27'},'color','r');
grid on; box on; axis(AL);
set(gca,'yticklabel',[]);
SP3.Position(3) = SP3.Position(3)*XW;
SP3.Position(4) = SP3.Position(4)*YW;
set(gca,'xtick',[0,500,1000]);

SP4 = subplot(3,4,5);
HOO.fitR.R2 = fitlm(HOO.result_veglengthMHWS(:),...
    HOO.ScN.result_matr_WA_veg(:));
% plot(HOO.result_veglengthMHWS(1:42,1:6),HOO.ScN.result_matr_WA_veg(1:42,1:6),'.','color',CL1);
% hold on;
plot(HOO.result_barelength(1:42,1:6),HOO.ScN.result_matr_WA_bar(1:42,1:6),'*','color',CL2);
hold on
[HOO.fit.p, HOO.fit.s] = polyfit(HOO.result_veglengthMHWS(:),...
    HOO.ScN.result_matr_WA_veg(:),1);
[HOO.fit.yfit, HOO.fit.dy] = polyval(HOO.fit.p,...
    HOO.result_veglengthMHWS(:), HOO.fit.s);
%plot(HOO.result_veglengthMHWS(:),HOO.fit.yfit,'color',...
    %cmap6(4,:),'linewidth',2);
%plot(HOO.result_veglengthMHWS(:),HOO.fit.yfit+2*HOO.fit.dy,'color',...
    %cmap6(4,:));
%plot(HOO.result_veglengthMHWS(:),HOO.fit.yfit-2*HOO.fit.dy,'color',...
    %cmap6(4,:));
%text(TX1,TY1,{'HOO','5.78m','2.36m','0.41'});
grid on; box on; axis(AL);
ylabel(' 		                            				wave attenuation of foreshore part (%)')
SP4.Position(3) = SP4.Position(3)*XW;
SP4.Position(4) = SP4.Position(4)*YW;
set(gca,'xtick',[0,500,1000]);

SP5 = subplot(3,4,6);
PAU.fitR.R2 = fitlm(PAU.result_veglengthMHWS(:),...
    PAU.ScN.result_matr_WA_veg(:));
% plot(PAU.result_veglengthMHWS(1:41,1:7),PAU.ScN.result_matr_WA_veg(1:41,1:7),'.','color',CL1);
% hold on;
plot(PAU.result_barelength(1:41,1:7),PAU.ScN.result_matr_WA_bar(1:41,1:7),'*','color',CL2);
hold on
[PAU.fit.p, PAU.fit.s] = polyfit(PAU.result_veglengthMHWS(:),...
    PAU.ScN.result_matr_WA_veg(:),1);
[PAU.fit.yfit, PAU.fit.dy] = polyval(PAU.fit.p,...
    PAU.result_veglengthMHWS(:), PAU.fit.s);
%plot(PAU.result_veglengthMHWS(:),PAU.fit.yfit,'color',...
    %cmap6(5,:),'linewidth',2);
%plot(PAU.result_veglengthMHWS(:),PAU.fit.yfit+2*PAU.fit.dy,'color',...
    %cmap6(5,:));
%plot(PAU.result_veglengthMHWS(:),PAU.fit.yfit-2*PAU.fit.dy,'color',...
    %cmap6(5,:));
%text(TX1,TY1,{'PAU','5.89m','2.15m','0.37'});
grid on; box on; axis(AL);
xlabel('length of foreshore part (m)')
set(gca,'yticklabel',[]);
SP5.Position(3) = SP5.Position(3)*XW;
SP5.Position(4) = SP5.Position(4)*YW;
set(gca,'xtick',[0,500,1000]);

SP6 = subplot(3,4,7);
HEL.fitR.R2 = fitlm(HEL.result_veglengthMHWS(:),...
    HEL.ScN.result_matr_WA_veg(:));
% plot(HEL.result_veglengthMHWS(1:52,1:6),HEL.ScN.result_matr_WA_veg(1:52,1:6),'.','color',CL1);
% hold on;
plot(HEL.result_barelength(1:52,1:6),HEL.ScN.result_matr_WA_bar(1:52,1:6),'*','color',CL2);
hold on
[HEL.fit.p, HEL.fit.s] = polyfit(HEL.result_veglengthMHWS(:),...
    HEL.ScN.result_matr_WA_veg(:),1);
[HEL.fit.yfit, HEL.fit.dy] = polyval(HEL.fit.p,...
    HEL.result_veglengthMHWS(:), HEL.fit.s);
%plot(HEL.result_veglengthMHWS(:),HEL.fit.yfit,'color',...
    %cmap6(6,:),'linewidth',2);
%plot(HEL.result_veglengthMHWS(:),HEL.fit.yfit+2*HEL.fit.dy,'color',...
    %cmap6(6,:));
%plot(HEL.result_veglengthMHWS(:),HEL.fit.yfit-2*HEL.fit.dy,'color',...
    %cmap6(6,:));
%text(TX1,TY1,{'HEL','6.32m','2.56m','0.41'});
grid on; box on; axis(AL);
set(gca,'yticklabel',[]);
SP6.Position(3) = SP6.Position(3)*XW;
SP6.Position(4) = SP6.Position(4)*YW;
set(gca,'xtick',[0,500,1000]);

SP7 = subplot(3,4,8)
plot(ZUI.result_veglengthMHWS(:),ZUI.fit.yfit,'color',...
    cmap6(1,:),'linewidth',2);
hold on;
plot(BAA.result_veglengthMHWS(:),BAA.fit.yfit,'color',...
    cmap6(2,:),'linewidth',2);
plot(ZIM.result_veglengthMHWS(:),ZIM.fit.yfit,'color',...
    cmap6(3,:),'linewidth',2);
plot(HOO.result_veglengthMHWS(:),HOO.fit.yfit,'color',...
    cmap6(4,:),'linewidth',2);
plot(PAU.result_veglengthMHWS(:),PAU.fit.yfit,'color',...
    cmap6(5,:),'linewidth',2);
plot(HEL.result_veglengthMHWS(:),HEL.fit.yfit,'color',...
    cmap6(6,:),'linewidth',2);
grid on; box on; axis(AL);
set(gca,'yticklabel',[]);
SP7.Position(3) = SP7.Position(3)*XW;
SP7.Position(4) = SP7.Position(4)*YW;
set(gca,'xtick',[0,500,1000,1500]);

SP8 = subplot(3,4,4)
plot(PAU.result_veglengthMHWS(1,1),PAU.ScN.result_matr_WA_veg(1,1),'.','color',CL1);
hold on;
plot(PAU.result_barelength(1,1),PAU.ScN.result_matr_WA_bar(1,1),'*','color',CL2);
plot(ZUI.result_veglengthMHWS(:),ZUI.fit.yfit,'color',...
    cmap6(1,:),'linewidth',2);
plot(BAA.result_veglengthMHWS(:),BAA.fit.yfit,'color',...
    cmap6(2,:),'linewidth',2);
plot(ZIM.result_veglengthMHWS(:),ZIM.fit.yfit,'color',...
    cmap6(3,:),'linewidth',2);
plot(HOO.result_veglengthMHWS(:),HOO.fit.yfit,'color',...
    cmap6(4,:),'linewidth',2);
plot(PAU.result_veglengthMHWS(:),PAU.fit.yfit,'color',...
    cmap6(5,:),'linewidth',2);
plot(HEL.result_veglengthMHWS(:),HEL.fit.yfit,'color',...
    cmap6(6,:),'linewidth',2);
axis([-1,0,-1,0]); axis off
LSP8 = legend('marsh','flat','ZUI','BAA','ZIM','HOO','PAU','HEL');
LSP8.Position(1) = SP7.Position(1)
LSP8.Position(2) = SP3.Position(2)

cd M:\Documents\PhD\Scripts\MATLAB\Chapter1\altmany-export_fig-412662f
% export_fig MS_Fig8 -deps -r864 -transparent -p1
