%% Analyse wave attenuation data of all foreshores in the Westerschelde based on Vaklodingen and SWAN analysis
close all; clear all; clc;

%% Load and summarize data
addpath('M:\Documents\PhD\Scripts\MATLAB\Chapter1');

%---Zuidgors--- #Transects=11 (9 effective) --- #Years=37 ---
ZUI.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Zuidgors_S250\Zuidgors_S250.mat')
ZUI.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Zuidgors_S250\Zuidgors_S250.mat');
ZUI.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Zuidgors_S250\Zuidgors_S250.mat');
ZUI.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Zuidgors_S250.mat');

for i = 1:9
    ZUI.result_length(i) = length(ZUI.ScN.result(i).year(1).Hsig)*5;
    for j = 1:37
        ZUI.ScN.result_matr_Hsig(j,i) = min(ZUI.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1)
            ZUI.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1);
        else
            ZUI.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1))
            ZUI.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1));
        else
            ZUI.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1)
            ZUI.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1);
        else
            ZUI.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(end);
        end
        
        ZUI.ScD.result_matr_Hsig(j,i) = min(ZUI.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1)
            ZUI.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1);
        else
            ZUI.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1))
            ZUI.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1));
        else
            ZUI.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1)
            ZUI.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1);
        else
            ZUI.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(end);
        end
        
        ZUI.ScDV.result_matr_Hsig(j,i) = min(ZUI.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1)
            ZUI.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1);
        else
            ZUI.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1))
            ZUI.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1));
        else
            ZUI.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1)
            ZUI.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1);
        else
            ZUI.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(end);
        end
        
        ZUI.result_veglength(j,i) = nansum(ZUI.input.Zuidgors_S250.Veg{i}(j,:))*5;
        ZUI.result_relveglength(j,i) = (ZUI.result_veglength(j,i)/ZUI.result_length(i)).*100;
        ZUI.result_barelength(j,i) =...
            length(find(ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS &...
            ZUI.ScN.result(i).year(j).Botlev>-ZUI.input.Zuidgors_S250.veg_edge))*5;
    end
end

ZUI.result_trans_relveglength = min(ZUI.result_relveglength);
ZUI.result_mm_trans_relveglength =...
    [min(ZUI.result_trans_relveglength),max(ZUI.result_trans_relveglength)];
ZUI.result_mean_trans_relveglength =...
    mean(ZUI.result_trans_relveglength);

ZUI.ScN.result_matr_Hsig(ZUI.ScN.result_matr_Hsig<0) = 0;
ZUI.ScN.result_matr_Hsig_MHWS(ZUI.ScN.result_matr_Hsig_MHWS<0) = 0;
ZUI.ScN.result_matr_WA = (1-ZUI.ScN.result_matr_Hsig./1.6550).*100;
ZUI.ScN.result_matr_WA_MHWS =...
    (ZUI.ScN.result_matr_Hsig_MLWS./1.6550-ZUI.ScN.result_matr_Hsig_MHWS./1.6550).*100;
ZUI.ScN.result_matr_WA_bar =...
    (ZUI.ScN.result_matr_Hsig_MLWS./1.6550-ZUI.ScN.result_matr_Hsig_vegedge./1.6550).*100;
ZUI.ScN.result_matr_WA_veg =...
    (ZUI.ScN.result_matr_Hsig_vegedge./1.6550-ZUI.ScN.result_matr_Hsig_MHWS./1.6550).*100;
ZUI.ScN.result_trans_WA = min(ZUI.ScN.result_matr_WA_MHWS);
ZUI.ScN.result_mm_WA = [min(ZUI.ScN.result_trans_WA),max(ZUI.ScN.result_trans_WA)];
ZUI.ScN.result_mean_WA = mean(ZUI.ScN.result_trans_WA);

ZUI.ScD.result_matr_Hsig(ZUI.ScD.result_matr_Hsig<0) = 0;
ZUI.ScD.result_matr_Hsig_MHWS(ZUI.ScD.result_matr_Hsig_MHWS<0) = 0;
ZUI.ScD.result_matr_WA = (1-ZUI.ScD.result_matr_Hsig./0.2).*100;
ZUI.ScD.result_matr_WA_MHWS =...
    (ZUI.ScD.result_matr_Hsig_MLWS./0.2-ZUI.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScD.result_matr_WA_bar =...
    (ZUI.ScD.result_matr_Hsig_MLWS./0.2-ZUI.ScD.result_matr_Hsig_vegedge./0.2).*100;
ZUI.ScD.result_matr_WA_veg =...
    (ZUI.ScD.result_matr_Hsig_vegedge./0.2-ZUI.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScD.result_trans_WA = nanmin(ZUI.ScD.result_matr_WA_MHWS);
ZUI.ScD.result_mm_WA = [min(ZUI.ScD.result_trans_WA),max(ZUI.ScD.result_trans_WA)];
ZUI.ScD.result_mean_WA = nanmean(ZUI.ScD.result_trans_WA);

ZUI.ScDV.result_matr_Hsig(ZUI.ScDV.result_matr_Hsig<0) = 0;
ZUI.ScDV.result_matr_Hsig_MHWS(ZUI.ScDV.result_matr_Hsig_MHWS<0) = 0;
ZUI.ScDV.result_matr_WA = (1-ZUI.ScDV.result_matr_Hsig./0.2).*100;
ZUI.ScDV.result_matr_WA_MHWS =...
    (ZUI.ScDV.result_matr_Hsig_MLWS./0.2-ZUI.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScDV.result_matr_WA_bar =...
    (ZUI.ScDV.result_matr_Hsig_MLWS./0.2-ZUI.ScDV.result_matr_Hsig_vegedge./0.2).*100;
ZUI.ScDV.result_matr_WA_veg =...
    (ZUI.ScDV.result_matr_Hsig_vegedge./0.2-ZUI.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScDV.result_trans_WA = nanmin(ZUI.ScDV.result_matr_WA_MHWS);
ZUI.ScDV.result_mm_WA = [min(ZUI.ScDV.result_trans_WA),max(ZUI.ScDV.result_trans_WA)];
ZUI.ScDV.result_mean_WA = nanmean(ZUI.ScDV.result_trans_WA);

%---Baarland--- #Transects=7 (3 effective) --- #Years=37 ---
BAA.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Baarland_S250\Baarland_S250.mat')
BAA.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Baarland_S250\Baarland_S250.mat');
BAA.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Baarland_S250\Baarland_S250.mat');
BAA.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Baarland_S250.mat');

for i = 1:3
    BAA.result_length(i) = length(BAA.ScN.result(i).year(1).Hsig)*5;
    for j = 1:37
        BAA.ScN.result_matr_Hsig(j,i) = min(BAA.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1)
            BAA.ScN.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1);
        else
            BAA.ScN.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1))
            BAA.ScN.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1));
        else
            BAA.ScN.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1)
            BAA.ScN.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1);
        else
            BAA.ScN.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(end);
        end
        
        BAA.ScD.result_matr_Hsig(j,i) = min(BAA.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1)
            BAA.ScD.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1);
        else
            BAA.ScD.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1))
            BAA.ScD.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1));
        else
            BAA.ScD.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1)
            BAA.ScD.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1);
        else
            BAA.ScD.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(end);
        end
        
        BAA.ScDV.result_matr_Hsig(j,i) = min(BAA.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1)
            BAA.ScDV.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1);
        else
            BAA.ScDV.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1))
            BAA.ScDV.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1));
        else
            BAA.ScDV.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1)
            BAA.ScDV.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1);
        else
            BAA.ScDV.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(end);
        end
        BAA.result_veglength(j,i) = nansum(BAA.input.Baarland_S250.Veg{i}(j,:))*5;
        BAA.result_relveglength(j,i) = (BAA.result_veglength(j,i)/BAA.result_length(i)).*100;
        BAA.result_barelength(j,i) =...
            length(find(BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS &...
            BAA.ScN.result(i).year(j).Botlev>-BAA.input.Baarland_S250.veg_edge))*5;
    end
end

BAA.result_trans_relveglength = min(BAA.result_relveglength);
BAA.result_mm_trans_relveglength =...
    [min(BAA.result_trans_relveglength),max(BAA.result_trans_relveglength)];
BAA.result_mean_trans_relveglength =...
    mean(BAA.result_trans_relveglength);

BAA.ScN.result_matr_Hsig(BAA.ScN.result_matr_Hsig<0) = NaN;
BAA.ScN.result_matr_Hsig_MHWS(BAA.ScN.result_matr_Hsig_MHWS<0) = NaN;
BAA.ScN.result_matr_WA = (1-BAA.ScN.result_matr_Hsig./1.7200).*100;
BAA.ScN.result_matr_WA_MHWS =...
    (BAA.ScN.result_matr_Hsig_MLWS./1.7200-BAA.ScN.result_matr_Hsig_MHWS./1.7200).*100;
BAA.ScN.result_matr_WA_bar =...
    (BAA.ScN.result_matr_Hsig_MLWS./1.7200-BAA.ScN.result_matr_Hsig_vegedge./1.7200).*100;
BAA.ScN.result_matr_WA_veg =...
    (BAA.ScN.result_matr_Hsig_vegedge./1.7200-BAA.ScN.result_matr_Hsig_MHWS./1.7200).*100;
BAA.ScN.result_trans_WA = min(BAA.ScN.result_matr_WA_MHWS);
BAA.ScN.result_mm_WA = [min(BAA.ScN.result_trans_WA(1:3)),max(BAA.ScN.result_trans_WA(1:3))];
BAA.ScN.result_mean_WA = mean(BAA.ScN.result_trans_WA);

BAA.ScD.result_matr_Hsig(BAA.ScD.result_matr_Hsig<0) = NaN;
BAA.ScD.result_matr_Hsig_MHWS(BAA.ScD.result_matr_Hsig_MHWS<0) = NaN;
BAA.ScD.result_matr_WA = (1-BAA.ScD.result_matr_Hsig./0.2).*100;
BAA.ScD.result_matr_WA_MHWS =...
    (BAA.ScD.result_matr_Hsig_MLWS./0.2-BAA.ScD.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScD.result_matr_WA_bar =...
    (BAA.ScD.result_matr_Hsig_MLWS./0.2-BAA.ScD.result_matr_Hsig_vegedge./0.2).*100;
BAA.ScD.result_matr_WA_veg =...
    (BAA.ScD.result_matr_Hsig_vegedge./0.2-BAA.ScD.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScD.result_trans_WA = min(BAA.ScD.result_matr_WA_MHWS);
BAA.ScD.result_mm_WA = [min(BAA.ScD.result_trans_WA(1:3)),max(BAA.ScD.result_trans_WA(1:3))];
BAA.ScD.result_mean_WA = mean(BAA.ScD.result_trans_WA);

BAA.ScDV.result_matr_Hsig(BAA.ScDV.result_matr_Hsig<0) = NaN;
BAA.ScDV.result_matr_Hsig_MHWS(BAA.ScDV.result_matr_Hsig_MHWS<0) = NaN;
BAA.ScDV.result_matr_WA = (1-BAA.ScDV.result_matr_Hsig./0.2).*100;
BAA.ScDV.result_matr_WA_MHWS =...
    (BAA.ScDV.result_matr_Hsig_MLWS./0.2-BAA.ScDV.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScDV.result_matr_WA_bar =...
    (BAA.ScDV.result_matr_Hsig_MLWS./0.2-BAA.ScDV.result_matr_Hsig_vegedge./0.2).*100;
BAA.ScDV.result_matr_WA_veg =...
    (BAA.ScDV.result_matr_Hsig_vegedge./0.2-BAA.ScDV.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScDV.result_trans_WA = min(BAA.ScDV.result_matr_WA_MHWS);
BAA.ScDV.result_mm_WA = [min(BAA.ScDV.result_trans_WA(1:3)),max(BAA.ScDV.result_trans_WA(1:3))];
BAA.ScDV.result_mean_WA = mean(BAA.ScDV.result_trans_WA);

%---Zimmermanpolder--- #Transects=6 (5 effective) --- #Years=51 ---
ZIM.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Zimmermanpolder_S250\Zimmermanpolder_S250.mat')
ZIM.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Zimmermanpolder_S250\Zimmermanpolder_S250.mat');
ZIM.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Zimmermanpolder_S250\Zimmermanpolder_S250.mat');
ZIM.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Zimmermanpolder_S250.mat');

for i = 1:5
    ZIM.result_length(i) = length(ZIM.ScN.result(i).year(1).Hsig)*5;
    for j = 1:51
        ZIM.ScN.result_matr_Hsig(j,i) = min(ZIM.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1)
            ZIM.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1);
        else
            ZIM.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1))
            ZIM.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1));
        else
            ZIM.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1)
            ZIM.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1);
        else
            ZIM.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(end);
        end
        
        ZIM.ScD.result_matr_Hsig(j,i) = min(ZIM.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1)
            ZIM.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1);
        else
            ZIM.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1))
            ZIM.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1));
        else
            ZIM.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1)
            ZIM.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1);
        else
            ZIM.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(end);
        end
        
        ZIM.ScDV.result_matr_Hsig(j,i) = min(ZIM.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1)
            ZIM.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1);
        else
            ZIM.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1))
            ZIM.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1));
        else
            ZIM.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1)
            ZIM.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1);
        else
            ZIM.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(end);
        end
        ZIM.result_veglength(j,i) = nansum(ZIM.input.Zimmermanpolder_S250.Veg{i}(j,:))*5;
        ZIM.result_relveglength(j,i) = (ZIM.result_veglength(j,i)/ZIM.result_length(i)).*100;
        ZIM.result_barelength(j,i) =...
            length(find(ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS &...
            ZIM.ScN.result(i).year(j).Botlev>-ZIM.input.Zimmermanpolder_S250.veg_edge))*5;
    end
end

ZIM.result_trans_relveglength = min(ZIM.result_relveglength);
ZIM.result_mm_trans_relveglength =...
    [min(ZIM.result_trans_relveglength),max(ZIM.result_trans_relveglength)];
ZIM.result_mean_trans_relveglength =...
    mean(ZIM.result_trans_relveglength);

ZIM.ScN.result_matr_Hsig(ZIM.ScN.result_matr_Hsig<0) = NaN;
ZIM.ScN.result_matr_Hsig_MHWS(ZIM.ScN.result_matr_Hsig_MHWS<0) = NaN;
ZIM.ScN.result_matr_WA = (1-ZIM.ScN.result_matr_Hsig./1.8150).*100;
ZIM.ScN.result_matr_WA_MHWS =...
    (ZIM.ScN.result_matr_Hsig_MLWS./1.8150-ZIM.ScN.result_matr_Hsig_MHWS./1.8150).*100;
ZIM.ScN.result_matr_WA_bar =...
    (ZIM.ScN.result_matr_Hsig_MLWS./1.8150-ZIM.ScN.result_matr_Hsig_vegedge./1.8150).*100;
ZIM.ScN.result_matr_WA_veg =...
    (ZIM.ScN.result_matr_Hsig_vegedge./1.8150-ZIM.ScN.result_matr_Hsig_MHWS./1.8150).*100;
ZIM.ScN.result_trans_WA = min(ZIM.ScN.result_matr_WA_MHWS);
ZIM.ScN.result_mm_WA = [min(ZIM.ScN.result_trans_WA(1:5)),max(ZIM.ScN.result_trans_WA(1:5))];
ZIM.ScN.result_mean_WA = mean(ZIM.ScN.result_trans_WA);

ZIM.ScD.result_matr_Hsig(ZIM.ScD.result_matr_Hsig<0) = NaN;
ZIM.ScD.result_matr_Hsig_MHWS(ZIM.ScD.result_matr_Hsig_MHWS<0) = NaN;
ZIM.ScD.result_matr_WA = (1-ZIM.ScD.result_matr_Hsig./0.2).*100;
ZIM.ScD.result_matr_WA_MHWS =...
    (ZIM.ScD.result_matr_Hsig_MLWS./0.2-ZIM.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScD.result_matr_WA_bar =...
    (ZIM.ScD.result_matr_Hsig_MLWS./0.2-ZIM.ScD.result_matr_Hsig_vegedge./0.2).*100;
ZIM.ScD.result_matr_WA_veg =...
    (ZIM.ScD.result_matr_Hsig_vegedge./0.2-ZIM.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScD.result_trans_WA = min(ZIM.ScD.result_matr_WA_MHWS);
ZIM.ScD.result_mm_WA = [min(ZIM.ScD.result_trans_WA(1:5)),max(ZIM.ScD.result_trans_WA(1:5))];
ZIM.ScD.result_mean_WA = mean(ZIM.ScD.result_trans_WA);

ZIM.ScDV.result_matr_Hsig(ZIM.ScDV.result_matr_Hsig<0) = NaN;
ZIM.ScDV.result_matr_Hsig_MHWS(ZIM.ScDV.result_matr_Hsig_MHWS<0) = NaN;
ZIM.ScDV.result_matr_WA = (1-ZIM.ScDV.result_matr_Hsig./0.2).*100;
ZIM.ScDV.result_matr_WA_MHWS =...
    (ZIM.ScDV.result_matr_Hsig_MLWS./0.2-ZIM.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScDV.result_matr_WA_bar =...
    (ZIM.ScDV.result_matr_Hsig_MLWS./0.2-ZIM.ScDV.result_matr_Hsig_vegedge./0.2).*100;
ZIM.ScDV.result_matr_WA_veg =...
    (ZIM.ScDV.result_matr_Hsig_vegedge./0.2-ZIM.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScDV.result_trans_WA = min(ZIM.ScDV.result_matr_WA_MHWS);
ZIM.ScDV.result_mm_WA = [min(ZIM.ScDV.result_trans_WA(1:5)),max(ZIM.ScDV.result_trans_WA(1:5))];
ZIM.ScDV.result_mean_WA = mean(ZIM.ScDV.result_trans_WA);

%---Hoofdplaat--- #Transects=6 --- #Years=42 ---
HOO.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Hoofdplaat_S250\Hoofdplaat_S250.mat')
HOO.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Hoofdplaat_S250\Hoofdplaat_S250.mat');
HOO.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Hoofdplaat_S250\Hoofdplaat_S250.mat');
HOO.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Hoofdplaat_S250.mat');

for i = 1:6
    HOO.result_length(i) = length(HOO.ScN.result(i).year(1).Hsig)*5;
    for j = 1:42
        HOO.ScN.result_matr_Hsig(j,i) = min(HOO.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1)
            HOO.ScN.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1);
        else
            HOO.ScN.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1))
            HOO.ScN.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1));
        else
            HOO.ScN.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1)
            HOO.ScN.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1);
        else
            HOO.ScN.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(end);
        end
        
        HOO.ScD.result_matr_Hsig(j,i) = min(HOO.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1)
            HOO.ScD.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1);
        else
            HOO.ScD.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1))
            HOO.ScD.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1));
        else
            HOO.ScD.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1)
            HOO.ScD.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1);
        else
            HOO.ScD.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(end);
        end
        
        HOO.ScDV.result_matr_Hsig(j,i) = min(HOO.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1)
            HOO.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1);
        else
            HOO.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1))
            HOO.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1));
        else
            HOO.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1)
            HOO.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1);
        else
            HOO.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(end);
        end
        HOO.result_veglength(j,i) = nansum(HOO.input.Hoofdplaat_S250.Veg{i}(j,:))*5;
        HOO.result_relveglength(j,i) = (HOO.result_veglength(j,i)/HOO.result_length(i)).*100;
        HOO.result_barelength(j,i) =...
            length(find(HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS &...
            HOO.ScN.result(i).year(j).Botlev>-HOO.input.Hoofdplaat_S250.veg_edge))*5;
    end
end

HOO.result_trans_relveglength = min(HOO.result_relveglength);
HOO.result_mm_trans_relveglength =...
    [min(HOO.result_trans_relveglength),max(HOO.result_trans_relveglength)];
HOO.result_mean_trans_relveglength =...
    mean(HOO.result_trans_relveglength);

HOO.ScN.result_matr_Hsig(HOO.ScN.result_matr_Hsig<0) = NaN;
HOO.ScN.result_matr_Hsig_MHWS(HOO.ScN.result_matr_Hsig_MHWS<0) = NaN;
HOO.ScN.result_matr_WA = (1-HOO.ScN.result_matr_Hsig./2.3600).*100;
HOO.ScN.result_matr_WA_MHWS =...
    (HOO.ScN.result_matr_Hsig_MLWS./2.3600-HOO.ScN.result_matr_Hsig_MHWS./2.3600).*100;
HOO.ScN.result_matr_WA_bar =...
    (HOO.ScN.result_matr_Hsig_MLWS./2.3600-HOO.ScN.result_matr_Hsig_vegedge./2.3600).*100;
HOO.ScN.result_matr_WA_veg =...
    (HOO.ScN.result_matr_Hsig_vegedge./2.3600-HOO.ScN.result_matr_Hsig_MHWS./2.3600).*100;
HOO.ScN.result_trans_WA = min(HOO.ScN.result_matr_WA_MHWS);
HOO.ScN.result_mm_WA = [min(HOO.ScN.result_trans_WA),max(HOO.ScN.result_trans_WA)];
HOO.ScN.result_mean_WA = mean(HOO.ScN.result_trans_WA);

HOO.ScD.result_matr_Hsig(HOO.ScD.result_matr_Hsig<0) = NaN;
HOO.ScD.result_matr_Hsig_MHWS(HOO.ScD.result_matr_Hsig_MHWS<0) = NaN;
HOO.ScD.result_matr_WA = (1-HOO.ScD.result_matr_Hsig./0.2).*100;
HOO.ScD.result_matr_WA_MHWS =...
    (HOO.ScD.result_matr_Hsig_MLWS./0.2-HOO.ScD.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScD.result_matr_WA_bar =...
    (HOO.ScD.result_matr_Hsig_MLWS./0.2-HOO.ScD.result_matr_Hsig_vegedge./0.2).*100;
HOO.ScD.result_matr_WA_veg =...
    (HOO.ScD.result_matr_Hsig_vegedge./0.2-HOO.ScD.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScD.result_trans_WA = min(HOO.ScD.result_matr_WA_MHWS);
HOO.ScD.result_mm_WA = [min(HOO.ScD.result_trans_WA),max(HOO.ScD.result_trans_WA)];
HOO.ScD.result_mean_WA = mean(HOO.ScD.result_trans_WA);

HOO.ScDV.result_matr_Hsig(HOO.ScDV.result_matr_Hsig<0) = NaN;
HOO.ScDV.result_matr_Hsig_MHWS(HOO.ScDV.result_matr_Hsig_MHWS<0) = NaN;
HOO.ScDV.result_matr_WA = (1-HOO.ScDV.result_matr_Hsig./0.2).*100;
HOO.ScDV.result_matr_WA_MHWS =...
    (HOO.ScDV.result_matr_Hsig_MLWS./0.2-HOO.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScDV.result_matr_WA_bar =...
    (HOO.ScDV.result_matr_Hsig_MLWS./0.2-HOO.ScDV.result_matr_Hsig_vegedge./0.2).*100;
HOO.ScDV.result_matr_WA_veg =...
    (HOO.ScDV.result_matr_Hsig_vegedge./0.2-HOO.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScDV.result_trans_WA = min(HOO.ScDV.result_matr_WA_MHWS);
HOO.ScDV.result_mm_WA = [min(HOO.ScDV.result_trans_WA),max(HOO.ScDV.result_trans_WA)];
HOO.ScDV.result_mean_WA = mean(HOO.ScDV.result_trans_WA);

%---Paulinapolder--- #Transects=7 --- #Years=41 ---
PAU.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Paulinapolder_S250\Paulinapolder_S250.mat')
PAU.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Paulinapolder_S250\Paulinapolder_S250.mat');
PAU.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Paulinapolder_S250\Paulinapolder_S250.mat');
PAU.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Paulinapolder_S250.mat');

for i = 1:7
    PAU.result_length(i) = length(PAU.ScN.result(i).year(1).Hsig)*5;
    for j = 1:41
        PAU.ScN.result_matr_Hsig(j,i) = min(PAU.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1)
            PAU.ScN.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1);
        else
            PAU.ScN.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1))
            PAU.ScN.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1));
        else
            PAU.ScN.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1)
            PAU.ScN.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1);
        else
            PAU.ScN.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(end);
        end
        
        PAU.ScD.result_matr_Hsig(j,i) = min(PAU.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1)
            PAU.ScD.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1);
        else
            PAU.ScD.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1))
            PAU.ScD.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1));
        else
            PAU.ScD.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1)
            PAU.ScD.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1);
        else
            PAU.ScD.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(end);
        end
        
        PAU.ScDV.result_matr_Hsig(j,i) = min(PAU.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1)
            PAU.ScDV.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1);
        else
            PAU.ScDV.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1))
            PAU.ScDV.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1));
        else
            PAU.ScDV.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1)
            PAU.ScDV.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1);
        else
            PAU.ScDV.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(end);
        end
        PAU.result_veglength(j,i) = nansum(PAU.input.Paulinapolder_S250.Veg{i}(j,:))*5;
        PAU.result_relveglength(j,i) = (PAU.result_veglength(j,i)/PAU.result_length(i)).*100;
        PAU.result_barelength(j,i) =...
            length(find(PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS &...
            PAU.ScN.result(i).year(j).Botlev>-PAU.input.Paulinapolder_S250.veg_edge))*5;
    end
end

PAU.result_trans_relveglength = min(PAU.result_relveglength);
PAU.result_mm_trans_relveglength =...
    [min(PAU.result_trans_relveglength),max(PAU.result_trans_relveglength)];
PAU.result_mean_trans_relveglength =...
    mean(PAU.result_trans_relveglength);

PAU.ScN.result_matr_Hsig(PAU.ScN.result_matr_Hsig<0) = NaN;
PAU.ScN.result_matr_Hsig_MHWS(PAU.ScN.result_matr_Hsig_MHWS<0) = NaN;
PAU.ScN.result_matr_WA = (1-PAU.ScN.result_matr_Hsig./2.1450).*100;
PAU.ScN.result_matr_WA_MHWS =...
    (PAU.ScN.result_matr_Hsig_MLWS./2.1450-PAU.ScN.result_matr_Hsig_MHWS./2.1450).*100;
PAU.ScN.result_matr_WA_bar =...
    (PAU.ScN.result_matr_Hsig_MLWS./2.1450-PAU.ScN.result_matr_Hsig_vegedge./2.1450).*100;
PAU.ScN.result_matr_WA_veg =...
    (PAU.ScN.result_matr_Hsig_vegedge./2.1450-PAU.ScN.result_matr_Hsig_MHWS./2.1450).*100;
PAU.ScN.result_trans_WA = min(PAU.ScN.result_matr_WA_MHWS);
PAU.ScN.result_mm_WA = [min(PAU.ScN.result_trans_WA),max(PAU.ScN.result_trans_WA)];
PAU.ScN.result_mean_WA = mean(PAU.ScN.result_trans_WA);

PAU.ScD.result_matr_Hsig(PAU.ScD.result_matr_Hsig<0) = NaN;
PAU.ScD.result_matr_Hsig_MHWS(PAU.ScD.result_matr_Hsig_MHWS<0) = NaN;
PAU.ScD.result_matr_WA = (1-PAU.ScD.result_matr_Hsig./0.2).*100;
PAU.ScD.result_matr_WA_MHWS =...
    (PAU.ScD.result_matr_Hsig_MLWS./0.2-PAU.ScD.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScD.result_matr_WA_bar =...
    (PAU.ScD.result_matr_Hsig_MLWS./0.2-PAU.ScD.result_matr_Hsig_vegedge./0.2).*100;
PAU.ScD.result_matr_WA_veg =...
    (PAU.ScD.result_matr_Hsig_vegedge./0.2-PAU.ScD.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScD.result_trans_WA = min(PAU.ScD.result_matr_WA_MHWS);
PAU.ScD.result_mm_WA = [min(PAU.ScD.result_trans_WA),max(PAU.ScD.result_trans_WA)];
PAU.ScD.result_mean_WA = mean(PAU.ScD.result_trans_WA);

PAU.ScDV.result_matr_Hsig(PAU.ScDV.result_matr_Hsig<0) = NaN;
PAU.ScDV.result_matr_Hsig_MHWS(PAU.ScDV.result_matr_Hsig_MHWS<0) = NaN;
PAU.ScDV.result_matr_WA = (1-PAU.ScDV.result_matr_Hsig./0.2).*100;
PAU.ScDV.result_matr_WA_MHWS =...
    (PAU.ScDV.result_matr_Hsig_MLWS./0.2-PAU.ScDV.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScDV.result_matr_WA_MHWS(PAU.ScDV.result_matr_WA_MHWS==-9) = NaN;
PAU.ScDV.result_matr_WA_bar =...
    (PAU.ScDV.result_matr_Hsig_MLWS./0.2-PAU.ScDV.result_matr_Hsig_vegedge./0.2).*100;
PAU.ScDV.result_matr_WA_bar(PAU.ScDV.result_matr_WA_bar==-9) = NaN;
PAU.ScDV.result_matr_WA_veg =...
    (PAU.ScDV.result_matr_Hsig_vegedge./0.2-PAU.ScDV.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScDV.result_matr_WA_veg(PAU.ScDV.result_matr_WA_veg==-9) = NaN;
PAU.ScDV.result_trans_WA = min(PAU.ScDV.result_matr_WA_MHWS);
PAU.ScDV.result_mm_WA = [min(PAU.ScDV.result_trans_WA),max(PAU.ScDV.result_trans_WA)];
PAU.ScDV.result_mean_WA = mean(PAU.ScDV.result_trans_WA);

%---Hellegatpolder--- #Transects=6 --- #Years=52 ---
HEL.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Hellegatpolder_S250\Hellegatpolder_S250.mat')
HEL.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Hellegatpolder_S250\Hellegatpolder_S250.mat');
HEL.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Hellegatpolder_S250\Hellegatpolder_S250.mat');
HEL.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Hellegatpolder_S250.mat');

for i = 1:6
    HEL.result_length(i) = length(HEL.ScN.result(i).year(1).Hsig)*5;
    for j = 1:52
        HEL.ScN.result_matr_Hsig(j,i) = min(HEL.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1)
            HEL.ScN.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1);
        else
            HEL.ScN.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1))
            HEL.ScN.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1));
        else
            HEL.ScN.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1)
            HEL.ScN.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1);
        else
            HEL.ScN.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(end);
        end
        
        HEL.ScD.result_matr_Hsig(j,i) = min(HEL.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1)
            HEL.ScD.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1);
        else
            HEL.ScD.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1))
            HEL.ScD.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1));
        else
            HEL.ScD.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1)
            HEL.ScD.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1);
        else
            HEL.ScD.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(end);
        end
        
        HEL.ScDV.result_matr_Hsig(j,i) = min(HEL.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1)
            HEL.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1);
        else
            HEL.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1))
            HEL.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1));
        else
            HEL.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1)
            HEL.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1);
        else
            HEL.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(end);
        end
        HEL.result_veglength(j,i) = nansum(HEL.input.Hellegatpolder_S250.Veg{i}(j,:))*5;
        HEL.result_relveglength(j,i) = (HEL.result_veglength(j,i)/HEL.result_length(i)).*100;
        HEL.result_barelength(j,i) =...
            length(find(HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS &...
            HEL.ScN.result(i).year(j).Botlev>-HEL.input.Hellegatpolder_S250.veg_edge))*5;
    end
end

HEL.result_trans_relveglength = min(HEL.result_relveglength);
HEL.result_mm_trans_relveglength =...
    [min(HEL.result_trans_relveglength),max(HEL.result_trans_relveglength)];
HEL.result_mean_trans_relveglength =...
    mean(HEL.result_trans_relveglength);

HEL.ScN.result_matr_Hsig(HEL.ScN.result_matr_Hsig<0) = NaN;
HEL.ScN.result_matr_Hsig_MHWS(HEL.ScN.result_matr_Hsig_MHWS<0) = NaN;
HEL.ScN.result_matr_WA = (1-HEL.ScN.result_matr_Hsig./2.6500).*100;
HEL.ScN.result_matr_WA_MHWS =...
    (HEL.ScN.result_matr_Hsig_MLWS./2.6500-HEL.ScN.result_matr_Hsig_MHWS./2.6500).*100;
HEL.ScN.result_matr_WA_bar =...
    (HEL.ScN.result_matr_Hsig_MLWS./2.6500-HEL.ScN.result_matr_Hsig_vegedge./2.6500).*100;
HEL.ScN.result_matr_WA_veg =...
    (HEL.ScN.result_matr_Hsig_vegedge./2.6500-HEL.ScN.result_matr_Hsig_MHWS./2.6500).*100;
HEL.ScN.result_trans_WA = min(HEL.ScN.result_matr_WA_MHWS);
HEL.ScN.result_mm_WA = [min(HEL.ScN.result_trans_WA),max(HEL.ScN.result_trans_WA)];
HEL.ScN.result_mean_WA = mean(HEL.ScN.result_trans_WA);

HEL.ScD.result_matr_Hsig(HEL.ScD.result_matr_Hsig<0) = NaN;
HEL.ScD.result_matr_Hsig_MHWS(HEL.ScD.result_matr_Hsig_MHWS<0) = NaN;
HEL.ScD.result_matr_WA = (1-HEL.ScD.result_matr_Hsig./0.2).*100;
HEL.ScD.result_matr_WA_MHWS =...
    (HEL.ScD.result_matr_Hsig_MLWS./0.2-HEL.ScD.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScD.result_matr_WA_bar =...
    (HEL.ScD.result_matr_Hsig_MLWS./0.2-HEL.ScD.result_matr_Hsig_vegedge./0.2).*100;
HEL.ScD.result_matr_WA_veg =...
    (HEL.ScD.result_matr_Hsig_vegedge./0.2-HEL.ScD.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScD.result_trans_WA = min(HEL.ScD.result_matr_WA_MHWS);
HEL.ScD.result_mm_WA = [min(HEL.ScD.result_trans_WA),max(HEL.ScD.result_trans_WA)];
HEL.ScD.result_mean_WA = mean(HEL.ScD.result_trans_WA);

HEL.ScDV.result_matr_Hsig(HEL.ScDV.result_matr_Hsig<0) = NaN;
HEL.ScDV.result_matr_Hsig_MHWS(HEL.ScDV.result_matr_Hsig_MHWS<0) = NaN;
HEL.ScDV.result_matr_WA = (1-HEL.ScDV.result_matr_Hsig./0.2).*100;
HEL.ScDV.result_matr_WA_MHWS =...
    (HEL.ScDV.result_matr_Hsig_MLWS./0.2-HEL.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScDV.result_matr_WA_bar =...
    (HEL.ScDV.result_matr_Hsig_MLWS./0.2-HEL.ScDV.result_matr_Hsig_vegedge./0.2).*100;
HEL.ScDV.result_matr_WA_veg =...
    (HEL.ScDV.result_matr_Hsig_vegedge./0.2-HEL.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScDV.result_trans_WA = min(HEL.ScDV.result_matr_WA_MHWS);
HEL.ScDV.result_mm_WA = [min(HEL.ScDV.result_trans_WA),max(HEL.ScDV.result_trans_WA)];
HEL.ScDV.result_mean_WA = mean(HEL.ScDV.result_trans_WA);

ZUI.ScN.result_matr_WA(isnan(ZUI.ScN.result_matr_WA)) = 100;
BAA.ScN.result_matr_WA(isnan(BAA.ScN.result_matr_WA)) = 100;
ZIM.ScN.result_matr_WA(isnan(ZIM.ScN.result_matr_WA)) = 100;
HOO.ScN.result_matr_WA(isnan(HOO.ScN.result_matr_WA)) = 100;
PAU.ScN.result_matr_WA(isnan(PAU.ScN.result_matr_WA)) = 100;
HEL.ScN.result_matr_WA(isnan(HEL.ScN.result_matr_WA)) = 100;

%% Manuscript Figure 7
name = 'MS_Fig7';
addpath('C:\Checkouts\OET\general\color_fun\colormaps\');
YLs = [0,11];
XLs = [1949,2015];
n_bins = 101;

bf = 20;
hf = 30;
SP_PosW = 1.15;
SP_PosH = 1.1;
cont_col = [0.45,0.45,0.45];
X_txt = 1960;
Y_txt = 10.5;

prep_cmap = flipud(colormapcmr(20));
prep_cmap2 = [prep_cmap(4,:);prep_cmap(8,:);prep_cmap(10,:);prep_cmap(10,:);...
prep_cmap(12,:);prep_cmap(12,:);prep_cmap(12,:);prep_cmap(12,:);...
prep_cmap(16,:);prep_cmap(16,:);prep_cmap(16,:);prep_cmap(16,:);...
prep_cmap(20,:);prep_cmap(20,:);prep_cmap(20,:);prep_cmap(20,:)]

MS_Fig7 = figure;

% --- ZUI VEG -----------------------------------------------------
SP1 = subplot(4,4,1)
colormap(prep_cmap2)
S1 = surf(repmat(year(ZUI.input.Zuidgors_S250.T{1,1}),1,10),...
repmat([0.5:1:9.5],37,1),...
[ZUI.ScN.result_matr_WA_veg ZUI.ScN.result_matr_WA_veg(:,end)]);
hold on;
view(2)

set(S1,'edgecolor','none')

plot3(repmat(XLs'+1,1,9),repmat(0.5:1:8.5,2,1),repmat(1000,2,9),...
'-w','linewidth',2)
 
text(X_txt,Y_txt,200,'ZUI veg.','color','r');
axis([XLs,YLs])
caxis([0,40])
SP1.Position(3) = SP1.Position(3) * SP_PosW;
SP1.Position(4) = SP1.Position(4) * SP_PosH;
grid off
set(SP1,'xticklabel',[],'ytick',[1:9])

% --- BAA VEG -----------------------------------------------------
SP2 = subplot(4,4,2)
colormap(prep_cmap2)
S2 = surf(repmat(year(BAA.input.Baarland_S250.T{1,1}),1,4),...
repmat([0.5:1:3.5],37,1),...
[BAA.ScN.result_matr_WA_veg BAA.ScN.result_matr_WA_veg(:,end)]);
hold on;
view(2)

set(S2,'edgecolor','none')
 
plot3(repmat(XLs'+1,1,9),repmat(0.5:1:8.5,2,1),repmat(1000,2,9),...
'-w','linewidth',2)
 
text(X_txt,Y_txt,200,'BAA veg.','color','r');
axis([XLs,YLs])
caxis([0,40])
SP2.Position(3) = SP2.Position(3) * SP_PosW;
SP2.Position(4) = SP2.Position(4) * SP_PosH;
grid off
set(SP2,'xticklabel',[],'ytick',[1:9],'yticklabel',[])

% --- ZIM VEG -----------------------------------------------------
SP3 = subplot(4,4,3)
colormap(prep_cmap2)
S3 = surf(repmat(year(ZIM.input.Zimmermanpolder_S250.T{1,1}),1,6),...
repmat([0.5:1:5.5],51,1),...
[ZIM.ScN.result_matr_WA_veg ZIM.ScN.result_matr_WA_veg(:,end)]);
hold on;
view(2)

set(S3,'edgecolor','none')

plot3(repmat(XLs'+1,1,9),repmat(0.5:1:8.5,2,1),repmat(1000,2,9),...
'-w','linewidth',2)
 
text(X_txt,Y_txt,200,'ZIM veg.','color','r');
axis([XLs,YLs])
caxis([0,40])
SP3.Position(3) = SP3.Position(3) * SP_PosW;
SP3.Position(4) = SP3.Position(4) * SP_PosH;
grid off
set(SP3,'xticklabel',[],'ytick',[1:9],'yticklabel',[])

% --- HOO VEG -----------------------------------------------------
SP4 = subplot(4,4,9)
colormap(prep_cmap2)
S4 = surf(repmat(year(HOO.input.Hoofdplaat_S250.T{1,1}),1,7),...
repmat([0.5:1:6.5],42,1),...
[HOO.ScN.result_matr_WA_veg HOO.ScN.result_matr_WA_veg(:,end)]);
hold on;
view(2)

set(S4,'edgecolor','none')
 
plot3(repmat(XLs'+1,1,9),repmat(0.5:1:8.5,2,1),repmat(1000,2,9),...
'-w','linewidth',2)
 
text(X_txt,Y_txt,200,'HOO veg.');
axis([XLs,YLs])
caxis([0,40])
SP4.Position(3) = SP4.Position(3) * SP_PosW;
SP4.Position(4) = SP4.Position(4) * SP_PosH;
grid off
set(SP4,'xticklabel',[],'ytick',[1:9])
ylabel('                                       # transect (-)')

% --- PAU VEG -----------------------------------------------------
SP5 = subplot(4,4,10)
colormap(prep_cmap2)
S5 = surf(repmat(year(PAU.input.Paulinapolder_S250.T{1,1}),1,8),...
repmat([0.5:1:7.5],41,1),...
[PAU.ScN.result_matr_WA_veg PAU.ScN.result_matr_WA_veg(:,end)]);
hold on;
view(2)
set(S5,'edgecolor','none')

plot3(repmat(XLs'+1,1,9),repmat(0.5:1:8.5,2,1),repmat(1000,2,9),...
'-w','linewidth',2)
 
text(X_txt,Y_txt,200,'PAU veg.');
axis([XLs,YLs])
caxis([0,40])
SP5.Position(3) = SP5.Position(3) * SP_PosW;
SP5.Position(4) = SP5.Position(4) * SP_PosH;
grid off
set(SP5,'xticklabel',[],'ytick',[1:9],'yticklabel',[])

% --- HEL VEG -----------------------------------------------------
SP6 = subplot(4,4,11)
colormap(prep_cmap2)
S6 = surf(repmat(year(HEL.input.Hellegatpolder_S250.T{1,1}),1,7),...
repmat([0.5:1:6.5],52,1),...
[HEL.ScN.result_matr_WA_veg HEL.ScN.result_matr_WA_veg(:,end)]);
hold on;
view(2)
set(S6,'edgecolor','none')

plot3(repmat(XLs'+1,1,9),repmat(0.5:1:8.5,2,1),repmat(1000,2,9),...
'-w','linewidth',2)
 
text(X_txt,Y_txt,200,'HEL veg.');
axis([XLs,YLs])
caxis([0,40])
SP6.Position(3) = SP6.Position(3) * SP_PosW;
SP6.Position(4) = SP6.Position(4) * SP_PosH;
grid off
set(SP6,'xticklabel',[],'ytick',[1:9],'yticklabel',[])

% -----------------------------------------------------------------
% --- ZUI TOT -----------------------------------------------------
SP7 = subplot(4,4,5)
colormap(prep_cmap2)
S7 = surf(repmat(year(ZUI.input.Zuidgors_S250.T{1,1}),1,10),...
repmat([0.5:1:9.5],37,1),...
[ZUI.ScN.result_matr_WA_veg+ZUI.ScN.result_matr_WA_bar ...
ZUI.ScN.result_matr_WA_veg(:,end)+ZUI.ScN.result_matr_WA_bar(:,end)]);
hold on;
view(2)
set(S7,'edgecolor','none')
 
plot3(repmat(XLs'+1,1,9),repmat(0.5:1:8.5,2,1),repmat(1000,2,9),...
'-w','linewidth',2)
 
text(X_txt,Y_txt,200,'ZUI','color','r');
axis([XLs,YLs])
caxis([0,40])
SP7.Position(3) = SP7.Position(3) * SP_PosW;
SP7.Position(4) = SP7.Position(4) * SP_PosH;
grid off
set(SP7,'xticklabel',[],'ytick',[1:9])


% --- BAA VEG -----------------------------------------------------
SP8 = subplot(4,4,6)
colormap(prep_cmap2)
S8 = surf(repmat(year(BAA.input.Baarland_S250.T{1,1}),1,4),...
repmat([0.5:1:3.5],37,1),...
[BAA.ScN.result_matr_WA_veg+BAA.ScN.result_matr_WA_bar ...
BAA.ScN.result_matr_WA_veg(:,end)+BAA.ScN.result_matr_WA_bar(:,end)]);
hold on;
view(2)
set(S8,'edgecolor','none')
 
plot3(repmat(XLs'+1,1,9),repmat(0.5:1:8.5,2,1),repmat(1000,2,9),...
'-w','linewidth',2)
 
text(X_txt,Y_txt,200,'BAA','color','r');
axis([XLs,YLs])
caxis([0,40])
SP8.Position(3) = SP8.Position(3) * SP_PosW;
SP8.Position(4) = SP8.Position(4) * SP_PosH;
grid off
set(SP8,'xticklabel',[],'ytick',[1:9],'yticklabel',[])

% --- ZIM VEG -----------------------------------------------------
SP9 = subplot(4,4,7)
colormap(prep_cmap2)
S9 = surf(repmat(year(ZIM.input.Zimmermanpolder_S250.T{1,1}),1,6),...
repmat([0.5:1:5.5],51,1),...
[ZIM.ScN.result_matr_WA_veg+ZIM.ScN.result_matr_WA_bar ...
ZIM.ScN.result_matr_WA_veg(:,end)+ZIM.ScN.result_matr_WA_bar(:,end)]);
hold on;
view(2)
set(S9,'edgecolor','none')
 
plot3(repmat(XLs'+1,1,9),repmat(0.5:1:8.5,2,1),repmat(1000,2,9),...
'-w','linewidth',2)
 
text(X_txt,Y_txt,200,'ZIM','color','r');
axis([XLs,YLs])
caxis([0,40])
SP9.Position(3) = SP9.Position(3) * SP_PosW;
SP9.Position(4) = SP9.Position(4) * SP_PosH;
grid off
set(SP9,'xticklabel',[],'ytick',[1:9],'yticklabel',[])

% --- HOO VEG -----------------------------------------------------
SP10 = subplot(4,4,13)
colormap(prep_cmap2)
S10 = surf(repmat(year(HOO.input.Hoofdplaat_S250.T{1,1}),1,7),...
repmat([0.5:1:6.5],42,1),...
[HOO.ScN.result_matr_WA_veg+HOO.ScN.result_matr_WA_bar ...
HOO.ScN.result_matr_WA_veg(:,end)+HOO.ScN.result_matr_WA_bar(:,end)]);
hold on;
view(2)
set(S10,'edgecolor','none')
 
plot3(repmat(XLs'+1,1,9),repmat(0.5:1:8.5,2,1),repmat(1000,2,9),...
'-w','linewidth',2)
 
text(X_txt,Y_txt,200,'HOO');
axis([XLs,YLs])
caxis([0,40])
SP10.Position(3) = SP10.Position(3) * SP_PosW;
SP10.Position(4) = SP10.Position(4) * SP_PosH;
grid off
set(SP10,'ytick',[1:9])

% --- PAU VEG -----------------------------------------------------
SP11 = subplot(4,4,14)
colormap(prep_cmap2)
S11 = surf(repmat(year(PAU.input.Paulinapolder_S250.T{1,1}),1,8),...
repmat([0.5:1:7.5],41,1),...
[PAU.ScN.result_matr_WA_veg+PAU.ScN.result_matr_WA_bar ...
PAU.ScN.result_matr_WA_veg(:,end)+PAU.ScN.result_matr_WA_bar(:,end)]);
hold on;
view(2)
set(S11,'edgecolor','none')

plot3(repmat(XLs'+1,1,9),repmat(0.5:1:8.5,2,1),repmat(1000,2,9),...
'-w','linewidth',2)
 
text(X_txt,Y_txt,200,'PAU');
axis([XLs,YLs])
caxis([0,40])
SP11.Position(3) = SP11.Position(3) * SP_PosW;
SP11.Position(4) = SP11.Position(4) * SP_PosH;
grid off
set(SP11,'ytick',[1:9],'yticklabel',[])
xlabel('time (year)')

% --- HEL VEG -----------------------------------------------------
SP12 = subplot(4,4,15)
colormap(prep_cmap2)
S12 = surf(repmat(year(HEL.input.Hellegatpolder_S250.T{1,1}),1,7),...
repmat([0.5:1:6.5],52,1),...
[HEL.ScN.result_matr_WA_veg+HEL.ScN.result_matr_WA_bar ...
HEL.ScN.result_matr_WA_veg(:,end)+HEL.ScN.result_matr_WA_bar(:,end)]);
hold on;
view(2)
set(S12,'edgecolor','none')
 
plot3(repmat(XLs'+1,1,9),repmat(0.5:1:8.5,2,1),repmat(1000,2,9),...
'-w','linewidth',2)
 
text(X_txt,Y_txt,200,'HEL');
axis([XLs,YLs])
caxis([0,40])
SP12.Position(3) = SP12.Position(3) * SP_PosW;
SP12.Position(4) = SP12.Position(4) * SP_PosH;
grid off
set(SP12,'ytick',[1:9],'yticklabel',[])

% --- LEGEND ------------------------------------------------------
subplot(4,4,[4,8,12,16])
colormap(prep_cmap2)
CB = colorbar;
CB.Position(1) = CB.Position(1) - 0.03;
CB.Position(2) = SP12.Position(2);
CB.Position(3) = 0.05;
CB.Position(4) = SP3.Position(2)+SP3.Position(4)-SP12.Position(2);
caxis([0,40])
ylabel(CB, 'wave attenuation (%)');
set(CB,'yaxislocation','right','ticks',[0,2.5,5,10,20,30,40])
axis off

MS_Fig7.Position(4) = 700;
figuurdimensies(bf,hf)
cd M:\Documents\PhD\Scripts\MATLAB\Chapter1\altmany-export_fig-412662f
%export_fig MS_Fig7 -deps -r864 -transparent -p1

