%% Analyse wave attenuation data of all foreshores in the Westerschelde based on Vaklodingen and SWAN analysis
close all; clear all; clc;

%% Load and summarize data
addpath('M:\Documents\PhD\Scripts\MATLAB\Chapter1');

%---Zuidgors--- #Transects=11 (9 effective) --- #Years=37 ---
ZUI.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Zuidgors_S250\Zuidgors_S250.mat')
ZUI.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Zuidgors_S250\Zuidgors_S250.mat');
ZUI.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Zuidgors_S250\Zuidgors_S250.mat');
ZUI.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Zuidgors_S250.mat');

for i = 1:9
    ZUI.result_length(i) = length(ZUI.ScN.result(i).year(1).Hsig)*5;
    for j = 1:37
        ZUI.ScN.result_matr_Hsig(j,i) = min(ZUI.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1)
            ZUI.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1);
        else
            ZUI.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1))
            ZUI.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1));
        else
            ZUI.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1)
            ZUI.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1);
        else
            ZUI.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(end);
        end
        
        ZUI.ScD.result_matr_Hsig(j,i) = min(ZUI.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1)
            ZUI.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1);
        else
            ZUI.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1))
            ZUI.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1));
        else
            ZUI.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1)
            ZUI.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1);
        else
            ZUI.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(end);
        end
        
        ZUI.ScDV.result_matr_Hsig(j,i) = min(ZUI.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1)
            ZUI.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1);
        else
            ZUI.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1))
            ZUI.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1));
        else
            ZUI.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1)
            ZUI.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1);
        else
            ZUI.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(end);
        end
        
        ZUI.result_veglength(j,i) = nansum(ZUI.input.Zuidgors_S250.Veg{i}(j,:))*5;
        ZUI.result_relveglength(j,i) = (ZUI.result_veglength(j,i)/ZUI.result_length(i)).*100;
        ZUI.result_barelength(j,i) =...
            length(find(ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS &...
            ZUI.ScN.result(i).year(j).Botlev>-ZUI.input.Zuidgors_S250.veg_edge))*5;
    end
end

ZUI.result_trans_relveglength = min(ZUI.result_relveglength);
ZUI.result_mm_trans_relveglength =...
    [min(ZUI.result_trans_relveglength),max(ZUI.result_trans_relveglength)];
ZUI.result_mean_trans_relveglength =...
    mean(ZUI.result_trans_relveglength);

ZUI.ScN.result_matr_Hsig(ZUI.ScN.result_matr_Hsig<0) = 0;
ZUI.ScN.result_matr_Hsig_MHWS(ZUI.ScN.result_matr_Hsig_MHWS<0) = 0;
ZUI.ScN.result_matr_WA = (1-ZUI.ScN.result_matr_Hsig./1.6550).*100;
ZUI.ScN.result_matr_WA_MHWS =...
    (ZUI.ScN.result_matr_Hsig_MLWS./1.6550-ZUI.ScN.result_matr_Hsig_MHWS./1.6550).*100;
ZUI.ScN.result_matr_WA_bar =...
    (ZUI.ScN.result_matr_Hsig_MLWS./1.6550-ZUI.ScN.result_matr_Hsig_vegedge./1.6550).*100;
ZUI.ScN.result_matr_WA_veg =...
    (ZUI.ScN.result_matr_Hsig_vegedge./1.6550-ZUI.ScN.result_matr_Hsig_MHWS./1.6550).*100;
ZUI.ScN.result_trans_WA = min(ZUI.ScN.result_matr_WA_MHWS);
ZUI.ScN.result_mm_WA = [min(ZUI.ScN.result_trans_WA),max(ZUI.ScN.result_trans_WA)];
ZUI.ScN.result_mean_WA = mean(ZUI.ScN.result_trans_WA);

ZUI.ScD.result_matr_Hsig(ZUI.ScD.result_matr_Hsig<0) = 0;
ZUI.ScD.result_matr_Hsig_MHWS(ZUI.ScD.result_matr_Hsig_MHWS<0) = 0;
ZUI.ScD.result_matr_WA = (1-ZUI.ScD.result_matr_Hsig./0.2).*100;
ZUI.ScD.result_matr_WA_MHWS =...
    (ZUI.ScD.result_matr_Hsig_MLWS./0.2-ZUI.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScD.result_matr_WA_bar =...
    (ZUI.ScD.result_matr_Hsig_MLWS./0.2-ZUI.ScD.result_matr_Hsig_vegedge./0.2).*100;
ZUI.ScD.result_matr_WA_veg =...
    (ZUI.ScD.result_matr_Hsig_vegedge./0.2-ZUI.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScD.result_trans_WA = nanmin(ZUI.ScD.result_matr_WA_MHWS);
ZUI.ScD.result_mm_WA = [min(ZUI.ScD.result_trans_WA),max(ZUI.ScD.result_trans_WA)];
ZUI.ScD.result_mean_WA = nanmean(ZUI.ScD.result_trans_WA);

ZUI.ScDV.result_matr_Hsig(ZUI.ScDV.result_matr_Hsig<0) = 0;
ZUI.ScDV.result_matr_Hsig_MHWS(ZUI.ScDV.result_matr_Hsig_MHWS<0) = 0;
ZUI.ScDV.result_matr_WA = (1-ZUI.ScDV.result_matr_Hsig./0.2).*100;
ZUI.ScDV.result_matr_WA_MHWS =...
    (ZUI.ScDV.result_matr_Hsig_MLWS./0.2-ZUI.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScDV.result_matr_WA_bar =...
    (ZUI.ScDV.result_matr_Hsig_MLWS./0.2-ZUI.ScDV.result_matr_Hsig_vegedge./0.2).*100;
ZUI.ScDV.result_matr_WA_veg =...
    (ZUI.ScDV.result_matr_Hsig_vegedge./0.2-ZUI.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScDV.result_trans_WA = nanmin(ZUI.ScDV.result_matr_WA_MHWS);
ZUI.ScDV.result_mm_WA = [min(ZUI.ScDV.result_trans_WA),max(ZUI.ScDV.result_trans_WA)];
ZUI.ScDV.result_mean_WA = nanmean(ZUI.ScDV.result_trans_WA);

%---Baarland--- #Transects=7 (3 effective) --- #Years=37 ---
BAA.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Baarland_S250\Baarland_S250.mat')
BAA.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Baarland_S250\Baarland_S250.mat');
BAA.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Baarland_S250\Baarland_S250.mat');
BAA.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Baarland_S250.mat');

for i = 1:3
    BAA.result_length(i) = length(BAA.ScN.result(i).year(1).Hsig)*5;
    for j = 1:37
        BAA.ScN.result_matr_Hsig(j,i) = min(BAA.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1)
            BAA.ScN.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1);
        else
            BAA.ScN.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1))
            BAA.ScN.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1));
        else
            BAA.ScN.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1)
            BAA.ScN.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1);
        else
            BAA.ScN.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(end);
        end
        
        BAA.ScD.result_matr_Hsig(j,i) = min(BAA.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1)
            BAA.ScD.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1);
        else
            BAA.ScD.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1))
            BAA.ScD.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1));
        else
            BAA.ScD.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1)
            BAA.ScD.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1);
        else
            BAA.ScD.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(end);
        end
        
        BAA.ScDV.result_matr_Hsig(j,i) = min(BAA.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1)
            BAA.ScDV.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1);
        else
            BAA.ScDV.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1))
            BAA.ScDV.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1));
        else
            BAA.ScDV.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1)
            BAA.ScDV.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1);
        else
            BAA.ScDV.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(end);
        end
        BAA.result_veglength(j,i) = nansum(BAA.input.Baarland_S250.Veg{i}(j,:))*5;
        BAA.result_relveglength(j,i) = (BAA.result_veglength(j,i)/BAA.result_length(i)).*100;
        BAA.result_barelength(j,i) =...
            length(find(BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS &...
            BAA.ScN.result(i).year(j).Botlev>-BAA.input.Baarland_S250.veg_edge))*5;
    end
end

BAA.result_trans_relveglength = min(BAA.result_relveglength);
BAA.result_mm_trans_relveglength =...
    [min(BAA.result_trans_relveglength),max(BAA.result_trans_relveglength)];
BAA.result_mean_trans_relveglength =...
    mean(BAA.result_trans_relveglength);

BAA.ScN.result_matr_Hsig(BAA.ScN.result_matr_Hsig<0) = NaN;
BAA.ScN.result_matr_Hsig_MHWS(BAA.ScN.result_matr_Hsig_MHWS<0) = NaN;
BAA.ScN.result_matr_WA = (1-BAA.ScN.result_matr_Hsig./1.7200).*100;
BAA.ScN.result_matr_WA_MHWS =...
    (BAA.ScN.result_matr_Hsig_MLWS./1.7200-BAA.ScN.result_matr_Hsig_MHWS./1.7200).*100;
BAA.ScN.result_matr_WA_bar =...
    (BAA.ScN.result_matr_Hsig_MLWS./1.7200-BAA.ScN.result_matr_Hsig_vegedge./1.7200).*100;
BAA.ScN.result_matr_WA_veg =...
    (BAA.ScN.result_matr_Hsig_vegedge./1.7200-BAA.ScN.result_matr_Hsig_MHWS./1.7200).*100;
BAA.ScN.result_trans_WA = min(BAA.ScN.result_matr_WA_MHWS);
BAA.ScN.result_mm_WA = [min(BAA.ScN.result_trans_WA(1:3)),max(BAA.ScN.result_trans_WA(1:3))];
BAA.ScN.result_mean_WA = mean(BAA.ScN.result_trans_WA);

BAA.ScD.result_matr_Hsig(BAA.ScD.result_matr_Hsig<0) = NaN;
BAA.ScD.result_matr_Hsig_MHWS(BAA.ScD.result_matr_Hsig_MHWS<0) = NaN;
BAA.ScD.result_matr_WA = (1-BAA.ScD.result_matr_Hsig./0.2).*100;
BAA.ScD.result_matr_WA_MHWS =...
    (BAA.ScD.result_matr_Hsig_MLWS./0.2-BAA.ScD.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScD.result_matr_WA_bar =...
    (BAA.ScD.result_matr_Hsig_MLWS./0.2-BAA.ScD.result_matr_Hsig_vegedge./0.2).*100;
BAA.ScD.result_matr_WA_veg =...
    (BAA.ScD.result_matr_Hsig_vegedge./0.2-BAA.ScD.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScD.result_trans_WA = min(BAA.ScD.result_matr_WA_MHWS);
BAA.ScD.result_mm_WA = [min(BAA.ScD.result_trans_WA(1:3)),max(BAA.ScD.result_trans_WA(1:3))];
BAA.ScD.result_mean_WA = mean(BAA.ScD.result_trans_WA);

BAA.ScDV.result_matr_Hsig(BAA.ScDV.result_matr_Hsig<0) = NaN;
BAA.ScDV.result_matr_Hsig_MHWS(BAA.ScDV.result_matr_Hsig_MHWS<0) = NaN;
BAA.ScDV.result_matr_WA = (1-BAA.ScDV.result_matr_Hsig./0.2).*100;
BAA.ScDV.result_matr_WA_MHWS =...
    (BAA.ScDV.result_matr_Hsig_MLWS./0.2-BAA.ScDV.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScDV.result_matr_WA_bar =...
    (BAA.ScDV.result_matr_Hsig_MLWS./0.2-BAA.ScDV.result_matr_Hsig_vegedge./0.2).*100;
BAA.ScDV.result_matr_WA_veg =...
    (BAA.ScDV.result_matr_Hsig_vegedge./0.2-BAA.ScDV.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScDV.result_trans_WA = min(BAA.ScDV.result_matr_WA_MHWS);
BAA.ScDV.result_mm_WA = [min(BAA.ScDV.result_trans_WA(1:3)),max(BAA.ScDV.result_trans_WA(1:3))];
BAA.ScDV.result_mean_WA = mean(BAA.ScDV.result_trans_WA);

%---Zimmermanpolder--- #Transects=6 (5 effective) --- #Years=51 ---
ZIM.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Zimmermanpolder_S250\Zimmermanpolder_S250.mat')
ZIM.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Zimmermanpolder_S250\Zimmermanpolder_S250.mat');
ZIM.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Zimmermanpolder_S250\Zimmermanpolder_S250.mat');
ZIM.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Zimmermanpolder_S250.mat');

for i = 1:5
    ZIM.result_length(i) = length(ZIM.ScN.result(i).year(1).Hsig)*5;
    for j = 1:51
        ZIM.ScN.result_matr_Hsig(j,i) = min(ZIM.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1)
            ZIM.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1);
        else
            ZIM.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1))
            ZIM.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1));
        else
            ZIM.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1)
            ZIM.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1);
        else
            ZIM.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(end);
        end
        
        ZIM.ScD.result_matr_Hsig(j,i) = min(ZIM.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1)
            ZIM.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1);
        else
            ZIM.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1))
            ZIM.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1));
        else
            ZIM.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1)
            ZIM.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1);
        else
            ZIM.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(end);
        end
        
        ZIM.ScDV.result_matr_Hsig(j,i) = min(ZIM.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1)
            ZIM.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1);
        else
            ZIM.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1))
            ZIM.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1));
        else
            ZIM.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1)
            ZIM.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1);
        else
            ZIM.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(end);
        end
        ZIM.result_veglength(j,i) = nansum(ZIM.input.Zimmermanpolder_S250.Veg{i}(j,:))*5;
        ZIM.result_relveglength(j,i) = (ZIM.result_veglength(j,i)/ZIM.result_length(i)).*100;
        ZIM.result_barelength(j,i) =...
            length(find(ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS &...
            ZIM.ScN.result(i).year(j).Botlev>-ZIM.input.Zimmermanpolder_S250.veg_edge))*5;
    end
end

ZIM.result_trans_relveglength = min(ZIM.result_relveglength);
ZIM.result_mm_trans_relveglength =...
    [min(ZIM.result_trans_relveglength),max(ZIM.result_trans_relveglength)];
ZIM.result_mean_trans_relveglength =...
    mean(ZIM.result_trans_relveglength);

ZIM.ScN.result_matr_Hsig(ZIM.ScN.result_matr_Hsig<0) = NaN;
ZIM.ScN.result_matr_Hsig_MHWS(ZIM.ScN.result_matr_Hsig_MHWS<0) = NaN;
ZIM.ScN.result_matr_WA = (1-ZIM.ScN.result_matr_Hsig./1.8150).*100;
ZIM.ScN.result_matr_WA_MHWS =...
    (ZIM.ScN.result_matr_Hsig_MLWS./1.8150-ZIM.ScN.result_matr_Hsig_MHWS./1.8150).*100;
ZIM.ScN.result_matr_WA_bar =...
    (ZIM.ScN.result_matr_Hsig_MLWS./1.8150-ZIM.ScN.result_matr_Hsig_vegedge./1.8150).*100;
ZIM.ScN.result_matr_WA_veg =...
    (ZIM.ScN.result_matr_Hsig_vegedge./1.8150-ZIM.ScN.result_matr_Hsig_MHWS./1.8150).*100;
ZIM.ScN.result_trans_WA = min(ZIM.ScN.result_matr_WA_MHWS);
ZIM.ScN.result_mm_WA = [min(ZIM.ScN.result_trans_WA(1:5)),max(ZIM.ScN.result_trans_WA(1:5))];
ZIM.ScN.result_mean_WA = mean(ZIM.ScN.result_trans_WA);

ZIM.ScD.result_matr_Hsig(ZIM.ScD.result_matr_Hsig<0) = NaN;
ZIM.ScD.result_matr_Hsig_MHWS(ZIM.ScD.result_matr_Hsig_MHWS<0) = NaN;
ZIM.ScD.result_matr_WA = (1-ZIM.ScD.result_matr_Hsig./0.2).*100;
ZIM.ScD.result_matr_WA_MHWS =...
    (ZIM.ScD.result_matr_Hsig_MLWS./0.2-ZIM.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScD.result_matr_WA_bar =...
    (ZIM.ScD.result_matr_Hsig_MLWS./0.2-ZIM.ScD.result_matr_Hsig_vegedge./0.2).*100;
ZIM.ScD.result_matr_WA_veg =...
    (ZIM.ScD.result_matr_Hsig_vegedge./0.2-ZIM.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScD.result_trans_WA = min(ZIM.ScD.result_matr_WA_MHWS);
ZIM.ScD.result_mm_WA = [min(ZIM.ScD.result_trans_WA(1:5)),max(ZIM.ScD.result_trans_WA(1:5))];
ZIM.ScD.result_mean_WA = mean(ZIM.ScD.result_trans_WA);

ZIM.ScDV.result_matr_Hsig(ZIM.ScDV.result_matr_Hsig<0) = NaN;
ZIM.ScDV.result_matr_Hsig_MHWS(ZIM.ScDV.result_matr_Hsig_MHWS<0) = NaN;
ZIM.ScDV.result_matr_WA = (1-ZIM.ScDV.result_matr_Hsig./0.2).*100;
ZIM.ScDV.result_matr_WA_MHWS =...
    (ZIM.ScDV.result_matr_Hsig_MLWS./0.2-ZIM.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScDV.result_matr_WA_bar =...
    (ZIM.ScDV.result_matr_Hsig_MLWS./0.2-ZIM.ScDV.result_matr_Hsig_vegedge./0.2).*100;
ZIM.ScDV.result_matr_WA_veg =...
    (ZIM.ScDV.result_matr_Hsig_vegedge./0.2-ZIM.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScDV.result_trans_WA = min(ZIM.ScDV.result_matr_WA_MHWS);
ZIM.ScDV.result_mm_WA = [min(ZIM.ScDV.result_trans_WA(1:5)),max(ZIM.ScDV.result_trans_WA(1:5))];
ZIM.ScDV.result_mean_WA = mean(ZIM.ScDV.result_trans_WA);

%---Hoofdplaat--- #Transects=6 --- #Years=42 ---
HOO.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Hoofdplaat_S250\Hoofdplaat_S250.mat')
HOO.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Hoofdplaat_S250\Hoofdplaat_S250.mat');
HOO.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Hoofdplaat_S250\Hoofdplaat_S250.mat');
HOO.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Hoofdplaat_S250.mat');

for i = 1:6
    HOO.result_length(i) = length(HOO.ScN.result(i).year(1).Hsig)*5;
    for j = 1:42
        HOO.ScN.result_matr_Hsig(j,i) = min(HOO.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1)
            HOO.ScN.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1);
        else
            HOO.ScN.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1))
            HOO.ScN.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1));
        else
            HOO.ScN.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1)
            HOO.ScN.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1);
        else
            HOO.ScN.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(end);
        end
        
        HOO.ScD.result_matr_Hsig(j,i) = min(HOO.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1)
            HOO.ScD.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1);
        else
            HOO.ScD.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1))
            HOO.ScD.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1));
        else
            HOO.ScD.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1)
            HOO.ScD.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1);
        else
            HOO.ScD.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(end);
        end
        
        HOO.ScDV.result_matr_Hsig(j,i) = min(HOO.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1)
            HOO.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1);
        else
            HOO.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1))
            HOO.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1));
        else
            HOO.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1)
            HOO.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1);
        else
            HOO.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(end);
        end
        HOO.result_veglength(j,i) = nansum(HOO.input.Hoofdplaat_S250.Veg{i}(j,:))*5;
        HOO.result_relveglength(j,i) = (HOO.result_veglength(j,i)/HOO.result_length(i)).*100;
        HOO.result_barelength(j,i) =...
            length(find(HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS &...
            HOO.ScN.result(i).year(j).Botlev>-HOO.input.Hoofdplaat_S250.veg_edge))*5;
    end
end

HOO.result_trans_relveglength = min(HOO.result_relveglength);
HOO.result_mm_trans_relveglength =...
    [min(HOO.result_trans_relveglength),max(HOO.result_trans_relveglength)];
HOO.result_mean_trans_relveglength =...
    mean(HOO.result_trans_relveglength);

HOO.ScN.result_matr_Hsig(HOO.ScN.result_matr_Hsig<0) = NaN;
HOO.ScN.result_matr_Hsig_MHWS(HOO.ScN.result_matr_Hsig_MHWS<0) = NaN;
HOO.ScN.result_matr_WA = (1-HOO.ScN.result_matr_Hsig./2.3600).*100;
HOO.ScN.result_matr_WA_MHWS =...
    (HOO.ScN.result_matr_Hsig_MLWS./2.3600-HOO.ScN.result_matr_Hsig_MHWS./2.3600).*100;
HOO.ScN.result_matr_WA_bar =...
    (HOO.ScN.result_matr_Hsig_MLWS./2.3600-HOO.ScN.result_matr_Hsig_vegedge./2.3600).*100;
HOO.ScN.result_matr_WA_veg =...
    (HOO.ScN.result_matr_Hsig_vegedge./2.3600-HOO.ScN.result_matr_Hsig_MHWS./2.3600).*100;
HOO.ScN.result_trans_WA = min(HOO.ScN.result_matr_WA_MHWS);
HOO.ScN.result_mm_WA = [min(HOO.ScN.result_trans_WA),max(HOO.ScN.result_trans_WA)];
HOO.ScN.result_mean_WA = mean(HOO.ScN.result_trans_WA);

HOO.ScD.result_matr_Hsig(HOO.ScD.result_matr_Hsig<0) = NaN;
HOO.ScD.result_matr_Hsig_MHWS(HOO.ScD.result_matr_Hsig_MHWS<0) = NaN;
HOO.ScD.result_matr_WA = (1-HOO.ScD.result_matr_Hsig./0.2).*100;
HOO.ScD.result_matr_WA_MHWS =...
    (HOO.ScD.result_matr_Hsig_MLWS./0.2-HOO.ScD.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScD.result_matr_WA_bar =...
    (HOO.ScD.result_matr_Hsig_MLWS./0.2-HOO.ScD.result_matr_Hsig_vegedge./0.2).*100;
HOO.ScD.result_matr_WA_veg =...
    (HOO.ScD.result_matr_Hsig_vegedge./0.2-HOO.ScD.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScD.result_trans_WA = min(HOO.ScD.result_matr_WA_MHWS);
HOO.ScD.result_mm_WA = [min(HOO.ScD.result_trans_WA),max(HOO.ScD.result_trans_WA)];
HOO.ScD.result_mean_WA = mean(HOO.ScD.result_trans_WA);

HOO.ScDV.result_matr_Hsig(HOO.ScDV.result_matr_Hsig<0) = NaN;
HOO.ScDV.result_matr_Hsig_MHWS(HOO.ScDV.result_matr_Hsig_MHWS<0) = NaN;
HOO.ScDV.result_matr_WA = (1-HOO.ScDV.result_matr_Hsig./0.2).*100;
HOO.ScDV.result_matr_WA_MHWS =...
    (HOO.ScDV.result_matr_Hsig_MLWS./0.2-HOO.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScDV.result_matr_WA_bar =...
    (HOO.ScDV.result_matr_Hsig_MLWS./0.2-HOO.ScDV.result_matr_Hsig_vegedge./0.2).*100;
HOO.ScDV.result_matr_WA_veg =...
    (HOO.ScDV.result_matr_Hsig_vegedge./0.2-HOO.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScDV.result_trans_WA = min(HOO.ScDV.result_matr_WA_MHWS);
HOO.ScDV.result_mm_WA = [min(HOO.ScDV.result_trans_WA),max(HOO.ScDV.result_trans_WA)];
HOO.ScDV.result_mean_WA = mean(HOO.ScDV.result_trans_WA);

%---Paulinapolder--- #Transects=7 --- #Years=41 ---
PAU.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Paulinapolder_S250\Paulinapolder_S250.mat')
PAU.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Paulinapolder_S250\Paulinapolder_S250.mat');
PAU.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Paulinapolder_S250\Paulinapolder_S250.mat');
PAU.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Paulinapolder_S250.mat');

for i = 1:7
    PAU.result_length(i) = length(PAU.ScN.result(i).year(1).Hsig)*5;
    for j = 1:41
        PAU.ScN.result_matr_Hsig(j,i) = min(PAU.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1)
            PAU.ScN.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1);
        else
            PAU.ScN.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1))
            PAU.ScN.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1));
        else
            PAU.ScN.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1)
            PAU.ScN.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1);
        else
            PAU.ScN.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(end);
        end
        
        PAU.ScD.result_matr_Hsig(j,i) = min(PAU.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1)
            PAU.ScD.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1);
        else
            PAU.ScD.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1))
            PAU.ScD.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1));
        else
            PAU.ScD.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1)
            PAU.ScD.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1);
        else
            PAU.ScD.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(end);
        end
        
        PAU.ScDV.result_matr_Hsig(j,i) = min(PAU.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1)
            PAU.ScDV.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1);
        else
            PAU.ScDV.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1))
            PAU.ScDV.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1));
        else
            PAU.ScDV.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1)
            PAU.ScDV.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1);
        else
            PAU.ScDV.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(end);
        end
        PAU.result_veglength(j,i) = nansum(PAU.input.Paulinapolder_S250.Veg{i}(j,:))*5;
        PAU.result_relveglength(j,i) = (PAU.result_veglength(j,i)/PAU.result_length(i)).*100;
        PAU.result_barelength(j,i) =...
            length(find(PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS &...
            PAU.ScN.result(i).year(j).Botlev>-PAU.input.Paulinapolder_S250.veg_edge))*5;
    end
end

PAU.result_trans_relveglength = min(PAU.result_relveglength);
PAU.result_mm_trans_relveglength =...
    [min(PAU.result_trans_relveglength),max(PAU.result_trans_relveglength)];
PAU.result_mean_trans_relveglength =...
    mean(PAU.result_trans_relveglength);

PAU.ScN.result_matr_Hsig(PAU.ScN.result_matr_Hsig<0) = NaN;
PAU.ScN.result_matr_Hsig_MHWS(PAU.ScN.result_matr_Hsig_MHWS<0) = NaN;
PAU.ScN.result_matr_WA = (1-PAU.ScN.result_matr_Hsig./2.1450).*100;
PAU.ScN.result_matr_WA_MHWS =...
    (PAU.ScN.result_matr_Hsig_MLWS./2.1450-PAU.ScN.result_matr_Hsig_MHWS./2.1450).*100;
PAU.ScN.result_matr_WA_bar =...
    (PAU.ScN.result_matr_Hsig_MLWS./2.1450-PAU.ScN.result_matr_Hsig_vegedge./2.1450).*100;
PAU.ScN.result_matr_WA_veg =...
    (PAU.ScN.result_matr_Hsig_vegedge./2.1450-PAU.ScN.result_matr_Hsig_MHWS./2.1450).*100;
PAU.ScN.result_trans_WA = min(PAU.ScN.result_matr_WA_MHWS);
PAU.ScN.result_mm_WA = [min(PAU.ScN.result_trans_WA),max(PAU.ScN.result_trans_WA)];
PAU.ScN.result_mean_WA = mean(PAU.ScN.result_trans_WA);

PAU.ScD.result_matr_Hsig(PAU.ScD.result_matr_Hsig<0) = NaN;
PAU.ScD.result_matr_Hsig_MHWS(PAU.ScD.result_matr_Hsig_MHWS<0) = NaN;
PAU.ScD.result_matr_WA = (1-PAU.ScD.result_matr_Hsig./0.2).*100;
PAU.ScD.result_matr_WA_MHWS =...
    (PAU.ScD.result_matr_Hsig_MLWS./0.2-PAU.ScD.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScD.result_matr_WA_bar =...
    (PAU.ScD.result_matr_Hsig_MLWS./0.2-PAU.ScD.result_matr_Hsig_vegedge./0.2).*100;
PAU.ScD.result_matr_WA_veg =...
    (PAU.ScD.result_matr_Hsig_vegedge./0.2-PAU.ScD.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScD.result_trans_WA = min(PAU.ScD.result_matr_WA_MHWS);
PAU.ScD.result_mm_WA = [min(PAU.ScD.result_trans_WA),max(PAU.ScD.result_trans_WA)];
PAU.ScD.result_mean_WA = mean(PAU.ScD.result_trans_WA);

PAU.ScDV.result_matr_Hsig(PAU.ScDV.result_matr_Hsig<0) = NaN;
PAU.ScDV.result_matr_Hsig_MHWS(PAU.ScDV.result_matr_Hsig_MHWS<0) = NaN;
PAU.ScDV.result_matr_WA = (1-PAU.ScDV.result_matr_Hsig./0.2).*100;
PAU.ScDV.result_matr_WA_MHWS =...
    (PAU.ScDV.result_matr_Hsig_MLWS./0.2-PAU.ScDV.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScDV.result_matr_WA_MHWS(PAU.ScDV.result_matr_WA_MHWS==-9) = NaN;
PAU.ScDV.result_matr_WA_bar =...
    (PAU.ScDV.result_matr_Hsig_MLWS./0.2-PAU.ScDV.result_matr_Hsig_vegedge./0.2).*100;
PAU.ScDV.result_matr_WA_bar(PAU.ScDV.result_matr_WA_bar==-9) = NaN;
PAU.ScDV.result_matr_WA_veg =...
    (PAU.ScDV.result_matr_Hsig_vegedge./0.2-PAU.ScDV.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScDV.result_matr_WA_veg(PAU.ScDV.result_matr_WA_veg==-9) = NaN;
PAU.ScDV.result_trans_WA = min(PAU.ScDV.result_matr_WA_MHWS);
PAU.ScDV.result_mm_WA = [min(PAU.ScDV.result_trans_WA),max(PAU.ScDV.result_trans_WA)];
PAU.ScDV.result_mean_WA = mean(PAU.ScDV.result_trans_WA);

%---Hellegatpolder--- #Transects=6 --- #Years=52 ---
HEL.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Hellegatpolder_S250\Hellegatpolder_S250.mat')
HEL.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Hellegatpolder_S250\Hellegatpolder_S250.mat');
HEL.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Hellegatpolder_S250\Hellegatpolder_S250.mat');
HEL.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Hellegatpolder_S250.mat');

for i = 1:6
    HEL.result_length(i) = length(HEL.ScN.result(i).year(1).Hsig)*5;
    for j = 1:52
        HEL.ScN.result_matr_Hsig(j,i) = min(HEL.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1)
            HEL.ScN.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1);
        else
            HEL.ScN.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1))
            HEL.ScN.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1));
        else
            HEL.ScN.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1)
            HEL.ScN.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1);
        else
            HEL.ScN.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(end);
        end
        
        HEL.ScD.result_matr_Hsig(j,i) = min(HEL.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1)
            HEL.ScD.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1);
        else
            HEL.ScD.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1))
            HEL.ScD.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1));
        else
            HEL.ScD.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1)
            HEL.ScD.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1);
        else
            HEL.ScD.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(end);
        end
        
        HEL.ScDV.result_matr_Hsig(j,i) = min(HEL.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1)
            HEL.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1);
        else
            HEL.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1))
            HEL.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1));
        else
            HEL.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1)
            HEL.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1);
        else
            HEL.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(end);
        end
        HEL.result_veglength(j,i) = nansum(HEL.input.Hellegatpolder_S250.Veg{i}(j,:))*5;
        HEL.result_relveglength(j,i) = (HEL.result_veglength(j,i)/HEL.result_length(i)).*100;
        HEL.result_barelength(j,i) =...
            length(find(HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS &...
            HEL.ScN.result(i).year(j).Botlev>-HEL.input.Hellegatpolder_S250.veg_edge))*5;
    end
end

HEL.result_trans_relveglength = min(HEL.result_relveglength);
HEL.result_mm_trans_relveglength =...
    [min(HEL.result_trans_relveglength),max(HEL.result_trans_relveglength)];
HEL.result_mean_trans_relveglength =...
    mean(HEL.result_trans_relveglength);

HEL.ScN.result_matr_Hsig(HEL.ScN.result_matr_Hsig<0) = NaN;
HEL.ScN.result_matr_Hsig_MHWS(HEL.ScN.result_matr_Hsig_MHWS<0) = NaN;
HEL.ScN.result_matr_WA = (1-HEL.ScN.result_matr_Hsig./2.6500).*100;
HEL.ScN.result_matr_WA_MHWS =...
    (HEL.ScN.result_matr_Hsig_MLWS./2.6500-HEL.ScN.result_matr_Hsig_MHWS./2.6500).*100;
HEL.ScN.result_matr_WA_bar =...
    (HEL.ScN.result_matr_Hsig_MLWS./2.6500-HEL.ScN.result_matr_Hsig_vegedge./2.6500).*100;
HEL.ScN.result_matr_WA_veg =...
    (HEL.ScN.result_matr_Hsig_vegedge./2.6500-HEL.ScN.result_matr_Hsig_MHWS./2.6500).*100;
HEL.ScN.result_trans_WA = min(HEL.ScN.result_matr_WA_MHWS);
HEL.ScN.result_mm_WA = [min(HEL.ScN.result_trans_WA),max(HEL.ScN.result_trans_WA)];
HEL.ScN.result_mean_WA = mean(HEL.ScN.result_trans_WA);

HEL.ScD.result_matr_Hsig(HEL.ScD.result_matr_Hsig<0) = NaN;
HEL.ScD.result_matr_Hsig_MHWS(HEL.ScD.result_matr_Hsig_MHWS<0) = NaN;
HEL.ScD.result_matr_WA = (1-HEL.ScD.result_matr_Hsig./0.2).*100;
HEL.ScD.result_matr_WA_MHWS =...
    (HEL.ScD.result_matr_Hsig_MLWS./0.2-HEL.ScD.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScD.result_matr_WA_bar =...
    (HEL.ScD.result_matr_Hsig_MLWS./0.2-HEL.ScD.result_matr_Hsig_vegedge./0.2).*100;
HEL.ScD.result_matr_WA_veg =...
    (HEL.ScD.result_matr_Hsig_vegedge./0.2-HEL.ScD.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScD.result_trans_WA = min(HEL.ScD.result_matr_WA_MHWS);
HEL.ScD.result_mm_WA = [min(HEL.ScD.result_trans_WA),max(HEL.ScD.result_trans_WA)];
HEL.ScD.result_mean_WA = mean(HEL.ScD.result_trans_WA);

HEL.ScDV.result_matr_Hsig(HEL.ScDV.result_matr_Hsig<0) = NaN;
HEL.ScDV.result_matr_Hsig_MHWS(HEL.ScDV.result_matr_Hsig_MHWS<0) = NaN;
HEL.ScDV.result_matr_WA = (1-HEL.ScDV.result_matr_Hsig./0.2).*100;
HEL.ScDV.result_matr_WA_MHWS =...
    (HEL.ScDV.result_matr_Hsig_MLWS./0.2-HEL.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScDV.result_matr_WA_bar =...
    (HEL.ScDV.result_matr_Hsig_MLWS./0.2-HEL.ScDV.result_matr_Hsig_vegedge./0.2).*100;
HEL.ScDV.result_matr_WA_veg =...
    (HEL.ScDV.result_matr_Hsig_vegedge./0.2-HEL.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScDV.result_trans_WA = min(HEL.ScDV.result_matr_WA_MHWS);
HEL.ScDV.result_mm_WA = [min(HEL.ScDV.result_trans_WA),max(HEL.ScDV.result_trans_WA)];
HEL.ScDV.result_mean_WA = mean(HEL.ScDV.result_trans_WA);

ZUI.ScN.result_matr_WA(isnan(ZUI.ScN.result_matr_WA)) = 100;
BAA.ScN.result_matr_WA(isnan(BAA.ScN.result_matr_WA)) = 100;
ZIM.ScN.result_matr_WA(isnan(ZIM.ScN.result_matr_WA)) = 100;
HOO.ScN.result_matr_WA(isnan(HOO.ScN.result_matr_WA)) = 100;
PAU.ScN.result_matr_WA(isnan(PAU.ScN.result_matr_WA)) = 100;
HEL.ScN.result_matr_WA(isnan(HEL.ScN.result_matr_WA)) = 100;

%% Manuscript Figure 6

%% ZUI -----------------------------------------------------------------------------------------------------
% Make diff vectors
for i = 1:length(ZUI.input.Zuidgors_S250.T{1,1}(2:end))-1
ZUI.T_diff{i} = year(ZUI.input.Zuidgors_S250.T{1,1}(1+i:end))-year(ZUI.input.Zuidgors_S250.T{1,1}(1:end-i));    
ZUI.result_veglength_diff{i} = ZUI.result_veglength(1+i:end,:)-ZUI.result_veglength(1:end-i,:);
end

% Make indice vectors for period bins
ZUI.T_diff1 = find(ZUI.T_diff{1}==1);
for i = 1:length(ZUI.input.Zuidgors_S250.T{1,1}(2:end))-1
ZUI.T_diffP1{i} = find(ZUI.T_diff{i}==5);
ZUI.T_diffP2{i} = find(ZUI.T_diff{i}==10);
ZUI.T_diffP3{i} = find(ZUI.T_diff{i}==25);
ZUI.T_diffP4{i} = find(ZUI.T_diff{i}==50);
end

% Make vectors with lengths
ZUI.veglength_diff1matr = ZUI.result_veglength_diff{1}(find(ZUI.T_diff{1,1}==1),:);
ZUI.veglength_diff1vec = reshape(ZUI.veglength_diff1matr,...
[1,size(ZUI.veglength_diff1matr,1)*size(ZUI.veglength_diff1matr,2)]);
count5 = 0;
count10 = 0;
count25 = 0;
count50 = 0;
for i = 1:length(ZUI.input.Zuidgors_S250.T{1,1}(2:end))-1
ZUI.veglength_diffP1{i} = ZUI.result_veglength_diff{i}(find(ZUI.T_diff{1,i}>=1 & ZUI.T_diff{1,i}<=10),:);
ZUI.veglength_diffP2{i} = ZUI.result_veglength_diff{i}(find(ZUI.T_diff{1,i}>=11 & ZUI.T_diff{1,i}<=20),:);
ZUI.veglength_diffP3{i} = ZUI.result_veglength_diff{i}(find(ZUI.T_diff{1,i}>=21 & ZUI.T_diff{1,i}<=30),:);
ZUI.veglength_diffP4{i} = ZUI.result_veglength_diff{i}(find(ZUI.T_diff{1,i}>=31 & ZUI.T_diff{1,i}<=40),:);
ZUI.veglength_diffP5{i} = ZUI.result_veglength_diff{i}(find(ZUI.T_diff{1,i}>=41 & ZUI.T_diff{1,i}<=50),:);
end

ZUI.veglength_diffP1matr = cat(1,ZUI.veglength_diffP1{:});
ZUI.veglength_diffP1vec = reshape(ZUI.veglength_diffP1matr,...
[1,size(ZUI.veglength_diffP1matr,1)*size(ZUI.veglength_diffP1matr,2)]);

ZUI.veglength_diffP2matr = cat(1,ZUI.veglength_diffP2{:});
ZUI.veglength_diffP2vec = reshape(ZUI.veglength_diffP2matr,...
[1,size(ZUI.veglength_diffP2matr,1)*size(ZUI.veglength_diffP2matr,2)]);

ZUI.veglength_diffP3matr = cat(1,ZUI.veglength_diffP3{:});
ZUI.veglength_diffP3vec = reshape(ZUI.veglength_diffP3matr,...
[1,size(ZUI.veglength_diffP3matr,1)*size(ZUI.veglength_diffP3matr,2)]);

ZUI.veglength_diffP4matr = cat(1,ZUI.veglength_diffP4{:});
ZUI.veglength_diffP4vec = reshape(ZUI.veglength_diffP4matr,...
[1,size(ZUI.veglength_diffP4matr,1)*size(ZUI.veglength_diffP4matr,2)]);

ZUI.veglength_diffP5matr = cat(1,ZUI.veglength_diffP5{:});
ZUI.veglength_diffP5vec = reshape(ZUI.veglength_diffP5matr,...
[1,size(ZUI.veglength_diffP5matr,1)*size(ZUI.veglength_diffP5matr,2)]);

% retrieve statistics (median, 10p, 90p)
% 1 year
ZUI.veglength_diff1_med = median(ZUI.veglength_diff1vec);
ZUI.veglength_diff1_prctl10 = prctile(ZUI.veglength_diff1vec,10);
ZUI.veglength_diff1_prctl90 = prctile(ZUI.veglength_diff1vec,90);
ZUI.veglength_diff1_prctl90 = prctile(ZUI.veglength_diff1vec,90);
ZUI.veglength_diff1_min = min(ZUI.veglength_diff1vec);
ZUI.veglength_diff1_max = max(ZUI.veglength_diff1vec);
 
ZUI.veglength_diff1_medsed = median(...
ZUI.veglength_diff1vec(ZUI.veglength_diff1vec>0));
ZUI.veglength_diff1_prctl10sed = prctile(...
ZUI.veglength_diff1vec(ZUI.veglength_diff1vec>0),10);
ZUI.veglength_diff1_prctl90sed = prctile(...
ZUI.veglength_diff1vec(ZUI.veglength_diff1vec>0),90);
ZUI.veglength_diff1_medero = median(...
ZUI.veglength_diff1vec(ZUI.veglength_diff1vec<0));
ZUI.veglength_diff1_prctl10ero = prctile(...
ZUI.veglength_diff1vec(ZUI.veglength_diff1vec<0),10);
ZUI.veglength_diff1_prctl90ero = prctile(...
ZUI.veglength_diff1vec(ZUI.veglength_diff1vec<0),90);

% 1 - 10
ZUI.veglength_diffP1_med = median(ZUI.veglength_diffP1vec);
ZUI.veglength_diffP1_prctl10 = prctile(ZUI.veglength_diffP1vec,10);
ZUI.veglength_diffP1_prctl90 = prctile(ZUI.veglength_diffP1vec,90);
ZUI.veglength_diffP1_min = min(ZUI.veglength_diffP1vec);
ZUI.veglength_diffP1_max = max(ZUI.veglength_diffP1vec);

ZUI.veglength_diffP1_medsed = median(...
ZUI.veglength_diffP1vec(ZUI.veglength_diffP1vec>0));
ZUI.veglength_diffP1_prctl10sed = prctile(...
ZUI.veglength_diffP1vec(ZUI.veglength_diffP1vec>0),10);
ZUI.veglength_diffP1_prctl90sed = prctile(...
ZUI.veglength_diffP1vec(ZUI.veglength_diffP1vec>0),90);
ZUI.veglength_diffP1_medero = median(...
ZUI.veglength_diffP1vec(ZUI.veglength_diffP1vec<0));
ZUI.veglength_diffP1_prctl10ero = prctile(...
ZUI.veglength_diffP1vec(ZUI.veglength_diffP1vec<0),10);
ZUI.veglength_diffP1_prctl90ero = prctile(...
ZUI.veglength_diffP1vec(ZUI.veglength_diffP1vec<0),90);

% 11 - 20 
ZUI.veglength_diffP2_med = median(ZUI.veglength_diffP2vec);
ZUI.veglength_diffP2_prctl10 = prctile(ZUI.veglength_diffP2vec,10);
ZUI.veglength_diffP2_prctl90 = prctile(ZUI.veglength_diffP2vec,90);
ZUI.veglength_diffP2_min = min(ZUI.veglength_diffP2vec);
ZUI.veglength_diffP2_max = max(ZUI.veglength_diffP2vec);

ZUI.veglength_diffP2_medsed = median(...
ZUI.veglength_diffP2vec(ZUI.veglength_diffP2vec>0));
ZUI.veglength_diffP2_prctl10sed = prctile(...
ZUI.veglength_diffP2vec(ZUI.veglength_diffP2vec>0),10);
ZUI.veglength_diffP2_prctl90sed = prctile(...
ZUI.veglength_diffP2vec(ZUI.veglength_diffP2vec>0),90);
ZUI.veglength_diffP2_medero = median(...
ZUI.veglength_diffP2vec(ZUI.veglength_diffP2vec<0));
ZUI.veglength_diffP2_prctl10ero = prctile(...
ZUI.veglength_diffP2vec(ZUI.veglength_diffP2vec<0),10);
ZUI.veglength_diffP2_prctl90ero = prctile(...
ZUI.veglength_diffP2vec(ZUI.veglength_diffP2vec<0),90);

% 21 - 30
ZUI.veglength_diffP3_med = median(ZUI.veglength_diffP3vec);
ZUI.veglength_diffP3_prctl10 = prctile(ZUI.veglength_diffP3vec,10);
ZUI.veglength_diffP3_prctl90 = prctile(ZUI.veglength_diffP3vec,90);
ZUI.veglength_diffP3_min = min(ZUI.veglength_diffP3vec);
ZUI.veglength_diffP3_max = max(ZUI.veglength_diffP3vec);

ZUI.veglength_diffP3_medsed = median(...
ZUI.veglength_diffP3vec(ZUI.veglength_diffP3vec>0));
ZUI.veglength_diffP3_prctl10sed = prctile(...
ZUI.veglength_diffP3vec(ZUI.veglength_diffP3vec>0),10);
ZUI.veglength_diffP3_prctl90sed = prctile(...
ZUI.veglength_diffP3vec(ZUI.veglength_diffP3vec>0),90);
ZUI.veglength_diffP3_medero = median(...
ZUI.veglength_diffP3vec(ZUI.veglength_diffP3vec<0));
ZUI.veglength_diffP3_prctl10ero = prctile(...
ZUI.veglength_diffP3vec(ZUI.veglength_diffP3vec<0),10);
ZUI.veglength_diffP3_prctl90ero = prctile(...
ZUI.veglength_diffP3vec(ZUI.veglength_diffP3vec<0),90);

% 31 - 40
ZUI.veglength_diffP4_med = median(ZUI.veglength_diffP4vec);
ZUI.veglength_diffP4_prctl10 = prctile(ZUI.veglength_diffP4vec,10);
ZUI.veglength_diffP4_prctl90 = prctile(ZUI.veglength_diffP4vec,90);
ZUI.veglength_diffP4_min = min(ZUI.veglength_diffP4vec);
ZUI.veglength_diffP4_max = max(ZUI.veglength_diffP4vec);

ZUI.veglength_diffP4_medsed = median(...
ZUI.veglength_diffP4vec(ZUI.veglength_diffP4vec>0));
ZUI.veglength_diffP4_prctl10sed = prctile(...
ZUI.veglength_diffP4vec(ZUI.veglength_diffP4vec>0),10);
ZUI.veglength_diffP4_prctl90sed = prctile(...
ZUI.veglength_diffP4vec(ZUI.veglength_diffP4vec>0),90);
ZUI.veglength_diffP4_medero = median(...
ZUI.veglength_diffP4vec(ZUI.veglength_diffP4vec<0));
ZUI.veglength_diffP4_prctl10ero = prctile(...
ZUI.veglength_diffP4vec(ZUI.veglength_diffP4vec<0),10);
ZUI.veglength_diffP4_prctl90ero = prctile(...
ZUI.veglength_diffP4vec(ZUI.veglength_diffP4vec<0),90);

% 41 - 50
ZUI.veglength_diffP5_med = median(ZUI.veglength_diffP5vec);
ZUI.veglength_diffP5_prctl10 = prctile(ZUI.veglength_diffP5vec,10);
ZUI.veglength_diffP5_prctl90 = prctile(ZUI.veglength_diffP5vec,90);
ZUI.veglength_diffP5_min = min(ZUI.veglength_diffP5vec);
ZUI.veglength_diffP5_max = max(ZUI.veglength_diffP5vec);

ZUI.veglength_diffP5_medsed = median(...
ZUI.veglength_diffP5vec(ZUI.veglength_diffP5vec>0));
ZUI.veglength_diffP5_prctl10sed = prctile(...
ZUI.veglength_diffP5vec(ZUI.veglength_diffP5vec>0),10);
ZUI.veglength_diffP5_prctl90sed = prctile(...
ZUI.veglength_diffP5vec(ZUI.veglength_diffP5vec>0),90);
ZUI.veglength_diffP5_medero = median(...
ZUI.veglength_diffP5vec(ZUI.veglength_diffP5vec<0));
ZUI.veglength_diffP5_prctl10ero = prctile(...
ZUI.veglength_diffP5vec(ZUI.veglength_diffP5vec<0),10);
ZUI.veglength_diffP5_prctl90ero = prctile(...
ZUI.veglength_diffP5vec(ZUI.veglength_diffP5vec<0),90);

%% BAA -----------------------------------------------------------------------------------------------------
% Make diff vectors
for i = 1:length(BAA.input.Baarland_S250.T{1,1}(2:end))-1
BAA.T_diff{i} = year(BAA.input.Baarland_S250.T{1,1}(1+i:end))-year(BAA.input.Baarland_S250.T{1,1}(1:end-i));    
BAA.result_veglength_diff{i} = BAA.result_veglength(1+i:end,:)-BAA.result_veglength(1:end-i,:);
end

% Make indice vectors for period bins
BAA.T_diff1 = find(BAA.T_diff{1}==1);
for i = 1:length(BAA.input.Baarland_S250.T{1,1}(2:end))-1
BAA.T_diffP1{i} = find(BAA.T_diff{i}==5);
BAA.T_diffP2{i} = find(BAA.T_diff{i}==10);
BAA.T_diffP3{i} = find(BAA.T_diff{i}==25);
BAA.T_diffP4{i} = find(BAA.T_diff{i}==50);
end

% Make vectors with lengths
BAA.veglength_diff1matr = BAA.result_veglength_diff{1}(find(BAA.T_diff{1,1}==1),:);
BAA.veglength_diff1vec = reshape(BAA.veglength_diff1matr,...
[1,size(BAA.veglength_diff1matr,1)*size(BAA.veglength_diff1matr,2)]);
count5 = 0;
count10 = 0;
count25 = 0;
count50 = 0;
for i = 1:length(BAA.input.Baarland_S250.T{1,1}(2:end))-1
BAA.veglength_diffP1{i} = BAA.result_veglength_diff{i}(find(BAA.T_diff{1,i}>=1 & BAA.T_diff{1,i}<=10),:);
BAA.veglength_diffP2{i} = BAA.result_veglength_diff{i}(find(BAA.T_diff{1,i}>=11 & BAA.T_diff{1,i}<=20),:);
BAA.veglength_diffP3{i} = BAA.result_veglength_diff{i}(find(BAA.T_diff{1,i}>=21 & BAA.T_diff{1,i}<=30),:);
BAA.veglength_diffP4{i} = BAA.result_veglength_diff{i}(find(BAA.T_diff{1,i}>=31 & BAA.T_diff{1,i}<=40),:);
BAA.veglength_diffP5{i} = BAA.result_veglength_diff{i}(find(BAA.T_diff{1,i}>=41 & BAA.T_diff{1,i}<=50),:);
end

BAA.veglength_diffP1matr = cat(1,BAA.veglength_diffP1{:});
BAA.veglength_diffP1vec = reshape(BAA.veglength_diffP1matr,...
[1,size(BAA.veglength_diffP1matr,1)*size(BAA.veglength_diffP1matr,2)]);

BAA.veglength_diffP2matr = cat(1,BAA.veglength_diffP2{:});
BAA.veglength_diffP2vec = reshape(BAA.veglength_diffP2matr,...
[1,size(BAA.veglength_diffP2matr,1)*size(BAA.veglength_diffP2matr,2)]);

BAA.veglength_diffP3matr = cat(1,BAA.veglength_diffP3{:});
BAA.veglength_diffP3vec = reshape(BAA.veglength_diffP3matr,...
[1,size(BAA.veglength_diffP3matr,1)*size(BAA.veglength_diffP3matr,2)]);

BAA.veglength_diffP4matr = cat(1,BAA.veglength_diffP4{:});
BAA.veglength_diffP4vec = reshape(BAA.veglength_diffP4matr,...
[1,size(BAA.veglength_diffP4matr,1)*size(BAA.veglength_diffP4matr,2)]);

BAA.veglength_diffP5matr = cat(1,BAA.veglength_diffP5{:});
BAA.veglength_diffP5vec = reshape(BAA.veglength_diffP5matr,...
[1,size(BAA.veglength_diffP5matr,1)*size(BAA.veglength_diffP5matr,2)]);

% retrieve statistics (median, 10p, 90p)
% 1 year
BAA.veglength_diff1_med = median(BAA.veglength_diff1vec);
BAA.veglength_diff1_prctl10 = prctile(BAA.veglength_diff1vec,10);
BAA.veglength_diff1_prctl90 = prctile(BAA.veglength_diff1vec,90);
BAA.veglength_diff1_min = min(BAA.veglength_diff1vec);
BAA.veglength_diff1_max = max(BAA.veglength_diff1vec);

BAA.veglength_diff1_medsed = median(...
BAA.veglength_diff1vec(BAA.veglength_diff1vec>0));
BAA.veglength_diff1_prctl10sed = prctile(...
BAA.veglength_diff1vec(BAA.veglength_diff1vec>0),10);
BAA.veglength_diff1_prctl90sed = prctile(...
BAA.veglength_diff1vec(BAA.veglength_diff1vec>0),90);
BAA.veglength_diff1_medero = median(...
BAA.veglength_diff1vec(BAA.veglength_diff1vec<0));
BAA.veglength_diff1_prctl10ero = prctile(...
BAA.veglength_diff1vec(BAA.veglength_diff1vec<0),10);
BAA.veglength_diff1_prctl90ero = prctile(...
BAA.veglength_diff1vec(BAA.veglength_diff1vec<0),90);

% 1 - 10
BAA.veglength_diffP1_med = median(BAA.veglength_diffP1vec);
BAA.veglength_diffP1_prctl10 = prctile(BAA.veglength_diffP1vec,10);
BAA.veglength_diffP1_prctl90 = prctile(BAA.veglength_diffP1vec,90);
BAA.veglength_diffP1_min = min(BAA.veglength_diffP1vec);
BAA.veglength_diffP1_max = max(BAA.veglength_diffP1vec);

BAA.veglength_diffP1_medsed = median(...
BAA.veglength_diffP1vec(BAA.veglength_diffP1vec>0));
BAA.veglength_diffP1_prctl10sed = prctile(...
BAA.veglength_diffP1vec(BAA.veglength_diffP1vec>0),10);
BAA.veglength_diffP1_prctl90sed = prctile(...
BAA.veglength_diffP1vec(BAA.veglength_diffP1vec>0),90);
BAA.veglength_diffP1_medero = median(...
BAA.veglength_diffP1vec(BAA.veglength_diffP1vec<0));
BAA.veglength_diffP1_prctl10ero = prctile(...
BAA.veglength_diffP1vec(BAA.veglength_diffP1vec<0),10);
BAA.veglength_diffP1_prctl90ero = prctile(...
BAA.veglength_diffP1vec(BAA.veglength_diffP1vec<0),90);

% 11 - 20
BAA.veglength_diffP2_med = median(BAA.veglength_diffP2vec);
BAA.veglength_diffP2_prctl10 = prctile(BAA.veglength_diffP2vec,10);
BAA.veglength_diffP2_prctl90 = prctile(BAA.veglength_diffP2vec,90);
BAA.veglength_diffP2_min = min(BAA.veglength_diffP2vec);
BAA.veglength_diffP2_max = max(BAA.veglength_diffP2vec);

BAA.veglength_diffP2_medsed = median(...
BAA.veglength_diffP2vec(BAA.veglength_diffP2vec>0));
BAA.veglength_diffP2_prctl10sed = prctile(...
BAA.veglength_diffP2vec(BAA.veglength_diffP2vec>0),10);
BAA.veglength_diffP2_prctl90sed = prctile(...
BAA.veglength_diffP2vec(BAA.veglength_diffP2vec>0),90);
BAA.veglength_diffP2_medero = median(...
BAA.veglength_diffP2vec(BAA.veglength_diffP2vec<0));
BAA.veglength_diffP2_prctl10ero = prctile(...
BAA.veglength_diffP2vec(BAA.veglength_diffP2vec<0),10);
BAA.veglength_diffP2_prctl90ero = prctile(...
BAA.veglength_diffP2vec(BAA.veglength_diffP2vec<0),90);

% 21 - 30
BAA.veglength_diffP3_med = median(BAA.veglength_diffP3vec);
BAA.veglength_diffP3_prctl10 = prctile(BAA.veglength_diffP3vec,10);
BAA.veglength_diffP3_prctl90 = prctile(BAA.veglength_diffP3vec,90);
BAA.veglength_diffP3_min = min(BAA.veglength_diffP3vec);
BAA.veglength_diffP3_max = max(BAA.veglength_diffP3vec);

BAA.veglength_diffP3_medsed = median(...
BAA.veglength_diffP3vec(BAA.veglength_diffP3vec>0));
BAA.veglength_diffP3_prctl10sed = prctile(...
BAA.veglength_diffP3vec(BAA.veglength_diffP3vec>0),10);
BAA.veglength_diffP3_prctl90sed = prctile(...
BAA.veglength_diffP3vec(BAA.veglength_diffP3vec>0),90);
BAA.veglength_diffP3_medero = median(...
BAA.veglength_diffP3vec(BAA.veglength_diffP3vec<0));
BAA.veglength_diffP3_prctl10ero = prctile(...
BAA.veglength_diffP3vec(BAA.veglength_diffP3vec<0),10);
BAA.veglength_diffP3_prctl90ero = prctile(...
BAA.veglength_diffP3vec(BAA.veglength_diffP3vec<0),90);

% 31 - 40
BAA.veglength_diffP4_med = median(BAA.veglength_diffP4vec);
BAA.veglength_diffP4_prctl10 = prctile(BAA.veglength_diffP4vec,10);
BAA.veglength_diffP4_prctl90 = prctile(BAA.veglength_diffP4vec,90);
BAA.veglength_diffP4_min = min(BAA.veglength_diffP4vec);
BAA.veglength_diffP4_max = max(BAA.veglength_diffP4vec);

BAA.veglength_diffP4_medsed = median(...
BAA.veglength_diffP4vec(BAA.veglength_diffP4vec>0));
BAA.veglength_diffP4_prctl10sed = prctile(...
BAA.veglength_diffP4vec(BAA.veglength_diffP4vec>0),10);
BAA.veglength_diffP4_prctl90sed = prctile(...
BAA.veglength_diffP4vec(BAA.veglength_diffP4vec>0),90);
BAA.veglength_diffP4_medero = median(...
BAA.veglength_diffP4vec(BAA.veglength_diffP4vec<0));
BAA.veglength_diffP4_prctl10ero = prctile(...
BAA.veglength_diffP4vec(BAA.veglength_diffP4vec<0),10);
BAA.veglength_diffP4_prctl90ero = prctile(...
BAA.veglength_diffP4vec(BAA.veglength_diffP4vec<0),90);

% 41 - 50
BAA.veglength_diffP5_med = median(BAA.veglength_diffP5vec);
BAA.veglength_diffP5_prctl10 = prctile(BAA.veglength_diffP5vec,10);
BAA.veglength_diffP5_prctl90 = prctile(BAA.veglength_diffP5vec,90);
BAA.veglength_diffP5_min = min(BAA.veglength_diffP5vec);
BAA.veglength_diffP5_max = max(BAA.veglength_diffP5vec);

BAA.veglength_diffP5_medsed = median(...
BAA.veglength_diffP5vec(BAA.veglength_diffP5vec>0));
BAA.veglength_diffP5_prctl10sed = prctile(...
BAA.veglength_diffP5vec(BAA.veglength_diffP5vec>0),10);
BAA.veglength_diffP5_prctl90sed = prctile(...
BAA.veglength_diffP5vec(BAA.veglength_diffP5vec>0),90);
BAA.veglength_diffP5_medero = median(...
BAA.veglength_diffP5vec(BAA.veglength_diffP5vec<0));
BAA.veglength_diffP5_prctl10ero = prctile(...
BAA.veglength_diffP5vec(BAA.veglength_diffP5vec<0),10);
BAA.veglength_diffP5_prctl90ero = prctile(...
BAA.veglength_diffP5vec(BAA.veglength_diffP5vec<0),90);

%% ZIM -----------------------------------------------------------------------------------------------------
% Make diff vectors
for i = 1:length(ZIM.input.Zimmermanpolder_S250.T{1,1}(2:end))-1
ZIM.T_diff{i} = year(ZIM.input.Zimmermanpolder_S250.T{1,1}(1+i:end))-year(ZIM.input.Zimmermanpolder_S250.T{1,1}(1:end-i));    
ZIM.result_veglength_diff{i} = ZIM.result_veglength(1+i:end,:)-ZIM.result_veglength(1:end-i,:);
end

% Make indice vectors for period bins
ZIM.T_diff1 = find(ZIM.T_diff{1}==1);
for i = 1:length(ZIM.input.Zimmermanpolder_S250.T{1,1}(2:end))-1
ZIM.T_diffP1{i} = find(ZIM.T_diff{i}==5);
ZIM.T_diffP2{i} = find(ZIM.T_diff{i}==10);
ZIM.T_diffP3{i} = find(ZIM.T_diff{i}==25);
ZIM.T_diffP4{i} = find(ZIM.T_diff{i}==50);
end

% Make vectors with lengths
ZIM.veglength_diff1matr = ZIM.result_veglength_diff{1}(find(ZIM.T_diff{1,1}==1),:);
ZIM.veglength_diff1vec = reshape(ZIM.veglength_diff1matr,...
[1,size(ZIM.veglength_diff1matr,1)*size(ZIM.veglength_diff1matr,2)]);
count5 = 0;
count10 = 0;
count25 = 0;
count50 = 0;
for i = 1:length(ZIM.input.Zimmermanpolder_S250.T{1,1}(2:end))-1
ZIM.veglength_diffP1{i} = ZIM.result_veglength_diff{i}(find(ZIM.T_diff{1,i}>=1 & ZIM.T_diff{1,i}<=10),:);
ZIM.veglength_diffP2{i} = ZIM.result_veglength_diff{i}(find(ZIM.T_diff{1,i}>=11 & ZIM.T_diff{1,i}<=20),:);
ZIM.veglength_diffP3{i} = ZIM.result_veglength_diff{i}(find(ZIM.T_diff{1,i}>=21 & ZIM.T_diff{1,i}<=30),:);
ZIM.veglength_diffP4{i} = ZIM.result_veglength_diff{i}(find(ZIM.T_diff{1,i}>=31 & ZIM.T_diff{1,i}<=40),:);
ZIM.veglength_diffP5{i} = ZIM.result_veglength_diff{i}(find(ZIM.T_diff{1,i}>=41 & ZIM.T_diff{1,i}<=50),:);
end

ZIM.veglength_diffP1matr = cat(1,ZIM.veglength_diffP1{:});
ZIM.veglength_diffP1vec = reshape(ZIM.veglength_diffP1matr,...
[1,size(ZIM.veglength_diffP1matr,1)*size(ZIM.veglength_diffP1matr,2)]);

ZIM.veglength_diffP2matr = cat(1,ZIM.veglength_diffP2{:});
ZIM.veglength_diffP2vec = reshape(ZIM.veglength_diffP2matr,...
[1,size(ZIM.veglength_diffP2matr,1)*size(ZIM.veglength_diffP2matr,2)]);

ZIM.veglength_diffP3matr = cat(1,ZIM.veglength_diffP3{:});
ZIM.veglength_diffP3vec = reshape(ZIM.veglength_diffP3matr,...
[1,size(ZIM.veglength_diffP3matr,1)*size(ZIM.veglength_diffP3matr,2)]);

ZIM.veglength_diffP4matr = cat(1,ZIM.veglength_diffP4{:});
ZIM.veglength_diffP4vec = reshape(ZIM.veglength_diffP4matr,...
[1,size(ZIM.veglength_diffP4matr,1)*size(ZIM.veglength_diffP4matr,2)]);

ZIM.veglength_diffP5matr = cat(1,ZIM.veglength_diffP5{:});
ZIM.veglength_diffP5vec = reshape(ZIM.veglength_diffP5matr,...
[1,size(ZIM.veglength_diffP5matr,1)*size(ZIM.veglength_diffP5matr,2)]);

% retrieve statistics (median, 10p, 90p)
% 1 year
ZIM.veglength_diff1_med = median(ZIM.veglength_diff1vec);
ZIM.veglength_diff1_prctl10 = prctile(ZIM.veglength_diff1vec,10);
ZIM.veglength_diff1_prctl90 = prctile(ZIM.veglength_diff1vec,90);
ZIM.veglength_diff1_min = min(ZIM.veglength_diff1vec);
ZIM.veglength_diff1_max = max(ZIM.veglength_diff1vec);

ZIM.veglength_diff1_medsed = median(...
ZIM.veglength_diff1vec(ZIM.veglength_diff1vec>0));
ZIM.veglength_diff1_prctl10sed = prctile(...
ZIM.veglength_diff1vec(ZIM.veglength_diff1vec>0),10);
ZIM.veglength_diff1_prctl90sed = prctile(...
ZIM.veglength_diff1vec(ZIM.veglength_diff1vec>0),90);
ZIM.veglength_diff1_medero = median(...
ZIM.veglength_diff1vec(ZIM.veglength_diff1vec<0));
ZIM.veglength_diff1_prctl10ero = prctile(...
ZIM.veglength_diff1vec(ZIM.veglength_diff1vec<0),10);
ZIM.veglength_diff1_prctl90ero = prctile(...
ZIM.veglength_diff1vec(ZIM.veglength_diff1vec<0),90);

% 1 - 10
ZIM.veglength_diffP1_med = median(ZIM.veglength_diffP1vec);
ZIM.veglength_diffP1_prctl10 = prctile(ZIM.veglength_diffP1vec,10);
ZIM.veglength_diffP1_prctl90 = prctile(ZIM.veglength_diffP1vec,90);
ZIM.veglength_diffP1_min = min(ZIM.veglength_diffP1vec);
ZIM.veglength_diffP1_max = max(ZIM.veglength_diffP1vec);

ZIM.veglength_diffP1_medsed = median(...
ZIM.veglength_diffP1vec(ZIM.veglength_diffP1vec>0));
ZIM.veglength_diffP1_prctl10sed = prctile(...
ZIM.veglength_diffP1vec(ZIM.veglength_diffP1vec>0),10);
ZIM.veglength_diffP1_prctl90sed = prctile(...
ZIM.veglength_diffP1vec(ZIM.veglength_diffP1vec>0),90);
ZIM.veglength_diffP1_medero = median(...
ZIM.veglength_diffP1vec(ZIM.veglength_diffP1vec<0));
ZIM.veglength_diffP1_prctl10ero = prctile(...
ZIM.veglength_diffP1vec(ZIM.veglength_diffP1vec<0),10);
ZIM.veglength_diffP1_prctl90ero = prctile(...
ZIM.veglength_diffP1vec(ZIM.veglength_diffP1vec<0),90);

% 11 - 20
ZIM.veglength_diffP2_med = median(ZIM.veglength_diffP2vec);
ZIM.veglength_diffP2_prctl10 = prctile(ZIM.veglength_diffP2vec,10);
ZIM.veglength_diffP2_prctl90 = prctile(ZIM.veglength_diffP2vec,90);
ZIM.veglength_diffP2_min = min(ZIM.veglength_diffP2vec);
ZIM.veglength_diffP2_max = max(ZIM.veglength_diffP2vec);

ZIM.veglength_diffP2_medsed = median(...
ZIM.veglength_diffP2vec(ZIM.veglength_diffP2vec>0));
ZIM.veglength_diffP2_prctl10sed = prctile(...
ZIM.veglength_diffP2vec(ZIM.veglength_diffP2vec>0),10);
ZIM.veglength_diffP2_prctl90sed = prctile(...
ZIM.veglength_diffP2vec(ZIM.veglength_diffP2vec>0),90);
ZIM.veglength_diffP2_medero = median(...
ZIM.veglength_diffP2vec(ZIM.veglength_diffP2vec<0));
ZIM.veglength_diffP2_prctl10ero = prctile(...
ZIM.veglength_diffP2vec(ZIM.veglength_diffP2vec<0),10);
ZIM.veglength_diffP2_prctl90ero = prctile(...
ZIM.veglength_diffP2vec(ZIM.veglength_diffP2vec<0),90);

% 21 - 30
ZIM.veglength_diffP3_med = median(ZIM.veglength_diffP3vec);
ZIM.veglength_diffP3_prctl10 = prctile(ZIM.veglength_diffP3vec,10);
ZIM.veglength_diffP3_prctl90 = prctile(ZIM.veglength_diffP3vec,90);
ZIM.veglength_diffP3_min = min(ZIM.veglength_diffP3vec);
ZIM.veglength_diffP3_max = max(ZIM.veglength_diffP3vec);

ZIM.veglength_diffP3_medsed = median(...
ZIM.veglength_diffP3vec(ZIM.veglength_diffP3vec>0));
ZIM.veglength_diffP3_prctl10sed = prctile(...
ZIM.veglength_diffP3vec(ZIM.veglength_diffP3vec>0),10);
ZIM.veglength_diffP3_prctl90sed = prctile(...
ZIM.veglength_diffP3vec(ZIM.veglength_diffP3vec>0),90);
ZIM.veglength_diffP3_medero = median(...
ZIM.veglength_diffP3vec(ZIM.veglength_diffP3vec<0));
ZIM.veglength_diffP3_prctl10ero = prctile(...
ZIM.veglength_diffP3vec(ZIM.veglength_diffP3vec<0),10);
ZIM.veglength_diffP3_prctl90ero = prctile(...
ZIM.veglength_diffP3vec(ZIM.veglength_diffP3vec<0),90);

% 31 - 40
ZIM.veglength_diffP4_med = median(ZIM.veglength_diffP4vec);
ZIM.veglength_diffP4_prctl10 = prctile(ZIM.veglength_diffP4vec,10);
ZIM.veglength_diffP4_prctl90 = prctile(ZIM.veglength_diffP4vec,90);
ZIM.veglength_diffP4_min = min(ZIM.veglength_diffP4vec);
ZIM.veglength_diffP4_max = max(ZIM.veglength_diffP4vec);

ZIM.veglength_diffP4_medsed = median(...
ZIM.veglength_diffP4vec(ZIM.veglength_diffP4vec>0));
ZIM.veglength_diffP4_prctl10sed = prctile(...
ZIM.veglength_diffP4vec(ZIM.veglength_diffP4vec>0),10);
ZIM.veglength_diffP4_prctl90sed = prctile(...
ZIM.veglength_diffP4vec(ZIM.veglength_diffP4vec>0),90);
ZIM.veglength_diffP4_medero = median(...
ZIM.veglength_diffP4vec(ZIM.veglength_diffP4vec<0));
ZIM.veglength_diffP4_prctl10ero = prctile(...
ZIM.veglength_diffP4vec(ZIM.veglength_diffP4vec<0),10);
ZIM.veglength_diffP4_prctl90ero = prctile(...
ZIM.veglength_diffP4vec(ZIM.veglength_diffP4vec<0),90);

% 41 - 50
ZIM.veglength_diffP5_med = median(ZIM.veglength_diffP5vec);
ZIM.veglength_diffP5_prctl10 = prctile(ZIM.veglength_diffP5vec,10);
ZIM.veglength_diffP5_prctl90 = prctile(ZIM.veglength_diffP5vec,90);
ZIM.veglength_diffP5_min = min(ZIM.veglength_diffP5vec);
ZIM.veglength_diffP5_max = max(ZIM.veglength_diffP5vec);

ZIM.veglength_diffP5_medsed = median(...
ZIM.veglength_diffP5vec(ZIM.veglength_diffP5vec>0));
ZIM.veglength_diffP5_prctl10sed = prctile(...
ZIM.veglength_diffP5vec(ZIM.veglength_diffP5vec>0),10);
ZIM.veglength_diffP5_prctl90sed = prctile(...
ZIM.veglength_diffP5vec(ZIM.veglength_diffP5vec>0),90);
ZIM.veglength_diffP5_medero = median(...
ZIM.veglength_diffP5vec(ZIM.veglength_diffP5vec<0));
ZIM.veglength_diffP5_prctl10ero = prctile(...
ZIM.veglength_diffP5vec(ZIM.veglength_diffP5vec<0),10);
ZIM.veglength_diffP5_prctl90ero = prctile(...
ZIM.veglength_diffP5vec(ZIM.veglength_diffP5vec<0),90);

%% HOO -----------------------------------------------------------------------------------------------------
% Make diff vectors
for i = 1:length(HOO.input.Hoofdplaat_S250.T{1,1}(2:end))-1
HOO.T_diff{i} = year(HOO.input.Hoofdplaat_S250.T{1,1}(1+i:end))-year(HOO.input.Hoofdplaat_S250.T{1,1}(1:end-i));    
HOO.result_veglength_diff{i} = HOO.result_veglength(1+i:end,:)-HOO.result_veglength(1:end-i,:);
end

% Make indice vectors for period bins
HOO.T_diff1 = find(HOO.T_diff{1}==1);
for i = 1:length(HOO.input.Hoofdplaat_S250.T{1,1}(2:end))-1
HOO.T_diffP1{i} = find(HOO.T_diff{i}==5);
HOO.T_diffP2{i} = find(HOO.T_diff{i}==10);
HOO.T_diffP3{i} = find(HOO.T_diff{i}==25);
HOO.T_diffP4{i} = find(HOO.T_diff{i}==50);
end

% Make vectors with lengths
HOO.veglength_diff1matr = HOO.result_veglength_diff{1}(find(HOO.T_diff{1,1}==1),:);
HOO.veglength_diff1vec = reshape(HOO.veglength_diff1matr,...
[1,size(HOO.veglength_diff1matr,1)*size(HOO.veglength_diff1matr,2)]);
count5 = 0;
count10 = 0;
count25 = 0;
count50 = 0;
for i = 1:length(HOO.input.Hoofdplaat_S250.T{1,1}(2:end))-1
HOO.veglength_diffP1{i} = HOO.result_veglength_diff{i}(find(HOO.T_diff{1,i}>=1 & HOO.T_diff{1,i}<=10),:);
HOO.veglength_diffP2{i} = HOO.result_veglength_diff{i}(find(HOO.T_diff{1,i}>=11 & HOO.T_diff{1,i}<=20),:);
HOO.veglength_diffP3{i} = HOO.result_veglength_diff{i}(find(HOO.T_diff{1,i}>=21 & HOO.T_diff{1,i}<=30),:);
HOO.veglength_diffP4{i} = HOO.result_veglength_diff{i}(find(HOO.T_diff{1,i}>=31 & HOO.T_diff{1,i}<=40),:);
HOO.veglength_diffP5{i} = HOO.result_veglength_diff{i}(find(HOO.T_diff{1,i}>=41 & HOO.T_diff{1,i}<=50),:);
end

HOO.veglength_diffP1matr = cat(1,HOO.veglength_diffP1{:});
HOO.veglength_diffP1vec = reshape(HOO.veglength_diffP1matr,...
[1,size(HOO.veglength_diffP1matr,1)*size(HOO.veglength_diffP1matr,2)]);

HOO.veglength_diffP2matr = cat(1,HOO.veglength_diffP2{:});
HOO.veglength_diffP2vec = reshape(HOO.veglength_diffP2matr,...
[1,size(HOO.veglength_diffP2matr,1)*size(HOO.veglength_diffP2matr,2)]);

HOO.veglength_diffP3matr = cat(1,HOO.veglength_diffP3{:});
HOO.veglength_diffP3vec = reshape(HOO.veglength_diffP3matr,...
[1,size(HOO.veglength_diffP3matr,1)*size(HOO.veglength_diffP3matr,2)]);

HOO.veglength_diffP4matr = cat(1,HOO.veglength_diffP4{:});
HOO.veglength_diffP4vec = reshape(HOO.veglength_diffP4matr,...
[1,size(HOO.veglength_diffP4matr,1)*size(HOO.veglength_diffP4matr,2)]);

HOO.veglength_diffP5matr = cat(1,HOO.veglength_diffP5{:});
HOO.veglength_diffP5vec = reshape(HOO.veglength_diffP5matr,...
[1,size(HOO.veglength_diffP5matr,1)*size(HOO.veglength_diffP5matr,2)]);

% retrieve statistics (median, 10p, 90p)
% 1 year
HOO.veglength_diff1_med = median(HOO.veglength_diff1vec);
HOO.veglength_diff1_prctl10 = prctile(HOO.veglength_diff1vec,10);
HOO.veglength_diff1_prctl90 = prctile(HOO.veglength_diff1vec,90);
HOO.veglength_diff1_min = min(HOO.veglength_diff1vec);
HOO.veglength_diff1_max = max(HOO.veglength_diff1vec);

HOO.veglength_diff1_medsed = median(...
HOO.veglength_diff1vec(HOO.veglength_diff1vec>0));
HOO.veglength_diff1_prctl10sed = prctile(...
HOO.veglength_diff1vec(HOO.veglength_diff1vec>0),10);
HOO.veglength_diff1_prctl90sed = prctile(...
HOO.veglength_diff1vec(HOO.veglength_diff1vec>0),90);
HOO.veglength_diff1_medero = median(...
HOO.veglength_diff1vec(HOO.veglength_diff1vec<0));
HOO.veglength_diff1_prctl10ero = prctile(...
HOO.veglength_diff1vec(HOO.veglength_diff1vec<0),10);
HOO.veglength_diff1_prctl90ero = prctile(...
HOO.veglength_diff1vec(HOO.veglength_diff1vec<0),90);

% 1 - 10
HOO.veglength_diffP1_med = median(HOO.veglength_diffP1vec);
HOO.veglength_diffP1_prctl10 = prctile(HOO.veglength_diffP1vec,10);
HOO.veglength_diffP1_prctl90 = prctile(HOO.veglength_diffP1vec,90);
HOO.veglength_diffP1_min = min(HOO.veglength_diffP1vec);
HOO.veglength_diffP1_max = max(HOO.veglength_diffP1vec);

HOO.veglength_diffP1_medsed = median(...
HOO.veglength_diffP1vec(HOO.veglength_diffP1vec>0));
HOO.veglength_diffP1_prctl10sed = prctile(...
HOO.veglength_diffP1vec(HOO.veglength_diffP1vec>0),10);
HOO.veglength_diffP1_prctl90sed = prctile(...
HOO.veglength_diffP1vec(HOO.veglength_diffP1vec>0),90);
HOO.veglength_diffP1_medero = median(...
HOO.veglength_diffP1vec(HOO.veglength_diffP1vec<0));
HOO.veglength_diffP1_prctl10ero = prctile(...
HOO.veglength_diffP1vec(HOO.veglength_diffP1vec<0),10);
HOO.veglength_diffP1_prctl90ero = prctile(...
HOO.veglength_diffP1vec(HOO.veglength_diffP1vec<0),90);

% 11 - 20
HOO.veglength_diffP2_med = median(HOO.veglength_diffP2vec);
HOO.veglength_diffP2_prctl10 = prctile(HOO.veglength_diffP2vec,10);
HOO.veglength_diffP2_prctl90 = prctile(HOO.veglength_diffP2vec,90);
HOO.veglength_diffP2_min = min(HOO.veglength_diffP2vec);
HOO.veglength_diffP2_max = max(HOO.veglength_diffP2vec);

HOO.veglength_diffP2_medsed = median(...
HOO.veglength_diffP2vec(HOO.veglength_diffP2vec>0));
HOO.veglength_diffP2_prctl10sed = prctile(...
HOO.veglength_diffP2vec(HOO.veglength_diffP2vec>0),10);
HOO.veglength_diffP2_prctl90sed = prctile(...
HOO.veglength_diffP2vec(HOO.veglength_diffP2vec>0),90);
HOO.veglength_diffP2_medero = median(...
HOO.veglength_diffP2vec(HOO.veglength_diffP2vec<0));
HOO.veglength_diffP2_prctl10ero = prctile(...
HOO.veglength_diffP2vec(HOO.veglength_diffP2vec<0),10);
HOO.veglength_diffP2_prctl90ero = prctile(...
HOO.veglength_diffP2vec(HOO.veglength_diffP2vec<0),90);

% 21 - 30
HOO.veglength_diffP3_med = median(HOO.veglength_diffP3vec);
HOO.veglength_diffP3_prctl10 = prctile(HOO.veglength_diffP3vec,10);
HOO.veglength_diffP3_prctl90 = prctile(HOO.veglength_diffP3vec,90);
HOO.veglength_diffP3_min = min(HOO.veglength_diffP3vec);
HOO.veglength_diffP3_max = max(HOO.veglength_diffP3vec);

HOO.veglength_diffP3_medsed = median(...
HOO.veglength_diffP3vec(HOO.veglength_diffP3vec>0));
HOO.veglength_diffP3_prctl10sed = prctile(...
HOO.veglength_diffP3vec(HOO.veglength_diffP3vec>0),10);
HOO.veglength_diffP3_prctl90sed = prctile(...
HOO.veglength_diffP3vec(HOO.veglength_diffP3vec>0),90);
HOO.veglength_diffP3_medero = median(...
HOO.veglength_diffP3vec(HOO.veglength_diffP3vec<0));
HOO.veglength_diffP3_prctl10ero = prctile(...
HOO.veglength_diffP3vec(HOO.veglength_diffP3vec<0),10);
HOO.veglength_diffP3_prctl90ero = prctile(...
HOO.veglength_diffP3vec(HOO.veglength_diffP3vec<0),90);

% 31 - 40
HOO.veglength_diffP4_med = median(HOO.veglength_diffP4vec);
HOO.veglength_diffP4_prctl10 = prctile(HOO.veglength_diffP4vec,10);
HOO.veglength_diffP4_prctl90 = prctile(HOO.veglength_diffP4vec,90);
HOO.veglength_diffP4_min = min(HOO.veglength_diffP4vec);
HOO.veglength_diffP4_max = max(HOO.veglength_diffP4vec);

HOO.veglength_diffP4_medsed = median(...
HOO.veglength_diffP4vec(HOO.veglength_diffP4vec>0));
HOO.veglength_diffP4_prctl10sed = prctile(...
HOO.veglength_diffP4vec(HOO.veglength_diffP4vec>0),10);
HOO.veglength_diffP4_prctl90sed = prctile(...
HOO.veglength_diffP4vec(HOO.veglength_diffP4vec>0),90);
HOO.veglength_diffP4_medero = median(...
HOO.veglength_diffP4vec(HOO.veglength_diffP4vec<0));
HOO.veglength_diffP4_prctl10ero = prctile(...
HOO.veglength_diffP4vec(HOO.veglength_diffP4vec<0),10);
HOO.veglength_diffP4_prctl90ero = prctile(...
HOO.veglength_diffP4vec(HOO.veglength_diffP4vec<0),90);

% 41 - 50
HOO.veglength_diffP5_med = median(HOO.veglength_diffP5vec);
HOO.veglength_diffP5_prctl10 = prctile(HOO.veglength_diffP5vec,10);
HOO.veglength_diffP5_prctl90 = prctile(HOO.veglength_diffP5vec,90);
HOO.veglength_diffP5_min = min(HOO.veglength_diffP5vec);
HOO.veglength_diffP5_max = max(HOO.veglength_diffP5vec);

HOO.veglength_diffP5_medsed = median(...
HOO.veglength_diffP5vec(HOO.veglength_diffP5vec>0));
HOO.veglength_diffP5_prctl10sed = prctile(...
HOO.veglength_diffP5vec(HOO.veglength_diffP5vec>0),10);
HOO.veglength_diffP5_prctl90sed = prctile(...
HOO.veglength_diffP5vec(HOO.veglength_diffP5vec>0),90);
HOO.veglength_diffP5_medero = median(...
HOO.veglength_diffP5vec(HOO.veglength_diffP5vec<0));
HOO.veglength_diffP5_prctl10ero = prctile(...
HOO.veglength_diffP5vec(HOO.veglength_diffP5vec<0),10);
HOO.veglength_diffP5_prctl90ero = prctile(...
HOO.veglength_diffP5vec(HOO.veglength_diffP5vec<0),90);

%% PAU -----------------------------------------------------------------------------------------------------
% Make diff vectors
for i = 1:length(PAU.input.Paulinapolder_S250.T{1,1}(2:end))-1
PAU.T_diff{i} = year(PAU.input.Paulinapolder_S250.T{1,1}(1+i:end))-year(PAU.input.Paulinapolder_S250.T{1,1}(1:end-i));    
PAU.result_veglength_diff{i} = PAU.result_veglength(1+i:end,:)-PAU.result_veglength(1:end-i,:);
end

% Make indice vectors for period bins
PAU.T_diff1 = find(PAU.T_diff{1}==1);
for i = 1:length(PAU.input.Paulinapolder_S250.T{1,1}(2:end))-1
PAU.T_diffP1{i} = find(PAU.T_diff{i}==5);
PAU.T_diffP2{i} = find(PAU.T_diff{i}==10);
PAU.T_diffP3{i} = find(PAU.T_diff{i}==25);
PAU.T_diffP4{i} = find(PAU.T_diff{i}==50);
end

% Make vectors with lengths
PAU.veglength_diff1matr = PAU.result_veglength_diff{1}(find(PAU.T_diff{1,1}==1),:);
PAU.veglength_diff1vec = reshape(PAU.veglength_diff1matr,...
[1,size(PAU.veglength_diff1matr,1)*size(PAU.veglength_diff1matr,2)]);
count5 = 0;
count10 = 0;
count25 = 0;
count50 = 0;
for i = 1:length(PAU.input.Paulinapolder_S250.T{1,1}(2:end))-1
PAU.veglength_diffP1{i} = PAU.result_veglength_diff{i}(find(PAU.T_diff{1,i}>=1 & PAU.T_diff{1,i}<=10),:);
PAU.veglength_diffP2{i} = PAU.result_veglength_diff{i}(find(PAU.T_diff{1,i}>=11 & PAU.T_diff{1,i}<=20),:);
PAU.veglength_diffP3{i} = PAU.result_veglength_diff{i}(find(PAU.T_diff{1,i}>=21 & PAU.T_diff{1,i}<=30),:);
PAU.veglength_diffP4{i} = PAU.result_veglength_diff{i}(find(PAU.T_diff{1,i}>=31 & PAU.T_diff{1,i}<=40),:);
PAU.veglength_diffP5{i} = PAU.result_veglength_diff{i}(find(PAU.T_diff{1,i}>=41 & PAU.T_diff{1,i}<=50),:);
end

PAU.veglength_diffP1matr = cat(1,PAU.veglength_diffP1{:});
PAU.veglength_diffP1vec = reshape(PAU.veglength_diffP1matr,...
[1,size(PAU.veglength_diffP1matr,1)*size(PAU.veglength_diffP1matr,2)]);

PAU.veglength_diffP2matr = cat(1,PAU.veglength_diffP2{:});
PAU.veglength_diffP2vec = reshape(PAU.veglength_diffP2matr,...
[1,size(PAU.veglength_diffP2matr,1)*size(PAU.veglength_diffP2matr,2)]);

PAU.veglength_diffP3matr = cat(1,PAU.veglength_diffP3{:});
PAU.veglength_diffP3vec = reshape(PAU.veglength_diffP3matr,...
[1,size(PAU.veglength_diffP3matr,1)*size(PAU.veglength_diffP3matr,2)]);

PAU.veglength_diffP4matr = cat(1,PAU.veglength_diffP4{:});
PAU.veglength_diffP4vec = reshape(PAU.veglength_diffP4matr,...
[1,size(PAU.veglength_diffP4matr,1)*size(PAU.veglength_diffP4matr,2)]);

PAU.veglength_diffP5matr = cat(1,PAU.veglength_diffP5{:});
PAU.veglength_diffP5vec = reshape(PAU.veglength_diffP5matr,...
[1,size(PAU.veglength_diffP5matr,1)*size(PAU.veglength_diffP5matr,2)]);

% retrieve statistics (median, 10p, 90p)
% 1 year
PAU.veglength_diff1_med = median(PAU.veglength_diff1vec);
PAU.veglength_diff1_prctl10 = prctile(PAU.veglength_diff1vec,10);
PAU.veglength_diff1_prctl90 = prctile(PAU.veglength_diff1vec,90);
PAU.veglength_diff1_min = min(PAU.veglength_diff1vec);
PAU.veglength_diff1_max = max(PAU.veglength_diff1vec);

PAU.veglength_diff1_medsed = median(...
PAU.veglength_diff1vec(PAU.veglength_diff1vec>0));
PAU.veglength_diff1_prctl10sed = prctile(...
PAU.veglength_diff1vec(PAU.veglength_diff1vec>0),10);
PAU.veglength_diff1_prctl90sed = prctile(...
PAU.veglength_diff1vec(PAU.veglength_diff1vec>0),90);
PAU.veglength_diff1_medero = median(...
PAU.veglength_diff1vec(PAU.veglength_diff1vec<0));
PAU.veglength_diff1_prctl10ero = prctile(...
PAU.veglength_diff1vec(PAU.veglength_diff1vec<0),10);
PAU.veglength_diff1_prctl90ero = prctile(...
PAU.veglength_diff1vec(PAU.veglength_diff1vec<0),90);

% 1 - 10
PAU.veglength_diffP1_med = median(PAU.veglength_diffP1vec);
PAU.veglength_diffP1_prctl10 = prctile(PAU.veglength_diffP1vec,10);
PAU.veglength_diffP1_prctl90 = prctile(PAU.veglength_diffP1vec,90);
PAU.veglength_diffP1_min = min(PAU.veglength_diffP1vec);
PAU.veglength_diffP1_max = max(PAU.veglength_diffP1vec);

PAU.veglength_diffP1_medsed = median(...
PAU.veglength_diffP1vec(PAU.veglength_diffP1vec>0));
PAU.veglength_diffP1_prctl10sed = prctile(...
PAU.veglength_diffP1vec(PAU.veglength_diffP1vec>0),10);
PAU.veglength_diffP1_prctl90sed = prctile(...
PAU.veglength_diffP1vec(PAU.veglength_diffP1vec>0),90);
PAU.veglength_diffP1_medero = median(...
PAU.veglength_diffP1vec(PAU.veglength_diffP1vec<0));
PAU.veglength_diffP1_prctl10ero = prctile(...
PAU.veglength_diffP1vec(PAU.veglength_diffP1vec<0),10);
PAU.veglength_diffP1_prctl90ero = prctile(...
PAU.veglength_diffP1vec(PAU.veglength_diffP1vec<0),90);

% 11 - 20
PAU.veglength_diffP2_med = median(PAU.veglength_diffP2vec);
PAU.veglength_diffP2_prctl10 = prctile(PAU.veglength_diffP2vec,10);
PAU.veglength_diffP2_prctl90 = prctile(PAU.veglength_diffP2vec,90);
PAU.veglength_diffP2_min = min(PAU.veglength_diffP2vec);
PAU.veglength_diffP2_max = max(PAU.veglength_diffP2vec);

PAU.veglength_diffP2_medsed = median(...
PAU.veglength_diffP2vec(PAU.veglength_diffP2vec>0));
PAU.veglength_diffP2_prctl10sed = prctile(...
PAU.veglength_diffP2vec(PAU.veglength_diffP2vec>0),10);
PAU.veglength_diffP2_prctl90sed = prctile(...
PAU.veglength_diffP2vec(PAU.veglength_diffP2vec>0),90);
PAU.veglength_diffP2_medero = median(...
PAU.veglength_diffP2vec(PAU.veglength_diffP2vec<0));
PAU.veglength_diffP2_prctl10ero = prctile(...
PAU.veglength_diffP2vec(PAU.veglength_diffP2vec<0),10);
PAU.veglength_diffP2_prctl90ero = prctile(...
PAU.veglength_diffP2vec(PAU.veglength_diffP2vec<0),90);

% 21 - 30
PAU.veglength_diffP3_med = median(PAU.veglength_diffP3vec);
PAU.veglength_diffP3_prctl10 = prctile(PAU.veglength_diffP3vec,10);
PAU.veglength_diffP3_prctl90 = prctile(PAU.veglength_diffP3vec,90);
PAU.veglength_diffP3_min = min(PAU.veglength_diffP3vec);
PAU.veglength_diffP3_max = max(PAU.veglength_diffP3vec);

PAU.veglength_diffP3_medsed = median(...
PAU.veglength_diffP3vec(PAU.veglength_diffP3vec>0));
PAU.veglength_diffP3_prctl10sed = prctile(...
PAU.veglength_diffP3vec(PAU.veglength_diffP3vec>0),10);
PAU.veglength_diffP3_prctl90sed = prctile(...
PAU.veglength_diffP3vec(PAU.veglength_diffP3vec>0),90);
PAU.veglength_diffP3_medero = median(...
PAU.veglength_diffP3vec(PAU.veglength_diffP3vec<0));
PAU.veglength_diffP3_prctl10ero = prctile(...
PAU.veglength_diffP3vec(PAU.veglength_diffP3vec<0),10);
PAU.veglength_diffP3_prctl90ero = prctile(...
PAU.veglength_diffP3vec(PAU.veglength_diffP3vec<0),90);

% 31 - 40
PAU.veglength_diffP4_med = median(PAU.veglength_diffP4vec);
PAU.veglength_diffP4_prctl10 = prctile(PAU.veglength_diffP4vec,10);
PAU.veglength_diffP4_prctl90 = prctile(PAU.veglength_diffP4vec,90);
PAU.veglength_diffP4_min = min(PAU.veglength_diffP4vec);
PAU.veglength_diffP4_max = max(PAU.veglength_diffP4vec);

PAU.veglength_diffP4_medsed = median(...
PAU.veglength_diffP4vec(PAU.veglength_diffP4vec>0));
PAU.veglength_diffP4_prctl10sed = prctile(...
PAU.veglength_diffP4vec(PAU.veglength_diffP4vec>0),10);
PAU.veglength_diffP4_prctl90sed = prctile(...
PAU.veglength_diffP4vec(PAU.veglength_diffP4vec>0),90);
PAU.veglength_diffP4_medero = median(...
PAU.veglength_diffP4vec(PAU.veglength_diffP4vec<0));
PAU.veglength_diffP4_prctl10ero = prctile(...
PAU.veglength_diffP4vec(PAU.veglength_diffP4vec<0),10);
PAU.veglength_diffP4_prctl90ero = prctile(...
PAU.veglength_diffP4vec(PAU.veglength_diffP4vec<0),90);

% 41 - 50
PAU.veglength_diffP5_med = median(PAU.veglength_diffP5vec);
PAU.veglength_diffP5_prctl10 = prctile(PAU.veglength_diffP5vec,10);
PAU.veglength_diffP5_prctl90 = prctile(PAU.veglength_diffP5vec,90);
PAU.veglength_diffP5_min = min(PAU.veglength_diffP5vec);
PAU.veglength_diffP5_max = max(PAU.veglength_diffP5vec);

PAU.veglength_diffP5_medsed = median(...
PAU.veglength_diffP5vec(PAU.veglength_diffP5vec>0));
PAU.veglength_diffP5_prctl10sed = prctile(...
PAU.veglength_diffP5vec(PAU.veglength_diffP5vec>0),10);
PAU.veglength_diffP5_prctl90sed = prctile(...
PAU.veglength_diffP5vec(PAU.veglength_diffP5vec>0),90);
PAU.veglength_diffP5_medero = median(...
PAU.veglength_diffP5vec(PAU.veglength_diffP5vec<0));
PAU.veglength_diffP5_prctl10ero = prctile(...
PAU.veglength_diffP5vec(PAU.veglength_diffP5vec<0),10);
PAU.veglength_diffP5_prctl90ero = prctile(...
PAU.veglength_diffP5vec(PAU.veglength_diffP5vec<0),90);

%% HEL -----------------------------------------------------------------------------------------------------
% Make diff vectors
for i = 1:length(HEL.input.Hellegatpolder_S250.T{1,1}(2:end))-1
HEL.T_diff{i} = year(HEL.input.Hellegatpolder_S250.T{1,1}(1+i:end))-year(HEL.input.Hellegatpolder_S250.T{1,1}(1:end-i));    
HEL.result_veglength_diff{i} = HEL.result_veglength(1+i:end,:)-HEL.result_veglength(1:end-i,:);
end

% Make indice vectors for period bins
HEL.T_diff1 = find(HEL.T_diff{1}==1);
for i = 1:length(HEL.input.Hellegatpolder_S250.T{1,1}(2:end))-1
HEL.T_diffP1{i} = find(HEL.T_diff{i}==5);
HEL.T_diffP2{i} = find(HEL.T_diff{i}==10);
HEL.T_diffP3{i} = find(HEL.T_diff{i}==25);
HEL.T_diffP4{i} = find(HEL.T_diff{i}==50);
end

% Make vectors with lengths
HEL.veglength_diff1matr = HEL.result_veglength_diff{1}(find(HEL.T_diff{1,1}==1),:);
HEL.veglength_diff1vec = reshape(HEL.veglength_diff1matr,...
[1,size(HEL.veglength_diff1matr,1)*size(HEL.veglength_diff1matr,2)]);
count5 = 0;
count10 = 0;
count25 = 0;
count50 = 0;
for i = 1:length(HEL.input.Hellegatpolder_S250.T{1,1}(2:end))-1
HEL.veglength_diffP1{i} = HEL.result_veglength_diff{i}(find(HEL.T_diff{1,i}>=1 & HEL.T_diff{1,i}<=10),:);
HEL.veglength_diffP2{i} = HEL.result_veglength_diff{i}(find(HEL.T_diff{1,i}>=11 & HEL.T_diff{1,i}<=20),:);
HEL.veglength_diffP3{i} = HEL.result_veglength_diff{i}(find(HEL.T_diff{1,i}>=21 & HEL.T_diff{1,i}<=30),:);
HEL.veglength_diffP4{i} = HEL.result_veglength_diff{i}(find(HEL.T_diff{1,i}>=31 & HEL.T_diff{1,i}<=40),:);
HEL.veglength_diffP5{i} = HEL.result_veglength_diff{i}(find(HEL.T_diff{1,i}>=41 & HEL.T_diff{1,i}<=50),:);
end

HEL.veglength_diffP1matr = cat(1,HEL.veglength_diffP1{:});
HEL.veglength_diffP1vec = reshape(HEL.veglength_diffP1matr,...
[1,size(HEL.veglength_diffP1matr,1)*size(HEL.veglength_diffP1matr,2)]);

HEL.veglength_diffP2matr = cat(1,HEL.veglength_diffP2{:});
HEL.veglength_diffP2vec = reshape(HEL.veglength_diffP2matr,...
[1,size(HEL.veglength_diffP2matr,1)*size(HEL.veglength_diffP2matr,2)]);

HEL.veglength_diffP3matr = cat(1,HEL.veglength_diffP3{:});
HEL.veglength_diffP3vec = reshape(HEL.veglength_diffP3matr,...
[1,size(HEL.veglength_diffP3matr,1)*size(HEL.veglength_diffP3matr,2)]);

HEL.veglength_diffP4matr = cat(1,HEL.veglength_diffP4{:});
HEL.veglength_diffP4vec = reshape(HEL.veglength_diffP4matr,...
[1,size(HEL.veglength_diffP4matr,1)*size(HEL.veglength_diffP4matr,2)]);

HEL.veglength_diffP5matr = cat(1,HEL.veglength_diffP5{:});
HEL.veglength_diffP5vec = reshape(HEL.veglength_diffP5matr,...
[1,size(HEL.veglength_diffP5matr,1)*size(HEL.veglength_diffP5matr,2)]);

% retrieve statistics (median, 10p, 90p)
% 1 year
HEL.veglength_diff1_med = median(HEL.veglength_diff1vec);
HEL.veglength_diff1_prctl10 = prctile(HEL.veglength_diff1vec,10);
HEL.veglength_diff1_prctl90 = prctile(HEL.veglength_diff1vec,90);
HEL.veglength_diff1_min = min(HEL.veglength_diff1vec);
HEL.veglength_diff1_max = max(HEL.veglength_diff1vec);

HEL.veglength_diff1_medsed = median(...
HEL.veglength_diff1vec(HEL.veglength_diff1vec>0));
HEL.veglength_diff1_prctl10sed = prctile(...
HEL.veglength_diff1vec(HEL.veglength_diff1vec>0),10);
HEL.veglength_diff1_prctl90sed = prctile(...
HEL.veglength_diff1vec(HEL.veglength_diff1vec>0),90);
HEL.veglength_diff1_medero = median(...
HEL.veglength_diff1vec(HEL.veglength_diff1vec<0));
HEL.veglength_diff1_prctl10ero = prctile(...
HEL.veglength_diff1vec(HEL.veglength_diff1vec<0),10);
HEL.veglength_diff1_prctl90ero = prctile(...
HEL.veglength_diff1vec(HEL.veglength_diff1vec<0),90);

% 1 - 10
HEL.veglength_diffP1_med = median(HEL.veglength_diffP1vec);
HEL.veglength_diffP1_prctl10 = prctile(HEL.veglength_diffP1vec,10);
HEL.veglength_diffP1_prctl90 = prctile(HEL.veglength_diffP1vec,90);
HEL.veglength_diffP1_min = min(HEL.veglength_diffP1vec);
HEL.veglength_diffP1_max = max(HEL.veglength_diffP1vec);

HEL.veglength_diffP1_medsed = median(...
HEL.veglength_diffP1vec(HEL.veglength_diffP1vec>0));
HEL.veglength_diffP1_prctl10sed = prctile(...
HEL.veglength_diffP1vec(HEL.veglength_diffP1vec>0),10);
HEL.veglength_diffP1_prctl90sed = prctile(...
HEL.veglength_diffP1vec(HEL.veglength_diffP1vec>0),90);
HEL.veglength_diffP1_medero = median(...
HEL.veglength_diffP1vec(HEL.veglength_diffP1vec<0));
HEL.veglength_diffP1_prctl10ero = prctile(...
HEL.veglength_diffP1vec(HEL.veglength_diffP1vec<0),10);
HEL.veglength_diffP1_prctl90ero = prctile(...
HEL.veglength_diffP1vec(HEL.veglength_diffP1vec<0),90);

% 11 - 20
HEL.veglength_diffP2_med = median(HEL.veglength_diffP2vec);
HEL.veglength_diffP2_prctl10 = prctile(HEL.veglength_diffP2vec,10);
HEL.veglength_diffP2_prctl90 = prctile(HEL.veglength_diffP2vec,90);
HEL.veglength_diffP2_min = min(HEL.veglength_diffP2vec);
HEL.veglength_diffP2_max = max(HEL.veglength_diffP2vec);

HEL.veglength_diffP2_medsed = median(...
HEL.veglength_diffP2vec(HEL.veglength_diffP2vec>0));
HEL.veglength_diffP2_prctl10sed = prctile(...
HEL.veglength_diffP2vec(HEL.veglength_diffP2vec>0),10);
HEL.veglength_diffP2_prctl90sed = prctile(...
HEL.veglength_diffP2vec(HEL.veglength_diffP2vec>0),90);
HEL.veglength_diffP2_medero = median(...
HEL.veglength_diffP2vec(HEL.veglength_diffP2vec<0));
HEL.veglength_diffP2_prctl10ero = prctile(...
HEL.veglength_diffP2vec(HEL.veglength_diffP2vec<0),10);
HEL.veglength_diffP2_prctl90ero = prctile(...
HEL.veglength_diffP2vec(HEL.veglength_diffP2vec<0),90);

% 21 - 30
HEL.veglength_diffP3_med = median(HEL.veglength_diffP3vec);
HEL.veglength_diffP3_prctl10 = prctile(HEL.veglength_diffP3vec,10);
HEL.veglength_diffP3_prctl90 = prctile(HEL.veglength_diffP3vec,90);
HEL.veglength_diffP3_min = min(HEL.veglength_diffP3vec);
HEL.veglength_diffP3_max = max(HEL.veglength_diffP3vec);

HEL.veglength_diffP3_medsed = median(...
HEL.veglength_diffP3vec(HEL.veglength_diffP3vec>0));
HEL.veglength_diffP3_prctl10sed = prctile(...
HEL.veglength_diffP3vec(HEL.veglength_diffP3vec>0),10);
HEL.veglength_diffP3_prctl90sed = prctile(...
HEL.veglength_diffP3vec(HEL.veglength_diffP3vec>0),90);
HEL.veglength_diffP3_medero = median(...
HEL.veglength_diffP3vec(HEL.veglength_diffP3vec<0));
HEL.veglength_diffP3_prctl10ero = prctile(...
HEL.veglength_diffP3vec(HEL.veglength_diffP3vec<0),10);
HEL.veglength_diffP3_prctl90ero = prctile(...
HEL.veglength_diffP3vec(HEL.veglength_diffP3vec<0),90);

% 31 - 40
HEL.veglength_diffP4_med = median(HEL.veglength_diffP4vec);
HEL.veglength_diffP4_prctl10 = prctile(HEL.veglength_diffP4vec,10);
HEL.veglength_diffP4_prctl90 = prctile(HEL.veglength_diffP4vec,90);
HEL.veglength_diffP4_min = min(HEL.veglength_diffP4vec);
HEL.veglength_diffP4_max = max(HEL.veglength_diffP4vec);

HEL.veglength_diffP4_medsed = median(...
HEL.veglength_diffP4vec(HEL.veglength_diffP4vec>0));
HEL.veglength_diffP4_prctl10sed = prctile(...
HEL.veglength_diffP4vec(HEL.veglength_diffP4vec>0),10);
HEL.veglength_diffP4_prctl90sed = prctile(...
HEL.veglength_diffP4vec(HEL.veglength_diffP4vec>0),90);
HEL.veglength_diffP4_medero = median(...
HEL.veglength_diffP4vec(HEL.veglength_diffP4vec<0));
HEL.veglength_diffP4_prctl10ero = prctile(...
HEL.veglength_diffP4vec(HEL.veglength_diffP4vec<0),10);
HEL.veglength_diffP4_prctl90ero = prctile(...
HEL.veglength_diffP4vec(HEL.veglength_diffP4vec<0),90);

% 41 - 50
HEL.veglength_diffP5_med = median(HEL.veglength_diffP5vec);
HEL.veglength_diffP5_prctl10 = prctile(HEL.veglength_diffP5vec,10);
HEL.veglength_diffP5_prctl90 = prctile(HEL.veglength_diffP5vec,90);
HEL.veglength_diffP5_min = min(HEL.veglength_diffP5vec);
HEL.veglength_diffP5_max = max(HEL.veglength_diffP5vec);

HEL.veglength_diffP5_medsed = median(...
HEL.veglength_diffP5vec(HEL.veglength_diffP5vec>0));
HEL.veglength_diffP5_prctl10sed = prctile(...
HEL.veglength_diffP5vec(HEL.veglength_diffP5vec>0),10);
HEL.veglength_diffP5_prctl90sed = prctile(...
HEL.veglength_diffP5vec(HEL.veglength_diffP5vec>0),90);
HEL.veglength_diffP5_medero = median(...
HEL.veglength_diffP5vec(HEL.veglength_diffP5vec<0));
HEL.veglength_diffP5_prctl10ero = prctile(...
HEL.veglength_diffP5vec(HEL.veglength_diffP5vec<0),10);
HEL.veglength_diffP5_prctl90ero = prctile(...
HEL.veglength_diffP5vec(HEL.veglength_diffP5vec<0),90);

%% Make Figure
figure;
% Figure settings
bsp = 1.2; % factor for width of subplot
hsp = 1.15; % factor for height of subplo
bf = 20; % width of figure
hf = 20; % height of figure

%% ZUI -----------------------------------------------------------------------------------------------------
subplot(2,3,1)
plot([1,1],[ZUI.veglength_diff1_min,ZUI.veglength_diff1_max],'k')
hold on
plot([1,1],[ZUI.veglength_diff1_prctl10,ZUI.veglength_diff1_prctl90],'k',...
'linewidth',10)
plot(1,ZUI.veglength_diff1_med,'ok','markerfacecolor','w')
plot([0.8,1.2],[ZUI.veglength_diff1_min,ZUI.veglength_diff1_min],'k')
plot([0.8,1.2],[ZUI.veglength_diff1_max,ZUI.veglength_diff1_max],'k')

plot([2,2],[ZUI.veglength_diffP1_min,ZUI.veglength_diffP1_max],'k')
plot([2,2],[ZUI.veglength_diffP1_prctl10,ZUI.veglength_diffP1_prctl90],'k',...
'linewidth',10)
plot(2,ZUI.veglength_diffP1_med,'ok','markerfacecolor','w')
plot([1.8,2.2],[ZUI.veglength_diffP1_min,ZUI.veglength_diffP1_min],'k')
plot([1.8,2.2],[ZUI.veglength_diffP1_max,ZUI.veglength_diffP1_max],'k')

plot([3,3],[ZUI.veglength_diffP2_min,ZUI.veglength_diffP2_max],'k')
plot([3,3],[ZUI.veglength_diffP2_prctl10,ZUI.veglength_diffP2_prctl90],'k',...
'linewidth',10)
plot(3,ZUI.veglength_diffP2_med,'ok','markerfacecolor','w')
plot([2.8,3.2],[ZUI.veglength_diffP2_min,ZUI.veglength_diffP2_min],'k')
plot([2.8,3.2],[ZUI.veglength_diffP2_max,ZUI.veglength_diffP2_max],'k')

plot([4,4],[ZUI.veglength_diffP3_min,ZUI.veglength_diffP3_max],'k')
plot([4,4],[ZUI.veglength_diffP3_prctl10,ZUI.veglength_diffP3_prctl90],'k',...
'linewidth',10)
plot(4,ZUI.veglength_diffP3_med,'ok','markerfacecolor','w')
plot([3.8,4.2],[ZUI.veglength_diffP3_min,ZUI.veglength_diffP3_min],'k')
plot([3.8,4.2],[ZUI.veglength_diffP3_max,ZUI.veglength_diffP3_max],'k')

plot([5,5],[ZUI.veglength_diffP4_min,ZUI.veglength_diffP4_max],'k')
plot([5,5],[ZUI.veglength_diffP4_prctl10,ZUI.veglength_diffP4_prctl90],'k',...
'linewidth',10)
plot(5,ZUI.veglength_diffP4_med,'ok','markerfacecolor','w')
plot([4.8,5.2],[ZUI.veglength_diffP4_min,ZUI.veglength_diffP4_min],'k')
plot([4.8,5.2],[ZUI.veglength_diffP4_max,ZUI.veglength_diffP4_max],'k')

plot([6,6],[ZUI.veglength_diffP5_min,ZUI.veglength_diffP5_max],'k')
plot([6,6],[ZUI.veglength_diffP5_prctl10,ZUI.veglength_diffP5_prctl90],'k',...
'linewidth',10)
plot(6,ZUI.veglength_diffP5_med,'ok','markerfacecolor','w')
plot([5.8,6.2],[ZUI.veglength_diffP5_min,ZUI.veglength_diffP5_min],'k')
plot([5.8,6.2],[ZUI.veglength_diffP5_max,ZUI.veglength_diffP5_max],'k')


YLim1 = [-250,400];
XLim1 = [0.5,6.5];
bnd_color = [.4 .4 .4];

Ytxt1 = -250-(650/10);
text(0,Ytxt1,'1 year','rotation',45,'horizontalalignment','center')
text(1,Ytxt1,'1 - 10','rotation',45,'horizontalalignment','center')
text(2,Ytxt1,'11 - 20','rotation',45,'horizontalalignment','center')
text(3,Ytxt1,'21 - 30','rotation',45,'horizontalalignment','center')
text(4,Ytxt1,'31 - 40','rotation',45,'horizontalalignment','center')
text(5,Ytxt1,'41 - 50','rotation',45,'horizontalalignment','center')

text(2,400-(650/10),'ZUI','color','r','horizontalalignment','center')

%ylabel('horizontal change of marsh width (m)')
set(gca,'xtick',[],'xticklabel',[],'YGrid','on','box','on')
ylim(YLim1);
xlim(XLim1);

%% BAA -----------------------------------------------------------------------------------------------------
subplot(2,3,2)
plot([1,1],[BAA.veglength_diff1_min,BAA.veglength_diff1_max],'k')
hold on
plot([1,1],[BAA.veglength_diff1_prctl10,BAA.veglength_diff1_prctl90],'k',...
'linewidth',10)
plot(1,BAA.veglength_diff1_med,'ok','markerfacecolor','w')
plot([0.8,1.2],[BAA.veglength_diff1_min,BAA.veglength_diff1_min],'k')
plot([0.8,1.2],[BAA.veglength_diff1_max,BAA.veglength_diff1_max],'k')

plot([2,2],[BAA.veglength_diffP1_min,BAA.veglength_diffP1_max],'k')
plot([2,2],[BAA.veglength_diffP1_prctl10,BAA.veglength_diffP1_prctl90],'k',...
'linewidth',10)
plot(2,BAA.veglength_diffP1_med,'ok','markerfacecolor','w')
plot([1.8,2.2],[BAA.veglength_diffP1_min,BAA.veglength_diffP1_min],'k')
plot([1.8,2.2],[BAA.veglength_diffP1_max,BAA.veglength_diffP1_max],'k')

plot([3,3],[BAA.veglength_diffP2_min,BAA.veglength_diffP2_max],'k')
plot([3,3],[BAA.veglength_diffP2_prctl10,BAA.veglength_diffP2_prctl90],'k',...
'linewidth',10)
plot(3,BAA.veglength_diffP2_med,'ok','markerfacecolor','w')
plot([2.8,3.2],[BAA.veglength_diffP2_min,BAA.veglength_diffP2_min],'k')
plot([2.8,3.2],[BAA.veglength_diffP2_max,BAA.veglength_diffP2_max],'k')

plot([4,4],[BAA.veglength_diffP3_min,BAA.veglength_diffP3_max],'k')
plot([4,4],[BAA.veglength_diffP3_prctl10,BAA.veglength_diffP3_prctl90],'k',...
'linewidth',10)
plot(4,BAA.veglength_diffP3_med,'ok','markerfacecolor','w')
plot([3.8,4.2],[BAA.veglength_diffP3_min,BAA.veglength_diffP3_min],'k')
plot([3.8,4.2],[BAA.veglength_diffP3_max,BAA.veglength_diffP3_max],'k')

plot([5,5],[BAA.veglength_diffP4_min,BAA.veglength_diffP4_max],'k')
plot([5,5],[BAA.veglength_diffP4_prctl10,BAA.veglength_diffP4_prctl90],'k',...
'linewidth',10)
plot(5,BAA.veglength_diffP4_med,'ok','markerfacecolor','w')
plot([4.8,5.2],[BAA.veglength_diffP4_min,BAA.veglength_diffP4_min],'k')
plot([4.8,5.2],[BAA.veglength_diffP4_max,BAA.veglength_diffP4_max],'k')

plot([6,6],[BAA.veglength_diffP5_min,BAA.veglength_diffP5_max],'k')
plot([6,6],[BAA.veglength_diffP5_prctl10,BAA.veglength_diffP5_prctl90],'k',...
'linewidth',10)
plot(6,BAA.veglength_diffP5_med,'ok','markerfacecolor','w')
plot([5.8,6.2],[BAA.veglength_diffP5_min,BAA.veglength_diffP5_min],'k')
plot([5.8,6.2],[BAA.veglength_diffP5_max,BAA.veglength_diffP5_max],'k')


YLim1 = [-100,1000];
XLim1 = [0.5,6.5];
bnd_color = [.4 .4 .4];

Ytxt1 = -100-(1100/10);
text(0,Ytxt1,'1 year','rotation',45,'horizontalalignment','center')
text(1,Ytxt1,'1 - 10','rotation',45,'horizontalalignment','center')
text(2,Ytxt1,'11 - 20','rotation',45,'horizontalalignment','center')
text(3,Ytxt1,'21 - 30','rotation',45,'horizontalalignment','center')
text(4,Ytxt1,'31 - 40','rotation',45,'horizontalalignment','center')
text(5,Ytxt1,'41 - 50','rotation',45,'horizontalalignment','center')

text(2,1000-(1100/10),'BAA','color','r','horizontalalignment','center')

%ylabel('horizontal change of marsh width (m)')
set(gca,'xtick',[],'xticklabel',[],'YGrid','on','box','on')
ylim(YLim1);
xlim(XLim1);

%% ZIM -----------------------------------------------------------------------------------------------------
subplot(2,3,3)
plot([1,1],[ZIM.veglength_diff1_min,ZIM.veglength_diff1_max],'k')
hold on
plot([1,1],[ZIM.veglength_diff1_prctl10,ZIM.veglength_diff1_prctl90],'k',...
'linewidth',10)
plot(1,ZIM.veglength_diff1_med,'ok','markerfacecolor','w')
plot([0.8,1.2],[ZIM.veglength_diff1_min,ZIM.veglength_diff1_min],'k')
plot([0.8,1.2],[ZIM.veglength_diff1_max,ZIM.veglength_diff1_max],'k')

plot([2,2],[ZIM.veglength_diffP1_min,ZIM.veglength_diffP1_max],'k')
plot([2,2],[ZIM.veglength_diffP1_prctl10,ZIM.veglength_diffP1_prctl90],'k',...
'linewidth',10)
plot(2,ZIM.veglength_diffP1_med,'ok','markerfacecolor','w')
plot([1.8,2.2],[ZIM.veglength_diffP1_min,ZIM.veglength_diffP1_min],'k')
plot([1.8,2.2],[ZIM.veglength_diffP1_max,ZIM.veglength_diffP1_max],'k')

plot([3,3],[ZIM.veglength_diffP2_min,ZIM.veglength_diffP2_max],'k')
plot([3,3],[ZIM.veglength_diffP2_prctl10,ZIM.veglength_diffP2_prctl90],'k',...
'linewidth',10)
plot(3,ZIM.veglength_diffP2_med,'ok','markerfacecolor','w')
plot([2.8,3.2],[ZIM.veglength_diffP2_min,ZIM.veglength_diffP2_min],'k')
plot([2.8,3.2],[ZIM.veglength_diffP2_max,ZIM.veglength_diffP2_max],'k')

plot([4,4],[ZIM.veglength_diffP3_min,ZIM.veglength_diffP3_max],'k')
plot([4,4],[ZIM.veglength_diffP3_prctl10,ZIM.veglength_diffP3_prctl90],'k',...
'linewidth',10)
plot(4,ZIM.veglength_diffP3_med,'ok','markerfacecolor','w')
plot([3.8,4.2],[ZIM.veglength_diffP3_min,ZIM.veglength_diffP3_min],'k')
plot([3.8,4.2],[ZIM.veglength_diffP3_max,ZIM.veglength_diffP3_max],'k')

plot([5,5],[ZIM.veglength_diffP4_min,ZIM.veglength_diffP4_max],'k')
plot([5,5],[ZIM.veglength_diffP4_prctl10,ZIM.veglength_diffP4_prctl90],'k',...
'linewidth',10)
plot(5,ZIM.veglength_diffP4_med,'ok','markerfacecolor','w')
plot([4.8,5.2],[ZIM.veglength_diffP4_min,ZIM.veglength_diffP4_min],'k')
plot([4.8,5.2],[ZIM.veglength_diffP4_max,ZIM.veglength_diffP4_max],'k')

plot([6,6],[ZIM.veglength_diffP5_min,ZIM.veglength_diffP5_max],'k')
plot([6,6],[ZIM.veglength_diffP5_prctl10,ZIM.veglength_diffP5_prctl90],'k',...
'linewidth',10)
plot(6,ZIM.veglength_diffP5_med,'ok','markerfacecolor','w')
plot([5.8,6.2],[ZIM.veglength_diffP5_min,ZIM.veglength_diffP5_min],'k')
plot([5.8,6.2],[ZIM.veglength_diffP5_max,ZIM.veglength_diffP5_max],'k')


YLim1 = [-100,300];
XLim1 = [0.5,6.5];
bnd_color = [.4 .4 .4];

Ytxt1 = -100-(400/10);
text(0,Ytxt1,'1 year','rotation',45,'horizontalalignment','center')
text(1,Ytxt1,'1 - 10','rotation',45,'horizontalalignment','center')
text(2,Ytxt1,'11 - 20','rotation',45,'horizontalalignment','center')
text(3,Ytxt1,'21 - 30','rotation',45,'horizontalalignment','center')
text(4,Ytxt1,'31 - 40','rotation',45,'horizontalalignment','center')
text(5,Ytxt1,'41 - 50','rotation',45,'horizontalalignment','center')

text(2,300-(400/10),'ZIM','color','r','horizontalalignment','center')

%ylabel('horizontal change of marsh width (m)')
set(gca,'xtick',[],'xticklabel',[],'YGrid','on','box','on')
ylim(YLim1);
xlim(XLim1);

%% HOO -----------------------------------------------------------------------------------------------------
subplot(2,3,4)
plot([1,1],[HOO.veglength_diff1_min,HOO.veglength_diff1_max],'k')
hold on
plot([1,1],[HOO.veglength_diff1_prctl10,HOO.veglength_diff1_prctl90],'k',...
'linewidth',10)
plot(1,HOO.veglength_diff1_med,'ok','markerfacecolor','w')
plot([0.8,1.2],[HOO.veglength_diff1_min,HOO.veglength_diff1_min],'k')
plot([0.8,1.2],[HOO.veglength_diff1_max,HOO.veglength_diff1_max],'k')

plot([2,2],[HOO.veglength_diffP1_min,HOO.veglength_diffP1_max],'k')
plot([2,2],[HOO.veglength_diffP1_prctl10,HOO.veglength_diffP1_prctl90],'k',...
'linewidth',10)
plot(2,HOO.veglength_diffP1_med,'ok','markerfacecolor','w')
plot([1.8,2.2],[HOO.veglength_diffP1_min,HOO.veglength_diffP1_min],'k')
plot([1.8,2.2],[HOO.veglength_diffP1_max,HOO.veglength_diffP1_max],'k')

plot([3,3],[HOO.veglength_diffP2_min,HOO.veglength_diffP2_max],'k')
plot([3,3],[HOO.veglength_diffP2_prctl10,HOO.veglength_diffP2_prctl90],'k',...
'linewidth',10)
plot(3,HOO.veglength_diffP2_med,'ok','markerfacecolor','w')
plot([2.8,3.2],[HOO.veglength_diffP2_min,HOO.veglength_diffP2_min],'k')
plot([2.8,3.2],[HOO.veglength_diffP2_max,HOO.veglength_diffP2_max],'k')

plot([4,4],[HOO.veglength_diffP3_min,HOO.veglength_diffP3_max],'k')
plot([4,4],[HOO.veglength_diffP3_prctl10,HOO.veglength_diffP3_prctl90],'k',...
'linewidth',10)
plot(4,HOO.veglength_diffP3_med,'ok','markerfacecolor','w')
plot([3.8,4.2],[HOO.veglength_diffP3_min,HOO.veglength_diffP3_min],'k')
plot([3.8,4.2],[HOO.veglength_diffP3_max,HOO.veglength_diffP3_max],'k')

plot([5,5],[HOO.veglength_diffP4_min,HOO.veglength_diffP4_max],'k')
plot([5,5],[HOO.veglength_diffP4_prctl10,HOO.veglength_diffP4_prctl90],'k',...
'linewidth',10)
plot(5,HOO.veglength_diffP4_med,'ok','markerfacecolor','w')
plot([4.8,5.2],[HOO.veglength_diffP4_min,HOO.veglength_diffP4_min],'k')
plot([4.8,5.2],[HOO.veglength_diffP4_max,HOO.veglength_diffP4_max],'k')

plot([6,6],[HOO.veglength_diffP5_min,HOO.veglength_diffP5_max],'k')
plot([6,6],[HOO.veglength_diffP5_prctl10,HOO.veglength_diffP5_prctl90],'k',...
'linewidth',10)
plot(6,HOO.veglength_diffP5_med,'ok','markerfacecolor','w')
plot([5.8,6.2],[HOO.veglength_diffP5_min,HOO.veglength_diffP5_min],'k')
plot([5.8,6.2],[HOO.veglength_diffP5_max,HOO.veglength_diffP5_max],'k')


YLim1 = [-100,150];
XLim1 = [0.5,6.5];
bnd_color = [.4 .4 .4];

Ytxt1 = -100-(250/10);
text(0,Ytxt1,'1 year','rotation',45,'horizontalalignment','center')
text(1,Ytxt1,'1 - 10','rotation',45,'horizontalalignment','center')
text(2,Ytxt1,'11 - 20','rotation',45,'horizontalalignment','center')
text(3,Ytxt1,'21 - 30','rotation',45,'horizontalalignment','center')
text(4,Ytxt1,'31 - 40','rotation',45,'horizontalalignment','center')
text(5,Ytxt1,'41 - 50','rotation',45,'horizontalalignment','center')

text(2,150-(250/10),'HOO','color','k','horizontalalignment','center')

text(-2,0,'horizontal change of marsh width (m)','rotation',90)
set(gca,'xtick',[],'xticklabel',[],'YGrid','on','box','on')
ylim(YLim1);
xlim(XLim1);

%% PAU -----------------------------------------------------------------------------------------------------
subplot(2,3,5)
plot([1,1],[PAU.veglength_diff1_min,PAU.veglength_diff1_max],'k')
hold on
plot([1,1],[PAU.veglength_diff1_prctl10,PAU.veglength_diff1_prctl90],'k',...
'linewidth',10)
plot(1,PAU.veglength_diff1_med,'ok','markerfacecolor','w')
plot([0.8,1.2],[PAU.veglength_diff1_min,PAU.veglength_diff1_min],'k')
plot([0.8,1.2],[PAU.veglength_diff1_max,PAU.veglength_diff1_max],'k')

plot([2,2],[PAU.veglength_diffP1_min,PAU.veglength_diffP1_max],'k')
plot([2,2],[PAU.veglength_diffP1_prctl10,PAU.veglength_diffP1_prctl90],'k',...
'linewidth',10)
plot(2,PAU.veglength_diffP1_med,'ok','markerfacecolor','w')
plot([1.8,2.2],[PAU.veglength_diffP1_min,PAU.veglength_diffP1_min],'k')
plot([1.8,2.2],[PAU.veglength_diffP1_max,PAU.veglength_diffP1_max],'k')

plot([3,3],[PAU.veglength_diffP2_min,PAU.veglength_diffP2_max],'k')
plot([3,3],[PAU.veglength_diffP2_prctl10,PAU.veglength_diffP2_prctl90],'k',...
'linewidth',10)
plot(3,PAU.veglength_diffP2_med,'ok','markerfacecolor','w')
plot([2.8,3.2],[PAU.veglength_diffP2_min,PAU.veglength_diffP2_min],'k')
plot([2.8,3.2],[PAU.veglength_diffP2_max,PAU.veglength_diffP2_max],'k')

plot([4,4],[PAU.veglength_diffP3_min,PAU.veglength_diffP3_max],'k')
plot([4,4],[PAU.veglength_diffP3_prctl10,PAU.veglength_diffP3_prctl90],'k',...
'linewidth',10)
plot(4,PAU.veglength_diffP3_med,'ok','markerfacecolor','w')
plot([3.8,4.2],[PAU.veglength_diffP3_min,PAU.veglength_diffP3_min],'k')
plot([3.8,4.2],[PAU.veglength_diffP3_max,PAU.veglength_diffP3_max],'k')

plot([5,5],[PAU.veglength_diffP4_min,PAU.veglength_diffP4_max],'k')
plot([5,5],[PAU.veglength_diffP4_prctl10,PAU.veglength_diffP4_prctl90],'k',...
'linewidth',10)
plot(5,PAU.veglength_diffP4_med,'ok','markerfacecolor','w')
plot([4.8,5.2],[PAU.veglength_diffP4_min,PAU.veglength_diffP4_min],'k')
plot([4.8,5.2],[PAU.veglength_diffP4_max,PAU.veglength_diffP4_max],'k')

plot([6,6],[PAU.veglength_diffP5_min,PAU.veglength_diffP5_max],'k')
plot([6,6],[PAU.veglength_diffP5_prctl10,PAU.veglength_diffP5_prctl90],'k',...
'linewidth',10)
plot(6,PAU.veglength_diffP5_med,'ok','markerfacecolor','w')
plot([5.8,6.2],[PAU.veglength_diffP5_min,PAU.veglength_diffP5_min],'k')
plot([5.8,6.2],[PAU.veglength_diffP5_max,PAU.veglength_diffP5_max],'k')


YLim1 = [-350,250];
XLim1 = [0.5,6.5];
bnd_color = [.4 .4 .4];

Ytxt1 = -350-(600/10);
text(0,Ytxt1,'1 year','rotation',45,'horizontalalignment','center')
text(1,Ytxt1,'1 - 10','rotation',45,'horizontalalignment','center')
text(2,Ytxt1,'11 - 20','rotation',45,'horizontalalignment','center')
text(3,Ytxt1,'21 - 30','rotation',45,'horizontalalignment','center')
text(4,Ytxt1,'31 - 40','rotation',45,'horizontalalignment','center')
text(5,Ytxt1,'41 - 50','rotation',45,'horizontalalignment','center')

text(2,250-(600/10),'PAU','color','k','horizontalalignment','center')

%ylabel('change of marsh width (m)')
set(gca,'xtick',[],'xticklabel',[],'YGrid','on','box','on')
ylim(YLim1);
xlim(XLim1);

%% HEL -----------------------------------------------------------------------------------------------------
subplot(2,3,6)
plot([1,1],[HEL.veglength_diff1_min,HEL.veglength_diff1_max],'k')
hold on
plot([1,1],[HEL.veglength_diff1_prctl10,HEL.veglength_diff1_prctl90],'k',...
'linewidth',10)
plot(1,HEL.veglength_diff1_med,'ok','markerfacecolor','w')
plot([0.8,1.2],[HEL.veglength_diff1_min,HEL.veglength_diff1_min],'k')
plot([0.8,1.2],[HEL.veglength_diff1_max,HEL.veglength_diff1_max],'k')

plot([2,2],[HEL.veglength_diffP1_min,HEL.veglength_diffP1_max],'k')
plot([2,2],[HEL.veglength_diffP1_prctl10,HEL.veglength_diffP1_prctl90],'k',...
'linewidth',10)
plot(2,HEL.veglength_diffP1_med,'ok','markerfacecolor','w')
plot([1.8,2.2],[HEL.veglength_diffP1_min,HEL.veglength_diffP1_min],'k')
plot([1.8,2.2],[HEL.veglength_diffP1_max,HEL.veglength_diffP1_max],'k')

plot([3,3],[HEL.veglength_diffP2_min,HEL.veglength_diffP2_max],'k')
plot([3,3],[HEL.veglength_diffP2_prctl10,HEL.veglength_diffP2_prctl90],'k',...
'linewidth',10)
plot(3,HEL.veglength_diffP2_med,'ok','markerfacecolor','w')
plot([2.8,3.2],[HEL.veglength_diffP2_min,HEL.veglength_diffP2_min],'k')
plot([2.8,3.2],[HEL.veglength_diffP2_max,HEL.veglength_diffP2_max],'k')

plot([4,4],[HEL.veglength_diffP3_min,HEL.veglength_diffP3_max],'k')
plot([4,4],[HEL.veglength_diffP3_prctl10,HEL.veglength_diffP3_prctl90],'k',...
'linewidth',10)
plot(4,HEL.veglength_diffP3_med,'ok','markerfacecolor','w')
plot([3.8,4.2],[HEL.veglength_diffP3_min,HEL.veglength_diffP3_min],'k')
plot([3.8,4.2],[HEL.veglength_diffP3_max,HEL.veglength_diffP3_max],'k')

plot([5,5],[HEL.veglength_diffP4_min,HEL.veglength_diffP4_max],'k')
plot([5,5],[HEL.veglength_diffP4_prctl10,HEL.veglength_diffP4_prctl90],'k',...
'linewidth',10)
plot(5,HEL.veglength_diffP4_med,'ok','markerfacecolor','w')
plot([4.8,5.2],[HEL.veglength_diffP4_min,HEL.veglength_diffP4_min],'k')
plot([4.8,5.2],[HEL.veglength_diffP4_max,HEL.veglength_diffP4_max],'k')

plot([6,6],[HEL.veglength_diffP5_min,HEL.veglength_diffP5_max],'k')
plot([6,6],[HEL.veglength_diffP5_prctl10,HEL.veglength_diffP5_prctl90],'k',...
'linewidth',10)
plot(6,HEL.veglength_diffP5_med,'ok','markerfacecolor','w')
plot([5.8,6.2],[HEL.veglength_diffP5_min,HEL.veglength_diffP5_min],'k')
plot([5.8,6.2],[HEL.veglength_diffP5_max,HEL.veglength_diffP5_max],'k')


YLim1 = [-250,300];
XLim1 = [0.5,6.5];
bnd_color = [.4 .4 .4];

Ytxt1 = -250-(550/10);
text(0,Ytxt1,'1 year','rotation',45,'horizontalalignment','center')
text(1,Ytxt1,'1 - 10','rotation',45,'horizontalalignment','center')
text(2,Ytxt1,'11 - 20','rotation',45,'horizontalalignment','center')
text(3,Ytxt1,'21 - 30','rotation',45,'horizontalalignment','center')
text(4,Ytxt1,'31 - 40','rotation',45,'horizontalalignment','center')
text(5,Ytxt1,'41 - 50','rotation',45,'horizontalalignment','center')
text(2,300-(550/10),'HEL','color','k','horizontalalignment','center')

%ylabel('horizontal change of marsh width (m/year)')
set(gca,'xtick',[],'xticklabel',[],'YGrid','on','box','on')
ylim(YLim1);
xlim(XLim1);

figuurdimensies(bf,hf)
cd M:\Documents\PhD\Scripts\MATLAB\Chapter1\altmany-export_fig-412662f
%export_fig MS_Fig6 -dpng -r864 -transparent -p1
%print('MS_Fig6.png','-dpng')
