%% Analyse wave attenuation data of all foreshores in the Westerschelde based on Vaklodingen and SWAN analysis
close all; clear all; clc;

%% Load and summarize data
addpath('M:\Documents\PhD\Scripts\MATLAB\Chapter1');

%---Zuidgors--- #Transects=11 (9 effective) --- #Years=37 ---
ZUI.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Zuidgors_S250\Zuidgors_S250.mat')
ZUI.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Zuidgors_S250\Zuidgors_S250.mat');
ZUI.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Zuidgors_S250\Zuidgors_S250.mat');
ZUI.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Zuidgors_S250.mat');

for i = 1:9
    ZUI.result_length(i) = length(ZUI.ScN.result(i).year(1).Hsig)*5;
    for j = 1:37
        ZUI.ScN.result_matr_Hsig(j,i) = min(ZUI.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1)
            ZUI.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1);
        else
            ZUI.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1))
            ZUI.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1));
        else
            ZUI.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1)
            ZUI.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(find...
                (ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1);
        else
            ZUI.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScN.result(i).year(j).Hsig(end);
        end
        
        ZUI.ScD.result_matr_Hsig(j,i) = min(ZUI.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1)
            ZUI.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1);
        else
            ZUI.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1))
            ZUI.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1));
        else
            ZUI.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1)
            ZUI.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(find...
                (ZUI.ScD.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1);
        else
            ZUI.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScD.result(i).year(j).Hsig(end);
        end
        
        ZUI.ScDV.result_matr_Hsig(j,i) = min(ZUI.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1)
            ZUI.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.h_daily,1)-1);
        else
            ZUI.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1))
            ZUI.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS,1));
        else
            ZUI.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1)
            ZUI.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(find...
                (ZUI.ScDV.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge,1)-1);
        else
            ZUI.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZUI.ScDV.result(i).year(j).Hsig(end);
        end
        
        ZUI.result_veglength(j,i) = nansum(ZUI.input.Zuidgors_S250.Veg{i}(j,:))*5;
        ZUI.result_relveglength(j,i) = (ZUI.result_veglength(j,i)/ZUI.result_length(i)).*100;
        ZUI.result_barelength(j,i) =...
            length(find(ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.MLWS &...
            ZUI.ScN.result(i).year(j).Botlev>-ZUI.input.Zuidgors_S250.veg_edge))*5;
    end
end

ZUI.result_trans_relveglength = min(ZUI.result_relveglength);
ZUI.result_mm_trans_relveglength =...
    [min(ZUI.result_trans_relveglength),max(ZUI.result_trans_relveglength)];
ZUI.result_mean_trans_relveglength =...
    mean(ZUI.result_trans_relveglength);

ZUI.ScN.result_matr_Hsig(ZUI.ScN.result_matr_Hsig<0) = 0;
ZUI.ScN.result_matr_Hsig_MHWS(ZUI.ScN.result_matr_Hsig_MHWS<0) = 0;
ZUI.ScN.result_matr_WA = (1-ZUI.ScN.result_matr_Hsig./1.6550).*100;
ZUI.ScN.result_matr_WA_MHWS =...
    (ZUI.ScN.result_matr_Hsig_MLWS./1.6550-ZUI.ScN.result_matr_Hsig_MHWS./1.6550).*100;
ZUI.ScN.result_matr_WA_bar =...
    (ZUI.ScN.result_matr_Hsig_MLWS./1.6550-ZUI.ScN.result_matr_Hsig_vegedge./1.6550).*100;
ZUI.ScN.result_matr_WA_veg =...
    (ZUI.ScN.result_matr_Hsig_vegedge./1.6550-ZUI.ScN.result_matr_Hsig_MHWS./1.6550).*100;
ZUI.ScN.result_trans_WA = min(ZUI.ScN.result_matr_WA_MHWS);
ZUI.ScN.result_mm_WA = [min(ZUI.ScN.result_trans_WA),max(ZUI.ScN.result_trans_WA)];
ZUI.ScN.result_mean_WA = mean(ZUI.ScN.result_trans_WA);

ZUI.ScD.result_matr_Hsig(ZUI.ScD.result_matr_Hsig<0) = 0;
ZUI.ScD.result_matr_Hsig_MHWS(ZUI.ScD.result_matr_Hsig_MHWS<0) = 0;
ZUI.ScD.result_matr_WA = (1-ZUI.ScD.result_matr_Hsig./0.2).*100;
ZUI.ScD.result_matr_WA_MHWS =...
    (ZUI.ScD.result_matr_Hsig_MLWS./0.2-ZUI.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScD.result_matr_WA_bar =...
    (ZUI.ScD.result_matr_Hsig_MLWS./0.2-ZUI.ScD.result_matr_Hsig_vegedge./0.2).*100;
ZUI.ScD.result_matr_WA_veg =...
    (ZUI.ScD.result_matr_Hsig_vegedge./0.2-ZUI.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScD.result_trans_WA = nanmin(ZUI.ScD.result_matr_WA_MHWS);
ZUI.ScD.result_mm_WA = [min(ZUI.ScD.result_trans_WA),max(ZUI.ScD.result_trans_WA)];
ZUI.ScD.result_mean_WA = nanmean(ZUI.ScD.result_trans_WA);

ZUI.ScDV.result_matr_Hsig(ZUI.ScDV.result_matr_Hsig<0) = 0;
ZUI.ScDV.result_matr_Hsig_MHWS(ZUI.ScDV.result_matr_Hsig_MHWS<0) = 0;
ZUI.ScDV.result_matr_WA = (1-ZUI.ScDV.result_matr_Hsig./0.2).*100;
ZUI.ScDV.result_matr_WA_MHWS =...
    (ZUI.ScDV.result_matr_Hsig_MLWS./0.2-ZUI.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScDV.result_matr_WA_bar =...
    (ZUI.ScDV.result_matr_Hsig_MLWS./0.2-ZUI.ScDV.result_matr_Hsig_vegedge./0.2).*100;
ZUI.ScDV.result_matr_WA_veg =...
    (ZUI.ScDV.result_matr_Hsig_vegedge./0.2-ZUI.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZUI.ScDV.result_trans_WA = nanmin(ZUI.ScDV.result_matr_WA_MHWS);
ZUI.ScDV.result_mm_WA = [min(ZUI.ScDV.result_trans_WA),max(ZUI.ScDV.result_trans_WA)];
ZUI.ScDV.result_mean_WA = nanmean(ZUI.ScDV.result_trans_WA);

%---Baarland--- #Transects=7 (3 effective) --- #Years=37 ---
BAA.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Baarland_S250\Baarland_S250.mat')
BAA.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Baarland_S250\Baarland_S250.mat');
BAA.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Baarland_S250\Baarland_S250.mat');
BAA.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Baarland_S250.mat');

for i = 1:3
    BAA.result_length(i) = length(BAA.ScN.result(i).year(1).Hsig)*5;
    for j = 1:37
        BAA.ScN.result_matr_Hsig(j,i) = min(BAA.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1)
            BAA.ScN.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1);
        else
            BAA.ScN.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1))
            BAA.ScN.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1));
        else
            BAA.ScN.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1)
            BAA.ScN.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(find...
                (BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1);
        else
            BAA.ScN.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScN.result(i).year(j).Hsig(end);
        end
        
        BAA.ScD.result_matr_Hsig(j,i) = min(BAA.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1)
            BAA.ScD.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1);
        else
            BAA.ScD.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1))
            BAA.ScD.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1));
        else
            BAA.ScD.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1)
            BAA.ScD.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(find...
                (BAA.ScD.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1);
        else
            BAA.ScD.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScD.result(i).year(j).Hsig(end);
        end
        
        BAA.ScDV.result_matr_Hsig(j,i) = min(BAA.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1)
            BAA.ScDV.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.h_daily,1)-1);
        else
            BAA.ScDV.result_matr_Hsig_MHWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1))
            BAA.ScDV.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS,1));
        else
            BAA.ScDV.result_matr_Hsig_MLWS(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1)
            BAA.ScDV.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(find...
                (BAA.ScDV.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge,1)-1);
        else
            BAA.ScDV.result_matr_Hsig_vegedge(j,i) =...
                BAA.ScDV.result(i).year(j).Hsig(end);
        end
        BAA.result_veglength(j,i) = nansum(BAA.input.Baarland_S250.Veg{i}(j,:))*5;
        BAA.result_relveglength(j,i) = (BAA.result_veglength(j,i)/BAA.result_length(i)).*100;
        BAA.result_barelength(j,i) =...
            length(find(BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.MLWS &...
            BAA.ScN.result(i).year(j).Botlev>-BAA.input.Baarland_S250.veg_edge))*5;
    end
end

BAA.result_trans_relveglength = min(BAA.result_relveglength);
BAA.result_mm_trans_relveglength =...
    [min(BAA.result_trans_relveglength),max(BAA.result_trans_relveglength)];
BAA.result_mean_trans_relveglength =...
    mean(BAA.result_trans_relveglength);

BAA.ScN.result_matr_Hsig(BAA.ScN.result_matr_Hsig<0) = NaN;
BAA.ScN.result_matr_Hsig_MHWS(BAA.ScN.result_matr_Hsig_MHWS<0) = NaN;
BAA.ScN.result_matr_WA = (1-BAA.ScN.result_matr_Hsig./1.7200).*100;
BAA.ScN.result_matr_WA_MHWS =...
    (BAA.ScN.result_matr_Hsig_MLWS./1.7200-BAA.ScN.result_matr_Hsig_MHWS./1.7200).*100;
BAA.ScN.result_matr_WA_bar =...
    (BAA.ScN.result_matr_Hsig_MLWS./1.7200-BAA.ScN.result_matr_Hsig_vegedge./1.7200).*100;
BAA.ScN.result_matr_WA_veg =...
    (BAA.ScN.result_matr_Hsig_vegedge./1.7200-BAA.ScN.result_matr_Hsig_MHWS./1.7200).*100;
BAA.ScN.result_trans_WA = min(BAA.ScN.result_matr_WA_MHWS);
BAA.ScN.result_mm_WA = [min(BAA.ScN.result_trans_WA(1:3)),max(BAA.ScN.result_trans_WA(1:3))];
BAA.ScN.result_mean_WA = mean(BAA.ScN.result_trans_WA);

BAA.ScD.result_matr_Hsig(BAA.ScD.result_matr_Hsig<0) = NaN;
BAA.ScD.result_matr_Hsig_MHWS(BAA.ScD.result_matr_Hsig_MHWS<0) = NaN;
BAA.ScD.result_matr_WA = (1-BAA.ScD.result_matr_Hsig./0.2).*100;
BAA.ScD.result_matr_WA_MHWS =...
    (BAA.ScD.result_matr_Hsig_MLWS./0.2-BAA.ScD.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScD.result_matr_WA_bar =...
    (BAA.ScD.result_matr_Hsig_MLWS./0.2-BAA.ScD.result_matr_Hsig_vegedge./0.2).*100;
BAA.ScD.result_matr_WA_veg =...
    (BAA.ScD.result_matr_Hsig_vegedge./0.2-BAA.ScD.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScD.result_trans_WA = min(BAA.ScD.result_matr_WA_MHWS);
BAA.ScD.result_mm_WA = [min(BAA.ScD.result_trans_WA(1:3)),max(BAA.ScD.result_trans_WA(1:3))];
BAA.ScD.result_mean_WA = mean(BAA.ScD.result_trans_WA);

BAA.ScDV.result_matr_Hsig(BAA.ScDV.result_matr_Hsig<0) = NaN;
BAA.ScDV.result_matr_Hsig_MHWS(BAA.ScDV.result_matr_Hsig_MHWS<0) = NaN;
BAA.ScDV.result_matr_WA = (1-BAA.ScDV.result_matr_Hsig./0.2).*100;
BAA.ScDV.result_matr_WA_MHWS =...
    (BAA.ScDV.result_matr_Hsig_MLWS./0.2-BAA.ScDV.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScDV.result_matr_WA_bar =...
    (BAA.ScDV.result_matr_Hsig_MLWS./0.2-BAA.ScDV.result_matr_Hsig_vegedge./0.2).*100;
BAA.ScDV.result_matr_WA_veg =...
    (BAA.ScDV.result_matr_Hsig_vegedge./0.2-BAA.ScDV.result_matr_Hsig_MHWS./0.2).*100;
BAA.ScDV.result_trans_WA = min(BAA.ScDV.result_matr_WA_MHWS);
BAA.ScDV.result_mm_WA = [min(BAA.ScDV.result_trans_WA(1:3)),max(BAA.ScDV.result_trans_WA(1:3))];
BAA.ScDV.result_mean_WA = mean(BAA.ScDV.result_trans_WA);

%---Zimmermanpolder--- #Transects=6 (5 effective) --- #Years=51 ---
ZIM.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Zimmermanpolder_S250\Zimmermanpolder_S250.mat')
ZIM.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Zimmermanpolder_S250\Zimmermanpolder_S250.mat');
ZIM.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Zimmermanpolder_S250\Zimmermanpolder_S250.mat');
ZIM.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Zimmermanpolder_S250.mat');

for i = 1:5
    ZIM.result_length(i) = length(ZIM.ScN.result(i).year(1).Hsig)*5;
    for j = 1:51
        ZIM.ScN.result_matr_Hsig(j,i) = min(ZIM.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1)
            ZIM.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1);
        else
            ZIM.ScN.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1))
            ZIM.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1));
        else
            ZIM.ScN.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1)
            ZIM.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(find...
                (ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1);
        else
            ZIM.ScN.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScN.result(i).year(j).Hsig(end);
        end
        
        ZIM.ScD.result_matr_Hsig(j,i) = min(ZIM.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1)
            ZIM.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1);
        else
            ZIM.ScD.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1))
            ZIM.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1));
        else
            ZIM.ScD.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1)
            ZIM.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(find...
                (ZIM.ScD.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1);
        else
            ZIM.ScD.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScD.result(i).year(j).Hsig(end);
        end
        
        ZIM.ScDV.result_matr_Hsig(j,i) = min(ZIM.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1)
            ZIM.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.h_daily,1)-1);
        else
            ZIM.ScDV.result_matr_Hsig_MHWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1))
            ZIM.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS,1));
        else
            ZIM.ScDV.result_matr_Hsig_MLWS(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1)
            ZIM.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(find...
                (ZIM.ScDV.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge,1)-1);
        else
            ZIM.ScDV.result_matr_Hsig_vegedge(j,i) =...
                ZIM.ScDV.result(i).year(j).Hsig(end);
        end
        ZIM.result_veglength(j,i) = nansum(ZIM.input.Zimmermanpolder_S250.Veg{i}(j,:))*5;
        ZIM.result_relveglength(j,i) = (ZIM.result_veglength(j,i)/ZIM.result_length(i)).*100;
        ZIM.result_barelength(j,i) =...
            length(find(ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.MLWS &...
            ZIM.ScN.result(i).year(j).Botlev>-ZIM.input.Zimmermanpolder_S250.veg_edge))*5;
    end
end

ZIM.result_trans_relveglength = min(ZIM.result_relveglength);
ZIM.result_mm_trans_relveglength =...
    [min(ZIM.result_trans_relveglength),max(ZIM.result_trans_relveglength)];
ZIM.result_mean_trans_relveglength =...
    mean(ZIM.result_trans_relveglength);

ZIM.ScN.result_matr_Hsig(ZIM.ScN.result_matr_Hsig<0) = NaN;
ZIM.ScN.result_matr_Hsig_MHWS(ZIM.ScN.result_matr_Hsig_MHWS<0) = NaN;
ZIM.ScN.result_matr_WA = (1-ZIM.ScN.result_matr_Hsig./1.8150).*100;
ZIM.ScN.result_matr_WA_MHWS =...
    (ZIM.ScN.result_matr_Hsig_MLWS./1.8150-ZIM.ScN.result_matr_Hsig_MHWS./1.8150).*100;
ZIM.ScN.result_matr_WA_bar =...
    (ZIM.ScN.result_matr_Hsig_MLWS./1.8150-ZIM.ScN.result_matr_Hsig_vegedge./1.8150).*100;
ZIM.ScN.result_matr_WA_veg =...
    (ZIM.ScN.result_matr_Hsig_vegedge./1.8150-ZIM.ScN.result_matr_Hsig_MHWS./1.8150).*100;
ZIM.ScN.result_trans_WA = min(ZIM.ScN.result_matr_WA_MHWS);
ZIM.ScN.result_mm_WA = [min(ZIM.ScN.result_trans_WA(1:5)),max(ZIM.ScN.result_trans_WA(1:5))];
ZIM.ScN.result_mean_WA = mean(ZIM.ScN.result_trans_WA);

ZIM.ScD.result_matr_Hsig(ZIM.ScD.result_matr_Hsig<0) = NaN;
ZIM.ScD.result_matr_Hsig_MHWS(ZIM.ScD.result_matr_Hsig_MHWS<0) = NaN;
ZIM.ScD.result_matr_WA = (1-ZIM.ScD.result_matr_Hsig./0.2).*100;
ZIM.ScD.result_matr_WA_MHWS =...
    (ZIM.ScD.result_matr_Hsig_MLWS./0.2-ZIM.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScD.result_matr_WA_bar =...
    (ZIM.ScD.result_matr_Hsig_MLWS./0.2-ZIM.ScD.result_matr_Hsig_vegedge./0.2).*100;
ZIM.ScD.result_matr_WA_veg =...
    (ZIM.ScD.result_matr_Hsig_vegedge./0.2-ZIM.ScD.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScD.result_trans_WA = min(ZIM.ScD.result_matr_WA_MHWS);
ZIM.ScD.result_mm_WA = [min(ZIM.ScD.result_trans_WA(1:5)),max(ZIM.ScD.result_trans_WA(1:5))];
ZIM.ScD.result_mean_WA = mean(ZIM.ScD.result_trans_WA);

ZIM.ScDV.result_matr_Hsig(ZIM.ScDV.result_matr_Hsig<0) = NaN;
ZIM.ScDV.result_matr_Hsig_MHWS(ZIM.ScDV.result_matr_Hsig_MHWS<0) = NaN;
ZIM.ScDV.result_matr_WA = (1-ZIM.ScDV.result_matr_Hsig./0.2).*100;
ZIM.ScDV.result_matr_WA_MHWS =...
    (ZIM.ScDV.result_matr_Hsig_MLWS./0.2-ZIM.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScDV.result_matr_WA_bar =...
    (ZIM.ScDV.result_matr_Hsig_MLWS./0.2-ZIM.ScDV.result_matr_Hsig_vegedge./0.2).*100;
ZIM.ScDV.result_matr_WA_veg =...
    (ZIM.ScDV.result_matr_Hsig_vegedge./0.2-ZIM.ScDV.result_matr_Hsig_MHWS./0.2).*100;
ZIM.ScDV.result_trans_WA = min(ZIM.ScDV.result_matr_WA_MHWS);
ZIM.ScDV.result_mm_WA = [min(ZIM.ScDV.result_trans_WA(1:5)),max(ZIM.ScDV.result_trans_WA(1:5))];
ZIM.ScDV.result_mean_WA = mean(ZIM.ScDV.result_trans_WA);

%---Hoofdplaat--- #Transects=6 --- #Years=42 ---
HOO.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Hoofdplaat_S250\Hoofdplaat_S250.mat')
HOO.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Hoofdplaat_S250\Hoofdplaat_S250.mat');
HOO.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Hoofdplaat_S250\Hoofdplaat_S250.mat');
HOO.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Hoofdplaat_S250.mat');

for i = 1:6
    HOO.result_length(i) = length(HOO.ScN.result(i).year(1).Hsig)*5;
    for j = 1:42
        HOO.ScN.result_matr_Hsig(j,i) = min(HOO.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1)
            HOO.ScN.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1);
        else
            HOO.ScN.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1))
            HOO.ScN.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1));
        else
            HOO.ScN.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1)
            HOO.ScN.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(find...
                (HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1);
        else
            HOO.ScN.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScN.result(i).year(j).Hsig(end);
        end
        
        HOO.ScD.result_matr_Hsig(j,i) = min(HOO.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1)
            HOO.ScD.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1);
        else
            HOO.ScD.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1))
            HOO.ScD.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1));
        else
            HOO.ScD.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1)
            HOO.ScD.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(find...
                (HOO.ScD.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1);
        else
            HOO.ScD.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScD.result(i).year(j).Hsig(end);
        end
        
        HOO.ScDV.result_matr_Hsig(j,i) = min(HOO.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1)
            HOO.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.h_daily,1)-1);
        else
            HOO.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1))
            HOO.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS,1));
        else
            HOO.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1)
            HOO.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(find...
                (HOO.ScDV.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge,1)-1);
        else
            HOO.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HOO.ScDV.result(i).year(j).Hsig(end);
        end
        HOO.result_veglength(j,i) = nansum(HOO.input.Hoofdplaat_S250.Veg{i}(j,:))*5;
        HOO.result_relveglength(j,i) = (HOO.result_veglength(j,i)/HOO.result_length(i)).*100;
        HOO.result_barelength(j,i) =...
            length(find(HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.MLWS &...
            HOO.ScN.result(i).year(j).Botlev>-HOO.input.Hoofdplaat_S250.veg_edge))*5;
    end
end

HOO.result_trans_relveglength = min(HOO.result_relveglength);
HOO.result_mm_trans_relveglength =...
    [min(HOO.result_trans_relveglength),max(HOO.result_trans_relveglength)];
HOO.result_mean_trans_relveglength =...
    mean(HOO.result_trans_relveglength);

HOO.ScN.result_matr_Hsig(HOO.ScN.result_matr_Hsig<0) = NaN;
HOO.ScN.result_matr_Hsig_MHWS(HOO.ScN.result_matr_Hsig_MHWS<0) = NaN;
HOO.ScN.result_matr_WA = (1-HOO.ScN.result_matr_Hsig./2.3600).*100;
HOO.ScN.result_matr_WA_MHWS =...
    (HOO.ScN.result_matr_Hsig_MLWS./2.3600-HOO.ScN.result_matr_Hsig_MHWS./2.3600).*100;
HOO.ScN.result_matr_WA_bar =...
    (HOO.ScN.result_matr_Hsig_MLWS./2.3600-HOO.ScN.result_matr_Hsig_vegedge./2.3600).*100;
HOO.ScN.result_matr_WA_veg =...
    (HOO.ScN.result_matr_Hsig_vegedge./2.3600-HOO.ScN.result_matr_Hsig_MHWS./2.3600).*100;
HOO.ScN.result_trans_WA = min(HOO.ScN.result_matr_WA_MHWS);
HOO.ScN.result_mm_WA = [min(HOO.ScN.result_trans_WA),max(HOO.ScN.result_trans_WA)];
HOO.ScN.result_mean_WA = mean(HOO.ScN.result_trans_WA);

HOO.ScD.result_matr_Hsig(HOO.ScD.result_matr_Hsig<0) = NaN;
HOO.ScD.result_matr_Hsig_MHWS(HOO.ScD.result_matr_Hsig_MHWS<0) = NaN;
HOO.ScD.result_matr_WA = (1-HOO.ScD.result_matr_Hsig./0.2).*100;
HOO.ScD.result_matr_WA_MHWS =...
    (HOO.ScD.result_matr_Hsig_MLWS./0.2-HOO.ScD.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScD.result_matr_WA_bar =...
    (HOO.ScD.result_matr_Hsig_MLWS./0.2-HOO.ScD.result_matr_Hsig_vegedge./0.2).*100;
HOO.ScD.result_matr_WA_veg =...
    (HOO.ScD.result_matr_Hsig_vegedge./0.2-HOO.ScD.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScD.result_trans_WA = min(HOO.ScD.result_matr_WA_MHWS);
HOO.ScD.result_mm_WA = [min(HOO.ScD.result_trans_WA),max(HOO.ScD.result_trans_WA)];
HOO.ScD.result_mean_WA = mean(HOO.ScD.result_trans_WA);

HOO.ScDV.result_matr_Hsig(HOO.ScDV.result_matr_Hsig<0) = NaN;
HOO.ScDV.result_matr_Hsig_MHWS(HOO.ScDV.result_matr_Hsig_MHWS<0) = NaN;
HOO.ScDV.result_matr_WA = (1-HOO.ScDV.result_matr_Hsig./0.2).*100;
HOO.ScDV.result_matr_WA_MHWS =...
    (HOO.ScDV.result_matr_Hsig_MLWS./0.2-HOO.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScDV.result_matr_WA_bar =...
    (HOO.ScDV.result_matr_Hsig_MLWS./0.2-HOO.ScDV.result_matr_Hsig_vegedge./0.2).*100;
HOO.ScDV.result_matr_WA_veg =...
    (HOO.ScDV.result_matr_Hsig_vegedge./0.2-HOO.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HOO.ScDV.result_trans_WA = min(HOO.ScDV.result_matr_WA_MHWS);
HOO.ScDV.result_mm_WA = [min(HOO.ScDV.result_trans_WA),max(HOO.ScDV.result_trans_WA)];
HOO.ScDV.result_mean_WA = mean(HOO.ScDV.result_trans_WA);

%---Paulinapolder--- #Transects=7 --- #Years=41 ---
PAU.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Paulinapolder_S250\Paulinapolder_S250.mat')
PAU.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Paulinapolder_S250\Paulinapolder_S250.mat');
PAU.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Paulinapolder_S250\Paulinapolder_S250.mat');
PAU.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Paulinapolder_S250.mat');

for i = 1:7
    PAU.result_length(i) = length(PAU.ScN.result(i).year(1).Hsig)*5;
    for j = 1:41
        PAU.ScN.result_matr_Hsig(j,i) = min(PAU.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1)
            PAU.ScN.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1);
        else
            PAU.ScN.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1))
            PAU.ScN.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1));
        else
            PAU.ScN.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1)
            PAU.ScN.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(find...
                (PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1);
        else
            PAU.ScN.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScN.result(i).year(j).Hsig(end);
        end
        
        PAU.ScD.result_matr_Hsig(j,i) = min(PAU.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1)
            PAU.ScD.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1);
        else
            PAU.ScD.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1))
            PAU.ScD.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1));
        else
            PAU.ScD.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1)
            PAU.ScD.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(find...
                (PAU.ScD.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1);
        else
            PAU.ScD.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScD.result(i).year(j).Hsig(end);
        end
        
        PAU.ScDV.result_matr_Hsig(j,i) = min(PAU.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1)
            PAU.ScDV.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.h_daily,1)-1);
        else
            PAU.ScDV.result_matr_Hsig_MHWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1))
            PAU.ScDV.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS,1));
        else
            PAU.ScDV.result_matr_Hsig_MLWS(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1)
            PAU.ScDV.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(find...
                (PAU.ScDV.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge,1)-1);
        else
            PAU.ScDV.result_matr_Hsig_vegedge(j,i) =...
                PAU.ScDV.result(i).year(j).Hsig(end);
        end
        PAU.result_veglength(j,i) = nansum(PAU.input.Paulinapolder_S250.Veg{i}(j,:))*5;
        PAU.result_relveglength(j,i) = (PAU.result_veglength(j,i)/PAU.result_length(i)).*100;
        PAU.result_barelength(j,i) =...
            length(find(PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.MLWS &...
            PAU.ScN.result(i).year(j).Botlev>-PAU.input.Paulinapolder_S250.veg_edge))*5;
    end
end

PAU.result_trans_relveglength = min(PAU.result_relveglength);
PAU.result_mm_trans_relveglength =...
    [min(PAU.result_trans_relveglength),max(PAU.result_trans_relveglength)];
PAU.result_mean_trans_relveglength =...
    mean(PAU.result_trans_relveglength);

PAU.ScN.result_matr_Hsig(PAU.ScN.result_matr_Hsig<0) = NaN;
PAU.ScN.result_matr_Hsig_MHWS(PAU.ScN.result_matr_Hsig_MHWS<0) = NaN;
PAU.ScN.result_matr_WA = (1-PAU.ScN.result_matr_Hsig./2.1450).*100;
PAU.ScN.result_matr_WA_MHWS =...
    (PAU.ScN.result_matr_Hsig_MLWS./2.1450-PAU.ScN.result_matr_Hsig_MHWS./2.1450).*100;
PAU.ScN.result_matr_WA_bar =...
    (PAU.ScN.result_matr_Hsig_MLWS./2.1450-PAU.ScN.result_matr_Hsig_vegedge./2.1450).*100;
PAU.ScN.result_matr_WA_veg =...
    (PAU.ScN.result_matr_Hsig_vegedge./2.1450-PAU.ScN.result_matr_Hsig_MHWS./2.1450).*100;
PAU.ScN.result_trans_WA = min(PAU.ScN.result_matr_WA_MHWS);
PAU.ScN.result_mm_WA = [min(PAU.ScN.result_trans_WA),max(PAU.ScN.result_trans_WA)];
PAU.ScN.result_mean_WA = mean(PAU.ScN.result_trans_WA);

PAU.ScD.result_matr_Hsig(PAU.ScD.result_matr_Hsig<0) = NaN;
PAU.ScD.result_matr_Hsig_MHWS(PAU.ScD.result_matr_Hsig_MHWS<0) = NaN;
PAU.ScD.result_matr_WA = (1-PAU.ScD.result_matr_Hsig./0.2).*100;
PAU.ScD.result_matr_WA_MHWS =...
    (PAU.ScD.result_matr_Hsig_MLWS./0.2-PAU.ScD.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScD.result_matr_WA_bar =...
    (PAU.ScD.result_matr_Hsig_MLWS./0.2-PAU.ScD.result_matr_Hsig_vegedge./0.2).*100;
PAU.ScD.result_matr_WA_veg =...
    (PAU.ScD.result_matr_Hsig_vegedge./0.2-PAU.ScD.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScD.result_trans_WA = min(PAU.ScD.result_matr_WA_MHWS);
PAU.ScD.result_mm_WA = [min(PAU.ScD.result_trans_WA),max(PAU.ScD.result_trans_WA)];
PAU.ScD.result_mean_WA = mean(PAU.ScD.result_trans_WA);

PAU.ScDV.result_matr_Hsig(PAU.ScDV.result_matr_Hsig<0) = NaN;
PAU.ScDV.result_matr_Hsig_MHWS(PAU.ScDV.result_matr_Hsig_MHWS<0) = NaN;
PAU.ScDV.result_matr_WA = (1-PAU.ScDV.result_matr_Hsig./0.2).*100;
PAU.ScDV.result_matr_WA_MHWS =...
    (PAU.ScDV.result_matr_Hsig_MLWS./0.2-PAU.ScDV.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScDV.result_matr_WA_MHWS(PAU.ScDV.result_matr_WA_MHWS==-9) = NaN;
PAU.ScDV.result_matr_WA_bar =...
    (PAU.ScDV.result_matr_Hsig_MLWS./0.2-PAU.ScDV.result_matr_Hsig_vegedge./0.2).*100;
PAU.ScDV.result_matr_WA_bar(PAU.ScDV.result_matr_WA_bar==-9) = NaN;
PAU.ScDV.result_matr_WA_veg =...
    (PAU.ScDV.result_matr_Hsig_vegedge./0.2-PAU.ScDV.result_matr_Hsig_MHWS./0.2).*100;
PAU.ScDV.result_matr_WA_veg(PAU.ScDV.result_matr_WA_veg==-9) = NaN;
PAU.ScDV.result_trans_WA = min(PAU.ScDV.result_matr_WA_MHWS);
PAU.ScDV.result_mm_WA = [min(PAU.ScDV.result_trans_WA),max(PAU.ScDV.result_trans_WA)];
PAU.ScDV.result_mean_WA = mean(PAU.ScDV.result_trans_WA);

%---Hellegatpolder--- #Transects=6 --- #Years=52 ---
HEL.ScN = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\normative_rough\Hellegatpolder_S250\Hellegatpolder_S250.mat')
HEL.ScD = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_noveg\Hellegatpolder_S250\Hellegatpolder_S250.mat');
HEL.ScDV = load('D:\Vaklodingen_Results\AllMarshes\Sim3\sim\production\daily_veg\Hellegatpolder_S250\Hellegatpolder_S250.mat');
HEL.input = load('M:\Documents\PhD\Scripts\MATLAB\Chapter1\mat_exports\Final\Hellegatpolder_S250.mat');

for i = 1:6
    HEL.result_length(i) = length(HEL.ScN.result(i).year(1).Hsig)*5;
    for j = 1:52
        HEL.ScN.result_matr_Hsig(j,i) = min(HEL.ScN.result(i).year(j).Hsig);
        if ~isempty(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1)
            HEL.ScN.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1);
        else
            HEL.ScN.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1))
            HEL.ScN.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1));
        else
            HEL.ScN.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1)
            HEL.ScN.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(find...
                (HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1);
        else
            HEL.ScN.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScN.result(i).year(j).Hsig(end);
        end
        
        HEL.ScD.result_matr_Hsig(j,i) = min(HEL.ScD.result(i).year(j).Hsig);
        if ~isempty(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1)
            HEL.ScD.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1);
        else
            HEL.ScD.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1))
            HEL.ScD.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1));
        else
            HEL.ScD.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1)
            HEL.ScD.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(find...
                (HEL.ScD.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1);
        else
            HEL.ScD.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScD.result(i).year(j).Hsig(end);
        end
        
        HEL.ScDV.result_matr_Hsig(j,i) = min(HEL.ScDV.result(i).year(j).Hsig);
        if ~isempty(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1)
            HEL.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.h_daily,1)-1);
        else
            HEL.ScDV.result_matr_Hsig_MHWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(end);
        end
        
        
        if ~isempty(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1))
            HEL.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS,1));
        else
            HEL.ScDV.result_matr_Hsig_MLWS(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(end);
        end
        
        if ~isempty(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1)
            HEL.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(find...
                (HEL.ScDV.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge,1)-1);
        else
            HEL.ScDV.result_matr_Hsig_vegedge(j,i) =...
                HEL.ScDV.result(i).year(j).Hsig(end);
        end
        HEL.result_veglength(j,i) = nansum(HEL.input.Hellegatpolder_S250.Veg{i}(j,:))*5;
        HEL.result_relveglength(j,i) = (HEL.result_veglength(j,i)/HEL.result_length(i)).*100;
        HEL.result_barelength(j,i) =...
            length(find(HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.MLWS &...
            HEL.ScN.result(i).year(j).Botlev>-HEL.input.Hellegatpolder_S250.veg_edge))*5;
    end
end

HEL.result_trans_relveglength = min(HEL.result_relveglength);
HEL.result_mm_trans_relveglength =...
    [min(HEL.result_trans_relveglength),max(HEL.result_trans_relveglength)];
HEL.result_mean_trans_relveglength =...
    mean(HEL.result_trans_relveglength);

HEL.ScN.result_matr_Hsig(HEL.ScN.result_matr_Hsig<0) = NaN;
HEL.ScN.result_matr_Hsig_MHWS(HEL.ScN.result_matr_Hsig_MHWS<0) = NaN;
HEL.ScN.result_matr_WA = (1-HEL.ScN.result_matr_Hsig./2.6500).*100;
HEL.ScN.result_matr_WA_MHWS =...
    (HEL.ScN.result_matr_Hsig_MLWS./2.6500-HEL.ScN.result_matr_Hsig_MHWS./2.6500).*100;
HEL.ScN.result_matr_WA_bar =...
    (HEL.ScN.result_matr_Hsig_MLWS./2.6500-HEL.ScN.result_matr_Hsig_vegedge./2.6500).*100;
HEL.ScN.result_matr_WA_veg =...
    (HEL.ScN.result_matr_Hsig_vegedge./2.6500-HEL.ScN.result_matr_Hsig_MHWS./2.6500).*100;
HEL.ScN.result_trans_WA = min(HEL.ScN.result_matr_WA_MHWS);
HEL.ScN.result_mm_WA = [min(HEL.ScN.result_trans_WA),max(HEL.ScN.result_trans_WA)];
HEL.ScN.result_mean_WA = mean(HEL.ScN.result_trans_WA);

HEL.ScD.result_matr_Hsig(HEL.ScD.result_matr_Hsig<0) = NaN;
HEL.ScD.result_matr_Hsig_MHWS(HEL.ScD.result_matr_Hsig_MHWS<0) = NaN;
HEL.ScD.result_matr_WA = (1-HEL.ScD.result_matr_Hsig./0.2).*100;
HEL.ScD.result_matr_WA_MHWS =...
    (HEL.ScD.result_matr_Hsig_MLWS./0.2-HEL.ScD.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScD.result_matr_WA_bar =...
    (HEL.ScD.result_matr_Hsig_MLWS./0.2-HEL.ScD.result_matr_Hsig_vegedge./0.2).*100;
HEL.ScD.result_matr_WA_veg =...
    (HEL.ScD.result_matr_Hsig_vegedge./0.2-HEL.ScD.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScD.result_trans_WA = min(HEL.ScD.result_matr_WA_MHWS);
HEL.ScD.result_mm_WA = [min(HEL.ScD.result_trans_WA),max(HEL.ScD.result_trans_WA)];
HEL.ScD.result_mean_WA = mean(HEL.ScD.result_trans_WA);

HEL.ScDV.result_matr_Hsig(HEL.ScDV.result_matr_Hsig<0) = NaN;
HEL.ScDV.result_matr_Hsig_MHWS(HEL.ScDV.result_matr_Hsig_MHWS<0) = NaN;
HEL.ScDV.result_matr_WA = (1-HEL.ScDV.result_matr_Hsig./0.2).*100;
HEL.ScDV.result_matr_WA_MHWS =...
    (HEL.ScDV.result_matr_Hsig_MLWS./0.2-HEL.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScDV.result_matr_WA_bar =...
    (HEL.ScDV.result_matr_Hsig_MLWS./0.2-HEL.ScDV.result_matr_Hsig_vegedge./0.2).*100;
HEL.ScDV.result_matr_WA_veg =...
    (HEL.ScDV.result_matr_Hsig_vegedge./0.2-HEL.ScDV.result_matr_Hsig_MHWS./0.2).*100;
HEL.ScDV.result_trans_WA = min(HEL.ScDV.result_matr_WA_MHWS);
HEL.ScDV.result_mm_WA = [min(HEL.ScDV.result_trans_WA),max(HEL.ScDV.result_trans_WA)];
HEL.ScDV.result_mean_WA = mean(HEL.ScDV.result_trans_WA);

ZUI.ScN.result_matr_WA(isnan(ZUI.ScN.result_matr_WA)) = 100;
BAA.ScN.result_matr_WA(isnan(BAA.ScN.result_matr_WA)) = 100;
ZIM.ScN.result_matr_WA(isnan(ZIM.ScN.result_matr_WA)) = 100;
HOO.ScN.result_matr_WA(isnan(HOO.ScN.result_matr_WA)) = 100;
PAU.ScN.result_matr_WA(isnan(PAU.ScN.result_matr_WA)) = 100;
HEL.ScN.result_matr_WA(isnan(HEL.ScN.result_matr_WA)) = 100;

%% Figure 4 Manuscript
name = 'MS_Fig4';
YLs = [1948,2017];
XLs = [0,3000];
n_bins = 101;
MS_FigXX5 = figure;
addpath('C:\Checkouts\OET\general\color_fun\colormaps\')
cmap_scatter = colormapbathymetry(150);
bf = 20;
hf = 20;
SP_PosW = 1.15;
SP_PosH = 1.1;

% ZUI --------------------------------------------------------------------
SP00001 = subplot(3,3,4);
for i = 1:9
    ZUI.input.Zuidgors_S250.Z_sel{1,i} = zeros(37,499)*NaN;
    for j = 1:37
        X1 = find(ZUI.input.Zuidgors_S250.Z{1,i}(j,:)<...
            ZUI.input.Zuidgors_S250.h_daily,1,'first');
        X2 = find(ZUI.input.Zuidgors_S250.Z{1,i}(j,:)<...
            ZUI.input.Zuidgors_S250.MLWS,1,'first')-1;
        if isempty(X2)==1
            X2 = find(isnan(ZUI.input.Zuidgors_S250.Z{1,i}(j,:)),1)-1;
        end
        ZUI.input.Zuidgors_S250.Z_sel{1,i}(j,1:X2-X1+1) =... 
            ZUI.input.Zuidgors_S250.Z{1,i}(j,X1:X2);
        ZUI.input.Zuidgors_S250.Z_norm{1,j}(i,:) = interp1([0:1:(X2-X1)],...
            ZUI.input.Zuidgors_S250.Z_sel{1,i}(j,1:X2-X1+1),...
            linspace(0,(X2-X1),100)); 
        ZUI.result_veglengthMHWS(j,i) =...
            length(find(ZUI.ScN.result(i).year(j).Botlev<-ZUI.input.Zuidgors_S250.veg_edge &...
            ZUI.ScN.result(i).year(j).Botlev>-ZUI.input.Zuidgors_S250.h_daily))*5;
    end
end
ZUI.result_lengthMLWS_MHWS = ZUI.result_veglengthMHWS + ZUI.result_barelength;
ZUI.result_lengthMLWS_MHWS_tempmean = mean(ZUI.result_lengthMLWS_MHWS,2);
for i = 1:37
     ZUI.input.Zuidgors_S250.Z_tempmean(i,:) =...
         mean(ZUI.input.Zuidgors_S250.Z_norm{i});
     ZUI.cmap(i,:) =...
         ceil((ZUI.input.Zuidgors_S250.Z_tempmean(i,:)+2.5)*(100/5.6));
     ZUI.input.Zuidgors_S250.Z_tempmeanX(i,:) =...
         linspace(0,ZUI.result_lengthMLWS_MHWS_tempmean(i),100);
    scatter(ZUI.input.Zuidgors_S250.Z_tempmeanX(i,:),...
        ones(1,100)*year(ZUI.input.Zuidgors_S250.T{1,1}(i,1)),...
        20,cmap_scatter(ZUI.cmap(i,:),:),'filled','s');
    hold on;
end

contour(ZUI.input.Zuidgors_S250.Z_tempmeanX,...
        ones(37,100).*year(ZUI.input.Zuidgors_S250.T{1,1}),...
        ZUI.input.Zuidgors_S250.Z_tempmean,...
        [ZUI.input.Zuidgors_S250.veg_edge ZUI.input.Zuidgors_S250.veg_edge],...
        'ShowText','off','linestyle','-','linecolor',[0,0,0],'linewidth',1);
plot(ZUI.input.Zuidgors_S250.Z_tempmeanX(:,100),...
        year(ZUI.input.Zuidgors_S250.T{1,1}),...
        'color',[0.5,0.5,0.5],'linewidth',1);
plot([0,0,0,0],[1950,1970,1990,2010],'+k','markersize',5)
plot([0,0],YLs,'-k');    
text(600,2010,'ZUI','color','r');
    
box off; grid on;
axis([0,1200,YLs]);
set(gca,'xtick',[0,400,800,1200],'ytick',[1950,1970,1990,2010],...
    'yticklabel',{'1950','1970','1990','2010'});
SP00001.Position(3) = SP00001.Position(3)*SP_PosW;
SP00001.Position(4) = SP00001.Position(4)*SP_PosH;

% BAA --------------------------------------------------------------------
SP00002 = subplot(3,3,5);

for i = 1:3
    BAA.input.Baarland_S250.Z_sel{1,i} = zeros(37,499)*NaN;
    for j = 1:37
        X1 = find(BAA.input.Baarland_S250.Z{1,i}(j,:)<...
            BAA.input.Baarland_S250.h_daily,1,'first');
        X2 = find(BAA.input.Baarland_S250.Z{1,i}(j,:)<...
            BAA.input.Baarland_S250.MLWS,1,'first')-1;
        if isempty(X2)==1
            X2 = find(isnan(BAA.input.Baarland_S250.Z{1,i}(j,:)),1)-1;
        end
        BAA.input.Baarland_S250.Z_sel{1,i}(j,1:X2-X1+1) =... 
            BAA.input.Baarland_S250.Z{1,i}(j,X1:X2);
        BAA.input.Baarland_S250.Z_norm{1,j}(i,:) = interp1([0:1:(X2-X1)],...
            BAA.input.Baarland_S250.Z_sel{1,i}(j,1:X2-X1+1),...
            linspace(0,(X2-X1),100)); 
        BAA.result_veglengthMHWS(j,i) =...
            length(find(BAA.ScN.result(i).year(j).Botlev<-BAA.input.Baarland_S250.veg_edge &...
            BAA.ScN.result(i).year(j).Botlev>-BAA.input.Baarland_S250.h_daily))*5;
    end
end
BAA.result_lengthMLWS_MHWS = BAA.result_veglengthMHWS + BAA.result_barelength;
BAA.result_lengthMLWS_MHWS_tempmean = mean(BAA.result_lengthMLWS_MHWS,2);
for i = 1:37
     BAA.input.Baarland_S250.Z_tempmean(i,:) =...
         mean(BAA.input.Baarland_S250.Z_norm{i});
     BAA.cmap(i,:) =...
         ceil((BAA.input.Baarland_S250.Z_tempmean(i,:)+2.5)*(100/5.6));
     BAA.input.Baarland_S250.Z_tempmeanX(i,:) =...
         linspace(0,BAA.result_lengthMLWS_MHWS_tempmean(i),100);
    scatter(BAA.input.Baarland_S250.Z_tempmeanX(i,:),...
        ones(1,100)*year(BAA.input.Baarland_S250.T{1,1}(i,1)),...
        20,cmap_scatter(BAA.cmap(i,:),:),'filled','s');
    hold on;
end

contour(BAA.input.Baarland_S250.Z_tempmeanX,...
        ones(37,100).*year(BAA.input.Baarland_S250.T{1,1}),...
        BAA.input.Baarland_S250.Z_tempmean,...
        [BAA.input.Baarland_S250.veg_edge BAA.input.Baarland_S250.veg_edge],...
        'ShowText','off','linestyle','-','linecolor',[0,0,0],'linewidth',1);
plot(BAA.input.Baarland_S250.Z_tempmeanX(:,100),...
        year(BAA.input.Baarland_S250.T{1,1}),...
        'color',[0.5,0.5,0.5],'linewidth',1);
plot([0,0,0,0],[1950,1970,1990,2010],'+k','markersize',5)
plot([0,0],YLs,'-k');
text(1500,2010,'BAA','color','r');

box off; grid on;
axis([XLs,YLs]);
set(gca,'xtick',[0,1000,2000,3000],...
    'yticklabel',[]);
SP00002.Position(3) = SP00002.Position(3)*SP_PosW;
SP00002.Position(4) = SP00002.Position(4)*SP_PosH;

% ZIM --------------------------------------------------------------------
SP00003 = subplot(3,3,6);
for i = 1:5
    ZIM.input.Zimmermanpolder_S250.Z_sel{1,i} = zeros(37,499)*NaN;
    for j = 1:51
        X1 = find(ZIM.input.Zimmermanpolder_S250.Z{1,i}(j,:)<...
            ZIM.input.Zimmermanpolder_S250.h_daily,1,'first');
        X2 = find(ZIM.input.Zimmermanpolder_S250.Z{1,i}(j,:)<...
            ZIM.input.Zimmermanpolder_S250.MLWS,1,'first')-1;
        if isempty(X2)==1
            X2 = find(isnan(ZIM.input.Zimmermanpolder_S250.Z{1,i}(j,:)),1)-1;
        end
        ZIM.input.Zimmermanpolder_S250.Z_sel{1,i}(j,1:X2-X1+1) =... 
            ZIM.input.Zimmermanpolder_S250.Z{1,i}(j,X1:X2);
        ZIM.input.Zimmermanpolder_S250.Z_norm{1,j}(i,:) = interp1([0:1:(X2-X1)],...
            ZIM.input.Zimmermanpolder_S250.Z_sel{1,i}(j,1:X2-X1+1),...
            linspace(0,(X2-X1),100)); 
        ZIM.result_veglengthMHWS(j,i) =...
            length(find(ZIM.ScN.result(i).year(j).Botlev<-ZIM.input.Zimmermanpolder_S250.veg_edge &...
            ZIM.ScN.result(i).year(j).Botlev>-ZIM.input.Zimmermanpolder_S250.h_daily))*5;
    end
end
ZIM.result_lengthMLWS_MHWS = ZIM.result_veglengthMHWS + ZIM.result_barelength;
ZIM.result_lengthMLWS_MHWS_tempmean = mean(ZIM.result_lengthMLWS_MHWS,2);
for i = 1:51
     ZIM.input.Zimmermanpolder_S250.Z_tempmean(i,:) =...
         mean(ZIM.input.Zimmermanpolder_S250.Z_norm{i});
     ZIM.cmap(i,:) =...
         ceil((ZIM.input.Zimmermanpolder_S250.Z_tempmean(i,:)+2.5)*(100/5.6));
     ZIM.input.Zimmermanpolder_S250.Z_tempmeanX(i,:) =...
         linspace(0,ZIM.result_lengthMLWS_MHWS_tempmean(i),100);
    scatter(ZIM.input.Zimmermanpolder_S250.Z_tempmeanX(i,:),...
        ones(1,100)*year(ZIM.input.Zimmermanpolder_S250.T{1,1}(i,1)),...
        20,cmap_scatter(ZIM.cmap(i,:),:),'filled','s');
    hold on;
end

contour(ZIM.input.Zimmermanpolder_S250.Z_tempmeanX,...
        ones(51,100).*year(ZIM.input.Zimmermanpolder_S250.T{1,1}),...
        ZIM.input.Zimmermanpolder_S250.Z_tempmean,...
        [ZIM.input.Zimmermanpolder_S250.veg_edge ZIM.input.Zimmermanpolder_S250.veg_edge],...
        'ShowText','off','linestyle','-','linecolor',[0,0,0],'linewidth',1);
plot(ZIM.input.Zimmermanpolder_S250.Z_tempmeanX(:,100),...
        year(ZIM.input.Zimmermanpolder_S250.T{1,1}),...
        'color',[0.5,0.5,0.5],'linewidth',1);
plot([0,0,0,0],[1950,1970,1990,2010],'+k','markersize',5)
plot([0,0],YLs,'-k');
text(900,2010,'ZIM','color','r');

box off; grid on;
axis([0,1800,YLs]);
set(gca,'xtick',[0,600,1200,1800],...
    'yticklabel',[]);
SP00003.Position(3) = SP00003.Position(3)*SP_PosW;
SP00003.Position(4) = SP00003.Position(4)*SP_PosH;

% HOO --------------------------------------------------------------------
SP00004 = subplot(3,3,7);
for i = 1:6
    HOO.input.Hoofdplaat_S250.Z_sel{1,i} = zeros(37,499)*NaN;
    for j = 1:42
        X1 = find(HOO.input.Hoofdplaat_S250.Z{1,i}(j,:)<...
            HOO.input.Hoofdplaat_S250.h_daily,1,'first');
        X2 = find(HOO.input.Hoofdplaat_S250.Z{1,i}(j,:)<...
            HOO.input.Hoofdplaat_S250.MLWS,1,'first')-1;
        if isempty(X2)==1
            X2 = find(isnan(HOO.input.Hoofdplaat_S250.Z{1,i}(j,:)),1)-1;
        end
        HOO.input.Hoofdplaat_S250.Z_sel{1,i}(j,1:X2-X1+1) =... 
            HOO.input.Hoofdplaat_S250.Z{1,i}(j,X1:X2);
        HOO.input.Hoofdplaat_S250.Z_norm{1,j}(i,:) = interp1([0:1:(X2-X1)],...
            HOO.input.Hoofdplaat_S250.Z_sel{1,i}(j,1:X2-X1+1),...
            linspace(0,(X2-X1),100)); 
        HOO.result_veglengthMHWS(j,i) =...
            length(find(HOO.ScN.result(i).year(j).Botlev<-HOO.input.Hoofdplaat_S250.veg_edge &...
            HOO.ScN.result(i).year(j).Botlev>-HOO.input.Hoofdplaat_S250.h_daily))*5;
    end
end
HOO.result_lengthMLWS_MHWS = HOO.result_veglengthMHWS + HOO.result_barelength;
HOO.result_lengthMLWS_MHWS_tempmean = mean(HOO.result_lengthMLWS_MHWS,2);
for i = 1:42
     HOO.input.Hoofdplaat_S250.Z_tempmean(i,:) =...
         mean(HOO.input.Hoofdplaat_S250.Z_norm{i});
     HOO.cmap(i,:) =...
         ceil((HOO.input.Hoofdplaat_S250.Z_tempmean(i,:)+2.5)*(100/5.6));
     HOO.input.Hoofdplaat_S250.Z_tempmeanX(i,:) =...
         linspace(0,HOO.result_lengthMLWS_MHWS_tempmean(i),100);
    scatter(HOO.input.Hoofdplaat_S250.Z_tempmeanX(i,:),...
        ones(1,100)*year(HOO.input.Hoofdplaat_S250.T{1,1}(i,1)),...
        20,cmap_scatter(HOO.cmap(i,:),:),'filled','s');
    hold on;
end

contour(HOO.input.Hoofdplaat_S250.Z_tempmeanX,...
        ones(42,100).*year(HOO.input.Hoofdplaat_S250.T{1,1}),...
        HOO.input.Hoofdplaat_S250.Z_tempmean,...
        [HOO.input.Hoofdplaat_S250.veg_edge HOO.input.Hoofdplaat_S250.veg_edge],...
        'ShowText','off','linestyle','-','linecolor',[0,0,0],'linewidth',1);
plot(HOO.input.Hoofdplaat_S250.Z_tempmeanX(:,100),...
        year(HOO.input.Hoofdplaat_S250.T{1,1}),...
        'color',[0.5,0.5,0.5],'linewidth',1);
plot([0,0,0,0],[1950,1970,1990,2010],'+k','markersize',5)
plot([0,0],YLs,'-k');
text(225,2010,'HOO');

ylabel('                            time (year)');
box off; grid on;
axis([0,450,YLs]);
set(gca,'xtick',[0,150,300,450],'ytick',[1950,1970,1990,2010],...
    'yticklabel',{'1950','1970','1990','2010'});
SP00004.Position(3) = SP00004.Position(3)*SP_PosW;
SP00004.Position(4) = SP00004.Position(4)*SP_PosH;

% PAU --------------------------------------------------------------------
SP00005 = subplot(3,3,8);
for i = 1:7
    PAU.input.Paulinapolder_S250.Z_sel{1,i} = zeros(37,499)*NaN;
    for j = 1:41
        X1 = find(PAU.input.Paulinapolder_S250.Z{1,i}(j,:)<...
            PAU.input.Paulinapolder_S250.h_daily,1,'first');
        X2 = find(PAU.input.Paulinapolder_S250.Z{1,i}(j,:)<...
            PAU.input.Paulinapolder_S250.MLWS,1,'first')-1;
        if isempty(X2)==1
            X2 = find(isnan(PAU.input.Paulinapolder_S250.Z{1,i}(j,:)),1)-1;
        end
        PAU.input.Paulinapolder_S250.Z_sel{1,i}(j,1:X2-X1+1) =... 
            PAU.input.Paulinapolder_S250.Z{1,i}(j,X1:X2);
        PAU.input.Paulinapolder_S250.Z_norm{1,j}(i,:) = interp1([0:1:(X2-X1)],...
            PAU.input.Paulinapolder_S250.Z_sel{1,i}(j,1:X2-X1+1),...
            linspace(0,(X2-X1),100)); 
        PAU.result_veglengthMHWS(j,i) =...
            length(find(PAU.ScN.result(i).year(j).Botlev<-PAU.input.Paulinapolder_S250.veg_edge &...
            PAU.ScN.result(i).year(j).Botlev>-PAU.input.Paulinapolder_S250.h_daily))*5;
    end
end
PAU.result_lengthMLWS_MHWS = PAU.result_veglengthMHWS + PAU.result_barelength;
PAU.result_lengthMLWS_MHWS_tempmean = mean(PAU.result_lengthMLWS_MHWS,2);
for i = 1:41
     PAU.input.Paulinapolder_S250.Z_tempmean(i,:) =...
         mean(PAU.input.Paulinapolder_S250.Z_norm{i});
     PAU.cmap(i,:) =...
         ceil((PAU.input.Paulinapolder_S250.Z_tempmean(i,:)+2.5)*(100/5.6));
     PAU.input.Paulinapolder_S250.Z_tempmeanX(i,:) =...
         linspace(0,PAU.result_lengthMLWS_MHWS_tempmean(i),100);
    scatter(PAU.input.Paulinapolder_S250.Z_tempmeanX(i,:),...
        ones(1,100)*year(PAU.input.Paulinapolder_S250.T{1,1}(i,1)),...
        20,cmap_scatter(PAU.cmap(i,:),:),'filled','s');
    hold on;
end

contour(PAU.input.Paulinapolder_S250.Z_tempmeanX,...
        ones(41,100).*year(PAU.input.Paulinapolder_S250.T{1,1}),...
        PAU.input.Paulinapolder_S250.Z_tempmean,...
        [PAU.input.Paulinapolder_S250.veg_edge PAU.input.Paulinapolder_S250.veg_edge],...
        'ShowText','off','linestyle','-','linecolor',[0,0,0],'linewidth',1);
plot(PAU.input.Paulinapolder_S250.Z_tempmeanX(:,100),...
        year(PAU.input.Paulinapolder_S250.T{1,1}),...
        'color',[0.5,0.5,0.5],'linewidth',1);
plot([0,0,0,0],[1950,1970,1990,2010],'+k','markersize',5)
plot([0,0],YLs,'-k');
text(450,2010,'PAU');

xlabel('width of foreshore (part) (m)')
box off; grid on;
axis([0,900,YLs]);
set(gca,'xtick',[0,300,600,900],'ytick',[1950,1970,1990,2010],...
    'yticklabel',[]);
SP00005.Position(3) = SP00005.Position(3)*SP_PosW;
SP00005.Position(4) = SP00005.Position(4)*SP_PosH;

% HEL --------------------------------------------------------------------
SP00006 = subplot(3,3,9);
for i = 1:6
    HEL.input.Hellegatpolder_S250.Z_sel{1,i} = zeros(37,499)*NaN;
    for j = 1:52
        X1 = find(HEL.input.Hellegatpolder_S250.Z{1,i}(j,:)<...
            HEL.input.Hellegatpolder_S250.h_daily,1,'first');
        X2 = find(HEL.input.Hellegatpolder_S250.Z{1,i}(j,:)<...
            HEL.input.Hellegatpolder_S250.MLWS,1,'first')-1;
        if isempty(X2)==1
            X2 = find(isnan(HEL.input.Hellegatpolder_S250.Z{1,i}(j,:)),1)-1;
        end
        HEL.input.Hellegatpolder_S250.Z_sel{1,i}(j,1:X2-X1+1) =... 
            HEL.input.Hellegatpolder_S250.Z{1,i}(j,X1:X2);
        HEL.input.Hellegatpolder_S250.Z_norm{1,j}(i,:) = interp1([0:1:(X2-X1)],...
            HEL.input.Hellegatpolder_S250.Z_sel{1,i}(j,1:X2-X1+1),...
            linspace(0,(X2-X1),100)); 
        HEL.result_veglengthMHWS(j,i) =...
            length(find(HEL.ScN.result(i).year(j).Botlev<-HEL.input.Hellegatpolder_S250.veg_edge &...
            HEL.ScN.result(i).year(j).Botlev>-HEL.input.Hellegatpolder_S250.h_daily))*5;
    end
end
HEL.result_lengthMLWS_MHWS = HEL.result_veglengthMHWS + HEL.result_barelength;
HEL.result_lengthMLWS_MHWS_tempmean = mean(HEL.result_lengthMLWS_MHWS,2);
for i = 1:52
     HEL.input.Hellegatpolder_S250.Z_tempmean(i,:) =...
         mean(HEL.input.Hellegatpolder_S250.Z_norm{i});
     HEL.cmap(i,:) =...
         ceil((HEL.input.Hellegatpolder_S250.Z_tempmean(i,:)+2.5)*(100/5.6));
     HEL.input.Hellegatpolder_S250.Z_tempmeanX(i,:) =...
         linspace(0,HEL.result_lengthMLWS_MHWS_tempmean(i),100);
    scatter(HEL.input.Hellegatpolder_S250.Z_tempmeanX(i,:),...
        ones(1,100)*year(HEL.input.Hellegatpolder_S250.T{1,1}(i,1)),...
        20,cmap_scatter(HEL.cmap(i,:),:),'filled','s');
    hold on;
end

contour(HEL.input.Hellegatpolder_S250.Z_tempmeanX,...
        ones(52,100).*year(HEL.input.Hellegatpolder_S250.T{1,1}),...
        HEL.input.Hellegatpolder_S250.Z_tempmean,...
        [HEL.input.Hellegatpolder_S250.veg_edge HEL.input.Hellegatpolder_S250.veg_edge],...
        'ShowText','off','linestyle','-','linecolor',[0,0,0],'linewidth',1);
plot(HEL.input.Hellegatpolder_S250.Z_tempmeanX(:,100),...
        year(HEL.input.Hellegatpolder_S250.T{1,1}),...
        'color',[0.5,0.5,0.5],'linewidth',1);
plot([0,0,0,0],[1950,1970,1990,2010],'+k','markersize',5)
plot([0,0],YLs,'-k');
text(450,2010,'HEL');

box off; grid on;
axis([0,900,YLs]);
set(gca,'xtick',[0,300,600,900],'ytick',[1950,1970,1990,2010],...
    'yticklabel',[]);
SP00006.Position(3) = SP00006.Position(3)*SP_PosW;
SP00006.Position(4) = SP00006.Position(4)*SP_PosH;

% Explanation profile --------------------------------------------------------------------
SP00007 = subplot(3,3,3);
profile_patch = bar(ZIM.input.Zimmermanpolder_S250.Z_tempmeanX(end,:),...
        ZIM.input.Zimmermanpolder_S250.Z_tempmean(end,:)+4,1,...
        'edgecolor','none','showbaseline','off');
profile_patch.FaceColor = 'flat';
profile_patch.CData = cmap_scatter(ZIM.cmap(end,:),:);
hold on;
plot([ZIM.input.Zimmermanpolder_S250.Z_tempmeanX(end,16),...
    ZIM.input.Zimmermanpolder_S250.Z_tempmeanX(end,16)],...
    [0.5,6.8],'-','color',[0,0,0],'linewidth',1);
plot([ZIM.input.Zimmermanpolder_S250.Z_tempmeanX(end,100),...
    ZIM.input.Zimmermanpolder_S250.Z_tempmeanX(end,100)],...
        [0.5,2.9],'color',[0.5,0.5,0.5],'linewidth',1);
text(ZIM.input.Zimmermanpolder_S250.Z_tempmeanX(end,16),7,'marsh edge')
text(ZIM.input.Zimmermanpolder_S250.Z_tempmeanX(end,100),3,'MLWS')

ylabel({'elevation','ZIM 2015 (m)'});
box off; grid on;
axis([0,1800,-3.5+4,3.5+4]);
set(gca,'xtick',[0,500,1000,1500],'ytick',[2,4,6],'yticklabel',{'-2','0','2'},...
    'xticklabel',[],'xcolor','none');
SP00007.Position(2) = SP00007.Position(2)-0.05;
SP00007.Position(3) = SP00007.Position(3)*SP_PosW;
SP00007.Position(4) = SP00007.Position(4)*SP_PosH;

% Legend --------------------------------------------------------------------
SP00008 = subplot(3,3,1:2)
colormap(cmap_scatter(1:100,:));
CB_tickvec = ([-2,-1,0,1,2,3]+2.5)./5.6;
CB = colorbar('southoutside','Ticks',CB_tickvec,...
    'TickLabels',{'-2','-1','0','1','2','3'},'FontSize',10);
CB.Label.String = 'elevation (m)';
set(CB.Label,'position',[0.5,3,0],'FontSize',10)
CB.Position(2) = CB.Position(2)-0.05;
CB.Position(3) = CB.Position(3)*0.7;
CB.Position(4) = CB.Position(4)*1.5;

axis off

figuurdimensies(bf,hf)
cd M:\Documents\PhD\Scripts\MATLAB\Chapter1\altmany-export_fig-412662f
% export_fig MS_Fig4 -deps -r864 -transparent -p1

