from DefAnalysisLib import *
import newstyle_DefectDetectionAnalysis
from itertools import chain
import numpy as np
from ast import literal_eval
from timeit import default_timer as timer
import pickle
import os

"""
This script is meant to automate the optimization the settings of image preprocessing and
the detection algorithms. May become a script that only returns generated instances of class Utils.cfg
as specified in the instructions.ini file in a future version.
"""

# reports = []
# #read in base config and generate Utils.cfg() instance
#base_cfg = Utils.cfg()

# #choose the algorithms on which to optimise the settings
#base_cfgs = base_cfg.load()
# all_cfgs = base_cfgs

# #change the settings of the PreProcessing
#     #changed settings include:

# all_cfgs = base_cfg.vary_range(base_cfgs, 'num_dilatations', 4, 12, 2)
# all_cfgs = base_cfg.vary_range(all_cfgs, 'clahe_clip_limit', 2, 26, 6)
# all_cfgs = base_cfg.vary_range(all_cfgs, 'num_iter_1', 6, 12, 2)
# all_cfgs = base_cfg.vary_range(all_cfgs, 'num_iter_2', 6, 12, 2)
# all_cfgs = base_cfg.vary_kernel(all_cfgs, 'clahe_tile_size', 5, 25, 4, square = True)

# # all_cfgs = base_cfg.vary_kernel(all_cfgs, 'kernel_2', 3, 9)
# # all_cfgs = base_cfg.vary_kernel(all_cfgs, 'kernel_1', 3, 9)

# debug = []

# temp = []

# #optimize preprocessing
# for i, cfg in enumerate(all_cfgs):
#     print(i)
#     images, labeledImg, allDefects, preProcImgs = newstyle_DefectDetectionAnalysis.preparation(cfg)

#     reports.append(newstyle_DefectDetectionAnalysis.defect_detection(cfg, allDefects, images, labeledImg, preProcImgs))

#     if len(reports) > 10: #keep RAM from filling up with images

#         reports = newstyle_DefectDetectionAnalysis.find_best(reports, 'topAlgorithms')
#         reports = list(reports.values())


# #find the respective best PreProcessing-settings
# best_algorithms = newstyle_DefectDetectionAnalysis.find_best(reports, 'topAlgorithms')

# # #best_algorithms =  pickle.load( open( "best_algorithms.p", "rb" ) )


# def generate_algo_cfgs(best_algo_dict):
#     """
#     Function reads in instructions from the instructions.ini file. Format of an instruction is:
#     [algorithm name]
#     range or kernel (list) = [ [algorithm name, setting #1, (start, end, step)],
#                              [algorithm name, setting #2, (start, end, step)],
#                              (...)
#                              ]
#     Caution, the algorithm name has to be the algorithm functions name, this function will not throw an error
#     if this condition is not met.

#     @param (dict) best_algo_dict: contains which algorithm cfgs to generate
#     @return (list) cfgs: list of all cfgs with the algorithms settings changed

#     """
#     all_instructions = ConfigHandler.configHandler('instructions.ini', 'r')

#     cfgs = {}

#     for algo_name, defdet in list(best_algo_dict.items()):


#         if algo_name not in list(cfgs.keys()):
#             cfgs[algo_name] = []


#         try:
#             algo_instruction_types = list(all_instructions[algo_name].keys()) #algorithm specific instructions

#         except:
#             try:
#                 algo_instruction_types = list(all_instructions[algo_name[5:]].keys())
#             except:
#                 print("No instructions could be found for {}.".format(algo_name))

#         cfg = defdet.cfg

#         for instruction_type in algo_instruction_types:
#             try:
#                 instructions = literal_eval(all_instructions[algo_name][instruction_type])
#             except:
#                 instructions = literal_eval(all_instructions[algo_name[5:]][instruction_type])
#             for instruction in instructions:

#                 if instruction_type == "range" and instruction != None:
#                     cfgs[algo_name] = cfgs[algo_name] + cfg.vary_range( cfgs[algo_name], instruction, "parser")

#                 elif instruction_type == "kernel" and instruction != None:

#                     cfgs[algo_name] = cfgs[algo_name] + cfg.vary_kernel( cfgs[algo_name], instruction, "parser")

#                 elif instruction == None:
#                     cfgs[algo_name] = cfgs[algo_name] + [cfg]
#     return cfgs

# test = {}
# test['gaborFilterSegmentation'] = best_algorithms['gaborFilterSegmentation']

##generate configs with algorithm specific settings
# new_cfgs = generate_algo_cfgs(best_algorithms)


# algorithm_reports = {} #dictionary to hold all reports sorted by algorithm
# debug  = 0

##

# for defdet in list(best_algorithms.values()):
#     algorithm_name = defdet.cfg.algo_name

#     if algorithm_name not in list(algorithm_reports.keys()):
#         algorithm_reports[algorithm_name] = []
#         images, labeledImg, allDefects, preProcImgs = defdet.return_input()
#         print('check if in list', algorithm_name)
#         algo_cfgs = []
#     else:
#         pass

#     #test algorithm specific


#     for cfg in new_cfgs[algorithm_name]:

#         algorithm_reports[algorithm_name].append(newstyle_DefectDetectionAnalysis.defect_detection(cfg, allDefects, images, labeledImg, preProcImgs))

#         if len(algorithm_reports[algorithm_name]) > 10: #keep RAM from filling up with images

#             temp = newstyle_DefectDetectionAnalysis.find_best(algorithm_reports[algorithm_name], 'topAlgorithms')
#             del algorithm_reports[algorithm_name]
#             algorithm_reports[algorithm_name] = list(temp.values())
#             print('cleared memory: {}'.format(debug))
#         print('iteration: {}'.format(debug))

#         debug +=1

# reports = list(algorithm_reports.values())
# reports = list(chain(*reports))

# top = newstyle_DefectDetectionAnalysis.find_best(reports, 'topAlgorithms')
# best_overall = newstyle_DefectDetectionAnalysis.find_best(reports, 'singleBest')

path = os.path.join(os.getcwd(), 'Assesment Results')
path = os.path.join(path, 'a VOM SIM RECHNER')
path = os.path.join(path, 'TwistUndWrinkle_Alle_Algo_opt_preProcess')


with open(os.path.join(path, 'top.p'), 'rb') as f:
    top = pickle.load(f)

top_two = [top['grid cellStdThresholding'], top['cellStdThresholding'], top['grid adaptiveThresholding'], top['adaptiveThresholding']]
#path = best_overall['Best'].cfg.save(mode = 'topLevel')

# for defdet in best_algorithms.values():
#     defdet.cfg.save(mode = 'lowLevel')

img_text, all_plots, names, newreport, comparison, f, general_means, general_stds = report(list(top.values()), path)

#plot charts and save means + standard deviation in .csv file
Visualisation.plot_radar_charts(general_means, f.cmp)
Visualisation.readable_barchart(general_means, general_stds, f.cmp)
Visualisation.save_means(general_stds, general_means, f.cmp)
Visualisation.draw_barchart(top_two, f.cmp, "top_two_barchart")

# with open(path, 'wb') as f:
#     pickle.dump(top, f)
