[X, Xt]=xlsread('qualtrics_responses.xlsx','A3:AIU777'); %#ok<XLSRD>
%% 
RO=NaN(size(X,1),150,3); % Initialize matrix of participants x 150 trials x 3 variables
V=33:6:931; % columns where comparisons can be found

for i=1:length(V) % loop over 150 trials
    for i2=1:size(Xt,1) % loop over observers
        st=char(Xt(i2,V(i)));
        del=strfind(st,'|');
        RO(i2,i,1)=str2double(st(1:del-1)); % left image number
        RO(i2,i,2)=str2double(st(del+1:end)); % right image number
        RO(i2,i,3)=X(i2,V(i)-3); % selected image by respondents
    end
end
RO(isnan(RO(:,150,1)),:,:)=[]; % delete participants who yielded NaNs
%% Create 96 x 96 matrix with comparison counts
MM=zeros(96,96);
for i=1:size(RO,1) % loop over observers
    v1=squeeze(RO(i,:,1))';
    v2=squeeze(RO(i,:,2))';
    v3=squeeze(RO(i,:,3))';
    for i2=1:length(v1)
        if v3(i2)==v1(i2) % if left image was selected
            MM(v1(i2),v2(i2))=MM(v1(i2),v2(i2))+1; % add increment to MM matrix
        elseif v3(i2)==v2(i2) % if right image was selected
            MM(v2(i2),v1(i2))=MM(v2(i2),v1(i2))+1; % add increment to MM matrix
        end
    end
end
%% compute complexity score
complexity=pw_scale(MM);
